<?php
$rating_counts = ahura_get_product_rating_counts($product);
$rating_percentage = ahura_get_product_rating_percentage($product);

$wp_comment_form = new \ahura\app\WP_Comment_Form_Handler('woocommerce_product_review_comment_form_args');

$rules_title = \ahura\app\mw_options::get_mod_product_review_rules_title();
$rules_text = \ahura\app\mw_options::get_mod_product_review_rules_text();
?>
<div id="reviews" class="woocommerce-Reviews comments-template-<?php echo $mode ?>">
    <div id="comments">
        <div class="row">
            <div class="col-12 col-md-9 product-comments-wrap">
                <div class="comments-head">
                    <h5><?php _e('User Reviews', 'ahura') ?></h5>
                    <a href="#commentform" rel="nofollow noopener">
                        <i class="fas fa-comments"></i>
                        <?php _e('Insert new Comment', 'ahura') ?>
                    </a>
                </div>
                <div class="comments-list-wrap">
                    <?php if (have_comments()) : ?>
                        <div class="cb_comment_list">
                            <ol class="commentlist">
                                <?php wp_list_comments(apply_filters('woocommerce_product_review_list_args', array('callback' => 'woocommerce_comments'))); ?>
                            </ol>
                        </div>
                        <?php $wp_comment_form->render_pagination(); ?>
                    <?php else : ?>
                        <?php wc_print_notice(__('There are no reviews yet.', 'ahura'), 'notice') ?>
                    <?php endif; ?>
                </div>
                <div class="new-comment-form">
                    <?php if (get_option('woocommerce_review_rating_verification_required') === 'no' || wc_customer_bought_product('', get_current_user_id(), $product->get_id())) : ?>
                    <?php if (\ahura\app\mw_options::get_mod_product_review_rules_status()): ?>
                        <div class="comments-note">
                            <div class="note-title">
                                <?php
                                if (!empty($rules_title)){
                                    echo $rules_title;
                                } else {
                                    _e('Please read the summary of the following rules before posting a comment:', 'ahura');
                                }
                                ?>
                            </div>
                            <ul>
                                <?php if (!empty($rules_text)): ?>
                                    <?php foreach (explode("\n", $rules_text) as $rule): ?>
                                        <li><?php echo $rule ?></li>
                                    <?php endforeach; ?>
                                <?php else: ?>
                                <li><?php _e('Write Persian and use Persian keyboard. It is better not to use more space than usual, emoticons or emojis and avoid drawing letters or words with the keyboard.', 'ahura') ?></li>
                                <li><?php _e('Submit your comments based on experience and practical use and carefully to the technical points; Recite the pros and cons without prejudice to a specific product and it is better to avoid posting multi-word comments.', 'ahura') ?></li>
                                <li><?php _e('It is better to avoid focusing on variable elements such as price in your comments.', 'ahura') ?></li>
                                <li><?php _e('Respect users and other people. Messages that contain offensive content and inappropriate words will be deleted.', 'ahura') ?></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    <?php endif; ?>
                    <div id="review_form_wrapper">
                        <div id="review_form">
                            <?php
                            $commenter = wp_get_current_commenter();

                            $wp_comment_form->set_param('title_reply', null);
                            $wp_comment_form->set_param('title_reply_to', __('Leave a Reply to %s', 'ahura'));
                            $wp_comment_form->set_param('title_reply_before', '<span id="reply-title" class="comment-reply-title">');
                            $wp_comment_form->set_param('title_reply_after', '</span>');
                            $wp_comment_form->set_param('comment_notes_before', null);
                            $wp_comment_form->set_param('comment_notes_after', null);
                            $wp_comment_form->set_param('fields', array(
                                'author' => '<div class="comment-field-group"><div class="form-field ah-comment-form-author">' . '<label for="author">' . __('Your Name', 'ahura') . '</label><input id="author" name="author" placeholder="' . __('Enter your name', 'ahura') . '" class="form-control" type="text" value="' . esc_attr($commenter['comment_author']) . '" aria-required="true" required /></div>',
                                'email' => '<div class="form-field ah-comment-form-email">' . '<label for="email">' . __('Your Email', 'ahura') . '</label><input id="email" class="form-control" placeholder="' . __('Enter your email', 'ahura') . '" name="email" type="email" value="' . esc_attr($commenter['comment_author_email']) . '" aria-required="true" required /></div></div>',
                            ));
                            $wp_comment_form->set_param('label_submit', __('Submit Comment', 'ahura'));
                            $wp_comment_form->set_param('logged_in_as', null);
                            $wp_comment_form->set_param('comment_field', null);
                            $wp_comment_form->set_param('class_submit', 'comment-submit-btn');

                            if ($account_page_url = wc_get_page_permalink('must_log_in')):
                                $wp_comment_form->start_section('must_log_in');
                                wc_print_notice(sprintf(__('You must be %s to post a review.', 'ahura'), sprintf('<a href="%s">'. __('logged in', 'ahura') .'</a>', esc_url($account_page_url))), 'error');
                                $wp_comment_form->end_section();
                            endif;

                            $wp_comment_form->set_field('<div class="form-field comment-form-comment mt-4"><label for="comment">' . __('Comment Text', 'ahura') . '</label><textarea id="comment" name="comment" aria-required="true" required></textarea></div>');
                            ?>
                            <?php if (get_option('woocommerce_enable_review_rating') === 'yes'): ?>
                                <?php $wp_comment_form->start_section('star_rating')->is_field(); ?>
                                <div class="ah-comment-form-rating">
                                    <select name="rating" aria-required="true" style="display:none" required>
                                        <option value=""><?php echo esc_html__('Rate&hellip;', 'woocommerce') ?></option>
                                        <option value="5" selected><?php echo esc_html__('Perfect', 'woocommerce') ?></option>
                                        <option value="4"><?php echo esc_html__('Good', 'woocommerce') ?></option>
                                        <option value="3"><?php echo esc_html__('Average', 'woocommerce') ?></option>
                                        <option value="2"><?php echo esc_html__('Not that bad', 'woocommerce') ?></option>
                                        <option value="1"><?php echo esc_html__('Very poor', 'woocommerce') ?></option>
                                    </select>
                                </div>
                                <div class="form-field">
                                    <label><?php _e('Your rate', 'ahura') ?></label>
                                    <div class="comment-rate-buttons">
                                        <a href="#" rel="nofollow noopener" data-star="5">
                                            <i class="far fa-star"></i>
                                            <?php echo esc_html__('Perfect', 'ahura') ?>
                                        </a>
                                        <a href="#" rel="nofollow noopener" data-star="4">
                                            <i class="far fa-star"></i>
                                            <?php echo esc_html__('Good', 'ahura') ?>
                                        </a>
                                        <a href="#" rel="nofollow noopener" data-star="3">
                                            <i class="far fa-star"></i>
                                            <?php echo esc_html__('Not Bad', 'ahura') ?>
                                        </a>
                                        <a href="#" rel="nofollow noopener" data-star="2">
                                            <i class="far fa-star"></i>
                                            <?php echo esc_html__('Bad', 'ahura') ?>
                                        </a>
                                        <a href="#" rel="nofollow noopener" data-star="1">
                                            <i class="far fa-star"></i>
                                            <?php echo esc_html__('Very poor', 'ahura') ?>
                                        </a>
                                    </div>
                                </div>
                                <?php $wp_comment_form->end_section(); ?>
                            <?php endif; ?>
                            <?php if (\ahura\app\mw_options::get_mod_product_review_strength_weak_points_status()): ?>
                                <?php $wp_comment_form->start_section('comment_rate_list')->is_field(); ?>
                                    <div class="comment-rate-list comment-field-group">
                                        <div class="form-field plus-rate-field">
                                            <label><?php _e('Strength Points', 'ahura') ?></label>
                                            <div class="input-wrap">
                                                <input type="text" data-name="plus-rate">
                                                <span class="ah-add-item"><i class="fas fa-plus"></i></span>
                                            </div>
                                        </div>
                                        <div class="form-field negative-rate-field">
                                            <label><?php _e('Weak Points', 'ahura') ?></label>
                                            <div class="input-wrap">
                                                <input type="text" data-name="negative-rate">
                                                <span class="ah-add-item"><i class="fas fa-plus"></i></span>
                                            </div>
                                        </div>
                                    </div>
                                <?php $wp_comment_form->end_section(); ?>
                            <?php endif; ?>
                            <?php $wp_comment_form->render_comment_form(); ?>
                        </div>
                    </div>
                    <?php
                    else :
                        wc_print_notice(__('Only logged in customers who have purchased this product may leave a review.', 'ahura'), 'error');
                    endif;
                    ?>
                </div>
            </div>
            <div class="col-12 col-md-3 product-comments-rate">
                <div class="product-rates-detail">
                    <div class="rate-detail">
                        <div class="rate-icon">
                            <i class="fas fa-star"></i>
                        </div>
                        <div class="rate-num">
                            <div class="full-rate"><?php echo sprintf(__('%s Rate', 'ahura'), $product->get_average_rating()) ?></div>
                            <div class="users-rate-num"><?php echo sprintf(__('From %s user reviews', 'ahura'), $product->get_review_count()) ?></div>
                        </div>
                    </div>
                </div>
                <div class="product-rate-stars">
                    <div class="rate-value">
                        <div class="rate-value-num">
                            <span><i></i><i></i><i></i><i></i><i></i></span>
                            <span><?php echo $rating_counts[5] ?></span>
                        </div>
                        <div class="rate-progress">
                            <div class="rate-progress-bar" style="width:<?php echo $rating_percentage[5] ?>%;"></div>
                        </div>
                    </div>
                    <div class="rate-value">
                        <div class="rate-value-num">
                            <span><i></i><i></i><i></i><i></i></span>
                            <span><?php echo $rating_counts[4] ?></span>
                        </div>
                        <div class="rate-progress">
                            <div class="rate-progress-bar" style="width:<?php echo $rating_percentage[4] ?>%;"></div>
                        </div>
                    </div>
                    <div class="rate-value">
                        <div class="rate-value-num">
                            <span><i></i><i></i><i></i></span>
                            <span><?php echo $rating_counts[3] ?></span>
                        </div>
                        <div class="rate-progress">
                            <div class="rate-progress-bar" style="width:<?php echo $rating_percentage[3] ?>%;"></div>
                        </div>
                    </div>
                    <div class="rate-value">
                        <div class="rate-value-num">
                            <span><i></i><i></i></span>
                            <span><?php echo $rating_counts[2] ?></span>
                        </div>
                        <div class="rate-progress">
                            <div class="rate-progress-bar" style="width:<?php echo $rating_percentage[2] ?>%;"></div>
                        </div>
                    </div>
                    <div class="rate-value">
                        <div class="rate-value-num">
                            <span><i></i></span>
                            <span><?php echo $rating_counts[1] ?></span>
                        </div>
                        <div class="rate-progress">
                            <div class="rate-progress-bar" style="width:<?php echo $rating_percentage[1] ?>%;"></div>
                        </div>
                    </div>
                </div>
                <div class="comments-note">
                    <div class="note-title ah-text-center"><?php _e('Guide others to choose this product by writing your comments.', 'ahura') ?></div>
                </div>
            </div>
        </div>
    </div>
    <div class="clear"></div>
</div>