<?php
/**
 * Loop Rating
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/rating.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

global $product;

$loop_style = \ahura\app\mw_options::get_product_item_style();

if ( ! wc_review_ratings_enabled() ) {
	return;
}

if($loop_style != 3 || $loop_style != 4) {
    echo wc_get_rating_html( $product->get_average_rating() ); // WordPress.XSS.EscapeOutput.OutputNotEscaped.
} else {
    $average_rating = $product->get_average_rating(); ?>

        <div class="d-flex align-items-center justify-content-end rating m-0" title="<?php echo sprintf(__('Rated %s out of 5', 'ahura'), $average_rating); ?>">
            <span class="d-flex align-items-center justify-content-center">
                <?php $full_stars = floor($average_rating);

                for ($i = 0; $i < $full_stars; $i++) {
                    echo '<svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M7.37774 0.472097L5.55562 3.98115L1.47887 4.54567C0.747792 4.64639 0.454802 5.50245 0.984975 5.99276L3.93441 8.72261L3.23681 12.5789C3.11125 13.2759 3.88418 13.798 4.53155 13.472L8.17858 11.6512L11.8256 13.472C12.473 13.7954 13.2459 13.2759 13.1203 12.5789L12.4228 8.72261L15.3722 5.99276C15.9024 5.50245 15.6094 4.64639 14.8783 4.54567L10.8015 3.98115L8.97942 0.472097C8.65295 -0.153384 7.70701 -0.161335 7.37774 0.472097Z"/>
                        </svg>';
                }
                ?>
            </span>
            <?php if($product->get_rating_count() > 0): ?>
                <span class="voted <?php echo is_rtl() ? 'pr-1' : 'pl-1'; ?>">
                    <?php echo '(' . $product->get_rating_count() . ')'; ?>
                </span>
            <?php endif; ?>
        </div>
<?php
}
