<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

?>
<?php $best_sale_products = wc_get_products( [ 'limit' => -1, 'meta_key' => 'total_sales', 'orderby' => 'meta_value_num', 'order' => 'desc' ] );
if ( $best_sale_products ) : ?>

    <section class="best-sale products best-sale-slider">
        <h2><?php echo get_theme_mod('ahura_best_sale_product_title') ? get_theme_mod('ahura_best_sale_product_title') : __( 'Best Sale products', 'ahura' ) ; ?></h2>
        <div dir="<?php echo is_rtl() ? 'rtl' : 'ltr'; ?>" class="shop-best-sale-slider">
            <ul class="products owl-carousel owl-theme">
                <?php foreach ( $best_sale_products as $best_sale_product ) : ?>
                    <?php $post_object = get_post( $best_sale_product->get_id() );

                    if ( \ahura\app\mw_options::get_mod_is_active_exclude_outofstock_related_products() && ( !$post_object || !wc_get_product( $post_object )->is_in_stock() ) ) continue;

                    $GLOBALS['post'] = $post_object;
                    setup_postdata( $GLOBALS['post'] );

                    wc_get_template_part( 'content', 'product' ); ?>

                <?php endforeach; ?>
            </ul>
        </div>
        <script>
            jQuery(document).ready(function($){
                ahuraHandleSaleShopSlider({
                    showNav: 'true',
                    mobileItems: <?php echo get_theme_mod('ahura_best_sale_product_column_mobile') ? get_theme_mod('ahura_best_sale_product_column_mobile') : 1 ?>,
                    desktopItems: <?php echo get_theme_mod('ahura_best_sale_product_column') ? get_theme_mod('ahura_best_sale_product_column') : 5 ?>
                });
            });
        </script>
    <?php else: ?>
        <?php woocommerce_product_loop_end(); ?>
    <?php endif; ?>
    </section>
<?php wp_reset_postdata(); ?>
