<?php
/**
 * 
 * Usage in action ahura_post_like_template
 * 
 * @uses ahura_post_like_template($post_id, $title)
 * 
 */
$box_title = (!empty($title)) ? $title : \ahura\app\mw_options::get_mod_post_like_box_title();
$like_title = \ahura\app\mw_options::get_mod_post_like_button_title();
$dislike_title = \ahura\app\mw_options::get_mod_post_dislike_button_title();
$liked = ahura_is_liked_post($post_id);
$likes = ahura_get_post_likes($post_id);
$dislikes = ahura_get_post_dislikes($post_id);
if(empty($style)) $style = 'default'; ?>

<?php if($style === 'default'): ?>
    <div class="ahura-post-like ah-has-bg">
        <div class="ahura-post-like-msg ahura-post-like-msg-<?php echo $post_id ?>"></div>
        <div class="row align-items-center">
            <div class="col">
                <h3 class="post-like-title ah-has-text"><?php echo $box_title ?></h3>
            </div>
            <div class="col-12 col-sm-12 col-md-6 col-lg-6">
                <div class="post-like-buttons">
                    <a href="#" class="btn-post-like-action btn-post-like" data-like="1" data-post-id="<?php echo $post_id ?>">
                        <i class="icon-post-like"></i>
                        <span class="btn-title"><?php echo $like_title ?></span>
                        <span class="counter"><?php echo intval($likes) ? $likes : '0' ?></span>
                    </a>
                    <a href="#" class="btn-post-like-action btn-post-dislike" data-like="0" data-post-id="<?php echo $post_id ?>">
                        <i class="icon-post-dislike"></i>
                        <span class="btn-title"><?php echo $dislike_title ?></span>
                        <span class="counter"><?php echo intval($dislikes) ? $dislikes : '0' ?></span>
                    </a>
                </div>
            </div>
        </div>
    </div>
<?php else: ?>
    <div class="ahura-post-like post-like-style1">
        <div class="post-like-buttons">
            <a href="#" class="d-flex btn-post-like-action btn-post-like" data-like="1" data-post-id="<?php echo $post_id ?>">
                <svg width="20" height="20" viewBox="0 0 20 20" fill="<?php echo $liked ? 'black' : 'none'; ?>" xmlns="http://www.w3.org/2000/svg" class="svg-like">
                    <path d="M17.3671 3.84172C16.9415 3.41589 16.4361 3.0781 15.8799 2.84763C15.3237 2.61716 14.7275 2.49854 14.1254 2.49854C13.5234 2.49854 12.9272 2.61716 12.371 2.84763C11.8147 3.0781 11.3094 3.41589 10.8838 3.84172L10.0004 4.72506L9.11709 3.84172C8.25735 2.98198 7.09129 2.49898 5.87542 2.49898C4.65956 2.49898 3.4935 2.98198 2.63376 3.84172C1.77401 4.70147 1.29102 5.86753 1.29102 7.08339C1.29102 8.29925 1.77401 9.46531 2.63376 10.3251L3.51709 11.2084L10.0004 17.6917L16.4838 11.2084L17.3671 10.3251C17.7929 9.89943 18.1307 9.39407 18.3612 8.83785C18.5917 8.28164 18.7103 7.68546 18.7103 7.08339C18.7103 6.48132 18.5917 5.88514 18.3612 5.32893C18.1307 4.77271 17.7929 4.26735 17.3671 3.84172V3.84172Z" stroke="#080808" stroke-opacity="0.9" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="like-icon"/>
                </svg>
            </a>
        </div>
    </div>
<?php endif; ?>