<?php
$price = \ahura\app\Post_Meta::get_item_price();
$monthly_price = \ahura\app\Post_Meta::get_item_monthly_price();
$address = \ahura\app\Post_Meta::get_item_address();
$bedrooms = \ahura\app\Post_Meta::get_bedrooms();
$has_elevator = \ahura\app\Post_Meta::has_elevator();

$active_features = \ahura\app\Post_Meta::is_active_features_box();
$features = \ahura\app\Post_Meta::get_features_list();
?>
<div class="post-estate-box-details">
    <div class="estate-details">
        <?php if ($address): ?>
        <div class="item-address">
            <strong><?php _e('Location', 'ahura') ?></strong>
            <span><?php echo $address ?></span>
        </div>
        <?php endif; ?>
        <?php if ($bedrooms): ?>
        <div class="item-bedroom">
            <span><?php echo $bedrooms ?></span>
            <strong><?php _e('Bedroom', 'ahura') ?></strong>
        </div>
        <?php endif; ?>
        <?php if ($has_elevator): ?>
        <div class="item-elevator">
            <strong><?php _e('Has Elevator', 'ahura') ?></strong>
        </div>
        <?php endif; ?>
    </div>
    <?php if ($active_features && !empty($features)): ?>
    <div class="estate-features">
        <ul>
            <?php foreach ($features as $item): ?>
                <li><?php echo $item['title'] . ' : ' . $item['value'] ?></li>
            <?php endforeach; ?>
        </ul>
    </div>
    <?php endif; ?>
    <?php if ($price): ?>
        <div class="item-price">
            <strong><?php _e('Price', 'ahura') ?></strong>
            <span><?php echo number_format($price) ?> <?php echo \ahura\app\mw_options::get_theme_currency_unit() ?></span>
        </div>
    <?php endif; ?>
    <?php if ($monthly_price && \ahura\app\Post_Meta::is_estate_for_rent()): ?>
        <div class="item-price item-month-price">
            <strong><?php _e('Monthly Rent', 'ahura') ?></strong>
            <span><?php echo number_format($monthly_price) ?> <?php echo \ahura\app\mw_options::get_theme_currency_unit() ?></span>
        </div>
    <?php endif; ?>
</div>