const handleTestimonialCarousel9Element = function (params) {
    let options = {
        loop: false,
        allowTouchMove: false,
        slidesPerView: 1,
        spaceBetween: 20,
    };

    if (params.pagination) {
        options.pagination = {
            el: `.testimonial-carousel-9-${params.widgetID} .swiper-pagination`,
            clickable: true,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/testimonial_carousel9.default', function($scope, $) {
        let wrap = $scope.find('.testimonial-carousel'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleTestimonialCarousel9Element(sliderData);
    });
});