const handleShopCarousel13 = function (params){
    let options = {
        slidesPerView: 1,
        spaceBetween: 10,
        breakpoints: {
            640: {
                slidesPerView: 1,
            },
            768: {
                slidesPerView: 2,
            },
            1024: {
                slidesPerView: 2,
            },
        },
        on: {
            slideChange: function () {
               updateStyles(this);
            },
        }
    };


    function updateStyles(swiper) {
        const slides = Array.from(swiper.slides);

        slides.forEach(slide => {
            slide.classList.remove('after-active-slide-1', 'after-active-slide-2', 'is-slide-hide', 'is-last-slide');
        });

        const activeIndex = swiper.realIndex;

        const slidesCount = slides.length;
        const slide1 = slides[activeIndex];
        const slide2 = slides[(activeIndex + 1) % slidesCount];
        const slide3 = slides[(activeIndex + 2) % slidesCount];

        if (slide2) {
            slide2.classList.add('after-active-slide-1');
        }

        if (slide3) {
            slide3.classList.add('after-active-slide-2');
        }

        for (let i = 0; i < slidesCount; i++) {
            if (i < activeIndex) {
                slides[i].classList.add('is-slide-hide');
            }
        }

        const nextIndex = (activeIndex + 1) % slidesCount;
        const nextSlide = slides[swiper.activeIndex + 1];

        if (nextSlide && nextIndex === slidesCount - 1) {
            nextSlide.classList.add('is-last-slide');
        }
    }

    if (params.autoPlay === true){
        options.autoplay = {
            delay: params.autoplayTimeout || 4500,
            disableOnInteraction: false,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);

    updateStyles(swiper);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_carousel13.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel13'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleShopCarousel13(sliderData);
    });
});