const handleShopCarousel12Element = function (params){
    if (typeof window.Swiper != undefined) {
        let options = {
            loop: params.loop,
            slidesPerView: 1,
            spaceBetween: 20,
        };

        if(params.autoPlay){
            options.autoplay = {
                delay: params.transitionDuration,
                disableOnInteraction: false,
            };
        }

        if(params.pagination){
            options.pagination = {
                el: `.shop-carousel12-${params.widgetID} .swiper-pagination`,
                clickable: true,
            };
        }

        if(params.observer === true){
            options.observer = true;
            options.observeParents = true;
        }

        let shop_carousel12_slider = new Swiper(params.container, options);
    }
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/shop_carousel12.default', function($scope, $) {
        let wrap = $scope.find('.shop-carousel12'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleShopCarousel12Element(sliderData);
    });
});