const handleShopCarouselElement = function(params){
    let is_rtl = jQuery('body').hasClass('mw_rtl') ? true : false;
    let carousel = params.container.owlCarousel({
        loop: params.loop || false,
        autoplay: params.autoplay || false,
        autoplayTimeout: params.autoplayTimeout,
        center: false,
        items: params.desktopItems,
        rtl: is_rtl,
        dots: true,
        margin: params.margin,
        navigation: true,
        navText: ["<i class='fa fa-3x fa-chevron-left'></i>", "<i class='fa fa-3x fa-chevron-right'></i>"],
        responsive: {
            0: {
                items: params.mobileItems
            },
            400: {
                items: params.mobileItems
            },
            600: {
                items: params.tabletItems
            },
            1000: {
                items: params.desktopItems
            }
        }
    });

    params.container.parent().find('.next-slide-btn').click(function() {
        carousel.trigger('next.owl.carousel');
    });

    params.container.parent().find('.prev-slide-btn').click(function() {
        carousel.trigger('prev.owl.carousel');
    });
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction('frontend/element_ready/shopcarousel.default', function($scope, $) {
        let wrap = $scope.find('.owl-shop-carousel'),
            sliderData = wrap.data('slider');

        handleShopCarouselElement({
            container: wrap,
            loop: true,
            autoplay: sliderData.autoplay,
            autoplayTimeout: sliderData.autoplay_delay || 2500,
            desktopItems: sliderData.cols.desktop,
            tabletItems: sliderData.cols.tablet,
            mobileItems: sliderData.cols.mobile,
            margin: sliderData.spacing || 25,
            dots: sliderData.show_pagination,
        });
    });
});