const handleProductTab3Element = function (params) {
    let options = {
        loop: true,
        breakpoints: {
            640: {
                slidesPerView: params.mobilePerView,
                spaceBetween: 10,
            },
            768: {
                slidesPerView: params.tabletPerView,
                spaceBetween: 15,
            },
            1024: {
                slidesPerView: params.desktopPerView,
                spaceBetween: 20,
            },
        },
    };

    if (params.autoPlayStatus === true) {
        options.autoplay = {
            delay: params.playDelay,
            disableOnInteraction: false,
        };
    }
    if (params.pagination) {
        options.pagination = {
            el: `.product-tab3-swiper-${params.widgetID} .swiper-pagination`,
            clickable: true,
        };
    }

    if (params.arrows) {
        options.navigation = {
            nextEl: '.items-carousel-button-next',
            prevEl: '.items-carousel-button-prev',
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/product_tab3.default', function($scope, $) {
        let wrap = $scope.find('.product-tab-3-wrap'),
            slider = wrap.find('.swiper'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handleProductTab3Element(sliderData);
    });
});