jQuery(document).ready(function($) {
    $('.product-intro').each(function() {
        var $widget = $(this);
        var widgetId = $widget.data('widget-id');
        var productVariations = window['productVariations_' + widgetId];

        function updateVariationId() {
            let selected_variation = $widget.find('.variations_form').find('input[name="variation_id"]').val();
            if (selected_variation) {
                $widget.find('.variation_id').val(selected_variation);
            } else {
                $widget.find('.variation_id').val('0');
            }
        }

        updateVariationId();

        $widget.find('.variations_form').on('change', '.variations select', function() {
            updateVariationId();
        });

        $widget.find('.product-swatches-button-group a').on('click', function(e) {
            e.preventDefault();

            $(this).siblings().removeClass('selected');
            $(this).addClass('selected');

            let selected_values = [];
            $widget.find('.variations .var-item').each(function() {
                let selected_value = $(this).find('.selected').data('value');
                if (selected_value) {
                    selected_values.push(selected_value);
                }
            });

            let variation_match = null;
            $.each(productVariations, function(index, variation) {
                let match_count = 0;
                $.each(selected_values, function(i, value) {
                    if ($.inArray(value, variation.attributes) !== -1) {
                        match_count++;
                    }
                });
                if (match_count === selected_values.length) {
                    variation_match = variation;
                    return false;
                }
            });

            if (variation_match) {
                $widget.find('.variation-price').html(variation_match.price_html);

                if (variation_match.price_html.trim() !== '') {
                    let minQty = variation_match.min_qty;
                    let maxQty = variation_match.max_qty;
                    let $quantityInput = $widget.find('.single_variation_wrap').find('.variation-quantity-input');

                    if ($quantityInput.length === 0) {
                        let $input = $('<input>', {
                            type: 'number',
                            class: 'variation-quantity-input',
                            name: 'quantity',
                            min: minQty,
                            max: maxQty,
                            value: minQty,
                            style: 'margin-top: 10px;'
                        });
                        $widget.find('.single_variation_wrap').prepend($input);
                    } else {
                        $quantityInput.attr('min', minQty);
                        $quantityInput.attr('max', maxQty);
                        if ($quantityInput.val() < minQty || $quantityInput.val() > maxQty) {
                            $quantityInput.val(minQty);
                        }
                    }
                    $widget.find('.single_add_to_cart_button').prop('disabled', false);
                } else {
                    $widget.find('.single_variation_wrap .variation-quantity-input').remove();
                    $widget.find('.single_add_to_cart_button').prop('disabled', true);
                }
                $widget.find('.single_add_to_cart_button').prop('disabled', false);
                $widget.find('.variation_id').val(variation_match.variation_id);
            } else {
                $widget.find('.single_variation_wrap .variation-quantity-input').remove();
                $widget.find('.single_add_to_cart_button').prop('disabled', true);
            }
        });

        $widget.find('.single_add_to_cart_button').on('click', function(e) {
            e.preventDefault();

            let variationId = $widget.find('.variation_id').val();

            if (variationId !== '0') {
                $(this).closest('form').submit();
            } else {
                alert('Please select a variation before adding to cart.');
            }
        });

        $widget.find('.product-swatches-button-group a.selected').trigger('click');

        $widget.find('.product-details-title').click(function() {
            let $details = $(this).next('.product-custom-details');
            $details.slideToggle(300);

            $(this).find('svg').toggleClass('rotate');
        });
    });
});
