const handlePostCarousel8Element = function (params){
    let options = {
        slidesPerView: 1,
        spaceBetween: params.margin,
        centeredSlides: true,
        loop: true,
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
        },
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        breakpoints: {
            640: {
                slidesPerView: 1,
            },
            768: {
                slidesPerView: 2,
                spaceBetween: 5,
            },
            1024: {
                slidesPerView: params.slidesPerView,
            },
        },
    };

    if(params.autoplay){
        options.autoplay = {
            delay: 3000,
            disableOnInteraction: false,
        };
    }

    if(params.observer === true){
        options.observer = true;
        options.observeParents = true;
    }

    let swiper = new Swiper(params.container, options);
}

jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/post_carousel8.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel8'),
            slider = wrap.find('.posts-carousel'),
            sliderData = slider.data('slider');

        sliderData.container = slider;

        handlePostCarousel8Element(sliderData);
    });
});