jQuery(window).on('elementor/frontend/init', function (){
    elementorFrontend.hooks.addAction( 'frontend/element_ready/ahura_post_carousel_5.default', function($scope, $) {
        let wrap = $scope.find('.post-carousel-5'),
            slider = wrap.find('.large-slider'),
            thumbsSlider = wrap.find('.thumbs-slider'),
            sliderData = slider.data('slider');

        let sliderOptions = {
            slidesPerView: 1,
            effect: sliderData.effect,
        };

        if(sliderData.observer === true){
            sliderOptions.observer = true;
            sliderOptions.observeParents = true;
        }

        if (sliderData.arrows) {
            sliderOptions.navigation = {
                prevEl: '.post-carousel5-button-next',
                nextEl: '.post-carousel5-button-prev',
            };
        }

        if (sliderData.autoplay === true){
            sliderOptions.autoplay = {
                delay: sliderData.delay || 4000,
                disableOnInteraction: false,
            };
        }

        if(thumbsSlider){
            let thumbsOptions = {
                effect: "slide",
                spaceBetween: 5,
                slidesPerView: sliderData.slidesPerView,
                watchSlidesProgress: true
            };

            if(sliderData.observer === true){
                thumbsOptions.observer = true;
                thumbsOptions.observeParents = true;
            }

            let thumbs = new Swiper(thumbsSlider, thumbsOptions)

            sliderOptions.thumbs = {
                swiper: thumbs,
            };
        }

        let swiper = new Swiper(slider, sliderOptions);
    });
});