jQuery(document).ready(function ($){
    $(document).on('click', '.popup-search2-element .toggle-search-btn', function (e){
        e.preventDefault();
        let button = $(this),
            container = button.parent().find('.popup-search-container');
        $('body').addClass('none_overflow');
        container.fadeToggle(250);
    });

    $(document).on('click', '.popup-search2-element .is-close-btn, .popup-search2-element .popup-search-overlay', function (e){
        e.preventDefault();
        let container = $('.popup-search2-element .popup-search-container');
        container.find('.is-search-input').val('');
        container.fadeOut(200);
        $('body').removeClass('none_overflow');
    });

    $(document).on('change', '.popup-search2-element .categories-selector select', function (e){
        e.preventDefault();
        let container = $(this).closest('.popup-search2-element'),
            input = container.find('.is-search-input');

        input.trigger('change');
    });

    $(document).on('keydown change', '.popup-search2-element .is-search-input', function (e){
        let input = $(this),
            container = input.closest('.popup-search2-element'),
            form = input.closest('form'),
            resultWrap = container.find('.popup-search-result-wrap'),
            resultContent = resultWrap.find('.popup-search-result');

        let showFormLoader = () => resultWrap.find('.is-search-loader').fadeIn(100);
        let hideFormLoader = () => resultWrap.find('.is-search-loader').fadeOut(100);

        let showResultWrap = () => resultWrap.slideDown();
        let hideResultWrap = () => resultWrap.slideUp();

        let handleRequestCallback = function (){
            let inputVal = input.val();

            if(inputVal.trim().length < 2){
                hideFormLoader();
                hideResultWrap();
                return false;
            }

            let ajaxData = {
                action: 'ahura_popup_search2_result',
                template: 2,
                show_thumb: true,
                show_price: true,
                keyword: inputVal,
            };

            $.each(form.serializeArray(), function (k, item){
                if(item && item.hasOwnProperty('name')){
                    if(item.name.includes('cat')){
                        item.name = 'category';
                    }
                    ajaxData[item.name] = item.value;
                }
            });

            $.ajax({
                url: search_data.au,
                data: ajaxData,
                type: 'POST',
                beforeSend: function (){
                    resultContent.empty();
                    showResultWrap();
                    showFormLoader();
                },
                complete: function (result){
                    let resultHtml = result.responseText;
                    hideFormLoader();
                    if(resultHtml && resultHtml !== '0'){
                        resultContent.html(result.responseText);
                    } else {
                        hideResultWrap();
                    }
                },
                error: function (){
                    resultContent.empty();
                    hideFormLoader();
                    hideResultWrap();
                }
            })
        }

        setTimeout(handleRequestCallback, 60);
    });
});