<?php

namespace ahura\inc\widgets;

use Elementor\Controls_Manager;
use \ahura\app\mw_assets;

defined('ABSPATH') or die('no script kiddies please!');

class timeline_4 extends \ahura\app\elementor\Elementor_Widget_Base
{
    public function __register_assets()
    {
        $this->register_elementor_style('timeline4_css', mw_assets::get_css('elementor.timeline_4'));
    }

    public function get_icon()
    {
        return 'aicon-svg-timeline';
    }

    public function get_name()
    {
        return 'timeline4';
    }

    public function get_title()
    {
        return esc_html__('Timeline 4', 'ahura');
    }

    public function get_categories()
    {
        return ['ahuraelements'];
    }

    public function get_keywords()
    {
        return ['ahura', 'timeline', 'timeline 4', esc_html__('ahura', 'ahura'), esc_html__('Timeline 4', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'timeline_number',
            [
                'label' => esc_html__('Number', 'ahura'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'timeline_title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
            'timeline_title2',
            [
                'label' => esc_html__('Title 2', 'ahura'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $repeater->add_control(
			'timeline_icon',
			[
				'label' => esc_html__( 'Icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
			]
		);

        $repeater->add_control(
            'timeline_title3',
            [
                'label' => esc_html__('Title 3', 'ahura'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'timeline_list',
            [
                'label' => esc_html__('Timeline List', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'timeline_title' => esc_html__('2023 - Present', 'ahura'),
                        'timeline_title2' => esc_html__('ART DIRECTOR', 'ahura'),
                        'timeline_title3' => esc_html__('Victory', 'ahura'),
                    ],
                    [
                        'timeline_title' => esc_html__('2023 - Present', 'ahura'),
                        'timeline_title2' => esc_html__('UX/UI DESIGNER & DEVELOPER', 'ahura'),
                        'timeline_title3' => esc_html__('Acumen', 'ahura'),
                    ],
                    [
                        'timeline_title' => esc_html__('2023 - Present', 'ahura'),
                        'timeline_title2' => esc_html__('CREATIVE DEVELOPER', 'ahura'),
                        'timeline_title3' => esc_html__('Designify', 'ahura'),
                    ],
                ],
                'title_field' => '{{{timeline_title}}}',
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         *
         * Items style tab
         *
         *
         */
        $this->start_controls_section(
            'timeline_items_style',
            [
                'label' => esc_html__('Items', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
			'item_opacity',
			[
				'label' => esc_html__( 'Opacity', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 55,
				],
				'selectors' => [
					'{{WRAPPER}} ul li' => 'opacity: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
                'default' => [
					'top' => 55,
					'right' => 0,
					'bottom' => 30,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .timeline4-wrap ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'items_justify_content',
			[
				'label' => esc_html__( 'Horizontal alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Start', 'ahura' ),
						'icon' => 'eicon-justify-start-h',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-justify-center-h',
					],
					'space-between' => [
						'title' => esc_html__( 'Space between', 'ahura' ),
						'icon' => 'eicon-justify-space-between-h',
					],
					'end' => [
						'title' => esc_html__( 'End', 'ahura' ),
						'icon' => 'eicon-justify-end-h',
					],
				],
				'default' => 'space-between',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} ul li' => 'justify-content: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'items_align_items',
			[
				'label' => esc_html__( 'Vertical alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Start', 'ahura' ),
						'icon' => 'eicon-align-start-v',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-align-center-v',
					],
					'space-between' => [
						'title' => esc_html__( 'Space between', 'ahura' ),
						'icon' => 'eicon-justify-space-between-v',
					],
					'end' => [
						'title' => esc_html__( 'End', 'ahura' ),
						'icon' => 'eicon-align-end-v',
					],
				],
				'default' => 'end',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} ul li' => 'align-items: {{VALUE}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'item_border',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => ['default' =>
                        [
                            'unit' => 'px',
                            'top' => 0,
                            'right' => 0,
                            'bottom' => 1.5,
                            'left' => 0,
                        ]
                    ],
                    'color' => ['default' => '#D3FD06']
                ],
				'selector' => '{{WRAPPER}} ul li',
			]
		);

		$this->add_control(
			'item_hover_options',
			[
				'label' => esc_html__( 'Hover options', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name' => 'item_hover_border',
                'fields_options' => [
                    'border' => ['default' => 'solid'],
                    'width' => ['default' =>
                        [
                            'unit' => 'px',
                            'top' => 0,
                            'right' => 0,
                            'bottom' => 1.5,
                            'left' => 0,
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} ul li:hover',
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'timeline_number_style',
            [
                'label' => esc_html__('Number', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'number_typography',
				'selector' => '{{WRAPPER}} .timeline-number-container span',
			]
		);

        $this->add_control(
			'number_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#D3FD06',
				'selectors' => [
					'{{WRAPPER}} .timeline-number-container span' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'number_hover_color',
			[
				'label' => esc_html__( 'Hover color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} li:hover .timeline-number-container span' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'number_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .timeline-number-container span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'timeline_title1_style',
            [
                'label' => esc_html__('Title 1', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'selector' => '{{WRAPPER}} .date-title',
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#D3FD06',
				'selectors' => [
					'{{WRAPPER}} .date-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'title_hover_color',
			[
				'label' => esc_html__( 'Hover color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} li:hover .date-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'title_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .date-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'timeline_title2_style',
            [
                'label' => esc_html__('Title 2', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title2_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '30'
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} .main-title',
			]
		);

        $this->add_control(
			'title2_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .main-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'title2_hover_color',
			[
				'label' => esc_html__( 'Hover color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} li:hover .main-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'title2_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .main-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'timeline_title3_style',
            [
                'label' => esc_html__('Title 3', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title3_typography',
				'selector' => '{{WRAPPER}} .timeline-name',
			]
		);

        $this->add_control(
			'title3_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000000',
				'selectors' => [
					'{{WRAPPER}} .timeline-name' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'title3_hover_color',
			[
				'label' => esc_html__( 'Hover color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} li:hover .timeline-name' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'title3_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .timeline-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'timeline_icon_style',
            [
                'label' => esc_html__('Icon', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .timeline-icon svg' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'icon_hover_color',
			[
				'label' => esc_html__( 'Hover color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} li:hover .timeline-icon svg' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'icon_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'selectors' => [
					'{{WRAPPER}} .timeline-icon svg' => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .timeline-icon svg' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'icon_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
                'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => -80,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .timeline-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
    }

    public function render()
    {
        $settings = $this->get_settings_for_display();
        $items = $settings['timeline_list'];
        if ($items): ?>
            <div class="timeline4-wrap">
                <div class="timelines">
                    <ul class="timeline-list">
                        <?php foreach ($items as $item): ?>
                            <li class="timeline-item elementor-repeater-item-<?php echo $item['_id']; ?>">
                                <div class="d-flex timeline-content">
									<?php if(!empty($item['timeline_number'])): ?>
										<div class="timeline-number-container">
											<span><?php echo $item['timeline_number']; ?></span>
										</div>
									<?php endif; ?>
									<div class="timeline-title-container">
										<?php if(!empty($item['timeline_title'])): ?>
											<h4 class="date-title"><?php echo $item['timeline_title']; ?></h4>
										<?php endif; ?>
										<?php if(!empty($item['timeline_title2'])): ?>
											<h3 class="main-title"><?php echo $item['timeline_title2']; ?></h3>
										<?php endif; ?>
									</div>
                                </div>
                                <?php if($item['timeline_icon']['value']): ?>
                                    <div class="timeline-icon">
                                        <?php \Elementor\Icons_Manager::render_icon( $item['timeline_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                    </div>
                                <?php endif; ?>
                                <?php if(!empty($item['timeline_title3'])): ?>
                                    <div class="timeline-name">
                                        <p><?php echo $item['timeline_title3']; ?></p>
                                    </div>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        <?php
        endif;
    }
}