<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class testimonial_carousel8 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('testimonial_carousel8_js', mw_assets::get_js('elementor.testimonial_carousel8'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('testimonial_carousel8_css', mw_assets::get_css('elementor.testimonial_carousel8'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('testimonial_carousel8_js')];
    }

    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'testimonial_carousel8';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Testimonial Carousel 8', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'eicon-testimonial-carousel';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements', 'ahuratestimonial'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    public function get_keywords()
    {
        return ['ahura', 'testimonial', 'testimonial carousel 8', esc_html__('ahura', 'ahura'), esc_html__('Testimonial Carousel 8', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        /**
         *
         * Start content section
         *
         */
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'testimonial_bycat_byids',
            [
                'label' => esc_html__( 'Testimonial query by', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'byids',
                'options' => [
                    'byids' => esc_html__( 'By Ids', 'ahura' ),
                    'bycat' => esc_html__( 'By Category', 'ahura' ),
                ],
            ]
        );

        $testimonial_cats = get_categories(['taxonomy' => 'testimonial_cat', 'orderby' => 'name', 'order' => 'ASC']);

        $testimonial_cats_options = [];
        if ($testimonial_cats) {
            foreach ($testimonial_cats as $item) {
                $testimonial_cats_options[$item->term_id] = $item->cat_name;
            }
        }

        $this->add_control(
            'testimonial_bycat',
            [
                'label' => esc_html__( 'Select category', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => $testimonial_cats_options,
                'condition' => [
                    'testimonial_bycat_byids' => 'bycat',
                ],
            ]
        );

        $repeater = new \Elementor\Repeater();

        $items = get_posts(['post_type' => 'testimonial', 'numberposts' => -1]);
        $options = [];
        if ($items) {
            foreach ($items as $item) {
                $options[$item->ID] = $item->post_title;
            }
        }

        $default = ($options && is_array($options)) ? key($options) : false;

        $repeater->add_control(
            'tst_id',
            [
                'type' => Controls_Manager::SELECT2,
                'label' => esc_html__('Select', 'ahura'),
                'label_block' => true,
                'options' => $options,
                'default' => $default
            ]
        );

        $this->add_control(
            'testimonials',
            [
                'label' => esc_html__('Testimonial', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tst_id' => $default,
                        'rate' => 5
                    ],
                ],
                'title_field' => '{{{tst_id}}}',
                'condition' => [
                    'testimonial_bycat_byids' => 'byids',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_settings',
            [
                'label' => esc_html__('Settings', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-avatar img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__('Autoplay', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'transition_duration',
            [
                'label' => esc_html__('Transition Duration', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4000,
                'condition' => [
                    'autoplay' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label' => esc_html__('Infinite Loop', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'box_content_style',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
            'bg_icon_color',
            [
                'label' => esc_html__('Background Icon Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2289FF',
                'selectors' => [
                    '{{WRAPPER}} .item-content svg linearGradient stop:first-child' => 'stop-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'name_color',
            [
                'label' => esc_html__('Name Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#556077',
                'selectors' => [
                    '{{WRAPPER}} .item-content .name' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'name_typo',
                'selector' => '{{WRAPPER}} .item-content .name',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '27'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 600
                    ],
                ]
            ]
        );

        $this->add_control(
            'site_name_color',
            [
                'label' => esc_html__('Site Name Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#556077',
                'selectors' => [
                    '{{WRAPPER}} .item-content .site-name' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'site_name_typo',
                'selector' => '{{WRAPPER}} .item-content .site-name',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 400
                    ],
                ]
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('Text Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#556077',
                'selectors' => [
                    '{{WRAPPER}} .item-content .content-text' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'text_typo',
                'selector' => '{{WRAPPER}} .item-content .content-text',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 400
                    ],
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_img_style',
            [
                'label' => esc_html__('Image', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'avatar_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 400
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-avatar' => 'width: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_responsive_control(
            'avatar_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['%', 'px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 3000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 200,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 400
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-avatar' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_control(
            'dots_color',
            [
                'label' => esc_html__('Dots Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#F1F1F1',
                'selectors' => [
                    '{{WRAPPER}} .item-avatar svg circle' => 'fill: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'box_avatar_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-avatar img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'unit' => '%',
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 0,
                    'left' => 50,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'avatar_border',
                'selector' => '{{WRAPPER}} .item-avatar img',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_paginate_style',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => ['pagination' => 'yes']
            ]
        );

        $this->add_control(
            'paginate_color',
            [
                'label' => esc_html__('Normal Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2289FF',
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'border-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'paginate_active_color',
            [
                'label' => esc_html__('Active Color', 'ahura'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#2289FF',
                'selectors' => [
                    '{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'border-color: {{VALUE}};background-color: {{VALUE}};',
                ]
            ]
        );


        $this->end_controls_section();

        $this->register_additional_controls();
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $items_byids = $settings['testimonials'];
        $rare_items_bycat = $settings['testimonial_bycat'];
        $has_paginate = $settings['pagination'] == 'yes';

        $slider_data = [
            'loop' => $settings['infinite_loop'] == 'yes',
            'autoPlay' => $settings['autoplay'] == 'yes',
            'transitionDuration' => (intval($settings['transition_duration'])) ? $settings['transition_duration'] : 4000,
            'showPagination' => $has_paginate,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        $items = null;
        $items_bycat = [];

        $posts_bycat = get_posts( [
            'posts_per_page'    => -1,
            'post_type'         => 'testimonial',
            'tax_query'         => [['taxonomy' => 'testimonial_cat', 'field' => 'term_id', 'terms' => $rare_items_bycat]]
        ]);

        if($items_byids) {
            $items = $items_byids;
        }

        if($rare_items_bycat){
            foreach($posts_bycat as $index => $post) {
                $items_bycat[$index]['tst_id'] = $post->ID;
                $items_bycat[$index]['show_rate'] = 'no';
                $items_bycat[$index]['rate'] = 5;
            }
            $items = $items_bycat;
        }

        if (!$items) {
            return false;
        }
        ?>
        <div class="testimonial-carousel testimonial-carousel-8<?php echo $has_paginate ? ' has-paginate-' . $settings['pagination'] : '' ?>">
            <div class="swiper carousel-wrap" data-slider='<?php echo json_encode($slider_data) ?>'>
                <div class="swiper-wrapper">
                    <?php
                    foreach($items as $item):
                        $name = \ahura\app\mw_options::get_testimonial_username($item['tst_id']);
                        $site_name = \ahura\app\mw_options::get_testimonial_sitename($item['tst_id']);
                        $avatar_url = get_the_post_thumbnail_url($item['tst_id'], 'full');
                        $content = get_post_field('post_content', $item['tst_id']);
                        ?>
                        <div class="swiper-slide">
                            <div class="testimonial-carousel-item-wrap">
                                <div class="ahura-testimonial testimonial-carousel-item">
                                    <div class="row">
                                        <div class="col-12 col-md-7">
                                            <div class="content-wrap">
                                                <div class="item-content">
                                                    <div class="content-text ah-has-text"><?php echo $content ?></div>
                                                    <div class="testimonial-footer ah-has-text">
                                                        <div class="name"><?php echo $name ?></div>
                                                        <div class="site-name"><?php echo $site_name ?></div>
                                                    </div>
                                                    <svg width="280" height="229" viewBox="0 0 280 229" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M114.131 41.2921V0C-1.24147 0 -7.36587 152.181 3.99348 228.271H114.131V117.731H73.258C66.2467 60.0576 97.5853 42.7412 114.131 41.2921Z" fill="url(#paint0_linear_0_396)" fill-opacity="0.2"/> <path d="M279.251 41.2921V0C163.878 0 157.754 152.181 169.113 228.271H279.251V117.731H238.378C231.366 60.0576 262.705 42.7412 279.251 41.2921Z" fill="url(#paint1_linear_0_396)" fill-opacity="0.2"/> <defs> <linearGradient id="paint0_linear_0_396" x1="154.298" y1="1.15144e-06" x2="150.428" y2="228.299" gradientUnits="userSpaceOnUse"> <stop stop-color="#2289FF"/> <stop offset="1" stop-color="white"/> </linearGradient> <linearGradient id="paint1_linear_0_396" x1="154.298" y1="1.15144e-06" x2="150.428" y2="228.299" gradientUnits="userSpaceOnUse"> <stop stop-color="#2289FF"/> <stop offset="1" stop-color="white"/> </linearGradient> </defs> </svg>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 col-md-5">
                                            <div class="avatar-wrap">
                                                <div class="item-avatar">
                                                    <svg width="100" height="139" viewBox="0 0 100 139" fill="none" xmlns="http://www.w3.org/2000/svg"> <circle cx="2.97266" cy="3.79859" r="2.81983" fill="#F1F1F1"/> <circle cx="21.7715" cy="3.79847" r="2.81983" fill="#F1F1F1"/> <circle cx="40.5703" cy="3.79847" r="2.81983" fill="#F1F1F1"/> <circle cx="59.3691" cy="3.79847" r="2.81983" fill="#F1F1F1"/> <circle cx="78.168" cy="3.79847" r="2.81983" fill="#F1F1F1"/> <circle cx="96.9669" cy="3.79847" r="2.81983" fill="#F1F1F1"/> <circle cx="2.97266" cy="22.5973" r="2.81983" fill="#F1F1F1"/> <circle cx="21.7715" cy="22.5973" r="2.81983" fill="#F1F1F1"/> <circle cx="40.5703" cy="22.5973" r="2.81983" fill="#F1F1F1"/> <circle cx="59.3691" cy="22.5973" r="2.81983" fill="#F1F1F1"/> <circle cx="78.168" cy="22.5973" r="2.81983" fill="#F1F1F1"/> <circle cx="96.9669" cy="22.5973" r="2.81983" fill="#F1F1F1"/> <circle cx="2.97266" cy="41.3961" r="2.81983" fill="#F1F1F1"/> <circle cx="21.7715" cy="41.3961" r="2.81983" fill="#F1F1F1"/> <circle cx="40.5703" cy="41.3961" r="2.81983" fill="#F1F1F1"/> <circle cx="59.3691" cy="41.3961" r="2.81983" fill="#F1F1F1"/> <circle cx="78.168" cy="41.3961" r="2.81983" fill="#F1F1F1"/> <circle cx="96.9669" cy="41.3961" r="2.81983" fill="#F1F1F1"/> <circle cx="2.97266" cy="78.9939" r="2.81983" fill="#F1F1F1"/> <circle cx="21.7715" cy="78.9939" r="2.81983" fill="#F1F1F1"/> <circle cx="40.5703" cy="78.9939" r="2.81983" fill="#F1F1F1"/> <circle cx="59.3691" cy="78.9939" r="2.81983" fill="#F1F1F1"/> <circle cx="78.168" cy="78.9939" r="2.81983" fill="#F1F1F1"/> <circle cx="96.9669" cy="78.9939" r="2.81983" fill="#F1F1F1"/> <circle cx="2.97266" cy="60.1951" r="2.81983" fill="#F1F1F1"/> <circle cx="21.7715" cy="60.1951" r="2.81983" fill="#F1F1F1"/> <circle cx="40.5703" cy="60.1951" r="2.81983" fill="#F1F1F1"/> <circle cx="59.3691" cy="60.1951" r="2.81983" fill="#F1F1F1"/> <circle cx="78.168" cy="60.1951" r="2.81983" fill="#F1F1F1"/> <circle cx="96.9669" cy="60.1951" r="2.81983" fill="#F1F1F1"/> <circle cx="2.97266" cy="97.7927" r="2.81983" fill="#F1F1F1"/> <circle cx="21.7715" cy="97.7927" r="2.81983" fill="#F1F1F1"/> <circle cx="40.5703" cy="97.7927" r="2.81983" fill="#F1F1F1"/> <circle cx="59.3691" cy="97.7927" r="2.81983" fill="#F1F1F1"/> <circle cx="78.168" cy="97.7927" r="2.81983" fill="#F1F1F1"/> <circle cx="96.9669" cy="97.7927" r="2.81983" fill="#F1F1F1"/> <circle cx="2.97266" cy="116.592" r="2.81983" fill="#F1F1F1"/> <circle cx="21.7715" cy="116.592" r="2.81983" fill="#F1F1F1"/> <circle cx="40.5703" cy="116.592" r="2.81983" fill="#F1F1F1"/> <circle cx="59.3691" cy="116.592" r="2.81983" fill="#F1F1F1"/> <circle cx="78.168" cy="116.592" r="2.81983" fill="#F1F1F1"/> <circle cx="96.9669" cy="116.592" r="2.81983" fill="#F1F1F1"/> <circle cx="2.97266" cy="135.39" r="2.81983" fill="#F1F1F1"/> <circle cx="21.7715" cy="135.39" r="2.81983" fill="#F1F1F1"/> <circle cx="40.5703" cy="135.39" r="2.81983" fill="#F1F1F1"/> <circle cx="59.3691" cy="135.39" r="2.81983" fill="#F1F1F1"/> <circle cx="78.168" cy="135.39" r="2.81983" fill="#F1F1F1"/> <circle cx="96.9669" cy="135.39" r="2.81983" fill="#F1F1F1"/> </svg>
                                                    <img src="<?php echo $avatar_url ?>" alt="<?php echo $name ?>">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
                <?php if($has_paginate): ?>
                    <div class="swiper-pagination"></div>
                <?php endif; ?>
            </div>
        </div>
        <?php
    }
}