<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

use ahura\app\mw_assets;
use Elementor\Controls_Manager;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Typography;

class ahura_post_sharing_buttons extends \ahura\app\elementor\Elementor_Widget_Base {
    public function __register_assets()
    {
        $this->register_elementor_style('post_sharing_buttons_css',mw_assets::get_css('elementor.post_sharing_buttons'));
    }

    public function get_name() {
        return 'ahura_post_sharing_buttons';
    }

    public function get_title() {
        return esc_html__( 'Sharing Buttons', 'ahura' );
    }

    public function get_icon() {
        return 'eicon-social-icons';
    }

    public function get_categories() {
        return [ 'ahura_single' ];
    }

    public function get_keywords() {
        return [ 'ahura', 'post', 'share', esc_html__( 'ahura', 'ahura' ), esc_html__( 'share', 'ahura' ), esc_html__( 'Sharing Buttons', 'ahura' ) ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'ahura' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'buttons',
            [
                'label' => esc_html__( 'Buttons', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'label_block' => true,
                'multiple' => true,
                'options' => [
                    'facebook'  => esc_html__( 'Facebook', 'ahura' ),
                    'twitter'  => esc_html__( 'Twitter', 'ahura' ),
                    'linkedin'  => esc_html__( 'Linkedin', 'ahura' ),
                    'telegram'  => esc_html__( 'Telegram', 'ahura' ),
                    'pinterest'  => esc_html__( 'Pinterest', 'ahura' ),
                    'whatsapp'  => esc_html__( 'Whatsapp', 'ahura' ),
                    'email'  => esc_html__( 'Email', 'ahura' ),
                ],
                'default' => ['facebook', 'twitter', 'linkedin', 'telegram', 'pinterest', 'whatsapp', 'email'],
            ]
        );

        $this->add_control(
            'use_custom_buttons',
            [
                'label' => esc_html__( 'Custom Buttons', 'ahura' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'button_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-telegram',
                    'library' => 'fa-solid',
                ],
            ]
        );

        $repeater->add_control(
            'button_title',
            [
                'label' => esc_html__( 'Title', 'ahura' ),
                'type' => Controls_Manager::TEXT,
                'default' => __('Telegram', 'ahura'),
            ]
        );

        $repeater->add_control(
            'button_link',
            [
                'label' => esc_html__( 'Link', 'ahura' ),
                'label_block' => true,
                'type' => Controls_Manager::URL,
                'description' => __('Title: {{POST_TITLE}} / Link: {{POST_LINK}}', 'ahura'),
                'placeholder' => 'https://example.com/share/?url={{POST_LINK}}',
            ]
        );

        $repeater->add_control(
            'item_icon_color',
            [
                'label' => esc_html__( 'Icon Color', 'ahura' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} {{CURRENT_ITEM}} svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_bg_color',
                'label' => __( 'Background Color', 'ahura' ),
                'types' => [ 'classic', 'gradient' ],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} {{CURRENT_ITEM}}',
            ]
        );

        $this->add_control(
            'custom_buttons',
            [
                'label' => esc_html__( 'Buttons', 'ahura' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{button_title}}}',
                'condition' => ['use_custom_buttons' => 'yes']
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style',
            [
                'label' => esc_html__( 'Style', 'ahura' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'icon_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
				],
				'default' => 'start',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .ah-post-share-buttons-element' => 'justify-content: {{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
            'button_icon_size',
            [
                'label' => esc_html__( 'Icon Size', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ah-item svg, {{WRAPPER}} .ah-item img' => 'width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .ah-item i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__( 'Border radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ah-item' => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem', 'vw', 'custom' ],
                'selectors' => [
                    '{{WRAPPER}} .ah-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $buttons = (array) $settings['buttons'];
        ?>
        <div class="ah-post-share-buttons-element">
            <?php if(in_array('facebook', $buttons)): ?>
                <a class="ah-item" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url');?>/img/social/facebook.svg" alt="facebook"/></a>
            <?php endif; ?>
            <?php if(in_array('twitter', $buttons)): ?>
                <a class="ah-item" target="_blank" href="https://twitter.com/intent/tweet?text=<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url');?>/img/social/twitter.svg" alt="twitter"/></a>
            <?php endif; ?>
            <?php if(in_array('linkedin', $buttons)): ?>
                <a class="ah-item" target="_blank" href="https://linkedin.com/shareArticle?mini=true&url=&source=<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url');?>/img/social/linkedin.svg" alt="linkedin"/></a>
            <?php endif; ?>
            <?php if(in_array('telegram', $buttons)): ?>
                <a class="ah-item" target="_blank" href="https://telegram.me/share/url?url=<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url');?>/img/social/telegram.png" alt="telegram"/></a>
            <?php endif; ?>
            <?php if(in_array('pinterest', $buttons)): ?>
                <a class="ah-item" target="_blank" href="https://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url');?>/img/social/pinterest.svg" alt="pinterest"/></a>
            <?php endif; ?>
            <?php if(in_array('whatsapp', $buttons)): ?>
                <a class="ah-item" target="_blank" href="whatsapp://send?text=<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url');?>/img/social/whatsapp.svg" alt="whatsapp"/></a>
            <?php endif; ?>
            <?php if(in_array('email', $buttons)): ?>
                <a class="ah-item" target="_blank" href="mailto:?subject=<?php the_title() ?>&body=<?php the_permalink(); ?>"><img src="<?php bloginfo('template_url');?>/img/social/email.svg" alt="email"/></a>
            <?php endif; ?>
            <?php if ($settings['use_custom_buttons'] == 'yes'): ?>
                <?php
                foreach ($settings['custom_buttons'] as $button):
                    $button_link = $button['button_link']['url'];
                    $button_link = str_replace(['{{POST_LINK}}', '{{POST_TITLE}}'], [get_the_permalink(), get_the_title()], $button_link);
                    ?>
                    <a target="_blank" class="elementor-repeater-item-<?php echo $button['_id'] ?> ah-item" href="<?php echo $button_link ?>" title="<?php echo $button['button_title'] ?>">
                        <?php \Elementor\Icons_Manager::render_icon($button['button_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                    </a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
        <?php
    }
}