<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\woocommerce;
use \ahura\app\mw_assets;

class product_tab3 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * product_tab constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('product_tab_js', mw_assets::get_js('elementor.product_tab'));
        mw_assets::register_script('product_tab3_carousel', mw_assets::get_js('elementor.product_tab3_carousel'));
        wp_localize_script(mw_assets::get_handle_name('product_tab_js'), 'ahura_data', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'translate' => [
                'view_product' => __('View Product', 'ahura')
            ],
            'product_tab_name' => 3,
        ]);
    }

    public function __register_assets()
    {
        $this->register_elementor_style('product_tab3_css', mw_assets::get_css('elementor.product_tab3'));
    }

    public function get_script_depends()
    {
        return [ mw_assets::get_handle_name('product_tab3_carousel'), mw_assets::get_handle_name('product_tab_js') ];
    }
    
    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'product_tab3';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Product Tab 3', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'aicon-svg-product-tab';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements','ahura_woocommerce'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    function get_keywords()
    {
        return ['ahura', 'product tab', 'product', 'tab', esc_html__('ahura', 'ahura'), esc_html__('product', 'ahura'), esc_html__('Product Tab', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        /**
         *
         *
         * Start content
         *
         */
        $this->start_controls_section(
            'tabs_content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Tab Title', 'ahura'),
            ]
        );

        $repeater->add_control(
            'item_icon',
            [
                'label' => esc_html__('Icon', 'ahura'),
                'type' => Controls_Manager::ICONS,
                'skin' => 'inline',
                'exclude_inline_options' => ['svg'],
            ]
        );

        $taxonomies = get_taxonomies([
            'public' => true,
            'name' => 'product_cat',
        ], 'objects');

        $cats = array();
        if ($taxonomies) {
            foreach ($taxonomies as $key => $taxonomy) {
                if ($term_object = get_terms($key)) {
                    if($term_object){
                        foreach ($term_object as $term) {
                            $cats[$term->term_id] = "{$term->name} - {$taxonomy->labels->name}";
                        }
                    }
                }
            }
        }
        $repeater->add_control(
            'cat_id',
            [
                'label' => esc_html__('Categories', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $cats,
                'label_block' => true,
                'multiple' => true,
            ]
        );

        $repeater->add_control(
            'cat_type',
            [
                'label' => esc_html__('Categories type', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'newest' => esc_html__('Newest', 'ahura'),
                    'popular' => esc_html__('Most Popular', 'ahura'),
                    'most-sale' => esc_html__('Most Sale', 'ahura'),
                ],
                'default' => 'newest'
            ]
        );

        $repeater->add_control(
            'per_page',
            [
                'label' => esc_html__('Products Count', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 8,
                'min' => 1,
            ]
        );

        $this->add_control(
            'tab_items',
            [
                'label' => esc_html__('Items', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{item_title}}}',
                'default' => [
                    [
                        'item_title' => esc_html__('All', 'ahura'),
                        'item_archive_link' => ['url' => site_url()],
                    ]
                ]
            ]
        );

        $this->add_control(
            'show_variation_colors',
            [
                'label' => esc_html__( 'Show variations colors', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_product_button',
            [
                'label' => esc_html__( 'Show product button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
			'button_icon',
			[
				'label' => esc_html__( 'Button icon', 'ahura' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'fas fa-shopping-cart',
					'library' => 'fa-solid',
				],
                'condition' => [ 'show_product_button' => 'yes' ]
			]
		);
		
        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_section',
            [
                'label' => esc_html__('Slider', 'ahura'),
            ]
        );
        
        $this->add_control(
			'auto_play',
			[
				'label' => esc_html__( 'Auto Play', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'auto_play_speed',
			[
				'label' => esc_html__( 'Auto Play Speed', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 10000,
				'step' => 1,
				'default' => 1000,
                'condition' => ['auto_play' => 'yes']
			]
		);

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides per view', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    1 => '1',
                    2 => '2',
                    3 => '3',
                    4 => '4',
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => 3,
				'tablet_default' => 2,
				'mobile_default' => 1,
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('Arrows', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );
        
        $this->end_controls_section();
        /**
         *
         *
         * Start Styles
         *
         */
        $this->start_controls_section(
            'tab_items_style',
            [
                'label' => esc_html__('Tabs', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $alignment = [
            'start' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'end' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        ];

        $this->add_responsive_control(
            'box_tabs_align',
            [
                'label' => esc_html__('Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => (is_rtl()) ? 'start' : 'end',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .box-head > .row' => 'justify-content: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'item_tab_title_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_tab_title_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_tab_title_hover_color',
            [
                'label' => esc_html__('Active color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li.active a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'item_tab_title_hover_bgcolor',
            [
                'label' => esc_html__('Background active color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li.active a' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'item_tab_typo',
                'selector' => '{{WRAPPER}} .pt-tab-items ul li a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
            'item_tab_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_tab_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 10,
                    'right' => 15,
                    'bottom' => 10,
                    'left' => 15,
                ]
            ]
        );

        $this->add_responsive_control(
            'item_tab_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .pt-tab-items ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        /**
         *
         *
         * Products styles
         *
         *
         */
        $this->start_controls_section(
            'products_item_style',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'product_item_cover_height',
            [
                'label' => esc_html__('Cover Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 700
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 230,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .product-cover' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'product_item_bg_color',
            [
                'label' => esc_html__('Background', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .product-item' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'product_item_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .product-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .product-tab-3 .product-item .product-cover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 10,
                    'right' => 10,
                    'bottom' => 10,
                    'left' => 10,
                ]
            ]
        );

        $this->add_responsive_control(
            'product_item_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .product-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => false,
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                ]
            ]
        );

        $this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
            'product_title_height',
            [
                'label' => esc_html__('Product title height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 400
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-title' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'product_item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .product-item .product-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'product_item_title_typo',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .product-tab-3 .product-item .product-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ],
                ]
            ]
        );$alignment = [
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        ];
        
        $this->add_responsive_control(
            'product_title_alignment',
            [
                'label' => esc_html__('Product title alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => (is_rtl()) ? 'right' : 'left',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .product-item .product-title' => 'text-align: {{VALUE}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'product_title_padding',
            [
                'label' => esc_html__('Product title padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .product-item .product-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
			'price_options',
			[
				'label' => esc_html__( 'Price', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'product_item_price_color',
            [
                'label' => esc_html__('Price Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#1daf3c',
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .product-item .price-wrap .price' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'product_item_dis_price_color',
            [
                'label' => esc_html__('Discount Price Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#a9a9a9',
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .product-item .price-wrap .price del' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'product_item_price_typo',
                'label' => esc_html__('Price Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .product-tab-3 .product-item .price-wrap .price',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '14'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '300'
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
            'product_price_padding',
            [
                'label' => esc_html__('Product price padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .product-item .price-wrap .price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'image_options',
			[
				'label' => esc_html__( 'Image', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
            'product_image_bg_color',
            [
                'label' => esc_html__('Product image background', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#F6F6F8',
                'selectors' => [
                    '{{WRAPPER}} .product-cover img' => 'background-color: {{VALUE}}',
                ],
                'condition' => [ 'show_product_button' => 'yes' ]
            ]
        );
        
        $this->add_control(
			'product_image_padding',
			[
				'label' => esc_html__( 'Product image padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .product-cover img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'button_options',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_control(
            'product_button_bg_color',
            [
                'label' => esc_html__('Product button background', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#0063d1',
                'selectors' => [
                    '{{WRAPPER}} .product-button' => 'background-color: {{VALUE}}',
                ],
                'condition' => [ 'show_product_button' => 'yes' ]
            ]
        );
        
        $this->add_control(
            'product_button_color',
            [
                'label' => esc_html__('Product button color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .product-button svg' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .product-button svg' => 'fill: {{VALUE}}',
                ],
                'condition' => [ 'show_product_button' => 'yes' ]
            ]
        );

        $this->add_responsive_control(
            'product_button_width',
            [
                'label' => esc_html__('Product button width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 400
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-button' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [ 'show_product_button' => 'yes' ]
            ]
        );

        $this->add_responsive_control(
            'product_button_height',
            [
                'label' => esc_html__('Product button height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-button' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [ 'show_product_button' => 'yes' ]
            ]
        );

        $this->add_responsive_control(
            'product_button_fontsize',
            [
                'label' => esc_html__('Product button icon font-size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 15,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-button svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [ 'show_product_button' => 'yes' ]
            ]
        );
        
        $this->add_control(
			'product_button_radius',
			[
				'label' => esc_html__( 'Product button border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .product-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_product_button' => 'yes' ]
			]
		);
        
        $this->add_control(
			'product_button_padding',
			[
				'label' => esc_html__( 'Product button padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .product-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
                'condition' => [ 'show_product_button' => 'yes' ]
			]
		);
        
        $this->add_control(
			'variation_options',
			[
				'label' => esc_html__( 'Color variations', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'variations_list_hr',
			[
				'label' => esc_html__( 'Color variations HR position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .color-variations-list' => 'right: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_variation_colors' => 'yes' ]
			]
		);
        
        $this->add_responsive_control(
			'variations_list_vr',
			[
				'label' => esc_html__( 'Color variations VR position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .color-variations-list' => 'top: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_variation_colors' => 'yes' ]
			]
		);

        $this->add_control(
			'variations_circle_size',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .color-variations-list li' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        /**
         *
         *
         * Box styles
         *
         *
         */
        $this->start_controls_section(
            'tab_box_wrap_style',
            [
                'label' => esc_html__('Box', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'tabs_wrap_bg_color',
            [
                'label' => esc_html__('Background Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#0063D1',
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .pt-tabs-content' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'tabs_wrap_text_color',
            [
                'label' => esc_html__('Inner box text color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .tab-content-inner-title li' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .tab-content-inner-title a' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_inner_title_typo',
                'label' => esc_html__('Inner title typography', 'ahura'),
                'selector' => '{{WRAPPER}} .tab-content-inner-title li',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ],
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'box_link_typo',
                'label' => esc_html__('Category link typography', 'ahura'),
                'selector' => '{{WRAPPER}} .tab-content-inner-title li a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '21'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ],
                ]
            ]
        );

        $this->add_responsive_control(
            'tabs_wrap_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => true,
				],
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .pt-tabs-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tabs_wrap_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
				'default' => [
					'top' => 40,
					'right' => 40,
					'bottom' => 40,
					'left' => 40,
					'unit' => 'px',
					'isLinked' => true,
				],
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .pt-tabs-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'tabs_wrap_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'top' => 20,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .product-tab-3 .pt-tabs-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_style',
            [
                'label' => esc_html__('Slider', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'active_pagination_color',
			[
				'label' => esc_html__( 'Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet.swiper-pagination-bullet-active' => 'background-color:{{VALUE}};color:{{VALUE}}',
				],
			]
		);
        
        $this->add_control(
			'notactive_pagination_color',
			[
				'label' => esc_html__( 'Not-Active pagination color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet' => 'background-color:{{VALUE}};opacity:1',
				],
			]
		);

        $pagination_style_default = 'border-radius: 100%';
        $pagination_style1 = 'border-radius: 5px;';

        $this->add_control(
			'pagination_styles',
			[
				'label' => esc_html__( 'Active pagination style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => $pagination_style_default,
				'options' => [
					$pagination_style_default => esc_html__( 'Default', 'ahura' ),
					$pagination_style1 => esc_html__( 'Style 1', 'ahura' ),
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => '{{VALUE}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_style1_width',
			[
				'label' => esc_html__( 'Style1 width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 100,
						'step' => 1,
					],
				],
				'condition' => [ 'show_pagination' => 'yes', 'pagination_styles' => $pagination_style1 ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination .swiper-pagination-bullet-active' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_vertical_position',
			[
				'label' => esc_html__( 'Pagination vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -50,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination' => 'bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_width',
			[
				'label' => esc_html__( 'Pagination size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 5,
						'max' => 50,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'condition' => [ 'show_pagination' => 'yes' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'width:{{SIZE}}{{UNIT}};height:{{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render_link_attrs($url_data, $status)
    {
        if($status == 'yes') {
            $target = $url_data['is_external'] ? 'target="_blank"' : '';
            $nofollow = $url_data['nofollow'] ? 'rel="nofollow"' : '';
            $cu_attr = $url_data['custom_attributes'] ? $url_data['custom_attributes'] : false;
            $data = 'href="' . $url_data['url'] . '" ' . $target . ' ' . $nofollow . ' ' . $cu_attr;
            echo $data;
        } else {
            echo 'href="#"';
        }
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $items = $settings['tab_items'];
        $has_paginate = ($settings['show_pagination'] == 'yes');
        $has_arrows = ($settings['show_arrow'] == 'yes');

        if(!\ahura\app\woocommerce::is_active()){
            return false;
        }

        $slider_data = [
            'widgetID' => $wid,
            'autoPlayStatus' => $settings['auto_play'] === 'yes',
            'playDelay' => $settings['auto_play'] === 'yes' ? $settings['auto_play_speed'] : 99999,
            'desktopPerView' => (isset($settings['slides_per_view']) && intval($settings['slides_per_view'])) ? $settings['slides_per_view'] : 3,
            'tabletPerView' => (isset($settings['slides_per_view_tablet']) && intval($settings['slides_per_view_tablet'])) ? $settings['slides_per_view_tablet'] : 2,
            'mobilePerView' => (isset($settings['slides_per_view_mobile']) && intval($settings['slides_per_view_mobile'])) ? $settings['slides_per_view_mobile'] : 1,
            'pagination' => $has_paginate,
            'arrows' => $has_arrows,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        if ($items): ?>
            <div class="product-tab-3-wrap product-tab-3-wrap-<?php echo $wid ?>">
                <div class="product-tab-3">
                    <div class="box-head">
                        <div class="row align-items-center">
                            <div class="pt-tab-items">
                                <ul>
                                    <?php $i = 0;
                                    foreach ($items as $item):
                                        $first = ($i === 0);
                                        $activeCls = $first ? 'active' : '';
                                        $data = array('category' => $item['cat_id'], 'num' => $item['per_page']);
                                        $i++;
                                        ?>
                                        <li class="elementor-repeater-item-<?php echo $item['_id'] . '-' . $wid . ' ' . $activeCls; ?>">
                                            <a href="#" class="pt-item-btn ah-has-bg ah-has-text" id="tab-item-<?php echo $item['_id'] . '-' . $wid ?>" data-wid="<?php echo $wid ?>" data-tab="#tab-content-<?php echo $item['_id'] . '-' . $wid ?>" data-settings="<?php echo base64_encode(json_encode($data)) ?>">
                                                <?php \Elementor\Icons_Manager::render_icon( $item['item_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                                <?php echo $item['item_title'] ?>
                                                <div class="ahura-loader-ring"></div>
                                            </a>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="pt-tabs-content">
                        <?php $i = 0;
                        foreach ($items as $item):
                            $firstWrap = ($i === 0);
                            $activeCls = $firstWrap ? 'active' : '';
                            $i++; ?>
                            <div class="pt-tab-content-wrap elementor-repeater-item-<?php echo $item['_id'] . '-' . $wid . ' ' . $activeCls; ?>" id="tab-content-<?php echo $item['_id'] . '-' . $wid ?>" style="display:<?php echo $firstWrap ? 'block' : 'none' ?>">
                                    <ul class="row tab-content-inner-title">
                                        <li><?php echo $item['item_title']; ?></li>
                                        <?php $cat_id = isset($item['cat_id'][0]) ? $item['cat_id'][0] : '';
                                        if (is_string($cat_id)) $cat_id = intval($cat_id); ?>
                                        <a href="<?php echo is_numeric($cat_id) && $cat_id > 0 ? get_term_link($cat_id, 'product_cat') : esc_url(get_permalink(wc_get_page_id('shop'))); ?>"><?php echo __('View All', 'ahura'); ?></a>
                                    </ul>
                                <div class="row pt-tab-content">
                                        <?php $args = [
                                            'post_type' => 'product',
                                            'posts_per_page' => $item['per_page'],
                                            'post_status' => 'publish'
                                        ];
                                        switch ($item['cat_type']) {
                                            case 'newest':
                                                $args['orderby'] = 'date';
                                                $args['order']   = 'DESC';
                                                break;
                                            case 'popular':
                                                $args['meta_key'] = '_wc_average_rating';
                                                $args['orderby']  = 'meta_value_num';
                                                $args['order']    = 'DESC';
                                                break;
                                            case 'most-sale':
                                                $args['meta_key'] = 'total_sales';
                                                $args['orderby'] = 'meta_value_num';
                                                break;
                                            default: break;
                                        }
                                        if ($item['cat_id']) {
                                            $args['tax_query'] = array(
                                                'tax_query' => [
                                                    'relation' => 'OR',
                                                    [
                                                        'taxonomy' => 'product_cat',
                                                        'field' => 'term_id',
                                                        'terms' => $item['cat_id'],
                                                    ]
                                                ]
                                            );
                                        }
                                    $products = new \WP_Query($args); ?>
                                    <div class="swiper swiper-product-tab3 product-tab3-swiper product-tab3-swiper-<?php echo $wid; ?>" data-slider='<?php echo json_encode($slider_data) ?>'>
                                        <div class="swiper-wrapper">
                                            <?php while ( $products->have_posts() ) : $products->the_post(); ?>
                                                <div class="swiper-slide elementor-repeater-item-<?php echo $wid; ?>">
                                                    <div class="items-carousel-content">
                                                    <?php global $product;
                                                    $carousel_type = 'product_tab3';
                                                    include get_template_directory() .'/template-parts/loop/elementor/product-tab-load-ajax.php'; ?>
                                                    </div>
                                                </div>
                                            <?php endwhile; ?>
                                            <?php wp_reset_query(); ?>
                                            <?php wp_reset_postdata(); ?>
                                        </div>
                                        <?php if($has_arrows): ?>
                                            <div class="items-carousel-button-prev"><i class="fa fa-chevron-left"></i></div>
                                            <div class="items-carousel-button-next"><i class="fa fa-chevron-right"></i></div>
                                        <?php endif; ?>
                                        <?php if($has_paginate): ?>
                                            <div class="swiper-pagination w-100"></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php
        endif;
    }
}
