<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use \ahura\app\mw_assets;

class post_tab extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('post_tab_carousel', mw_assets::get_js('elementor.post_tab_carousel'));
        mw_assets::register_script('post_tab_js', mw_assets::get_js('elementor.post_tab'));
        wp_localize_script(mw_assets::get_handle_name('post_tab_js'), 'ahura_data', [
            'ajax_url' => admin_url('admin-ajax.php'),
        ]);
    }

    public function __register_assets()
    {
        $this->register_elementor_style('post_tab_css', mw_assets::get_css('elementor.post_tab'));
    }

    public function get_script_depends()
    {
        return [ mw_assets::get_handle_name('post_tab_carousel'), mw_assets::get_handle_name('post_tab_js') ];
    }
    
    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'post_tab';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Post Tab', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'aicon-svg-product-tab';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements','ahura_woocommerce'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    function get_keywords()
    {
        return ['ahura', 'post tab', 'post', 'tab', esc_html__('ahura', 'ahura'), esc_html__('Post', 'ahura'), esc_html__('Post Tab', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        /**
         *
         *
         * Start content
         *
         */
        $this->start_controls_section(
            'tabs_content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Tab Title', 'ahura'),
            ]
        );

        $repeater->add_control(
            'item_icon',
            [
                'label' => esc_html__('Icon', 'ahura'),
                'type' => Controls_Manager::ICONS,
                'skin' => 'inline',
                'exclude_inline_options' => ['svg'],
            ]
        );

        $taxonomies = get_taxonomies([
            'public' => true,
            'name' => 'category',
        ], 'objects');

        $cats = array();
        if ($taxonomies) {
            foreach ($taxonomies as $key => $taxonomy) {
                if ($term_object = get_terms($key)) {
                    if($term_object){
                        foreach ($term_object as $term) {
                            $cats[$term->term_id] = "{$term->name} - {$taxonomy->labels->name}";
                        }
                    }
                }
            }
        }
        $repeater->add_control(
            'cat_id',
            [
                'label' => esc_html__('Categories', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $cats,
                'label_block' => true,
                'multiple' => true,
            ]
        );

        $repeater->add_control(
            'cat_type',
            [
                'label' => esc_html__('Categories type', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'DESC' => esc_html__('Newest', 'ahura'),
                    'ASC' => esc_html__('Oldest', 'ahura'),
                ],
                'default' => 'DESC'
            ]
        );

        $repeater->add_control(
            'per_page',
            [
                'label' => esc_html__('Products Count', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 8,
                'min' => 1,
            ]
        );

        $this->add_control(
            'tab_items',
            [
                'label' => esc_html__('Items', 'ahura'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{item_title}}}',
                'default' => [
                    [
                        'item_title' => esc_html__('All', 'ahura'),
                        'item_archive_link' => ['url' => site_url()],
                    ]
                ]
            ]
        );
		
        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_section',
            [
                'label' => esc_html__('Slider', 'ahura'),
            ]
        );
        
        $this->add_control(
			'auto_play',
			[
				'label' => esc_html__( 'Auto Play', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'yes', 'ahura' ),
				'label_off' => esc_html__( 'no', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'auto_play_speed',
			[
				'label' => esc_html__( 'Auto Play Speed', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 10000,
				'step' => 1,
				'default' => 1000,
                'condition' => ['auto_play' => 'yes']
			]
		);

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_arrow',
            [
                'label' => esc_html__('Arrows', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );
        
        $this->end_controls_section();

        /**
         *
         *
         * Start Styles
         *
         */

        $this->start_controls_section(
            'header_style',
            [
                'label' => esc_html__('Header', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'head_options',
			[
				'label' => esc_html__( 'Head', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'tab_alignment',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__( is_rtl() ? 'Right' : 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-' . ( is_rtl() ? 'right' : 'left' ),
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__( is_rtl() ? 'Left' : 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-' . ( is_rtl() ? 'left' : 'right' ),
					],
				],
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items' => 'justify-content: {{VALUE}};',
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul' => 'justify-content: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'head_border_color',
			[
				'label' => esc_html__( 'Header border color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#11111114',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul' => 'border: 1px solid {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'head_margin',
			[
				'label' => esc_html__( 'Header margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 80,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .box-head' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'head_padding',
			[
				'label' => esc_html__( 'Header padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'head_radius',
			[
				'label' => esc_html__( 'Head border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'tab_options',
			[
				'label' => esc_html__( 'Tabs', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$alignmentOptions = [
			'right' => [
				'title' => esc_html__( 'Right', 'ahura' ),
				'icon' => 'eicon-text-align-right',
			],
			'center' => [
				'title' => esc_html__( 'Center', 'ahura' ),
				'icon' => 'eicon-text-align-center',
			],
			'left' => [
				'title' => esc_html__( 'Left', 'ahura' ),
				'icon' => 'eicon-text-align-left',
			],
		];

		if (!is_rtl()) {
			$alignmentOptions = array_reverse($alignmentOptions);
		}

		$this->add_responsive_control(
			'tab_item_alignment',
			[
				'label' => esc_html__( 'Item alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => $alignmentOptions,
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items li a' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'tab_item_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '16'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ]
                ],
				'selector' => '{{WRAPPER}} .post-tab-wrap .pt-tab-items ul li a',
			]
		);

        $this->add_control(
			'head_tab_color',
			[
				'label' => esc_html__( 'Item color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#111111',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul li a' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'active_tab_background_color',
			[
				'label' => esc_html__( 'Active item background-color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#444BFF',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul li.active' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'active_tab_color',
			[
				'label' => esc_html__( 'Active item color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul li.active a' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'tab_margin',
			[
				'label' => esc_html__( 'Tab margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'tab_item_padding',
			[
				'label' => esc_html__( 'Tab item padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 10,
					'bottom' => 5,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'tab_item_radius',
			[
				'label' => esc_html__( 'Tab item border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_width',
			[
				'label' => esc_html__( 'Item width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .pt-tab-items ul li' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_style',
            [
                'label' => esc_html__('Item', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'heading_options',
			[
				'label' => esc_html__( 'Heading', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'item_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 510,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .post-item .post-container' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .post-item .post-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'item_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 30,
					'right' => 30,
					'bottom' => 30,
					'left' => 30,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .post-item .post-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'post_header_options',
			[
				'label' => esc_html__( 'Post header', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'post_header_padding',
			[
				'label' => esc_html__( 'Post header padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 40,
					'right' => 40,
					'bottom' => 0,
					'left' => 40,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .post-item .post-container .el-post-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'post_date_typography',
				'selector' => '{{WRAPPER}} .post-tab-wrap .post-date',
			]
		);

        $this->add_control(
			'post_date_color',
			[
				'label' => esc_html__( 'Date color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .post-date' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'post_time_typography',
				'selector' => '{{WRAPPER}} .post-tab-wrap .post-time-estimation',
			]
		);

        $this->add_control(
			'post_time_color',
			[
				'label' => esc_html__( 'Est. time color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .post-time-estimation' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'post_footer_options',
			[
				'label' => esc_html__( 'Post footer', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'post_footer_background_color',
			[
				'label' => esc_html__( 'Footer background-color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(0, 0, 0, 0.25)',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'post_footer_border_radius',
			[
				'label' => esc_html__( 'Footer border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'footer_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 135,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'post_footer_padding',
			[
				'label' => esc_html__( 'Footer padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'footer_width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 75,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'post_footer_margin',
			[
				'label' => esc_html__( 'Footer margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => -90,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'footer_backdrop_filter',
			[
				'label' => esc_html__( 'Backdrop filter', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer' => 'backdrop-filter: blur({{SIZE}}{{UNIT}});',
				],
			]
		);

		$this->add_responsive_control(
			'post_title_alignment',
			[
				'label' => esc_html__( 'Title alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => $alignmentOptions,
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer .post-title-container' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'post_title_color',
			[
				'label' => esc_html__( 'Post title color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer .post-title' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'post_title_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '32'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '700'
                    ]
                ],
				'selector' => '{{WRAPPER}} .post-tab-wrap .el-post-footer .post-title',
			]
		);

        $this->add_responsive_control(
			'post_title_padding',
			[
				'label' => esc_html__( 'Title padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 15,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer .post-title-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'post_excerpt_alignment',
			[
				'label' => esc_html__( 'Excerpt alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => $alignmentOptions,
				'default' => 'center',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer .post-excerpt' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_control(
			'post_excerpt_color',
			[
				'label' => esc_html__( 'Post excerpt color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .el-post-footer .post-excerpt' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'post_excerpt_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '18'
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} .post-tab-wrap .el-post-footer .post-excerpt',
			]
		);
        
        $this->end_controls_section();

        $this->start_controls_section(
            'slider_style',
            [
                'label' => esc_html__('Slider', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'general_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'slider_padding',
			[
				'label' => esc_html__( 'Slider padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 100,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .swiper.post-tab-swiper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'controllers_options',
			[
				'label' => esc_html__( 'Controllers', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'pagination_bullet_margin',
			[
				'label' => esc_html__( 'Pagination bullet margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 3,
					'bottom' => 0,
					'left' => 3,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .swiper-pagination-bullet' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_width',
			[
				'label' => esc_html__( 'Pagination width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 14,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'arrow_v_position',
			[
				'label' => esc_html__( 'Arrow vertical position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap div[class^="items-carousel-button-"]' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'next_arrow_h_position',
			[
				'label' => esc_html__( 'Next arrow h-position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 25,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .items-carousel-button-next' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'prev_arrow_v_position',
			[
				'label' => esc_html__( 'Previous arrow v-position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -200,
						'max' => 500,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 25,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .items-carousel-button-prev' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'arrow_color',
			[
				'label' => esc_html__( 'Arrow color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap div[class^="items-carousel-button-"] i' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'arrow_background_color',
			[
				'label' => esc_html__( 'Arrow background-color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#444BFF80',
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap div[class^="items-carousel-button-"] i' => 'background-color: {{VALUE}}',
				],
			]
		);
        $this->add_responsive_control(
			'arrow_width',
			[
				'label' => esc_html__( 'Arrow width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 35,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap div[class^="items-carousel-button-"] i' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'arrow_border_radius',
			[
				'label' => esc_html__( 'Arrow border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 10,
					'right' => 10,
					'bottom' => 10,
					'left' => 10,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap div[class^="items-carousel-button-"] i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_margin',
			[
				'label' => esc_html__( 'Pagination margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .post-tab-wrap .swiper-pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();

        $this->register_additional_controls();
    }

    protected function render_link_attrs($url_data, $status)
    {
        if($status == 'yes') {
            $target = $url_data['is_external'] ? 'target="_blank"' : '';
            $nofollow = $url_data['nofollow'] ? 'rel="nofollow"' : '';
            $cu_attr = $url_data['custom_attributes'] ? $url_data['custom_attributes'] : false;
            $data = 'href="' . $url_data['url'] . '" ' . $target . ' ' . $nofollow . ' ' . $cu_attr;
            echo $data;
        } else {
            echo 'href="#"';
        }
    }

    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $items = $settings['tab_items'];
        $has_paginate = ($settings['show_pagination'] == 'yes');
        $has_arrows = ($settings['show_arrow'] == 'yes');

        $slider_data = [
            'widgetID' => $wid,
            'autoPlayStatus' => $settings['auto_play'] === 'yes',
            'playDelay' => $settings['auto_play'] === 'yes' ? $settings['auto_play_speed'] : 99999,
            'pagination' => $has_paginate,
            'arrows' => $has_arrows,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        if ($items): ?>
            <div class="post-tab-wrap post-tab-wrap-<?php echo $wid ?>" data-slider='<?php echo json_encode($slider_data) ?>'>
                <div class="post-tab">
                    <div class="box-head">
                        <div class="d-flex align-items-center pt-tab-items w-100">
                            <ul class="d-flex flex-wrap">
                                <?php $i = 0;
                                foreach ($items as $item):
                                    $first = ($i === 0);
                                    $activeCls = $first ? 'active' : '';
                                    $data = array('category' => $item['cat_id'], 'num' => $item['per_page'], 'order' => $item['cat_type'],);
                                    $i++; ?>
                                    <li class="d-flex justify-content-center align-items-center elementor-repeater-item-<?php echo $item['_id'] . '-' . $wid . ' ' . $activeCls; ?>">
                                        <a href="#" class="pt-item-btn ah-has-bg ah-has-text w-100" id="tab-item-<?php echo $item['_id'] . '-' . $wid ?>" data-wid="<?php echo $wid ?>" data-tab="#tab-content-<?php echo $item['_id'] . '-' . $wid ?>" data-settings="<?php echo base64_encode(json_encode($data)) ?>">
                                            <?php \Elementor\Icons_Manager::render_icon( $item['item_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                                            <?php echo $item['item_title'] ?>
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>
                    <div class="pt-tabs-content">
                        <?php $i = 0;
                        foreach ($items as $item):
                            $firstWrap = ($i === 0);
                            $activeCls = $firstWrap ? 'active' : '';
                            $i++; ?>
                            <div class="pt-tab-content-wrap elementor-repeater-item-<?php echo $item['_id'] . '-' . $wid . ' ' . $activeCls; ?>" id="tab-content-<?php echo $item['_id'] . '-' . $wid ?>" style="display:<?php echo $firstWrap ? 'block' : 'none' ?>">
                                <div class="row pt-tab-content">
                                        <?php $args = [
                                            'post_type' => 'post',
                                            'posts_per_page' => $item['per_page'],
											'order' => $item['cat_type'],
                                            'post_status' => 'publish',
                                        ];
                                        if ($item['cat_id']) {
                                            $args['tax_query'] = array(
                                                'tax_query' => [
                                                    'relation' => 'OR',
                                                    [
                                                        'taxonomy' => 'category',
                                                        'field' => 'term_id',
                                                        'terms' => $item['cat_id'],
                                                    ]
                                                ]
                                            );
                                        }
                                    $post = new \WP_Query($args); ?>
                                    <div class="swiper swiper-post-tab post-tab-swiper post-tab-swiper-<?php echo $wid; ?> w-100">
                                        <div class="swiper-wrapper">
                                            <?php while ( $post->have_posts() ) : $post->the_post(); ?>
                                                <div class="swiper-slide elementor-repeater-item-<?php echo $wid; ?>">
                                                    <div class="items-carousel-content">
                                                    <?php
                                                    include get_template_directory() .'/template-parts/loop/elementor/post-tab-load-ajax.php'; ?>
                                                    </div>
                                                </div>
                                            <?php endwhile; ?>
                                            <?php wp_reset_query(); ?>
                                            <?php wp_reset_postdata(); ?>
                                        </div>
                                        <?php if($has_arrows): ?>
                                            <div class="items-carousel-button-prev"><i class="fa fa-chevron-left d-flex justify-content-center align-items-center "></i></div>
                                            <div class="items-carousel-button-next"><i class="fa fa-chevron-right d-flex justify-content-center align-items-center "></i></div>
                                        <?php endif; ?>
                                        <?php if($has_paginate): ?>
                                            <div class="swiper-pagination w-100"></div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php
        endif;
    }
}
