<?php
namespace ahura\inc\widgets;

// Block direct access to the main plugin file.
defined('ABSPATH') or die('No script kiddies please!');

use ahura\app\mw_assets;
use ahura\app\Post_Meta;
use Elementor\Controls_Manager;

class post_carousel9 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_swiper_assets(true);
        mw_assets::register_script('post_carousel9_js', mw_assets::get_js('elementor.post_carousel9'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('post_carousel9_css', mw_assets::get_css('elementor.post_carousel9'));
        if(!is_rtl()){
            $this->register_elementor_style('post_carousel9_ltr_css', mw_assets::get_css('elementor.ltr.post_carousel9_ltr'));
        }
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('post_carousel9_js')];
    }

    public function get_name()
    {
        return 'ahura_post_carousel_9';
    }

    public function get_title()
    {
        return __('Post Carousel 9', 'ahura');
    }

    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }

    public function get_keywords()
    {
        return ['ahura', 'post', 'post carousel 9', esc_html__('ahura', 'ahura'), esc_html__( 'Post Carousel 9' , 'ahura')];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_type',
            [
                'label'    => __('Show Type', 'ahura'),
                'type'     => \Elementor\Controls_Manager::SELECT,
                'options'  => [
                    'latest' => __('Latest Posts', 'ahura'),
                    'category' => __('Categories', 'ahura'),
                ],
                'label_block' => true,
                'default' => 'latest'
            ]
        );

        $categories = get_categories();
        $cats       = array();
        if ($categories){
            foreach ($categories as $category) {
                $cats[$category->term_id] = $category->name;
            }
        }
        $default = key($cats);

        $this->add_control(
            'cat_ids',
            [
                'label'    => __('Categories', 'ahura'),
                'type'     => \Elementor\Controls_Manager::SELECT2,
                'options'  => $cats,
                'label_block' => true,
                'multiple' => true,
                'default' => $default,
                'condition' => ['show_type' => 'category']
            ]
        );

        $this->add_control(
            'posts_order',
            [
                'label' => __('Sort', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'default' => 'DESC',
                'options' => [
                    'ASC' => [
                        'title' => __('Ascending', 'ahura'),
                        'icon' => 'eicon-sort-up'
                    ],
                    'DESC' => [
                        'title' => __('Descending', 'ahura'),
                        'icon' => 'eicon-sort-down'
                    ],
                ],
                'toggle' => true,
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label'      => __('Number of posts', 'ahura'),
                'type'       => \Elementor\Controls_Manager::NUMBER,
                'default'    => 4
            ]
        );

		$this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Button text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'readmore_text',
			[
				'label' => esc_html__( 'Read more text', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

        $this->add_control(
            'excerpt_chars_count',
            [
                'label'   => __( 'Excerpt Characters', 'ahura' ),
                'type'    => Controls_Manager::NUMBER,
                'default' => 30,
            ]
        );

		$this->add_control(
			'show_overlay',
			[
				'label' => esc_html__( 'Overlay', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->add_control(
			'show_glowing',
			[
				'label' => esc_html__( 'Glowing', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_section',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'slides_per_view',
            [
                'label' => esc_html__('Slides Per View', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 1,
                'tablet_default' => 1,
                'mobile_default' => 1,
                'options' => [
                    '1' => 1,
                    '2' => 2,
                    '3' => 3,
                    '4' => 4,
                    '5' => 5,
                    '6' => 6,
                    '7' => 7,
                    '8' => 8,
                ]
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label' => esc_html__( 'Autoplay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'autoplay_delay',
            [
                'label' => esc_html__( 'Autoplay delay', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 100,
                'max' => 10000,
                'step' => 1,
                'default' => 4000,
                'condition' => ['autoplay' => 'yes']
            ]
        );

        $this->add_control(
            'slide_margin',
            [
                'label' => esc_html__( 'Slides Space', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'max' => 200,
                'step' => 1,
                'default' => 25,
            ]
        );

        $this->add_control(
            'use_observer_slider',
            [
                'label' => esc_html__('Inner Slider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('If you use the slider internally (tab, ...) and its display is not direct, be sure to activate this option.', 'ahura')
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'box_styles',
            [
                'label' => __( 'Box', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 150,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .swiper-slide' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_styles',
            [
                'label' => __( 'Item', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'general_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
            'item_height',
            [
                'label' => esc_html__('height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 600,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-item' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'rem',
                    'top' => 3,
                    'right' => 2,
                    'bottom' => 3,
                    'left' => 2,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 28,
                    'right' => 28,
                    'bottom' => 28,
                    'left' => 28,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'categories_options',
			[
				'label' => esc_html__( 'Category', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
            'categories_margin',
            [
                'label' => esc_html__('Categories margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 15,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-categories' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'cat_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-categories a.category-link' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'cat_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#6C5DD3',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-categories a.category-link' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
            'cat_margin',
            [
                'label' => esc_html__('Category margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 0,
                    'right' => is_rtl() ? 0 : 10,
                    'bottom' => 0,
                    'left' => is_rtl() ? 10 : 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-categories a.category-link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'cat_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 5,
                    'right' => 12,
                    'bottom' => 5,
                    'left' => 12,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-categories a.category-link' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'cat_border_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-categories a.category-link' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'cat_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '700'
                    ]
                ],
				'selector' => '{{WRAPPER}} .post-carousel-9 .post-categories a.category-link',
			]
		);

        $this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'title_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => is_rtl() ? 'right' : 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-item h3' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '28'
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} .post-carousel-9 .post-item h3',
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-item h3' => 'color: {{VALUE}}',
				],
			]
		);
        
        $this->add_responsive_control(
			'title_height',
			[
				'label' => esc_html__( 'Min height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 120,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-item h3' => 'min-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 10,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-item h3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
			'desc_options',
			[
				'label' => esc_html__( 'Description', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'desc_align',
			[
				'label' => esc_html__( 'Alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__( 'Left', 'ahura' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', 'ahura' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__( 'Right', 'ahura' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => is_rtl() ? 'right' : 'left',
				'toggle' => true,
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-item .post-desc' => 'text-align: {{VALUE}};',
				],
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'desc_typography',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17'
                        ]
                    ],
                    'line_height' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '26'
                        ]
                    ],
                ],
				'selector' => '{{WRAPPER}} .post-carousel-9 .post-item .post-desc',
			]
		);

        $this->add_control(
			'desc_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-item .post-desc' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
            'desc_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 40,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-item .post-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_control(
			'button_options',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-item .post-button' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'button_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#6C5DD3',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-item .post-button' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
            'button_border_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 20,
                    'right' => 20,
                    'bottom' => 20,
                    'left' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-item .post-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 15,
                    'right' => 25,
                    'bottom' => 15,
                    'left' => 25,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-item .post-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'slider_styles',
            [
                'label' => __( 'Slider', 'ahura' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
        
        $this->add_control(
			'nav_options',
			[
				'label' => esc_html__( 'Navigation', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
        
        $this->add_responsive_control(
			'nav_top_position',
			[
				'label' => esc_html__( 'Top position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -800,
						'max' => 800,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .swiper-nav' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'nav_left_position',
			[
				'label' => esc_html__( 'Left position', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => -800,
						'max' => 800,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .swiper-nav' => 'left: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'nav_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#242731',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .swiper-nav .swiper-nav-button' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'nav_backcolor',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .swiper-nav .swiper-nav-button' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
            'nav_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 5,
                    'right' => 5,
                    'bottom' => 5,
                    'left' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .swiper-nav .swiper-nav-button' => 'Margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
			'nav_width',
			[
				'label' => esc_html__( 'Wrapper size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .swiper-nav .swiper-nav-button' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'nav_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 100,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .swiper-nav .swiper-nav-button' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'nav_icon_size',
			[
				'label' => esc_html__( 'Icon size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 22,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .swiper-nav .swiper-nav-button i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'overlay_options',
			[
				'label' => esc_html__( 'Overlay', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_overlay' => 'yes' ]
			]
		);
        
        $this->add_responsive_control(
			'overlay_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 250,
				],
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-item-overlay' => 'height: {{SIZE}}{{UNIT}};',
				],
                'condition' => [ 'show_overlay' => 'yes' ]
			]
		);
        
        $this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'overlay_background',
				'types' => [ 'classic', 'gradient', 'video' ],
				'selector' => '{{WRAPPER}} .post-carousel-9 .post-item-overlay',
                'condition' => [ 'show_overlay' => 'yes' ]
			]
		);

        $this->add_responsive_control(
            'overlay_border_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'unit' => 'px',
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 28,
                    'left' => 28,
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-carousel-9 .post-item-overlay' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [ 'show_overlay' => 'yes' ]
            ]
        );
        
        $this->add_control(
			'glowing_options',
			[
				'label' => esc_html__( 'Glowing', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'show_glowing' => 'yes' ]
			]
		);

        $this->add_control(
			'glowing_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .post-carousel-9 .post-item-glowing' => 'box-shadow: 0px 10px 100px 130px {{VALUE}}',
				],
                'condition' => [ 'show_glowing' => 'yes' ]
			]
		);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $cat_ids   = $settings['cat_ids'];
        $show_type = $settings['show_type'];
        $chars_num = isset($settings['excerpt_chars_count']) && intval($settings['excerpt_chars_count']) ? $settings['excerpt_chars_count'] : 35;
        $custom_readmore_text = !empty($settings['readmore_text']) ? '<span class="read-more">' . $settings['readmore_text'] . '</span>' : '...';

        $sliderData = [
            'autoplay' => $settings['autoplay'] == 'yes',
            'delay' => $settings['autoplay_delay'] ?? 4000,
            'perView' => $settings['slides_per_view'] ?? 1,
            'tabletPerView' => $settings['slides_per_view_tablet'] ?? 1,
            'mobilePerView' => $settings['slides_per_view_mobile'] ?? 1,
            'observer' => $settings['use_observer_slider'] == 'yes'
        ];

        $args = [
            'posts_per_page' => $settings['post_count'],
            'post_status' => 'publish',
            'order' => $settings['posts_order'] ?? 'DESC'
        ];

        if($show_type == 'category'){
            $args['cat'] = ahura_sanitize_categories($cat_ids);
        }

        $posts = new \WP_Query($args);

        if (!$posts->have_posts())
            return false;
        ?>
        <div class="post-carousel-9 is-<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
            <div class="carousel-items">
                <div class="swiper items-slider" data-slider='<?php echo json_encode($sliderData) ?>' dir="<?php echo is_rtl() ? 'rtl' : 'ltr' ?>">
                    <div class="swiper-wrapper">
                        <?php while ($posts->have_posts()) : $posts->the_post();
                            $large_cover = get_post_meta(get_the_ID(), '_large_cover', true);
                            $cover = !empty($large_cover) ? $large_cover : get_the_post_thumbnail_url(get_the_ID(),'full');
                            $categories = Post_Meta::get_category_list(get_the_ID()); ?>
                            <div class="swiper-slide">
                                <div class="d-flex align-items-end post-item" style="background-image:url(<?php echo $cover ?>)">
                                    <div class="post-content-wrap">
                                        <?php if (!empty($categories)): ?>
                                            <div class="d-flex justify-content-start align-items-center post-categories meta">
                                                <?php
                                                foreach ($categories as $category) {
                                                    $categoryLink = get_term_link($category->term_id);
                                                    echo '<a href="' . esc_url($categoryLink) . '" class="category-link">' . htmlspecialchars($category->name) . '</a>';
                                                }
                                                ?>
                                            </div>
                                        <?php endif; ?>
                                        <h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                        <p class="post-desc">
                                            <?php
                                            if($chars_num || $custom_readmore_text){
                                                echo wp_trim_words(get_the_excerpt(), $chars_num, $custom_readmore_text);
                                            } else {
                                                the_excerpt();
                                            }
                                            ?>
                                        </p>
                                        <?php if(!empty($settings['button_text'])): ?>
                                            <a href="<?php the_permalink(); ?>" class="post-button"><?php echo sanitize_text_field($settings['button_text']); ?></a>
                                        <?php endif; ?>
                                    </div>
                                    <?php if($settings['show_overlay'] === 'yes'): ?>
                                        <div class="post-item-overlay"></div>
                                    <?php endif; ?>
                                    <?php if($settings['show_glowing'] === 'yes'): ?>
                                        <div class="post-item-glowing"></div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endwhile; ?>
                    </div>
                    <div class="swiper-nav">
                        <div class="swiper-nav-button swiper-btn-prev"><i class="fas fa-angle-right"></i></div>
                        <div class="swiper-nav-button swiper-btn-next"><i class="fas fa-angle-left"></i></div>
                    </div>
                </div>
            </div>
        </div>
        <?php wp_reset_postdata(); ?>
        <?php
    }
}
