<?php

namespace ahura\inc\widgets;

// Block direct access to the main theme file.
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class post_archive3 extends \ahura\app\elementor\Elementor_Widget_Base
{
	private $query;

    public function __register_assets()
    {
        $this->register_elementor_style('post_archive3_css', mw_assets::get_css('elementor.post_archive3'));
    }

    public function get_name()
    {
        return 'post_archive3';
    }

    public function get_title()
    {
        return esc_html__('Post archive 3', 'ahura');
    }

	public function get_icon() {
		return 'eicon-posts-grid';
	}

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }

    public function get_keywords()
    {
        return ['ahura', 'post archive 3', 'archive', 'post archive', esc_html__('ahura', 'ahura'), esc_html__('Post archive 3', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'display_settings',
            [
                'label' => esc_html__('Layout', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

		$this->add_control(
			'show_related_posts',
			[
				'label' => esc_html__( 'Related posts', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);
        
        $post_types = get_post_types(array('public' => true), 'objects');
        unset($post_types['attachment']);
        $types = array();
        foreach ($post_types as $post_type) {
            $types[$post_type->name] = $post_type->labels->singular_name;
        }

        $this->add_control(
            'post_type',
            [
                'label' => esc_html__('Post Type', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 'post',
                'options' => $types,
				'condition' => [ 'show_related_posts!' => 'yes' ]
            ]
        );

        $this->add_control(
            'per_page',
            [
                'label' => esc_html__('Number of Per Page', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'default' => 12,
            ]
        );

        $this->add_responsive_control(
            'layout_col',
            [
                'label' => esc_html__('Columns', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => '33',
                'tablet_default' => '50',
                'mobile_default' => '100',
                'options' => [
                    '100' => 1,
                    '50' => 2,
                    '33' => 3,
                    '25' => 4,
				],
            ]
        );

		$this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Post title HTML Tag', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 'h3',
                'options' => [
                    'h1' => 'h1',
                    'h2' => 'h2',
                    'h3' => 'h3',
                    'h4' => 'h4',
                    'h5' => 'h5',
                    'h6' => 'h6',
                ],
            ]
        );

        $this->end_controls_section();
        /**
         *
         * More Settings
         *
         */
        $this->start_controls_section(
            'display_more_settings',
            [
                'label' => esc_html__('More Settings', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__('Show Pagination', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
				'condition' => [ 'show_related_posts!' => 'yes' ]
            ]
        );

        $this->add_control(
			'cascade_post',
			[
				'label' => esc_html__( 'Post cascade', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'show_title_arrow',
			[
				'label' => esc_html__( 'Title arrow', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

        $this->add_control(
			'show_desc',
			[
				'label' => esc_html__( 'Description', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ahura' ),
				'label_off' => esc_html__( 'Hide', 'ahura' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'excerpt_chars',
			[
				'label' => esc_html__( 'Excerpt chars', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 10,
				'max' => 400,
				'step' => 1,
				'default' => 44,
				'condition' => [ 'show_desc' => 'yes' ]
			]
		);
        
        $this->end_controls_section();
        /**
         *
         *
         * Start styles
         *
         *
         */
        
        $this->start_controls_section(
            'general_styles',
            [
                'label' => esc_html__('General', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
			'item_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 25,
					'right' => 25,
					'bottom' => 25,
					'left' => 25,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-archive3-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();

        $this->start_controls_section(
            'item_img_styles',
            [
                'label' => esc_html__('Image', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
			'image_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 400,
				],
				'selectors' => [
					'{{WRAPPER}} .img-container' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'image_border_radius',
			[
				'label' => esc_html__( 'Border radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 20,
					'right' => 20,
					'bottom' => 20,
					'left' => 20,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .img-container img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_meta_styles',
            [
                'label' => esc_html__('Meta', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'meta_general_options',
			[
				'label' => esc_html__( 'General', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_responsive_control(
			'meta_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-meta' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->add_responsive_control(
			'meta_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 25,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'meta_cat_options',
			[
				'label' => esc_html__( 'Category', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'meta_cat_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .cats a',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '14'
						]
                    ],
				]
			]
		);
        
        $this->add_control(
			'cat_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#080808CC',
				'selectors' => [
					'{{WRAPPER}} .post-meta .cats a' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'meta_cat_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 10 : 0,
					'bottom' => 0,
					'left' => is_rtl() ? 0 : 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-meta .cats' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'meta_cat_item_padding',
			[
				'label' => esc_html__( 'Items padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => 3,
					'bottom' => 0,
					'left' => 3,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-meta .cats a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'cat_dot_color',
			[
				'label' => esc_html__( 'Dot color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#080808CC',
				'selectors' => [
					'{{WRAPPER}} .post-meta .cats::before' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'cat_dot_size',
			[
				'label' => esc_html__( 'Dot size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .post-meta .cats::before' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'meta_cat_dot_radius',
			[
				'label' => esc_html__( 'Dot border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 100,
					'bottom' => 100,
					'left' => 100,
					'unit' => '%',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-meta .cats::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'meta_date_options',
			[
				'label' => esc_html__( 'Date', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'meta_date_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .post-date',
                'fields_options' =>
				[
                    'typography' => [
                        'default' => 'yes'
                    ],
					'font_size' => [
						'default' => [
							'unit' => 'px',
							'size' => '14'
						]
                    ],
				]
			]
		);
        
        $this->add_control(
			'cat_date_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF9330',
				'selectors' => [
					'{{WRAPPER}} .post-date' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'meta_date_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 10 : 0,
					'bottom' => 0,
					'left' => is_rtl() ? 0 : 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'meta_date_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 0,
					'right' => is_rtl() ? 10 : 0,
					'bottom' => 0,
					'left' => is_rtl() ? 0 : 10,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->add_control(
			'date_dot_color',
			[
				'label' => esc_html__( 'Dot color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF9330',
				'selectors' => [
					'{{WRAPPER}} .post-date::before' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'date_dot_size',
			[
				'label' => esc_html__( 'Dot size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .post-date::before' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'date_dot_radius',
			[
				'label' => esc_html__( 'Dot border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 100,
					'right' => 100,
					'bottom' => 100,
					'left' => 100,
					'unit' => '%',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-date::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();

        $this->start_controls_section(
            'item_title_styles',
            [
                'label' => esc_html__('Title', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

		$this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .post-title h2',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => 24,
                        ],
                    ],
                    'font_weight' => [
                        'default' => 'bold',
                    ],
                ],
			]
		);

        $this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#080808',
				'selectors' => [
					'{{WRAPPER}} .post-title h2' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'title_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 14,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'title_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-title' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'title_width',
			[
				'label' => esc_html__( 'width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-title h2' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'title_arrow_options',
			[
				'label' => esc_html__( 'Arrow', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'title_arrow_size',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-title svg' => 'height: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'item_content_styles',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .post-desc',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'rem',
                            'size' => 0.9,
                        ],
                    ],
                    'line_height' => [
                        'default' => [
                            'unit' => 'rem',
                            'size' => 1.5,
                        ],
                    ],
                    'font_weight' => [
                        'default' => 'normal',
                    ],
                ],
			]
		);

        $this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#080808CC',
				'selectors' => [
					'{{WRAPPER}} .post-desc' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'content_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 7,
					'right' => 0,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .post-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'desc_height',
			[
				'label' => esc_html__( 'Height', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-desc' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();
        
        $this->start_controls_section(
            'pagination_styles',
            [
                'label' => esc_html__('Pagination', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'pagination_typography',
                'label' => esc_html__('Typography', 'ahura'),
				'selector' => '{{WRAPPER}} .page-numbers',
                'fields_options' => [
                    'font_size' => [
                        'default' => [
                            'unit' => 'rem',
                            'size' => 1,
                        ],
                    ],
                    'font_weight' => [
                        'default' => 'normal',
                    ],
                ],
			]
		);

        $this->add_control(
			'pagination_color',
			[
				'label' => esc_html__( 'Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF9330',
				'selectors' => [
					'{{WRAPPER}} .page-numbers' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_control(
			'pagination_background_color',
			[
				'label' => esc_html__( 'Background color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#FF933029',
				'selectors' => [
					'{{WRAPPER}} .page-numbers' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_margin',
			[
				'label' => esc_html__( 'Margin', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .page-numbers' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_padding',
			[
				'label' => esc_html__( 'Padding', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 5,
					'right' => 5,
					'bottom' => 5,
					'left' => 5,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .page-numbers' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_radius',
			[
				'label' => esc_html__( 'Border-radius', 'ahura' ),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em', 'rem' ],
				'default' => [
					'top' => 4,
					'right' => 4,
					'bottom' => 4,
					'left' => 4,
					'unit' => 'px',
					'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .page-numbers' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'pagination_numbers_width',
			[
				'label' => esc_html__( 'Numbers width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .page-numbers:not(.next):not(.prev)' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
        
        $this->end_controls_section();
    }

	public function query_posts() {

		global $wp_query;
		$settings = $this->get_settings_for_display();

		$query_vars = $wp_query->query_vars;
		$page = isset($_GET['page_num']) ? intval($_GET['page_num']) : 1;
		$current_page = max(1, $page);

		$query_vars['posts_per_page'] = $settings['per_page'] ? $settings['per_page'] : 4;
		$query_vars['post_type'] = $settings['post_type'];
		$query_vars['paged'] = $current_page;

        if (is_admin() || is_single()){
            $this->query = new \WP_Query([
                'post_type' => 'post',
                'posts_per_page' => 12
            ]);
        } elseif ( $query_vars !== $wp_query->query_vars ) {
            $this->query = new \WP_Query( $query_vars );
        } else {
            $this->query = $wp_query;
        }
	
		return $this->query;
	}

	public function render()
	{
		$settings = $this->get_settings_for_display();
		$wid = $this->get_id();

		$excerpt_chars = isset($settings['excerpt_chars']) ? $settings['excerpt_chars'] : 44;
		$show_title_arrow = isset($settings['show_title_arrow']) && $settings['show_title_arrow'] === 'yes';

		$desktop_width = isset($settings['layout_col']) ? $settings['layout_col'] : '33';
		$tablet_width = isset($settings['layout_col_tablet']) ? $settings['layout_col_tablet'] : '50';
		$mobile_width = isset($settings['layout_col_mobile']) ? $settings['layout_col_mobile'] : '100';

		$page = isset($_GET['page_num']) ? intval($_GET['page_num']) : 1;
		$current_page = max(1, $page);

		if ($settings['show_related_posts'] !== 'yes') {
			$posts_query = $this->query_posts();
		} else {
			$current_post_id = get_the_ID();
			$current_post_categories = wp_get_post_categories($current_post_id);

			$posts_query = new \WP_Query(array(
				'category__in'     => $current_post_categories,
				'post__not_in'     => array($current_post_id),
				'posts_per_page'   => $settings['per_page'] ? $settings['per_page'] : 4,
				'paged'            => $current_page,
			));
		}

		if ($posts_query instanceof \WP_Query && $posts_query->have_posts()) : ?>
			<div class="post-archive-3 post-archive-3-<?php echo esc_attr($wid); ?>">
				<div class="d-flex flex-wrap posts-list<?php echo $settings['cascade_post'] === 'yes' ? ' cascade-post' : ''; ?>">
					<?php
					while ($posts_query->have_posts()) {
						$posts_query->the_post();
						$gmdate = get_the_modified_date('F j, Y');
						$this->render_post($desktop_width, $tablet_width, $mobile_width, $excerpt_chars, $show_title_arrow, $gmdate, $settings);
					}
					?>
				</div>
				<?php if ($settings['show_pagination'] === 'yes' && $settings['show_related_posts'] !== 'yes') : ?>
					<div class="d-flex justify-content-center align-items-center ahura-pagination">
						<?php ahura_custom_pagination($posts_query->found_posts, $settings['per_page'], $current_page); ?>
					</div>
				<?php endif; ?>
			</div>
		<?php else : ?>
			<div class="mw_element_error">
				<?php echo esc_html__('Sorry, no posts were found for display.', 'ahura'); ?>
			</div>
		<?php endif;

		wp_reset_postdata();
	}

	function render_post($desktop_width, $tablet_width, $mobile_width, $excerpt_chars, $show_title_arrow, $gmdate, $settings)
	{
		$settings = $this->get_settings_for_display();
		$title_tag = $settings['title_tag']; ?>
		
		<div class="post-archive3-box-area" desktop-width="<?php echo esc_attr($desktop_width); ?>" tablet-width="<?php echo esc_attr($tablet_width); ?>" mobile-width="<?php echo esc_attr($mobile_width); ?>">
			<div class="post-archive3-box">
				<a href="<?php the_permalink(); ?>" class="d-block img-container">
					<?php the_post_thumbnail(); ?>
				</a>
				<div class="box-content">
					<div class="d-inline-block post-meta">
						<div class="d-inline-block cats">
							<?php the_category('<span>/</span>'); ?>
						</div>
						<span class="d-inline-block post-date">
							<?php echo esc_html($gmdate); ?>
						</span>
					</div>
					<a href="<?php the_permalink(); ?>" class="d-flex justify-content-between align-items-center post-title">
						<<?php echo esc_attr($title_tag) ?>><?php the_title(); ?></<?php echo esc_attr($title_tag) ?>>
						<?php if ($show_title_arrow) : ?>
							<svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40" fill="none"><path d="M28.3333 28.3334L11.6666 11.6667" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path><path d="M28.3333 11.6667H11.6666V28.3334" stroke="black" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path></svg>
						<?php endif; ?>
					</a>
					<?php if ($settings['show_desc'] === 'yes') : ?>
						<div class="post-desc">
							<?php echo wp_trim_words(get_the_content(), $excerpt_chars); ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	<?php
	}

}