<?php
namespace ahura\inc\widgets;

use ahura\app\mw_assets;
use ahura\app\Post_Meta;
use Elementor\Controls_Manager;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

class portfolio2 extends \ahura\app\elementor\Elementor_Widget_Base {

    public function get_name() {
        return 'portfolio2';
    }

    public function get_title() {
        return __( 'Portfolio 2', 'ahura' );
    }

    public function get_icon() {
        return 'aicon-svg-item-portfolio';
    }

    public function get_categories() {
        return [ 'ahuraelements', 'ahuraportfolio' ];
    }
    function get_keywords()
    {
        return ['ahura', 'portfolio 2', esc_html__('ahura', 'ahura'), esc_html__('Portfolio 2', 'ahura')];
    }

    public function __construct($data = [], $args = null) {
        parent::__construct($data, $args);
        mw_assets::register_script('portfolio2_script', mw_assets::get_js('elementor.portfolio2'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('portfolio2_style', mw_assets::get_css('elementor.portfolio2'));
        if(!is_rtl()){
            $this->register_elementor_style('portfolio2_ltr_style', mw_assets::get_css('elementor.ltr.portfolio2_ltr'));
        }
    }

    public function get_script_depends() {
        return [ mw_assets::get_handle_name('portfolio2_script') ];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab' 	=> \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'tab_title',
            [
                'label' => esc_html__( 'Tab Title', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Default title', 'ahura' ),
            ]
        );

        $terms = get_terms(array(
            'taxonomy'   => 'portfolio_cat',
            'hide_empty' => false,
        ));

        $categories = [];

        if(!empty($terms) && !is_wp_error($terms)){
            foreach ($terms as $term){
                $categories[$term->term_id] = $term->name;
            }
        }

        $repeater->add_control(
            'cat_id',
            [
                'label' => esc_html__( 'Category', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'options' => $categories,
            ]
        );

        $repeater->add_control(
            'items_count',
            [
                'label' => esc_html__( 'Count', 'ahura' ),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 6,
                'min' => 1,
                'step' => 1
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Items', 'ahura' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ tab_title }}}',
                'default' => [
                        ['tab_title' => __('All', 'ahura')]
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => __('Settings', 'ahura'),
                'tab' 	=> \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_responsive_control(
            'items_col',
            [
                'label' => __( 'Column', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 6,
                'options' => [
                    '6'  => __( '2', 'ahura' ),
                    '4' => __( '3', 'ahura' ),
                    '3' => __( '4', 'ahura' ),
                    '2' => __( '6', 'ahura' ),
                ],
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'auto' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-item .item-cover img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         * Styles
         *
         *
         */
        $this->start_controls_section(
            'tabs_style_section',
            [
                'label' => __('Tabs', 'ahura'),
                'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('style_tabs');
        $this->start_controls_tab('style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);
        $alignment = array(
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_responsive_control(
            'tabs_align',
            [
                'label' => esc_html__('Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .tabs-list' => 'text-align: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'tab_color',
            [
                'label' => esc_html__('Title color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#333',
                'selectors' => [
                    '{{WRAPPER}} .tab-item' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tab_bg_color',
                'label' => esc_html__('Background', 'ahura'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .tab-item',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'ahura'),
                'name' => 'tab_typography',
                'selector' => '{{WRAPPER}} .tab-item',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
            'tab_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .tab-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                ]
            ]
        );

        $this->add_responsive_control(
            'tab_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .tab-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 10,
                    'right' => 15,
                    'bottom' => 10,
                    'left' => 15,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tab_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .tab-item',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('style_active_tab', ['label' => esc_html__( 'Active', 'ahura' )]);

        $this->add_control(
            'tab_color_active',
            [
                'label' => esc_html__('Title color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .tab-item.active' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'tab_bg_color_active',
                'label' => esc_html__('Background', 'ahura'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .tab-item.active',
                'fields_options' => [
                    'background' => ['default' => 'gradient'],
                    'color' => ['default' => '#8750F7'],
                    'color_b' => ['default' => '#370F88FF'],
                ]
            ]
        );

        $this->add_responsive_control(
            'tab_border_radius_active',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .tab-item.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'tab_shadow_active',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .tab-item.active',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        $this->start_controls_section(
            'item_title_style_section',
            [
                'label' => __('Item Title', 'ahura'),
                'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_icon_color',
            [
                'label' => esc_html__('Icon Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-icon svg path' => 'fill: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__('Title Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-title' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_title_typography',
                'selector' => '{{WRAPPER}} .item-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '25',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'item_des_color',
            [
                'label' => esc_html__('Description Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .item-des' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Description Typography', 'ahura'),
                'name' => 'item_des_typography',
                'selector' => '{{WRAPPER}} .item-des',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '17',
                        ]
                    ]
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_content_bg_color_active',
                'label' => esc_html__('Background', 'ahura'),
                'types' => ['classic', 'gradient'],
                'exclude' => ['image'],
                'selector' => '{{WRAPPER}} .item-content',
                'fields_options' => [
                    'background' => ['default' => 'gradient'],
                    'color' => ['default' => '#8750F7'],
                    'color_b' => ['default' => '#370F88FF'],
                ]
            ]
        );

        $this->add_responsive_control(
            'item_content_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 15,
                    'right' => 15,
                    'bottom' => 15,
                    'left' => 15,
                ]
            ]
        );

        $this->add_responsive_control(
            'item_content_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 15,
                    'right' => 15,
                    'bottom' => 15,
                    'left' => 15,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_content_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .item-content',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'items_style_section',
            [
                'label' => __('Items', 'ahura'),
                'tab' 	=> \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('item_style_tabs');
        $this->start_controls_tab('item_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_responsive_control(
            'item_img_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'default' => [
                    'size' => 450,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .item-cover img' => 'height: {{SIZE}}{{UNIT}}'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .item-cover img',
            ]
        );

        $this->add_responsive_control(
            'item_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-cover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => 15,
                    'right' => 15,
                    'bottom' => 15,
                    'left' => 15,
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .item-cover img',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('item_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border_hover',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .portfolio-item:hover .item-cover img',
            ]
        );

        $this->add_responsive_control(
            'item_border_radius_hover',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-item:hover .item-cover img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_hover',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .portfolio-item:hover .item-cover img',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();

        $items = $settings['items'];
        $col = $settings['items_col'] ?? 6;
        $tablet_col = $settings['items_col_tablet'] ?? 6;
        $mobile_col = $settings['items_col_mobile'] ?? 12;

        if (empty($items))
            return false;
        ?>
        <div class="portfolio2-element">
            <div class="tabs-list">
                <?php $i = 0; foreach ($items as $item): ?>
                    <a href="#" class="tab-item <?php echo $i === 0 ? 'active' : '' ?>" data-tab="#tab-content-<?php echo $item['_id'] ?>" rel="nofollow noopener">
                        <?php echo $item['tab_title'] ?>
                    </a>
                <?php $i++; endforeach; ?>
            </div>
            <div class="tabs-content-wrap">
                <?php
                $i = 0;
                foreach ($items as $item):
                    $category = $item['cat_id'];
                    $args = ['post_type' => 'portfolio','posts_per_page' => $item['items_count']];
                    if(!empty($category)){
                        $args['tax_query'] = [
                            [
                                'taxonomy' => 'portfolio_cat',
                                'field' => 'term_id',
                                'terms' => $category,
                            ],
                        ];
                    }
                    $query = new \WP_Query($args);
                    ?>
                    <div class="tab-content-wrap" id="tab-content-<?php echo $item['_id'] ?>" style="display:<?php echo $i === 0 ? 'block' : 'none' ?>">
                        <?php if ($query->have_posts()): ?>
                           <div class="row">
                               <?php
                               while ($query->have_posts()): $query->the_post();
                                   $customer_name = Post_Meta::get_portfolio_customer_name();
                                   ?>
                                   <div class="col-<?php echo $mobile_col ?> col-md-<?php echo $tablet_col ?> col-lg-<?php echo $col ?>">
                                       <div class="portfolio-item">
                                           <a href="<?php the_permalink() ?>">
                                               <div class="item-cover"><?php the_post_thumbnail() ?></div>
                                               <div class="item-details-wrap">
                                                   <div class="item-content">
                                                       <div class="item-details">
                                                           <h3 class="item-title"><?php echo the_title() ?></h3>
                                                           <?php if ($customer_name): ?>
                                                               <div class="item-des"><?php echo $customer_name ?></div>
                                                           <?php endif; ?>
                                                       </div>
                                                       <div class="item-icon">
                                                           <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                               <path d="M22 23.5C22.38 23.5 22.76 23.36 23.06 23.06C23.64 22.48 23.64 21.52 23.06 20.94L6.66 4.53998C6.08 3.95998 5.12 3.95998 4.54 4.53998C3.96 5.11998 3.96 6.07998 4.54 6.65998L20.94 23.06C21.24 23.36 21.62 23.5 22 23.5Z" fill="white"/>
                                                               <path d="M3.99998 15.1C4.81998 15.1 5.49998 14.42 5.49998 13.6V5.5H13.6C14.42 5.5 15.1 4.82 15.1 4C15.1 3.18 14.42 2.5 13.6 2.5H3.99998C3.17998 2.5 2.49998 3.18 2.49998 4V13.6C2.49998 14.42 3.17998 15.1 3.99998 15.1Z" fill="white"/>
                                                               <path d="M18 45.5H30C40.86 45.5 45.5 40.86 45.5 30V18C45.5 7.14 40.86 2.5 30 2.5H26C25.18 2.5 24.5 3.18 24.5 4C24.5 4.82 25.18 5.5 26 5.5H30C39.22 5.5 42.5 8.78 42.5 18V30C42.5 39.22 39.22 42.5 30 42.5H18C8.78 42.5 5.5 39.22 5.5 30V26C5.5 25.18 4.82 24.5 4 24.5C3.18 24.5 2.5 25.18 2.5 26V30C2.5 40.86 7.14 45.5 18 45.5Z" fill="white"/>
                                                           </svg>
                                                       </div>
                                                   </div>
                                               </div>
                                           </a>
                                       </div>
                                   </div>
                               <?php
                               endwhile;
                               wp_reset_query();
                               ?>
                           </div>
                        <?php
                        else:
                            $this->renderElementorNotice(__('Sorry, no items were found to display.', 'ahura'));
                        endif;
                        ?>
                    </div>
                <?php
                $i++;
                endforeach; ?>
            </div>
        </div>
        <?php
    }
}
