<?php
namespace ahura\inc\widgets;

// Die if is direct opened file
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class mapbox_1 extends \ahura\app\elementor\Elementor_Widget_Base
{
    /**
     * mapbox_1 constructor.
     * @param array $data
     * @param null $args
     */
    public function __construct($data = [], $args = null)
    {
        parent::__construct($data, $args);
        mw_assets::register_script('mapbox_js', mw_assets::get_js('mapbox-gl'));
        mw_assets::register_script('mapbox1_js', mw_assets::get_js('elementor.mapbox_1'));
    }

    public function __register_assets()
    {
        $this->register_elementor_style('mapbox_css', mw_assets::get_css('mapbox-gl'));
        $this->register_elementor_style('mapbox1_css', mw_assets::get_css('elementor.mapbox1'));
    }

    public function get_script_depends()
    {
        return [mw_assets::get_handle_name('mapbox_js'), mw_assets::get_handle_name('mapbox1_js')];
    }

    /**
     *
     * Set element id
     *
     * @return string
     */
    public function get_name()
    {
        return 'ahura_mapbox1';
    }

    /**
     *
     * Set element widget
     *
     * @return mixed
     */
    public function get_title()
    {
        return esc_html__('Mapbox', 'ahura');
    }

    /**
     *
     * Set widget icon
     *
     */
    public function get_icon()
    {
        return 'eicon-map-pin';
    }

    /**
     *
     * Set element category
     *
     * @return string[]
     */
    public function get_categories()
    {
        return ['ahuraelements'];
    }

    /**
     *
     * Keywords for search
     *
     * @return array
     */
    function get_keywords()
    {
        return ['ahura', 'map', 'map box', esc_html__('ahura', 'ahura'), esc_html__('map', 'ahura'), esc_html__('Map box', 'ahura')];
    }

    /**
     *
     * Element controls option
     *
     */
    public function register_controls()
    {
        /**
         *
         * Start content section
         *
         */
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'api_key',
            [
                'label' => esc_html__('Api Key', 'ahura'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'use_public_key!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'use_public_key',
            [
                'label' => esc_html__('Using public key', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ahura'),
                'label_off' => esc_html__('No', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
                'description' => __('It is recommended to use your own private key, public keys have many restrictions and are suitable for low traffic websites.', 'ahura')
            ]
        );

        $this->add_control(
            'style_mode',
            [
                'label' => esc_html__('Style', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
				'options' => [
					'default'  => esc_html__('Default', 'ahura'),
					'custom' => esc_html__('Custom', 'ahura'),
				],
            ]
        );

        $this->add_control(
            'style_key',
            [
                'label' => esc_html__('Style Key', 'ahura'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'style_mode' => 'custom'
                ]
            ]
        );

        $this->add_control(
            'zoom',
            [
                'label' => esc_html__('Zoom', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 11,
                'min' => 1,
                'step' => 1,
            ]
        );

        $this->add_control(
            'lng',
            [
                'label' => esc_html__('Longitude', 'ahura'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 52.5418852538383
            ]
        );

        $this->add_control(
            'lat',
            [
                'label' => esc_html__('Latitude', 'ahura'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 29.6085199586813
            ]
        );

        $this->add_control(
            'use_custom_marker',
            [
                'label' => esc_html__('Custom Marker', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'points_show' => 'yes'
                ]
            ]
        );

        $this->add_control(
			'marker',
			[
				'label' => esc_html__('Marker Image', 'ahura'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => get_template_directory_uri() . '/img/marker-icon.png',
				],
                'condition' => [
                    'use_custom_marker' => 'yes',
                    'points_show' => 'yes'
                ]
			]
		);

        $this->end_controls_section();
        $this->start_controls_section(
            'points_content_section',
            [
                'label' => esc_html__('Points', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'points_show',
            [
                'label' => esc_html__('Show Points', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'point_lng',
            [
                'label' => esc_html__('Longitude', 'ahura'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 52.5418852538383
            ]
        );

        $repeater->add_control(
            'point_lat',
            [
                'label' => esc_html__('Latitude', 'ahura'),
                'label_block' => true,
                'type' => Controls_Manager::TEXT,
                'default' => 29.6085199586813
            ]
        );

        $repeater->add_control(
            'point_content_show',
            [
                'label' => esc_html__('Show Content', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $repeater->add_control(
			'point_content',
			[
				'label' => esc_html__('Content', 'ahura'),
				'type' => Controls_Manager::WYSIWYG,
                'condition' => [
                    'point_content_show' => 'yes'
                ]
			]
		);

        $this->add_control(
            'points',
            [
                'label' => __('Points', 'ahura'),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'point_lng' => 52.5418852538383,
                        'point_lat' => 29.6085199586813,
                    ],
                    [
                        'point_lng' => 52.51003260512681,
                        'point_lat' => 29.628622280328173,
                    ],
                    [
                        'point_lng' => 52.579097723246036,
                        'point_lat' => 29.60678910778276,
                    ],
                    [
                        'point_lng' => 52.490737250618054,
                        'point_lat' => 29.606256532297905,
                    ],
                ],
                'condition' => [
                    'points_show' => 'yes'
                ]
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'map_style',
            [
                'label' => esc_html__('Map', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'map_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','em','rem','%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 2000
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 500
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'map_border',
                'label' => esc_html__('Border', 'ahura'),
                'selector' => '{{WRAPPER}} .ahura-map-element',
            ]
        );

        $this->add_control(
            'map_border_radius',
            [
                'label' => esc_html__('Border Radius', 'ahura'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .ahura-map-element' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Css_Filter::get_type(),
			[
				'name' => 'map_css_filters',
				'selector' => '{{WRAPPER}} .ahura-map-element .mapboxgl-canvas',
			]
		);

        $this->end_controls_section();
        $this->start_controls_section(
            'map_marker_style',
            [
                'label' => esc_html__('Marker', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'points_show' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'marker_width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','em','rem'],
                'selectors' => [
                    '{{WRAPPER}} .ahura-map-element .marker' => 'width: {{SIZE}}{{UNIT}};',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 35
                ],
            ]
        );

        $this->add_responsive_control(
            'marker_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','em','rem'],
                'selectors' => [
                    '{{WRAPPER}} .ahura-map-element .marker' => 'height: {{SIZE}}{{UNIT}};',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 35
                ],
            ]
        );

        $this->add_group_control(
			\Elementor\Group_Control_Css_Filter::get_type(),
			[
				'name' => 'map_marker_css_filters',
				'selector' => '{{WRAPPER}} .ahura-map-element .marker',
			]
		);

        $this->end_controls_section();
    }


    /**
     *
     * Render element content (html)
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $api_key = $settings['api_key'];
        $style_mode = $settings['style_mode'];
        $style_key = $style_mode == 'custom' && !empty($settings['style_key']) ? $settings['style_key'] : 'mapbox://styles/mapbox/streets-v11';
        $zoom = intval($settings['zoom']) ? $settings['zoom'] : 11;
        $lng = !empty($settings['lng']) ? $settings['lng'] : 52.5418852538383;
        $lat = !empty($settings['lat']) ? $settings['lat'] : 29.6085199586813;
        $show_points = $settings['points_show'] == 'yes';
        $points = $show_points ? $settings['points'] : false;
        $marker = $settings['use_custom_marker'] == 'yes' ? $settings['marker'] : false;
        $map_height = $settings['map_height'] ? "{$settings['map_height']['size']}{$settings['map_height']['unit']}" : '';

        if($settings['use_public_key'] === 'yes'){
            $api_key = 'pk.eyJ1IjoiYWxpcmV6YWRlaGthciIsImEiOiJja3A0eWVydXYxb3M0MnBtdzF2ZDI1MDQyIn0.0Pjo8FUUkr3o9zOPM1FxnA';
        }

        if(!empty($api_key)):

        $data = [
            'api_key' => $api_key,
            'wid' => $wid,
            'map_height' => $map_height,
            'style_key' => $style_key,
            'lng' => $lng,
            'lat' => $lat,
            'zoom' => $zoom,
            'is_admin' => is_admin(),
            'points' => $points,
            'marker' => $marker,
        ];

        $json_data = json_encode($data);
        ?>
        <div class="ahura-map-element-wrap mapbox-1 mapbox-1-<?php echo esc_attr($wid) ?>" data-json='<?php echo $json_data ?>'>
            <?php if(is_admin()): ?>
                <div class="map-details"><div class="lnglat"><?php echo esc_html__('Just click on a point to get location information.', 'ahura') ?></div></div>
            <?php endif; ?>
            <div class="ahura-map-element" id="map_<?php echo esc_attr($wid) ?>" style="height:<?php echo esc_attr($map_height) ?>"></div>
        </div>
        <?php else: ?>
            <div class="ahura-element-msg">
                <?php echo __('Please enter the access key.','ahura');?>
            </div>
		<?php endif; ?>
        <?php
    }
}