<?php
namespace ahura\inc\widgets;

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

// Block direct access to the main plugin file.
defined( 'ABSPATH' ) or die( 'No script kiddies please!' );


class icon_box_2 extends \ahura\app\elementor\Elementor_Widget_Base {
    public function __register_assets()
    {
        $this->register_elementor_style('icon_box_2', mw_assets::get_css('elementor.icon_box_2'));
    }

    public function get_name() {
		return 'icon_box_2';
	}

	public function get_title() {
		return __( 'Icon Box 2', 'ahura' );
	}

	public function get_icon() {
		return 'aicon-svg-icon-box-2';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}
    function get_keywords()
    {
        return ['ahura', 'icon', 'icon box 2', esc_html__('ahura', 'ahura'), esc_html__('Icon Box 2', 'ahura')];
    }
	protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => __( 'Content', 'ahura' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'use_image_icon',
            [
                'label' => esc_html__('Use Image Icon', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-shield-alt',
                    'library' => 'solid',
                ],
                'condition' => ['use_image_icon!' => 'yes']
            ]
        );

        $this->add_control(
            'img_icon',
            [
                'label' => esc_html__( 'Image Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => ['use_image_icon' => 'yes']
            ]
        );

        $this->add_control(
            'show_hover_icon',
            [
                'label' => esc_html__('Show Hover Icon', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'hover_icon',
            [
                'label' => esc_html__( 'Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_hover_icon' => 'yes', 'use_image_icon!' => 'yes']
            ]
        );

        $this->add_control(
            'hover_img_icon',
            [
                'label' => esc_html__( 'Hover Image', 'ahura' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => ['show_hover_icon' => 'yes', 'use_image_icon' => 'yes']
            ]
        );

        $this->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Border Style', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'default',
				'options' => [
					'default' => esc_html__( 'Default', 'ahura' ),
					'backgroundy' => esc_html__( 'With Background', 'ahura' ),
				],
			]
		);

        $this->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'ahura'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Security', 'ahura'),
            ]
        );

        $this->add_control(
            'second_title',
            [
                'label' => esc_html__('Second title', 'ahura'),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'title_divider',
            [
                'label' => esc_html__('Show titles divider', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_des',
            [
                'label' => esc_html__('Show Description', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => esc_html__('Description', 'ahura'),
                'type' => Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat.', 'ahura'),
                'condition' => [
                        'show_des' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'box_link',
            [
                'label' => esc_html__( 'Box link', 'ahura' ),
                'type' => Controls_Manager::URL,
                'show_external' => true,
                'dynamic' => ['active' => true],
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );


        $this->add_control(
            'show_btn',
            [
                'label' => esc_html__( 'Show Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ahura' ),
                'label_off' => esc_html__( 'Hide', 'ahura' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button Text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Read More...', 'ahura' ),
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $this->add_control(
            'btn_icon',
            [
                'label' => esc_html__( 'Button Icon', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-arrow-left',
                    'library' => 'fa-solid',
                ],
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $this->add_control(
            'btn_icon_hover',
            [
                'label' => esc_html__( 'Button Icon on hover', 'ahura' ),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => ['show_btn' => 'yes']
            ]
        );

        $this->end_controls_section();
		$this->start_controls_section(
			'icon_section',
			[
				'label' => __( 'Icon', 'ahura' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs('icon_style_tabs');
        $this->start_controls_tab('icon_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_responsive_control(
            'icon_font_size',
            [
                'label' => esc_html__('Icon Size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'px' ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 300
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '35',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon svg' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon svg > *' => 'fill: {{VALUE}}',
                ],
                'condition' => ['use_image_icon!' => 'yes']
            ]
        );

        $this->add_control(
            'icon_backcolor',
            [
                'label' => esc_html__( 'Background color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'icon_backgroundcolor',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2 .icon',
                'condition' => [ 'icon_type' => 'backgroundy' ]
            ]
        );

        $this->add_control(
            'icon_padding',
            [
                'label' => esc_html__( 'Padding', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 0,
                    'unit' => 'px',
                    'isLinked' => false,
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'icon_margin',
            [
                'label' => esc_html__( 'Margin', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_img_radius',
            [
                'label' => esc_html__( 'Border Radius', 'ahura' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em', 'rem' ],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .ahura_element_icon_box_2 .icon img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('icon_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' ), 'condition' => ['use_image_icon!' => 'yes']]);

        $this->add_control(
            'icon_color_hover',
            [
                'label' => esc_html__( 'Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .icon' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .icon svg' => 'fill: {{VALUE}}',
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .icon svg > *' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
			'content_style',
			[
				'label' => __( 'Content', 'ahura' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs('item_style_tabs');
        $this->start_controls_tab('item_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'second_title_color',
            [
                'label' => esc_html__( 'Second title color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 .second-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'divider_color',
            [
                'label' => esc_html__( 'Divider color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .title-divider' => 'border: 1px solid {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Title typography', 'ahura'),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2 .title',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '20',
                            ]
                        ],
                    ]
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__('Title padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 0,
                    'right' => 3,
                    'bottom' => 0,
                    'left' => 3,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Second title typography', 'ahura'),
                'name' => 'title2_typography',
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2 .second-title',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '20',
                            ]
                        ],
                    ]
            ]
        );

        $this->add_responsive_control(
            'second_title_padding',
            [
                'label' => esc_html__('Second title padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .second-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 0,
                    'right' => 3,
                    'bottom' => 0,
                    'left' => 3,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_control(
            'divider_height',
            [
                'label' => esc_html__('Divider height size', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'px' ],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '20',
                ],
                'selectors' => [
                    '{{WRAPPER}} .title-divider' => 'height: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'divider_padding',
            [
                'label' => esc_html__('Divider margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .title-divider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 0,
                    'right' => 3,
                    'bottom' => 0,
                    'left' => 3,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_responsive_control(
            'titles_area_padding',
            [
                'label' => esc_html__('Titles area padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .titles-area' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 5,
                    'right' => 0,
                    'bottom' => 5,
                    'left' => 0,
                    'unit' => 'px'
                ]
            ]
        );

        $this->add_control(
            'des_color',
            [
                'label' => esc_html__( 'Description Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 .el-des' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => __('Description Typography', 'ahura'),
                'name' => 'des_typography',
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2 .el-des',
                'fields_options' =>
                    [
                        'typography' => [
                            'default' => 'yes'
                        ],
                        'font_size' => [
                            'default' => [
                                'unit' => 'px',
                                'size' => '15',
                            ]
                        ],
                    ]
            ]
        );

        $this->add_control(
            'content_align',
            [
                'label' => esc_html__( 'Icon & title alignment', 'ahura' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'start' => [
                        'title' => esc_html__( 'Right', 'ahura' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'ahura' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => esc_html__( 'Left', 'ahura' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2' => 'align-items: {{VALUE}};',
                ],
                'default' => 'center',
                'toggle' => true,
            ]
        );

        $this->add_control(
            'description_align',
            [
                'label' => esc_html__( 'Alignment', 'ahura' ),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [
                        'title' => esc_html__( 'Right', 'ahura' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'ahura' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'left' => [
                        'title' => esc_html__( 'Left', 'ahura' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 p' => 'text-align: {{VALUE}};',
                ],
                'default' => 'center',
                'toggle' => true,
            ]
        );

        $this->add_responsive_control(
            'description_margin',
            [
                'label' => esc_html__('Description margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2 p' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'btn_style_more_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'btn_color',
            [
                'label' => esc_html__( 'Button Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .item-btn svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_bg',
            [
                'label' => esc_html__( 'Button Background Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .item-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_padding',
            [
                'label' => esc_html__('Button Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'btn_margin',
            [
                'label' => esc_html__('Button Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_btn_border',
                'selector' => '{{WRAPPER}} .item-btn',
            ]
        );

        $this->add_responsive_control(
            'btn_radius',
            [
                'label' => esc_html__('Button Radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .item-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
			'icon_size',
			[
				'label' => esc_html__( 'Icon size', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', 'em', 'rem' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ahura_element_icon_box_2 .item-btn svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_tab();
        $this->start_controls_tab('item_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__( 'Title color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'second_title_color_hover',
            [
                'label' => esc_html__( 'Second title color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .second-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'divider_color_hover',
            [
                'label' => esc_html__( 'Divider color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .title-divider' => 'border-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'des_color_hover',
            [
                'label' => esc_html__( 'Description Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .el-des' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_hover_style_more_options',
            [
                'label' => esc_html__( 'Button', 'ahura' ),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'btn_color_hover',
            [
                'label' => esc_html__( 'Button Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .item-btn' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .item-btn svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'btn_bg_hover',
            [
                'label' => esc_html__( 'Button Background Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2:hover .item-btn' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_btn_border_hover',
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2:hover .item-btn',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
			'box_styles',
			[
				'label' => __( 'Box', 'ahura' ),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

        $this->start_controls_tabs('box_style_tabs');
        $this->start_controls_tab('box_style_normal_tab', ['label' => esc_html__( 'Normal', 'ahura' )]);

        $this->add_responsive_control(
            'width',
            [
                'label' => esc_html__('Width', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'px' ],
                'range' => [
                    '%' => [
                        'min' => 0,
                        'max' => 100
                    ],
                    'px' => [
                        'min' => 0,
                        'max' => 500
                    ]
                ],
                'default' => [
                    'unit' => '%',
                    'size' => '100',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2' => 'width: {{SIZE}}{{UNIT}};'
                ]
            ]
        );
        $this->add_responsive_control(
            'height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'px' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2' => 'height: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_bg',
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2',
                'fields_options' =>
                    [
                        'background' =>
                            [
                                'default' => 'classic'
                            ],
                        'color' =>
                            [
                                'default' => '#9037FF'
                            ],
                    ]
            ]
        );

        $this->add_responsive_control(
            'box_border_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ '%', 'px' ],
                'range' => [
                    '%' => [
                        'min' => 1,
                        'max' => 100
                    ],
                    'px' => [
                        'min' => 1,
                        'max' => 100
                    ]
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => '10',
                ],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2' => 'border-radius: {{SIZE}}{{UNIT}};'
                ]
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .ahura_element_icon_box_2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 1.5,
                    'right' => 1.5,
                    'bottom' => 1.5,
                    'left' => 1.5,
                    'unit' => 'em'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border',
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'label' => __( 'Box shadow', 'ahura' ),
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 10,
                            'blur' => 10,
                            'spread' => 0,
                            'color' => 'rgba(158, 71, 198, 0.5)'
                        ]
                    ]
                ]
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab('box_style_hover_tab', ['label' => esc_html__( 'Hover', 'ahura' )]);


        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'box_bg_hover',
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'box_border_hover',
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_hover',
                'label' => __( 'Box shadow', 'ahura' ),
                'selector' => '{{WRAPPER}} .ahura_element_icon_box_2:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
        $show_hover_icon = $settings['show_hover_icon'] == 'yes';
        $wid = $this->get_id();
        if (!empty($settings['box_link']['url'])) {
            $this->add_link_attributes('link', $settings['box_link']);
        }
		?>
		<a <?php echo $this->get_render_attribute_string('link'); ?> class="ahura_element_icon_box_2 icon-box2-<?php echo $wid; ?>">
			<div class="icon<?php echo isset($settings['icon_type']) && $settings['icon_type'] == 'backgroundy' ? ' backgroundy' : '' ; ?> <?php echo $show_hover_icon ? 'has-hover-icon' : '' ?>">
                <div class="ah-items-center icon-wrap">
                    <?php
                    if($settings['use_image_icon'] == 'yes'){
                        echo '<img src="' . $settings['img_icon']['url'] . '">';
                    } else {
                        \Elementor\Icons_Manager::render_icon($settings['icon']);
                    }
                    ?>
                </div>
                <?php if ($show_hover_icon): ?>
                    <div class="ah-items-center hover-icon-wrap">
                        <?php
                        if($settings['use_image_icon'] == 'yes'){
                            echo '<img src="' . $settings['hover_img_icon']['url'] . '">';
                        } else {
                            \Elementor\Icons_Manager::render_icon($settings['hover_icon']);
                        }
                        ?>
                    </div>
                <?php endif; ?>
            </div>
            <div class="d-flex justify-content-center align-items-center titles-area">
                <?php if($settings['title']): ?>
                    <span class="title"><?php echo $settings['title']?></span>
                <?php endif; ?>
                <?php if($settings['second_title']): ?>
                    <?php if($settings['title_divider']): ?>
                        <hr class="title-divider" />
                    <?php endif; ?>
                    <span class="second-title"><?php echo $settings['second_title']?></span>
                <?php endif; ?>
            </div>
            <?php if ($settings['show_des'] === 'yes'): ?>
                <div class="el-des justify-content-<?php echo isset($settings['content_align']) ? $settings['content_align'] : 'center'; ?>">
                    <p><?php echo $settings['description'] ?></p>
                </div>
            <?php endif; ?>
            <?php if ($settings['show_btn'] == 'yes'): ?>
                <div class="item-button-wrap">
                    <span class="item-btn">
                        <?php echo $settings['btn_text'] ?>
                        <?php if($settings['btn_icon']['value']): ?>
                            <span class="btn-icon<?php echo $settings['btn_icon_hover']['value'] ? ' hover-on' : ''; ?>">
                                <?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon'], [ 'aria-hidden' => 'true' ] ); ?>
                            </span>
                        <?php endif; ?>
                        <?php if($settings['btn_icon_hover']['value']): ?>
                            <span class="btn-icon on-hover">
                                <?php \Elementor\Icons_Manager::render_icon( $settings['btn_icon_hover'], [ 'aria-hidden' => 'true' ] ); ?>
                            </span>
                        <?php endif; ?>
                    </span>
                </div>
            <?php endif; ?>
		</a>
		<?php
    }
}
