<?php

namespace ahura\inc\widgets;

// Block direct access to the main theme file.
defined('ABSPATH') or die('No script kiddies please!');

use Elementor\Controls_Manager;
use ahura\app\mw_assets;

class grid_posts7 extends \ahura\app\elementor\Elementor_Widget_Base
{
    public function __register_assets()
    {
        $this->register_elementor_style('grid_posts7_css', mw_assets::get_css('elementor.grid_posts7'));
        if(!is_rtl()){
            $this->register_elementor_style('grid_posts7_ltr_css', mw_assets::get_css('elementor.ltr.grid_posts7_ltr'));
        }
    }

    public function get_name()
    {
        return 'grid_posts7';
    }

    public function get_title()
    {
        return esc_html__('Grid Posts 7', 'ahura');
    }

    public function get_icon()
    {
        return 'aicon-svg-grid-post-7';
    }

    public function get_categories()
    {
        return ['ahuraelements', 'ahura_posts'];
    }

    public function get_keywords()
    {
        return ['ahura', 'posts', 'grid posts 7', esc_html__('ahura', 'ahura'), esc_html__('Grid Posts 7', 'ahura')];
    }

    public function register_controls()
    {
        $this->start_controls_section(
            'display_settings',
            [
                'label' => esc_html__('Layout', 'ahura'),
                'tab' => Controls_Manager::TAB_CONTENT
            ]
        );

        $post_types = get_post_types(array('public' => true), 'objects');
        unset($post_types['attachment']);
        $types = array();
        foreach ($post_types as $post_type) {
            $types[$post_type->name] = $post_type->labels->singular_name;
        }

        $this->add_control(
            'post_type',
            [
                'label' => esc_html__('Post Type', 'ahura'),
                'type' => Controls_Manager::SELECT,
                'default' => 'post',
                'options' => $types,
            ]
        );

        $taxonomies = get_taxonomies(['public' => true], 'objects');

        $taxs = array();
        if ($taxonomies) {
            foreach ($taxonomies as $key => $taxonomy) {
                if ($taxonomy->public) {
                    $taxs[$taxonomy->name] = $taxonomy->labels->name;
                }
            }
        }
        $default = ($taxs) ? key($taxs) : 0;
        $this->add_control(
            'tax_name',
            [
                'label' => esc_html__('Taxonomy', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $taxs,
                'label_block' => true,
                'default' => $default
            ]
        );

        $cats = array();
        if ($taxonomies) {
            foreach ($taxonomies as $key => $taxonomy) {
                if ($term_object = get_terms($key)) {
                    if($term_object){
                        foreach ($term_object as $term) {
                            $cats[$term->term_id] = "{$term->name} - {$taxonomy->labels->name}";
                        }
                    }
                }
            }
        }
        $default = ($cats) ? key($cats) : 0;
        $this->add_control(
            'cat_id',
            [
                'label' => esc_html__('Categories', 'ahura'),
                'type' => Controls_Manager::SELECT2,
                'options' => $cats,
                'label_block' => true,
                'multiple' => true,
            ]
        );

        $this->add_control(
            'per_page',
            [
                'label' => esc_html__('Posts Count', 'ahura'),
                'type' => Controls_Manager::NUMBER,
                'default' => 4,
                'min' => 1,
                'max' => 8,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'item_cover',
                'default' => 'full',
            ]
        );

        $this->add_responsive_control(
            'object_fit',
            [
                'label' => esc_html__( 'Aspect ratio', 'ahura' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'cover',
                'options' => [
                    'fill' => esc_html__( 'Default', 'ahura' ),
                    'contain' => esc_html__( 'Contain', 'ahura' ),
                    'cover'  => esc_html__( 'Cover', 'ahura' ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .post-item img' => 'object-fit: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
			'button_text',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'View more', 'ahura' ),
			]
		);

        $this->add_control(
            'button_icon',
            [
                'label' => esc_html__('Button icon', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'box_hover',
            [
                'label' => esc_html__('Box hover', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'show_views',
            [
                'label' => esc_html__('Show post views', 'ahura'),
                'description' => esc_html__('Should enable "Capture and enable post views" setting on theme customization panel > blog > single post', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'meta_prefix',
            [
                'label' => esc_html__('Meta prefix', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'item_meta_show',
            [
                'label' => esc_html__('Meta', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'item_excerpt_show',
            [
                'label' => esc_html__('Excerpt', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
			'excerpt_chars_count',
			[
				'label'   => __( 'Excerpt Characters', 'ahura' ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => 20,
				'condition' => [
					'item_excerpt_show' => 'yes'
				]
			]
		);

        $this->add_control(
            'item_revert',
            [
                'label' => esc_html__('Items revet', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'box_item_styles',
            [
                'label' => esc_html__('Box', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
			'item_alignment',
			[
				'label' => esc_html__( 'Item alignment', 'ahura' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'row' => [
						'title' => esc_html__( 'Row', 'ahura' ),
						'icon' => 'eicon-arrow-left',
					],
					'column' => [
						'title' => esc_html__( 'Column', 'ahura' ),
						'icon' => 'eicon-arrow-down',
					],
				],
				'default' => 'row',
				'toggle' => true,
			]
		);
        
        $alignment = array(
            'right' => [
                'title' => esc_html__('Right', 'ahura'),
                'icon' => 'eicon-text-align-right',
            ],
            'center' => [
                'title' => esc_html__('Center', 'ahura'),
                'icon' => 'eicon-text-align-center',
            ],
            'left' => [
                'title' => esc_html__('Left', 'ahura'),
                'icon' => 'eicon-text-align-left',
            ]
        );

        $this->add_responsive_control(
            'item_details_text_align',
            [
                'label' => esc_html__('Text Alignment', 'ahura'),
                'type' => Controls_Manager::CHOOSE,
                'options' => (is_rtl()) ? $alignment : array_reverse($alignment),
                'default' => 'right',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details' => 'text-align: {{VALUE}}',
                    '{{WRAPPER}} .grid-posts7 .post-details .post-excerpt' => 'text-align: {{VALUE}}',
                    '{{WRAPPER}} .grid-posts7 .post-details .post-excerpt p' => 'text-align: {{VALUE}}',
                ]
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => esc_html__('Box padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_item_details_padding',
            [
                'label' => esc_html__('Content padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'isLinked' => true,
                    'top' => 25,
                    'right' => 25,
                    'bottom' => 25,
                    'left' => 25,
                ]
            ]
        );

        $this->add_responsive_control(
            'box_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 > .row > div' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_item_border_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'isLinked' => true,
                    'top' => 0,
                    'right' => 20,
                    'bottom' => 0,
                    'left' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_bg_color',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-item' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .grid-posts7 .post-item',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 2,
                            'blur' => 15,
                            'spread' => 0,
                            'color' => 'rgba(0, 0, 0, 0.13)'
                        ]
                    ]
                ],
            ]
        );

        $this->add_control('divider', ['type' => Controls_Manager::DIVIDER]);

        $this->add_control(
            'box_item_hover_animation',
            [
                'label' => esc_html__('Hover Animation', 'ahura'),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->add_control(
			'box_hover_options',
			[
				'label' => esc_html__( 'Box hover', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [ 'box_hover' => 'yes' ]
			]
		);

        $this->add_control(
            'box_hover_backcolor',
            [
                'label' => esc_html__('Box background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-item:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => [ 'box_hover' => 'yes' ]
            ]
        );

        $this->add_control(
            'box_hover_meta_color',
            [
                'label' => esc_html__('Meta color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-item:hover .post-details .post-cats span' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'box_hover' => 'yes' ]
            ]
        );

        $this->add_control(
            'box_hover_meta_backcolor',
            [
                'label' => esc_html__('Meta background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-item:hover .post-details .post-cats span' => 'background-color: {{VALUE}}',
                ],
                'condition' => [ 'box_hover' => 'yes' ]
            ]
        );

        $this->add_control(
            'box_hover_title_color',
            [
                'label' => esc_html__('Title color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-item:hover .post-details .post-title h2' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'box_hover' => 'yes' ]
            ]
        );

        $this->add_control(
            'box_hover_views_color',
            [
                'label' => esc_html__('Post views color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-item:hover .post-views span' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'box_hover' => 'yes' ]
            ]
        );

        $this->add_control(
            'box_hover_views_dot_color',
            [
                'label' => esc_html__('Post views dot color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-item:hover .post-views-dot' => 'background-color: {{VALUE}}',
                ],
                'condition' => [ 'box_hover' => 'yes' ]
            ]
        );

        $this->add_control(
            'box_hover_button_color',
            [
                'label' => esc_html__('Button color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-item:hover .post-details .post-btns a' => 'color: {{VALUE}}',
                ],
                'condition' => [ 'box_hover' => 'yes' ]
            ]
        );

        $this->add_control(
            'box_hover_button_backcolor',
            [
                'label' => esc_html__('Button background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .post-item:hover .post-details .post-btns a' => 'background-color: {{VALUE}}',
                ],
                'condition' => [ 'box_hover' => 'yes' ]
            ]
        );

        $this->add_control(
			'box_hover_image_grayscale',
			[
				'label' => esc_html__( 'Image grayscale', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .post-item:hover img' => 'filter: grayscale({{SIZE}}%);',
				],
                'condition' => [ 'box_hover' => 'yes' ]
			]
		);

        $this->add_control(
            'box_hover_image_overlay_bordercolor',
            [
                'label' => esc_html__('Image overlay border color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-item:hover .cover-overlay' => 'border: 1px solid {{VALUE}}',
                ],
                'condition' => [ 'box_hover' => 'yes' ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'box_item_details_styles',
            [
                'label' => esc_html__('Details', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_control(
			'title_options',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'box_item_details_title_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#3E3E3E',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Title Typography', 'ahura'),
                'name' => 'item_title_typography',
                'selector' => '{{WRAPPER}} .grid-posts7 .post-details .post-title h2',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '20',
                        ]
                    ]
                ]
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'meta_options',
			[
				'label' => esc_html__( 'Meta', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'box_item_details_meta_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#7B7B7B',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-metas div' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'item_meta_show' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'box_item_details_meta_backcolor',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-cats span' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'item_meta_show' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Meta Typography', 'ahura'),
                'name' => 'item_meta_typography',
                'selector' => '{{WRAPPER}} .grid-posts7 .post-details .post-metas div',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 300],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '13',
                        ]
                    ]
                ],
                'condition' => [
                    'item_meta_show' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'meta_cats_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-cats span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'meta_cats_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-cats span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'meta_cats_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-cats span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
			'desc_options',
			[
				'label' => esc_html__( 'Description', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [
                    'item_excerpt_show' => 'yes'
                ]
			]
		);

        $this->add_control(
            'box_item_details_excerpt_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#7B7B7B',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-excerpt' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .grid-posts7 .post-details .post-excerpt p' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'item_excerpt_show' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Excerpt Typography', 'ahura'),
                'name' => 'item_excerpt_typography',
                'selector' => '{{WRAPPER}} .grid-posts7 .post-details .post-excerpt',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 300],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '13',
                        ]
                    ]
                ],
                'condition' => [
                    'item_excerpt_show' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'desc_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-excerpt' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'item_excerpt_show' => 'yes'
                ]
            ]
        );$this->add_control(
			'views_options',
			[
				'label' => esc_html__( 'Post views', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
                'condition' => [
                    'show_views' => 'yes'
                ]
			]
		);

        $this->add_control(
            'post_views_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#7B7B7B',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-views span' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_views' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'post_views_dot_color',
            [
                'label' => esc_html__('Dot color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#FF754C',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-views-dot' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_views' => 'yes'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'post_views_typography',
                'selector' => '{{WRAPPER}} .grid-posts7 .post-views',
                'condition' => [
                    'show_views' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'post_views_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-views' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_views' => 'yes'
                ]
            ]
        );

        $this->add_control(
			'button_options',
			[
				'label' => esc_html__( 'Button', 'ahura' ),
				'type' => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_control(
            'box_item_details_btn_color',
            [
                'label' => esc_html__('Color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'default' => '#418dff',
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-btns a' => 'color: {{VALUE}}',
                ]
            ]
        );

        $this->add_control(
            'box_item_details_btn_backcolor',
            [
                'label' => esc_html__('Background color', 'ahura'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-btns a' => 'background-color: {{VALUE}}',
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'ahura'),
                'name' => 'item_btns_typography',
                'selector' => '{{WRAPPER}} .grid-posts7 .post-details .post-btns a',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_weight' => ['default' => 300],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '13',
                        ]
                    ]
                ]
            ]
        );

        $this->add_control(
            'button_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-btns a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__('Padding', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-btns a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => esc_html__('Margin', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-details .post-btns a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         *
         *
         * Image style
         *
         *
         */
        $this->start_controls_section(
            'box_item_image_styles',
            [
                'label' => esc_html__('Image', 'ahura'),
                'tab' => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_responsive_control(
            'item_img_min_height',
            [
                'label' => esc_html__('Height', 'ahura'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    'rem' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'desktop_default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'size' => 293,
                    'unit' => 'px',
                ],
                'mobile_default' => [
                    'size' => 150,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-item .post-cover' => 'height: {{SIZE}}{{UNIT}}',
                ]
            ]
        );

        $this->add_control(
            'item_image_radius',
            [
                'label' => esc_html__('Border radius', 'ahura'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em', 'rem'],
                'default' => [
                    'isLinked' => true,
                    'top' => 0,
                    'right' => 20,
                    'bottom' => 0,
                    'left' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .grid-posts7 .post-item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .grid-posts7 .post-item .cover-overlay' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_img_box_shadow',
                'label' => esc_html__('Box Shadow', 'ahura'),
                'selector' => '{{WRAPPER}} .grid-posts7 .post-item .post-cover img',
                'fields_options' => [
                    'box_shadow_type' => ['default' => 'yes'],
                    'box_shadow' => [
                        'default' => [
                            'horizontal' => 0,
                            'vertical' => 2,
                            'blur' => 15,
                            'spread' => 0,
                            'color' => 'rgba(0, 0, 0, 0.13)'
                        ]
                    ]
                ],
            ]
        );

        $this->end_controls_section();

        $this->register_additional_controls();
    }

    /**
     *
     * Get posts result
     *
     * @param array $params
     * @return false
     */
    public function get_posts($params = [])
    {
        $settings = $this->get_settings_for_display();
        $args = array(
            'post_type' => $settings['post_type'],
            'posts_per_page' => $settings['per_page'],
            'post_status' => 'publish',
        );

        if ($settings['cat_id']) {
            $args['tax_query'] = array(
                'tax_query' => [
                    'relation' => 'OR',
                    [
                        'taxonomy' => $settings['tax_name'],
                        'field' => 'term_id',
                        'terms' => $settings['cat_id'],
                    ]
                ]
            );
        }

        $posts = new \WP_Query(array_merge($args, $params));
        return ($posts->have_posts()) ? $posts : false;
    }

    /**
     *
     * Render content for display
     *
     */
    public function render()
    {
        $settings = $this->get_settings_for_display();
        $wid = $this->get_id();
        $posts = $this->get_posts();

        $hoverClass = '';
        if ($settings['box_item_hover_animation']) {
            $hoverClass .= ' elementor-animation-' . $settings['box_item_hover_animation'];
        }

        $chars_num = isset($settings['excerpt_chars_count']) && intval($settings['excerpt_chars_count']) ? $settings['excerpt_chars_count'] : false;

        if ($posts): ?>
            <div class="grid-posts7-wrap">
                <div class="grid-posts7">
                    <div class="row flex-direction-<?php echo $settings['item_alignment'] === 'column' ? 'column' : 'row'; ?>">
                        <?php
                        $i = 0;
                        while ($posts->have_posts()):$posts->the_post();
                            $i++;
                            $cls = ($i == 1 || $i % 4 == 0 || $i % 5 == 0 || $i % 9 == 0) ? ' post-revert' : ''; ?>
                            <div class="<?php echo $settings['item_alignment'] === 'column' ? 'col-12' : 'col-12 col-xs-12 col-sm-12 col-md-6 col-lg-6 mb-4'; ?><?php if($settings['item_revert'] === 'yes') echo $cls; ?>">
                                <div class="post-item ah-has-bg ah-has-border <?php echo $hoverClass; ?>">
                                    <div class="row p-0 m-0 align-items-center">
                                        <div class="col-12 col-xs-12 col-sm-12 col-md-5 col-lg-5 p-0 m-0">
                                            <div class="cover-overlay"></div>
                                            <div class="post-cover">
                                                <?php echo wp_get_attachment_image(get_post_thumbnail_id(), $settings['item_cover_size']) ?>
                                            </div>
                                        </div>
                                        <div class="col-12 col-xs-12 col-sm-12 col-md-7 col-lg-7 p-0 m-0">
                                            <div class="post-details">
                                                <?php if ($settings['item_meta_show'] === 'yes'): ?>
                                                    <div class="post-metas ah-has-text">
                                                        <?php
                                                        $cats = get_the_category();
                                                        if ($cats) { ?>
                                                            <div class="d-flex post-cats">
                                                                <?php if($settings['meta_prefix'] === 'yes'): ?>
                                                                    <span><?php printf('%s:', esc_html__('Category', 'ahura')) ?></span>
                                                                <?php endif; ?>
                                                                <?php
                                                                foreach ($cats as $key => $cat) {
                                                                    $output = "<span>{$cat->cat_name}</span>";
                                                                    if($settings['meta_prefix'] === 'yes') {
                                                                    if (count($cats) > 1 && $key !== count($cats) - 1)
                                                                        $output .= is_rtl() ? "، " : ", ";
                                                                    };
                                                                    echo $output;
                                                                }
                                                                ?>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="post-title">
                                                    <a href="<?php echo esc_attr(get_the_permalink()) ?>" class="ah-has-text">
                                                        <h2><?php the_title() ?></h2>
                                                    </a>
                                                </div>
                                                <?php if (function_exists('ah_get_unique_views') && $settings['show_views'] === 'yes' && ah_get_unique_views(get_the_ID()) !== false): ?>
                                                    <div class="d-flex align-items-center post-views">
                                                        <div class="post-views-dot <?php echo is_rtl() ? 'ml-1' : 'mr-1'; ?>"></div>
                                                        <?php
                                                        if(ah_get_unique_views(get_the_ID()) === 0) {
                                                            ?><span class="post-view-count"><?php echo esc_html__('No views', 'ahura'); ?></span><?php
                                                        } else {
                                                            echo '<span class="post-view-count ' . (is_rtl() ? 'ml-1' : 'mr-1') . '">' . ah_get_unique_views(get_the_ID()) . '</span>' . (ah_get_unique_views(get_the_ID()) === 1 ? '<span class="post-view-postfix">' . esc_html__(' person has read this article.', 'ahura') . '</span>' : '<span class="post-view-postfix">' . esc_html__(' people have read this article.', 'ahura') . '</span>');
                                                        }
                                                        ?>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if ($settings['item_excerpt_show'] === 'yes'): ?>
                                                    <div class="post-excerpt ah-has-text"><?php
                                                        if($chars_num){
                                                            echo '<p>' . wp_trim_words(get_the_excerpt(), $chars_num, '...') . '</p>';
                                                        } else {
                                                            the_excerpt();
                                                        }
                                                    ?></div>
                                                <?php endif; ?>
                                                <?php if(!empty($settings['button_text'])): ?>
                                                <div class="post-btns">
                                                    <a href="<?php echo esc_attr(get_the_permalink()) ?>" class="ah-has-text">
                                                        <?php if($settings['button_icon'] === 'yes'): ?>
                                                            <i class="fas fa-eye"></i>
                                                        <?php endif; ?>
                                                        <?php if($settings['button_text']): ?>
                                                            <?php echo sanitize_text_field($settings['button_text']); ?>
                                                        <?php endif; ?>
                                                        <?php if($settings['button_icon'] === 'yes'): ?>
                                                            <span class="f<?php echo (is_rtl()) ? 'l' : 'r' ?> ah-is-button">
                                                                <i class="fas fa-chevron-<?php echo (is_rtl()) ? 'left' : 'right' ?>"></i>
                                                            </span>
                                                        <?php endif; ?>
                                                    </a>
                                                </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php
                        endwhile;
                        wp_reset_query();
                        wp_reset_postdata();
                        ?>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class="mw_element_error">
                <?php echo esc_html__('Sorry,no posts were found for display.', 'ahura'); ?>
            </div>
        <?php
        endif;
    }
}