<?php
namespace ahura\inc\widgets;

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

use ahura\app\mw_assets;
use Elementor\Controls_Manager;

class charts extends \ahura\app\elementor\Elementor_Widget_Base {
    public function __register_assets()
    {
        $this->register_elementor_style('chartcss', mw_assets::get_css('elementor.charts'));
    }

    public function get_name() {
		return 'ahura_chart';
	}

	public function get_title() {
		return __( 'Chart', 'ahura' );
	}

	public function get_icon() {
		return 'eicon-counter-circle';
	}

	public function get_categories() {
		return [ 'ahuraelements' ];
	}

	function get_keywords()
	{
		return [ 'ahura', 'chart', 'progress', esc_html__('ahura', 'ahura'), esc_html__( 'charts' , 'ahura' ) ];
	}
    
	protected function register_controls() {
		$this->start_controls_section(
			'section_general', [
				'label' => __( 'General', 'ahura' ),
			]
		);

        $this->add_control(
			'title',
			[
				'label' => esc_html__( 'Title', 'ahura' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '20', 'ahura' ),
			]
		);

        $this->add_control(
			'percent',
			[
				'label' => esc_html__( 'Percent', 'ahura' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 100,
				'step' => 1,
				'default' => 20,
			]
		);

        $this->add_control(
            'show_text',
            [
                'label' => esc_html__('Show Text', 'ahura'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ahura'),
                'label_off' => esc_html__('Hide', 'ahura'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'chart_text',
            [
                'label' => esc_html__( 'Text', 'ahura' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Default Title', 'ahura'),
                'condition' => ['show_text' => 'yes']
            ]
        );

		$this->end_controls_section();

        $this->start_controls_section(
            'content_styles_section',
            [
                'label' => esc_html__('General', 'ahura'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'text_color',
			[
				'label' => esc_html__( 'Title Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .pie' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'label' => esc_html__('Title Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .pie-title',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '25'
                        ]
                    ],
                    'font_weight' => [
                        'default' => 'bold'
                    ],
                ],
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__( 'Text Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
                'selectors' => [
                    '{{WRAPPER}} .pie-text' => 'color: {{VALUE}}',
                ],
                'condition' => ['show_text' => 'yes']
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'content_typo',
                'label' => esc_html__('Text Typography', 'ahura'),
                'selector' => '{{WRAPPER}} .pie-text',
                'fields_options' => [
                    'typography' => ['default' => 'yes'],
                    'font_size' => [
                        'default' => [
                            'unit' => 'px',
                            'size' => '15'
                        ]
                    ],
                    'font_weight' => [
                        'default' => '400'
                    ],
                ],
                'condition' => ['show_text' => 'yes']
            ]
        );

        $this->add_control(
			'border_color',
			[
				'label' => esc_html__( 'Border Color', 'ahura' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'gold'
			]
		);

        $this->add_control(
            'border_bg_color',
            [
                'label' => esc_html__( 'Border Background Color', 'ahura' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#fff'
            ]
        );

        $this->add_control(
			'border',
			[
				'label' => esc_html__( 'Border', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 15,
				],
			]
		);

        $this->add_control(
			'width',
			[
				'label' => esc_html__( 'Width', 'ahura' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 150,
				],
			]
		);
		
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
        $wid = $this->get_id();

        $styles = $this->array_to_style([
            '--percent' => $settings[ 'percent' ] ?? 20,
            '--color' => $settings[ 'border_color' ] ?? '#7e7e7e',
            '--border-bg' => $settings[ 'border_bg_color' ] ?? '#fff',
            '--border' => ($settings[ 'border' ][ 'size' ] ?? '22') . 'px',
            '--width' => ($settings[ 'width' ][ 'size' ] ?? '150') . 'px',
        ]);
        ?>
        <div class="pie-charts-element pie-charts-<?php echo $wid; ?>">
            <div class="pie animate no-round" style="<?php echo $styles ?>">
                <span class="pie-title"><?php echo $settings['title']; ?></span>
                <?php if ($settings['show_text'] == 'yes'): ?>
                    <div class="pie-text"><?php echo $settings['chart_text'] ?></div>
                <?php endif; ?>
            </div>
        </div>
	   <?php
    }
}
