<?php
namespace ahura\app;

class Fonts {
    private static function get_font_options(){
        $font_options_key = [
            'ahura_post_font_family',
            'ahura_menu_font_family',
            'ahura_mega_menu_font_family',
            'ahura_footer_widget_font_family',
            'ahura_post_font_family',
            'ahura_post_title_font_family',
            'ahura_en_post_title_font_family',
            'ahura_single_post_author_font_family',
            'ahura_en_single_post_author_font_family',
            'ahura_single_post_cats_font_family',
            'ahura_single_post_comment_count_font_family',
            'ahura_en_single_post_comment_count_font_family',
            'ahura_single_post_date_font_family',
            'post_title_font_family',
            'post_description_font_family',
            'post_author_font_family',
            'post_time_font_family',
            'ahura_en_post_font_family',
        ];

        if(is_rtl() || mw_options::get_mod_use_fa_fonts_status()){
            $font_options_key[] = 'ahura_theme_font';
        }

        if(!is_rtl()){
            $font_options_key[] = 'ahura_en_theme_font';
        }

        $font_options_key = apply_filters('ahura_get_font_options', $font_options_key);

        return $font_options_key;
    }

    private static function flattenArray($array) {
        $result = [];
        foreach ($array as $value) {
            if (empty($value))
                continue;

            if (is_array($value)) {
                $result = array_merge($result, self::flattenArray($value));
            } else {
                $result[] = $value;
            }
        }

        return $result;
    }

    /**
     *
     * Get current font stylesheets file uri
     * Returned all activated fonts stylesheet
     *
     * @return array|bool
     */
    public static function get_current_font_file_stylesheets($return_path = true, $extension = 'php'){
        $styles = [];

        $font_options_key = self::get_font_options();

        $font_names = [];

        if(is_array($font_options_key) && count($font_options_key)){
            foreach($font_options_key as $option){
                $option_value = $option ? get_theme_mod($option) : null;

                if(!empty($option_value)){
                    $font_names[] = $option_value;
                }
            }
        }

        $ahura_elementor_fonts = explode(',', get_theme_mod('ahura_global_font_onelementor_typo'));

        array_push($font_names, $ahura_elementor_fonts);

        $font_names = array_unique(self::flattenArray($font_names));

        if (empty($font_names)){
            $font_names[] = \ahura\app\mw_options::get_mod_theme_font();
        }

        if(is_array($font_names) && !empty($font_names) && count($font_names) > 0){
            foreach($font_names as $name){
                if(!empty($name)){
                    $font_path = "/css/fonts/{$name}." . $extension;
                    $style_uri = get_template_directory_uri() . $font_path;
                    $style_path = get_parent_theme_file_path($font_path);
                    $style_uri = (file_exists($style_path) && is_readable($style_path)) ? ($return_path === true ? $style_path : $style_uri)  : null;

                    if(!empty($style_uri)){
                        $styles[$name] = $style_uri;
                    }
                }
            }
        }

        return is_array($styles) && !empty($styles) && count($styles) > 0 ? array_unique($styles) : false;
    }

    /**
     *
     *  Get current fonts inline style
     *
     */
    private static function get_current_font_inline_styles(){
        $style_files = self::get_current_font_file_stylesheets();
        $inline_style = '';

        if(is_array($style_files) && count($style_files) > 0){
            foreach($style_files as $key => $value){
                $style = \ahura\app\mw_tools::get_executable_file_content($value);
                if(!empty($style)){
                    $inline_style .= '/*-- START {{' . $key . '}} --*/' . PHP_EOL;
                    $inline_style .= $style . PHP_EOL;
                    $inline_style .= '/*-- END {{' . $key . '}} --*/' . PHP_EOL;
                }
            }
        }

        return self::url_replacer($inline_style);
    }

    public static function url_replacer($inline_style)
    {
        return str_replace('{{BASE_URL}}', self::get_fonts_base_url(), $inline_style);
    }

    /**
     *
     *
     * Generate font style file
     *
     *
     */
    public static function generate_fonts_style_file() {
        $font_styles = self::get_current_font_inline_styles();
        $file_name = self::get_locale_file_name();

        if (!empty($font_styles)) {
            $file_path = self::get_fonts_path($file_name);
            if (file_exists($file_path)) {
                unlink($file_path);
            }
            file_put_contents($file_path, $font_styles, FILE_APPEND);
        }
    }

    private static function find_font_name($name) {
        $file_name = self::get_locale_file_name();
        $font_path = self::get_fonts_path($file_name);

        if (!file_exists($font_path)) return false;

        $font_content = file_get_contents($font_path);

        return ahura_str_contains($font_content, "{{{$name}}}");
    }

    private static function get_fonts_base_url()
    {
        return get_template_directory_uri() . '/fonts/';
    }

    public static function get_locale_file_name()
    {
        $lang = ahura_get_current_lang();
        return (!empty($lang) ? $lang . '-' : '') . 'fonts.css';
    }

    public static function get_fonts_stylesheet_name()
    {
        $file_name = 'fonts.css';
        $local_file_name = self::get_locale_file_name();
        if(file_exists(self::get_fonts_stylesheet_dir() . $local_file_name)){
            return $local_file_name;
        }
        return $file_name;
    }

    public static function get_fonts_path($file_name = null) {
        $dir = self::get_fonts_stylesheet_dir();
        if (!is_dir($dir)) {
            mkdir($dir, 0755);
        }

        $file_name = $file_name ?? self::get_fonts_stylesheet_name();

        return $dir . $file_name;
    }

    private static function get_fonts_stylesheet_dir(){
        $upload_dir = wp_upload_dir();
        $dir = $upload_dir['basedir'];
        return $dir . '/ahura/fonts/';
    }

    public static function get_fonts_stylesheet_base_url(){
        $upload_dir = wp_upload_dir();
        $url = $upload_dir['baseurl'];
        return $url . '/ahura/fonts/';
    }

    public static function get_fonts_stylesheet_uri(){
        return self::get_fonts_stylesheet_base_url() . self::get_fonts_stylesheet_name();
    }

    public static function get_font_path_by_name($font_name){
        $font_path = "/css/fonts/{$font_name}.php";
        $style_path = get_parent_theme_file_path($font_path);
        return $style_path;
    }
}