<?php

namespace ahura\app;

class Ahura_Alert {
    const SUCCESS = 1;
    const WARNING = 2;
    const ERROR = 3;
    const INFO = 4;

    private static function getTypeClass($type)
    {
        if ($type === self::WARNING) {
            $class = 'warning mw_element_warning';
        } elseif ($type === self::ERROR) {
            $class = 'error mw_element_error';
        } elseif ($type === self::INFO) {
            $class = 'info mw_element_info';
        } else {
            $class = 'success mw_element_success';
        }
        return $class;
    }

    public static function frontNotice($msg, $type = self::SUCCESS)
    {
        $class = self::getTypeClass($type);
        echo "<div class='alert ahura-alert alert-{$class}'>{$msg}</div>";
    }

    public static function addNotice($msg, $type = self::SUCCESS){
        if (!isset($_SESSION['ahura']['messages'])) {
            $_SESSION['ahura']['messages'] = array();
        }

        $_SESSION['ahura']['messages'][] = array(
            'body' => $msg,
            'type' => $type
        );
    }

    public static function adminNotice($msg, $type = self::SUCCESS)
    {
        $class = self::getTypeClass($type);
        echo "<div class='notice ahura-notice notice-{$class} is-dismissible'><p>{$msg}</p></div>";
    }

    public static function emptyBag()
    {
        $_SESSION['ahura']['messages'] = array();
    }

    public static function showMessage($simple = false)
    {
        if (isset($_SESSION['ahura']['messages']) && !empty($_SESSION['ahura']['messages'])) {
            foreach ($_SESSION['ahura']['messages'] as $message) {
                $alert_class = self::getTypeClass($message['type'])
                ?>
                <div class="<?php echo is_admin() && !$simple ? 'notice is-dismissible' : 'ahura-alert'; ?> <?php echo esc_attr($alert_class); ?>">
                    <p><?php echo $message['body']; ?></p>
                </div>
                <?php
            }
            self::emptyBag();
        }
    }
}