<?php
get_header();
?>

<div class="single-page pt-0">
    <?php
    if (have_posts()) :
        while (have_posts()) : the_post();
            ?>
            <?php
            $images = get_field('project_gallery');
            if ($images): ?>
                <div class="container-fluid">
                    <div class="row">
                        <div class="swiper-container swiper-project col-12 p-0">
                            <div class="swiper-wrapper">
                                <?php foreach ($images as $image): ?>
                                    <div class="swiper-slide">
                                        <img
                                            src="<?php echo esc_url($image['sizes']['large']); ?>"
                                            alt="<?php echo esc_attr($image['alt']); ?>"/>
                                        <div class="col-11 col-md-6 col-lg-4 project-sidebar">
                                            <div class="sidebar">
                                                <h1 class="single-title text-start wow fadeInUp" data-wow-delay="0.25s">
                                                    <?php echo get_the_title(); ?>
                                                </h1>
                                                <?php
                                                $countm = get_field('countm');
                                                $modelm = get_field('modelm');
                                                $factorym = get_field('factorym');
                                                echo '<ul>';
                                                if ($countm != '') {
                                                    echo '<li><span><i class="icon-checkmark"></i>تعداد</span>' . $countm . '</li>';
                                                }
                                                if ($modelm != '') {
                                                    echo '<li><span><i class="icon-checkmark"></i>مدل</span>' . $modelm . '</li>';
                                                }
                                                if ($factorym != '') {
                                                    echo '<li><span><i class="icon-checkmark"></i>کارخانه سازنده</span>' . $factorym . '</li>';
                                                }
                                                echo '</ul>';
                                                ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <!-- If we need navigation buttons -->
                            <div class="swiper-button-prev"></div>
                            <div class="swiper-button-next"></div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="container-lg my-5">
                <div class="row">
                    <div class="col-12 col-lg-8 mx-auto">
                        <?php if (has_post_thumbnail() && !$images) { ?>
                            <div class="single-thumbnail text-center mb-5">
                                <?php the_post_thumbnail('large'); ?>
                            </div>
                        <?php } ?>
                        <h4 class="single-title text-start wow fadeInUp" data-wow-delay="0.25s">
                            <?php echo get_the_title(); ?>
                        </h4>
                        <article class="post-single" itemscope="itemscope" itemtype="http://schema.org/Article">
                            <div class="default-editor"><?php the_content(); ?></div>
                        </article>
                    </div>
                </div>
            </div>
        <?php
        endwhile;
    endif;
    ?>
</div>
</div>
<?php get_footer(); ?>
