<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta content="telephone=no" name="format-detection">
    <meta name="viewport" content="width=device-width,initial-scale=1">
    <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">
    <?php $favIcon = get_field('favicon', 'option');
    if ($favIcon) {
        ?>
        <link rel="shortcut icon" type="image/png" href="<?php echo $favIcon['url']; ?>"/>
    <?php }
    wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<?php
if (is_home() || is_front_page()) {
    $cls_header = 'site-header';
} else {
    $cls_header = 'inner-header';
}
?>
<span class="cursor-follower"></span>
<div class="loader-wrap">
    <div class="preloader">
        <div id="handle-preloader" class="handle-preloader">
            <div class="animation-preloader">
                <div class="spinner"></div>
                <div class="txt-loading">
                        <span data-text-preloader="S" class="letters-loading">
                            S
                        </span>
                    <span data-text-preloader="A" class="letters-loading">
                            A
                        </span>
                    <span data-text-preloader="N" class="letters-loading">
                            N
                        </span>
                    <span data-text-preloader="T" class="letters-loading">
                            T
                        </span>
                </div>
                <div class="company">شرکت مهندسی سدآب نیرو تونل (سانت)</div>
            </div>
        </div>
    </div>
</div>
<div class="search_wrap">
    <div class="search_header_wrap">
        <span class="search_close" role="button"><i class="icon-close"></i></span>
    </div>
    <div class="search_form_wrap">
        <form role="search" method="get" class="search_form position-relative" action="<?php echo home_url('/'); ?>">
            <input type="hidden" value="" name="post_types">
            <input type="text" class="search_field" placeholder="جستجو..." value="" name="s" autocomplete="off">
            <button type="submit" class="search_submit"><i class="icon-search"></i></button>
        </form>
    </div>
</div>
<header class="<?php echo $cls_header; ?>" id="site-header">
    <div class="container-lg">
        <div class="row align-items-center header-wrap">
            <div class="logo-wrap col-4 col-sm-2 col-md-2 col-lg-1">
                <?php
                /* logo */
                $logo = get_field('logo', 'option');
                if ($logo) {
                    echo '<a class="logo-header" href="' . get_bloginfo('url') . '" >';
                    echo '<img src="' . $logo['url'] . '" width="' . $logo['width'] . '" height="' . $logo['height'] . '" alt="' . $logo['alt'] . '" />';
                    echo '</a>';
                }
                ?>
            </div>

            <nav class="col-1 col-sm-2 col-md-7  menu-col-wrap">
                <div class="mobile-menu-btn d-inline-flex d-md-none">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/menu.svg" width="24" height="24"
                         alt="menu"/>
                </div>
                <?php
                if (has_nav_menu('main')) {
                    $defaults = array(
                        'theme_location' => 'main',
                        'container' => '',
                        'menu_class' => ' main-menu  d-none d-md-flex',
                        'echo' => true,
                        'fallback_cb' => 'wp_page_menu',
                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                        'depth' => 3,
                    );
                    wp_nav_menu($defaults);
                }
                ?>
            </nav>
            <div class="header-left col-7 col-sm-8 col-md-3 col-lg-4">
                <span class="quick-button" role="button"><i class="icon-search"></i></span>
                <?php $header_cta = get_field('header_login', 'options');
                if ($header_cta) {
                    ?>
                    <div class="header-cta">
                        <a class="theme-button" href="<?php echo $header_cta; ?>">
                            <span><i class="icon-user"></i>ورود همکاران</span>
                        </a>
                    </div>
                <?php } ?>
            </div>
        </div>
    </div>
</header>

<main class="main-content">
    <?php if (!is_home() || !is_front_page()) {
        get_template_part('templates/content/breadcrumb');
    } ?>
