<?php
/**
General Settings
**/
add_action('after_setup_theme', 'tiyara_theme_setup');
function tiyara_theme_setup(){
    load_theme_textdomain('tiyara', get_template_directory() . '/languages');

	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	//Remove Default Wordpress Gallery Styles
	add_filter( 'use_default_gallery_style', '__return_false' );
}
/**
  Proper way to enqueue scripts and styles
**/
function tiyara_scripts() {
	//Styles
	wp_enqueue_style( 'bootstrap', get_template_directory_uri() .'/assets/vendors/bootstrap/bootstrap.rtl.min.css' );
	wp_enqueue_style( 'swiper-css', get_template_directory_uri() .'/assets/vendors/swiper/swiper-bundle.min.css' );
	wp_enqueue_style( 'animate', get_template_directory_uri() .'/assets/vendors/animate.css' );
	wp_enqueue_style( 'style', get_template_directory_uri() .'/style.css' );
	//Scripts
	wp_enqueue_script( 'bootstrap-js', get_template_directory_uri() . '/assets/vendors/bootstrap/bootstrap.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'swiper-js', get_template_directory_uri() . '/assets/vendors/swiper/swiper-bundle.min.js', array(), '1.0', true );
	//Styles and scripts for Comment Reply
	if ( is_singular() ) {
		wp_enqueue_script( 'comment-reply' );
		wp_enqueue_script( 'validate', get_template_directory_uri() . '/assets/js/jquery.validate.min.js', array(), '1.0', true );

		wp_enqueue_style( 'lightgallery-css', get_template_directory_uri() .'/assets/vendors/lightgallery/lightgallery-bundle.min.css' );
		wp_enqueue_script( 'lightgallery-js', get_template_directory_uri() . '/assets/vendors/lightgallery/lightgallery.min.js', array('jquery'), '1.0', true );

		wp_enqueue_script( 'isotope-js', get_template_directory_uri() . '/assets/vendors/isotope/isotope.pkgd.min.js', array('jquery'), '1.0', true );
	}
	wp_enqueue_script( 'wow.min', get_template_directory_uri() . '/assets/vendors/wow.min.js', array('jquery'), '1.0', true );
	wp_enqueue_script( 'custom.js', get_template_directory_uri() . '/assets/js/custom.js', array('jquery'), '1.0', true );
}
add_action( 'wp_enqueue_scripts', 'tiyara_scripts' );
/**
 Starndard Image Sizes
**/
add_action('after_setup_theme', 'tiyara_image_sizes');
function tiyara_image_sizes(){
	add_image_size( 'post-img', 370,270, true ); // (cropped)
	add_image_size( 'project-img', 370, 370, true ); // (cropped)
}
/**
 Register Menu Locations
**/
add_action('after_setup_theme', 'tiyara_menus');
function tiyara_menus(){
    register_nav_menus( array(
		'main'  => __( 'Main Menu', 'tiyara' ),
		'mobile'  => __( 'Mobile Menu', 'tiyara' ),
	    'footer'  => __( 'Footer', 'tiyara' ),
	    'footer2'  => __( 'Footer2', 'tiyara' ),
	) );
}
/**
 Register Sidebar
**/
add_action('after_setup_theme', 'tiyara_sidebars');
function tiyara_sidebars(){
	register_sidebar(array(
		'name'          => __('sidebar','tiyara'),
		'id'            => 'sidebar-blog',
		'description'   => '',
		'class'         => '',
		'before_widget' => '<div id="%1$s" class="widget widget-blog %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h4 class="widget-title"><i class="icon-gradient"></i>',
		'after_title'   => '</h4>'
	));
}

/****remove site adminbar *******/
add_filter('show_admin_bar', '__return_false');


if( function_exists('acf_add_options_page') ) {

	acf_add_options_page(array(
		'page_title'    => 'تنظیمات سایت',
		'menu_title'    => 'تنظیمات سایت',
		'menu_slug'     => 'theme-general-settings',
		'capability'    => 'edit_posts',
		'redirect'      => false
	));

	acf_add_options_sub_page(array(
		'page_title'    => 'Theme Home Settings',
		'menu_title'    => 'Home',
		'parent_slug'   => 'theme-general-settings',
	));

}
?>
