<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
require_once '../../include/vars.php';

require_once $GLOBALS["RootFiles"] . '/include/tools.php';

function returnCurlResult($url, $action, $time, $domain)
{
    $response=API_REPORT_ADMIN::RunAccessLog($domain,$time,$action);
    return  $response;
}

$dtse=$_POST["time"];
$validtime=["3h"=>"3","6h"=>"6","12h"=>"12","1d"=>"24","1w"=>"7d","1m"=>"30d"];
if (!isset($validtime[$dtse])) {
    echo json_encode([ "status" => "error",$dtse, "message" => "زمان درخواستی شما نامعتبر است" ]);
    return;
}

$m = [];
$url = "";
$action = "statuscounter";
$_POST['action']=$action;

$domain = $_POST["domain"];
if($_POST["website"]!=$domain){
    $domain=$_POST["website"].".".$_POST["domain"];
}

if (!file_exists("statuses/" . $domain))
    mkdir("statuses/" . $domain);

$fp = "statuses/" . $domain . "/" . $validtime[$_POST["time"]] . ".report";

if (file_exists($fp)) {
    $response = file_get_contents($fp);

    $now = date("Y/m/d H:i:s");
    $rep = json_decode($response, true);
    $expire = $rep["expire"];
    if ($now > $expire) {
        $_POST["action"] = "statuscounter";
        $response = returnCurlResult(
            $url,
            $action,
            $validtime[$dtse],
            $domain
        );
        $rep = json_decode($response, true);
        ksort($rep);
        $output = [ "status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "data" => $rep ];
        $rep = json_encode($output, true);

        $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

        $dtss = ["expire" => $expire, "data" => $output];
        $dmns = json_encode($dtss);
        $myfile = fopen($fp, "w") or die(json_encode([ "status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp ]));
        fwrite($myfile, $dmns);
        fclose($myfile);
        echo json_encode($output);
    } else {
        $rep = $rep["data"];
        ksort($rep["data"]);
        echo json_encode($rep);
    }
} else {
    $_POST["action"] = "statuscounter";
    $response = returnCurlResult(
        $url,
        $action,
        $validtime[$dtse],
        $domain
    );
    $rep = json_decode($response, true);
    ksort($rep);
    $output = ["status" => "success", "message" => "درخواست شما با موفقیت انجام شد", "data" => $rep];
    // $rep = json_decode($output, true);

    $expire = date("Y/m/d H:" . returnMinute(date("i")) . ":s", strtotime("+15 minutes"));

    $dtss = ["expire" => $expire, "data" => $output];
    $dmns = json_encode($dtss);
    $myfile = fopen($fp, "w") or die(json_encode([ "status" => "error", "message" => "خطا در دسترسی به فایل بر روی سرور", "data" => $fp ]));
    fwrite($myfile, $dmns);
    fclose($myfile);
    echo json_encode($output);
}
