<?php
header("Content-Type: application/json; charset=UTF-8");

require_once '../include/vars.php';
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

$sql = "SELECT * FROM tbl_domains,tbl_users WHERE d_user_id_fk=uid AND d_status=1 AND d_plan='free'";
$conn = GetConnection();

$result = mysqli_query($conn, $sql);
if (!$result || mysqli_num_rows($result) == 0) {
    $result = ["status" => "error", "message" => "اطلاعاتی جهت نمایش وجود ندارد"];
    return $result;
} else {
    $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
    $dmn = [];
    foreach ($list as $l) {
        $nsql = "SELECT * FROM tbl_websites WHERE ws_domainid_fk=" . $l["domain_id"];
        $nresult = mysqli_query($conn, $nsql);
        $n = mysqli_fetch_all($nresult, MYSQLI_ASSOC);
        $ds = [];
        foreach ($n as $b) {
            if ($l["d_name"] == $b["ws_recordname"]) {
                $ds[] = $l["d_name"];
                $ds[] = $l["d_name"] . "#" .  $l["umail"] . "#" .  $l["umobile"] . "#" .  $l["domain_id"] . "#112";
            } else {
                $ds[] = $b["ws_recordname"] . "." . $l["d_name"];
            }
            // echo $b["ws_recordname"].">>>".$l["d_name"].">>>wid:".$b["wsid"].">>>>domainid:".$l["domain_id"]."<br />";
        }
        $dmn[] = $ds;
        // echo json_encode($n);
    }
    $listOfRecordType = ["status" => "success", "websites" => $l];
}
$result->free_result();
$conn->close();
$outputArr = [];
foreach ($dmn as $d) {
    $dmns = implode(",", $d);
    // 2022-06-01 00:00:00,2022-05-01 00:00:00
    $fdt = jDateTime::date("Y-m-01 00:00:00");
    $tdt = jDateTime::date("Y-m-d 00:00:00");
    // jDateTime::toGregorian();
    $fjdate = jDateTime::toGregorian(jDateTime::date("Y"), jDateTime::date("m"), jDateTime::date("1"));
    $tjdate = jDateTime::toGregorian(jDateTime::date("Y"), jDateTime::date("m"), jDateTime::date("d"));
    $fjdate = date("Y-m-d 00:00:00", strtotime($fjdate));
    $tjdate = date("Y-m-d 00:00:00", strtotime($tjdate));
    // return $jdate;
    // echo json_encode([$fjdate,$tjdate]);
    $bandwithUsage = API_DOMAIN_ADMIN::GetBandwidth($dmns, $tjdate . "," . $fjdate);
    // echo $bandwithUsage;
    $bw = json_decode($bandwithUsage, true);
    $domainOutput = "";
    $bws = 0;
    $rqs = 0;
    $domainid = 0;
    $umobile = "";
    $umail = "";
    foreach ($bw as $c => $k) {
        $m = explode("#", $c);
        if ($m[count($m) - 1] == "112") {
            $domainid = $m[count($m) - 2];
            $umobile = $m[count($m) - 3];
            $umail = $m[count($m) - 4];

            // print_r( $m[count($m) - 2]);
            unset($m[count($m) - 1]);
            unset($m[count($m) - 1]);
            unset($m[count($m) - 1]);
            unset($m[count($m) - 1]);
            $domainOutput =  implode(".", $m);
            // print_r($m);
            // $outputArr[$domainOutput] = "1222";
        }
    }

    foreach ($bw as $c => $k) {
        $m = explode("#", $c);
        if ($m[count($m) - 1] != "112") {
            $rqs = $rqs + $k["reqs"];
            $bws = $bws + $k["bytes"];
            // echo ">>>>>>>>>>>>>>>>>>>>>".$k["bytes"];
        }
    }
    $bwwait = ReturnPlans()["free"]["traffic"] - $bws;
    $rqwait = ReturnPlans()["free"]["request"] - $rqs;
    $outputArr[$domainOutput] = [
        "bwwait" => $bwwait,
        "bytes" => $bws,
        "rqwait" => $rqwait,
        "reqs" => $rqs,
        "domains" => $dmns,
        "mail" => $umail,
        "mobile" => $umobile,
        "insert" => InsertData(
            $domainid,
            $bws,
            cal_percentage($bws, ReturnPlans()["free"]["traffic"]),
            $rqs,
            cal_percentage($rqs, ReturnPlans()["free"]["request"]),
            $umail,
            $umobile
        ),
        "bwpercent" => cal_percentage($bws, ReturnPlans()["free"]["traffic"]),
        "rqpercent" => cal_percentage($rqs, ReturnPlans()["free"]["request"]),
        "date" => $tjdate . "," . $fjdate, "domainid" => $domainid
    ];
    // echo $dmns.">>>>".$fjdate.",".$tjdate;
}
echo json_encode($outputArr);

function InsertData($domainid, $bandwidth, $bwpercent, $request, $rqpercent, $umail, $mobile)
{
    $startDate = jDateTime::date("Y-m-01 00:00:00");
    $enddate = jDateTime::date("Y-m-d 00:00:00");
    $dmnstat = CheckRecordExist($domainid);
    if ($dmnstat["status"] == "success") {
        $sql = "INSERT INTO `tbl_cdn_log_websitebandwidth`
                    (`clwbid`, `clwb_did_fk`, `clwb_bwusage`, `clwb_bwusage_percent`, `clwb_rqusage`,
                    `clwb_rqusage_percent`, `clwb_startdate`, `clwb_enddate`, `clwb_announce`)
                    VALUES (0," . $domainid . "," . $bandwidth . "," . $bwpercent . ",
                    " . $request . "," . $rqpercent . ",'" . $startDate . "','" . $enddate . "',0)";
    } else {
        $sql = "UPDATE tbl_cdn_log_websitebandwidth set clwb_bwusage=" . $bandwidth . ",clwb_bwusage_percent=" . $bwpercent . ",
        clwb_rqusage=" . $request . ",clwb_rqusage_percent =" . $rqpercent . ",  clwb_enddate ='" . $enddate . "' where clwbid=" . $dmnstat["data"][0]["clwbid"];
    }
    $conn = GetConnection();
    mysqli_query($conn, $sql);
    $conn->close();
    if ($bwpercent > 80 || $rqpercent > 80) {
        //send email and sms
    }
    return $sql;
}
function CheckRecordExist($domainid)
{
    $start = jDateTime::date("Y-m-01 00:00:00");
    $end = jDateTime::date("Y-m-01 00:00:00", strtotime('+1 month'));
    $sql = "SELECT * FROM tbl_cdn_log_websitebandwidth where clwb_did_fk=" .
        $domainid . " AND clwb_startdate >= '" . $start . "' and  	clwb_enddate <='" . $end . "'";
    $conn = GetConnection();
    $result = mysqli_query($conn, $sql);
    if (!$result || mysqli_num_rows($result) == 0) {
        $result = ["status" => "success", "message" => "اطلاعاتی جهت نمایش وجود ندارد"];
        $conn->close();
        return $result;
    } else {
        $n = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "error", "data" => $n];
    }
}
function cal_percentage($num_amount, $num_total)
{
    $count1 = $num_amount / $num_total;
    $count2 = $count1 * 100;
    $count = number_format($count2, 0);
    return $count;
}
