<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class FINANCIAL_INVOICEBYMONTH_ADMIN
{

    public static function GetListByInvoiceByUser($token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT *,iidm as invoiceid,imstarttime as start,imendtime as end,(imcdn+imlive+imcloud+imvod+imlivewebrtc) as price from " . $GLOBALS["tbl_financial_invoice_bymonth"] . " WHERE " .
            $GLOBALS['im_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        if (count($listOfRecordType) == 0) {
            return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "page" => 1, "currentpage" => 1, "countofpage" => 1, "invoices" => []];
        } else {
            $i=0;
            foreach ($listOfRecordType as $l) {
                $listOfRecordType[$i]["data"]=self::GetCurrentInvoiceByUser($token,$l["start"],$l["end"])["data"];
                $i++;
            }
        }
        unset($listOfRecordType[count($listOfRecordType)-1]);
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "page" => 1, "currentpage" => 1, "countofpage" => 1, "invoices" => $listOfRecordType];
    }
    public static function GetCurrentInvoiceByUser($token, $starttime = 0, $end = 0)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $whereend="";
        $uid = $usersDetails["userdetail"][0]["uid"];
        if ($starttime == 0)
            $starttime = jDateTime::date("Y/m/01 00:00:00");
        if ($end == 0){
            $end =  jDateTime::date("Y/m/d 00:00:00");
        }else{
            $whereend="and imendtime='" . $end . "'";
        }
        $sql = "SELECT * FROM " . $GLOBALS["tbl_financial_invoice_bymonth"] . " WHERE " .
            $GLOBALS['im_uid_fk'] . "=" . $uid  . " AND imstarttime='" . $starttime . "' ".$whereend." limit 0,1";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        $datas = [];
        $partsOfService = ["cdn", "cloud", "livewebrtc", "vod", "live"];
        if (count($listOfRecordType) == 0) {
            return [
                "status" => "success",
                "message" => "اطلاعات با موفقیت دریافت شد",
                "invoiceid" => 0,
                "start" => $starttime,
                "end" => $end,
                "price" => "0",
                "data" => []
            ];
        }
        foreach ($partsOfService as $p) {
            if (intVal($listOfRecordType[0]["im" . $p]) > 0) {
                $datas[$p] = [];
                $datas[$p]["price"] = intVal($listOfRecordType[0]["im" . $p]);
                $datas[$p]["services"] = [];
                $trees = FINANCIAL_INVOICETREEMONTH_ADMIN::GetTreesByInvoice($listOfRecordType[0]["iidm"], $p);
                if ($trees["status"] == "success") {
                    for ($i = 0; $i < count($trees["data"]); $i++) {
                        $partOfServiceName = ["cdn" => "WebsiteName", "cloud" => "ServerName", "realtimeLiveStream" => "livename", "vod" => "VideoName", "live" => "livename"];
                        $datas[$p]["services"][$i][$partOfServiceName[$p]] = $trees["data"][$i]["fitm_sname"];
                        $datas[$p]["services"][$i]["start"] = $trees["data"][$i]["fitm_starttime"];
                        $datas[$p]["services"][$i]["end"] = $trees["data"][$i]["fitm_endtime"];
                        $datas[$p]["services"][$i]["price"] = $trees["data"][$i]["fitmprice"];
                        $datas[$p]["services"][$i]["details"] = [];
                        $det = FINANCIAL_INVOICEDETAILSBYMONTH_ADMIN::GetListByInvoiceTreeIDByCategory($trees["data"][$i]["fitmid"], $p);
                        if ($det["status"] == "success") {
                            for ($j = 0; $j < count($det["data"]); $j++) {
                                $datas[$p]["services"][$i]["details"][$j] = [
                                    "item" => $det["data"][$j]["fidm_calculateditem"],
                                    "message" => $det["data"][$j]["fidm_details"],
                                    "price" => $det["data"][$j]["fidm_price"],
                                ];
                            }
                        }
                    }
                }
            }
        }
        return [
            "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
            "invoiceid" => $listOfRecordType[0]["iidm"],
            "start" => $listOfRecordType[0]["imstarttime"],
            "end" => $listOfRecordType[0]["imendtime"],
            "price" => intVal($listOfRecordType[0]["imcdn"]) + intVal($listOfRecordType[0]["imlive"]) + intVal($listOfRecordType[0]["imcloud"]) + intVal($listOfRecordType[0]["imvod"]) + intVal($listOfRecordType[0]["imlivewebrtc"]) . "",
            "data" => $datas
        ];
    }
    public static function GetInvoiceDetails($uid, $start)
    {
        $sql = "SELECT * FROM " . $GLOBALS['tbl_financial_invoice_bymonth'] .
            " WHERE " . $GLOBALS['im_uid_fk'] . "='" . $uid . "' AND " .
            $GLOBALS['imstarttime'] . "='" . $start . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $conn->close();
            return [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => []
            ];
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $conn->close();
            return ["status" => "error", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
        }
    }
    public static function UpdateEndOfTime($invoiceid, $endOfTime, $iscurrent)
    {
        $sql = "UPDATE   " .
            $GLOBALS['tbl_financial_invoice_bymonth'] . "  SET  " . $GLOBALS['imendtime'] . "='" .
            $endOfTime . "'," . $GLOBALS['im_current'] . "=" . $iscurrent . " WHERE " . $GLOBALS['iidm'] . "=" . $invoiceid;
        $conn = GetConnection();
        $conn->query($sql);
        $id  =  $conn->insert_id;
        $conn->close();
    }
    public static function UpdateInvoice($uid, $start, $end, $iscurrent)
    {
        $starttime =   $start;
        $r = self::GetInvoiceDetails($uid, $starttime);
        $id = 0;

        if ($r["status"] == "success") {
            $sql = "INSERT INTO  " .
                $GLOBALS['tbl_financial_invoice_bymonth'] . "  VALUES(0,0,0,0,0,0,'" .
                $start . "','" . $end . "','" . $uid . "',1,0)";
            $conn = GetConnection();
            $conn->query($sql);
            $id  =  $conn->insert_id;
            $conn->close();
        } else {
            $id = $r["data"][0]["iidm"];
            self::UpdateEndOfTime($id, $end, $iscurrent);
        }
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $id];
    }
    public static function UpdatePriceJob($cat, $price, $invoiceid)
    {
        $sql = "UPDATE " . $GLOBALS['tbl_financial_invoice_bymonth'] . " SET " .
            $GLOBALS["im" . $cat] . "=" . $GLOBALS["im" . $cat] . "+" . $price . "'
       where " . $GLOBALS['iidm'] . "=" . $invoiceid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function UpdatePrice($cat, $price, $invoiceid)
    {
        $sql = "UPDATE " . $GLOBALS['tbl_financial_invoice_bymonth'] . " SET " . $GLOBALS["im" . $cat]
            . "=(
                select sum(`fitmprice`) from  tbl_financial_invoicetreebymonth
                where `fitm_ifield`='" . $cat . "' and fitm_iidm_fk=" . $invoiceid . " )
                where iidm =" . $invoiceid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return $sql;
    }
    public static function RunDisableCurrentInvoice()
    {
        $sql = "UPDATE " . $GLOBALS['tbl_financial_invoice_bymonth'] . " SET " .
            $GLOBALS['im_current'] . "=1";
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function RunJobForCalculateAndGenerateInvoiceForCloudServer()
    {

        mb_internal_encoding('utf-8');
        $starttime = jDateTime::date("Y/m/d 00:00:00", strtotime("-1 day"));
        $end =  jDateTime::date("Y/m/d 00:00:00");
        $day = jDateTime::date("Y/m/d");
        $firstDayOfMonth = jDateTime::date("Y/m/01 00:00:00");
        $dayOfMonth = explode("/", $day);
        $daystatus = "0";
        if ($dayOfMonth[2] == "01") {
            $daystatus = "1";
        }
        $o = [];

        if ($daystatus == "1") {
            //FirstDayOfMonth->CreateNewInvoice & ClosedOldInvoice
        } else {
            //DaysBetweenMonth->UpdateCurrentInvoice
            $invoiceDay = FINANCIAL_INVOICEBYDAY_ADMIN::GetInvoicesForDay($starttime, $end);
            if ($invoiceDay["status"] == "error") {
                return $invoiceDay;
            }
            foreach ($invoiceDay["data"] as $inv) {

                $invoiceIDByMonth = self::UpdateInvoice(
                    $inv["id_uid_fk"],
                    $firstDayOfMonth,
                    $end,
                    $daystatus
                )["data"];

                $invoiceTreeForDay = FINANCIAL_INVOICETREEDAY_ADMIN::GetListOfInvoiceTreeByInvoiceID($inv["iidd"]);

                foreach ($invoiceTreeForDay["data"] as $invoiceTrees) {

                    $InvoiceTreeByMonth = FINANCIAL_INVOICETREEMONTH_ADMIN::UpdateByInvoiceID(
                        $invoiceIDByMonth,
                        $invoiceTrees["fitddecription"],
                        $invoiceTrees["fitd_ifield"],
                        $invoiceTrees["fitd_sid"],
                        $invoiceTrees["fitd_sname"],
                        $firstDayOfMonth,
                        $end
                    );
                    $treeIDByMonth = $invoiceTrees["fitdid"];
                    $invoiceDetails = FINANCIAL_INVOICEDETAILSBYDAY_ADMIN::GetListByInvoiceTreeID($treeIDByMonth);
                    for ($i = 0; $i < count($invoiceDetails["data"]); $i++) {
                        //    $ex=explode(" ",$invoiceDetails["data"][$i]["fidd_details"]);
                        //    $CountOfHour= $ex[count($ex)-2];
                        //    $ex[count($ex)-2]=44;

                        $o[$invoiceDetails["data"][$i]["fidd_sid_fk"]][$i] =
                            FINANCIAL_INVOICEDETAILSBYMONTH_ADMIN::AddInvoiceDetails(
                                $InvoiceTreeByMonth["id"],
                                $invoiceDetails["data"][$i]["fidd_details"],
                                $invoiceDetails["data"][$i]["fidd_price"],
                                $invoiceDetails["data"][$i]["fidd_calculateditem"],
                                $invoiceDetails["data"][$i]["fidd_count"],
                                $invoiceDetails["data"][$i]["fidd_sid_fk"],
                                $starttime,
                                $end
                            );
                    }
                    $s[$InvoiceTreeByMonth["id"]] =
                        FINANCIAL_INVOICETREEMONTH_ADMIN::UpdatePrice($InvoiceTreeByMonth["id"]);
                }
                FINANCIAL_INVOICEBYMONTH_ADMIN::UpdatePrice("cloud", 0, $invoiceIDByMonth);
            }
        }

       
        return INVOICE_LOG_ADMIN::UpdateLastTimeLog("CloudInvoiceMonthly", $end);
    }
    public static function RunJobForCalculateAndGenerateInvoiceForLiveStream()
    {
        mb_internal_encoding('utf-8');
        $starttime = jDateTime::date("Y/m/d 00:00:00", strtotime("-1 day"));
        $end =  jDateTime::date("Y/m/d 00:00:00");
        $day = jDateTime::date("Y/m/d");
        $firstDayOfMonth = jDateTime::date("Y/m/01 00:00:00");
        $dayOfMonth = explode("/", $day);
        $daystatus = "0";
        if ($dayOfMonth[2] == "01") {
            $daystatus = "1";
        }
        $o = [];

        if ($daystatus == "1") {
            //FirstDayOfMonth->CreateNewInvoice & ClosedOldInvoice
            self::RunDisableCurrentInvoice();
        }

        //DaysBetweenMonth->UpdateCurrentInvoice
        $invoiceDay = FINANCIAL_INVOICEBYDAY_ADMIN::GetInvoicesForDay($starttime, $end, "live");

        if ($invoiceDay["status"] == "error") {
            return;
        }
        $months = [];
        foreach ($invoiceDay["data"] as $inv) {
            $invoiceIDByMonth = self::UpdateInvoice(
                $inv["id_uid_fk"],
                $firstDayOfMonth,
                $end,
                $daystatus
            )["data"];
            $months[$invoiceIDByMonth] = $invoiceDay["data"];
            $invoiceTreeForDay =
                FINANCIAL_INVOICETREEDAY_ADMIN::GetListOfInvoiceTreeByInvoiceID($inv["iidd"], "live");

            foreach ($invoiceTreeForDay["data"] as $invoiceTrees) {

                $InvoiceTreeByMonth = FINANCIAL_INVOICETREEMONTH_ADMIN::UpdateByInvoiceID(
                    $invoiceIDByMonth,
                    $invoiceTrees["fitddecription"],
                    $invoiceTrees["fitd_ifield"],
                    $invoiceTrees["fitd_sid"],
                    $invoiceTrees["fitd_sname"],
                    $firstDayOfMonth,
                    $end
                );

                $treeIDByMonth = $invoiceTrees["fitdid"];
                $invoiceDetails = FINANCIAL_INVOICEDETAILSBYDAY_ADMIN::GetListByInvoiceTreeID($treeIDByMonth);

                for ($i = 0; $i < count($invoiceDetails["data"]); $i++) {
                    $invoiceDetails["data"][$i]["fidd_price"];
                    $o[$invoiceDetails["data"][$i]["fidd_sid_fk"]][$i] =
                        FINANCIAL_INVOICEDETAILSBYMONTH_ADMIN::AddInvoiceDetails(
                            $InvoiceTreeByMonth["id"],
                            $invoiceDetails["data"][$i]["fidd_details"],
                            $invoiceDetails["data"][$i]["fidd_price"],
                            $invoiceDetails["data"][$i]["fidd_calculateditem"],
                            $invoiceDetails["data"][$i]["fidd_count"],
                            $invoiceDetails["data"][$i]["fidd_sid_fk"],
                            $starttime,
                            $end
                        );
                }

                FINANCIAL_INVOICETREEMONTH_ADMIN::UpdatePrice($InvoiceTreeByMonth["id"]);
            }

            FINANCIAL_INVOICEBYMONTH_ADMIN::UpdatePrice("live", 0, $invoiceIDByMonth);
        }
        return INVOICE_LOG_ADMIN::UpdateLastTimeLog("LiveStreamInvoiceMonthly", $end);
    }
    public static function RunJobForCalculateAndGenerateInvoiceForCDN()
    {
        mb_internal_encoding('utf-8');
        $starttime = jDateTime::date("Y/m/d 00:00:00", strtotime("-1 day"));
        $end =  jDateTime::date("Y/m/d 00:00:00");
        $day = jDateTime::date("Y/m/d");
        $firstDayOfMonth = jDateTime::date("Y/m/01 00:00:00");
        $dayOfMonth = explode("/", $day);
        $daystatus = "0";
        if ($dayOfMonth[2] == "01") {
            $daystatus = "1";
        }
        $o = [];

        if ($daystatus == "1") {
            //FirstDayOfMonth->CreateNewInvoice & ClosedOldInvoice
            self::RunDisableCurrentInvoice();
        }

        //DaysBetweenMonth->UpdateCurrentInvoice
        $invoiceDay = FINANCIAL_INVOICEBYDAY_ADMIN::GetInvoicesForDay($starttime, $end, "cdn");
        if ($invoiceDay["status"] == "error") {
            return $invoiceDay;
        }
        $months = [];
        foreach ($invoiceDay["data"] as $inv) {
            $invoiceIDByMonth = self::UpdateInvoice(
                $inv["id_uid_fk"],
                $firstDayOfMonth,
                $end,
                $daystatus
            )["data"];

            $months[$invoiceIDByMonth] = $invoiceDay["data"];
            $invoiceTreeForDay =
                FINANCIAL_INVOICETREEDAY_ADMIN::GetListOfInvoiceTreeByInvoiceID($inv["iidd"], "cdn");
            foreach ($invoiceTreeForDay["data"] as $invoiceTrees) {

                $InvoiceTreeByMonth = FINANCIAL_INVOICETREEMONTH_ADMIN::UpdateByInvoiceID(
                    $invoiceIDByMonth,
                    $invoiceTrees["fitddecription"],
                    $invoiceTrees["fitd_ifield"],
                    $invoiceTrees["fitd_sid"],
                    $invoiceTrees["fitd_sname"],
                    $firstDayOfMonth,
                    $end
                );

                $treeIDByMonth = $invoiceTrees["fitdid"];
                $invoiceDetails = FINANCIAL_INVOICEDETAILSBYDAY_ADMIN::GetListByInvoiceTreeID($treeIDByMonth);

                for ($i = 0; $i < count($invoiceDetails["data"]); $i++) {
                    $invoiceDetails["data"][$i]["fidd_price"];
                    $o[$invoiceDetails["data"][$i]["fidd_sid_fk"]][$i] =
                        FINANCIAL_INVOICEDETAILSBYMONTH_ADMIN::AddInvoiceDetails(
                            $InvoiceTreeByMonth["id"],
                            $invoiceDetails["data"][$i]["fidd_details"],
                            $invoiceDetails["data"][$i]["fidd_price"],
                            $invoiceDetails["data"][$i]["fidd_calculateditem"],
                            $invoiceDetails["data"][$i]["fidd_count"],
                            $invoiceDetails["data"][$i]["fidd_sid_fk"],
                            $starttime,
                            $end
                        );
                }

                FINANCIAL_INVOICETREEMONTH_ADMIN::UpdatePrice($InvoiceTreeByMonth["id"]);
            }

            FINANCIAL_INVOICEBYMONTH_ADMIN::UpdatePrice("cdn", 0, $invoiceIDByMonth);
        }
        return INVOICE_LOG_ADMIN::UpdateLastTimeLog("CDNInvoiceMonthly", $end);
    }
}
