<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';

class FINANCIAL_INVOICEBYDAY_ADMIN
{
    public static function GetListByInvoiceByUser($token)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                         return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT * FROM " . $GLOBALS["tbl_financial_invoice_byday"] . " WHERE " . $GLOBALS['id_uid_fk'] . "=" . $uid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
        $conn->close();
        return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
    }
    public static function GetInvoicesForDay($start, $end, $cat = "cloud")
    {
        $start=str_replace("/","-",$start);
        $end=str_replace("/","-",$end);
        $sql = "SELECT * FROM " . $GLOBALS['tbl_financial_invoice_byday'] . " WHERE "
            .   $GLOBALS['idstarttime'] . " >='" . $start . "' AND "
            .   $GLOBALS['idendtime'] . " <= '" . $end . "' AND " .
            "id" . $cat . ">0
                 order by " . $GLOBALS['id_uid_fk'] . " asc , " . $GLOBALS['idstarttime'] . " asc";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $conn->close();
            return [
                "status" => "error", $sql,
                "message" => "اطلاعات با موفقیت دریافت شد",
            ];
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
            foreach ($listOfRecordType as $l) {
                $m = FINANCIAL_INVOICETREEHOUR_ADMIN::GetPriceListWithByCategory(1);
            }
            $conn->close();
            return [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $listOfRecordType
            ];
        }
    }
    public static function GetInvoiceDetails($uid, $start)
    {
        $sql = "SELECT * FROM " . $GLOBALS['tbl_financial_invoice_byday'] .
            " WHERE " . $GLOBALS['id_uid_fk'] . "='" . $uid . "' AND " .
            $GLOBALS['idstarttime'] . "='" . $start . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $conn->close();
            return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد"];
        } else {
            $listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $conn->close();
            return ["status" => "error", "message" => "اطلاعات با موفقیت دریافت شد", "data" => $listOfRecordType];
        }
    }
    public static function UpdateInvoice($uid, $start, $end)
    {
        $r = self::GetInvoiceDetails($uid, $start);
        $id = 0;
        $stat = "ins";
        if ($r["status"] == "success") {
            $sql = "INSERT INTO  " .
                $GLOBALS['tbl_financial_invoice_byday'] . "  VALUES(0,0,0,0,0,0,'" .
                $start . "','" . $end . "','" . $uid . "')";
            $conn = GetConnection();
            $conn->query($sql);
            $id  =  $conn->insert_id;
            $conn->close();
            $stat = "ins";
        } else {
            $id = $r["data"][0]["iidd"];
            $stat = "get";
        }
        return [
            "status" => "success", "stat" => $stat, "message" => "اطلاعات با موفقیت دریافت شد",
            "data" => $id
        ];
    }
    public static function UpdatePriceJob($cat, $price, $invoiceid)
    {
        $sql = "UPDATE " . $GLOBALS['tbl_financial_invoice_byday'] . " SET " .
            $GLOBALS["id" . $cat] . " =" . $GLOBALS["id" . $cat] . "+" . $price . "
            where " . $GLOBALS['iidd'] . "=" . $invoiceid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return $sql;
    }
    public static function UpdatePrice($cat, $price = 0, $invoiceid)
    {

        $sql = "UPDATE " . $GLOBALS['tbl_financial_invoice_byday'] . " SET " . $GLOBALS["id" . $cat]
            . "=(
            select sum(`fitdprice`) from  tbl_financial_invoicetreebyday
            where `fitd_ifield`='" . $cat . "' and fitd_iidd_fk=" . $invoiceid . " )
            where iidd =" . $invoiceid;
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return $sql;
    }
    public static function RunJobForCalculateAndGenerateInvoiceForCloudServer()
    {
        mb_internal_encoding('utf-8');
        $starttime = jDateTime::date("Y/m/d 00:00:00", strtotime("-1 day"));
        $end =  jDateTime::date("Y/m/d 00:00:00");
        $invoiceDay = FINANCIAL_INVOICEBYHOUR_ADMIN::GetInvoicesForDay($starttime, $end);
        $dateForCreateFolder = jDateTime::date("Ymd");
        $users = [];
        $invoicebyuid = [];
        $output = [];
        $pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("CloudServer");
        $prc = [];
        foreach ($pricelist["data"] as $pr) {
            $prc[$pr["dp_category"]] = $pr["dp_price"];
        }
        if ($invoiceDay["status"] == "error") {
            return $invoiceDay;
        };

        for ($i = 0; $i < count($invoiceDay["data"]); $i++) {

            $uid = $invoiceDay["data"][$i]["i_uid_fk"];
            $invoiceid = $invoiceDay["data"][$i]["iid"];

            $path = $GLOBALS["RootFiles"] . "/invoices/user/" . $invoiceDay["data"][$i]["i_uid_fk"] .
                "/invoicedata/hourly/" . $dateForCreateFolder;
            if (!file_exists($path)) {
                mkdir($path, 0700, true);
            }
            if (!in_array($uid, $users)) {
                array_push($users, $uid);
                $invoicebyuid[$uid] = [];
            }
            $invidbyday = self::UpdateInvoice($uid, $starttime, $end)["data"];

            $m = FINANCIAL_INVOICETREEHOUR_ADMIN::GetListOfTreesByInvoiceID($invoiceid);
            $invoiceDay["data"][$i]["Trees"] = $m;

            $ot = [];

            for ($j = 0; $j < count($m["data"]); $j++) {
                $sid = $m["data"][$j]["fit_sid"];
                $ip = $m["data"][$j]["fit_sname"];

                $treeid = FINANCIAL_INVOICETREEDAY_ADMIN::UpdateByInvoiceID(
                    $invidbyday,
                    $m["data"][$j]["fitdecription"],
                    "cloud",
                    $sid,
                    $ip,
                    $starttime,
                    $end
                )["id"];

                //$serverIP = mb_substr($m["data"][$j]["fitdecription"], 14);
                $s = FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::GetListByServiceIDWithDateRange(
                    $m["data"][$j]["fit_sid"],
                    $starttime,
                    $end,
                    $prc
                );
                $invoiceDay["data"][$i]["Trees"]["data"][$j]["Details"] = $s;

                $k = 0;
                $n = "";


                for ($c = 0; $c < count($s["data"]); $c++) {

                    if ($c > 0) {
                        if ($s["data"][$c]["fid_calculateditem"] == $s["data"][$c - 1]["fid_calculateditem"]) {
                            if ($s["data"][$c]["fid_count"] == $s["data"][$c - 1]["fid_count"]) {
                                $ot[$k]["fid_endtime"] = $s["data"][$c]["fid_endtime"];
                                $ot[$k]["fid_price"] = $ot[$k]["fid_price"] + $s["data"][$c]["fid_price"];
                                $ot[$k]["countofHours"] = $ot[$k]["countofHours"] + 1;
                                // $ot[$sid][$k]["countofHours".$c] = $k."//". $c."//".$s["data"][$c]["fidid"]."//".$s["data"][$c]["fid_sid_fk"]
                                //  ."//".$s["data"][$c]["fid_endtime"]."//".$s["data"][$c]["fid_calculateditem"];
                                // $ot[$sid][$k]["countofHours".$s["data"][$c]["fidid"]]=$s["data"][$c];
                            } else {
                                $k++;
                                $ot[$k] = $s["data"][$c];
                                $ot[$k]["fid_starttime"] = $s["data"][$c]["fid_endtime"];
                                $ot[$k]["countofHours"] = 0;
                                $ot[$k]["stat"] = 2;
                            }
                        } else {
                            if ($s["data"][$c]["fid_calculateditem"] != $s["data"][$c - 1]["fid_calculateditem"]) {
                                if ($s["data"][$c]["fid_count"] == $s["data"][$c - 1]["fid_count"]) {
                                    $k++;
                                    $ot[$k] = $s["data"][$c];
                                    $ot[$k]["fid_endtime"] = $s["data"][$c]["fid_endtime"];

                                    if(!isset($ot[$k]["fid_price"]))
                                        $ot[$k]["fid_price"]=0;
                                    $ot[$k]["fid_price"] = $ot[$k]["fid_price"] + $s["data"][$c]["fid_price"];
                                    $ot[$k]["countofHours"] = 1;
                                    $ot[$k]["stat"] = 3;
                                } else {
                                    $k++;
                                    $ot[$k] = $s["data"][$c];
                                    $ot[$k]["countofHours"] = 1;
                                    $ot[$k]["stat"] = 4;
                                }
                            }
                        }
                    } else {
                        $ot[0] = $s["data"][$c];
                        $ot[0]["countofHours"] = 1;
                    }
                }
                $output["inv" . $invidbyday] = 0;
                $otprice = 0;
                // return $ot;
                $cql=[];
                foreach ($ot  as $ab) {
                    $otprice = $otprice + $ab["fid_price"];
                    $cql[]=FINANCIAL_INVOICEDETAILSBYDAY_ADMIN::AddInvoiceDetails(
                        $treeid,
                        $ab["fid_details"] . " برای " . $ab["countofHours"] . " ساعت",
                        $ab["fid_price"],
                        $ab["fid_calculateditem"],
                        $ab["fid_count"],
                        $ab["fid_sid_fk"],
                        $ab["fid_starttime"],
                        $ab["fid_endtime"]
                    );
                }

                $output["inv" . $invidbyday] = $output["inv" . $invidbyday] + $otprice;
                FINANCIAL_INVOICETREEDAY_ADMIN::UpdatePriceJob($otprice, $treeid);
                // $a = CREADITDETAILS_ADMIN::AddCreditDetails(
                //     "سرور ابری IP :" .
                //         $ip . "(" . $starttime . "-" . $end . ")",
                //     $otprice * (-1),
                //     $uid,
                //     9
                // );
            }
        }
        foreach ($output as $key => $value) {
            $invoiceid = substr($key, 3);
            $price = $value;
            FINANCIAL_INVOICEBYDAY_ADMIN::UpdatePrice("cloud", $price, $invoiceid);
        }

        return INVOICE_LOG_ADMIN::UpdateLastTimeLog("CloudInvoiceDaily", $end);
    }
    public static function RunJobForCalculateAndGenerateInvoiceForLiveStream()
    {
        mb_internal_encoding('utf-8');
        $starttime = jDateTime::date("Y/m/d 00:00:00", strtotime("-1 day"));
        $end =  jDateTime::date("Y/m/d 00:00:00");
        $invoiceDay = FINANCIAL_INVOICEBYHOUR_ADMIN::GetInvoicesForDay($starttime, $end);

        $dateForCreateFolder = jDateTime::date("Ymd");
        $users = [];
        $invoicebyuid = [];
        $output = [];
        $pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("LiveStream");
        $prc = [];
        foreach ($pricelist["data"] as $pr) {
            $prc[$pr["dp_category"]] = $pr["dp_price"];
        }
        if ($invoiceDay["status"] == "error") {
            return;
        };
        for ($i = 0; $i < count($invoiceDay["data"]); $i++) {

            $uid = $invoiceDay["data"][$i]["i_uid_fk"];
            $invoiceid = $invoiceDay["data"][$i]["iid"];

            $path = $GLOBALS["RootFiles"] . "/invoices/user/" . $invoiceDay["data"][$i]["i_uid_fk"] .
                "/invoicedata/hourly/" . $dateForCreateFolder;
            if (!file_exists($path)) {
                mkdir($path, 0700, true);
            }
            if (!in_array($uid, $users)) {
                array_push($users, $uid);
                $invoicebyuid[$uid] = [];
            }
            $invidbyday = self::UpdateInvoice($uid, $starttime, $end)["data"];

            $m = FINANCIAL_INVOICETREEHOUR_ADMIN::GetListOfTreesByInvoiceID($invoiceid, "live");
            $invoiceDay["data"][$i]["Trees"] = $m;
            $ot = [];

            for ($j = 0; $j < count($m["data"]); $j++) {
                $sid = $m["data"][$j]["fit_sid"];
                $ip = $m["data"][$j]["fit_sname"];

                $treeid = FINANCIAL_INVOICETREEDAY_ADMIN::UpdateByInvoiceID(
                    $invidbyday,
                    $m["data"][$j]["fitdecription"],
                    "live",
                    $sid,
                    $ip,
                    $starttime,
                    $end
                )["id"];

                $s = FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::GetListByServiceIDWithDateRange(
                    $m["data"][$j]["fit_sid"],
                    $starttime,
                    $end,
                    $prc
                );

                $invoiceDay["data"][$i]["Trees"]["data"][$j]["Details"] = $s;

                $k = 0;
                $n = "";
                for ($c = 0; $c < count($s["data"]); $c++) {

                    if ($c > 0) {
                        if ($s["data"][$c]["fid_calculateditem"] == $s["data"][$c - 1]["fid_calculateditem"]) {
                            if ($s["data"][$c]["fid_count"] == $s["data"][$c - 1]["fid_count"]) {
                                $ot[$k]["fid_endtime"] = $s["data"][$c]["fid_endtime"];
                                $ot[$k]["fid_price"] = $ot[$k]["fid_price"] + $s["data"][$c]["fid_price"];
                                $ot[$k]["countofHours"] = $ot[$k]["countofHours"] + 1;
                                // $ot[$sid][$k]["countofHours".$c] = $k."//". $c."//".$s["data"][$c]["fidid"]."//".$s["data"][$c]["fid_sid_fk"]
                                //  ."//".$s["data"][$c]["fid_endtime"]."//".$s["data"][$c]["fid_calculateditem"];
                                // $ot[$sid][$k]["countofHours".$s["data"][$c]["fidid"]]=$s["data"][$c];
                            } else {
                                $k++;
                                $ot[$k] = $s["data"][$c];
                                $ot[$k]["fid_starttime"] = $s["data"][$c]["fid_endtime"];
                                $ot[$k]["countofHours"] = 0;
                                $ot[$k]["stat"] = 2;
                            }
                        } else {
                            if ($s["data"][$c]["fid_calculateditem"] != $s["data"][$c - 1]["fid_calculateditem"]) {
                                if ($s["data"][$c]["fid_count"] == $s["data"][$c - 1]["fid_count"]) {
                                    $k++;
                                    $ot[$k] = $s["data"][$c];
                                    $ot[$k]["fid_endtime"] = $s["data"][$c]["fid_endtime"];
                                    $ot[$k]["fid_price"] = $ot[$k]["fid_price"] + $s["data"][$c]["fid_price"];
                                    $ot[$k]["countofHours"] = 1;
                                    $ot[$k]["stat"] = 3;
                                } else {
                                    $k++;
                                    $ot[$k] = $s["data"][$c];
                                    $ot[$k]["countofHours"] = 1;
                                    $ot[$k]["stat"] = 4;
                                }
                            }
                        }
                    } else {
                        $ot[0] = $s["data"][$c];
                        $ot[0]["countofHours"] = 1;
                    }
                }
                $output["inv" . $invidbyday] = 0;
                $otprice = 0;
                // return $ot;
                foreach ($ot  as $ab) {

                    $otprice = $otprice + $ab["fid_price"];
                    FINANCIAL_INVOICEDETAILSBYDAY_ADMIN::AddInvoiceDetails(
                        $treeid,
                        $ab["fid_details"] . " برای " . $ab["countofHours"] . " ساعت",
                        $ab["fid_price"],
                        $ab["fid_calculateditem"],
                        $ab["fid_count"],
                        $ab["fid_sid_fk"],
                        $ab["fid_starttime"],
                        $ab["fid_endtime"]
                    );
                }
                $output["inv" . $invidbyday] = $output["inv" . $invidbyday] + $otprice;
                FINANCIAL_INVOICETREEDAY_ADMIN::UpdatePriceJob($otprice, $treeid);
                CREADITDETAILS_ADMIN::AddCreditDetails(
                    "سرویس پخش زنده  :" .
                        $ip . "(" . $starttime . "-" . $end . ")",
                    $otprice * (-1),
                    $uid,
                    9
                );
            }
        }
        foreach ($output as $key => $value) {
            $invoiceid = substr($key, 3);
            $price = $value;
            $s = FINANCIAL_INVOICEBYDAY_ADMIN::UpdatePrice("live", $price, $invoiceid);
        }
        return $s;
        return INVOICE_LOG_ADMIN::UpdateLastTimeLog("LiveStreamInvoiceDaily", $end);
    }
    public static function ByDayFixer($start, $end)
    {
        $startarr = explode(" ", $start);
        $endarr = explode(" ", $start);
        $getStartDate = explode(" ", $start)[0] . " 00:00:00";
        $getendDate = explode(" ", $end)[0] . " 00:00:00";
        while ($getStartDate <= $getendDate) {

            if ($getStartDate == $getendDate)
                self::RunJobForCalculateAndGenerateInvoiceForCDN($getStartDate, jDateTime::ReturnTimeafterCustomTime($getendDate, "days", 1));
            else
                self::RunJobForCalculateAndGenerateInvoiceForCDN($getStartDate, jDateTime::ReturnTimeafterCustomTime($getStartDate, "days", 1));

            $getStartDate = jDateTime::ReturnTimeafterCustomTime($getStartDate, "days", 1);
        }
    }
    public static function RunJobForCalculateAndGenerateInvoiceForCDN($start = null, $endtime = null)
    {
        mb_internal_encoding('utf-8');
        $starttime = $start;
        $end = $endtime;
        if ($start == null)
            $starttime = jDateTime::date("Y/m/d 00:00:00", strtotime("-1 day"));
        if ($endtime == null)
            $end =  jDateTime::date("Y/m/d 00:00:00");

        $invoiceDay = FINANCIAL_INVOICEBYHOUR_ADMIN::GetInvoicesForDay($starttime, $end, "cdn");
		return $invoiceDay;
        $dateForCreateFolder = jDateTime::date("Ymd");
        $users = [];
        $invoicebyuid = [];
        $output = [];
        $pricelist = FINANCIAL_PRICE_ADMIN::GetPriceListWithByType("cdn");

        $prc = [];
        foreach ($pricelist["data"] as $pr) {
            $prc[$pr["dp_category"]] = $pr["dp_price"];
        }
        if ($invoiceDay["status"] == "error") {
            return;
        };

        for ($i = 0; $i < count($invoiceDay["data"]); $i++) {

			echo "\r\e[2K" . console_text(sprintf('Calculating invoice %s from total %s... (%s)', $i, count($invoiceDay["data"]), round(100 * $i / count($invoiceDay["data"])) . '%'), [CONSOLE['l_blue']]) . "\r";

            if ( empty($invoiceDay["data"][$i]["icdn"]) )
			{
				echo "\n" . console_text("No CDN for time range ", [CONSOLE['yellow']]) . console_text(sprintf("start: %s, end: %s", $start, $endtime), [CONSOLE['l_black']]) . "\n\n";
				continue;
			}

			$uid = $invoiceDay["data"][$i]["i_uid_fk"];
			$invoiceid = $invoiceDay["data"][$i]["iid"];

			$path = $GLOBALS["RootFiles"] . "/invoices/user/" . $invoiceDay["data"][$i]["i_uid_fk"] .
				"/invoicedata/hourly/" . $dateForCreateFolder;

			if (!file_exists($path)) {
				mkdir($path, 0700, true);
			}

			if (!in_array($uid, $users)) {
				array_push($users, $uid);
				$invoicebyuid[$uid] = [];
			}

			$invidbyday = self::UpdateInvoice($uid, $starttime, $end)["data"];

			$m = FINANCIAL_INVOICETREEHOUR_ADMIN::GetListOfTreesByInvoiceID($invoiceid, "cdn");
			$invoiceDay["data"][$i]["Trees"] = $m;

			$ot = [];

			for ($j = 0; $j < count($m["data"]); $j++) {

				// debug_msg("info", sprintf('Calculating tree %s from total %s...', $j, count($m["data"])));

				if ($m["data"][$j]["fit_ifield"] == "cdn") {
					// if($m["data"][$j]["fit_ifield"]=="cdn")

					$sid = $m["data"][$j]["fit_sid"];
					$ip = $m["data"][$j]["fit_sname"];

					// debug_msg("info", "Updating CDN invoice tree...");

					$treeid = FINANCIAL_INVOICETREEDAY_ADMIN::UpdateByInvoiceID(
						$invidbyday,
						$m["data"][$j]["fitdecription"],
						"cdn",
						$sid,
						$ip,
						$starttime,
						$end
					)["id"];

					// $serverIP = mb_substr($m["data"][$j]["fitdecription"], 14);
					$s = FINANCIAL_INVOICEDETAILSBYHOUR_ADMIN::GetListByServiceIDWithDateRange(
						$m["data"][$j]["fit_sid"],
						$starttime,
						$end,
						$prc
					);
					$invoiceDay["data"][$i]["Trees"]["data"][$j]["Details"] = $s;

					$k = 0;

					for ($c = 0; $c < count($s["data"]); $c++) {

						if ($c > 0) {
							if ($s["data"][$c]["fid_calculateditem"] == $s["data"][$c - 1]["fid_calculateditem"]) {
								if ($s["data"][$c]["fid_count"] == $s["data"][$c - 1]["fid_count"]) {
									$ot[$k]["fid_endtime"] = $s["data"][$c]["fid_endtime"];
									$ot[$k]["fid_price"] = $ot[$k]["fid_price"] + $s["data"][$c]["fid_price"];
									$ot[$k]["countofHours"] = $ot[$k]["countofHours"] + 1;
									// $ot[$sid][$k]["countofHours".$c] = $k."//". $c."//".$s["data"][$c]["fidid"]."//".$s["data"][$c]["fid_sid_fk"]
									//  ."//".$s["data"][$c]["fid_endtime"]."//".$s["data"][$c]["fid_calculateditem"];
									// $ot[$sid][$k]["countofHours".$s["data"][$c]["fidid"]]=$s["data"][$c];
								} else {
									$k++;
									$ot[$k] = $s["data"][$c];
									$ot[$k]["fid_starttime"] = $s["data"][$c]["fid_endtime"];
									$ot[$k]["countofHours"] = 0;
									$ot[$k]["stat"] = 2;
								}
							} else {
								if ($s["data"][$c]["fid_calculateditem"] != $s["data"][$c - 1]["fid_calculateditem"]) {
									if ($s["data"][$c]["fid_count"] == $s["data"][$c - 1]["fid_count"]) {
										$k++;
                                        $ot[$k] = $s["data"][$c];
										$ot[$k]["fid_endtime"] = $s["data"][$c]["fid_endtime"];
										$ot[$k]["fid_price"] = $ot[$k]["fid_price"] + $s["data"][$c]["fid_price"];
										$ot[$k]["countofHours"] = 1;
										$ot[$k]["stat"] = 3;
									} else {
										$k++;
										$ot[$k] = $s["data"][$c];
										$ot[$k]["countofHours"] = 1;
										$ot[$k]["stat"] = 4;
									}
								}
							}
						} else {
							$ot[0] = $s["data"][$c];
							$ot[0]["countofHours"] = 1;
						}
					}
					$output["inv" . $invidbyday] = 0;
					$otprice = 0;
					foreach ($ot  as $ab) {
						$otprice = $otprice + $ab["fid_price"];
						FINANCIAL_INVOICEDETAILSBYDAY_ADMIN::AddInvoiceDetails(
							$treeid,
							$ab["fid_details"] . " برای " . $ab["countofHours"] . " ساعت",
							$ab["fid_price"],
							$ab["fid_calculateditem"],
							$ab["fid_count"],
							$ab["fid_sid_fk"],
							$ab["fid_starttime"],
							$ab["fid_endtime"]
						);
					}

					$output["inv" . $invidbyday] = $output["inv" . $invidbyday] + $otprice;
					FINANCIAL_INVOICETREEDAY_ADMIN::UpdatePriceJob($otprice, $treeid);
					$a = self::UpdatePriceJob("cdn", $otprice, $invidbyday);
					// $a=CREADITDETAILS_ADMIN::AddCreditDetails(
					//     "سرور ابری IP :" .
					//         $ip . "(" . $starttime . "-" . $end . ")",
					//     $otprice * (-1),
					//     $uid,
					//     9
					// );
				}
			}
        }

        return $a;

        return   INVOICE_LOG_ADMIN::UpdateLastTimeLog("CDNInvoiceDaily", $end);
    }

    //     mb_internal_encoding('utf-8');
    //     $starttime = jDateTime::date("Y/m/d 00:00:00", strtotime("-1 day"));
    //     $end =  jDateTime::date("Y/m/d 00:00:00");
    //   $sql="SELECT * FROM tbl_users,tbl_domains where d_status!=2  and uid=d_user_id_fk and  d_plan!='free'";
    //     $conn = GetConnection();
    //     $result = $conn->query($sql);
    //     if (!$result || mysqli_num_rows($result) == 0) {
    //         $res = ["status" => "error"];
    //     } else {
    //         $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
    //         $conn->close();
    //         foreach($list as $l){
    //             if(!isset(ReturnPlans()[$l["d_plan"]])){

    //             }
    //             else{
    //                 $planPrice=ReturnPlans()[$l["d_plan"]];
    //                 //ADD DAILY DETAILS
    //                 $websitename=$l["d_name"] ;

    //                 $s=self::GetInvoiceDetails($l["uid"], $starttime);

    //                   $tree=FINANCIAL_INVOICETREEDAY_ADMIN::UpdateByInvoiceID($s["data"][0]["iidd"], "مصرف CDN برای سایت".$websitename." پلان ".$l["d_plan"]
    //                   , "cdn",
    //                   $l["domain_id"],
    //                   $websitename,
    //                   $starttime,
    //                   $end);
    //                 FINANCIAL_INVOICETREEDAY_ADMIN::UpdatePriceJob($planPrice["price"], $tree["id"]);
    //                 FINANCIAL_INVOICEDETAILSBYDAY_ADMIN::AddInvoiceDetails($tree["id"], "مصرف CDN برای سایت".$websitename." پلان ".$l["d_plan"],$planPrice["price"],"cdn",
    //                          1,$l["domain_id"],$starttime,$end);
    //                 if($tree["status"]=="success"){
    //                 $a=self::UpdatePriceJob("cdn",$planPrice["price"] , $s["data"][0]["iidd"]);
    //                 }

    //                  //$planPrice["price"];
    //             }

    //         }

    //     }

    //      return   INVOICE_LOG_ADMIN::UpdateLastTimeLog("CDNInvoiceDaily",$end);

}
