<?php

	function console_text(string $str, array $attrs = [])
	{
		if ( empty($GLOBALS['is_cli']) )
		{
			$classes = ['console-text'];
			foreach (array_map('trim', $attrs) as $attr)
				$classes []= 'ansi-' . $attr;
			return sprintf('<span class="%s">%s</span>', implode(' ', $classes), htmlentities($str));
		}
		else
		{
			$classes = [];
			foreach (array_map('trim', $attrs) as $attr)
				$classes []= sprintf("\e[%sm", $attr);
			return sprintf("%s%s%s", implode('', $classes), $str, sprintf("\e[%sm", 0));
		}

		return $str;
	}

	function debug_msg(string $title, string $message, bool|int $return = false)
	{
		echo "\r";

		if ( empty($return) || is_bool($return) )
			echo "\e[s\e[K"; // save cursor and clear line

		echo sprintf("%s %s %s\e[K",
			console_text('|' . date('H:i:s') . '|', [CONSOLE['l_black']]),
			console_text($title, [CONSOLE['bold'], CONSOLE['l_yellow']]),
			console_text($message, []),
		);

		if ($return) echo "\e[u"; // restore cursor
		else echo "\n";
	}

	define ('CONSOLE', array(
		"off"           => 0,

		"bold"          => 1,
		"dim"           => 2,
		"italic"        => 3,
		"underline"     => 4,
		"blink"         => 5,
		"inverse"       => 7,
		"hidden"        => 8,
		"strikethrough" => 9,

		"black"         => 30,
		"red"           => 31,
		"green"         => 32,
		"yellow"        => 33,
		"blue"          => 34,
		"magenta"       => 35,
		"cyan"          => 36,
		"white"         => 37,

		"black_bg"      => 40,
		"red_bg"        => 41,
		"green_bg"      => 42,
		"yellow_bg"     => 43,
		"blue_bg"       => 44,
		"magenta_bg"    => 45,
		"cyan_bg"       => 46,
		"white_bg"      => 47,

		"gray"          => 90,

		"l_black"       => 90,
		"l_red"         => 91,
		"l_green"       => 92,
		"l_yellow"      => 93,
		"l_blue"        => 94,
		"l_magenta"     => 95,
		"l_cyan"        => 96,
		"l_white"       => 97,

		"l_black_bg"    => 100,
		"l_red_bg"      => 101,
		"l_green_bg"    => 102,
		"l_yellow_bg"   => 103,
		"l_blue_bg"     => 104,
		"l_magenta_bg"  => 105,
		"l_cyan_bg"     => 106,
		"l_white_bg"    => 107
	));
