<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/waf/waf_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/wafrules/admin/wafrules_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/waf/waf.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/wafrules/wafrules.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';

class WAF_ADMIN
{
    public static function CheckWafForDownGrade($domainID, $plan, $newplan)
    {

        if (isset(ReturnPlans()[$plan]["waf"])) {
            if (!isset(ReturnPlans()[$newplan]["waf"])) {
                $sql = "SELECT * FROM tbl_domains,tbl_websites, tbl_waf where domain_id=ws_domainid_fk and  wsid=w_ws_id_fk   and ws_domainid_fk=" . $domainID;
                $conn = GetConnection();
                $result = $conn->query($sql);
                if (!$result || mysqli_num_rows($result) == 0) {
                    $conn->close();
                    $result = ["status" => "success"];
                    return $result;
                } else {
                    $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
                    $conn->close();
                    foreach ($list as $l) {
                        $websitename = $l["d_name"];
                        if ($l["d_name"] != $l["ws_recordname"])
                            $websitename = $l["ws_recordname"] . "." . $l["d_name"];
                        return ["status" => "error", "wid" => $l["wsid"], "message" => "شما در سایت " .
                            $websitename
                            . "  WAF فعال لایه " .
                            $l["w_level"]
                            . " را فعال دارید که امکان کاهش پلان وجود ندارد"];
                    }
                }
            } else {
                $currentWafPlan = ReturnPlans()[$plan]["waf"];
                $NewWafPlan = ReturnPlans()[$newplan]["waf"];
                $sql = "SELECT * FROM tbl_domains,tbl_websites, tbl_waf where domain_id=ws_domainid_fk and  wsid=w_ws_id_fk  and ws_stauts=1 and ws_domainid_fk=" . $domainID;
                $conn = GetConnection();
                $result = $conn->query($sql);
                if (!$result || mysqli_num_rows($result) == 0) {
                    $conn->close();
                    $result = ["status" => "success"];
                    return $result;
                } else {
                    $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
                    $conn->close();
                    foreach ($list as $l) {
                        $websitename = $l["d_name"];
                        if ($l["d_name"] != $l["ws_recordname"])
                            $websitename = $l["ws_recordname"] . "." . $l["d_name"];
                        if ($l["w_level"] > $NewWafPlan) {
                            return ["status" => "error", "wid" => $l["wsid"], "message" => "شما در سایت " .
                                $websitename
                                . "  WAF فعال لایه " .
                                $l["w_level"]
                                . " را فعال دارید که امکان کاهش پلان وجود ندارد"];
                        }
                        return ["status" => "success"];
                    }
                    return ["status" => "success"];
                }
                return ["status" => "success"];
            }
            return ["status" => "success"];
        }
        return ["status" => "success"];
    }
    public static function GetListOfActiveWaf($token, $websiteID)
    {
        $wfl = [
            "1" => "سرویس امنیتی لایه 1",
            "2" => "سرویس امنیتی لایه 2",
            "3" => "فعالسازی هر دو لایه امنیتی"
        ];
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            $conn->close();
            return [
                "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $sql = "SELECT " . $GLOBALS['w_level'] . " as  WafLevel  " .
            " FROM " . $GLOBALS["waf_tablename"] . " WHERE "
            . $GLOBALS['w_ws_id_fk'] . "=" . $websiteID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error", "message" => "شما سرویس امنیتی برای این وب سایت فعال نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(200);
            $dsRules = WAF_ADMIN::GetListOfDisabledRules($websiteID);
            $listOfRecordType = [
                "status" => "success", "message" => "اطلاعات با موفقیت دریافت شد",
                "data" => $list,
                "disabledrules" => $dsRules
            ];
        }

        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function removeWaf($token, $websiteid, $waflevel)
    {
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websiteaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($websiteaccess["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(302);
            return [
                "status" => "error", "code" => "302", "message" => "شما اجازه دسترسی به این وب سایت را ندارید"
            ];
        }

        $sql = "DELETE FROM " . $GLOBALS['waf_tablename'] . " WHERE " . $GLOBALS['w_ws_id_fk'] . "=" . $websiteid;

        $conn = GetConnection();
        $result = $conn->query($sql);
        $dmn = TOOLS_ADMIN::ReturnDomainName($websiteaccess);
        API_WAF_ADMIN::RunDisableAPIWAF($dmn, $waflevel);
        return ["status" => "success", "message" => "سرویس امنیتی درخواستی شما با موفقیت غیر فعال شد"];
    }
    public static function GetOneByWebsite($websiteid)
    {
        $sql = "SELECT " . $GLOBALS['wid'] . " as  id,w_level as waf_level, " . $GLOBALS['w_disabled_rules_l1'] . " as rules_level1,"
            . $GLOBALS['w_disabled_rules_l2'] . " as rules_level2"
            . " FROM " . $GLOBALS["waf_tablename"] . " WHERE "
            . $GLOBALS['w_ws_id_fk'] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error", "message" => "خطا در مقادیر ارسالی"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(200);
            $listOfRecordType = [
                "status" => "success",
                "id" => $list[0]["id"],
                "level" => $list[0]["waf_level"],
                "rules_level1" => $list[0]["rules_level1"],
                "rules_level2" => $list[0]["rules_level2"]
            ];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function ActivateWaf($token, $websiteid, $waflevel)
    {
        $wfl = [
            "1" => "سرویس امنیتی لایه 1",
            "2" => "سرویس امنیتی لایه 2",
            "3" => "فعالسازی هر دو لایه امنیتی"
        ];

        if (!array_key_exists($waflevel, $wfl)) {
            return [
                "status" => "error", "code" => "300", "message" => "سرویس waf درخواستی شما نامعتبر است "
            ];
        }
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websiteaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($websiteaccess["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(302);
            return [
                "status" => "error", "code" => "302", "message" => "شما اجازه دسترسی به این وب سایت را ندارید"
            ];
        }

        $planwebsite = $websiteaccess["data"][0]["wsplan"];
        $plans = ReturnPlans();
        if (isset($plans[$planwebsite])) {
            if (isset($plans[$planwebsite]["waf"])) {
                if (intVal($waflevel) > intVal($plans[$planwebsite]["waf"])) {
                    return [
                        "status" => "error",
                        "current" => WAF_ADMIN::GetListOfActiveWaf($token, $websiteid),
                        "message" => "شما امکان انتخاب این مورد را ندارید و باید پلان سایت خود را ارتقا دهید ",
                        "plans" => CheckPlanRequest("waf")
                    ];
                }
            } else {
                return ["status" => "error", "current" => WAF_ADMIN::GetListOfActiveWaf($token, $websiteid), "action" => "needtoupgrade", "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید"];
            }
        } else {
            return ["status" => "error",  "current" => WAF_ADMIN::GetListOfActiveWaf($token, $websiteid), "message" =>  "پلان وب سایت شما نامشخص است"];
        }
        $currentWafplan = WAF_ADMIN::GetOneByWebsite($websiteid);
        if ($currentWafplan["status"] == "error") {
            $sql = "INSERT INTO " . $GLOBALS['waf_tablename'] . " (" . $GLOBALS['w_ws_id_fk'] . "," . $GLOBALS['w_level']
                . "," . $GLOBALS['w_disabled_rules_l1'] . "," . $GLOBALS['w_disabled_rules_l2'] . " )
           VALUES(" . $websiteid . "," . $waflevel . ",'','')";
        } else {
            $sql = "UPDATE " . $GLOBALS['waf_tablename'] . " SET " . $GLOBALS['w_level']
                . "='" . $waflevel . "' WHERE " . $GLOBALS['w_ws_id_fk'] . "=" . $websiteid;
        }

        $dmn = "";
        if ($websiteaccess["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websiteaccess["data"][0]["d_name"];
        } else {
            $dmn = $websiteaccess["data"][0]["ws_recordname"] . "." . $websiteaccess["data"][0]["d_name"];
        }
        switch ($waflevel) {
            case 1:
                // API_WAF_ADMIN::RunDisableAPIWAF($dmn, 2);
                switch ($currentWafplan["level"]) {
                    case 2:
                        API_WAF_ADMIN::RunDisableAPIWAF($dmn, 2);
                        break;
                }
            case 2:
                // API_WAF_ADMIN::RunDisableAPIWAF($dmn, 1);
                switch ($currentWafplan["level"]) {
                    case 1:
                        API_WAF_ADMIN::RunDisableAPIWAF($dmn, 1);
                        break;
                }
        }

        if ($waflevel == "3") {
            switch ($currentWafplan["level"]) {
                case 1:
                    API_WAF_ADMIN::RunCreateAPIWAF($dmn, 2);
                    break;
                case 2:
                    API_WAF_ADMIN::RunCreateAPIWAF($dmn, 1);
                    break;
            }
        } else {
            switch ($currentWafplan["level"]) {
                case 3:
                    switch ($waflevel) {
                        case 1:
                            API_WAF_ADMIN::RunDisableAPIWAF($dmn, 2);
                            break;
                        case 2:
                            API_WAF_ADMIN::RunDisableAPIWAF($dmn, 1);
                            break;
                    }
            }
            if ($currentWafplan["level"] != 3)
                API_WAF_ADMIN::RunCreateAPIWAF($dmn, $waflevel);
        }
        $conn = GetConnection();
        $result = $conn->query($sql);
        return ["status" => "success",  "current" => WAF_ADMIN::GetListOfActiveWaf($token, $websiteid), "message" => "سرویس امنیتی درخواستی شما با موفقیت افزوده شد"];
    }
    public static function GetOneDisabledRulesWithWebsite($websiteid, $ruleid)
    {
        $sql = "SELECT * FROM " . $GLOBALS["waf_disabled_rules_tablename"] . " WHERE "
            . $GLOBALS['wdr_websiteid_fk'] . "=" . $websiteid . " AND " . $GLOBALS['wdr_ruleid'] . "='" . $ruleid . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error", "message" => "خطا در مقادیر ارسالی"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = ["status" => "success"];
        }
        $result->free_result();
        $conn->close();
        return $listOfRecordType;
    }
    public static function DeleteRules($ruleid, $websiteid)
    {
        $sql = "delete  from " . $GLOBALS["waf_disabled_rules_tablename"] . " WHERE "
            . $GLOBALS['wdr_websiteid_fk'] . "=" . $websiteid . " AND " . $GLOBALS['wdr_ruleid'] . "='" . $ruleid . "'";
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
        return "";
    }
    public static function UpdateRules($sruleid, $ruleid, $websiteid, $waflevel, $action)
    {
        if ($action == "enable") {
            WAF_ADMIN::DeleteRules($ruleid, $websiteid);
        }
        if ($action == "disable") {
            if (WAF_ADMIN::GetOneDisabledRulesWithWebsite($websiteid, $ruleid)["status"] == "error") {
                $sql = "INSERT INTO " . $GLOBALS["waf_disabled_rules_tablename"] . " ( "
                    . $GLOBALS['wdr_websiteid_fk'] . "," . $GLOBALS['wdr_waf_level'] . "," .
                    $GLOBALS['wdr_ruleid'] . "," . $GLOBALS['wdr_server_ruleid'] . ") VALUES(" . $websiteid . "," .
                    $waflevel . ",'" . $ruleid . "','" . $sruleid . "')";
                $conn = GetConnection();
                $conn->query($sql);
                $conn->close();
            }
        }
        return [WAF_ADMIN::UPDATEAPI($websiteid, $waflevel, $sruleid, $action), $sruleid, $ruleid, $websiteid, $waflevel, $action];
        return ["status" => "success", "message" => "سرویس امنیتی درخواستی شما با موفقیت ویرایش شد"];
    }
    public static function UPDATEAPI($websiteid, $waflevel, $sruleid, $action)
    {
        $websiteaccess = WEBSITES_ADMIN::WebsiteDetails($websiteid);

        $dmn = TOOLS_ADMIN::ReturnDomainName($websiteaccess);
        if ($action == "enable")
            $a = API_WAFRULES_ADMIN::RunDisableAPIRulesManagement($dmn, $waflevel, $sruleid);
        else if ($action == "disable")
            $a = API_WAFRULES_ADMIN::RunCreateAPIRulesManagement($dmn, $waflevel, $sruleid);

        return [$sruleid, $a];
    }
    public static function RulesManagement($token, $websiteid, $ruleid, $action)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(301);
            return [
                "status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
            ];
        }
        $uid = $usersDetails["userdetail"][0]["uid"];

        $websiteaccess = WEBSITES_ADMIN::UserCanAccessToWebsite($uid, $websiteid);
        if ($websiteaccess["status"] == "error") {
            VARS_ADMIN::ReturnHeadersState(302);
            return [
                "status" => "error", "code" => "302", "message" => "شما اجازه دسترسی به این وب سایت را ندارید"
            ];
        }
        if (WAF_ADMIN::GetOneByWebsite($websiteid)["status"] == "error") {
            return ["status" => "error", "message" => "شما سرویس waf فعالی برای این وب سایت ندارید"];
        } else {
            $wf = WAFRULES_ADMIN::CheckRuleIsCorrectWithID($ruleid);
            if ($wf["status"] == "success") {

                $r = WAF_ADMIN::UpdateRules(
                    $wf["data"][0]["SRuleID"],
                    $ruleid,
                    $websiteid,
                    $wf["data"][0]["WafLevel"],
                    $action
                );
                $listOfRecordType = [
                    "status" => "success", "message" => "اطلاعات با موفقیت ثبت شد", $r
                ];

                return $listOfRecordType;
            } else {
                return ["status" => "error", "message" => "شناسه Rule درخواستی شما نامعتبر است"];
            }
        }

        return ["status" => "success", "message" => "سرویس امنیتی درخواستی شما با موفقیت ویرایش شد"];
    }
    public static function GetListOfDisabledRules($websiteID)
    {

        $sql = "SELECT " . $GLOBALS['wdr_waf_level'] . " as  WafLevel ," .
            $GLOBALS['wdr_ruleid'] . " as RuleID ,wr_rule_description as WafRuleDescription "
            . " FROM " . $GLOBALS["waf_disabled_rules_tablename"] . ",tbl_waf_rules WHERE wdr_ruleid = wr_urule_id and "
            . $GLOBALS['wdr_websiteid_fk'] . "=" . $websiteID . " ORDER BY  WafLevel "; // .$GLOBALS['wdr_waf_level'];
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            VARS_ADMIN::ReturnHeaders(200);
            $result = ["status" => "error", "message" => "شما قانونی را غیر فعال نکرده اید"];
            return $result;
        } else {
            $list = mysqli_fetch_all($result, MYSQLI_ASSOC);
            VARS_ADMIN::ReturnHeaders(200);
            $waflevel1 = [];
            $waflevel2 = [];
            foreach ($list as $l) {
                if ($l["WafLevel"] == "1")
                    array_push($waflevel1, $l);
                else if ($l["WafLevel"] == "2")
                    array_push($waflevel2, $l);
            }
            $listOfRecordType = [

                "WafLevel1" => $waflevel1,
                "WafLevel2" => $waflevel2,
            ];
            return $listOfRecordType;
        }
    }
}
