<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/users_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/userverification/admin/userverification_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/include/sms.php';
require_once $GLOBALS["RootFiles"] . '/include/tools.php';
require_once $GLOBALS["RootFiles"] . '/userlogs/userpanel/logs.php';

class USERS_ADMIN
{
	public static function CheckAndAddAnnounce($uid, $state, $reset = "false")
	{
		/**
		 *  uaid Primary
		 *   ua_uid_fk
		 *  ua_state
		 *   ua_count
		 *  tbl_user_announce
		 */
		$now = jDateTime::date("Y/m/d H:i:s");
		$conn = GetConnection();
		if ($reset == "false") {
			$sql = "SELECT * FROM  tbl_user_announce where ua_uid_fk=" . $uid . " AND ua_state='" . $state . "'";
			$result = $conn->query($sql);
			if (!$result || mysqli_num_rows($result) == 0) {
				$sql = "INSERT INTO tbl_user_announce VALUES(0,'" . $uid . "','" . $state . "',1,'" . $now . "')";
				$conn->query($sql);
				$conn->close();
				$result = ["status" => "inserted", $sql];
				return $result;
			} else {
				$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
				if (intval($listOfRecordType[0]["ua_count"]) < 2) {
					$sql = "UPDATE tbl_user_announce SET ua_count=" . (intVal($listOfRecordType[0]["ua_count"]) + 1) . ",ua_date='" . $now . "' where uaid=" . $listOfRecordType[0]["uaid"];
					$conn->query($sql);
					$conn->close();
					$result = ["status" => "updated", $sql];
					return $result;
				} else {
					return ["status" => "duplicated", $sql];
				}
			}
		} else {
			$sql = "SELECT * FROM  tbl_user_announce where ua_uid_fk=" . $uid . " AND ua_state='" . $state . "'";
			$result = $conn->query($sql);
			if (!$result || mysqli_num_rows($result) == 0) {
				$sql = "INSERT INTO tbl_user_announce VALUES('" . $uid . "','" . $state . "',0,'" . $now . "')";
				$conn->query($sql);
				$conn->close();
				$result = ["status" => "inserted"];
				return $result;
			} else {
				$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
				$sql = "UPDATE tbl_user_announce SET ua_count=0,ua_date='" . $now . "' where uaid=" . $listOfRecordType[0]["uaid"];
				$conn->query($sql);
				$conn->close();
			}
		}
	}
	public static function GETUSERByMobile($mobile)
	{
		$sql = "SELECT uname as name,ufamily as family,uindividual as usertype from " . $GLOBALS["users_tablename"] . "
         WHERE umobile='" . $mobile . "'";
		$conn = GetConnection();
		$result = $conn->query($sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "کاربری با شماره ارسالی دریافت نشد"];
			return $result;
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		}
		$conn->close();
		return ["status" => "success", "plan" => "gold", "data" => $listOfRecordType];
	}
	public static function GenerateHash($length = 64)
	{
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$string = '';

		for ($i = 0; $i < $length; $i++) {
			$string .= $characters[mt_rand(0, strlen($characters) - 1)];
		}

		return $string;
	}
	public static function GetList()
	{
		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"];
		$conn = GetConnection();
		$result = $conn->query($sql);
		$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetRecordWithParameter($fieldname, $fieldvalue)
	{
		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] . " WHERE " . $GLOBALS[$fieldname] . " LIKE '%" . $fieldvalue . "%'";
		$conn = GetConnection();
		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["result" => "null"];
			return $result;
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetOneByID($uid)
	{

		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] . " where uid=" . $uid;
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["result" => "null"];
			return $result;
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
		}
		$result->free_result();

		$conn->close();
		return ["result" => "success", "data" => $listOfRecordType];
	}
	public static function AddUsers($uname, $ufamily, $umail, $unationalid, $uindividual, $ustatus, $umobile, $upass, $uip)
	{
		$conn = GetConnection();
		$sql = "INSERT INTO " . $GLOBALS['users_tablename'] . "(" . $GLOBALS['uname'] . "," .
			$GLOBALS['ufamily'] . "," . $GLOBALS['umail'] . "," . $GLOBALS['unationalid'] . "," . $GLOBALS['uindividual']
			. "," . $GLOBALS['ustatus'] . "," . $GLOBALS['umobile'] . "," . $GLOBALS['usessionkey'] . "," . $GLOBALS['upass']
			. "," . $GLOBALS['uregistrationdate'] . "," . $GLOBALS['ulastloginip'] . "," . $GLOBALS['ulastlogin'] .
			"," . $GLOBALS['uexp_session'] .
			",usetting ) VALUES ('%s','%s','%s','%s',%s,%s,'%s','%s','%s','%s','%s','%s','%s','{}')";
		$now = date("Y-m-d H:i:s");
		$sessionkey = USERS_ADMIN::GenerateHash();
		$expsession = jDateTime::date("Y/m/d H:i:s", strtotime("+2 days"));

		$sql = sprintf(
			$sql,
			$uname,
			$ufamily,
			$umail,
			$unationalid,
			$uindividual,
			0,
			$umobile,
			$sessionkey,
			md5($upass),
			$now,
			$uip,
			$now,
			$expsession
		);

		if ($conn->query($sql) === TRUE) {
			VARS_ADMIN::ReturnHeaders(200);
			$resp = USERSVERIFICATION_ADMIN::AddRecord($conn->insert_id);
			$token = self::GenerateToken($conn->insert_id);
			LOGS_ADMIN::AddLog("عضویت کاربر در سایت", $conn->insert_id, 0, "", "users");
			$vfcode = $resp["smscode"];
			SMSCLASS::SendSMSForVerifyUser($umobile, '24cx5b0wio', $vfcode);
			LOGS_ADMIN::AddLog("ارسال پیامک تاییدیه", $conn->insert_id, 0, "", "users");

			$response = [
				"message" => "کاربر جدید با موفقیت افزوده شد و کد تاییدیه به شماره ثبت شده ارسال شد ",
				"data" => ["token" =>  $token],
				"uid" => $conn->insert_id
			];

			// $mailTemplate = '
			//   %s عزیز
			//                 <br />
			//     ثبت نام شما در میزبان کلود با موفقیت انجام شد؛
			//     <br />
			//     هم اکنون شما عضوی از خانواده میزبان کلود هستید،
			//     <br />
			//     از حسن انتخاب شما سپاسگزاریم!
			//     <br />
			//     از این پس می توانید با استفاده از جزئیات زیر وارد حساب کاربری خود در میزبان کلود شوید:
			//     <br />
			//     آدرس ایمیل: %s
			//     <br />
			//     رمز عبور: رمز عبور انتخای شما
			//     <br />
			//     آدرس ناحیه کاربری میزبان کلود: https://portal.mizbancloud.com
			//     <br />
			//     در صورت نیاز به راهنمایی و کسب اطلاعات در خصوص سرویس های میزبان کلود، از طریق راه های ارتباطی زیر با تیم پشتیبانی میزبان کلود در ارتباط باشید.
			//     <br />
			//             ';
			// $uname = $uname . " " . $ufamily;
			// $mailTemplate = sprintf($mailTemplate, $uname, $umail);
			// $params = [
			//     "param1" => $uname,
			// ];
			// $o = EMAILCLASS::SendEmailPanel($umail, "به میزبان کلود خوش آمدید", $mailTemplate, "success", "ilamrdzppx", $params, $umobile);

			$conn->close();
			return $response;
		} else {
			VARS_ADMIN::ReturnHeaders(406);
			$response = [
				"status" => "error", "message" => "خطا در ارتباط لطفا دقایقی دیگر مجدد بررسی نمایید", $conn->error
			];
			$conn->close();
			return $response;
		}
	}
	public static function UpdateVerifiedUserEmail($uid, $mail)
	{
		$conn = GetConnection();
		$sql = "UPDATE " . $GLOBALS['users_tablename'] . " SET " .
			$GLOBALS['umail'] . "='%s'  WHERE " . $GLOBALS['uid'] . "=%s";
		$sql = sprintf($sql, $mail, $uid);

		if ($conn->query($sql) === TRUE) {
			VARS_ADMIN::ReturnHeaders(200);
			$response = ["message" => "ایمیل شما  با موفقیت ویرایش شد ", "status" => "success"];
			LOGS_ADMIN::AddLog("تغییر ایمیل  حساب کاربری", $uid, 0, "", "users");

			return $response;
		} else {
			VARS_ADMIN::ReturnHeaders(400);
			$response = ["message" => "خطا در مقادیر ورودی", "status" => "error"];
			return $response;
		}

		$conn->close();
	}
	public static function UpdateVerifiedUserMobile($uid, $umobile)
	{
		$conn = GetConnection();
		$sql = "UPDATE " . $GLOBALS['users_tablename'] . " SET " .
			$GLOBALS['umobile'] . "='%s'  WHERE " . $GLOBALS['uid'] . "=%s";
		$sql = sprintf($sql, $umobile, $uid);

		if ($conn->query($sql) === TRUE) {
			VARS_ADMIN::ReturnHeaders(200);
			$response = ["message" => "شماره همراه  شما  با موفقیت ویرایش شد ", "status" => "success"];
			LOGS_ADMIN::AddLog("تغییر شماره همراه حساب کاربری", $uid, 0, "", "users");

			return $response;
		} else {
			VARS_ADMIN::ReturnHeaders(400);
			$response = ["message" => "خطا در مقادیر ورودی", "status" => "error"];
			return $response;
		}

		$conn->close();
	}
	public static function ChangeUserPassword($newpassword, $uid)
	{
		$conn = GetConnection();
		$sql = "UPDATE " . $GLOBALS['users_tablename'] . " SET " .
			$GLOBALS['upass'] . "='%s'  WHERE " . $GLOBALS['uid'] . "=%s";
		$sql = sprintf($sql, md5($newpassword), $uid);

		if ($conn->query($sql) === TRUE) {
			VARS_ADMIN::ReturnHeaders(200);
			$response = ["message" => "رمز عبور  با موفقیت ویرایش شد ", "status" => "success"];
			LOGS_ADMIN::AddLog("تغییر رمز عبور حساب کاربری", $uid, 0, "", "users");

			return $response;
		} else {
			VARS_ADMIN::ReturnHeaders(400);
			$response = ["message" => "خطا در مقادیر ورودی", "status" => "error"];
			return $response;
		}

		$conn->close();
	}
	public static function UpdateNewPassword($token, $newpassword, $oldpassword)
	{
		$usersDetails = self::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			VARS_ADMIN::ReturnHeadersState(301);
			return [
				"status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
			];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] . " WHERE "
			. $GLOBALS['uid'] . "=" . $uid . " AND " . $GLOBALS['upass'] . "='" . md5($oldpassword) . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "رمز عبور فعلی شما نامعتبر است"];
			return $result;
		}
		$result->free_result();
		$conn->close();
		return self::ChangeUserPassword($newpassword, $uid);
	}
	public static function GetUserinfoWithoutOwn($fieldname, $fieldvalue, $uid)
	{
		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] .
			" WHERE " . $GLOBALS[$fieldname] . " ='" . $fieldvalue . "'
        and uid!=" . $uid;
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error"];
			return $result;
		} else {
			$listOfRecordType = [
				$sql,
				"status" => "success",

			];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function UpdateUsers(
		$uname,
		$ufamily,
		$umail,
		$unationalid,
		$uindividual,
		$ustatus,
		$umobile,
		$token
	) {
		$usersDetails = self::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			VARS_ADMIN::ReturnHeadersState(301);
			return [
				"status" => "error", "code" => "301", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"
			];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];

		if (self::GetUserinfoWithoutOwn($GLOBALS['umobile'], $umobile, $uid)["status"] == "success") {
			return [
				"status" => "error", "code" => "301", self::GetUserinfoWithoutOwn($GLOBALS['umobile'], $umobile, $uid), $usersDetails,
				"message1" => "شماره موبایل وارد شده تکراری است"
			];
		}
		if ($usersDetails["userdetail"][0]["umobile"] != $umobile) {
			USERCHANGETEMP_ADMIN::AddRecord(
				$uid,
				2,
				$umobile,
				// $usersDetails["userdetail"][0]["umobile"]
				$umobile
			);
			$response = [
				"status" => "success", "mobile" => "true",
				"message" => "لطفا کد دریافتی در پیامک را جهت تغییر شماره همراه وارد نمایید  "
			];
			return $response;
			// self::ChangeUserStatus("45",$uid);
		}
		// if ($usersDetails["userdetail"][0]["umail"] != $umail) {
		//     USERCHANGETEMP_ADMIN::AddRecord(
		//         $uid,
		//         1,
		//         $umail,
		//         $usersDetails["userdetail"][0]["umail"]
		//     );
		// }
		$conn = GetConnection();
		$sql = "UPDATE " . $GLOBALS['users_tablename'] . " SET " .
			$GLOBALS['uindividual'] . "=%s WHERE uid=%s";
		$sql = sprintf($sql,  $uindividual, $uid);

		if ($conn->query($sql) === TRUE) {
			$response = ["status" => "success", "mobile" => "false", "message" => "کاربر  با موفقیت ویرایش شد"];
		} else {
			$response = ["status" => "error", "message" => "خطا در مقادیر ورودی"];
		}

		$conn->close();

		return $response;
	}
	public static function ChangeUserStatus($status, $uid)
	{
		$sql = "UPDATE " . $GLOBALS["users_tablename"] . " SET " .
			$GLOBALS['ustatus'] . "=" . $status . " WHERE " .
			$GLOBALS['uid'] . "=" . $uid;
		$conn = GetConnection();

		if ($conn->query($sql) === TRUE) {
			$result = ["status" => "success", "result" => "درخواست شما با موفقیت انجام شد"];
			return $result;
		} else {
			$result = ["status" => "error", "result" => "خطا در مقادیر ورودی"];
			return $result;
		}

		$conn->close();
	}
	public static function GetByMail($mail)
	{
		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] .
			" WHERE " . $GLOBALS['umail'] . " ='" . $mail . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error"];
			return $result;
		} else {
			$listOfRecordType = [
				"status" => "success",
				"data" => mysqli_fetch_all($result, MYSQLI_ASSOC)
			];
		}
		$result->free_result();
		$conn->close();
		return $listOfRecordType;
	}
	public static function CheckTwoFA($mail, $pass, $ip, $code)
	{
		$udet = self::GetByMail($mail);
		if ($udet["status"] == "error") {
			return ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
		} else {
			$u = USERTWOFACTOR_ADMIN::CheckCodeisCorrect($udet["data"][0]["uid"], $code);
			if ($u["status"] == "error") {
				return ["status" => "error", "message" => "کد وارد شده اشتباه است"];
			} else {
				return self::CheckLogin($mail, $pass, $ip, $checkedTwoFA = true);
			}
		}
	}
	public static function GetUserSetting($token)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$uid = $usersDetails["userdetail"][0]["uid"];
		$sql = "SELECT usetting as usersetting from tbl_users where uid=" . $uid;
		$conn = GetConnection();
		$result = mysqli_query($conn, $sql);
		$res = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$conn->close();
		return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد", "data" => json_decode($res[0]["usersetting"], true)];
	}
	public static function UpdateUsersetting($token, $key, $value)
	{
		$usersDetails = USERS_ADMIN::GetOneByToken($token);
		if ($usersDetails["status"] == "error") {
			return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
		}
		$currentSetting = self::GetUserSetting($token)["data"];
		$currentSetting[$key] = $value;
		$uid = $usersDetails["userdetail"][0]["uid"];
		$sql = "UPDATE tbl_users set  usetting='" . json_encode($currentSetting) . "' where uid=" . $uid;
		$conn = GetConnection();
		mysqli_query($conn, $sql);
		$conn->close();
		return ["status" => "success", "message" => "اطلاعات با موفقیت دریافت شد"];
	}
	public static function CheckLogin($mail, $pass, $ip, $checkedTwoFA = false)
	{
		// return $GLOBALS["apidomain"]."/apibackend/users/admin/users.sendtwofamobile.php?ml=";
		$userExistByMail = self::GetByMail($mail);
		$expsession = jDateTime::date("Y/m/d H:i:s", strtotime("+2 days"));
		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] . " WHERE " . $GLOBALS['umail'] . "='" . $mail . "' and " .
			$GLOBALS['upass'] . "='" . md5($pass) . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			if ($userExistByMail["status"] == "success") {
				$usetting = USERSETTING_ADMIN::GetOneByID($userExistByMail["data"][0]["uid"]);
				if ($usetting["data"]["onenter"] == "true") {
					if ($usetting["data"]["on_failed_login"] == "sms") {
						// SMSCLASS::SendSMSForLoginFaild(
						//     $userExistByMail["data"][0]["uname"],
						//     $userExistByMail["data"][0]["umobile"]
						// );
						$url = $GLOBALS["apidomain"] . "apibackend/users/admin/users.sendloginfailedmobile.php?ml=" . $userExistByMail["data"][0]["umobile"] . "&name=" . $userExistByMail["data"][0]["uname"];
						$curl = curl_init();
						$post['test'] = 'examples daata'; // our data todo in received
						curl_setopt($curl, CURLOPT_URL, $url);
						curl_setopt($curl, CURLOPT_POST, TRUE);
						curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
						curl_setopt($curl, CURLOPT_USERAGENT, 'api');
						curl_setopt($curl, CURLOPT_TIMEOUT, 1);
						curl_setopt($curl, CURLOPT_HEADER, 0);
						curl_setopt($curl, CURLOPT_RETURNTRANSFER, false);
						curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
						curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
						curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
						curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
						curl_exec($curl);
						curl_close($curl);
						// return $url ;
					} else if ($usetting["data"]["on_failed_login"] == "email") {
						$url = $GLOBALS["apidomain"] . "apibackend/users/admin/users.sendloginfailedmail.php?ml=" . $mail . "&ip=" . $ip;
						$curl = curl_init();
						$post['test'] = 'examples daata'; // our data todo in received
						curl_setopt($curl, CURLOPT_URL, $url);
						curl_setopt($curl, CURLOPT_POST, TRUE);
						curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
						curl_setopt($curl, CURLOPT_USERAGENT, 'api');
						curl_setopt($curl, CURLOPT_TIMEOUT, 1);
						curl_setopt($curl, CURLOPT_HEADER, 0);
						curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
						curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
						curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
						curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
						curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
						curl_exec($curl);
						curl_close($curl);
					} else {

						$url = $GLOBALS["apidomain"] . "apibackend/users/admin/users.sendloginfailedmobile.php?ml=" . $userExistByMail["data"][0]["umobile"] . "&name=" . $userExistByMail["data"][0]["uname"];
						$curl = curl_init();
						$post['test'] = 'examples daata'; // our data todo in received
						curl_setopt($curl, CURLOPT_URL, $url);
						curl_setopt($curl, CURLOPT_POST, TRUE);
						curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
						curl_setopt($curl, CURLOPT_USERAGENT, 'api');
						curl_setopt($curl, CURLOPT_TIMEOUT, 1);
						curl_setopt($curl, CURLOPT_HEADER, 0);
						curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
						curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
						curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
						curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
						curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
						curl_exec($curl);
						curl_close($curl);

						$url2 = $GLOBALS["apidomain"] . "apibackend/users/admin/users.sendloginfailedmail.php?ml=" . $mail . "&ip=" . $ip;
						$curl2 = curl_init();
						curl_setopt($curl2, CURLOPT_URL, $url2);
						curl_setopt($curl2, CURLOPT_POST, TRUE);
						curl_setopt($curl2, CURLOPT_POSTFIELDS, $post);
						curl_setopt($curl2, CURLOPT_USERAGENT, 'api');
						curl_setopt($curl2, CURLOPT_TIMEOUT, 1);
						curl_setopt($curl2, CURLOPT_HEADER, 0);
						curl_setopt($curl2,  CURLOPT_RETURNTRANSFER, false);
						curl_setopt($curl2, CURLOPT_FORBID_REUSE, true);
						curl_setopt($curl2, CURLOPT_CONNECTTIMEOUT, 1);
						curl_setopt($curl2, CURLOPT_DNS_CACHE_TIMEOUT, 1);
						curl_setopt($curl2, CURLOPT_FRESH_CONNECT, true);
						curl_exec($curl2);
						curl_close($curl2);
					}
				}
			}
			$result = ["status" => "error", "message" => "اطلاعات ورود اشتباه است"];
			$conn->close();
			return $result;
		} else {

			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			if ($listOfRecordType[0]["ustatus"] != 1) {

				$result->free_result();
				//header("Status: 400");
				$now = jDateTime::date("Y-m-d H:i:s");
				$uvdetails = USERSVERIFICATION_ADMIN::GetOneByID($listOfRecordType[0]["uid"]);
				$nhas =  self::GenerateToken($listOfRecordType[0]["uid"]);

				$sql2 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " .
					$GLOBALS['ulastloginip'] . "='" . $ip . "' WHERE " .
					$GLOBALS['uid'] . "=" . $listOfRecordType[0]["uid"];

				$sql3 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " . $GLOBALS['ulastlogin'] . "='" . $now . "' WHERE " . $GLOBALS['uid'] . "=" . $listOfRecordType[0]["uid"];
				$sql4 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " . $GLOBALS['usessionkey'] . "='" . $nhas . "' WHERE " . $GLOBALS['uid'] . "=" . $listOfRecordType[0]["uid"];
				$sql5 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " . $GLOBALS['uexp_session'] . "='" . $expsession . "' WHERE " . $GLOBALS['uid'] . "=" . $listOfRecordType[0]["uid"];
				$conn->query($sql2);
				$conn->query($sql3);
				$conn->query($sql4);
				$conn->query($sql5);
				$emailvf = $uvdetails["data"][0]["uvemail_status"] ?? "1";
				$mobilevf = $uvdetails["data"][0]["uvmobile_status"] ?? "0";
				$result = [
					"status" => "error", "message" => "اطلاعات کاربر هنوز تایید نشده است", "token" => $nhas,
					"email" => $emailvf, "mobile" => $mobilevf
				];
				$conn->close();
				return $result;
			} else {

				$uid = $listOfRecordType[0]["uid"];
				$usetting = USERSETTING_ADMIN::GetOneByID($listOfRecordType[0]["uid"]);
				if ($checkedTwoFA == false) {
					if ($usetting["data"]["2fa"] == "1") {
						$twofacode = rand(10000, 99999);
						USERTWOFACTOR_ADMIN::AddRecord($uid, $twofacode);
						if ($usetting["data"]["2fa_annouce"] == "sms") {
							$message = "کد ورود دومرحله ای به   موبایل شما ارسال شد ";
							$url = $GLOBALS["apidomain"] . "/apibackend/users/admin/users.sendtwofamobile.php?ml=" . $listOfRecordType[0]["umobile"] . "&cd=" . $twofacode;
							$curl = curl_init();
							$post['test'] = 'examples daata'; // our data todo in received
							curl_setopt($curl, CURLOPT_URL, $url);
							curl_setopt($curl, CURLOPT_POST, TRUE);
							curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
							curl_setopt($curl, CURLOPT_USERAGENT, 'api');
							curl_setopt($curl, CURLOPT_TIMEOUT, 1);
							curl_setopt($curl, CURLOPT_HEADER, 0);
							curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
							curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
							curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
							curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
							curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
							curl_exec($curl);
							curl_close($curl);
						} else if ($usetting["data"]["2fa_annouce"] == "email") {
							$message = "کد ورود دومرحله ای به ایمیل   شما ارسال شد ";

							$url = $GLOBALS["apidomain"] . "/apibackend/users/admin/users.sendtowfamail.php?ml=" . $mail . "&cd=" . $twofacode;
							$curl = curl_init();
							$post['test'] = 'examples daata'; // our data todo in received
							curl_setopt($curl, CURLOPT_URL, $url);
							curl_setopt($curl, CURLOPT_POST, TRUE);
							curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
							curl_setopt($curl, CURLOPT_USERAGENT, 'api');
							curl_setopt($curl, CURLOPT_TIMEOUT, 1);
							curl_setopt($curl, CURLOPT_HEADER, 0);
							curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
							curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
							curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
							curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
							curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
							curl_exec($curl);
							curl_close($curl);
						} else {
							//SEND EMAIL & SMS
							$message = "کد ورود دومرحله ای به ایمیل و موبایل شما ارسال شد ";
							$url = $GLOBALS["apidomain"] . "/apibackend/users/admin/users.sendtowfamail.php?ml=" . $listOfRecordType[0]["umail"] . "&cd=" . $twofacode;
							$curl = curl_init();
							$post['test'] = 'examples daata'; // our data todo in received
							curl_setopt($curl, CURLOPT_URL, $url);
							curl_setopt($curl, CURLOPT_POST, TRUE);
							curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
							curl_setopt($curl, CURLOPT_USERAGENT, 'api');
							curl_setopt($curl, CURLOPT_TIMEOUT, 1);
							curl_setopt($curl, CURLOPT_HEADER, 0);
							curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
							curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
							curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
							curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
							curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
							curl_exec($curl);
							curl_close($curl);

							$url = $GLOBALS["apidomain"] . "/apibackend/users/admin/users.sendtwofamobile.php?ml=" . $listOfRecordType[0]["umobile"] . "&cd=" . $twofacode;
							$curl = curl_init();
							$post['test'] = 'examples daata'; // our data todo in received
							curl_setopt($curl, CURLOPT_URL, $url);
							curl_setopt($curl, CURLOPT_POST, TRUE);
							curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
							curl_setopt($curl, CURLOPT_USERAGENT, 'api');
							curl_setopt($curl, CURLOPT_TIMEOUT, 1);
							curl_setopt($curl, CURLOPT_HEADER, 0);
							curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
							curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
							curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
							curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
							curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
							curl_exec($curl);
							curl_close($curl);
						}
						return ["status" => "pending", "message" => $message];
					}
				}
			}

			$now = jDateTime::date("Y-m-d H:i:s");
			$nhas = self::GenerateToken($uid);

			$sql2 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " .
				$GLOBALS['ulastloginip'] . "='" . $ip . "' WHERE " .
				$GLOBALS['uid'] . "=" . $listOfRecordType[0]["uid"];
			$sql3 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " . $GLOBALS['ulastlogin'] . "='" . $now . "' WHERE " . $GLOBALS['uid'] . "=" . $listOfRecordType[0]["uid"];
			$sql4 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " . $GLOBALS['usessionkey'] . "='" . $nhas . "' WHERE " . $GLOBALS['uid'] . "=" . $listOfRecordType[0]["uid"];
			$sql5 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " . $GLOBALS['uexp_session'] . "='" . $expsession . "' WHERE " . $GLOBALS['uid'] . "=" . $listOfRecordType[0]["uid"];
			//header("Status: 200");
			$conn->query($sql2);
			$conn->query($sql3);
			$conn->query($sql4);
			$conn->query($sql5);
			$result = mysqli_query($conn, $sql);
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);
			unset($listOfRecordType[0]["upass"]);
			//unset($listOfRecordType[0]["ustatus"]);
			$individual = $listOfRecordType[0]["uindividual"];
			$uid = $listOfRecordType[0]["uid"];
			$listOfRecordType[0]["individual"] = $individual;
			if ($individual == 2) {
				$org = USERSORGANIZE_ADMIN::GetOneByUserID($uid);
				$listOfRecordType[0]["organize"] = $org;
			}
			unset($listOfRecordType[0]["uindividual"]);

			unset($listOfRecordType[0]["uid"]);

			$listOfRecordType[0]["token"] = $listOfRecordType[0]["usessionkey"];
			unset($listOfRecordType[0]["usessionkey"]);

			$usetting = USERSETTING_ADMIN::GetOneByID($userExistByMail["data"][0]["uid"]);

			if ($usetting["data"]["onenter"] == "true") {
				if ($usetting["data"]["on_success_login"] == "sms") {
					$url = $GLOBALS["apidomain"] . "/apibackend/users/admin/users.sendsuccessloginmobile.php?ml=" . $listOfRecordType[0]["umobile"] . "&name=" . $listOfRecordType[0]["uname"];
					$curl = curl_init();
					$post['test'] = 'examples daata'; // our data todo in received
					curl_setopt($curl, CURLOPT_URL, $url);
					curl_setopt($curl, CURLOPT_POST, TRUE);
					curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
					curl_setopt($curl, CURLOPT_USERAGENT, 'api');
					curl_setopt($curl, CURLOPT_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_HEADER, 0);
					curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
					curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
					curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
					curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
					curl_exec($curl);
					curl_close($curl);
				} else if ($usetting["data"]["2fa_annouce"] == "email") {
					$url = $GLOBALS["apidomain"] . "/apibackend/users/admin/users.sendsuccessloginmail.php?ml=" . $userExistByMail["data"][0]["umail"] . "&ip=" . $ip;
					$curl = curl_init();
					$post['test'] = 'examples daata'; // our data todo in received
					curl_setopt($curl, CURLOPT_URL, $url);
					curl_setopt($curl, CURLOPT_POST, TRUE);
					curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
					curl_setopt($curl, CURLOPT_USERAGENT, 'api');
					curl_setopt($curl, CURLOPT_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_HEADER, 0);
					curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
					curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
					curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
					curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
					curl_exec($curl);
					curl_close($curl);
				} else {

					$url = $GLOBALS["apidomain"] . "/apibackend/users/admin/users.sendsuccessloginmail.php?ml=" . $userExistByMail["data"][0]["umail"] . "&ip=" . $ip;
					$curl = curl_init();
					$post['test'] = 'examples daata'; // our data todo in received
					curl_setopt($curl, CURLOPT_URL, $url);
					curl_setopt($curl, CURLOPT_POST, TRUE);
					curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
					curl_setopt($curl, CURLOPT_USERAGENT, 'api');
					curl_setopt($curl, CURLOPT_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_HEADER, 0);
					curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
					curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
					curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
					curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
					curl_exec($curl);
					curl_close($curl);

					$url = $GLOBALS["apidomain"] . "/apibackend/users/admin/users.sendsuccessloginmobile.php?ml=" . $listOfRecordType[0]["umobile"] . "&name=" . $listOfRecordType[0]["uname"];
					$curl = curl_init();
					$post['test'] = 'examples daata'; // our data todo in received
					curl_setopt($curl, CURLOPT_URL, $url);
					curl_setopt($curl, CURLOPT_POST, TRUE);
					curl_setopt($curl, CURLOPT_POSTFIELDS, $post);
					curl_setopt($curl, CURLOPT_USERAGENT, 'api');
					curl_setopt($curl, CURLOPT_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_HEADER, 0);
					curl_setopt($curl,  CURLOPT_RETURNTRANSFER, false);
					curl_setopt($curl, CURLOPT_FORBID_REUSE, true);
					curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 1);
					curl_setopt($curl, CURLOPT_DNS_CACHE_TIMEOUT, 1);
					curl_setopt($curl, CURLOPT_FRESH_CONNECT, true);
					curl_exec($curl);
					curl_close($curl);
				}
			}

			$resp = ["status" => "success", "message" => "اطلاعات کاربر صحیح است ", "data" => $listOfRecordType[0]];
			// LOGS_ADMIN::AddLog("ورود به حساب کاربری", $uid, 0, "", "users");
		}
		$result->free_result();
		$conn->close();
		return $resp;
	}
	public static function checknationalCode($nc)
	{
		if (!preg_match('/^[0-9]{10}$/', $nc))
			return false;
		for ($i = 0; $i < 10; $i++)
			if (preg_match('/^' . $i . '{10}$/', $nc))
				return false;
		for ($i = 0, $sum = 0; $i < 9; $i++)
			$sum += ((10 - $i) * intval(substr($nc, $i, 1)));
		$ret = $sum % 11;
		$parity = intval(substr($nc, 9, 1));
		if (($ret < 2 && $ret == $parity) || ($ret >= 2 && $ret == 11 - $parity))
			return true;
		return false;
	}
	public static function CheckMobile($mno)
	{
		if (preg_match("/^09[0-9]{9}$/", $mno)) {
			return true;
		} else {
			return false;
		}
	}
	public static function GetActiveUserInfo($uid)
	{
		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] . " where ustatus=1 and " . $GLOBALS['uid'] . "=" . $uid;
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "error", "message" => "کاربر مورد نظر یافت نشد"];
			return $result;
		} else {
			$listOfRecordType = ["status" => "success", mysqli_fetch_all($result, MYSQLI_ASSOC)];
		}
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function CheckUserExist($uid)
	{
		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] .
			" where ustatus=1 and " . $GLOBALS['uid'] . "=" . $uid;
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = [
				"status" => "error",
				"message" =>
				"کاربر مورد نظر یافت نشد یا کاربر تایید نشده است "
			];
			return $result;
		} else {
			$listOfRecordType = [
				"status" => "success",
				mysqli_fetch_all($result, MYSQLI_ASSOC)
			];
		}
		$result->free_result();

		$conn->close();
		return $listOfRecordType;
	}
	public static function CheckSessionExist($token)
	{
		self::DeleteUnUsedToken();
		$expsession = jDateTime::date("Y/m/d H:i:s", strtotime("+2 days"));
		$now = jDateTime::date("Y/m/d H:i:s");

		$sql = "SELECT * FROM " . $GLOBALS['sessions_tablename'] . "," . $GLOBALS['users_tablename'] . " WHERE "
			. $GLOBALS['ss_token'] . "='" . $token . "' AND " . $GLOBALS['ss_expiredate'] . ">'" . $now
			. "' AND " . $GLOBALS['uid'] . "=" .  $GLOBALS['ss_uid_fk'];

		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$result = ["status" => "expire",  "message" =>
			"کاربر مورد نظر یافت نشد یا کاربر تایید نشده است"];
			return $result;
		} else {
			$listOfRecordType = mysqli_fetch_all($result, MYSQLI_ASSOC);

			$uid = $listOfRecordType[0]["ss_uid_fk"];
			$sql2 = "SELECT * FROM " . $GLOBALS["users_tablename"] .
				" where ustatus=1 and " . $GLOBALS['uid'] . "=" . $uid;
			// $token=self::GenerateToken($uid);
			$now = jDateTime::date("Y-m-d H:i:s");
			$expsession = jDateTime::date("Y/m/d H:i:s", strtotime("+2 days"));
			$result2 = mysqli_query($conn, $sql2);
			$listOfRecordType2 = mysqli_fetch_all($result2, MYSQLI_ASSOC);

			$sql3 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " .
				$GLOBALS['ulastlogin'] . "='" .
				$now . "' WHERE " . $GLOBALS['uid'] . "=" . $uid;
			$sql4 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " .
				$GLOBALS['usessionkey'] . "='" .
				$token . "' WHERE " . $GLOBALS['uid'] . "=" . $uid;
			$sql5 = "UPDATE " . $GLOBALS["sessions_tablename"] . " SET  ss_expiredate='" .
				$expsession . "' WHERE " . $GLOBALS['ss_token'] . "='" .  $token . "'";
			VARS_ADMIN::ReturnHeaders(200);

			$conn->query($sql3);
			//$conn->query($sql4);
			$conn->query($sql5);
			$result = mysqli_query($conn, $sql);
			$result3 = mysqli_query($conn, $sql3);
			$result5 = mysqli_query($conn, $sql5);
			$individual = $listOfRecordType2[0]["uindividual"];
			$uid =  $uid;
			$listOfRecordType2[0]["individual"] = $individual;
			if ($individual == 2) {
				$org = USERSORGANIZE_ADMIN::GetOneByUserID($uid);
				$listOfRecordType2[0]["organize"] = $org;
			}
			$listOfRecordType2[0]["interlid"] = TOOLS_ADMIN::encrypt($listOfRecordType2[0]["uid"]);
			unset($listOfRecordType2[0]["upass"]);
			unset($listOfRecordType2[0]["ustatus"]);
			unset($listOfRecordType2[0]["uindividual"]);
			unset($listOfRecordType2[0]["uid"]);
			$listOfRecordType2[0]["token"] = $token;
			unset($listOfRecordType2[0]["usessionkey"]);
			$resp = [
				"message" => "اطلاعات کاربر مورد تایید است", "status" => "success", $sql5,
				"data" => $listOfRecordType2
			];
		}
		$result->free_result();
		$conn->close();
		return $resp;
	}
	public static function GetUserWithoutToken($uid)
	{
		$conn = GetConnection();

		$sqlusers = "SELECT * FROM " . $GLOBALS['users_tablename'] . " WHERE uid ='" . $uid . "'";
		$rs = mysqli_query($conn, $sqlusers);

		$rss = mysqli_fetch_all($rs, MYSQLI_ASSOC);

		$balance = CREADITBALANCE_ADMIN::GetRecordBalanceWithUserID($uid)["data"][0]["balance"];
		if ($balance < 0) {
			$userDeactiveByCredit = "1";
		}

		$expsess  = jDateTime::date("Y/m/d H:i:s", strtotime("+2 days"));

		$listOfRecordType = [
			$uid,
			"status" => "success",
			"credit" => $balance,
			"userdetail" => $rss
		];
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetOneByToken($token, $action = "checksession", $datas = null)
	{
		self::DeleteUnUsedToken();
		// $expsession = jDateTime::date("Y/m/d H:i:s");

		// $sql = "SELECT * FROM " . $GLOBALS["users_tablename"] . " WHERE " .
		//     $GLOBALS['usessionkey'] . "='" . $token . "'
		//    and " . $GLOBALS['uexp_session'] . " > '" . $expsession . "'";
		// $conn = GetConnection();

		// $result = mysqli_query($conn, $sql);
		// if (!$result || mysqli_num_rows($result) == 0) {

		//     $result = ["status" => "error", "message" => "توکن ارسالی شما نامعتبر است"];
		//     return $result;
		// }
		// $res = mysqli_fetch_all($result, MYSQLI_ASSOC);
		// $uid = $res[0]["uid"];
		// $balance = CREADITBALANCE_ADMIN::GetRecordBalanceWithUserID($uid)["data"][0]["balance"];
		// if ($balance < 0) {
		//     $userDeactiveByCredit = "1";
		// }

		// $expsess  = jDateTime::date("Y/m/d H:i:s", strtotime("+1 hours"));

		// $sql5 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " .
		//     $GLOBALS['uexp_session'] . "='" .
		//     $expsess . "' WHERE " . $GLOBALS['uid'] . "=" . $res[0]["uid"];
		// $conn->query($sql5);
		// $result = mysqli_query($conn, $sql5);
		// $listOfRecordType = [
		//     "status" => "success",
		//     "credit" => $balance,
		//     "userdetail" => $res
		// ];
		// $conn->close();
		// return $listOfRecordType;

		$expsession = jDateTime::date("Y/m/d H:i:s");
		$sql = "SELECT * FROM " . $GLOBALS['sessions_tablename'] . " WHERE "
			. $GLOBALS['ss_token'] . "='" . $token . "' AND " . $GLOBALS['ss_expiredate'] . ">'" . $expsession
			. "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {

			$result = ["status" => "error", "message" => "توکن ارسالی شما نامعتبر است"];
			return $result;
		}
		$res = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$uid = $res[0]["ss_uid_fk"];
		$sqlusers = "SELECT * FROM " . $GLOBALS['users_tablename'] . " WHERE uid ='" . $uid . "'";
		$rs = mysqli_query($conn, $sqlusers);

		$rss = mysqli_fetch_all($rs, MYSQLI_ASSOC);

		$balance = CREADITBALANCE_ADMIN::GetRecordBalanceWithUserID($uid)["data"][0]["balance"];
		if ($balance < 0) {
			$userDeactiveByCredit = "1";
		}

		$expsess  = jDateTime::date("Y/m/d H:i:s", strtotime("+2 days"));

		$sql5 = "UPDATE " . $GLOBALS["users_tablename"] . " SET  " .
			$GLOBALS['uexp_session'] . "='" .
			$expsess . "' WHERE " . $GLOBALS['uid'] . "=" .  $uid;

		$sql6 = "UPDATE " . $GLOBALS["sessions_tablename"] . " SET  " .
			$GLOBALS['ss_expiredate'] . "='" .
			$expsess . "' WHERE " . $GLOBALS['ssid'] . "=" .  $uid;

		$conn->query($sql5);
		$conn->query($sql6);

		$result = mysqli_query($conn, $sql5);
		$listOfRecordType = [
			$uid,
			"status" => "success",
			"credit" => $balance,
			"userdetail" => $rss
		];
		$conn->close();
		return $listOfRecordType;
	}
	public static function GetOneByUID($uid)
	{

		$sqlusers = "SELECT * FROM " . $GLOBALS['users_tablename'] . " WHERE " . $GLOBALS['uid'] . "='" . $uid . "'";
		$conn = GetConnection();

		$rs = mysqli_query($conn, $sqlusers);

		$rss = mysqli_fetch_all($rs, MYSQLI_ASSOC);

		$balance = CREADITBALANCE_ADMIN::GetRecordBalanceWithUserID($uid)["data"][0]["balance"];
		if ($balance < 0) {
			$userDeactiveByCredit = "1";
		}
		$listOfRecordType = [
			"status" => "success",
			"credit" => $balance,
			"userdetail" => $rss
		];
		$conn->close();
		return $listOfRecordType;
	}
	public static function ClientChangeInfo($token, $mobile, $email)
	{
		$expsession = jDateTime::date("Y/m/d H:i:s", strtotime("+1 hours"));
		$ud = self::CheckByToken($token);
		if ($ud["status"] == "error") {
			return ["status" => "error", "message" => "اطلاعات ارسالی نامعتبر است"];
		}
		$sql = "SELECT * FROM " . $GLOBALS["users_tablename"] .
			" where ustatus=1 and " . $GLOBALS['uid'] . "='" . $ud["userdetail"][0]["uid"] . "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {
			$res  = [
				"status" => "error",
				"message" => "کاربر مورد نظر یافت نشد یا کاربر تایید نشده است "
			];
			return $res;
		} else {
			$rt = mysqli_fetch_all($result, MYSQLI_ASSOC);
			$uid = $rt[0]["uid"];
			$mobexist = true;
			if ($mobile === $rt[0]["umobile"]) {
				$mobexist = false;
				$sql2 = "UPDATE " . $GLOBALS["users_tablename"] . " SET " .
					$GLOBALS['umail'] . "='" . $email . "'  WHERE " .
					$GLOBALS['uid'] . "='" . $ud["userdetail"][0]["uid"] . "' ";
			} else {
				$sql2 = "UPDATE " . $GLOBALS["users_tablename"] . " SET " .
					$GLOBALS['umobile'] . "='" . $mobile . "'," .
					$GLOBALS['umail'] . "='" . $email . "'," .
					$GLOBALS['ustatus'] . "=0 WHERE " .
					$GLOBALS['uid'] . "='" . $ud["userdetail"][0]["uid"] . "' ";
				USERSVERIFICATION_ADMIN::ResendSMS($token);
			}
			$rst = mysqli_query($conn, $sql2);
			if (!$rst) {
				VARS_ADMIN::ReturnHeaders(406);
				$result = ["message" => "خطا در ارتباط لطفا دقایقی دیگر بررسی نمایید"];
				return $result;
			} else {
				VARS_ADMIN::ReturnHeaders(200);
				$msg = "";
				if ($mobexist) {
					LOGS_ADMIN::AddLog(
						"تغییر شماره همراه ثبت شده در پنل کاربری",
						$uid,
						0,
						"",
						"users"
					);

					$msg = "لطفا کد جدید ارسالی به شماره همراه جدید خود را تایید نمایید";
				} else {
					LOGS_ADMIN::AddLog(
						"تغییر مشخصات ثبت شده در پنل کاربری",
						$uid,
						0,
						"",
						"users"
					);

					VARS_ADMIN::ReturnHeadersState(200);
					$msg = "اطلاعات با موفقیت ویرایش شد ";
				}
				$listOfRecordType = ["message" => $msg];
			}

			$result->free_result();

			$conn->close();
			return $listOfRecordType;
		}
	}
	public static function CheckSession($token)
	{
		$ch = self::GetOneByToken($token);
		return $ch;
		// $now = jDateTime::date("Y/m/d H:i:s");

		// $sql = "SELECT * FROM " . $GLOBALS["users_tablename"] .
		//     " where ustatus=1 and " . $GLOBALS['usessionkey'] . "='" . $token . "' AND " .
		//     $GLOBALS["uexp_session"] . " > '" . $now . "'";
		// $conn = GetConnection();

		// $result = mysqli_query($conn, $sql);
		// if (!$result || mysqli_num_rows($result) == 0) {
		//              //     $result = ["status" => "expire"];
		//     return $result;
		// } else {
		//     $resp = ["status" => "active"];
		// }
		// $result->free_result();

		// $conn->close();
		// return $resp;
	}
	public static function DeleteUser($uid)
	{
		$sql = "DELETE  from " . $GLOBALS["users_tablename"] . " WHERE " . $GLOBALS['uid'] . "=" . $uid;
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);

		$conn->close();
		return null;
	}
	public static function GenerateToken($uid)
	{
		$expsession = jDateTime::date("Y/m/d H:i:s", strtotime("+2 days"));
		$nhas = USERS_ADMIN::GenerateHash(64);
		$sql = "INSERT INTO " . $GLOBALS['sessions_tablename'] . "(" .
			$GLOBALS['ssid'] . "," . $GLOBALS['ss_token'] . "," . $GLOBALS['ss_uid_fk']
			. "," . $GLOBALS['ss_expiredate'] . ") VALUES(0,'" . $nhas . "','" . $uid . "','" . $expsession . "')";
		$conn = GetConnection();
		$conn->query($sql);
		$conn->close();
		return $nhas;
	}
	public static function DeleteUnUsedToken()
	{
		$expsession = jDateTime::date("Y/m/d H:i:s");
		$sql = "DELETE FROM " . $GLOBALS['sessions_tablename'] . " WHERE "
			. $GLOBALS['ss_expiredate'] . "<'" . $expsession
			. "'";
		$conn = GetConnection();

		mysqli_query($conn, $sql);
		$conn->close();
	}
	public static function CheckByToken($token, $action = "checksession", $datas = null)
	{
		return  self::DeleteUnUsedToken();
		$expsession = jDateTime::date("Y/m/d H:i:s");
		$sql = "SELECT * FROM " . $GLOBALS['sessions_tablename'] . " WHERE "
			. $GLOBALS['ss_token'] . "='" . $token . " AND " . $GLOBALS['ss_expiredate'] . ">'" . $expsession
			. "'";
		$conn = GetConnection();

		$result = mysqli_query($conn, $sql);
		if (!$result || mysqli_num_rows($result) == 0) {

			$result = ["status" => "error", "message" => "توکن ارسالی شما نامعتبر است"];
			return $result;
		}
		$res = mysqli_fetch_all($result, MYSQLI_ASSOC);
		$uid = $res[0]["ss_uid_fk"];
		$ssid = $res[0]["ssid"];

		$balance = CREADITBALANCE_ADMIN::GetRecordBalanceWithUserID($uid)["data"][0]["balance"];
		if ($balance < 0) {
			$userDeactiveByCredit = "1";
		}

		$expsess  = jDateTime::date("Y/m/d H:i:s", strtotime("+2 days"));

		$sql5 = "UPDATE " . $GLOBALS["sessions_tablename"] . " SET  " .
			$GLOBALS['ss_expiredate'] . "='" .
			$expsess . "' WHERE " . $GLOBALS['ssid'] . "=" . $ssid;
		$conn->query($sql5);
		$result = mysqli_query($conn, $sql5);
		$sqlselect = "SELECT * FROM " . $GLOBALS['users_tablename'] . " WHERE " . $GLOBALS["uid"]
			. "=" . $uid . " AND " . $GLOBALS['ustatus'] . "=1";
		$resultuser = mysqli_query($conn, $sql);
		if (!$resultuser || mysqli_num_rows($resultuser) == 0) {

			$result = ["status" => "error", "message" => "توکن ارسالی شما نامعتبر است"];
			return $result;
		}
		$userDetails =  mysqli_fetch_all($resultuser, MYSQLI_ASSOC);
		$listOfRecordType = [
			"status" => "success",
			"credit" => $balance,
			"userdetail" => $userDetails
		];
		$conn->close();
		return $listOfRecordType;
	}
	public static function AddUserLog($description, $oldvalue, $newvalue, $action, $uid, $ip)
	{
		$now = jDateTime::date("Y/m/d H:i:s");
		$sql = "INSERT INTO " . $GLOBALS['client_userlog_tablename'] . "(ulid,uldesc,ulold,ulnew,uldatetime,ulaction,ul_uid_fk,ul_ip) VALUES(0,'"
			. $description . "','" . $oldvalue . "','" . $newvalue . "','" . $now . "','" . $action . "','" . $uid . "','" . $ip . "')";
		$conn = GetConnection();
		mysqli_query($conn, $sql);
		$conn->close();
		return $sql;
	}
}
