<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/defaultpage/defaultpage_field_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';

require_once $GLOBALS["RootFiles"] . '/include/tools.php';

class DEFAULTPAGE_ADMIN
{

    public static function CheckDefaultPageForDownGrade($domainID, $currentPlan, $newPlan)
    {
        if (isset(ReturnPlans()[$currentPlan]["customerrorpage"])) {
            if (!isset(ReturnPlans()[$newPlan]["customerrorpage"])) {
                $sql = "SELECT * FROM `tbl_websites`,tbl_domains,`tbl_defaultpages` WHERE domain_id = ws_domainid_fk and `dp_wid_fk`=wsid and domain_id=" . $domainID;
                $conn = GetConnection();
                $result = $conn->query($sql);
                if (!$result || mysqli_num_rows($result) == 0) {
                    $listOfRecordType = ["status" => "success"];
                    $conn->close();
                } else {
                    $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
                    foreach ($r as $f) {
                        $websitename = $f["d_name"];
                        if ($f["d_name"] != $f["ws_recordname"]) {
                            $websitename = $f["ws_recordname"] . "." . $f["d_name"];
                        }
                        return ["status" => "error", "message" => "شما برای سایت " . $websitename . " صفحات خطای اختصاصی ایجاد نموده اید"];
                    }
                    $listOfRecordType = [
                        "status" => "success",
                        "data" => $r
                    ];
                    $conn->close();
                }
                return ["status" => "success"];
            }
        }
        return ["status" => "success"];
    }
    public static function UpdateWebSiteDefaultPage($token, $websiteid, $partofPage, $default, $filecontent, $ipranges)
    {
        $filetype = ["firewall", "underconstruction", "waf", "ratelimit", "servererror"];
        if (!in_array($partofPage, $filetype)) {
            return ["status" => "error", "message" => "بخش درخواستی شما نامعتبر است"];
        }
        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است ", $websitesOwner];
        } else {

            $planwebsite = $websitesOwner["data"][0]["wsplan"];
            $plans = ReturnPlans();
            if (isset($plans[$planwebsite])) {
                if (!isset($plans[$planwebsite]["customerrorpage"])) {
                    return [
                        "status" => "error",
                        "action" => "needtoupgrade",
                        "message" =>  "شما امکان دسترسی به این بخش را ندارید برای استفاده از این قابلیت باید پلان خود را ارتقا دهید ",
                    ];
                }
            } else {
                return ["status" => "error", "message" => "پلان وب سایت شما نامشخص است"];
            }

            if ($ipranges != "null") {

                $ips = explode(",", $ipranges);
                $res = [];
                $stat = 1;
                $success_array = [];
                foreach ($ips as $ip) {
                    if (strpos($ip, '/')) {
                        $nip = explode("/", $ip);
                        if (!filter_var($nip[0], FILTER_VALIDATE_IP)) {
                            $stat = 0;
                            $out["status"] = "error";
                            array_push(
                                $res,
                                ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                            );
                        }
                    } else {
                        if (!filter_var($ip, FILTER_VALIDATE_IP)) {
                            $stat = 0;

                            $out["status"] = "error";
                            array_push(
                                $res,
                                ["status" => "error", "ip" => $ip, "message" => "IP نامعتبر است"]
                            );
                        }
                    }
                }

                if ($stat == 0) {
                    return ["status" => "error", "message" => "خطا در IPهای ارسالی ", "data" => $res];
                }
            }

            $dmn = TOOLS_ADMIN::ReturnDomainName($websitesOwner);

            $folderpath = $GLOBALS["RootFiles"] . '/attachments/htmltemplates/' . $dmn;
            $error = ["firewall" => "403", "underconstruction" => "590", "waf" => "580", "ratelimit" => "503", "servererror" => "502"];

            if (!file_exists($folderpath))
                mkdir($folderpath);

            if ($default == "true") {
                API_CUSTOMERRORPAGES_ADMIN::RunDisableAPIRATELIMIT($dmn, $error[$partofPage]);
                return   DEFAULTPAGE_ADMIN::ChangeToDefaultPage($websiteid, $partofPage, $dmn);
            } else {
                self::RemoveNullRows();
                $out =  DEFAULTPAGE_ADMIN::uploadFile($filecontent, $websiteid, $dmn, $partofPage, $ipranges);
                if ($out["status"] == "error")
                    return $out;

                $oo = API_CUSTOMERRORPAGES_ADMIN::RunCreateAPICUSTOMERRORPAGES($dmn, $error[$partofPage], $partofPage . ".html", $ipranges);
                DEFAULTPAGE_ADMIN::UpdateDB($websiteid, $partofPage, $partofPage, $ipranges);
                return $out;
            }
        }
    }
    public static function ChangeToDefaultPage($websiteID, $filepath, $websitename)
    {
        $sql = " SELECT  * FROM " . $GLOBALS["tbl_defaultpages"] . " WHERE " .
            $GLOBALS['dp_wid_fk'] . "=" . $websiteID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);

        if (!$result || mysqli_num_rows($result) == 0) {
            $r = ["status" => "success", "message" => "درخواست شما انجام شد"];

            $ins = "INSERT INTO " . $GLOBALS["tbl_defaultpages"] . " (" . $GLOBALS["dp_wid_fk"] . ") VALUES(" .
                $websiteID . ")";
        } else {
            $r = ["status" => "success", "message" => "درخواست شما انجام شد ", "filename" => $res[0][$GLOBALS["dp_" . $filepath]]];

            $ins = "UPDATE " . $GLOBALS["tbl_defaultpages"] . " SET " .
                $GLOBALS["dp_" . $filepath] . "= NULL," . $GLOBALS["dp_" . $filepath . "_status"] . "=NULL WHERE "
                . $GLOBALS["dp_wid_fk"] . "=" . $websiteID;
            $output = $GLOBALS["RootFiles"] . '/attachments/htmltemplates/' . $websitename;
            if ($res[0][$GLOBALS["dp_" . $filepath]] != "") {
                if (file_exists($output . '/' . $res[0][$GLOBALS["dp_" . $filepath]])) {
                    unlink($output . '/' . $res[0][$GLOBALS["dp_" . $filepath]]);
                }
            }
        }
        $conn->query($ins);
        $conn->close();
        self::RemoveNullRows();

        return $r;
    }
    public static function RemoveNullRows()
    {
        $sql = " DELETE FROM `tbl_defaultpages` WHERE `dp_servererror` IS NULL and `dp_ratelimit` IS NULL and `dp_waf` IS NULL and `dp_firewall` IS NULL and `dp_underconstruction` IS NULL  ";
        $conn = GetConnection();
        $conn->query($sql);
        $conn->close();
    }
    public static function deleteallbetween($beginning, $end, $string)
    {
        $beginningPos = strpos($string, $beginning);
        $endPos = strpos($string, $end);
        if ($beginningPos === false || $endPos === false) {
            return $string;
        }

        $textToDelete = substr($string, $beginningPos, ($endPos + strlen($end)) - $beginningPos);
        $output = str_replace($textToDelete, '', $string);
        return $output;
    }

    public static function UpdateDB($websiteID, $filepath, $filename, $ipranges)
    {
        $sql = " SELECT  * FROM " . $GLOBALS["tbl_defaultpages"] . " WHERE " .
            $GLOBALS['dp_wid_fk'] . "=" . $websiteID;
        $conn = GetConnection();
        $result = $conn->query($sql);
        $res = mysqli_fetch_all($result, MYSQLI_ASSOC);

        if (!$result || mysqli_num_rows($result) == 0) {
            $result = ["status" => "error"];
            $r = ["status" => "success", "isnew" => "true"];
            if ($ipranges == "null") {
                $ins = "INSERT INTO " . $GLOBALS["tbl_defaultpages"] . " (" . $GLOBALS["dp_" . $filepath]
                    . "," . $GLOBALS["dp_wid_fk"] . ") VALUES(" .
                    "'" . $filename . ".html'," . $websiteID . ")";
            } else {

                $ins = "INSERT INTO " . $GLOBALS["tbl_defaultpages"] . " (" . $GLOBALS["dp_" . $filepath]
                    . "," . $GLOBALS["dp_wid_fk"] . "," . $GLOBALS["dp_" . $filepath . "_status"] . ") VALUES(" .
                    "'" . $filename . ".html'," . $websiteID . ",'" . $ipranges . "')";
            }
        } else {
            $r = ["status" => "success", "isnew" => "false", "filename" => $res[0]["dp_" . $filepath]];
            if ($ipranges == "null") {
                $ins = "UPDATE " . $GLOBALS["tbl_defaultpages"] . " SET " .
                    $GLOBALS["dp_" . $filepath] . "='" . $filename . ".html' WHERE "
                    . $GLOBALS["dp_wid_fk"] . "=" . $websiteID;
            } else {
                $ins = "UPDATE " . $GLOBALS["tbl_defaultpages"] . " SET " .
                    $GLOBALS["dp_" . $filepath] . "='" . $filename . ".html'," . $GLOBALS["dp_" . $filepath . "_status"] . "='" . $ipranges . "' WHERE "
                    . $GLOBALS["dp_wid_fk"] . "=" . $websiteID;
            }
        }
        $conn->query($ins);
        $conn->close();

        return [$r, $ins];
    }
    public static function uploadFile($fileBrowse, $websiteid, $websitename, $fname, $ipranges)
    {

        $resp = [];

        $size   =   $fileBrowse["size"];
        $name   =   $fileBrowse['name'];
        $ext    =   pathinfo($name, PATHINFO_EXTENSION);
        $allowed = array('html');
        $nm = time();

        $output = $GLOBALS["RootFiles"] . '/attachments/htmltemplates/' . $websitename;
        if (in_array($ext, $allowed)) {
            if ((number_format($size / 1048576, 2)) > 1) {
                $response = ["status" => "error", "message" => "حداکثر حجم فایل برای آپلود 1 مگابایت است"];
            } else {
                $string = file_get_contents($fileBrowse["tmp_name"]);
                if (move_uploaded_file($fileBrowse["tmp_name"], $output . '/' . $fname . ".html")) {
                    $file = fopen($output . '/' . $fname . ".html", "w");
                    $str = DEFAULTPAGE_ADMIN::deleteallbetween("<?php", "?>", $string);
                    $str = DEFAULTPAGE_ADMIN::deleteallbetween("<%#", "%>", $str);
                    $str = DEFAULTPAGE_ADMIN::deleteallbetween("<%=", "%>", $str);
                    $str = DEFAULTPAGE_ADMIN::deleteallbetween("<%@", "%>", $str);
                    $str = DEFAULTPAGE_ADMIN::deleteallbetween("<%$", "%>", $str);
                    $str = DEFAULTPAGE_ADMIN::deleteallbetween("<%", "%>", $str);
                    $str = DEFAULTPAGE_ADMIN::deleteallbetween("<?", "%>", $str);

                    fwrite($file, $str);
                    fclose($file);

                    $response = [
                        "status" => "success", "message" => "فایل با موفقیت آپلود شد",
                        "filename" => $name
                    ];
                } else {
                    $response = [
                        "status" => "error", "message" => "اطلاعات ارسالی نامعتبر است",
                        "filename" => $name
                    ];
                }
            }
        } else {
            $response = ["status" => "error", "message" => "فرمت فایل ارسالی نامعتبر است ", "filename" => $name];
        }

        return $response;
    }

    public static function GetListOfFilesForWebSite($token, $websiteid)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        } else {

            $sql = " SELECT IFNULL(" . $GLOBALS['dp_underconstruction'] . ",'Default') as  underconstruction ,
                        " . $GLOBALS['dp_underconstruction_status'] . " as UnderConstructionIP,
                        IFNULL(" . $GLOBALS['dp_firewall'] . ",'Default') as firewall,
                        " . $GLOBALS['dp_firewall_status'] . " as FirewallIP,
                        IFNULL(" . $GLOBALS['dp_waf'] . ",'Default') as waf,
                        " . $GLOBALS['dp_waf_status'] . " as WafIP,
                        IFNULL(" . $GLOBALS['dp_ratelimit'] . ",'Default') as ratelimit,
                        " . $GLOBALS['dp_ratelimit_status'] . " as RatelimitIP,
                        IFNULL(" . $GLOBALS['dp_servererror'] . ",'Default') as  servererror,
                        " . $GLOBALS['dp_servererror_status'] . " as ServerErrorIP
                        FROM " . $GLOBALS["tbl_defaultpages"] . " WHERE " .
                $GLOBALS['dp_wid_fk'] . "=" . $websiteid;

            $conn = GetConnection();
            $result = $conn->query($sql);
            $res = ["status" => "success"];
            if (!$result || mysqli_num_rows($result) == 0) {
                $res = ["status" => "success", "data" => [
                    "underconstruction" => "Default",
                    "firewall" => "Default",
                    "waf" => "Default",
                    "ratelimit" => "Default",
                    "servererror" => "Default"
                ]];
            } else {
                $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
                $res = [
                    "status" => "success",
                    "basepath" => "/attachments/htmltemplates/" .
                        $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"],
                    "data" => [
                        "underconstruction" => [
                            "filename" => $r[0]["underconstruction"],
                            "ip" => explode(",", $r[0]["UnderConstructionIP"])
                        ],
                        "firewall" => [
                            "filename" => $r[0]["firewall"],
                            "ip" => explode(",", $r[0]["FirewallIP"])
                        ],

                        "waf" => [
                            "filename" => $r[0]["waf"],
                            "ip" => explode(",", $r[0]["WafIP"])
                        ],
                        "ratelimit" => [
                            "filename" => $r[0]["ratelimit"],
                            "ip" => explode(",", $r[0]["RatelimitIP"])
                        ],
                        "servererror" => [
                            "filename" => $r[0]["servererror"],
                            "ip" => explode(",", $r[0]["ServerErrorIP"])
                        ]
                    ]
                ];
            }

            return    $res;
        }
    }
}
