<?php
require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/gzip/gzip_filed_web.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/users/admin/users_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/websites/admin/websites_admin_class.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/gzip/gzip.php';

class BACKENDPROTOCOL_ADMIN
{
    public static function CheckRecordHasCluster($websiteid)
    {

        $sql = "SELECT * FROM `tbl_clusters_websites`  WHERE cw_ws_id_fk =" . $websiteid;
        $conn = GetConnection();
        $re = $conn->query($sql);
        if (!$re || mysqli_num_rows($re) == 0) {
            return ["status" => "success"];
        } else {
            return ["status" => "error", "message" => "شما برای این دامنه کلاستر اضافه نموده اید و امکان ویرایش رکورد ندارید"];
        }
    }

    public static function GetWebsiteBACKENDPROTOCOL($token, $websiteid, $ip="127.0.0.1")
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        if (!filter_var($ip, FILTER_VALIDATE_IP)) {
            return ["status" => "error", "message" => "خطا در IP ارسالی"];
        }
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        $websitename=$websitesOwner["data"][0]["d_name"];
        if($websitesOwner["data"][0]["ws_recordname"]!=$websitesOwner["data"][0]["d_name"]){
            $websitename=$websitesOwner["data"][0]["ws_recordname"].".".$websitesOwner["data"][0]["d_name"];
        }
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        if (!filter_var($ip, FILTER_VALIDATE_IP)) {
            return ["status" => "error", "message" => "خطا در IP ارسالی"];
        }

        $sql = "SELECT bpstatus  as BackendStatus FROM " . $GLOBALS["backendprotocol_tablename"] .
            " WHERE " . $GLOBALS["bpwid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $listOfRecordType = [
                "status" => "success", "data" => ["BackendStatus" => "auto"]
            ];
            $conn->close();
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $listOfRecordType = [
                "status" => "success",
                "data" => $r[0]
            ];
            $conn->close();
        }
        USERS_ADMIN::AddUserLog("دریافت اطلاعات از backend protocol برای سایت ".$websitename, "", json_encode($listOfRecordType), "", $uid,$ip);

        return $listOfRecordType;
    }
    public static function InternalChangeDNSRecord($websiteid, $status)
    {
        $sql = "SELECT * FROM tbl_websites,tbl_domains_ns_records WHERE wsid='" . $websiteid . "' and dnr_d_id_fk=ws_domainid_fk and ws_recordname=dnr_name  ";
        $conn = GetConnection();
        $result = $conn->query($sql);
        $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
        if (mysqli_num_rows($result) == 0) {
            $sql = "update tbl_domains set d_defaultwid=" . $websiteid . " where domain_id=(select ws_domainid_fk
                    from tbl_websites where wsid='" . $websiteid . "');
                    update tbl_websites set
                    ws_recordname=(select d_name from tbl_domains,tbl_websites where domain_id=ws_domainid_fk and wsid=" . $websiteid . ")
                    where wsid=" . $websiteid;
            // $sql="SELECT * FROM tbl_websites,tbl_domains,tbl_domains_ns_records where wsid='".$websiteid."' and dnr_d_id_fk=ws_domainid_fk and
            // dnr_d_id_fk=domain_id and ws_recordname=dnr_name";

            $result = $conn->query($sql);

            $sql = "SELECT * FROM tbl_websites,tbl_domains_ns_records where wsid='" . $websiteid . "' and dnr_d_id_fk=ws_domainid_fk and ws_recordname=dnr_name  ";
            $result = $conn->query($sql);
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            if (mysqli_num_rows($result) == 0) {
                return ["status" => "succes"];
            }
        }

        // $sql2="SELECT * FROM  tbl_domains_ns_records where dnr_d_id_fk='".$r[0]["ws_domainid_fk"]."'";
        // $result2 = $conn->query($sql2);
        // $r2 = mysqli_fetch_all($result2, MYSQLI_ASSOC);
        // foreach($r2 as $m){
        //     if($r[0]["ws_recordname"]==$m["dnr_name"]){
        //         $port=0;
        if (strtolower($status) != "automatic") {
            if (strtolower($status) == "http") {
                $port = 80;
            } else {
                $port = 443;
            }
        }
        $sql3 = "update tbl_domains_ns_records SET dnr_protocol='" . $status . "',dnr_port='" . $port . "' WHERE dnrid=" . $r[0]["dnrid"];
        $result3 = $conn->query($sql3);
        // }
        // }
        $sql = "SELECT * FROM tbl_websites,tbl_domains_ns_records WHERE wsid='" . $websiteid . "' and dnr_d_id_fk=ws_domainid_fk and ws_recordname=dnr_name  ";

        $result = $conn->query($sql);
        $r = mysqli_fetch_all($result, MYSQLI_ASSOC);

        $conn->close();
        return  ["r" => $r, "port" => $port, "sql3" => $sql3, "sql" => $sql, "r2" => $r, "status" => $status];
    }
    public static function InternalUpdateDefaultValue($domainid, $record, $status)
    {
        $sql = "SELECT * FROM tbl_websites WHERE ws_domainid_fk=" . $domainid . " AND ws_recordname ='" . $record . "'";
        $conn = GetConnection();
        $result = $conn->query($sql);

        if (!$result || mysqli_num_rows($result) == 0) {
        } else {

            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);
            $wsid = $r[0]["wsid"];
            $allowedstatus = ["HTTP", "HTTPS", "AUTO"];
            if (!in_array(strtoupper($status), $allowedstatus)) {
                $status = "auto";
            }
            $sql = "SELECT * FROM " . $GLOBALS["backendprotocol_tablename"] .
                " WHERE " . $GLOBALS["bpwid_fk"] . "=" . $wsid;
            $conn = GetConnection();
            $result = $conn->query($sql);
            if (!$result || mysqli_num_rows($result) == 0) {
                $ins = "INSERT INTO " . $GLOBALS["backendprotocol_tablename"] . " (" .
                    $GLOBALS['bpwid_fk'] . "," . $GLOBALS['bpstatus'] . ")
                    VALUE ('" . $wsid . "','" . strtolower($status) . "')";
            } else {
                $ins = "UPDATE " . $GLOBALS["backendprotocol_tablename"] . " SET " .
                    $GLOBALS['bpstatus'] . "='" . strtolower($status) . "'
                            WHERE " . $GLOBALS['bpwid_fk'] . "=" . $wsid;
                $listOfRecordType = [
                    "status" => "success", "code" => "201",
                    "message" => "شما تنظیماتی برای این بخش انجام نداده اید "
                ];
            }
            $conn->query($ins);
            $conn->close();
            return ["r", $r, "sql" => $ins]; //[0]["wsid"];
        }
        return ["sql" => $sql];
    }

    public static function UpdateWebsiteBackendProtocol($token, $websiteid, $status, $ip)
    {

        $usersDetails = USERS_ADMIN::GetOneByToken($token);
        if ($usersDetails["status"] == "error") {
                     return ["status" => "error", "message" => "اعتبار ورود شما به پایان رسیده است لطفا مجدد وارد شوید"];
        }

        if ($usersDetails["credit"] < 0) {
            return ["status" => "error", "message" => "اعتبار شما منفی است و شما امکان اعمال تغییرات را ندارید" ];
        }

        if (!filter_var($ip, FILTER_VALIDATE_IP)) {
            return ["status" => "error", "message" => "خطا در IP ارسالی"];
        }

        $uid = $usersDetails["userdetail"][0]["uid"];
        $websitesOwner = WEBSITES_ADMIN::GetWebsiteByID($websiteid, $uid);
        if ($websitesOwner["status"] == "error") {
            // VARS_ADMIN::ReturnHeaders(400);
            return ["status" => "error", "message" => "شناسه وب سایت مورد نظر اشتباه است"];
        }
        if ($status == "") {
            return ["status" => "error", "message" => "امکان خالی بودن وضعیت وجود ندارد"];
        }
        $bd = self::CheckRecordHasCluster($websiteid);
        if ($bd["status"] == "error") {
            return $bd;
        }
        $allowedstatus = ["HTTP", "HTTPS", "AUTO"];

        $methods = explode(",", $status);
        $res = [];
        $stat = 1;
        foreach ($methods as $method) {
            if (!in_array(strtoupper($method), $allowedstatus)) {
                $stat = 0;
                array_push(
                    $res,
                    ["status" => "error", "status" => $status, "message" => "وضعیت نامعتبر است"]
                );
            }
        }
        $dmn = "";

        if ($websitesOwner["data"][0]["subdomain"] == "maindomain") {
            $dmn = $websitesOwner["data"][0]["d_name"];
        } else {
            $dmn = $websitesOwner["data"][0]["ws_recordname"] . "." . $websitesOwner["data"][0]["d_name"];
        }

        if ($stat == 0) {
            return ["status" => "error", "message" => "خطا در وضعیت های ارسالی", "backendprotocol" => $res];
        }

        $sql = "SELECT * FROM " . $GLOBALS["backendprotocol_tablename"] .
            " WHERE " . $GLOBALS["bpwid_fk"] . "=" . $websiteid;
        $conn = GetConnection();
        $result = $conn->query($sql);
        if (!$result || mysqli_num_rows($result) == 0) {
            $ins = "INSERT INTO " . $GLOBALS["backendprotocol_tablename"] . " (" .
                $GLOBALS['bpwid_fk'] . "," . $GLOBALS['bpstatus'] . ")
                VALUE ('" . $websiteid . "','" . $status . "')";
                USERS_ADMIN::AddUserLog("تغییر در backendprotocol", "", $status, "update_backendprotocol", $uid,$ip);
        } else {
            $r = mysqli_fetch_all($result, MYSQLI_ASSOC);

            USERS_ADMIN::AddUserLog("تغییر در backendprotocol برای سایت ".$dmn, $r[0][$GLOBALS['bpstatus']], $status, "update_backendprotocol", $uid,$ip);
            $ins = "UPDATE " . $GLOBALS["backendprotocol_tablename"] . " SET " .
                $GLOBALS['bpstatus'] . "='" . $status . "'
                        WHERE " . $GLOBALS['bpwid_fk'] . "=" . $websiteid;
            $listOfRecordType = [
                "status" => "success", "code" => "201",
                "message" => "شما تنظیماتی برای این بخش انجام نداده اید "
            ];
        }
        $conn->query($ins);
        $conn->close();

        $dnsstatus = strtoupper($status);
        if (strtolower($status) == "auto")
            $dnsstatus = "Automatic";
        $b = self::InternalChangeDNSRecord($websiteid, strtoupper($dnsstatus));
        if (strtolower($status) == "auto")
            $status = "scheme";

        if(!isset($b["r2"][0]["dnr_ip"])){
            $b["r2"][0]["dnr_ip"]="127.0.0.1";
        }
        if(!isset($b["r2"][0]["dnr_port"])){
            $b["r2"][0]["dnr_port"]="80";
        }
        API_UPSTREAMTOLOCATION_ADMIN::RunCreateAPIUPSTREAMTOLOCATION($dmn, "mizdef", strtolower($status));
        API_UPSTREAM_ADMIN::RunCreateAPIUPSTREAM($dmn, "", "100-" . $b["r2"][0]["dnr_ip"] . "-" . $b["r2"][0]["dnr_port"], "ip_hash", strtolower($status));
        return ["status" => "success",  "message" => "درخواست شما با موفقیت انجام شد"];
    }
}
