<?php

require_once $GLOBALS["RootFiles"] . '/database/DataBaseConnection.php';
require_once $GLOBALS["RootFiles"] . '/bussiness/admin/admin_field_web.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/sendrequest/send.php';
require_once $GLOBALS["RootFiles"] . '/apitobackend/middlelog/middlelog.php';

class API_CAHCE_ADMIN
{

    public static function RunCreateAPICacheLevel($domain, $cachetype, $location = null, $priority = null)
    {
        $actionUrl = "api/";
        $postededata["action"] = "http_cache";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));

        $postededata["cachetype"] = $cachetype;

        // $postededata["period"]="m";
        if ($location == null) {
            // $postededata["location"]="/";
        } else {
            if ($location != "/") {
                $postededata["location"] = $location;
                $postededata["priority"] = $priority;
            }
        }

        $apiOut = SENDAPI::SendCDNAPI($actionUrl, $postededata);
        return $apiOut;
    }

    public static function RunCreateAPIBrowserCacheTTL($domain, $cachettl, $location = null, $priority = null, $format = "m")
    {
        $actionUrl = "api/";
        $postededata["action"] = "http_browsercache";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));
        $postededata["cachettl"] = $cachettl;
        $postededata["period"] = $format;
        if ($format == "s") {
            $postededata["period"] = "s";
            $postededata["cachettl"] = $cachettl; // substr($cachettl,0,strlen($cachettl)-1);
        } else {
            if ($format == "d") {
                $postededata["period"] = "m";
                $postededata["cachettl"] = $cachettl * 1440; // substr($cachettl,0,strlen($cachettl)-1);
            } else
                $postededata["cachettl"] = $cachettl; // *60; // substr($cachettl,0,strlen($cachettl)-1);
        }
        if ($location == null) {
            //$postededata["location"]="/";
        } else {
            if ($location != "/") {
                $postededata["location"] = $location;
                $postededata["priority"] = $priority;
            }
        }
        // $postededata["period"]="m";

        $apiOut = SENDAPI::SendCDNAPI($actionUrl, $postededata);
        return $apiOut;
    }

    public static function RunCreateAPIServerCacheTTL($domain, $cachettl, $location = null, $priority = null, $format = "m")
    {
        $actionUrl = "api/";
        $postededata["action"] = "http_cachettl";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));
        $postededata["cachettl"] = $cachettl;
        $postededata["period"] = $format;
        if ($format == "s") {
            $postededata["period"] = "s";
            $postededata["cachettl"] = $cachettl; // substr($cachettl,0,strlen($cachettl)-1);
        } else {
            if ($format == "d") {
                $postededata["period"] = "m";
                $postededata["cachettl"] = $cachettl * 1440; //substr($cachettl,0,strlen($cachettl)-1);
            } else
                $postededata["cachettl"] = $cachettl; // *60; //substr($cachettl,0,strlen($cachettl)-1);

        }
        if ($location == null) {
            //$postededata["location"]="/";
        } else {
            if ($location != "/") {
                $postededata["location"] = $location;
                $postededata["priority"] = $priority;
            }
        }
        if ($postededata["cachettl"] == "-1")
            $postededata["cachettl"] = "0";
        $apiOut = SENDAPI::SendCDNAPI($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);
        return $apiOut;
    }

    public static function RunPurgeCache($domain, $path)
    {
        $actionUrl = "api/";
        $postededata["action"] = "reweb_purgecache";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));
        if ($path != $domain . "/")
            $postededata["filepaths"] = $path;

        $apiOut = SENDAPI::SendCDNAPI($actionUrl, $postededata);
        $cljs = json_encode($postededata);
        str_replace("'", "\'", $cljs);
        // $s = CLOUD_LOG_ADMIN::ADDLog("URL : " . $actionUrl . "; " . $cljs, $apiOut);
        return $apiOut;
    }
    public static function RunDeleteDomain($domain)
    {
        $actionUrl = "api/";
        $postededata["action"] = "dns_delete";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));

        return SENDAPI::SendCDNAPI($actionUrl, $postededata);
    }
    public static function RunCacheVars($domain, $zone, $maxsize)
    {
        $actionUrl = "api/";
        $postededata["action"] = "http_cachevars";
        $postededata["keyzone"] = $zone;
        $postededata["maxsize"] = $maxsize;
        $postededata["duration"] = "30";
        $postededata["domain"] = str_replace("*", "starwildcarddomain", Punycode::encodeHostName($domain));

        return SENDAPI::SendCDNAPI($actionUrl, $postededata);
    }
}
