import os
import environ
from pathlib import Path



BASE_DIR = Path(__file__).resolve().parent.parent.parent
env = environ.Env()
environ.Env.read_env(os.path.join(BASE_DIR, '.env'))

ENVIRONMENT = env('DEPLOYMENT_ENV')
if ENVIRONMENT == 'main':
    from .production import *
elif ENVIRONMENT == 'stage':
    from .stage import *
elif ENVIRONMENT == 'develop':
    from .development import *

