# Generated by Django 4.2 on 2023-06-08 11:41

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Flags',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('color', models.CharField(blank=True, max_length=255, null=True)),
                ('created_at', models.DateTimeField(blank=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                'db_table': 'flags',
            },
        ),
        migrations.CreateModel(
            name='InsuranceContracts',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('company', models.CharField(blank=True, max_length=255, null=True)),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('number', models.CharField(blank=True, max_length=255, null=True)),
                ('start_date', models.DateTimeField(blank=True, null=True)),
                ('end_date', models.DateTimeField(blank=True, null=True)),
                ('is_active', models.BooleanField(default=False)),
                ('description', models.TextField(blank=True, null=True)),
                ('close', models.IntegerField()),
                ('created_at', models.DateTimeField(auto_now=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                'db_table': 'insurance_contracts',
            },
        ),
        migrations.CreateModel(
            name='InsuranceDocuments',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('insurance_contract', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insurancecontracts')),
            ],
            options={
                'db_table': 'insurance_documents',
            },
        ),
        migrations.CreateModel(
            name='InsuranceMembers',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('first_name', models.CharField(blank=True, max_length=255, null=True)),
                ('last_name', models.CharField(blank=True, max_length=255, null=True)),
                ('father_name', models.CharField(blank=True, max_length=255, null=True)),
                ('gender', models.CharField(blank=True, max_length=255, null=True)),
                ('identity_number', models.CharField(blank=True, max_length=255, null=True)),
                ('national_code', models.CharField(blank=True, max_length=255, null=True)),
                ('birth_date', models.DateTimeField(blank=True, null=True)),
                ('insurance_code', models.CharField(blank=True, max_length=255, null=True)),
                ('parent_id', models.IntegerField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                'db_table': 'insured_members',
            },
        ),
        migrations.CreateModel(
            name='InsurancePeriods',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('period_number', models.IntegerField(blank=True, null=True)),
                ('period_date', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(blank=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'insurance_periods',
            },
        ),
        migrations.CreateModel(
            name='InsuranceServices',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255, null=True)),
                ('created_at', models.DateTimeField(blank=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                'db_table': 'insurance_services',
            },
        ),
        migrations.CreateModel(
            name='Relationship',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(blank=True, max_length=255, null=True)),
                ('created_at', models.DateTimeField(auto_now=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
            ],
            options={
                'db_table': 'relationships',
            },
        ),
        migrations.CreateModel(
            name='InsuranceRequests',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('claimed_service', models.CharField(blank=True, max_length=255, null=True)),
                ('claimed_fee', models.IntegerField(blank=True, null=True)),
                ('claimed_date', models.DateTimeField(blank=True, null=True)),
                ('benefit', models.IntegerField(blank=True, null=True)),
                ('description', models.TextField(blank=True, null=True)),
                ('attachments', models.FileField(blank=True, null=True, upload_to='insurance_attachments/')),
                ('result', models.TextField(blank=True, null=True)),
                ('created_at', models.DateTimeField(blank=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('document', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insurancedocuments')),
                ('flag', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.flags')),
                ('member', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insurancemembers')),
                ('period', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insuranceperiods')),
                ('service', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insuranceservices')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'insurance_requests',
            },
        ),
        migrations.AddField(
            model_name='insurancemembers',
            name='relationship',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.relationship'),
        ),
        migrations.AddField(
            model_name='insurancedocuments',
            name='insurance_member',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insurancemembers'),
        ),
        migrations.AddField(
            model_name='insurancedocuments',
            name='user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to=settings.AUTH_USER_MODEL),
        ),
        migrations.CreateModel(
            name='InsuranceContractServices',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('insurance_contract', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insurancecontracts')),
                ('insurance_service', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insuranceservices')),
            ],
            options={
                'db_table': 'insurance_contract_services',
            },
        ),
        migrations.CreateModel(
            name='InsuranceContractPeriods',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('insurance_contract', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insurancecontracts')),
                ('insurance_period', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insuranceperiods')),
            ],
            options={
                'db_table': 'insurance_contract_periods',
            },
        ),
        migrations.CreateModel(
            name='InsuranceContractMembers',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(blank=True, null=True)),
                ('updated_at', models.DateTimeField(auto_now=True, null=True)),
                ('insurance_contract', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insurancecontracts')),
                ('insurance_member', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='insurance.insurancemembers')),
            ],
            options={
                'db_table': 'insurance_contract_members',
            },
        ),
    ]
