from django.utils.deprecation import MiddlewareMixin
from django.http import JsonResponse
from mysgi_middleware.settings.base import AUTH_SERVICE_URL
from auth_backend import AuthAPIBackend


EXCLUDED_PATHS = ['/docs/', '/swagger/', '/schema/', '/ets/update_working_years/']

class TokenAuthMiddleware(MiddlewareMixin):
    def process_request(self, request):
        if any(request.path.startswith(path) for path in EXCLUDED_PATHS):
            return None
        
        auth_backend = AuthAPIBackend()
        authorization_header = request.headers.get('Authorization')
        if authorization_header:
            if auth_backend.authenticate(request, authorization_header):
                return None
            else:
                return JsonResponse({'detail': 'Invalid token'}, status=401)
        else:
            return JsonResponse({'detail': 'Authorization header missing'}, status=401)



