import requests
from mysgi_middleware.settings.base import AUTH_SERVICE_URL
from django.contrib.auth.backends import BaseBackend
from rest_framework_simplejwt.authentication import JWTAuthentication
from rest_framework_simplejwt.exceptions import InvalidToken, AuthenticationFailed
import json



class AuthAPIBackend(BaseBackend):
    
    def authenticate(self, request, token=None):
        if token is None:
            return None, None
        api_url = AUTH_SERVICE_URL+'/accounts/authorization-checker/'
        token = token.split(' ')[1]
        headers = {
            'accept': 'application/json',
            'Content-Type': 'application/x-www-form-urlencoded'
        }
        data = {
            'auth_token': token,
            'permission_name': 'it_requests-change_status',
            'is_admin': 'false'
        }

        response = requests.post(api_url, headers=headers, data=data)
        if response.status_code == 200:
            print(20022)
            personnel_code = response.json().get('message')
            request.personnel_code = personnel_code
            return True, personnel_code

        return None, None



class CustomJWTAuthentication(JWTAuthentication):
    
    def authenticate(self, request):
        print('customjwt')
        authorization = request.headers.get('Authorization')
        if authorization is None:
            return None
        authorization = authorization.split(' ')[1]
        
        if not self.validate_with_external_service(request, authorization):
            raise AuthenticationFailed('Auth Service Failed')
        return (None, None)


    def validate_with_external_service(self, request, authorization):
        
        headers = {
            'accept': 'application/json',
            'Content-Type': 'application/x-www-form-urlencoded'
        }
        response = requests.post(AUTH_SERVICE_URL+'/accounts/authorization-checker/', headers=headers, data={'auth_token': authorization, 'permission_name': 'it_requests-change_status', 'is_admin': 'false'})
        if response.status_code == 200:
            res = response.json()
            request.personnel_code = res['message']
            return True
        return False
        # except requests.RequestException:
        #     raise AuthenticationFailed('Authentication service unavailable')

        
