<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
class Themento_Post_Grid extends Widget_Base{

	public function get_name(){
		return 'tmt-post-grid';
	}

	public function get_title(){
		return __( 'Post Grid', text_domain );
	}

	public function get_icon() {
		return 'eicon-posts-grid';
	}

	public function get_script_depends() {
		return [ 'swiper' ];
	}

	public function get_categories() {
		return [ text_domain ];
	}

    protected function register_controls(){
		$this->register_general_content_controls();
		$this->register_general_slider_controls();
		$this->register_general_style_controls();
		$this->register_style_img_icon_controls();
		$this->register_style_title_controls();
		$this->register_style_description_controls();
		$this->register_style_red_more_controls();
		$this->register_style_pagination_controls();
		$this->register_style_arrows_dots_slider_controls();
		$this->register_style_meta_data_controls();
		$this->register_style_border_custom_image_controls();
		$this->register_style_auther_controls();
		$this->register_style_date_controls();
	}
	
    protected function register_general_content_controls(){
        $this->start_controls_section(
            'settings',
            [
                'label' => __( 'Content', text_domain )
            ]
		);
		$this->add_control(
		        'post_type',
		        [
		            'label' => __( 'Post Type', text_domain ),
		            'type' => Controls_Manager::SELECT,
		            'default' => 'post',
		            'options' => get_posts_types(),
		        ]
		);
		$this->add_control(
			'select_style',
			[
				'label' => __( 'Border Style', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style-one-1',
				'options' => [
					'style-one-1'  => __( 'Style One', text_domain ),
					'style-two-2' => __( 'Style Two', text_domain ),
				],
			]
		);
		$post_types = get_posts_types();
			foreach ( $post_types as $post_type => $x ) {
				$taxonomies = get_object_taxonomies($post_type, 'objects');
				unset($taxonomies['post_translations'],$taxonomies['language'],$taxonomies['post_format']);
				foreach ( $taxonomies as $taxonomy => $object ) {
					$categories = get_terms( array(
						'taxonomy'    => $object->name,
						'hide_empty' => 0,
					) );
					$cat_array  = array();
					foreach( $categories as $cat_id => $cat_name ) {
						$cat_array[ $cat_name->term_id ] = $cat_name->name;
					}
					@$this->add_control(
						$object->name,
						[
							'label' => $object->label,
							'type' => Controls_Manager::SELECT2,
							'label_block' => true,
							'multiple' => true,
							'options' => $cat_array,
							'condition' => [
								'post_type' => $object->object_type,
							],
						]
					);
				}
		}
		$this->add_responsive_control(
			'columns',
				[
					'label' => __( 'Number of Columns', text_domain ),
					'type' => Controls_Manager::SELECT,
					'options' => [
						''       => __( 'None', text_domain ),
						'100%'       => __( '1 Columns', text_domain ),
						'50%'        => __( '2 Columns', text_domain ),
						'33.333333%' => __( '3 Columns', text_domain ),
						'25%'        => __( '4 Columns', text_domain ),
						'20%'        => __( '5 Columns', text_domain ),
						'16.666667%' => __( '6 Columns', text_domain ),
					],
					'devices' => [ 'desktop', 'tablet', 'mobile' ],
							'desktop_default' => '33.333333%',
							'tablet_default' => '50%',
							'mobile_default' => '100%',
					'selectors' => [
						'{{WRAPPER}} .tmt-posts > *' => '-ms-flex: 0 0 {{VALUE}};flex: 0 0 {{VALUE}};max-width: {{VALUE}};',
					],
					'condition' => [
						'enable_slider!' => 'yes',
					],
			]
        );

		$this->add_control(
            'slider_columns',
            [
	            'label' => __( 'Number of Columns', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 3,
				'condition' => [
					'enable_slider' => 'yes',
				],
            ]
        );
		$this->add_control(
            'slider_columns_tablet',
            [
	            'label' => __( 'Columns Tablet', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
				'condition' => [
					'enable_slider' => 'yes',
				],
            ]
        );
        $this->add_control(
            'slider_columns_mobile',
            [
	            'label' => __( 'Columns Mobile', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 10,
                'step' => 1,
                'default' => 1,
				'condition' => [
					'enable_slider' => 'yes',
				],
            ]
        );
		$this->add_control(
			'posts_count',
			[
				'label' => __( 'Number of Posts', text_domain ),
				'type' => Controls_Manager::NUMBER,
				'default' => '4',
					'condition' => [
							'post_type!' => 'loop'
						],
			]
		);
		$this->add_control(
			'post_order',
			[
				'label' => __( 'Order', text_domain ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'asc' => __( 'Ascending', text_domain ),
					'desc' => __( 'Descending', text_domain )
				],
				'default' => 'asc',
				'condition' => [
					'post_type!' => 'loop'
				],
			]
		);
        // image
		$this->add_group_control(
		    Group_Control_Image_Size::get_type(),
		    [
		        'name' => 'image',
		        'default' => 'large',
				'separator' => 'before',
		    ]
		);
		$this->add_control(
		    'object_fit',
		     [
		        'label' => __( 'Image Fit', text_domain ),
		        'type' => Controls_Manager::SELECT,
		        'options' => [
		            'inherit' => __( 'None', text_domain ),
		            'cover' => __( 'Cover', text_domain ),
		            'contain' => __( 'Contain', text_domain ),
		            'fill' => __( 'Fill', text_domain ),
		            'scale-down' => __( 'Scale Down', text_domain ),
		         ],
		        'default' => 'inherit',
		        'selectors' => [
		            '{{WRAPPER}} img' => 'object-fit: {{VALUE}}',
				],
		    ]
		);
        // slider
		$this->add_control(
			'enable_slider',
			[
				'label' => __( 'Enable Slider', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'post_type!' => 'loop',
				],
			]
		);


        //show icons
		$this->add_control(
			'show_icons',
			[
			    'label' => __( 'Show Icons', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'select_style' => 'style-two-2'
				],
			]
		);
		//show icon link
		$this->add_control(
			'show_icon_link',
			[
			    'label' => __( 'Show Icon Link', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'select_style' => 'style-two-2',
					'show_icons' => 'yes',
				],
			]
		);
		$this->add_control(
		    'post_icon_link',
		    [
		        'label'            => __( 'Select Icon Link', text_domain ),
		        'type'             => Controls_Manager::ICONS,
		        'fa4compatibility' => 'icon',
		        'default' => [
		            'value' => 'fas fa-link',
		            'library' => 'fa-solid',
		        ],
				'condition' => [
					'select_style' => 'style-two-2',
					'show_icon_link' => 'yes',
					'show_icons' => 'yes',
				],
		    ]
		);
		//show icon link
		$this->add_control(
			'show_icon_fancybox',
			[
			    'label' => __( 'Show Icon Gallery', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'yes',
				'condition' => [
					'select_style' => 'style-two-2',
					'show_icons' => 'yes',
				],
			]
		);
		$this->add_control(
		    'post_icon_fancybox',
		    [
		        'label'            => __( 'Select Icon', text_domain ),
		        'type'             => Controls_Manager::ICONS,
		        'fa4compatibility' => 'icon',
		        'default' => [
		            'value' => 'fas fa-link',
		            'library' => 'fa-solid',
				],
				'condition' => [
					'select_style' => 'style-two-2',
					'show_icon_fancybox' => 'yes',
					'show_icons' => 'yes',
				],
		    ]
		);
        //enable_title
		$this->add_control(
		 	'enable_title',
		 	[
		 	 	'label' => __( 'Show Title', text_domain ),
		 	 	'type' => Controls_Manager::SWITCHER,
		 	    'separator' => 'before',
		 	 	'default' => 'yes',
		 	]
		);
		$this->add_control(
			'title_tag',
			[
				'label' => __( 'Title Tag', text_domain ),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => TMT_Title_Tags(),
				'default' => 'h4',
				'condition' => [
					'enable_title' => 'yes'
				],
			]
		);
        //enable_excerpt
		$this->add_control(
  			     'enable_excerpt',
  			     [
  				     'label' => __( 'Show Excerpt', text_domain ),
  				     'type' => Controls_Manager::SWITCHER,
  				     'separator' => 'before',
  				     'default' => 'yes',
  			    ]
        );
		$this->add_control(
				'excerpt_length',
				[
					'label' => __( 'Excerpt Words', text_domain ),
					'type' => Controls_Manager::NUMBER,
					'default' => '15',
					'condition' => [
						'enable_excerpt' => 'yes'
					],
				]
		);
        //enable_more
		$this->add_control(
		 	    'enable_more',
		 		[
		 			'label' => __( 'Show Red More', text_domain ),
		 			'type' => Controls_Manager::SWITCHER,
		 			'separator' => 'before' ,
		 			'default' => 'yes',
		 		]
		);
		$this->add_control(
				'text_more_link',
				[
					'label' => __( 'Read More Text', text_domain ),
					'type' => Controls_Manager::TEXT,
				    'default' => __( 'Read More', text_domain ),
					'condition' => [
						'enable_more' => 'yes',
					],
				]
		);
		$this->add_control(
			'icon_red_more',
				[
				'label'            => __( 'Select Icon', text_domain ),
				'type'             => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-long-arrow-alt-left',
					'library' => 'fa-solid',
					],
				'condition' => [
					'enable_more' => 'yes',
				],
			]
		);
		$this->add_control(
			'show_animation_redmore',
			[
				'label' => __( 'Show Animation Redmore', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', text_domain ),
				'label_off' => __( 'Hide', text_domain ),
				'return_value' => 'yes',
				'default' => 'yes',
				'selectors' => [
					'{{WRAPPER}} .info .redmore-blog a,{{WRAPPER}} .card .redmore-card' => 'position: relative;-webkit-transition: .5s;-o-transition: .5s;transition: .5s;',
					'{{WRAPPER}} .info .redmore-blog a:before,{{WRAPPER}} .card .redmore-card:before' => 'position: absolute;content: "";right: 0;top: 11px;height: 1px;width: 21px;',
					'{{WRAPPER}} .info .redmore-blog a i,{{WRAPPER}} .card .redmore-card i' => 'position: absolute;right: 0px;font-size: 14px;opacity: 0;-webkit-transition: .5s;-o-transition: .5s;transition: .5s',
					'{{WRAPPER}} .redmore-blog a:hover i,{{WRAPPER}} .card .redmore-card:hover i' => 'opacity: 1;',
					'{{WRAPPER}} .info .redmore-blog a:hover,{{WRAPPER}} .card .redmore-card:hover' => 'padding-right: 25px;',	
				],
				'condition' => [
					'enable_more' => 'yes',
					'select_style' => 'style-one-1',
				],
			]
		);
		$this->add_control(
			'select_redmore',
			[
				'label' => __( 'Select Position Icon', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'row',
				'options' => [
					'row'  => __( 'Before Link', text_domain ),
					'row-reverse' => __( 'After Link', text_domain ),
				],
				'selectors' => [
					'{{WRAPPER}} .info .redmore-blog a' => 'flex-direction: {{VALUE}};',
				],
				'condition' => [
					'enable_more' => 'yes',
					'show_animation_redmore!' => 'yes'
				],
			]
		);
        // show_pagination
		$this->add_control(
				'show_pagination',
				[
					'label' => __( 'Show Pagination', text_domain ),
					'type' => Controls_Manager::SWITCHER,
					'separator' => 'before' ,
					'condition' =>[
						'post_type!' => 'loop'
					],
				]
		);
        // custom border image //
	    $this->add_control(
		    'custom_border_image',
		    [
			    'label' => __( 'Custom Border Image', text_domain ),
			    'type' => Controls_Manager::SWITCHER,
				'condition' => [
					'select_style' => 'style-one-1'
				]
		    ]
		);
		// Meta Post //
		$this->add_control(
		    'show_meta',
		    [
			    'label' => __( 'Show Meta', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'default' => 'yes',
				'condition' => [
					'select_style' => 'style-one-1',
				],
		    ]
		);
		$this->add_control(
			'meta_data',
			[
				'label' => __( 'Meta Post', text_domain ),
				'label_block' => true,
				'type' => Controls_Manager::SELECT2,
				'default' => ['Comments','Date'],
				'multiple' => true,
				'options' => [
					'date' => __( 'Date', text_domain ),
					'time' => __( 'Time', text_domain ),
					'comments' => __( 'Comments', text_domain ),
					'auther' => __( 'Auther', text_domain ),
				],
				'condition' => [
					'select_style' => 'style-one-1',
					'show_meta' => 'yes',
				],
			]	
		);
        // Auther //
		$this->add_control(
		    'show_auther',
		    [
			    'label' => __( 'Show Auther', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'default' => 'yes',
				'condition' => [
					'select_style' => 'style-one-1'
				],
		    ]
		);
		$this->add_control(
			'select_auther',
			[
				'label' => __( 'Select Style Auther', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'admin-auther',
				'options' => [
					'icon-auther' => __( 'Icon', text_domain ),
					'admin-auther' => __( 'Admin', text_domain ),
					'together' => __( 'Together', text_domain ),
					'together-2' => __( 'Together 2', text_domain ),
				],
				'condition' => [
					'select_style' => 'style-one-1',
					'show_auther' => 'yes',
				],
			]
		);
        // data
		$this->add_control(
			'show_data',
			[
				'label' => __( 'Show Date', text_domain ),
				'type' => Controls_Manager::SWITCHER,
				'separator' => 'before',
				'selectors' => [
					'{{WRAPPER}} .blog-item .date-item' => 'position: absolute;',
				],
			]
		);

       $this->end_controls_section();
	}
    protected function register_general_slider_controls(){
		$this->start_controls_section(
			'section_slider',
			[
				'label' => __( 'Slider Settings', text_domain ),
				'condition' => [
					'enable_slider' => 'yes',
				]
			]
		);

		$this->add_control(
            'navigation',
            [
                'label' => __( 'Navigation', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'dots',
                'options' => [
                    'both' => __( 'Arrows and Dots', text_domain ),
                    'arrows' => __( 'Arrows', text_domain ),
                    'dots' => __( 'Dots', text_domain ),
                    'none' => __( 'None', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'pause_on_hover',
            [
                'label' => __( 'Pause on Hover', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __( 'Autoplay', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'autoplay_speed',
            [
                'label' => __( 'Autoplay Speed', text_domain ),
                'type' => Controls_Manager::NUMBER,
                'default' => 2000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );
        $this->add_control(
            'infinite',
            [
                'label' => __( 'Infinite Loop', text_domain ),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'centerMode',
            [
                'label' => __( 'Center Mode', text_domain ),
                'type' => Controls_Manager::SWITCHER,
            ]
        );
        $this->add_control(
            'effect',
            [
                'label' => __( 'Effect', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
	                'none'      => __( 'None', text_domain ),
	                'fade'      => __( 'Fade', text_domain ),
	                'cube'      => __( 'Cube', text_domain ),
                    'coverflow' => __( 'Coverflow', text_domain ),
                    'flip'      => __( 'Flip', text_domain ),
                    'cards'     => __( 'Cards', text_domain ),
                    'creative'  => __( 'Creative', text_domain ),
                ],
            ]
        );
        $this->add_control(
            'creative_type',
            [
                'label' => __( 'Creative Type', text_domain ),
                'type' => Controls_Manager::SELECT,
                'default' => '1',
                'options' => [
	                '1' => __( 'Type', text_domain ) . ' 1',
	                '2' => __( 'Type', text_domain ) . ' 2',
                    '3' => __( 'Type', text_domain ) . ' 3',
                    '4' => __( 'Type', text_domain ) . ' 4',
                    '5' => __( 'Type', text_domain ) . ' 5',
                    '6' => __( 'Type', text_domain ) . ' 6',
                ],
                'condition' => [
                    'effect' => 'creative'
                ],
            ]
        );
		$this->end_controls_section();
	}
    protected function register_general_style_controls(){
				    $this->start_controls_section(
						   'section_style',
						   [
								   'label' => __( 'Settings Public', text_domain ),
								   'tab'   => Controls_Manager::TAB_STYLE,
						   ]
					);

					$this->add_control(
						'align_info_card',
						[
							'label' => __( 'Position Title', text_domain ),
							'type' => Controls_Manager::CHOOSE,
							'options' => [
								'left' => [
									'title' => __( 'Left', text_domain ),
									'icon' => 'eicon-text-align-left',
								],
								'center' => [
									'title' => __( 'Center', text_domain ),
									'icon' => 'eicon-text-align-center',
								],
								'right' => [
									'title' => __( 'Right', text_domain ),
									'icon' => 'eicon-text-align-right',
								],
							],
							'default' => 'center',
							'toggle' => true,
							'selectors' => [
								'{{WRAPPER}} .card .overlay-box' => 'text-align: {{VALUE}}',
							],
							'condition' => [
								'select_style' => 'style-two-2'
							],
						]
					);

					$this->add_responsive_control(
		 			    'padding_posts',
		 			    [
		 				    'label' => __( 'Padding Posts', text_domain ),
		 				    'type' => Controls_Manager::DIMENSIONS,
		 				    'size_units' => [ 'px', '%', 'em' ],
		 				    'selectors' => [
		 					    '{{WRAPPER}} .tmt-posts > *' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
		 			    ]
					);
					  					
				    $this->add_responsive_control(
					    'margin_posts',
					    [
						    'label' => __( 'Margin Posts', text_domain ),
						    'type' => Controls_Manager::DIMENSIONS,
						    'size_units' => [ 'px', '%', 'em' ],
						    'selectors' => [
							    '{{WRAPPER}} .tmt-posts > *,{{WRAPPER}} .blog-item,{{WRAPPER}} .card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						    ],
					    ]
					);
					
					$this->add_control(
		 			    'border_radius_posts',
		 			    [
		 				    'label' => __( 'Border Radius', text_domain ),
		 				    'type' => Controls_Manager::DIMENSIONS,
		 				    'size_units' => [ 'px', '%', 'em' ],
		 				    'selectors' => [
		 					    '{{WRAPPER}} .blog-item, {{WRAPPER}} .card, .card img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'condition' => [
								'custom_border_image!' => 'yes',
							],
		 			    ]
		 		    );

					$this->add_group_control(
					    Group_Control_Box_Shadow::get_type(),
					    [
						    'name' => 'box_shadow_posts',
						    'label' => __( 'Box Shadow', text_domain ),
							'selector' => '{{WRAPPER}} .blog-item, {{WRAPPER}} .card, .card img',
					    ]
				    );

					$this->add_group_control(
						Group_Control_Border::get_type(),
						[
							'name' => 'border',
							'label' => __( 'Border', text_domain ),
							'selector' => '{{WRAPPER}} .blog-item, {{WRAPPER}} .card img',
							'condition' => [
								'custom_border_image!' => 'yes',
							],
						]
					);
                    // section info
					$this->add_control(
						'heading_info',
						[
							'label' => __( 'Section Info', text_domain ),
							'type' => Controls_Manager::HEADING,
							'separator' => 'before',
							'condition' => [
								'select_style' => 'style-one-1'
							],
						]
					);

					$this->add_control(
						'bg_color_info',
						[
							'label' => __( 'Background', text_domain ),
							'type' => Controls_Manager::COLOR,
							'default' => '#fff',
							'selectors' => [
								'{{WRAPPER}} .blog-item .info' => 'background: {{VALUE}}',
							],
							'condition' => [
								'select_style' => 'style-one-1'
							],
						]
					);

					$this->add_control(
						'bg_color_info_hover',
						[
							'label' => __( 'Background Hover', text_domain ),
							'type' => Controls_Manager::COLOR,
							'default' => '#02108B',
							'selectors' => [
								'{{WRAPPER}} .blog-item .info:before' => 'background: {{VALUE}}',
							],
							'condition' => [
								'select_style' => 'style-one-1'
							],
						]
					);

					$this->add_control(
						'margin_info',
						[
							'label' => __( 'Margin', text_domain ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'default' => [
								'top' => '-50',
	                            'right' => '15',
	                            'bottom' => '50',
	                            'left' => '15',
	                            'unit' => 'px',
	                            'isLinked' => false,
							],
							'selectors' => [
								'{{WRAPPER}} .blog-item .info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'condition' => [
								'select_style' => 'style-one-1'
							],
						]
					);

					$this->add_control(
						'padding_info',
						[
							'label' => __( 'Padding', text_domain ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'default' => [
								'top' => '0',
	                            'right' => '20',
	                            'bottom' => '5',
	                            'left' => '20',
	                            'unit' => 'px',
	                            'isLinked' => false,
							],
							'selectors' => [
								'{{WRAPPER}} .blog-item .info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'condition' => [
								'select_style' => 'style-one-1'
							],
						]
					);

					$this->add_control(
						'border_radius_info_posts',
						[
							'label' => __( 'Border Radius', text_domain ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'selectors' => [
								'{{WRAPPER}} .info, {{WRAPPER}} .blog-item .info:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'condition' => [
								'select_style' => 'style-one-1'
							],
						]
				    );

					$this->add_group_control(
						Group_Control_Box_Shadow::get_type(),
						[
							'name' => 'box_shadow_info',
							'label' => __( 'Box Shadow', text_domain ),
							'selector' => '{{WRAPPER}} .blog-item .info',
							'condition' => [
								'select_style' => 'style-one-1'
							],
						]
					);

				$this->end_controls_section();
	}
    protected function register_style_img_icon_controls(){
					$this->start_controls_section(
							'style_image_icon',
							[
							'label' => __('Image & Icon', text_domain),
							'tab' => Controls_Manager::TAB_STYLE,
							]
					);

					$this->start_controls_tabs('style_tabs_img_icon');
					$this->start_controls_tab('style_normal_tab', ['label' => __( 'Image', text_domain ),]);

					$this->add_control(
						'heading_image_normal',
						[
							'label' => __( 'Normal', text_domain ),
							'type' => Controls_Manager::HEADING,
							'condition' => [
								'select_style' => 'style-two-2'
							],
						]
					);

					$this->add_responsive_control(
						'width_image',
						[
							'label' => __( 'Width Image', text_domain ),
							'type' => Controls_Manager::SLIDER,
							'default' => [
								'size' => 100,
							],
							'selectors' => [
								'{{WRAPPER}} .blog-item figure,{{WRAPPER}} .card img' => 'width:{{SIZE}}%;',
							],
							'condition' => [
								'select_style' => 'style-one-1'
							],
						]
					);
		
		            $this->add_control(
			            'show_full_width',
			            [
				            'label' => __( 'Full Width', text_domain ),
				            'type' => Controls_Manager::SWITCHER,
				            'label_on' => __( 'Show', text_domain ),
				            'label_off' => __( 'Hide', text_domain ),
				            'return_value' => 'yes',
				            'default' => 'yes',
							'selectors' => [
								'{{WRAPPER}} .card img' => 'width:100%;',
							],
							'condition' => [
								'select_style' => 'style-two-2'
							],
			            ]
		            );
		
					$this->add_responsive_control(
						'height_image',
						[
							'label' => __( 'Height Image', text_domain ),
							'type' => Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' =>0,
									'max' =>1000
								]
							],
							'default' => [
								'size' => 255,
							],
							'selectors' => [
								'{{WRAPPER}} .blog-item figure,{{WRAPPER}} .card img' => 'height:{{SIZE}}px;',
							],
						]
					);

					

					$this->add_control(
						'heading_image_hover',
						[
							'label' => __( 'Hover', text_domain ),
							'type' => Controls_Manager::HEADING,
							'separator' => 'before',
							'condition' => [
								'select_style' => 'style-two-2'
							],
						]
					);	

					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'background_hover_img',
							'label' => __( 'Background', text_domain ),
							'types' => [ 'gradient' ],
							'selector' => '{{WRAPPER}} .card .overlay-box::before',
							'condition' => [
								'select_style' => 'style-two-2'
							],
						]
					);

					$this->add_control(
						'border_style_outline_image_hover',
						[
							'label' => __( 'Border Style', 'plugin-domain' ),
							'type' => Controls_Manager::SELECT,
							'default' => 'solid',
							'options' => [
								'none' => __( 'None', text_domain ),
								'solid'  => __( 'Solid', text_domain ),
								'dashed' => __( 'Dashed', text_domain ),
								'dotted' => __( 'Dotted', text_domain ),
								'double' => __( 'Double', text_domain ),
							],
							'selectors' => [
								'{{WRAPPER}} .card .overlay-box::before' => 'outline-style: {{VALUE}};',
							],
							'condition' => [
								'select_style' => 'style-two-2'
							],
						]
					);

					$this->add_control(
						'width_borderhover_img',
						[
							'label' => __( 'Width', text_domain ),
							'type' => Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 30,
									'step' => 1,
								],
							],
							'default' => [
								'size' => 2,
							],
							'selectors' => [
								'{{WRAPPER}} .card .overlay-box::before' => 'outline-width: {{SIZE}}px;',
							],
							'condition' => [
								'border_style_outline_image_hover!' => 'none',
								'select_style' => 'style-two-2'
							],
						]
					);

					$this->add_control(
						'color_border_outline',
							[
							'label' => __( 'Color', text_domain ),
							'type' => Controls_Manager::COLOR,
						    'default' => 'rgb(255, 255, 255)',
							'selectors' => [
								'{{WRAPPER}} .card .overlay-box::before' => 'outline-color:{{VALUE}}',
							 ],
						   'condition' => [
								'border_style_outline_image_hover!' => 'none',
								'select_style' => 'style-two-2'
						   ],
						]
					);
					
					$this->end_controls_tab();
					$this->start_controls_tab('style_hover_tab', ['label' => __( 'Icon', text_domain ),
					    'condition' => [
							'select_style' => 'style-two-2',
							'show_icons' => 'yes'
						],
						]
					);	

				 	$this->add_control(
				 		'hover_color_icon',
				 			[
				 			'label' => __( 'Color', text_domain ),
				 			'type' => Controls_Manager::COLOR,
							'default' => '#FAA514',
				 			'selectors' => [
				 				'{{WRAPPER}} .card .link, {{WRAPPER}} .card .icon_fancybox' => 'color: {{VALUE}};fill:{{VALUE}}',
				 			 ],
							'condition' => [
								'select_style' => 'style-two-2',
								'show_icons' => 'yes'
							],
				 		]
					);			
					
					$this->add_group_control(
						Group_Control_Background::get_type(),
						[
							'name' => 'hover_bg_icon',
							'label' => __( 'Background Hover', text_domain ),
							'types' => ['gradient'],
							'selector' => '{{WRAPPER}} .card .link,{{WRAPPER}} .card .icon_fancybox',
							'condition' => [
								'select_style' => 'style-two-2',
								'show_icons' => 'yes'
							],
						]
					);	

		            $this->add_control(
			             'padding_icon',
			             [
				            'label' => __( 'Paddnig',text_domain ),
				            'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'default' => [
								'top' => '7',
	                            'right' => '7',
	                            'bottom' => '0',
	                            'left' => '7',
	                            'unit' => 'px',
							],
				            'selectors' => [
				 	             '{{WRAPPER}} .card .link,.card .icon_fancybox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				            ],
							 'condition' => [
								'select_style' => 'style-two-2',
								'show_icons' => 'yes'
							],
			              ]
		            );
				
					$this->add_responsive_control(
						'margin_icon',
						[
						    'label' => __( 'Position', text_domain ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'default' => [
								'top' => '0',
	                            'right' => '3',
	                            'bottom' => '0',
	                            'left' => '3',
	                            'unit' => 'px',
							],
							'selectors' => [
								'{{WRAPPER}} .card .link, {{WRAPPER}} .card .icon_fancybox' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							 ],
							 'condition' => [
								'select_style' => 'style-two-2',
								'show_icons' => 'yes'
							],
						]
					);	
		 
					$this->add_responsive_control(
						'border_radius_icon',
						[
						    'label' => __( 'Border Radius', text_domain ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%', 'em' ],
							'default' => [
								'top' => '0',
	                            'right' => '0',
	                            'bottom' => '0',
	                            'left' => '0',
	                            'unit' => 'px',
							],
							'selectors' => [
								'{{WRAPPER}} .card .link, {{WRAPPER}} .card .icon_fancybox' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							 ],
							 'condition' => [
								'select_style' => 'style-two-2',
								'show_icons' => 'yes'
							],
						]
					);	

					$this->add_control(
						'size_icon',
						[
							'label' => __( 'Size', text_domain ),
							'type' => Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 100,
									'step' => 1,
								],
							],
							'default' => [
								'size' => 35,
							],
							'selectors' => [
								'{{WRAPPER}} .card .link i,{{WRAPPER}} .card .link svg' =>
								'font-size: {{SIZE}}px; width:{{SIZE}}px;height:{{SIZE}}px',
						        '{{WRAPPER}} .card .icon_fancybox i,{{WRAPPER}} .card .icon_fancybox svg'=>
								'font-size: {{SIZE}}px; width:{{SIZE}}px;height:{{SIZE}}px',
							],
							'condition' => [
								'select_style' => 'style-two-2',
								'show_icons' => 'yes'
							],
						]
					);

					$this->end_controls_tab();
					$this->end_controls_tabs();
				    $this->end_controls_section();
	}
	protected function register_style_border_custom_image_controls(){
		$this->start_controls_section(
			'style_border_custom',
			[
				'label' => __('Border Custom Image', text_domain),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'custom_border_image' => 'yes',
					'select_style' => 'style-one-1'
			    ],
			]
		);
		$this->add_control(
			'select_style_top_right',
			[
				'label' => __( 'Select Top Right', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					''  => __( 'None', text_domain ),
					'solid'  => __( 'Solid', text_domain ),
					'double' => __( 'Double', text_domain ),
					'dotted' => __( 'Dotted', text_domain ),
					'dashed' => __( 'Dashed', text_domain ),
					'groove' => __( 'Groove', text_domain ),
				],
				'selectors' => [
					'{{WRAPPER}} figure:after' => 'border-style: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'border_width_top_right',
			[
				'label' => __( 'Border Width', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => 3,
					'right' => 3,
					'bottom' => 0,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure:after' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
				'condition' => [
					'select_style_top_right!' => '',
				],
			]
		);
		$this->add_control(
			'border_color_top_right',
			[
				'label' => __( 'Border Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} figure:after' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select_style_top_right!' => '',
				],
			]
		);
		$this->add_control(
			'width_custom_border_top_right',
			[
				'label' => __( 'Width', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure:after' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_style_top_right!' => '',
				],
			]
		);
		$this->add_control(
			'height_custom_border_top_right',
			[
				'label' => __( 'Height', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure:after' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_style_top_right!' => '',
				],
			]
		);
		//border_top_left 
		$this->add_control(
			'select_style_top_left',
			[
				'label' => __( 'Select Top Left', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					''  => __( 'None', text_domain ),
					'solid'  => __( 'Solid', text_domain ),
					'double' => __( 'Double', text_domain ),
					'dotted' => __( 'Dotted', text_domain ),
					'dashed' => __( 'Dashed', text_domain ),
					'groove' => __( 'Groove', text_domain ),
				],
				'selectors' => [
					'{{WRAPPER}} figure:before' => 'border-style: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'border_width_top_left',
			[
				'label' => __( 'Border Width', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => 3,
					'right' => 0 ,
					'bottom' => 0,
					'left' => 3,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure:before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
				'condition' => [
					'select_style_top_left!' => '',
				],
			]
		);
		$this->add_control(
			'border_color_top_left',
			[
				'label' => __( 'Border Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} figure:before' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select_style_top_left!' => '',
				],
			]
		);
		$this->add_control(
			'width_custom_border_top_left',
			[
				'label' => __( 'Width', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure:before' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_style_top_left!' => '',
				],
			]
		);
		$this->add_control(
			'height_custom_border_top_left',
			[
				'label' => __( 'Height', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure:before' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_style_top_left!' => '',
				],
			]
		);
		//border_bottom_right
		$this->add_control(
			'select_style_bottom_right',
			[
				'label' => __( 'Select Bottom Right', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					''  => __( 'None', text_domain ),
					'solid'  => __( 'Solid', text_domain ),
					'double' => __( 'Double', text_domain ),
					'dotted' => __( 'Dotted', text_domain ),
					'dashed' => __( 'Dashed', text_domain ),
					'groove' => __( 'Groove', text_domain ),
				],
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:before' => 'border-style: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'border_width_bottom_right',
			[
				'label' => __( 'Border Width', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => 0,
					'right' => 3,
					'bottom' => 3,
					'left' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:before' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
				'condition' => [
					'select_style_bottom_right!' => ''
				],
			]
		);
		$this->add_control(
			'border_color_bottom_right',
			[
				'label' => __( 'Border Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:before' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select_style_bottom_right!' => ''
				],
			]
		);
		$this->add_control(
			'width_custom_border_bottom_right',
			[
				'label' => __( 'Width', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:before' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_style_bottom_right!' => ''
				],
			]
		);
		$this->add_control(
			'height_custom_border_bottom_right',
			[
				'label' => __( 'Height', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:before' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_style_bottom_right!' => ''
				],
			]
		);
		//border_bottom_left
		$this->add_control(
			'select_style_bottom_left',
			[
				'label' => __( 'Select Bottom Left', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					''  => __( 'None', text_domain ),
					'solid'  => __( 'Solid', text_domain ),
					'double' => __( 'Double', text_domain ),
					'dotted' => __( 'Dotted', text_domain ),
					'dashed' => __( 'Dashed', text_domain ),
					'groove' => __( 'Groove', text_domain ),
				],
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:after' => 'border-style: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'border_width_bottom_left',
			[
				'label' => __( 'Border Width', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 3,
					'left' => 3,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:after' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
				'condition' => [
					'select_style_bottom_left!' => '',
				],
			]
		);
		$this->add_control(
			'border_color_bottom_left',
			[
				'label' => __( 'Border Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:after' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select_style_bottom_left!' => '',
				],
			]
		);
		$this->add_control(
			'width_custom_border_bottom_left',
			[
				'label' => __( 'Width', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:after' => 'width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_style_bottom_left!' => '',
				],
			]
		);
		$this->add_control(
			'height_custom_border_bottom_left',
			[
				'label' => __( 'Height', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 50,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} figure>:last-child:after' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_style_bottom_left!' => '',
				],
			]
		);
		$this->end_controls_section();
	}
	protected function register_style_title_controls(){
		$this->start_controls_section(
			'title_style',
			[
				'label' => __('Title', text_domain),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'enable_title' => 'yes'
				],
			]
		);

		$this->add_control(
			'align_title',
			[
				'label' => __( 'Align Title', text_domain ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', text_domain ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', text_domain ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', text_domain ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
				'condition' => [
					'select_style' => 'style-one-1'
				],
			]
		);
		
		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#02108B',
				'selectors' => [
					'{{WRAPPER}} .title_blog, {{WRAPPER}} .card .title-card' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'title_color_hover',
			[
				'label' => __( 'Color Hover', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#fff',
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .title_blog' => 'color: {{VALUE}}',
				],
				'condition' => [
					'select_style' => 'style-one-1',
				],
			]
		);

		$this->add_responsive_control(
			'margin_title',
			[
				'label' => __( 'Margin', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .title_blog, {{WRAPPER}} .card .title-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
		  [
			  'name' => 'title_typography',
			  'label' => __( 'Typography', text_domain ),
			  'selector' => '{{WRAPPER}} .title_blog, {{WRAPPER}} .card .title-card',
		  ]
	    );

		$this->end_controls_section();

	}
    protected function register_style_description_controls(){
		$this->start_controls_section(
			'description_style',
			[
				'label' => __('Description', text_domain),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'enable_excerpt' => 'yes'
				],
			]
		);

		$this->add_control(
			'align_description',
			[
				'label' => __( 'Alignment', text_domain ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', text_domain ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', text_domain ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', text_domain ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
			   'selectors' => [
				   '{{WRAPPER}} .blog-item .excerpt-blog' => 'text-align:{{VALUE}}',
			   ],
			   'condition' => [
				   'select_style' => 'style-one-1',
			   ],
			]
		);

		$this->add_group_control(
			  Group_Control_Typography::get_type(),
			[
				'name' => 'description_typography',
				'label' => __( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .blog-item .excerpt-blog, {{WRAPPER}} .card .excerpt-card',
			]
		);

		$this->add_responsive_control(
			'margin_description',
			[
				'label' => __( 'Margin', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-item .excerpt-blog, {{WRAPPER}} .card .excerpt-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		
		$this->add_control(
			'description_color',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#474747',
				'selectors' => [
					'{{WRAPPER}} .blog-item .excerpt-blog, {{WRAPPER}} .card .excerpt-card,.card .overlay-box' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'description_color_hover',
			[
				'label' => __( 'Color Hover', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FFF',
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .excerpt-blog, {{WRAPPER}} .card:hover .excerpt-card' => 'color: {{VALUE}}',
				],
			]
		);

        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();

	}
    protected function register_style_red_more_controls(){
		$this->start_controls_section(
				'style_red_more',
				[
						'label' => __('Red More', text_domain),
						'tab' => Controls_Manager::TAB_STYLE,
						'condition' => [
							'enable_more' => 'yes'
						],
				]
		);

		$this->add_control(
			'align_red_more',
			[
				'label' => __( 'Align More', text_domain ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', text_domain ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', text_domain ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', text_domain ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
				'condition' => [
					'select_style' => 'style-one-1'
				],
			]
		);

		$this->add_control(
			'color_text_link',
			[
				'label' => __( 'Color Text Link', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FDB60D',
				'selectors' => [
					'{{WRAPPER}} .blog-item .redmore-blog a, {{WRAPPER}} .card .redmore-card' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'color_text_link_hover',
			[
				'label' => __( 'Color Text Link Hover', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .redmore-blog a, {{WRAPPER}} .card:hover .redmore-card' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'color_icon_link',
			[
				'label' => __( 'Color Icon Link', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FFF',
				'selectors' => [
					'{{WRAPPER}} .blog-item .redmore-blog a i, {{WRAPPER}} .card .redmore-card i' => 'color: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'bg_color_red_more',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-item .redmore-blog a, {{WRAPPER}} .card .redmore-card' => 'background: {{VALUE}}',
				],
			]
		);
		
		$this->add_responsive_control(
			'padding_red_more',
			[
				'label' => __( 'Padding Red More', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-item .redmore-blog a, {{WRAPPER}} .card .redmore-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'margin_red_more',
			[
				'label' => __( 'Margin Red More', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '10',
	                'right' => '0',
	                'bottom' => '10',
	                'left' => '0',
	                'unit' => 'px',
	                'isLinked' => true,
				],
				'selectors' => [
					'{{WRAPPER}} .blog-item .redmore-blog, {{WRAPPER}} .card .redmore-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'border_radius_red_more',
			[
				'label' => __( 'Border Radius Red More', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-item .redmore-blog a, {{WRAPPER}} .card .redmore-card' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
		  [
			  'name' => 'red_more_typography',
			  'label' => __( 'Typography', text_domain ),
			  'selector' => '{{WRAPPER}} .blog-item  .redmore-blog a, {{WRAPPER}} .card .redmore-card',
		  ]
	    );

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_redmore',
				'label' => __( 'Border more', text_domain ),
				'selector' => '{{WRAPPER}} .blog-item .redmore-blog a, {{WRAPPER}} .card .redmore-card',
			]
		);
		
		$this->end_controls_section();

	}
    protected function register_style_pagination_controls(){
				$this->start_controls_section(
					'style_pagination',
					[
						'label' => __('Pagination', text_domain),
						'tab' => Controls_Manager::TAB_STYLE,
				    ]
				);

				$this->start_controls_tabs('style_tabs_navigation');
		        $this->start_controls_tab('style_normal_navigation_tab', ['label' => __( 'Normal', text_domain ),]);
				$this->add_control(
					'align_navigation',
				    [
						'label' => __( 'Align Navigation', text_domain ),
						'type' => Controls_Manager::CHOOSE,
						'options' => [
							'left' => [
								'title' => __( 'Left', text_domain ),
								'icon' => 'eicon-text-align-left',
							],
						    'center' => [
								'title' => __( 'Center', text_domain ),
								'icon' => 'eicon-text-align-center',
							],
							'right' => [
								'title' => __( 'Right', text_domain ),
								'icon' => 'eicon-text-align-right',
							],
						],
						'default' => 'center',
						'toggle' => true,
						'selectors' => [
							'{{WRAPPER}} .navigation' => 'display: flex ; align-items:center; justify-content:{{VALUE}}',
						],
				    ]
				);
				$this->add_control(
					'color_navigation',
					[
						'label' => __( 'Color Navigation', text_domain ),
						'type' => Controls_Manager::COLOR,
						'default' => '#FDB60D',
						'selectors' => [
							'{{WRAPPER}} .nav-links a' => 'color: {{VALUE}}',
						],
					]
				);
				$this->add_control(
					'bg_color_navigation',
					[
						'label' => __( 'Background Color Navigation', text_domain ),
						'type' => Controls_Manager::COLOR,
						'default' => '#FFF',
						'selectors' => [
							'{{WRAPPER}} .nav-links a' => 'Background: {{VALUE}}',
						],
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'border_navigation',
						'label' => __( 'Border Navigation', text_domain ),
						'selector' => '{{WRAPPER}} .nav-links a,{{WRAPPER}} .nav-links span',
					]
				);

				$this->add_responsive_control(
					'padding_navigation',
					[
					    'label' => __( 'Padding Navigation', text_domain ),
						'type' => Controls_Manager::DIMENSIONS,
						'size_units' => [ 'px', '%', 'em' ],
						'default' => [
							'top' => 7,
			                'right' => 15,
			                'bottom' => 4,
			                'left' => 15,
						],
						'selectors' => [
							'{{WRAPPER}} .nav-links a,{{WRAPPER}} .nav-links span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
						],
					]
			    );
				$this->add_responsive_control(
			 		'margin_navigation',
			 		[
			 			'label' => __( 'Margin Navigation', text_domain ),
			 			'type' => Controls_Manager::DIMENSIONS,
			 			'size_units' => [ 'px', '%', 'em' ],
			 			'selectors' => [
			 			    '{{WRAPPER}} .nav-links a,{{WRAPPER}} .nav-links span , {{WRAPPER}} .nav-links ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			 			],
			 		]
			 	);
				$this->add_control(
				 	'border_radius_navigation',
				 	[
				 	    'label' => __( 'Border Radius Navigation', text_domain ),
				 		'type' => Controls_Manager::DIMENSIONS,
				 		'size_units' => [ 'px', '%', 'em' ],
						'default' => [
							'top' => 5,
					        'right' => 5,
					        'bottom' => 5,
							'left' => 5,
						],
				 		'selectors' => [
				 			'{{WRAPPER}} .nav-links a , {{WRAPPER}} .nav-links span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				 		],
				 	]
				);

		        $this->end_controls_tab();
		        $this->start_controls_tab('style_hover_navigation_tab', ['label' => __( 'Hover', text_domain ),]);
				$this->add_control(
					'hover_color_navigation',
					[
						'label' => __( 'Hover Navigation', text_domain ),
						'type' => Controls_Manager::COLOR,
						'default' => '#FFF',
						'selectors' => [
							'{{WRAPPER}} .nav-links a:hover' => 'color: {{VALUE}}',
						],
					]
				);
				$this->add_control(
					'hover_bg_color_navigation',
					[
						'label' => __( 'Background Hover Navigation', text_domain ),
						'type' => Controls_Manager::COLOR,
						'default' => '#FDB60D',
						'selectors' => [
							'{{WRAPPER}} .nav-links a:hover' => 'Background: {{VALUE}}',
						],
					]
				);
		        $this->end_controls_tab();


				$this->start_controls_tab('style_active_tab', ['label' => __( 'Active', text_domain ),]);
			    $this->add_control(
					'active_color_navigation',
					[
						'label' => __( 'Active Navigation', text_domain ),
						'type' => Controls_Manager::COLOR,
						'default' => '#FFF',
						'selectors' => [
							'{{WRAPPER}} .nav-links span' => 'color: {{VALUE}}',
						],
					]
				);
				$this->add_control(
					'active_bg_color_navigation',
					[
						'label' => __( 'Background Active Navigation', text_domain ),
						'type' => Controls_Manager::COLOR,
						'default' => '#FDB60D',
						'selectors' => [
							'{{WRAPPER}} .nav-links span' => 'Background: {{VALUE}}',
						],
					]
				);
				$this->add_group_control(
					Group_Control_Border::get_type(),
					[
						'name' => 'border_navigation_active',
						'label' => __( 'Border Navigation', text_domain ),
						'selector' => '{{WRAPPER}} .nav-links span',
					 ]
				);
				$this->end_controls_tab();
		        $this->end_controls_tabs();
				$this->end_controls_section();

	}
    protected function register_style_arrows_dots_slider_controls() {
					$this->start_controls_section(
							'section_style_navigation',
							[
									'label' => __( 'Navigation', text_domain ),
									'tab' => Controls_Manager::TAB_STYLE,
									'condition' => [
										'enable_slider' => 'yes',
								    ],
							]
					);
					// Arrows //
					$this->add_control(
							'heading_style_arrows',
							[
									'label' => __( 'Arrows', text_domain ),
									'type' => Controls_Manager::HEADING,
									'separator' => 'before',
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);
					$this->add_responsive_control(
							'right_arrow',
							[
									'label' => __( 'Right Arrow', text_domain ),
									'type' => Controls_Manager::DIMENSIONS,
									'allowed_dimensions' => [ 'top', 'right' ],
									'default' => [
										'top' => '48',
										'right' => '-4',
									],
									'selectors' => [
											'{{WRAPPER}} .swiper-button-prev' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
									],
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);
					$this->add_responsive_control(
							'left_arrow',
							[
									'label' => __( 'Left Arrow', text_domain ),
									'type' => Controls_Manager::DIMENSIONS,
									'allowed_dimensions' => [ 'top', 'left' ],
									'default' => [
										'top' => '48',
										'left' => '-4',
									],
									'selectors' => [
											'{{WRAPPER}} .swiper-button-next' => 'top: {{TOP}}%;left: {{LEFT}}%;right: auto;',
									],
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);
					$this->add_control(
							'arrows_size',
							[
									'label' => __( 'Arrows Size', text_domain ),
									'type' => Controls_Manager::SLIDER,
									'range' => [
											'px' => [
													'min' => 20,
													'max' => 60,
											],
									],
									'default' => [
										'size' => 30,
									],
									'selectors' => [
											'{{WRAPPER}} .tmt-sw-button::after' => 'font-size: {{SIZE}}{{UNIT}};',
									],
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);
					$this->start_controls_tabs( 'arrows_icon_tabs' );
					$this->start_controls_tab( 'arrows_icon_normal', [
							'label' => __( 'Normal', text_domain ),
							'condition' => [
								'navigation' => ['arrows','both'] 
							],
					] );

					$this->add_control(
							'arrows_color',
							[
									'label' => __( 'Icon Color', text_domain ),
									'type' => Controls_Manager::COLOR,
									'default' => '#172541',
									'selectors' => [
											'{{WRAPPER}} .tmt-sw-button' => 'color: {{VALUE}};',
									],
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);
					$this->add_control(
							'arrows_background_color',
							[
									'label' => __( 'Background Color', text_domain ),
									'type' => Controls_Manager::COLOR,
									'selectors' => [
											'{{WRAPPER}} .tmt-sw-button' => 'background-color: {{VALUE}};',
									],
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);
					$this->end_controls_tab();
					$this->start_controls_tab( 'arrows_icon_hover', [
							'label' => __( 'Hover', text_domain ),
							'condition' => [
								'navigation' => ['arrows','both'] 
							],
					] );

					$this->add_control(
							'arrows_hover_color',
							[
									'label' => __( 'Icon Color', text_domain ),
									'type' => Controls_Manager::COLOR,
									'selectors' => [
											'{{WRAPPER}} .tmt-sw-button:hover' => 'color: {{VALUE}};',
									],
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);
					$this->add_control(
							'arrows_hover_background_color',
							[
									'label' => __( 'Background Color', text_domain ),
									'type' => Controls_Manager::COLOR,
									'selectors' => [
											'{{WRAPPER}} .tmt-sw-button:hover' => 'background-color: {{VALUE}};',
									],
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);
					$this->end_controls_tab();
					$this->end_controls_tabs();

					$this->add_responsive_control(
							'arrow_radius',
							[
									'label' => __('Border Radius', text_domain),
									'type' => Controls_Manager::DIMENSIONS,
									'size_units' => ['px', 'em', '%'],
									'selectors' => [
											'{{WRAPPER}} .tmt-sw-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
									],
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);

					$this->add_responsive_control(
							'arrow_padding',
							[
									'label' => esc_html__('Padding', text_domain),
									'type' => Controls_Manager::DIMENSIONS,
									'size_units' => ['px', 'em', '%'],
									'selectors' => [
											'{{WRAPPER}} .tmt-sw-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
									],
									'condition' => [
										'navigation' => ['arrows','both'] 
								    ],
							]
					);
					// Dots //
					$this->add_control(
							'heading_style_dots',
							[
									'label' => __( 'Dots', text_domain ),
									'type' => Controls_Manager::HEADING,
									'separator' => 'before',
									'condition' => [
										'navigation' => ['dots','both'] 
								    ],
							]
					);
					$this->add_control(
						'background_dots',
						[
							'label' => __( 'Background', text_domain ),
							'type' => Controls_Manager::COLOR,
							'selectors' => [
								'{{WRAPPER}} .swiper-pagination' => 'background: {{VALUE}}',
							],
							'condition' => [
								'navigation' => ['both', 'dots'],
							],
						]
					);

					$this->add_control(
						'show_vertical_dots',
						[
							'label' => __( 'Show Vertical', text_domain ),
							'type'  => Controls_Manager::SWITCHER,
							'condition' => [
								'navigation' => ['both', 'dots'],
							],
							'selectors' => [
								'{{WRAPPER}} .swiper-pagination' => 'flex-direction: column;',
							],
						]
					);
					$this->add_control(
						'show_clip_path_dots',
						[
							'label' => __( 'Show Broken', text_domain ),
							'type'  => Controls_Manager::SWITCHER,
							'condition' => [
								'navigation' => ['both', 'dots'],
							],
						]
					);
					$this->add_responsive_control(
						'clip_path_dots',
						[
							'label' => __( 'Clip Path', text_domain ),
							'description' => sprintf(__('For example: <b>%1s</b> or Go <a href="%2s" target="_blank">this link</a> and copy and paste the radius value.', text_domain), '75% 25% 43% 57% / 46% 29% 71% 54%', 'https://9elements.github.io/fancy-border-radius/'),
							'type' => Controls_Manager::TEXTAREA,
							'default'     => '20% 0%, 80% 0%, 100% 100%, 0% 100%',
							'rows' => 5,
							'selectors'   => [
								'{{WRAPPER}} .swiper-pagination' => 'clip-path: polygon({{VALUE}});',
							],
							'condition' => [
								'show_clip_path_dots' => 'yes',
								'navigation' => ['both', 'dots'],
							],
						]
					);

					$this->add_control(
						'number_size',
						[
								'label' => __( 'Number Size', text_domain ),
								'type' => Controls_Manager::SLIDER,
								'range' => [
										'px' => [
												'min' => 20,
												'max' => 60,
										],
								],
								'selectors' => [
										'{{WRAPPER}} .swiper-pagination span' => 'font-size: {{SIZE}}{{UNIT}};',
								],
								'condition' => [
									'navigation' => ['both', 'dots'],
									'show_mode_dots' => 'yes',
								],
						]
					);
					$this->add_responsive_control(
						'dots_slider_rotate',
						[
							'label' => __( 'Rotate', text_domain ),
							'type'  => Controls_Manager::SLIDER,
							'range' => [
								'px' => [
									'min' => 0,
									'max' => 360,
								],
							],
							'selectors'  => [
								'{{WRAPPER}} .swiper-pagination' => 'transform:rotate({{SIZE}}deg);',
							],
							'condition' => [
								'navigation' => ['both', 'dots'],
							],
						]
					);

					$this->add_control(
						'padding_dots',
						[
							'label' => __( 'Padding', text_domain ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .swiper-pagination' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'condition' => [
								'navigation' => ['both', 'dots'],
							],
						]
					);

					$this->add_responsive_control(
						'dots_margin',
						[
							'label' => esc_html__('Margin', text_domain),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => ['px', 'em', '%'],
							'default'   => [
								'top' => '0',
								'right' => '8',
								'bottom' => '0',
								'left' => '8',
								'unit' => 'px',
							],
							'selectors' => [
								'{{WRAPPER}} .swiper-pagination span' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
							],
							'condition' => [
								'navigation' => ['both', 'dots'],
							],
						]
					);
					$this->add_responsive_control(
							'dots_position',
							[
									'label' => __( 'Dots Position', text_domain ),
									'type' => Controls_Manager::DIMENSIONS,
									'allowed_dimensions' => [ 'top', 'right' ],
									'selectors' => [
											'{{WRAPPER}} .swiper-pagination' => 'top: {{TOP}}%;right: {{RIGHT}}%;left: auto;',
									],
									'condition' => [
										'navigation' => ['dots','both'] 
								    ],
							]
					);

					$this->start_controls_tabs('style_tabs_dots');
					$this->start_controls_tab('style_normal_tab_dots', ['label' => __( 'Normal', 'elementor' ),'condition' => [
						'navigation' => ['both', 'dots'],
					],]);

					$this->add_control(
						'dots_color',
						[
								'label' => __( 'Dots Color', text_domain ),
								'type' => Controls_Manager::COLOR,
								'default' => '#FDB60D6B',
								'selectors' => [
										'{{WRAPPER}} .swiper-pagination span' => 'background-color: {{VALUE}};',
								],
								'condition' => [
									'navigation' => ['dots','both'] 
								],
						]
				    );

					$this->add_control(
						'number_color',
						[
								'label' => __( 'Number Color', text_domain ),
								'type' => Controls_Manager::COLOR,
								'selectors' => [
										'{{WRAPPER}} .swiper-pagination span' => 'color: {{VALUE}};',
								],
								'condition' => [
									'navigation' => ['both', 'dots'],
									'show_mode_dots' => 'number',
								],
						]
					);
			
					$this->add_responsive_control(
							'dots_slider_width',
							[
									'label' => __( 'Width', text_domain ),
									'type'  => Controls_Manager::SLIDER,
									'range' => [
											'px' => [
													'min' => 0,
													'max' => 100,
											],
									],
									'default'    => [
											
											'size' => 10,
									],
									'selectors'  => [
											'{{WRAPPER}} .swiper-pagination span' => 'width: {{SIZE}}px;',
									],
									'condition' => [
										'navigation' => ['dots','both'] 
								    ],
							]
					);
					$this->add_responsive_control(
							'dots_slider_height',
							[
									'label' => __( 'Height', text_domain ),
									'type'  => Controls_Manager::SLIDER,
									'range' => [
										'px' => [
											'min' => 0,
											'max' => 100,
										],
									],
									'default'    => [
										'size' => 10,
									],
									'selectors'  => [
											'{{WRAPPER}} .swiper-pagination span' => 'height: {{SIZE}}px;',
									],
									'condition' => [
										'navigation' => ['dots','both'] 
								    ],
							]
					);

					$this->add_responsive_control(
						'dots_radius',
						[
								'label' => __('Border Radius', text_domain),
								'type' => Controls_Manager::DIMENSIONS,
								'size_units' => ['px', '%'],
								'selectors' => [
										'{{WRAPPER}} .swiper-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing:content-box;',
								],
								'condition' => [
									'navigation' => ['dots','both'] 
								],
						]
				    );

					$this->add_control(
						'padding_border',
						[
							'label' => __( 'Padding', text_domain ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .swiper-pagination span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};-moz-outline-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
							],
							'condition' => [
								'navigation' =>  ['dots','both'],
							],
						]
					);







					$this->end_controls_tab();
					$this->start_controls_tab('style_active_tab_dots', ['label' => __( 'Active', 'elementor' ),'condition' => [
						'navigation' => ['both', 'dots'],
					],]);

					$this->add_control(
						'active_dot_color',
						[
								'label' => __( 'Active Dot Color', text_domain ),
								'type' => Controls_Manager::COLOR,
								'default' => '#FDB60D',
								'selectors' => [
										'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'background-color: {{VALUE}};',
								],
								'condition' => [
									'navigation' => ['dots','both'] 
								],
						]
				    );

					$this->add_responsive_control(
						'active_dots_slider_width',
						[
								'label' => __( 'Width', text_domain ),
								'type'  => Controls_Manager::SLIDER,
								'range' => [
										'px' => [
												'min' => 0,
												'max' => 100,
										],
								],
								'default'    => [
										'size' => 3,
								],
								'selectors'  => [
										'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'width: {{SIZE}}px;',
								],
								'condition' => [
									'navigation' => ['dots','both'] 
								],
						]
				    );

					$this->add_responsive_control(
						'active_dots_slider_height',
						[
								'label' => __( 'Height', text_domain ),
								'type'  => Controls_Manager::SLIDER,
								'range' => [
										'px' => [
												'min' => 0,
												'max' => 100,
										],
								],
								'default'    => [
										'size' => 6,
								],
								'selectors'  => [
										'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'height: {{SIZE}}px;',
								],
								'condition' => [
									'navigation' => ['dots','both'] 
								],
						]
				    );

					$this->add_responsive_control(
						'dots_radius_active',
						[
								'label' => __('Border Radius', text_domain),
								'type' => Controls_Manager::DIMENSIONS,
								'size_units' => ['px', '%'],
								/*'default'   => [
										'top' => '50',
										'right' => '50',
										'bottom' => '50',
										'left' => '50',
										'unit' => 'px',
								],*/
								'selectors' => [
										'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; box-sizing:content-box;',
								],
								'condition' => [
									'navigation' => ['both', 'dots'],
								],
						]
					);

					$this->add_control(
						'padding_border_hover',
						[
							'label' => __( 'Padding', text_domain ),
							'type' => Controls_Manager::DIMENSIONS,
							'size_units' => [ 'px', '%' ],
							'selectors' => [
								'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};-moz-outline-radius:{{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
							],
							'condition' => [
								'navigation' =>  ['dots','both'],
							],
						]
					);

					$this->end_controls_tab();
                    $this->end_controls_tabs();
		$this->start_controls_tabs('style_tabs_outline');
        $this->start_controls_tab('style_normal_tab_outline', ['label' => __( 'Normal', 'elementor' ),]);
        $this->add_control(
			'style_outline',
			[
				'label' => __( 'Style Outline', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'options' => [
					'none' => __( 'None', text_domain ),
					'solid'  => __( 'Solid', text_domain ),
					'dashed' => __( 'Dashed', text_domain ),
					'dotted' => __( 'Dotted', text_domain ),
					'double' => __( 'Double', text_domain ),
				],
				'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span' => 'outline-style:{{VALUE}}',
                ],
			]
		);
		
		$this->add_control(
			'outline_thickness',
			[
				'label' => __( 'Thickness', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'outline-width: {{SIZE}}px;',
				],
				'condition' => [
					'style_outline!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		
	    $this->add_control(
			'outline_color',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'outline-color: {{VALUE}}',
				],
				'condition' => [
					'style_outline!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		
		$this->add_control(
			'outline_offset',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],	
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'outline-offset: {{SIZE}}px;',
				],
				'condition' => [
					'style_outline!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		
		$this->add_control(
			'border_radius_outline',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'style_outline!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);

		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_dots',
                'label' => __( 'Box Shadow', text_domain ),
                'selector' => '{{WRAPPER}} .swiper-pagination span',
                'condition' => [
					'style_outline!' => 'none',
					'navigation' =>  ['dots','both'],
				],
            ]
        );

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_border',
				'label' => __( 'Border', text_domain ),
                'separator' => 'before',
				'selector' => '{{WRAPPER}} .swiper-pagination span',
                'condition' => [
					'navigation' =>  ['dots','both'],
				],
			]
		);
		
        $this->end_controls_tab();
        $this->start_controls_tab('style_hover_tab_outline', ['label' => __( 'Hover', 'elementor' ),]);
		$this->add_control(
			'style_outline_hover',
			[
				'label' => __( 'Style Outline', text_domain ),
				'type' => Controls_Manager::SELECT,
				'default' => 'double',
				'options' => [
					'none' => __( 'None', text_domain ),
					'solid'  => __( 'Solid', text_domain ),
					'dashed' => __( 'Dashed', text_domain ),
					'dotted' => __( 'Dotted', text_domain ),
					'double' => __( 'Double', text_domain ),
				],
				'selectors' => [
                    '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'outline-style:{{VALUE}}',
                ],
			]
		);
		
		$this->add_control(
			'outline_thickness_hover',
			[
				'label' => __( 'Thickness', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'outline-width: {{SIZE}}px;',
				],
				'condition' => [
					'style_outline_hover!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		
	    $this->add_control(
			'outline_color_hover',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FDB60D',
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'outline-color: {{VALUE}}',
				],
				'condition' => [
					'style_outline_hover!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		
		$this->add_control(
			'outline_offset_hover',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],	
				],
				'default' => [
					'size' => 4,
				],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'outline-offset: {{SIZE}}px;',
				],
				'condition' => [
					'style_outline_hover!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);
		
		$this->add_control(
			'border_radius_outline_hover',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'style_outline_hover!' => 'none',
					'navigation' =>  'dots',
				],
			]
		);

		$this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow_dots_active',
                'label' => __( 'Box Shadow', text_domain ),
                'selector' => '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active',
                'condition' => [
					'style_outline_hover!' => 'none',
					'navigation' =>  ['dots','both'],
				],
            ]
        );

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_border_hover',
				'label' => __( 'Border', text_domain ),
                'separator' => 'before',
				'selector' => '{{WRAPPER}} .swiper-pagination span.swiper-pagination-bullet-active',
                'condition' => [
					'navigation' =>  ['dots','both'],
				],
			]
		);
		
		
        $this->end_controls_tab();
        $this->end_controls_tabs();
		$this->end_controls_section();
	}
	protected function register_style_meta_data_controls(){
		$this->start_controls_section(
				'meta_data_style',
				[
					'label' => __('Meta Data', text_domain),
					'tab' => Controls_Manager::TAB_STYLE,
					'condition' => [
						'show_meta' => 'yes',
					],
				]
		);

		$this->start_controls_tabs('style_tabs_meta');
		$this->start_controls_tab('style_normal_tab_m', ['label' => __( 'Normal', text_domain ),]);

		$this->add_control(
			'bg_meta_data',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .meta-data' => 'background-color: {{VALUE}}',
				],	
			]
		);

		$this->add_control(
			'bg_meta_data_item',
			[
				'label' => __( 'Background Item', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .meta-data .total' => 'background-color: {{VALUE}}',
				],	
			]
		);

		$this->add_control(
			'color_text_meta_data',
			[
				'label' => __( 'Color Text', text_domain ),
				'type' => Controls_Manager::COLOR,
		        'default' => '#828281',
				'selectors' => [
					'{{WRAPPER}} .meta-data , {{WRAPPER}} .blog-item .meta-data a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'color_icon_meta_data',
			[
				'label' => __( 'Color Icon', text_domain ),
				'type' => Controls_Manager::COLOR,
		        'default' => '#FDB60D',
				'selectors' => [
					'{{WRAPPER}} .meta-data i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'border_radius_meta_item',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-item .meta-data .total' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_tab();
		$this->start_controls_tab('style_hover_tab_m', ['label' => __( 'Hover', text_domain ),]);

		$this->add_control(
			'bg_meta_data_item_hover',
			[
				'label' => __( 'Background Item', text_domain ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .meta-data .total' => 'background-color: {{VALUE}}',
				],	
			]
		);

		$this->add_control(
			'hover_color_icon_meta_data',
			[
				'label' => __( 'Color Hover Icon', text_domain ),
				'type' => Controls_Manager::COLOR,
		        'default' => '#FDB60D',
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .meta-data i' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'color_text_meta_data_hover',
			[
				'label' => __( 'Color Text Hover', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FFF',
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .meta-data , {{WRAPPER}} .blog-item:hover .meta-data a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'border_radius_meta_item_hover',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .meta-data .total' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .blog-item .meta-data .total' => 'transition: .5s',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control(
			'font_size_meta_data',
			[
				'label' => __( 'Size Icon', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'separator' => 'before',
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'default' => [
					'size' => 13,
				],
				'selectors' => [
					'{{WRAPPER}} .meta-data , {{WRAPPER}} .blog-item .meta-data a' => 'font-size: {{SIZE}}px;',
				],
			]
		);

		$this->add_responsive_control(
			'padding_meta_data',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => 7,
					'right' => 24,
					'bottom' => 7,
					'left' => 7,
				],
				'selectors' => [
					'{{WRAPPER}} .meta-data' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->add_responsive_control(
			'padding_meta_data_total',
			[
				'label' => __( 'Padding Item', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .meta-data .total' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'margin_meta_data',
			[
				'label' => __( 'Margin', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => 0,
					'right' => 0,
					'bottom' => 10,
					'left' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .meta-data' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'border_radius_meta',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .meta-data' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'space_between',
			[
				'label' => __( 'Space Between', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'allowed_dimensions' => [ 'left', 'right' ],
				'default' => [
					'left' => 5,
					'right' => 0,
				],
				'selectors' => [
					'{{WRAPPER}} .meta-data .total' => 'margin: {{RIGHT}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
		   [
			   'name' => 'border_meta-data',
			   'label' => __( 'Border', text_domain ),
			   'selector' => '{{WRAPPER}} .meta-data',
		   ]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography_text',
				'label' => __( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .meta-data .total,.meta-data a',
			]
		);

		$this->end_controls_section();
	}
	protected function register_style_auther_controls(){
		$this->start_controls_section(
			'section_style_auther',
			[
				'label' => __('Auther', text_domain),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_auther' => 'yes',
				],
			]
		);

		$this->start_controls_tabs('style_tabs_auther');
		$this->start_controls_tab('style_normal_tab_a', ['label' => __( 'Normal', text_domain ),]);

		$this->add_control(
			'color_text',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FFF',
				'selectors' => [
					'{{WRAPPER}} .blog-item .info .icon-auther a' => 'color: {{VALUE}}',
				],
				//'condition' => [
					//'select_auther!' => 'yesicon-auther',
				//],
			]
		);

		$this->add_control(
			'color_icon',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FFF',
				'selectors' => [
					'{{WRAPPER}} .blog-item .info .icon-auther i' => 'color: {{VALUE}}',
				],
				//'condition' => [
					//'select_auther!' => 'yesicon-auther',
				//],
			]
		);

		$this->add_control(
			'bg_color_auther',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#02108B',
				'selectors' => [
					'{{WRAPPER}} .blog-item .info .icon-auther' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'border_radius_auther',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '12',
	                'right' => '12',
	                'bottom' => '12',
	                'left' => '12',
	                'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .blog-item .info .icon-auther' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_auther',
				'label' => __( 'Border', text_domain ),
				'selector' => '{{WRAPPER}} .blog-item .info .icon-auther',
			]
		);

		$this->end_controls_tab();
		$this->start_controls_tab('style_hover_tab_a', ['label' => __( 'Hover', text_domain ),]);

		$this->add_control(
			'color_auther_hover',
			[
				'label' => __( 'Color', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FFF',
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .info .icon-auther i,{{WRAPPER}} .blog-item:hover .info .icon-auther a' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'hover_bg_color_auther',
			[
				'label' => __( 'Background', text_domain ),
				'type' => Controls_Manager::COLOR,
				'default' => '#FDB60D',
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .info .icon-auther' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'border_radius_auther_hover',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-item:hover .info .icon-auther' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .blog-item .info .icon-auther' => 'transition: .5s',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'border_auther_hover',
				'label' => __( 'Border', text_domain ),
				'selector' => '{{WRAPPER}} .blog-item:hover .info .icon-auther',
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();

		$this->add_responsive_control(
			'width_auther',
			[
				'label' => __( 'Width', text_domain ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px','%'],
				'separator' => 'before',
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size' => 20, 
				],
				'selectors' => [
					'{{WRAPPER}} .blog-item .info .icon-auther img' =>'width:{{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'select_auther' => ['together','icon-auther'],
				],
			]
		);
		
		$this->add_responsive_control(
			'position_row_auther',
			[
				'label' => __( 'Position Row & Vertical', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'allowed_dimensions' => [ 'top', 'right' ],
				'default' => [
					'top' => '-12',
	                'right' => '0',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .blog-item .info .icon-auther' =>'
					-webkit-transform: translate( {{RIGHT}}px , {{TOP}}px ); 
					-ms-transform : translate( {{RIGHT}}px , {{TOP}}px );
					transform : translate( {{RIGHT}}px , {{TOP}}px );',
				],
			]
		);
		
		$this->add_responsive_control(
			'margin_bottom_auther',
			[
				'label' => __( 'Space', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '0',
	                'right' => '0',
	                'bottom' => '5',
	                'left' => '0',
					'unit' => 'px',
					'isLinked' => false,
				],
				'selectors' => [
					'{{WRAPPER}} .blog-item .info .icon-auther' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'padding_auther',
			[
				'label' => __( 'Padding', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '5',
	                'right' => '20',
	                'bottom' => '2',
	                'left' => '20',
	                'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .blog-item .info .icon-auther' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'border_radius_auther_img',
			[
				'label' => __( 'Border Radius', text_domain ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'default' => [
					'top' => '50',
	                'right' => '50',
	                'bottom' => '50',
	                'left' => '50',
	                'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .blog-item .info .icon-auther img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'select_auther' => ['icon-auther','together'],
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography_auther',
				'label' => __( 'Typography', text_domain ),
				'selector' => '{{WRAPPER}} .blog-item .info .icon-auther',
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow_auther',
				'label' => __( 'Box Shadow', text_domain ),
				'selector' => '{{WRAPPER}} .blog-item .info .icon-auther',
			]
		);

		$this->end_controls_section();
	}
    protected function register_style_date_controls(){
	     $this->start_controls_section(
		    'date_style',
		    [
			    'label' => __('Date', text_domain),
			    'tab' => Controls_Manager::TAB_STYLE,
			    'condition' => [
				    'show_data' => 'yes',
			    ],
		    ]
	    );
	    $this->start_controls_tabs('style_tabs_number');
	    $this->start_controls_tab('style_normal_tab_number', ['label' => __( 'Number', text_domain ),]);
	    $this->add_control(
		    'color_date_number',
	        [
		        'label' => __( 'Color Date Number', text_domain ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '#2A2929',
		        'selectors' => [
			        '{{WRAPPER}} .blog-item .date-number' => 'color: {{VALUE}}',
		        ],
		    ]
	    );
	    $this->add_control(
		    'bg_color_date_number',
	        [
		        'label' => __( 'Background Date Number', text_domain ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '#fff',
		        'selectors' => [
			        '{{WRAPPER}} .blog-item .date-number' => 'background-color: {{VALUE}}',
		        ],
		    ]
	    );
	    $this->add_responsive_control(
		    'size_number',
		    [
			    'label' => __( 'Size Number', text_domain ),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => [
					    'min' => 0,
					    'max' => 1000,
				    ],
			    ],
			    'default' => [
				    'size' => 20,
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .blog-item .date-number' => 'font-size: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );
	    $this->add_responsive_control(
	        'border_radius_date_number',
	        [
	            'label' => __( 'Boder Radius', text_domain ),
	            'type' => Controls_Manager::DIMENSIONS,
	            'size_units' => [ 'px','%','em' ],
	            'selectors' => [
		            '{{WRAPPER}} .blog-item .date-number' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	            ],
	        ]
        );
	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'border_data',
			    'label' => __( 'Border Number', text_domain ),
			    'selector' => '{{WRAPPER}} .blog-item .date-number',
		    ]
	    );
	    $this->end_controls_tab();
	    $this->start_controls_tab('style_hover_tab_text', ['label' => __( 'Text', text_domain ),]);
	    $this->add_control(
		    'color_date_text',
	        [
		        'label' => __( 'Color Date Text', text_domain ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '#2A2929',
		        'selectors' => [
			        '{{WRAPPER}} .blog-item .date-text' => 'color: {{VALUE}}',
		        ],
		    ]
	    );
	    $this->add_control(
		    'bg_color_date_text',
	        [
		        'label' => __( 'Background Date Text', text_domain ),
		        'type' => Controls_Manager::COLOR,
		        'default' => '#FFD400',
		        'selectors' => [
			        '{{WRAPPER}} .blog-item .date-text' => 'background-color: {{VALUE}}',
		        ],
		    ]
	    );
	    $this->add_responsive_control(
		    'size_text',
		    [
			    'label' => __( 'Size Text', text_domain ),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => [
					    'min' => 0,
					    'max' => 1000,
				    ],
			    ],
			    'default' => [
				    'size' => 15,
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .blog-item .date-text' => 'font-size: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );
	    $this->add_group_control(
		    Group_Control_Border::get_type(),
		    [
			    'name' => 'border_text',
			    'label' => __( 'Border Text', text_domain ),
			    'selector' => '{{WRAPPER}} .blog-item .date-text',
		    ]
	    );
  	    $this->add_responsive_control(
	        'border_radius_date_text',
	        [
	            'label' => __( 'Boder Radius', text_domain ),
	            'type' => Controls_Manager::DIMENSIONS,
	            'size_units' => [ 'px','%','em' ],
	            'selectors' => [
		            '{{WRAPPER}} .blog-item .date-text' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	            ],
	        ]
        );
	    $this->end_controls_tab();
	    $this->end_controls_tabs();
	    $this->add_responsive_control(
		    'position_data_top',
	 	    [
			    'label' => __( 'Position Vertical', text_domain ),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => [
					    'min' => 0,
					    'max' => 1000,
				    ],
			    ],
			    'default' => [
				    'size' => 20,
			    ],
			    'separator' => 'before',
			    'selectors' => [
				    '{{WRAPPER}} .blog-item .date-item' => 'top: {{SIZE}}px;',
			    ],
		    ]
	    );
	    $this->add_responsive_control(
		    'position_data_right',
		    [
			    'label' => __( 'Position Horizontal', text_domain ),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => [
					    'min' => 0,
					    'max' => 500,
				    ],
			    ],
			    'default' => [
				    'size' => 20,
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .blog-item .date-item' => 'right: {{SIZE}}px;',
			    ],
		    ]
	    );
	    $this->add_responsive_control(
		    'width_data',
		    [
			    'label' => __( 'Width', text_domain ),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => [
					    'min' => 0,
					    'max' => 500,
				    ],
			    ],
			    'default' => [
				    'size' => 35,
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .blog-item .date-item li' => 'width: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );
	    $this->add_responsive_control(
		    'height_data',
	 	    [
			    'label' => __( 'Height', text_domain ),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => [
					    'min' => 0,
					    'max' => 500,
				    ],
			    ],
			    'default' => [
				    'size' => 40,
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .blog-item .date-item li' => 'height: {{SIZE}}{{UNIT}};',
			    ],
	 	    ]
	    );
	    $this->end_controls_section();
    }
    protected function render(){
		$settings = $this->get_settings();
		$post_type = $settings['post_type'];
		$title_tag = $settings['title_tag'];
		$align_title = $settings['align_title'];
		$align_red_more = $settings['align_red_more'];
		$text_more_link = $settings['text_more_link'];
		$icon_red_more = $settings['icon_red_more'];
		$enable_title =  $settings['enable_title'];
		$meta_data = $settings['meta_data'];
		$id = $this->get_id();
		$editor = Plugin::$instance->editor->is_edit_mode();
		$image_size = $settings['image_size'];
		if('custom' == $image_size) {
			$width = $settings['image_custom_dimension']['width'];
			$height = $settings['image_custom_dimension']['height'];
			add_image_size( "custom-$id", $width, $height, true );
		}

	    if($post_type == 'loop') {

			if($editor) {
				$args = array(
					'posts_per_page' => 12,
					'post_status' => 'publish',
					'post_type' => 'post',
				);
				$query = new \WP_Query($args);
				echo "<div class='tmt-posts flex flex-wrap'>";
					if ( $query->have_posts() ):while ( $query->have_posts() ):$query->the_post();
						$this->Post_Loop($settings,$image_size,$id,$editor,$meta_data,$title_tag,$align_title,$align_red_more,$text_more_link,$icon_red_more,$enable_title);
					endwhile;endif;wp_reset_postdata();
				echo "</div>";
			}else {
                echo "<div class='tmt-posts flex flex-wrap'>";
		            if ( have_posts() ) { while ( have_posts() ) { the_post();
                        $this->Post_Loop($settings,$image_size,$id,$editor,$meta_data,$title_tag,$align_title,$align_red_more,$text_more_link,$icon_red_more,$enable_title);
				    }
                echo "</div>";
				    // Previous/next page navigation.
				vihan_the_posts_navigation(3);
				}
				else {
					echo "<header class='page-header'>"
				        . "<h1 class='page-title'>" . __( 'Nothing Found', text_domain ) . "</h1>"
				    . "</header>"

				    . "<div class='page-content'>";
				        if ( is_home() && current_user_can( 'publish_posts' ) ) :
					        printf('<p>' . wp_kses(__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', text_domain ),	array('a' => array('href' => array(),),)) . '</p>',esc_url( admin_url( 'post-new.php' ) ));
				        elseif ( is_search() ) :
					        echo '<p>' . __('Sorry, but nothing matched your search terms. Please try again with some different keywords.', text_domain) . '</p>';get_search_form();
				        else :
					        echo '<p>' . __('It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', text_domain) . '</p>';get_search_form();
				        endif;wp_reset_postdata();
				    echo "</div></div>";
				}
			}
					   
		}else{
            $enable_slider = $settings['enable_slider'];
			if($enable_slider == 'yes') {
  				$is_rtl = is_rtl();
  				$direction = $is_rtl ? 'rtl' : 'ltr';
  				$show_dots = ( in_array( $settings['navigation'], [ 'dots', 'both' ] ) );
  				$show_arrows = ( in_array( $settings['navigation'], [ 'arrows', 'both' ] ) );
				$columns = $settings['slider_columns'];
				$columns_tablet = $settings['slider_columns_tablet'];
				$columns_mobile = $settings['slider_columns_mobile'];
				$pause_on_hover = $settings['pause_on_hover'];
				$infinite = $settings['infinite'];
				$autoplay = $settings['autoplay'];
				$centerMode = $settings['centerMode'];
				$autoplay_speed = $settings['autoplay_speed'];
				$effect = $settings['effect'];
  				$data_swiper = [
					'columns' => absint($columns),
					'columns_tablet' => absint($columns_tablet),
					'columns_mobile_h' => $columns_tablet == 1 ? 1 : $columns_tablet - 1,
					'columns_mobile' => absint($columns_mobile),
					'autoplay' => ( 'yes' === $autoplay ),
					'speed' => absint($autoplay_speed),
					'pause_on_hover' => ( 'yes' === $pause_on_hover ),
					'infinite' => ( 'yes' === $infinite ),
					'centerMode' => ( 'yes' === $centerMode ),
					'effect' => $effect,
				];
				if($effect == 'creative') {
					$data_swiper['creative-type'] = $settings['creative_type'];
				}
		
				$this->add_render_attribute( 'slides', [
					'data-swiper' => wp_json_encode( $data_swiper ),
				] );

				echo "<div id='slider-$id' class='swiper tmt-slider-yes' dir='$direction' ". $this->get_render_attribute_string( 'slides' ) .">"
                	. "<div class='swiper-wrapper tmt-posts'>";
  			} else {
				echo "<div class='tmt-posts flex flex-wrap'>";
			}
			$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
			$args = array(
				'posts_per_page' => $settings['posts_count'],
				'post_status' => 'publish',
				'post_type' => $post_type,
				'order'    => $settings['post_order'],
				'paged'=> $paged,
		    );

			$taxonomies = get_object_taxonomies($post_type, 'objects');
			    unset($taxonomies['post_translations'],$taxonomies['language'],$taxonomies['post_format']);
				foreach ( $taxonomies as $object ) {
				    if (! empty($settings[$object->name])) {
					    $args['tax_query'] = array(
						    array(
							    'taxonomy' => $object->name,
							    'terms' => $settings[$object->name],
						    )
					    );
				    }
				}
			$query = new \WP_Query($args);               
				if ( $query->have_posts() ):while ( $query->have_posts() ):$query->the_post();
                    $this->Post_Loop($settings,$image_size,$id,$editor,$meta_data,$title_tag,$align_title,$align_red_more,$text_more_link,$icon_red_more,$enable_title);
				endwhile;
				if($enable_slider == 'yes') {
					echo '</div>';
					if($show_dots) {
						echo "<div class='swiper-pagination flex align-items-center justify-content-center'></div>";
					}
					if($show_arrows) {
						echo "<div class='tmt-sw-button swiper-button-prev'></div>"
						. "<div class='tmt-sw-button swiper-button-next'></div>";
					}
				}
			echo "</div>";
			if (( 'yes' === $settings['show_pagination'] )) {
            $GLOBALS['wp_query']->max_num_pages = $query->max_num_pages;
                vihan_the_posts_navigation(3);
            };

            endif;wp_reset_postdata();
        }
	}
    private function Post_Loop($settings,$image_size,$id,$editor,$meta_data,$title_tag,$align_title,$align_red_more,$text_more_link,$icon_red_more,$enable_title){
		$title = get_the_title();
		$permalink = get_permalink();

		switch($settings['select_style']) {
        case 'style-one-1' :
			echo "<div class='swiper-slide blog-item'>"
				. "<figure>"
					."<a href='$permalink'>";
						if('custom' == $image_size) {tmt_post_thumbnail("$image_size-$id");}
						else {tmt_post_thumbnail($image_size);}
						if( $settings['show_data'] == 'yes'){
							echo "<div class='date-item flex flex-column justify-content-center align-items-center'>";
								echo '<li class="date-number flex align-items-center justify-content-center">';echo the_time('j') . '</li>'
								. '<li class="date-text flex align-items-center justify-content-center">';echo the_time('F') . '</li>';
							echo "</div>";
						}
					echo "</a>" 
				. "</figure>"

				. "<div class='info'>";
					if($settings['show_auther'] == 'yes') {
						echo "<div class='icon-auther'>";
							switch($settings['select_auther']){
								case 'icon-auther' : TMT_avatar(); break;
								case 'admin-auther' : the_author_posts_link(); break;
								case 'together' :
									echo "<div class='flex justify-content-center align-items-center'>"; 
										TMT_avatar();the_author_posts_link();
									echo "</div>";
								break;
								
								case 'together-2' :
									echo "<div class='flex justify-content-center align-items-center'>"
										."<i class='fas fa-user'></i>";the_author_posts_link();
									echo "</div>";
								break;
							}
					echo "</div>";
					}
					if($settings['show_meta'] == 'yes') {
						echo '<div class="meta-data flex">';
							if (in_array('auther', $meta_data)) {echo '<div class="author total"><i class="far fa-user"></i>'; the_author_posts_link(); echo'</div>';}
							if (in_array('time', $meta_data)) {echo '<div class="time total"><i class="far fa-clock"></i>'; the_time('H:i'); echo'</div>';}
							if (in_array('date', $meta_data)) {echo '<div class="date total"><i class="far fa-calendar-alt"></i>'; the_time('j F Y'); echo'</div>';}						        
							if (in_array('comments', $meta_data)) {echo '<div class="comments total"><i class="far fa-comment"></i>'; comments_number(); echo'</div>';}
							
						echo '</div>';
					}
					if ($enable_title == 'yes'){
					echo "<a href='$permalink'><$title_tag class='title_blog flex align-items-center justify-content-$align_title'>$title</$title_tag></a>";
					}
					if($settings['enable_excerpt'] == 'yes'){
						echo '<p class="excerpt-blog">';
						if(has_excerpt()) {
							the_excerpt();
						} else {
							echo excerpt_post($settings['excerpt_length']);
						}
						echo'</p>';
					}
					if($settings['enable_more'] == 'yes'){echo "<div class='redmore-blog flex align-items-center justify-content-$align_red_more'>" ."<a class='flex align-items-center' href='$permalink'>" . $settings['text_more_link'];Icons_Manager::render_icon($settings['icon_red_more']); echo"</a>" ."</div>";}
				echo "</div>";
			echo "</div>";
		break;
		case 'style-two-2' :
			echo "<div class='swiper-slide card'>";
					echo '<div class="card-project">';
				    if('custom' == $image_size) {tmt_post_thumbnail("$image_size-$id");}
					else {tmt_post_thumbnail($image_size);}
				    echo "<div class='overlay-box'>"
                        . "<div class='overlay-inner'>"
                            . "<div class='content'>";
							if($enable_title == 'yes'){echo "<a  href='$permalink'><$title_tag class='title-card'>$title</$title_tag></a>";}
                            if($settings['enable_excerpt'] == 'yes'){
								echo '<p class="excerpt-card">';
								if(has_excerpt()) {
									the_excerpt();
								} else {
									excerpt_post($settings['excerpt_length']);
								}
								echo '</p>';}
                            if($settings['enable_more'] == 'yes'){ echo"<a class='redmore-card inline-flex' href='$permalink'>" . $text_more_link ; Icons_Manager::render_icon($icon_red_more); echo"</a>";}
                            echo "</div>"
                        . "</div>"
					. "</div>";
				    if($settings['show_icons'] == 'yes'){
                    if($settings['show_icon_link'] == 'yes') {
						echo "<a href='$permalink' class='link'>";Icons_Manager::render_icon( $settings['post_icon_link']);echo "</a>";
					}
					if($settings['show_icon_fancybox'] == 'yes') {
					echo '<a class="icon_fancybox" data-fancybox="gallery" href="';
						    if(has_post_thumbnail()) {the_post_thumbnail_url('large');} else{
							echo wp_directory_uri . '/images/thumbnail.jpg';}
						    echo '" class="icon_fancybox">';Icons_Manager::render_icon($settings['post_icon_fancybox']);
					echo '</a>';
					}}
					echo '</div>';
			echo '</div>';
		break;
	    }
	}
}
Plugin::instance()->widgets_manager->register( new Themento_Post_Grid );