<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
class TMT_Newsletter extends Widget_Base
{
 

    public function get_name()
    {
        return 'tmt-news-letter';
    }
    public function get_title()
    {
        return __('newsletter', text_domain);
    }
    public function get_categories()
    {
        return [text_domain];
    }
    public function get_icon()
    {
        return 'eicon-twitter-feed';
    }
    public function get_keywords()
    {
        return ['news', 'newsletter'];
    }
    
    protected function getMailPoetListForm(){
        global $wpdb;
        $mailpoet_list_form = $wpdb->get_results("SELECT * FROM {$wpdb->prefix}mailpoet_forms");

        if (!empty($mailpoet_list_form)) {
            foreach ($mailpoet_list_form as $mail_form) {
                $options[$mail_form->id] = $mail_form->name;
            }
        }

        return $options;
    }

    protected function register_controls() {
        $this->register_controls_setting();
        $this->register_controls_input_style();
        $this->register_controls_button_style();
    }
    protected function register_controls_setting()
    {
        $this->start_controls_section(
            'section_newsletter',
            [
                'label' => __('newsletter', text_domain),
            ]
        );
        $this->add_control(
            'newslater_form_id',
            [
                'label' => __('Select Form', text_domain),
                'type' => Controls_Manager::SELECT,
                'default' => 'solid',
                'options' => $this->getMailPoetListForm(),
            ]
        );
        $this->end_controls_section();
    }
    protected function register_controls_input_style()
    {
        $this->start_controls_section(
            'section_input',
            [
                'label' => __('Input', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_responsive_control(
            'input_width',
            [
                'label' => __('Width', text_domain),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mailpoet_form_form .mailpoet_paragraph ' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->start_controls_tabs('controls_tabs_input');
        $this->start_controls_tab(
            'controls_normal_input',
            [
                'label' => __('Normal', text_domain),
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'input_typography',
                'label' => __('Typography', text_domain),
                'selector' => '{{WRAPPER}} input[type="email"]',
            ]
        );
        $this->add_control(
            'input_color',
            [
                'label' => __('Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input[type="email"]' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'input_background_color',
            [
                'label' => __('Background Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input[type="email"]' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_responsive_control(
            'input_margin',
            [
                'label' => __('Margin', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} input[type="email"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'input_padding',
            [
                'label' => __('Padding', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} input[type="email"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'input_border_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} input[type="email"]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'input_border',
                'label' => __('Border', text_domain),
                'selector' => '{{WRAPPER}} input[type="email"]',
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'controls_hover_input',
            [
                'label' => __('Hover', text_domain),
            ]
        );
        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'input_normal_border',
                'label' => __('Border', text_domain),
                'selector' => '{{WRAPPER}} input[type="email"]:hover',
            ]
        );
        $this->add_responsive_control(
            'input_hover_border_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} input[type="email"]:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }
    protected function register_controls_button_style()
    {
        $this->start_controls_section(
            'section_button',
            [
                'label' => __('Button', text_domain),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'button_width',
            [
                'label' => __('Width', text_domain),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => '%',
                    'size' => 50,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mailpoet_form .last' => 'width: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );


        $this->add_control(
            'alignment_newsletter',
            [
                'label' => __('Alignment', text_domain),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', text_domain),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', text_domain),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', text_domain),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} form .mailpoet_paragraph' => 'text-align: {{VALUE}}!important',
                ]
            ]
        );

        $this->start_controls_tabs('controls_tabs_button');
        $this->start_controls_tab(
            'controls_normal_button',
            [
                'label' => __('Normal', text_domain),
            ]
        );
		
		$this->add_control(
            'button_size',
            [
                'label' => __('Size', text_domain),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]' => 'font-size: {{SIZE}}{{UNIT}} !important;',
                ],
            ]
        );
		

        $this->add_control(
            'button_color',
            [
                'label' => __('Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]' => 'color: {{VALUE}}!important',
                ],
            ]
        );
        $this->add_control(
            'button_background_color',
            [
                'label' => __('Background Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]' => 'background-color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_margin',
            [
                'label' => __('Margin', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_responsive_control(
            'button_padding',
            [
                'label' => __('Padding', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_border_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'label' => __('Border', text_domain),
                'selector' => '{{WRAPPER}} input[type="submit"]',
            ]
        );


        $this->end_controls_tab();
        $this->start_controls_tab(
            'controls_hover_button',
            [
                'label' => __('Hover', text_domain),
            ]
        );

        $this->add_control(
            'button_hover_color',
            [
                'label' => __('Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'button_hover_background_color',
            [
                'label' => __('Background Color', text_domain),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'button_normal_border',
                'label' => __('Border', text_domain),
                'selector' => '{{WRAPPER}} input[type="submit"]:hover',
            ]
        );


        $this->add_responsive_control(
            'button_hover_border_radius',
            [
                'label' => __('Border Radius', text_domain),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} input[type="submit"]:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
    }
    protected function render()
    {
        $settings = $this->get_settings();
        $editor = Plugin::$instance->editor->is_edit_mode();
         ?>
            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    $('.mailpoet_submit').parent().addClass('last');
                });
           </script>
        <?php
        $form_id = $settings['newslater_form_id'];
        $form_shortcode = '[mailpoet_form id="' . $form_id . '"]';
        echo '<div class="elementor-shortcode">';
        echo do_shortcode(shortcode_unautop($form_shortcode));
        echo '</div>';
    }
}
Plugin::instance()->widgets_manager->register(new TMT_Newsletter);