<?php

namespace Themento\Admin;

class Admin_Helper {

    public function TMT_Text($id, $class, $title, $description, $sub_title, $value, $attr, $width) {
        $sub_title = !empty($sub_title) ? "<p>$sub_title</p>" : '';
        $description = !empty($description) ? "<p>$description</p>" : '';
        $attr = !empty($attr) ? " $attr" : '';
        $content = !empty($content) ? $content : '';
        $class = !empty($class) ? " $class" : '';
        $width = !empty($width) ? " $width" : '';
        $field = "<div id='$id' class='tmt-field field-text$class$width'>"
            . "<label class='tmt-label' for='$id'><span>$title</span>$sub_title</label>"
            . "<div class='tmt-input'><input type='text' value='$value' name='$id'$attr />$description</div>"
        . "</div>";

        return $field;
    }

    public function TMT_Textarea($id, $title, $content, $width) {
        $escaped_content = !empty($content) ? esc_attr($content) : '';
        $br_content = nl2br($escaped_content);
        $field = "<div id='$id' class='tmt-field $width field-textarea'>"
            . "<label for='$id'>$title</label>"
            . "<textarea name='$id' rows='4' cols='50'>". (!empty($content) ? esc_attr($content) : '') ."</textarea>"
        . "</div>";

        return $field;
    }

    public function TMT_URL($id, $title, $url, $parrent, $width) {
        $width = !empty($width) ? " $width" : '';
        $parrent_class = '';
        if(!empty($parrent)) {
            $parrent_value = $parrent[1] == true ? ' tmt-show-field' : '';
            $parrent_class = " tmt-condition-field condition-" . $parrent[0] . $parrent_value;
        }
        $field = "<div id='tmt-field-$id' class='tmt-field field-url$width$parrent_class'>"
            . "<div class='tmt-field-entry'>"
                . "<label for='$id'>$title</label>"
                . "<input type='text' id='$id' value='". (!empty($url) ? esc_attr($url) : '') ."' name='$id' />"
            . "</div>"
        . "</div>";

        return $field;
    }

    public function TMT_Image_Uploader($id, $title, $url, $parrent, $width) {
        $parrent_class = '';
        if(!empty($parrent)) {
            $parrent_value = $parrent[1] == true ? ' tmt-show-field' : '';
            $parrent_class = " tmt-condition-field condition-" . $parrent[0] . $parrent_value;
        }
        $width = !empty($width) ? " $width" : '';
        $field = "<div id='$id' class='tmt-field field-image-uploader$width$parrent_class'>"
            . "<div class='tmt-field-entry'>"
                . "<label for='$id'>$title</label>"
                . "<div class='flex align-items-center'>"
                    . "<button class='button field-upload-img' id='chooseLogo'>انتخاب تصویر</button>"
                    . "<input value='". (!empty($url) ? esc_url($url) : '') ."' type='text' class='field-img-url' name='$id' />"
                    . "<div class='field-img-container'>". (!empty($url) ? '<img src="'. esc_url($url) .'" alt="'. $id . '">' : '') ."</div>"
                    . "<a class='field-delete-img". (empty($url) ? ' hidden' : '') ."' href='#'>حذف تصویر</a>"
                . "</div>"
            . "</div>"
        . "</div>";

        return $field;
    }

    public function TMT_Checkbox($id, $title, $value, $class, $width) {
        $width = !empty($width) ? " $width" : '';
        $class = !empty($class) ? " $class" : '';
        $field = "<div class='tmt-field field-checkbox$class$width'>"
            . "<label for='$id'>"
                . "<span>$title</span>"
                . "<input type='checkbox' id='$id' name='$id' ". ($value == true ? ' checked' : '') ." >"
                . "<span class='btn-toggle'></span>"
            . "</label>"
        . "</div>";

        return $field;
    }

    public function TMT_Simple_Checkbox($id, $class, $title, $value, $description, $attr, $width) {
        $class = !empty($class) ? " $class" : '';
        $width = !empty($width) ? " $width" : '';
        $attr = !empty($attr) ? " $attr" : '';
        $description = !empty($description) ? "<p>$description</p>" : '';
        $value = $value == true ? ' checked' : '';
        $field = "<div class='tmt-field field-simple-checkbox$width$class'>"
            . "<label for='$id'><span>$title</span></label>"
            . "<div class='tmt-input'><input type='checkbox' id='$id' name='$id' $value$attr>$description</div>"
        . "</div>";

        return $field;
    }

    public function TMT_Select($id, $title, $array, $selected, $parrent, $width) {
        $parrent_class = '';
        if(!empty($parrent)) {
            $parrent_value = $parrent[1] == true ? ' tmt-show-field' : '';
            $parrent_class = " tmt-condition-field condition-" . $parrent[0] . $parrent_value;
        }
        $width = !empty($width) ? " $width" : '';
        $field = "<div class='tmt-field field-select$width$parrent_class'>"
            . "<div class='tmt-field-entry'>"
                . "<label for='$id'>$title</label>"
                . "<select class='tmt-select select-single' id='$id' name='$id'>";
                    foreach($array as $id => $value) {
                        $field .= "<option ". ($selected == $id ? ' selected' : '') ." value='$id'>$value</option>";
                    }
                $field .= "</select>"
            . "</div>"
        . "</div>";

        return $field;
    }

    public function TMT_Select2($id, $select_id, $title, $content, $selected, $width) {
        $field = '';
        $field .= "<div id='$id' class='tmt-field $width field-select2'>"
            . "<label for='$id'>$title</label>"
            . "<select class='tmt-select select-multiple' name='$select_id' multiple='multiple'>";
                foreach($content as $id => $value) {
                    $field .= "<option ". (!empty($selected) && in_array($id, $selected) ? ' selected' : '') ." value='$id'>$value</option>";
                }
            $field .= "</select>"
        . "</div>";

        return $field;
    }

    public function TMT_Color($id, $title, $value, $alpha, $default, $parrent, $width) {
        $default = !empty($default) ? $default : '';
        $alpha = $alpha == true ? " data-alpha-enabled='true'" : '';
        $parrent_class = '';
        if(!empty($parrent)) {
            $parrent_value = $parrent[1] == true ? ' tmt-show-field' : '';
            $parrent_class = " tmt-condition-field condition-" . $parrent[0] . $parrent_value;
        }
        $width = !empty($width) ? " $width" : '';
        $field = "<div id='tmt-field-$id' class='tmt-field field-color$width$parrent_class'>"
            . "<div class='tmt-field-entry flex'>"
                . "<label for='$id'>$title</label>"
                . "<input type='text' id='$id' class='color-picker' data-alpha-color-type='hex'$alpha value='". (!empty($value) ? esc_attr($value) : $default) ."' name='$id' />"
            . "</div>"
        . "</div>";

        return $field;
    }

    public function TMT_Editor($id, $title, $content, $width) {
        $settings = array(
            'textarea_name' => $id,
            'wpautop' => false,
            'textarea_rows' => 15,
            'media_buttons' => false,
            'drag_drop_upload' => false,
            'editor_height' => 200,
            'tinymce' => array('plugins' => 'fullscreen,wordpress,wplink,textcolor'),
        );
    
        $content = html_entity_decode($content);
        $content = stripslashes($content);
        return wp_editor($content, $id, $settings);
    }

    public function TMT_Repeater($id, $title, $section, $btn, $settings, $default, $width) {
        $field = '';
        $theme_options = get_option('tmt_main_option', [] );
        $field .= "<div id='$id' class='tmt-field field-repeater'>"
            . "<label for='$id'>$title</label>"
            . "<div class='main-repeater flex flex-wrap'>";
            $get_option = (!empty($theme_options[$section]) ? $theme_options[$section] : '');
            if(!empty($get_option[$id])) {
                $i = -1;
                foreach($get_option[$id] as $repeater) {
                    $i++;
                    $field .= "<div id='". $id . "[" . $i . "]' class='repeater-table $width'>"
                        . "<div class='repeater-table-entry'>"
                        . "<button class='delete-repeater-row'>حذف</button>";
                        foreach($settings as $key => $setting) {
                            $parts = explode('[', $key);
                            $lastPart = end($parts);
                            $default_id = rtrim($lastPart, ']');
                            $type = $setting['type'];
                            $title = $setting['title'];
                            $key = $id . '[' . $i . '][' . $default_id . ']';
                            $w = '';
                            $default = (!empty($get_option[$id][$i][$default_id]) ? $get_option[$id][$i][$default_id] : '');
                            switch($type) {
                                case 'text' :
                                    // $field .= $this->TMT_Text($key, $title, $default, $w);
                                break;
                                case 'textarea' :
                                    $field .= $this->TMT_Textarea($key, $title, $default, $w);
                                break;
                            }
                        }
                        $field .= "</div>"
                    . "</div>";
                }
            } else {
                $field .= "<div id='". $id . "[0]' class='repeater-table $width'>"
                    . "<div class='repeater-table-entry'>";
                    foreach($settings as $id => $setting) {
                        $type = $setting['type'];
                        $title = $setting['title'];
                        $w = '';
                        $default = (!empty($get_option[$id]) ? $get_option[$id] : '');
                        
                        switch($type) {
                            case 'text' :
                                // $field .= $this->TMT_Text($id, $title, $default, $w);
                            break;
                            case 'textarea' :
                                $field .= $this->TMT_Textarea($id, $title, $default, $w);
                            break;
                        }
                    }
                    $field .= "</div>"
                . "</div>";
            }
            $field .= "<button class='button w100 button-primary add-repeater-row'>$btn</button>"
            . "</div>"
        . "</div>";

        return $field;
    }

    public function TMT_Heading($id, $title) {
        $field = "<h3 id='$id' class='tmt-field w100 field-heading'>$title</h3>";

        return $field;
    }

    public function TMT_Seperator() {
        $field = "<hr class='tmt-line-seperator'>";

        return $field;
    }

    public function TMT_Type_To_Function($id,$setting) {
        $type = $setting['type'];
        $content = '';
        switch($type) {
            case 'heading':
                $title = $setting['title'];
                $content = $this->TMT_Heading($id, $title);
            break;

            case 'text':
                $title = $setting['title'];
                $description = !empty($setting['description']) ? $setting['description'] : '';
                $width = !empty($setting['width']) ? $setting['width'] : '';
                $value = !empty($setting['value']) ? $setting['value'] : '';
                $class = !empty($setting['class']) ? $setting['class'] : '';
                $sub_title = !empty($setting['sub-title']) ? $setting['sub-title'] : '';
                $attr = !empty($setting['attr']) ? $setting['attr'] : '';
                $content = $this->TMT_Text($id, $class, $title, $description, $sub_title, $value, $attr, $width);
            break;

            case 'simple-checkbox':
                $title = $setting['title'];
                $value = !empty($setting['value']) ? $setting['value'] : '';
                $description = !empty($setting['description']) ? $setting['description'] : '';
                $class = !empty($setting['class']) ? $setting['class'] : '';
                $attr = !empty($setting['attr']) ? $setting['attr'] : '';
                $width = !empty($setting['width']) ? $setting['width'] : '';
                $content = $this->TMT_Simple_Checkbox($id, $class, $title, $value, $description, $attr, $width);
            break;

            case 'checkbox':
                $title = $setting['title'];
                $value = !empty($setting['value']) ? $setting['value'] : '';
                $class = !empty($setting['class']) ? $setting['class'] : '';
                $width = !empty($setting['width']) ? $setting['width'] : '';
                $content = $this->TMT_Checkbox($id, $title, $value, $class, $width);
            break;
            
            case 'url':
                $title = $setting['title'];
                $url = !empty($setting['url']) ? $setting['url'] : '';
                $width = !empty($setting['width']) ? $setting['width'] : '';
                $parrent = !empty($setting['parrent']) ? $setting['parrent'] : '';
                $content = $this->TMT_URL($id, $title, $url, $parrent, $width);
            break;
            
            case 'color':
                $title = $setting['title'];
                $value = !empty($setting['value']) ? $setting['value'] : '';
                $width = !empty($setting['width']) ? $setting['width'] : '';
                $alpha = !empty($setting['alpha']) ? $setting['alpha'] : false;
                $default = !empty($setting['default']) ? $setting['default'] : '';
                $parrent = !empty($setting['parrent']) ? $setting['parrent'] : '';
                $content = $this->TMT_Color($id, $title, $value, $alpha, $default, $parrent, $width);
            break;

            case 'select':
                $title = $setting['title'];
                $array = !empty($setting['array']) ? $setting['array'] : '';
                $width = !empty($setting['width']) ? $setting['width'] : '';
                $selected = !empty($setting['selected']) ? $setting['selected'] : '';
                $parrent = !empty($setting['parrent']) ? $setting['parrent'] : '';
                $content = $this->TMT_Select($id, $title, $array, $selected, $parrent, $width);
            break;
            
            case 'image':
                $title = $setting['title'];
                $url = !empty($setting['url']) ? $setting['url'] : '';
                $width = !empty($setting['width']) ? $setting['width'] : '';
                $parrent = !empty($setting['parrent']) ? $setting['parrent'] : '';
                $content = $this->TMT_Image_Uploader($id, $title, $url, $parrent, $width);
            break;

            case 'seperator':
                $content = $this->TMT_Seperator();
            break;
        }

        return $content;
    }

    public function TMT_Get_Post_Type($post_type) {
        $posts = [];
        $get_posts 	= get_posts( array( 'post_type' => $post_type, 'numberposts' => -1, 'post_status' => 'publish' ) );
        if ( ! empty ( $get_posts ) ) {
            foreach ( $get_posts as $post ) {
                $posts[ $post->ID ] = $post->post_title;
            }
        }
        return $posts;
    }

    public function TMT_Get_Elementor_Library() {
        $templates 		= array( esc_html__( 'Default', text_domain ) );
        $get_templates 	= get_posts( array( 'post_type' => 'elementor_library', 'numberposts' => -1, 'post_status' => 'publish' ) );
        if ( ! empty ( $get_templates ) ) {
            foreach ( $get_templates as $template ) {
                $templates[ $template->ID ] = $template->post_title;
            }
        }
        return $templates;
    }

    public function convert_post_type_posts( $original_slug = '', $new_slug = '' ) {
        $args = [
            'posts_per_page' => -1,
            'post_type'      => $original_slug,
        ];
        $convert = new \WP_Query( $args );

        if ( $convert->have_posts() ) :
            while ( $convert->have_posts() ) :
                $convert->the_post();
                set_post_type( get_the_ID(), $new_slug );
            endwhile;
        endif;
    }

    public function convert_taxonomy_terms( $original_slug = '', $new_slug = '' ) {
        global $wpdb;

        $args = [
            'taxonomy'   => $original_slug,
            'hide_empty' => false,
            'fields'     => 'ids',
        ];

        $term_ids = get_terms( $args );

        if ( is_int( $term_ids ) ) {
            $term_ids = (array) $term_ids;
        }

        if ( is_array( $term_ids ) && ! empty( $term_ids ) ) {
            $term_ids = implode( ',', $term_ids );

            $query = "UPDATE `{$wpdb->term_taxonomy}` SET `taxonomy` = %s WHERE `taxonomy` = %s AND `term_id` IN ( {$term_ids} )";

            $wpdb->query(
                $wpdb->prepare( $query, $new_slug, $original_slug )
            );
        }
    }
}