/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.15-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: mtpcloud_ldkjcsklcj
-- ------------------------------------------------------
-- Server version	10.11.15-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `mtpcloud_ldkjcsklcj`
--


--
-- Table structure for table `ResellersCenter_BrandedInvoices`
--

DROP TABLE IF EXISTS `ResellersCenter_BrandedInvoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_BrandedInvoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` int(10) unsigned NOT NULL,
  `invoice_id` int(10) unsigned NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `invoicenum` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `reseller_id` (`reseller_id`),
  KEY `invoice_id` (`invoice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_BrandedInvoices`
--

LOCK TABLES `ResellersCenter_BrandedInvoices` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_BrandedInvoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_BrandedInvoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_Documentations`
--

DROP TABLE IF EXISTS `ResellersCenter_Documentations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_Documentations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text DEFAULT NULL,
  `content` text DEFAULT NULL,
  `pdfpath` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_Documentations`
--

LOCK TABLES `ResellersCenter_Documentations` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_Documentations` DISABLE KEYS */;
INSERT INTO `ResellersCenter_Documentations` (`id`, `name`, `content`, `pdfpath`, `created_at`, `updated_at`) VALUES (1,'ModulesGarden Manual','&lt;style&gt;\n    .mg-default-documentation img{\n        margin-top: 30px;\n        margin-bottom: 30px;\n    }\n    .mg-default-documentation .content-list{\n        margin-top: 60px;\n        margin-bottom: 60px;\n    }\n    \n    .mg-default-documentation ol { counter-reset: item; padding-left: 10px;}\n    .mg-default-documentation li { display: block;  font-size: 20px; line-height: 30px; }\n    .mg-default-documentation li:before { content: counters(item, &quot;.&quot;) &quot;. &quot;; counter-increment: item; }\n&lt;/style&gt;\n\n&lt;div class=&quot;mg-default-documentation&quot;&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 70%;&quot; src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/mglogo.png&quot;&gt;&lt;/center&gt;\n\n    &lt;center&gt;&lt;h1&gt;&lt;strong&gt;Reseller Area&lt;/strong&gt;&lt;/h1&gt;&lt;/center&gt;\n    &lt;center&gt;&lt;h2&gt;Manual For Resellers&lt;/h2&gt;&lt;/center&gt;\n\n    &lt;div class=&quot;content-list&quot;&gt;\n        &lt;ol&gt;\n            &lt;li&gt;Introduction&lt;/li&gt;\n            &lt;li&gt;Clients&lt;/li&gt;\n            &lt;li&gt;Product Pricing&lt;/li&gt;\n            &lt;li&gt;Configuration&lt;/li&gt;\n            &lt;li&gt;Invoices&lt;/li&gt;\n            &lt;li&gt;Orders&lt;/li&gt;\n            &lt;li&gt;Ordering&lt;/li&gt;\n                &lt;ol&gt;\n                    &lt;li&gt;Product Assignment&lt;/li&gt;\n                    &lt;li&gt;Access Order From The Client Area&lt;/li&gt;\n                &lt;/ol&gt;\n            &lt;li&gt;Tickets Management&lt;/li&gt;\n        &lt;/ol&gt;\n    &lt;/div&gt;\n\n    &lt;h2&gt;1. Introduction&lt;/h2&gt;\n    &lt;p&gt;The Resellers Area you are currently browsing will empower you to carefully manage all acquired customers together with products, services and domains they have obtained. At the same time, your clients will be allowed to readily place orders directly in your customized store and then, log in to their own accounts in order to handle purchases, pay invoices or even create tickets.&lt;/p&gt;\n    &lt;p&gt;Reseller Area gathers all instruments for you to manage every key aspect of your reselling activities. You can handle the particulars of your customers here, define prices of offered products, set up branding of your store, customize email templates, submit tickets and more.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot; src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/resellersarea.png&quot;&gt;&lt;/center&gt;\n\n    &lt;h2&gt;2. Clients&lt;/h2&gt;\n    &lt;p&gt;In this section you can view the list of acquired clients as well as perform all customer related actions. These are: logging in as a client (1), placing the order for a client (2), viewing customer details (3) and deleting the account of a given client (4).&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/clients1.png&quot;&gt;&lt;/center&gt;\n    &lt;p&gt;If you wish to add a new client, simply press the &lsquo;+&rsquo; button as presented below.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/clients2.png&quot;&gt;&lt;/center&gt;\n    &lt;p&gt;Then, fill in all required data in both &quot;General&quot; and &quot;Address&quot; tabs. Remember to save the changes before moving to another section.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/clients3.png&quot;&gt;&lt;/center&gt;\n    &lt;p&gt;Enter &lsquo;Client Details&rsquo; section (3) to view or edit personal data of a given customer as well as access complete information concerning their orders, invoices, services, addons and domains.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/clients4.png&quot;&gt;&lt;/center&gt;\n\n    &lt;h2&gt;3. Product Pricing&lt;/h2&gt;\n    &lt;p&gt;Before you can offer the products, addons and domains to your clients, you need to establish your own pricing for them. Move to the &quot;Product Pricing&quot; section to do so.&lt;/p&gt;\n    &lt;p&gt;It is important to define the price of each product, as otherwise, it will not be available for your customers. Keep in mind that your charges have to be chosen only from within the pricing range set by the provider.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/pricing1.png&quot;&gt;&lt;/center&gt;\n\n    &lt;h2&gt;4. Configuration&lt;/h2&gt;\n    &lt;p&gt;All fundamental elements, such as your company name, an email signature as well as the logo visible across the client area, emails and invoices, can be defined in the &quot;Configuration&quot; section.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/config1.png&quot;&gt;&lt;/center&gt;\n    &lt;p&gt;Additionally, the &lsquo;Configuration&rsquo; section contains &quot;Email Templates&quot; tab where you can view and manage templates of email notifications sent to your clients.&lt;/p&gt;\n    &lt;p&gt;Press &quot;Edit&quot; button next to a given template to modify its content and other details.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/config2.png&quot;&gt;&lt;/center&gt;\n    &lt;p&gt;Remember to press the &quot;Save Changes&quot; button once all necessary alterations are made.&lt;/p&gt;\n    &lt;p&gt;Note: When editing the template, you can easily add merge fields using dropdown menus indicated on the following screen.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/config3.png&quot;&gt;&lt;/center&gt;\n\n    &lt;h2&gt;5. Invoices&lt;/h2&gt;\n    &lt;p&gt;The &lsquo;Invoices&rsquo; section provides the list of all invoices generated for your clients along with their current statuses.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/invoices1.png&quot;&gt;&lt;/center&gt;\n\n    &lt;h2&gt;6. Orders&lt;/h2&gt;\n    &lt;p&gt;Each order placed by your clients along with the payment method they have chosen and the current status of a transaction is presented on a transparent list in the &lsquo;Orders&rsquo; section.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/orders1.png&quot;&gt;&lt;/center&gt;\n\n    &lt;h2&gt;7. Ordering&lt;/h2&gt;\n    &lt;p&gt;There are two methods to add a product to your customer&rsquo;s account, below both of them are explained in detail.&lt;/p&gt;\n\n    &lt;h2&gt;7.1 Product Assignment&lt;/h2&gt;\n    &lt;p&gt;You can place a new order for your client as you would do normally when purchasing services for yourself.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/ordering1.png&quot;&gt;&lt;/center&gt;\n    &lt;p&gt;In this scenario,order confirmation emails will be sent to both you and your client.&lt;/p&gt;\n    &lt;p&gt;Your customers will be able to view and handle all previously ordered products once they log in to the WHMCS client area. They will be also permitted to pay invoices and submit tickets (provided that these options are enabled in the module).&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/ordering2.png&quot;&gt;&lt;/center&gt;\n\n    &lt;h2&gt;7.2 Access Order From The Client Area&lt;/h2&gt;\n    &lt;p&gt;In the WHMCS client area, your customers can view the order form containing the list of all products you have on offer. They can easily place orders using this very form.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/ordering3.png&quot;&gt;&lt;/center&gt;\n\n    &lt;h2&gt;8. Tickets Management&lt;/h2&gt;\n    &lt;p&gt;As a reseller, you are given access to separate tickets departments created by the provider. Enter the &lsquo;Tickets&rsquo; section to view a complete list of tickets submitted by your customers from the WHMCS client area.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/tickets1.png&quot;&gt;&lt;/center&gt;\n\n    &lt;p&gt;Additionally, you can respond in the tickets opened by your clients.&lt;/p&gt;\n    &lt;center&gt;&lt;img style=&quot;width: 50%;&quot;src=&quot;modules/addons/ResellersCenter/resources/reseller_documentation/img/tickets2.png&quot;&gt;&lt;/center&gt;\n&lt;/div&gt;','modules/addons/ResellersCenter/storage/documentations/ManualForReseller.pdf','2017-09-07 18:53:03','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `ResellersCenter_Documentations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_EmailTemplates`
--

DROP TABLE IF EXISTS `ResellersCenter_EmailTemplates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_EmailTemplates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` int(10) DEFAULT NULL,
  `name` text DEFAULT NULL,
  `subject` text DEFAULT NULL,
  `message` text DEFAULT NULL,
  `language` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `reseller_id` (`reseller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_EmailTemplates`
--

LOCK TABLES `ResellersCenter_EmailTemplates` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_EmailTemplates` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_EmailTemplates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_Groups`
--

DROP TABLE IF EXISTS `ResellersCenter_Groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_Groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_Groups`
--

LOCK TABLES `ResellersCenter_Groups` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_Groups` DISABLE KEYS */;
INSERT INTO `ResellersCenter_Groups` (`id`, `name`, `created_at`, `updated_at`, `deleted_at`) VALUES (1,'Reseller 1','2017-09-07 18:57:16','2017-09-07 18:57:16',NULL);
/*!40000 ALTER TABLE `ResellersCenter_Groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_GroupsContents`
--

DROP TABLE IF EXISTS `ResellersCenter_GroupsContents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_GroupsContents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `relid` int(10) unsigned NOT NULL,
  `type` enum('product','addon','domainregister','domaintransfer','domainrenew') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `relid` (`relid`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_GroupsContents`
--

LOCK TABLES `ResellersCenter_GroupsContents` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_GroupsContents` DISABLE KEYS */;
INSERT INTO `ResellersCenter_GroupsContents` (`id`, `group_id`, `relid`, `type`) VALUES (1,1,50,'product'),
(2,1,51,'product'),
(3,1,64,'product'),
(4,1,52,'product'),
(5,1,61,'product'),
(6,1,63,'product');
/*!40000 ALTER TABLE `ResellersCenter_GroupsContents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_GroupsContentsPricing`
--

DROP TABLE IF EXISTS `ResellersCenter_GroupsContentsPricing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_GroupsContentsPricing` (
  `relid` int(10) unsigned NOT NULL,
  `type` varchar(255) NOT NULL,
  `currency` int(10) unsigned NOT NULL,
  `billingcycle` varchar(40) NOT NULL,
  `value` decimal(16,2) DEFAULT NULL,
  PRIMARY KEY (`relid`,`type`,`currency`,`billingcycle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_GroupsContentsPricing`
--

LOCK TABLES `ResellersCenter_GroupsContentsPricing` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_GroupsContentsPricing` DISABLE KEYS */;
INSERT INTO `ResellersCenter_GroupsContentsPricing` (`relid`, `type`, `currency`, `billingcycle`, `value`) VALUES (1,'adminprice',1,'annually',600000.00),
(1,'adminprice',1,'biennially',1100000.00),
(1,'adminprice',1,'triennially',1500000.00),
(1,'highestprice',1,'annually',600000.00),
(1,'highestprice',1,'biennially',1100000.00),
(1,'highestprice',1,'triennially',1500000.00),
(1,'lowestprice',1,'annually',600000.00),
(1,'lowestprice',1,'biennially',1100000.00),
(1,'lowestprice',1,'triennially',1500000.00),
(2,'adminprice',1,'annually',13500000.00),
(2,'adminprice',1,'biennially',24000000.00),
(2,'highestprice',1,'annually',13500000.00),
(2,'highestprice',1,'biennially',24000000.00),
(2,'lowestprice',1,'annually',13500000.00),
(2,'lowestprice',1,'biennially',24000000.00),
(3,'adminprice',1,'annually',600000.00),
(3,'adminprice',1,'biennially',1100000.00),
(3,'adminprice',1,'triennially',1500000.00),
(3,'highestprice',1,'annually',600000.00),
(3,'highestprice',1,'biennially',1100000.00),
(3,'highestprice',1,'triennially',1500000.00),
(3,'lowestprice',1,'annually',600000.00),
(3,'lowestprice',1,'biennially',1100000.00),
(3,'lowestprice',1,'triennially',1500000.00),
(4,'adminprice',1,'annually',4190000.00),
(4,'adminprice',1,'biennially',8300000.00),
(4,'adminprice',1,'triennially',12500000.00),
(4,'highestprice',1,'annually',4190000.00),
(4,'highestprice',1,'biennially',8300000.00),
(4,'highestprice',1,'triennially',12500000.00),
(4,'lowestprice',1,'annually',4190000.00),
(4,'lowestprice',1,'biennially',8300000.00),
(4,'lowestprice',1,'triennially',12500000.00),
(5,'adminprice',1,'annually',600000.00),
(5,'adminprice',1,'biennially',1200000.00),
(5,'adminprice',1,'triennially',1800000.00),
(5,'highestprice',1,'annually',600000.00),
(5,'highestprice',1,'biennially',1200000.00),
(5,'highestprice',1,'triennially',1800000.00),
(5,'lowestprice',1,'annually',600000.00),
(5,'lowestprice',1,'biennially',1200000.00),
(5,'lowestprice',1,'triennially',1800000.00),
(6,'adminprice',1,'annually',3000000.00),
(6,'adminprice',1,'biennially',60000000.00),
(6,'adminprice',1,'triennially',9000000.00),
(6,'highestprice',1,'annually',3000000.00),
(6,'highestprice',1,'biennially',60000000.00),
(6,'highestprice',1,'triennially',9000000.00),
(6,'lowestprice',1,'annually',3000000.00),
(6,'lowestprice',1,'biennially',60000000.00),
(6,'lowestprice',1,'triennially',9000000.00);
/*!40000 ALTER TABLE `ResellersCenter_GroupsContentsPricing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_GroupsContentsSettings`
--

DROP TABLE IF EXISTS `ResellersCenter_GroupsContentsSettings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_GroupsContentsSettings` (
  `relid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned NOT NULL,
  `setting` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`relid`,`group_id`,`setting`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_GroupsContentsSettings`
--

LOCK TABLES `ResellersCenter_GroupsContentsSettings` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_GroupsContentsSettings` DISABLE KEYS */;
INSERT INTO `ResellersCenter_GroupsContentsSettings` (`relid`, `group_id`, `setting`, `value`, `created_at`, `updated_at`) VALUES (1,1,'counting_type','Difference','2017-09-07 18:57:40','2017-09-07 18:57:40'),
(2,1,'counting_type','Difference','2017-09-07 18:57:56','2017-09-07 18:57:56'),
(3,1,'counting_type','Difference','2017-09-07 18:58:20','2017-09-07 18:58:20'),
(4,1,'counting_type','Difference','2017-09-07 18:58:35','2017-09-07 18:58:35'),
(5,1,'counting_type','Difference','2017-09-07 18:58:47','2017-09-07 18:58:47'),
(6,1,'counting_type','Difference','2017-09-07 18:59:04','2017-09-07 18:59:04');
/*!40000 ALTER TABLE `ResellersCenter_GroupsContentsSettings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_InvoiceItems`
--

DROP TABLE IF EXISTS `ResellersCenter_InvoiceItems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_InvoiceItems` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` int(10) unsigned NOT NULL,
  `invoice_id` int(10) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `type` varchar(30) NOT NULL,
  `relid` int(10) unsigned NOT NULL,
  `description` text NOT NULL,
  `amount` decimal(16,2) NOT NULL,
  `taxed` int(1) NOT NULL,
  `duedate` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `paymentmethod` text NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_id` (`invoice_id`),
  KEY `reseller_id` (`reseller_id`),
  KEY `userid` (`userid`),
  KEY `relid` (`relid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_InvoiceItems`
--

LOCK TABLES `ResellersCenter_InvoiceItems` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_InvoiceItems` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_InvoiceItems` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_Invoices`
--

DROP TABLE IF EXISTS `ResellersCenter_Invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_Invoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` int(10) unsigned NOT NULL,
  `relinvoice_id` int(10) unsigned NOT NULL,
  `userid` int(10) unsigned NOT NULL,
  `invoicenum` text NOT NULL,
  `date` date DEFAULT '0000-00-00',
  `duedate` date DEFAULT '0000-00-00',
  `datepaid` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_capture_attempt` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `subtotal` decimal(16,2) NOT NULL,
  `credit` decimal(16,2) NOT NULL,
  `tax` decimal(16,2) NOT NULL,
  `tax2` decimal(16,2) NOT NULL,
  `total` decimal(16,2) NOT NULL,
  `taxrate` decimal(16,2) NOT NULL,
  `taxrate2` decimal(16,2) NOT NULL,
  `status` text NOT NULL,
  `paymentmethod` text NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `reseller_id` (`reseller_id`),
  KEY `userid` (`userid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_Invoices`
--

LOCK TABLES `ResellersCenter_Invoices` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_Invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_Invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_Logs`
--

DROP TABLE IF EXISTS `ResellersCenter_Logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_Logs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(10) DEFAULT NULL,
  `reseller_id` int(10) DEFAULT NULL,
  `client_id` int(10) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `type` enum('info','warning','error') NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `admin_id` (`admin_id`),
  KEY `reseller_id` (`reseller_id`),
  KEY `client_id` (`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_Logs`
--

LOCK TABLES `ResellersCenter_Logs` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_Logs` DISABLE KEYS */;
INSERT INTO `ResellersCenter_Logs` (`id`, `admin_id`, `reseller_id`, `client_id`, `description`, `type`, `created_at`) VALUES (1,1,NULL,NULL,'New resellers group has been created. Group: <a href=\'?module=ResellersCenter&mg-page=groups\'>#1</a> Reseller 1','info','2017-09-07 18:57:16'),
(2,1,NULL,NULL,'New content (product: <a href=\'?module=ResellersCenter&mg-page=groups\'>#50</a>) has been added to group <a href=\'?module=ResellersCenter&mg-page=groups\'>#1</a>','info','2017-09-07 18:57:40'),
(3,1,NULL,NULL,'New content (product: <a href=\'?module=ResellersCenter&mg-page=groups\'>#51</a>) has been added to group <a href=\'?module=ResellersCenter&mg-page=groups\'>#1</a>','info','2017-09-07 18:57:57'),
(4,1,NULL,NULL,'New content (product: <a href=\'?module=ResellersCenter&mg-page=groups\'>#64</a>) has been added to group <a href=\'?module=ResellersCenter&mg-page=groups\'>#1</a>','info','2017-09-07 18:58:20'),
(5,1,NULL,NULL,'New content (product: <a href=\'?module=ResellersCenter&mg-page=groups\'>#52</a>) has been added to group <a href=\'?module=ResellersCenter&mg-page=groups\'>#1</a>','info','2017-09-07 18:58:35'),
(6,1,NULL,NULL,'New content (product: <a href=\'?module=ResellersCenter&mg-page=groups\'>#61</a>) has been added to group <a href=\'?module=ResellersCenter&mg-page=groups\'>#1</a>','info','2017-09-07 18:58:47'),
(7,1,NULL,NULL,'New content (product: <a href=\'?module=ResellersCenter&mg-page=groups\'>#63</a>) has been added to group <a href=\'?module=ResellersCenter&mg-page=groups\'>#1</a>','info','2017-09-07 18:59:04'),
(8,1,NULL,NULL,'Content <a href=\'?module=ResellersCenter&mg-page=groups\'>#6</a> pricing has been updated','info','2017-09-07 19:00:20'),
(9,1,NULL,NULL,'New reseller (client: #1) has been created and assinged to group #1','info','2017-09-07 19:01:47'),
(10,1,NULL,NULL,'Configuration has been updated for reseller #1 (0 mean default settings)','info','2017-09-07 19:02:25');
/*!40000 ALTER TABLE `ResellersCenter_Logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_PaymentGateways`
--

DROP TABLE IF EXISTS `ResellersCenter_PaymentGateways`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_PaymentGateways` (
  `reseller_id` int(11) DEFAULT NULL,
  `gateway` varchar(255) DEFAULT NULL,
  `setting` varchar(255) DEFAULT NULL,
  `value` text DEFAULT NULL,
  KEY `gateway` (`gateway`),
  KEY `setting` (`setting`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_PaymentGateways`
--

LOCK TABLES `ResellersCenter_PaymentGateways` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_PaymentGateways` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_PaymentGateways` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_PaymentGatewaysLogs`
--

DROP TABLE IF EXISTS `ResellersCenter_PaymentGatewaysLogs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_PaymentGatewaysLogs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` int(10) unsigned NOT NULL,
  `date` datetime DEFAULT NULL,
  `gateway` text NOT NULL,
  `data` text NOT NULL,
  `result` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `reseller_id` (`reseller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_PaymentGatewaysLogs`
--

LOCK TABLES `ResellersCenter_PaymentGatewaysLogs` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_PaymentGatewaysLogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_PaymentGatewaysLogs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_Resellers`
--

DROP TABLE IF EXISTS `ResellersCenter_Resellers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_Resellers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `lastlogin` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_Resellers`
--

LOCK TABLES `ResellersCenter_Resellers` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_Resellers` DISABLE KEYS */;
INSERT INTO `ResellersCenter_Resellers` (`id`, `client_id`, `group_id`, `lastlogin`, `created_at`, `updated_at`) VALUES (1,1,1,'2017-09-07 19:03:01','2017-09-07 19:01:47','2017-09-07 19:03:01');
/*!40000 ALTER TABLE `ResellersCenter_Resellers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_ResellersClients`
--

DROP TABLE IF EXISTS `ResellersCenter_ResellersClients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_ResellersClients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `reseller_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `client_id` (`client_id`),
  KEY `reseller_id` (`reseller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_ResellersClients`
--

LOCK TABLES `ResellersCenter_ResellersClients` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_ResellersClients` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_ResellersClients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_ResellersPricing`
--

DROP TABLE IF EXISTS `ResellersCenter_ResellersPricing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_ResellersPricing` (
  `reseller_id` int(10) unsigned NOT NULL,
  `relid` int(10) unsigned NOT NULL,
  `type` enum('product','addon','domainregister','domaintransfer','domainrenew') NOT NULL,
  `currency` int(10) unsigned NOT NULL,
  `billingcycle` varchar(40) NOT NULL,
  `value` decimal(16,2) DEFAULT NULL,
  KEY `reseller_id` (`reseller_id`),
  KEY `relid` (`relid`),
  KEY `type` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_ResellersPricing`
--

LOCK TABLES `ResellersCenter_ResellersPricing` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_ResellersPricing` DISABLE KEYS */;
INSERT INTO `ResellersCenter_ResellersPricing` (`reseller_id`, `relid`, `type`, `currency`, `billingcycle`, `value`) VALUES (1,50,'product',1,'annually',600000.00),
(1,50,'product',1,'biennially',1100000.00),
(1,50,'product',1,'triennially',1500000.00),
(1,51,'product',1,'annually',13500000.00),
(1,51,'product',1,'biennially',24000000.00),
(1,52,'product',1,'annually',4190000.00),
(1,52,'product',1,'biennially',8300000.00),
(1,52,'product',1,'triennially',12500000.00),
(1,61,'product',1,'annually',600000.00),
(1,61,'product',1,'biennially',1200000.00),
(1,61,'product',1,'triennially',1800000.00),
(1,63,'product',1,'annually',3000000.00),
(1,63,'product',1,'biennially',60000000.00),
(1,63,'product',1,'triennially',9000000.00),
(1,64,'product',1,'annually',600000.00),
(1,64,'product',1,'biennially',1100000.00),
(1,64,'product',1,'triennially',1500000.00);
/*!40000 ALTER TABLE `ResellersCenter_ResellersPricing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_ResellersProfits`
--

DROP TABLE IF EXISTS `ResellersCenter_ResellersProfits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_ResellersProfits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` int(10) unsigned NOT NULL,
  `invoiceitem_id` int(10) unsigned NOT NULL,
  `service_id` int(10) unsigned NOT NULL,
  `amount` decimal(16,2) DEFAULT NULL,
  `collected` int(1) unsigned NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `reseller_id` (`reseller_id`),
  KEY `invoiceitem_id` (`invoiceitem_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_ResellersProfits`
--

LOCK TABLES `ResellersCenter_ResellersProfits` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_ResellersProfits` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_ResellersProfits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_ResellersServices`
--

DROP TABLE IF EXISTS `ResellersCenter_ResellersServices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_ResellersServices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `reseller_id` int(10) unsigned NOT NULL,
  `type` enum('addon','hosting','domain') NOT NULL,
  `relid` int(10) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `reseller_id` (`reseller_id`),
  KEY `relid` (`relid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_ResellersServices`
--

LOCK TABLES `ResellersCenter_ResellersServices` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_ResellersServices` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_ResellersServices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_ResellersSettings`
--

DROP TABLE IF EXISTS `ResellersCenter_ResellersSettings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_ResellersSettings` (
  `reseller_id` int(10) unsigned NOT NULL DEFAULT 0,
  `private` int(1) unsigned NOT NULL DEFAULT 0,
  `setting` varchar(255) NOT NULL,
  `value` text DEFAULT NULL,
  PRIMARY KEY (`reseller_id`,`setting`,`private`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_ResellersSettings`
--

LOCK TABLES `ResellersCenter_ResellersSettings` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_ResellersSettings` DISABLE KEYS */;
INSERT INTO `ResellersCenter_ResellersSettings` (`reseller_id`, `private`, `setting`, `value`) VALUES (1,1,'docsDoNotShowAgain','1'),
(1,0,'documentation','1'),
(1,0,'invoicenumber',''),
(1,0,'nextinvoicenumber',''),
(1,0,'products','on'),
(1,1,'skipResellerDashboard','1'),
(1,0,'status','on');
/*!40000 ALTER TABLE `ResellersCenter_ResellersSettings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_ResellersTickets`
--

DROP TABLE IF EXISTS `ResellersCenter_ResellersTickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_ResellersTickets` (
  `ticket_id` int(10) NOT NULL,
  `reseller_id` int(10) NOT NULL,
  PRIMARY KEY (`ticket_id`),
  KEY `reseller_id` (`reseller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_ResellersTickets`
--

LOCK TABLES `ResellersCenter_ResellersTickets` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_ResellersTickets` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_ResellersTickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_SessionStorage`
--

DROP TABLE IF EXISTS `ResellersCenter_SessionStorage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_SessionStorage` (
  `key` varchar(255) NOT NULL,
  `time` int(10) NOT NULL,
  `value` blob NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_SessionStorage`
--

LOCK TABLES `ResellersCenter_SessionStorage` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_SessionStorage` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_SessionStorage` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ResellersCenter_Transactions`
--

DROP TABLE IF EXISTS `ResellersCenter_Transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ResellersCenter_Transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `userid` int(10) unsigned NOT NULL,
  `currency` int(10) unsigned NOT NULL,
  `gateway` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `description` text NOT NULL,
  `amountin` decimal(16,2) NOT NULL,
  `fees` decimal(16,2) NOT NULL,
  `amountout` decimal(16,2) NOT NULL,
  `rate` decimal(16,2) NOT NULL,
  `transid` text NOT NULL,
  `invoice_id` int(10) unsigned NOT NULL,
  `refundid` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_id` (`invoice_id`),
  KEY `refundid` (`refundid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ResellersCenter_Transactions`
--

LOCK TABLES `ResellersCenter_Transactions` WRITE;
/*!40000 ALTER TABLE `ResellersCenter_Transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ResellersCenter_Transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certum_approvers`
--

DROP TABLE IF EXISTS `certum_approvers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certum_approvers` (
  `serviceid` int(12) unsigned NOT NULL,
  `data` text NOT NULL,
  UNIQUE KEY `serviceid` (`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certum_approvers`
--

LOCK TABLES `certum_approvers` WRITE;
/*!40000 ALTER TABLE `certum_approvers` DISABLE KEYS */;
/*!40000 ALTER TABLE `certum_approvers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `certum_renewals`
--

DROP TABLE IF EXISTS `certum_renewals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `certum_renewals` (
  `serviceid` int(12) unsigned NOT NULL,
  `serial` char(255) NOT NULL,
  `pem` text NOT NULL,
  `csr` text NOT NULL,
  UNIQUE KEY `serviceid` (`serviceid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `certum_renewals`
--

LOCK TABLES `certum_renewals` WRITE;
/*!40000 ALTER TABLE `certum_renewals` DISABLE KEYS */;
/*!40000 ALTER TABLE `certum_renewals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloudflare_log`
--

DROP TABLE IF EXISTS `cloudflare_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloudflare_log` (
  `log_id` int(10) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `message` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloudflare_log`
--

LOCK TABLES `cloudflare_log` WRITE;
/*!40000 ALTER TABLE `cloudflare_log` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloudflare_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloudflare_plans`
--

DROP TABLE IF EXISTS `cloudflare_plans`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloudflare_plans` (
  `addonid` int(10) DEFAULT NULL,
  `pricingid` int(10) DEFAULT NULL,
  `cf_auth_dns` tinyint(1) DEFAULT NULL,
  `plan_tag` varchar(255) DEFAULT NULL,
  `defaulton` tinyint(4) DEFAULT 0
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloudflare_plans`
--

LOCK TABLES `cloudflare_plans` WRITE;
/*!40000 ALTER TABLE `cloudflare_plans` DISABLE KEYS */;
INSERT INTO `cloudflare_plans` (`addonid`, `pricingid`, `cf_auth_dns`, `plan_tag`, `defaulton`) VALUES (6,424,0,'',0),
(7,425,1,'',0);
/*!40000 ALTER TABLE `cloudflare_plans` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloudflare_ulog`
--

DROP TABLE IF EXISTS `cloudflare_ulog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloudflare_ulog` (
  `log_id` int(10) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `whmcs_id` int(10) DEFAULT NULL,
  `message` varchar(1000) DEFAULT NULL,
  PRIMARY KEY (`log_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloudflare_ulog`
--

LOCK TABLES `cloudflare_ulog` WRITE;
/*!40000 ALTER TABLE `cloudflare_ulog` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloudflare_ulog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cloudflare_zone`
--

DROP TABLE IF EXISTS `cloudflare_zone`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cloudflare_zone` (
  `whmcs_id` int(10) NOT NULL DEFAULT 0,
  `user_key` varchar(255) DEFAULT NULL,
  `active_zone` varchar(255) NOT NULL DEFAULT '',
  `nameservers` varchar(255) DEFAULT NULL,
  `plan_tag` varchar(255) DEFAULT NULL,
  `sub_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`whmcs_id`,`active_zone`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cloudflare_zone`
--

LOCK TABLES `cloudflare_zone` WRITE;
/*!40000 ALTER TABLE `cloudflare_zone` DISABLE KEYS */;
/*!40000 ALTER TABLE `cloudflare_zone` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpanel_extended_cloudlinux_options`
--

DROP TABLE IF EXISTS `cpanel_extended_cloudlinux_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cpanel_extended_cloudlinux_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rel_id` int(11) NOT NULL,
  `pmem` text DEFAULT NULL,
  `io` text DEFAULT NULL,
  `cpu` text DEFAULT NULL,
  `ep` text DEFAULT NULL,
  `nproc` text DEFAULT NULL,
  `php` text DEFAULT NULL,
  `show` text DEFAULT NULL,
  `ishow` text NOT NULL,
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpanel_extended_cloudlinux_options`
--

LOCK TABLES `cpanel_extended_cloudlinux_options` WRITE;
/*!40000 ALTER TABLE `cpanel_extended_cloudlinux_options` DISABLE KEYS */;
INSERT INTO `cpanel_extended_cloudlinux_options` (`id`, `rel_id`, `pmem`, `io`, `cpu`, `ep`, `nproc`, `php`, `show`, `ishow`) VALUES (1,27,'','','','','','','','');
/*!40000 ALTER TABLE `cpanel_extended_cloudlinux_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cpanel_extended_functions_settings`
--

DROP TABLE IF EXISTS `cpanel_extended_functions_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cpanel_extended_functions_settings` (
  `product_id` int(11) NOT NULL,
  `ftp` varchar(2) NOT NULL DEFAULT '',
  `emails` varchar(2) NOT NULL DEFAULT '',
  `emails_forwarders` varchar(2) NOT NULL DEFAULT '',
  `databases` varchar(2) NOT NULL DEFAULT '',
  `cron` varchar(2) NOT NULL DEFAULT '',
  `subdomains` varchar(2) NOT NULL DEFAULT '',
  `parked_domains` varchar(2) NOT NULL DEFAULT '',
  `addon_domains` varchar(2) NOT NULL DEFAULT '',
  `cpanel_login` varchar(2) NOT NULL DEFAULT '',
  `webmail_login` varchar(2) NOT NULL DEFAULT '',
  `change_password` varchar(2) NOT NULL DEFAULT '',
  `forward_domains` varchar(2) NOT NULL DEFAULT '',
  `install_app` varchar(2) NOT NULL DEFAULT '',
  `installer_type` int(1) NOT NULL DEFAULT 0,
  `app_name` text NOT NULL,
  `lang` varchar(10) NOT NULL DEFAULT '',
  `client_install_app` varchar(2) NOT NULL DEFAULT '',
  `apps_backups` varchar(2) NOT NULL DEFAULT '',
  `webalizer` varchar(2) NOT NULL DEFAULT '',
  `awstats` varchar(2) NOT NULL DEFAULT '',
  `analog` varchar(2) NOT NULL DEFAULT '',
  `lastvisitors` varchar(2) NOT NULL DEFAULT '',
  `phpmyadmin` varchar(2) NOT NULL DEFAULT '',
  `manage_ssl` varchar(2) NOT NULL DEFAULT '',
  `order_assign` int(1) NOT NULL DEFAULT 0,
  `config_option_gid` int(11) NOT NULL DEFAULT 0,
  `bans` varchar(2) NOT NULL DEFAULT '',
  `rvsitebuilderlogin` varchar(2) NOT NULL DEFAULT '',
  `automaticbackups` varchar(2) NOT NULL DEFAULT '',
  `backups` varchar(2) NOT NULL DEFAULT '',
  `fileslogin` varchar(2) NOT NULL DEFAULT '',
  `files` varchar(2) NOT NULL DEFAULT '',
  `ssh` varchar(2) NOT NULL DEFAULT '',
  `mx` varchar(2) NOT NULL DEFAULT '',
  `unbanonlogin` varchar(2) NOT NULL DEFAULT '',
  `cloudlinux` varchar(2) NOT NULL DEFAULT '',
  `skin` varchar(100) NOT NULL DEFAULT 'default',
  `phpVersion` varchar(2) NOT NULL DEFAULT '',
  `auto_apps_backups` varchar(2) NOT NULL DEFAULT '',
  `auto_apps_backups_default` varchar(2) NOT NULL DEFAULT '',
  PRIMARY KEY (`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cpanel_extended_functions_settings`
--

LOCK TABLES `cpanel_extended_functions_settings` WRITE;
/*!40000 ALTER TABLE `cpanel_extended_functions_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `cpanel_extended_functions_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jsonapi`
--

DROP TABLE IF EXISTS `jsonapi`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `jsonapi` (
  `jsid` int(11) NOT NULL AUTO_INCREMENT,
  `js_modulename` varchar(500) NOT NULL,
  `js_content` text NOT NULL,
  PRIMARY KEY (`jsid`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jsonapi`
--

LOCK TABLES `jsonapi` WRITE;
/*!40000 ALTER TABLE `jsonapi` DISABLE KEYS */;
/*!40000 ALTER TABLE `jsonapi` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mgfw_SSLCENTER_api_configuration`
--

DROP TABLE IF EXISTS `mgfw_SSLCENTER_api_configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mgfw_SSLCENTER_api_configuration` (
  `api_login` varchar(255) NOT NULL,
  `api_password` varchar(255) NOT NULL,
  `use_admin_contact` tinyint(1) NOT NULL,
  `display_csr_generator` tinyint(1) NOT NULL,
  `auto_renew_invoice_one_time` tinyint(1) NOT NULL,
  `auto_renew_invoice_reccuring` tinyint(1) NOT NULL,
  `send_expiration_notification_reccuring` tinyint(1) NOT NULL,
  `send_expiration_notification_one_time` tinyint(1) NOT NULL,
  `automatic_processing_of_renewal_orders` tinyint(1) NOT NULL,
  `tech_firstname` varchar(255) NOT NULL,
  `tech_lastname` varchar(255) NOT NULL,
  `tech_organization` varchar(255) NOT NULL,
  `tech_addressline1` varchar(255) NOT NULL,
  `tech_phone` varchar(255) NOT NULL,
  `tech_title` varchar(255) NOT NULL,
  `tech_email` varchar(255) NOT NULL,
  `tech_city` varchar(255) NOT NULL,
  `tech_country` varchar(255) NOT NULL,
  `tech_fax` varchar(255) NOT NULL,
  `tech_postalcode` varchar(255) NOT NULL,
  `tech_region` varchar(255) NOT NULL,
  `renew_invoice_days_reccuring` varchar(255) DEFAULT NULL,
  `renew_invoice_days_one_time` varchar(255) DEFAULT NULL,
  `default_csr_generator_country` varchar(255) DEFAULT NULL,
  `summary_expires_soon_days` varchar(255) DEFAULT NULL,
  `send_certificate_template` int(11) DEFAULT NULL,
  `display_ca_summary` tinyint(1) NOT NULL,
  `disable_email_validation` tinyint(1) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mgfw_SSLCENTER_api_configuration`
--

LOCK TABLES `mgfw_SSLCENTER_api_configuration` WRITE;
/*!40000 ALTER TABLE `mgfw_SSLCENTER_api_configuration` DISABLE KEYS */;
INSERT INTO `mgfw_SSLCENTER_api_configuration` (`api_login`, `api_password`, `use_admin_contact`, `display_csr_generator`, `auto_renew_invoice_one_time`, `auto_renew_invoice_reccuring`, `send_expiration_notification_reccuring`, `send_expiration_notification_one_time`, `automatic_processing_of_renewal_orders`, `tech_firstname`, `tech_lastname`, `tech_organization`, `tech_addressline1`, `tech_phone`, `tech_title`, `tech_email`, `tech_city`, `tech_country`, `tech_fax`, `tech_postalcode`, `tech_region`, `renew_invoice_days_reccuring`, `renew_invoice_days_one_time`, `default_csr_generator_country`, `summary_expires_soon_days`, `send_certificate_template`, `display_ca_summary`, `disable_email_validation`) VALUES ('hammedsadeghie@gmail.com','x8o9f2EGOWuD0m4',1,1,1,1,1,1,0,'hamed','sadeghi','IT','Tehran','9123952369','Support','hammedsaadeghie@gmail.com','tehran','AF','','','','90',NULL,'US','30',87,1,0);
/*!40000 ALTER TABLE `mgfw_SSLCENTER_api_configuration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mgfw_SSLCENTER_api_product_prices`
--

DROP TABLE IF EXISTS `mgfw_SSLCENTER_api_product_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mgfw_SSLCENTER_api_product_prices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `api_product_id` int(11) NOT NULL,
  `price` varchar(255) NOT NULL,
  `period` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mgfw_SSLCENTER_api_product_prices`
--

LOCK TABLES `mgfw_SSLCENTER_api_product_prices` WRITE;
/*!40000 ALTER TABLE `mgfw_SSLCENTER_api_product_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `mgfw_SSLCENTER_api_product_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mgfw_SSLCENTER_invoices_info`
--

DROP TABLE IF EXISTS `mgfw_SSLCENTER_invoices_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mgfw_SSLCENTER_invoices_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `invoice_id` int(10) unsigned NOT NULL,
  `service_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `order_id` int(10) unsigned NOT NULL,
  `new_service_id` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `new_service_id` (`new_service_id`,`order_id`),
  KEY `invoice_id` (`invoice_id`,`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mgfw_SSLCENTER_invoices_info`
--

LOCK TABLES `mgfw_SSLCENTER_invoices_info` WRITE;
/*!40000 ALTER TABLE `mgfw_SSLCENTER_invoices_info` DISABLE KEYS */;
INSERT INTO `mgfw_SSLCENTER_invoices_info` (`id`, `user_id`, `invoice_id`, `service_id`, `product_id`, `order_id`, `new_service_id`, `status`, `created_at`, `updated_at`) VALUES (1,1,4206,82,188,0,0,'','2019-02-05 10:40:27','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `mgfw_SSLCENTER_invoices_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mgfw_SSLCENTER_user_commission`
--

DROP TABLE IF EXISTS `mgfw_SSLCENTER_user_commission`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mgfw_SSLCENTER_user_commission` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `commission` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mgfw_SSLCENTER_user_commission`
--

LOCK TABLES `mgfw_SSLCENTER_user_commission` WRITE;
/*!40000 ALTER TABLE `mgfw_SSLCENTER_user_commission` DISABLE KEYS */;
/*!40000 ALTER TABLE `mgfw_SSLCENTER_user_commission` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mgfw_ggssl_invoices_info`
--

DROP TABLE IF EXISTS `mgfw_ggssl_invoices_info`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mgfw_ggssl_invoices_info` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `invoice_id` int(10) unsigned NOT NULL,
  `service_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `order_id` int(10) unsigned NOT NULL,
  `new_service_id` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `service_id` (`service_id`),
  KEY `new_service_id` (`new_service_id`,`order_id`),
  KEY `invoice_id` (`invoice_id`,`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mgfw_ggssl_invoices_info`
--

LOCK TABLES `mgfw_ggssl_invoices_info` WRITE;
/*!40000 ALTER TABLE `mgfw_ggssl_invoices_info` DISABLE KEYS */;
INSERT INTO `mgfw_ggssl_invoices_info` (`id`, `user_id`, `invoice_id`, `service_id`, `product_id`, `order_id`, `new_service_id`, `status`, `created_at`, `updated_at`) VALUES (1,1,4206,82,188,0,0,'','2019-02-05 10:40:27','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `mgfw_ggssl_invoices_info` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_ChangeMainDomain`
--

DROP TABLE IF EXISTS `mod_ChangeMainDomain`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_ChangeMainDomain` (
  `cmdid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cmd_old_domain` text NOT NULL,
  `cmd_new_domain` text NOT NULL,
  `cmd_datetime` text NOT NULL,
  `cmd_userip` text NOT NULL,
  PRIMARY KEY (`cmdid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_ChangeMainDomain`
--

LOCK TABLES `mod_ChangeMainDomain` WRITE;
/*!40000 ALTER TABLE `mod_ChangeMainDomain` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_ChangeMainDomain` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_CpanelChangeMainDomain`
--

DROP TABLE IF EXISTS `mod_CpanelChangeMainDomain`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_CpanelChangeMainDomain` (
  `cmdid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cmd_old_domain` text NOT NULL,
  `cmd_new_domain` text NOT NULL,
  `cmd_datetime` text NOT NULL,
  `cmd_status` text NOT NULL,
  `cmd_response` text NOT NULL,
  `cmd_serviceid` text NOT NULL,
  PRIMARY KEY (`cmdid`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_CpanelChangeMainDomain`
--

LOCK TABLES `mod_CpanelChangeMainDomain` WRITE;
/*!40000 ALTER TABLE `mod_CpanelChangeMainDomain` DISABLE KEYS */;
INSERT INTO `mod_CpanelChangeMainDomain` (`cmdid`, `cmd_old_domain`, `cmd_new_domain`, `cmd_datetime`, `cmd_status`, `cmd_response`, `cmd_serviceid`) VALUES (1,'irdnn.com','irdnn.ir','2020/05/27 16:42:43','1','Account Modified','78'),
(2,'irdnn.com','irdnn.ir','2020/05/27 16:45:29','1','Account Modified','78'),
(3,'irdnn.com','irdnn.ir','2020/05/27 16:47:10','1','Account Modified','78'),
(4,'irdnn.ir','irdnn.com','2020/05/28 08:54:06','1','Account Modified','78'),
(5,'irdnn.com','irdnn.ir','2020/06/04 13:49:33','1','Account Modified','78'),
(6,'btbinvestment.com','viratahlil.com','2020/10/26 13:12:43','1','Account Modified','130'),
(7,'rahe-saba.com','rahesaba.com','2022/01/30 09:25:52','0','(XID gnwvn3) The domain “rahesaba.com” already exists in the userdata. at /usr/local/cpanel/Whostmgr/Accounts/Modify.pm line 931.\n','145'),
(8,'rahe-saba.com','rahesaba.com','2022/01/30 15:02:31','0','(XID bkqt3k) The domain “rahesaba.com” already exists in the userdata. at /usr/local/cpanel/Whostmgr/Accounts/Modify.pm line 931.\n','145'),
(9,'rahe-saba.com','rahesaba.com','2022/01/30 15:03:50','1','Account Modified','145'),
(10,'farfallina.ir','mohammadlou.me','2022/03/02 09:16:48','1','Account Modified','146'),
(11,'portbaz.space','silverf.fun','2022/12/19 17:02:30','0','(XID mk8mz7) The domain “silverf.fun” already exists in the userdata. at /usr/local/cpanel/Whostmgr/Accounts/Modify.pm line 958.\n','326');
/*!40000 ALTER TABLE `mod_CpanelChangeMainDomain` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_CpanelResetHost`
--

DROP TABLE IF EXISTS `mod_CpanelResetHost`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_CpanelResetHost` (
  `crhid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `crh_command` text NOT NULL,
  `crh_response` text NOT NULL,
  `crh_datetime` text NOT NULL,
  `crh_status` text NOT NULL,
  `crh_serviceid` text NOT NULL,
  PRIMARY KEY (`crhid`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_CpanelResetHost`
--

LOCK TABLES `mod_CpanelResetHost` WRITE;
/*!40000 ALTER TABLE `mod_CpanelResetHost` DISABLE KEYS */;
INSERT INTO `mod_CpanelResetHost` (`crhid`, `crh_command`, `crh_response`, `crh_datetime`, `crh_status`, `crh_serviceid`) VALUES (1,'terminate','irdnn account removed','2020/05/28 11:25:14','1','78'),
(2,'create','irdnn account removed','2020/05/28 11:25:21','1','78'),
(3,'terminate','irdnn account removed','2020/05/28 11:29:18','1','78'),
(4,'create','Account Creation Ok','2020/05/28 11:29:26','1','78'),
(5,'terminate','weplancer account removed','2021/08/23 01:37:08','1','140'),
(6,'create','Account Creation Ok','2021/08/23 01:37:17','1','140'),
(7,'terminate','farfallina account removed','2022/03/02 02:10:51','1','146'),
(8,'create','Account Creation Ok','2022/03/02 02:11:02','1','146'),
(9,'terminate','farfallina account removed','2022/03/03 06:20:02','1','146'),
(10,'create','Account Creation Ok','2022/03/03 06:20:11','1','146'),
(11,'terminate','mytestse account removed','2022/08/25 12:40:01','1','169'),
(12,'create','Account Creation Ok','2022/08/25 12:40:08','1','169'),
(13,'terminate','chstudio account removed','2022/09/20 01:03:17','1','177'),
(14,'create','Account Creation Ok','2022/09/20 01:03:24','1','177'),
(15,'terminate','chstudio account removed','2022/09/20 01:38:51','1','177'),
(16,'create','Account Creation Ok','2022/09/20 01:38:58','1','177'),
(17,'terminate','silverff account removed','2022/12/21 15:02:15','1','325'),
(18,'create','Account Creation Ok','2022/12/21 15:02:25','1','325');
/*!40000 ALTER TABLE `mod_CpanelResetHost` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_CpanelWordpressInstallation`
--

DROP TABLE IF EXISTS `mod_CpanelWordpressInstallation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_CpanelWordpressInstallation` (
  `cwpid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cwp_domain` text NOT NULL,
  `cwp_datetime` text NOT NULL,
  `cwp_status` text NOT NULL,
  `cwp_response` text NOT NULL,
  `cwp_serviceid` text NOT NULL,
  `cwp-admin-username` text NOT NULL,
  `cwp-admin-email` text NOT NULL,
  `cwp-admin-pass` text NOT NULL,
  PRIMARY KEY (`cwpid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_CpanelWordpressInstallation`
--

LOCK TABLES `mod_CpanelWordpressInstallation` WRITE;
/*!40000 ALTER TABLE `mod_CpanelWordpressInstallation` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_CpanelWordpressInstallation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_PleskChangeMainDomain`
--

DROP TABLE IF EXISTS `mod_PleskChangeMainDomain`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_PleskChangeMainDomain` (
  `pcmdid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pcmd_old_domain` text NOT NULL,
  `pcmd_new_domain` text NOT NULL,
  `pcmd_datetime` text NOT NULL,
  `pcmd_status` text NOT NULL,
  `pcmd_response` text NOT NULL,
  `pcmd_serviceid` text NOT NULL,
  PRIMARY KEY (`pcmdid`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_PleskChangeMainDomain`
--

LOCK TABLES `mod_PleskChangeMainDomain` WRITE;
/*!40000 ALTER TABLE `mod_PleskChangeMainDomain` DISABLE KEYS */;
INSERT INTO `mod_PleskChangeMainDomain` (`pcmdid`, `pcmd_old_domain`, `pcmd_new_domain`, `pcmd_datetime`, `pcmd_status`, `pcmd_response`, `pcmd_serviceid`) VALUES (1,'maintest.org','maintest.','2020/05/31 15:55:06','1','','128'),
(2,'maintest.org','maintest.net','2020/05/31 15:56:07','0','SUCCESS: Update of domain \'maintest.org\' completed.','128'),
(3,'maintest.net','maintest.org','2020/05/31 15:56:50','0','SUCCESS: Update of domain \'maintest.net\' completed.','128'),
(4,'main2test.net','mainwebsite.net','2020/06/01 11:10:45','0','SUCCESS: Update of domain \'main2test.net\' completed.','129'),
(5,'maintest.org','mainwebsite.com','2020/06/14 15:54:56','4','','128'),
(6,'maintest.org','mainweb21site.com','2020/06/14 15:55:07','4','','128'),
(7,'maintest.org','mainweb21site.com','2020/06/14 15:56:25','0','SUCCESS: Update of domain \'maintest.org\' completed.','128'),
(8,'atiara.com','atiara.ir','2021/08/28 11:02:52','0','SUCCESS: Update of domain \'atiara.com\' completed.','148');
/*!40000 ALTER TABLE `mod_PleskChangeMainDomain` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_PleskResetHost`
--

DROP TABLE IF EXISTS `mod_PleskResetHost`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_PleskResetHost` (
  `prhid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `prh_command` text NOT NULL,
  `prh_response` text NOT NULL,
  `prh_datetime` text NOT NULL,
  `prh_status` text NOT NULL,
  `prh_serviceid` text NOT NULL,
  PRIMARY KEY (`prhid`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_PleskResetHost`
--

LOCK TABLES `mod_PleskResetHost` WRITE;
/*!40000 ALTER TABLE `mod_PleskResetHost` DISABLE KEYS */;
INSERT INTO `mod_PleskResetHost` (`prhid`, `prh_command`, `prh_response`, `prh_datetime`, `prh_status`, `prh_serviceid`) VALUES (40,'create','1','2020/06/14 15:55:28','1','128');
/*!40000 ALTER TABLE `mod_PleskResetHost` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_SmsAlert_messages`
--

DROP TABLE IF EXISTS `mod_SmsAlert_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_SmsAlert_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender` varchar(40) NOT NULL,
  `to` varchar(15) DEFAULT NULL,
  `text` text DEFAULT NULL,
  `phid` varchar(50) DEFAULT NULL,
  `status` varchar(100) DEFAULT NULL,
  `errors` text DEFAULT NULL,
  `logs` text DEFAULT NULL,
  `user` int(11) DEFAULT NULL,
  `datetime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_SmsAlert_messages`
--

LOCK TABLES `mod_SmsAlert_messages` WRITE;
/*!40000 ALTER TABLE `mod_SmsAlert_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_SmsAlert_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_SmsAlert_otp`
--

DROP TABLE IF EXISTS `mod_SmsAlert_otp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_SmsAlert_otp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(11) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `phone` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `verify` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_SmsAlert_otp`
--

LOCK TABLES `mod_SmsAlert_otp` WRITE;
/*!40000 ALTER TABLE `mod_SmsAlert_otp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_SmsAlert_otp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_SmsAlert_settings`
--

DROP TABLE IF EXISTS `mod_SmsAlert_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_SmsAlert_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `apiparams` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `wantsmsfield` int(11) DEFAULT NULL,
  `gsmnumberfield` int(11) DEFAULT NULL,
  `resend_time` int(5) DEFAULT NULL,
  `dateformat` varchar(12) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `version` varchar(6) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_SmsAlert_settings`
--

LOCK TABLES `mod_SmsAlert_settings` WRITE;
/*!40000 ALTER TABLE `mod_SmsAlert_settings` DISABLE KEYS */;
INSERT INTO `mod_SmsAlert_settings` (`id`, `api`, `apiparams`, `wantsmsfield`, `gsmnumberfield`, `resend_time`, `dateformat`, `version`) VALUES (1,'sms','{\"senderid\":\"\",\"signature\":\"\",\"country_code\":\"\"}',0,0,15,'%d.%m.%y','1.1.3');
/*!40000 ALTER TABLE `mod_SmsAlert_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_SmsAlert_templates`
--

DROP TABLE IF EXISTS `mod_SmsAlert_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_SmsAlert_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `type` enum('client','admin') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `admingsm` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `template` varchar(240) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `variables` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `extra` varchar(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_SmsAlert_templates`
--

LOCK TABLES `mod_SmsAlert_templates` WRITE;
/*!40000 ALTER TABLE `mod_SmsAlert_templates` DISABLE KEYS */;
INSERT INTO `mod_SmsAlert_templates` (`id`, `name`, `type`, `admingsm`, `template`, `variables`, `active`, `extra`, `description`) VALUES (1,'AfterRegistrarRegistrationFailed_admin','admin','','An error occurred while recording the domain {domain}.','{domain}',1,'','{\"english\":\"When client login.\"}'),
(2,'AfterRegistrarRenewal','client','','Dear {firstname} {lastname},Your domain {domain} is successfully renewed.','{firstname},{lastname},{domain}',1,'','{\"english\":\"After domain renewal\"}'),
(3,'AfterRegistrarRenewalFailed_admin','admin','','An error occurred while updating the domain {domain}.','{domain}',1,'','{\"english\":\"When domain registration failed.\"}'),
(4,'ClientAdd','client','','Hi {firstname}{lastname}, Thank you for registering with us.','{firstname},{lastname},{email}',1,'','{\"english\":\"After Client Registration\"}'),
(5,'TicketOpen_admin','admin','','A new ticket #{ticketno} with the subject {subject} has been created.','{subject},{ticketno}',1,'','{\"english\":\"When new ticket is created.\"}'),
(6,'ClientLogin_admin','admin','','Client with the name- {firstname} {lastname} made entrance to the site.','{firstname},{lastname}',1,'','{\"english\":\"When client login.\"}'),
(7,'ClientAdd_admin','admin','','New customer has been added to the website.','',1,'','{\"english\":\"When client is added.\"}'),
(8,'InvoicePaymentReminder_Reminder','client','','Hi {firstname} {lastname},for invoice with id {invoiceid},The due date for the payment is {duedate}.Kindly make the payment for uninterrupted services.','{firstname},{lastname},{duedate},{invoiceid}',1,'','{\"english\":\"Invoice Payment Reminder\"}'),
(9,'AfterModuleChangePassword','client','','Hi {firstname} {lastname},password for the {domain} has been changed successfully.Here are the details- Username: {username} Password: {password}.','{firstname},{lastname},{domain},{username},{password}',1,'','{\"english\":\"After module password changed\"}'),
(10,'TicketAdminReply','client','','Dear {firstname} {lastname},{ticketsubject} has been responded by admin.','{firstname},{lastname},{ticketsubject}',1,'','{\"english\":\"After Reply By Admin\"}'),
(11,'AfterModuleSuspend','client','','Hi {firstname} {lastname},The service for your account associated with the domain {domain} has been paused.Kindly contact us for more details.','{firstname},{lastname},{domain}',1,'','{\"english\":\"After Module Suspension\"}'),
(12,'DomainRenewalNotice','client','','Hi {firstname} {lastname},your domain- {domain} will expire in {x} days i.e. on {expirydate}.Kindly visit site to renew it.Thank You!.','{firstname},{lastname},{domain},{expirydate},{x}',1,'15','{\"english\":\"Domain Renewal Notice before {x} days.\"}'),
(13,'AfterRegistrarRegistration_admin','admin','','New domain named {domain} have been registered.','{domain}',1,'','{\"english\":\"When domain registered.\"}'),
(14,'UserChangePassword','client','','Hi {firstname} {lastname},password has been changed successfully.','{firstname},{lastname},{password}',1,'','{\"english\":\"After client change password\"}'),
(15,'InvoicePaid','client','','Dear {firstname} {lastname},payment for invoice with id {invoiceid} is done! Thank you.','{firstname},{lastname},{duedate},{invoiceid}',1,'','{\"english\":\"Post Payment\"}'),
(16,'AfterModuleUnsuspend','client','','Hello! The services for the domain {domain} have now been made active.','{firstname},{lastname},{domain}',1,'','{\"english\":\"After module unsuspend\"}'),
(17,'InvoicePaymentReminder_secondoverdue','client','','Hi {firstname} {lastname},the payment for invoice with id {invoiceid},associated with your is due.Kindly make the payment at the earliest to enjoy the services.','{firstname}, {lastname}, {duedate}, {invoiceid}',1,'','{\"english\":\"Invoice payment reminder for second overdue\"}'),
(18,'TicketUserReply_admin','admin','','User has replied on the ticket #{ticketno} with the subject {subject}.','{subject},{ticketno}',1,'','{\"english\":\"When user has replied on the ticket.\"}'),
(19,'ClientEdit_clientarea','client','','Dear {firstname} {lastname},your profile has been updated.','{firstname},{lastname}',1,'','{\"english\":\"After Client Edit (OTP) Mobile Verification\"}'),
(20,'AfterRegistrarRegistrationFailed','client','','Hi {firstname} {lastname},Your domain name {domain} could not be registered.','{firstname},{lastname},{domain}',1,'','{\"english\":\"Domain Registration Failure\"}'),
(21,'AcceptOrder_SMS','client','','Dear {firstname} {lastname},Your order associated with the ID #{orderid} has been approved.','{firstname},{lastname},{orderid}',1,'','{\"english\":\"Post Order Acceptance\"}'),
(22,'AfterRegistrarRenewal_admin','admin','','The domain name {domain} has been renewed.','{domain}',1,'','{\"english\":\"When domain is renewed.\"}'),
(23,'TicketClose','client','','Hello {firstname} {lastname},The ticket with the ticket number #{ticketno} has been successfully closed.In case of any issue,kindly contact us.','{firstname},{lastname},{ticketno}',1,'','{\"english\":\"Ticket Closure\"}'),
(24,'InvoicePaymentReminder_Firstoverdue','client','','Hi {firstname} {lastname},the payment associated with your account with date {duedate} is not done yet for invoice {invoiceid}. Kindly make the payment at the earliest to enjoy the services.','{firstname},{lastname},{duedate},{invoiceid}',1,'','{\"english\":\"Invoice payment reminder for first overdue\"}'),
(25,'AfterRegistrarRegistration','client','','Hi {firstname} {lastname},Entries in the name field for the domain name {domain} have been successfully made.','{firstname},{lastname},{domain}',1,'','{\"english\":\"After Domain Registration\"}'),
(26,'InvoiceCreated','client','','Hello {firstname} {lastname}, Your invoice with id {invoiceid} has been generated.Total amount is  {total}.The last day of payment is {duedate}.Kindly pay your bill before due date to use services without interruption.','{firstname},{lastname},{duedate},{total},{invoiceid}',1,'','{\"english\":\"After Invoice Creation\"}'),
(27,'AdminLogin_admin','admin','','A user with the username {username} has entered the admin panel.','{username}',1,'','null'),
(28,'AfterModuleChangePackage','client','','Hello {firstname} {lastname},The product/service package for your domain {domain} is changed.Kindly contact us for more details.','{firstname},{lastname},{domain}',1,'','{\"english\":\"Following Module Package Change\"}'),
(29,'InvoicePaymentReminder_thirdoverdue','client','','Hi {firstname} {lastname},the payment for date {duedate},associated with your is due for invoice {invoiceid}. Kindly make the payment at the earliest to enjoy the services.','{firstname}, {lastname}, {duedate},{invoiceid}',1,'','{\"english\":\"Invoice payment reminder for third overdue\"}'),
(30,'AfterModuleCreate_Hosting','client','','Hello! The services for the domain {domain} have now been made active.The login details for the accounts are- Username:{username} Password: {password}.','{firstname},{lastname},{domain},{username},{password}',1,'','{\"english\":\"Post Service Activation\"}'),
(31,'ClientAreaRegister_clientarea','client','','Dear {firstname} {lastname}, OTP generated for your mobile phone verification is {otp}.','{firstname},{lastname},{otp}',1,'','{\"english\":\"After Client Registration (OTP) Mobile Verification\"}');
/*!40000 ALTER TABLE `mod_SmsAlert_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_configserver_settings`
--

DROP TABLE IF EXISTS `mod_configserver_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_configserver_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `change_ip_price` decimal(16,4) NOT NULL,
  `expire_licenses_after` int(11) NOT NULL DEFAULT 7,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_configserver_settings`
--

LOCK TABLES `mod_configserver_settings` WRITE;
/*!40000 ALTER TABLE `mod_configserver_settings` DISABLE KEYS */;
INSERT INTO `mod_configserver_settings` (`id`, `change_ip_price`, `expire_licenses_after`) VALUES (1,900000.0000,7);
/*!40000 ALTER TABLE `mod_configserver_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_csfmanager_allow`
--

DROP TABLE IF EXISTS `mod_csfmanager_allow`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_csfmanager_allow` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `clientid` int(11) unsigned NOT NULL DEFAULT 0,
  `serverid` int(11) unsigned NOT NULL DEFAULT 0,
  `ip` varchar(255) NOT NULL,
  `time` int(11) unsigned NOT NULL DEFAULT 0,
  `expiration` int(11) unsigned NOT NULL DEFAULT 0,
  `reason` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_csfmanager_allow`
--

LOCK TABLES `mod_csfmanager_allow` WRITE;
/*!40000 ALTER TABLE `mod_csfmanager_allow` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_csfmanager_allow` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_csfmanager_allow_keys`
--

DROP TABLE IF EXISTS `mod_csfmanager_allow_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_csfmanager_allow_keys` (
  `key_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `server_id` int(11) unsigned NOT NULL DEFAULT 0,
  `product_id` int(11) unsigned NOT NULL DEFAULT 0,
  `key_hash` varchar(40) NOT NULL,
  `key_email` varchar(255) NOT NULL,
  `key_recipient` varchar(255) NOT NULL,
  `key_clicks_remained` int(11) unsigned NOT NULL DEFAULT 0,
  `key_expire` int(11) unsigned NOT NULL DEFAULT 0,
  `key_cancelled` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`key_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_csfmanager_allow_keys`
--

LOCK TABLES `mod_csfmanager_allow_keys` WRITE;
/*!40000 ALTER TABLE `mod_csfmanager_allow_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_csfmanager_allow_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_csfmanager_config`
--

DROP TABLE IF EXISTS `mod_csfmanager_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_csfmanager_config` (
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_csfmanager_config`
--

LOCK TABLES `mod_csfmanager_config` WRITE;
/*!40000 ALTER TABLE `mod_csfmanager_config` DISABLE KEYS */;
INSERT INTO `mod_csfmanager_config` (`name`, `value`) VALUES ('permission_firewall','0'),
('permission_unblock','1'),
('permission_allow','0'),
('permission_allowemail','0'),
('permission_aunblock','1'),
('allowlength','7'),
('allowlength_type','days'),
('checkbrute','1'),
('version_check','1603111477'),
('version_new','1.0'),
('servers','2,3');
/*!40000 ALTER TABLE `mod_csfmanager_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_faraso_reseller`
--

DROP TABLE IF EXISTS `mod_faraso_reseller`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_faraso_reseller` (
  `serviceid` int(10) unsigned NOT NULL,
  `farasosid` int(10) unsigned NOT NULL,
  PRIMARY KEY (`serviceid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_faraso_reseller`
--

LOCK TABLES `mod_faraso_reseller` WRITE;
/*!40000 ALTER TABLE `mod_faraso_reseller` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_faraso_reseller` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_hcloud_config`
--

DROP TABLE IF EXISTS `mod_hcloud_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_hcloud_config` (
  `setting` text NOT NULL,
  `value` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_hcloud_config`
--

LOCK TABLES `mod_hcloud_config` WRITE;
/*!40000 ALTER TABLE `mod_hcloud_config` DISABLE KEYS */;
INSERT INTO `mod_hcloud_config` (`setting`, `value`) VALUES ('deldb',''),
('defaultrdns','de.cloud.keloncloud.com'),
('adminstall','on'),
('admrescue','on'),
('admiso','on'),
('admbw','on'),
('admhostupdate','on'),
('admprimary','on'),
('admfloating',''),
('admbackup',''),
('admvolume',''),
('snapshots','on'),
('runcmd',''),
('autosuspend','on');
/*!40000 ALTER TABLE `mod_hcloud_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_hcloud_project`
--

DROP TABLE IF EXISTS `mod_hcloud_project`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_hcloud_project` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `projectname` text NOT NULL,
  `projectapikey` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_hcloud_project`
--

LOCK TABLES `mod_hcloud_project` WRITE;
/*!40000 ALTER TABLE `mod_hcloud_project` DISABLE KEYS */;
INSERT INTO `mod_hcloud_project` (`id`, `projectname`, `projectapikey`) VALUES (1,'site','4OeaxKQilvMApAYmbEYBlQXTlQwfWlauC0IqZndCOPSeooV2p3PIKbMDzrB5GoOh');
/*!40000 ALTER TABLE `mod_hcloud_project` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_hcloud_server`
--

DROP TABLE IF EXISTS `mod_hcloud_server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_hcloud_server` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hcloudid` text NOT NULL,
  `hcloudrescue` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_hcloud_server`
--

LOCK TABLES `mod_hcloud_server` WRITE;
/*!40000 ALTER TABLE `mod_hcloud_server` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_hcloud_server` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_hetzner_account`
--

DROP TABLE IF EXISTS `mod_hetzner_account`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_hetzner_account` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `webname` text NOT NULL,
  `webuser` text NOT NULL,
  `webpass` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_hetzner_account`
--

LOCK TABLES `mod_hetzner_account` WRITE;
/*!40000 ALTER TABLE `mod_hetzner_account` DISABLE KEYS */;
INSERT INTO `mod_hetzner_account` (`id`, `webname`, `webuser`, `webpass`) VALUES (1,'MyCluster','VDQ3S1ZreDAwdW1yMDhrSTFCc3RhUT09','Q3ByL1plY2p0VHlBM2Y1ZDJ0NzhlVmdzb1p6VDhmQmsrMmVVYVRtQmhHTT0=');
/*!40000 ALTER TABLE `mod_hetzner_account` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_hetzner_config`
--

DROP TABLE IF EXISTS `mod_hetzner_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_hetzner_config` (
  `setting` text NOT NULL,
  `value` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_hetzner_config`
--

LOCK TABLES `mod_hetzner_config` WRITE;
/*!40000 ALTER TABLE `mod_hetzner_config` DISABLE KEYS */;
INSERT INTO `mod_hetzner_config` (`setting`, `value`) VALUES ('deldb',''),
('delemail',''),
('reboot',''),
('cpanel','on'),
('plesk','on'),
('rescue',''),
('linux',''),
('vnc',''),
('windows','on'),
('wol',''),
('rdns',''),
('srvpurchange','on'),
('cronemail','on'),
('prodoutofstuck',''),
('whmcsmodule_prodpercent',''),
('whmcsproductname',''),
('marketview',''),
('productids','N;'),
('prodimport',''),
('prodminval',''),
('prodmaxval',''),
('prodnoofsrv',''),
('projaccid',''),
('setupfees','');
/*!40000 ALTER TABLE `mod_hetzner_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_hetzner_cron`
--

DROP TABLE IF EXISTS `mod_hetzner_cron`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_hetzner_cron` (
  `id` int(11) NOT NULL,
  `hdate` text NOT NULL,
  `htime` text NOT NULL,
  `hstatus` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_hetzner_cron`
--

LOCK TABLES `mod_hetzner_cron` WRITE;
/*!40000 ALTER TABLE `mod_hetzner_cron` DISABLE KEYS */;
INSERT INTO `mod_hetzner_cron` (`id`, `hdate`, `htime`, `hstatus`) VALUES (1,'','','');
/*!40000 ALTER TABLE `mod_hetzner_cron` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_hetzner_order`
--

DROP TABLE IF EXISTS `mod_hetzner_order`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_hetzner_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `serviceid` text NOT NULL,
  `userid` text NOT NULL,
  `orderid` text NOT NULL,
  `status` text NOT NULL,
  `accountid` text NOT NULL,
  `producttype` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_hetzner_order`
--

LOCK TABLES `mod_hetzner_order` WRITE;
/*!40000 ALTER TABLE `mod_hetzner_order` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_hetzner_order` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_hetzner_server`
--

DROP TABLE IF EXISTS `mod_hetzner_server`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_hetzner_server` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hetznerip` text NOT NULL,
  `hetznerrescue` text NOT NULL,
  `hetznerosname` text NOT NULL,
  `hetzneros` text NOT NULL,
  `hetznerwindows` text NOT NULL,
  `hetznervnc` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_hetzner_server`
--

LOCK TABLES `mod_hetzner_server` WRITE;
/*!40000 ALTER TABLE `mod_hetzner_server` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_hetzner_server` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_hostcontrol_domain`
--

DROP TABLE IF EXISTS `mod_hostcontrol_domain`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_hostcontrol_domain` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `domain_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `remote_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_hostcontrol_domain`
--

LOCK TABLES `mod_hostcontrol_domain` WRITE;
/*!40000 ALTER TABLE `mod_hostcontrol_domain` DISABLE KEYS */;
INSERT INTO `mod_hostcontrol_domain` (`id`, `type`, `domain_id`, `user_id`, `remote_id`) VALUES (1,'customer',NULL,7,963970),
(2,'transfer',2,NULL,83386),
(3,'transfer',1,NULL,83388),
(4,'customer',NULL,10,992095),
(5,'transfer',4,NULL,92672),
(6,'customer',NULL,1,993045),
(7,'transfer',9,NULL,97600);
/*!40000 ALTER TABLE `mod_hostcontrol_domain` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_invoicedata`
--

DROP TABLE IF EXISTS `mod_invoicedata`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_invoicedata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoiceid` int(10) NOT NULL,
  `clientsdetails` text NOT NULL,
  `customfields` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_invoicedata`
--

LOCK TABLES `mod_invoicedata` WRITE;
/*!40000 ALTER TABLE `mod_invoicedata` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_invoicedata` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_ippanelsms_login_otp`
--

DROP TABLE IF EXISTS `mod_ippanelsms_login_otp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_ippanelsms_login_otp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mobile` text NOT NULL,
  `otp` varchar(50) NOT NULL,
  `relid` int(10) NOT NULL DEFAULT 0,
  `request` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT 0,
  `timestamp` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_ippanelsms_login_otp`
--

LOCK TABLES `mod_ippanelsms_login_otp` WRITE;
/*!40000 ALTER TABLE `mod_ippanelsms_login_otp` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_ippanelsms_login_otp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_ippanelsms_messages`
--

DROP TABLE IF EXISTS `mod_ippanelsms_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_ippanelsms_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender` varchar(40) NOT NULL,
  `to` varchar(15) DEFAULT NULL,
  `text` text DEFAULT NULL,
  `msgid` varchar(50) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `errors` text DEFAULT NULL,
  `logs` text DEFAULT NULL,
  `user` int(11) DEFAULT NULL,
  `datetime` datetime NOT NULL,
  `position` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_ippanelsms_messages`
--

LOCK TABLES `mod_ippanelsms_messages` WRITE;
/*!40000 ALTER TABLE `mod_ippanelsms_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_ippanelsms_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_ippanelsms_otp`
--

DROP TABLE IF EXISTS `mod_ippanelsms_otp`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_ippanelsms_otp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `otp` varchar(50) NOT NULL,
  `type` enum('client','admin') DEFAULT 'client',
  `relid` int(10) DEFAULT 0,
  `request` varchar(50) NOT NULL,
  `text` text DEFAULT NULL,
  `status` tinyint(1) DEFAULT 0,
  `datetime` datetime NOT NULL,
  `phonenumber` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=275 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_ippanelsms_otp`
--

LOCK TABLES `mod_ippanelsms_otp` WRITE;
/*!40000 ALTER TABLE `mod_ippanelsms_otp` DISABLE KEYS */;
INSERT INTO `mod_ippanelsms_otp` (`id`, `otp`, `type`, `relid`, `request`, `text`, `status`, `datetime`, `phonenumber`) VALUES (1,'316347','client',49,'284aMwVSyn3CWjq0p9JH','مشتری گرامی علی امیراحمدی, کد تأیید شماره همراه شما: 316347',1,'2022-09-07 00:16:24','09124931609'),
(2,'403412','client',49,'xQEtQiAuBWmUFOsLBwz8','مشتری گرامی علی امیراحمدی, کد تأیید شماره همراه شما: 403412',1,'2022-09-07 00:16:24','09124931609'),
(3,'145271','client',50,'QEvIFAPBeikWsHMXJNws','مشتری گرامی حمیدرضا ممشلی, کد تأیید شماره همراه شما: 145271',1,'2022-09-10 19:24:25','09359923631'),
(4,'618963','client',50,'AJlP0OoixJ3nSzRav9NR','مشتری گرامی حمیدرضا ممشلی, کد تأیید شماره همراه شما: 618963',1,'2022-09-10 19:24:26','09359923631'),
(5,'236934','client',52,'Ci40BKE3pbt4VnoOxo70','مشتری گرامی سینا آقاسی, کد تأیید شماره همراه شما: 236934',1,'2022-09-14 00:17:25','09369204423'),
(6,'276502','client',52,'xrDuafdGzpKPWaoje8iX','مشتری گرامی سینا آقاسی, کد تأیید شماره همراه شما: 276502',1,'2022-09-14 00:17:25','09369204423'),
(8,'24339','client',43,'VHKESOcXg8XWXg29s4An','مشتری گرامی hamed sadeghi, کد تأیید شماره همراه شما: 24339 برای درخواست # VHKESOcXg8XWXg29s4An.',1,'2022-09-18 12:06:48','09123952369'),
(9,'682293','client',53,'5fJRzfWHR3MiYz6xrKYC','مشتری گرامی یزدان زرخواه, کد تأیید شماره همراه شما: 682293',1,'2022-09-19 14:41:33','09123399076'),
(10,'041596','client',53,'E07bmjMgC0iDA4TOLarA','مشتری گرامی یزدان زرخواه, کد تأیید شماره همراه شما: 041596',1,'2022-09-19 14:41:34','09123399076'),
(11,'035836','client',56,'GgGxYueihd7seizlZMhH','مشتری گرامی امیر حسین حبیبی نژاد, کد تأیید شماره همراه شما: 035836',1,'2022-09-30 22:35:08','09196411626'),
(12,'544750','client',56,'Op0di9TJeNzDCkEUqiqp','مشتری گرامی امیر حسین حبیبی نژاد, کد تأیید شماره همراه شما: 544750',1,'2022-09-30 22:35:09','09196411626'),
(13,'928248','client',57,'UKAVbn99gmOfTKWkN2Uy','مشتری گرامی فرزام حبیبی, کد تأیید شماره همراه شما: 928248',1,'2022-10-05 14:02:29','09123866891'),
(14,'162236','client',57,'GCPMuC2xZRK0brexANx5','مشتری گرامی فرزام حبیبی, کد تأیید شماره همراه شما: 162236',1,'2022-10-05 14:02:30','09123866891'),
(15,'790898','client',58,'vHl9MKGsXosT7pf46Ct2','مشتری گرامی Moe Khavyani, کد تأیید شماره همراه شما: 790898',1,'2022-10-05 16:29:21','09125545413'),
(16,'863324','client',58,'Shp6tkweoElnmcuQJPHI','مشتری گرامی Moe Khavyani, کد تأیید شماره همراه شما: 863324',1,'2022-10-05 16:29:22','09125545413'),
(17,'504263','client',59,'Dnriyc2PY12V0fIxKPAC','مشتری گرامی Saber Amiri, کد تأیید شماره همراه شما: 504263',1,'2022-10-13 23:27:12','09362768686'),
(18,'478371','client',59,'qNicI3Hw20mjPWZzUT80','مشتری گرامی Saber Amiri, کد تأیید شماره همراه شما: 478371',1,'2022-10-13 23:27:13','09362768686'),
(19,'706126','client',60,'1lQonmLGCSWErZ5LQGUO','مشتری گرامی محمد نبی نوری, کد تأیید شماره همراه شما: 706126',1,'2022-10-15 11:47:02','09228492709'),
(20,'313874','client',60,'GoJj3A9YcM5H0TgR4q9h','مشتری گرامی محمد نبی نوری, کد تأیید شماره همراه شما: 313874',1,'2022-10-15 11:47:05','09228492709'),
(21,'808776','client',61,'2CNBjFJjZnEVNUPdaHYP','مشتری گرامی هادی حسینی, کد تأیید شماره همراه شما: 808776',1,'2022-10-15 22:32:30','09124868648'),
(22,'076306','client',61,'iOMzeg4ZtMcn2PIsmvpc','مشتری گرامی هادی حسینی, کد تأیید شماره همراه شما: 076306',1,'2022-10-15 22:32:36','09124868648'),
(23,'548370','client',62,'CmCuzlpEJRRzW3nrlmfs','مشتری گرامی بهادر درزاده, کد تأیید شماره همراه شما: 548370',1,'2022-10-17 18:20:44','09940725790'),
(24,'448183','client',62,'6f2pSicnvQJoF8gQ6Iht','مشتری گرامی بهادر درزاده, کد تأیید شماره همراه شما: 448183',1,'2022-10-17 18:20:45','09940725790'),
(25,'146690','client',63,'JXegtI4X7nziQJh9jfK1','مشتری گرامی مصطفی زنگنه, کد تأیید شماره همراه شما: 146690',1,'2022-10-19 00:53:15','09388739168'),
(26,'546510','client',63,'JSg38HRotB25jlNWCoTJ','مشتری گرامی مصطفی زنگنه, کد تأیید شماره همراه شما: 546510',1,'2022-10-19 00:53:17','09388739168'),
(27,'177694','client',64,'U5UIC3B77hZ0wywppi98','مشتری گرامی سالار کاشانی, کد تأیید شماره همراه شما: 177694',1,'2022-10-21 16:04:36','09121216749'),
(28,'467351','client',64,'SVLQaM98oysh192Weobv','مشتری گرامی سالار کاشانی, کد تأیید شماره همراه شما: 467351',1,'2022-10-21 16:04:37','09121216749'),
(29,'564912','client',66,'sfgNswJOmF7hs4qKTJvD','مشتری گرامی محمود کریمی, کد تأیید شماره همراه شما: 564912',1,'2022-10-23 22:44:14','09388698064'),
(30,'308070','client',66,'Pzxd7tlBtN9uPOdJD0ur','مشتری گرامی محمود کریمی, کد تأیید شماره همراه شما: 308070',1,'2022-10-23 22:44:16','09388698064'),
(31,'150245','client',70,'74r1uucq940o8blh9rtE','مشتری گرامی mob baran, کد تأیید شماره همراه شما: 150245',1,'2022-10-30 12:15:00','09388698064'),
(32,'271162','client',70,'uNig7p6o7g7FNBROTQZP','مشتری گرامی mob baran, کد تأیید شماره همراه شما: 271162',1,'2022-10-30 12:15:03','09388698064'),
(33,'812886','client',71,'vJeBiGioeq4CTTLuw7WG','مشتری گرامی اشکان آقاسی, کد تأیید شماره همراه شما: 812886',1,'2022-10-30 14:23:51','09122654620'),
(34,'771435','client',71,'C0TzgEAaP3O6yUhXz11G','مشتری گرامی اشکان آقاسی, کد تأیید شماره همراه شما: 771435',1,'2022-10-30 14:23:52','09122654620'),
(35,'099583','client',75,'MrJTKpfmtsZAybUSMlkR','مشتری گرامی محمد  بالی مقدس, کد تأیید شماره همراه شما: 099583',1,'2022-11-06 21:38:59','09366155242'),
(36,'479330','client',75,'ELz89XtqJywXSBr0QNBk','مشتری گرامی محمد  بالی مقدس, کد تأیید شماره همراه شما: 479330',1,'2022-11-06 21:38:59','09366155242'),
(37,'590005','client',76,'twUDAmBQOLxnoR1FR8lD','مشتری گرامی سیدمیلاد هاشمی, کد تأیید شماره همراه شما: 590005',1,'2022-11-09 00:43:04','09138509973'),
(38,'469635','client',76,'nyfnI1mqc3nCEgPmyC92','مشتری گرامی سیدمیلاد هاشمی, کد تأیید شماره همراه شما: 469635',1,'2022-11-09 00:43:05','09138509973'),
(39,'929990','client',77,'q1ztNRoNgCoAn90PuG5w','مشتری گرامی وحید اسماعیلی, کد تأیید شماره همراه شما: 929990',1,'2022-11-09 11:05:39','09369915909'),
(40,'978173','client',77,'6X4h0HVrHhQhRONgCJfg','مشتری گرامی وحید اسماعیلی, کد تأیید شماره همراه شما: 978173',1,'2022-11-09 11:05:41','09369915909'),
(41,'310491','client',78,'r1qgqZ17xSF4F4qeXRpI','مشتری گرامی Frank  Shelby, کد تأیید شماره همراه شما: 310491',1,'2022-11-09 16:34:15','09300136077'),
(42,'988287','client',78,'6Dsa19IE1TgQAB59g4cf','مشتری گرامی Frank  Shelby, کد تأیید شماره همراه شما: 988287',1,'2022-11-09 16:34:16','09300136077'),
(43,'536880','client',79,'F4OuBpzio7N5MJalsWeS','مشتری گرامی شروین حسنی, کد تأیید شماره همراه شما: 536880',1,'2022-11-09 18:12:22','09359347626'),
(44,'569903','client',79,'QGaeSlS3sumJpkjZV5jP','مشتری گرامی شروین حسنی, کد تأیید شماره همراه شما: 569903',1,'2022-11-09 18:12:23','09359347626'),
(45,'135269','client',82,'87F5Wp8koegpOHAY86B6','مشتری گرامی امیرحسین استادملک, کد تأیید شماره همراه شما: 135269',1,'2022-11-10 16:08:27','09197170836'),
(46,'567359','client',82,'Rah8acQrz2JjOZceqG2N','مشتری گرامی امیرحسین استادملک, کد تأیید شماره همراه شما: 567359',1,'2022-11-10 16:08:27','09197170836'),
(47,'795760','client',84,'cAlKDqyH9BMUPJ1Lcajr','مشتری گرامی ali sohrabi, کد تأیید شماره همراه شما: 795760',1,'2022-11-11 11:02:51','09368279106'),
(48,'883682','client',84,'tLUt6BC9D8Af45lP4ujk','مشتری گرامی ali sohrabi, کد تأیید شماره همراه شما: 883682',1,'2022-11-11 11:02:51','09368279106'),
(49,'242385','client',85,'V6uBcpsLhMeHXWbkTfzt','مشتری گرامی بابک قزوینیان زنجانی, کد تأیید شماره همراه شما: 242385',1,'2022-11-11 21:04:15','۰۹۰۲۲۲۸۰۶۰۱'),
(50,'727752','client',85,'LXJPqCaJjovKzNBi5xlW','مشتری گرامی بابک قزوینیان زنجانی, کد تأیید شماره همراه شما: 727752',1,'2022-11-11 21:04:16','۰۹۰۲۲۲۸۰۶۰۱'),
(51,'200030','client',87,'ZcjhsDCFLt8OXqEOZN8n','مشتری گرامی لقمان قربانی پور, کد تأیید شماره همراه شما: 200030',1,'2022-11-12 19:07:20','09359170682'),
(52,'563222','client',87,'JdiViwFJlg3WKEgU8Zkz','مشتری گرامی لقمان قربانی پور, کد تأیید شماره همراه شما: 563222',1,'2022-11-12 19:07:21','09359170682'),
(53,'550777','client',89,'py0Rrrs9YWIGYBmD2ylA','مشتری گرامی شایان رضاپور نیکرو, کد تأیید شماره همراه شما: 550777',1,'2022-11-15 15:12:10','09123158391'),
(54,'237588','client',89,'B483fvAanytbIJub3kM7','مشتری گرامی شایان رضاپور نیکرو, کد تأیید شماره همراه شما: 237588',1,'2022-11-15 15:12:11','09123158391'),
(55,'583587','client',91,'4qxFZ9BG9ogQfURcavpR','مشتری گرامی امیر کامکار, کد تأیید شماره همراه شما: 583587',1,'2022-11-16 13:39:52','09124101860'),
(56,'526200','client',91,'CqCBlmU5gP2dInoZ2tWR','مشتری گرامی امیر کامکار, کد تأیید شماره همراه شما: 526200',1,'2022-11-16 13:39:53','09124101860'),
(57,'700428','client',92,'me10OxGKMd8u30JiUsDh','مشتری گرامی مهدی ارشادی, کد تأیید شماره همراه شما: 700428',1,'2022-11-17 11:10:47','09130055461'),
(58,'520083','client',92,'Ln6dUFox0kOt5I7iLYLY','مشتری گرامی مهدی ارشادی, کد تأیید شماره همراه شما: 520083',1,'2022-11-17 11:10:48','09130055461'),
(59,'410227','client',95,'FSTAfwfxWueoz9RHRVzz','مشتری گرامی محمد فاضلی, کد تأیید شماره همراه شما: 410227',1,'2022-11-19 09:18:37','09146569240'),
(60,'773846','client',95,'zKQ8P2s2H3Xou5qWHrk7','مشتری گرامی محمد فاضلی, کد تأیید شماره همراه شما: 773846',1,'2022-11-19 09:18:38','09146569240'),
(61,'476043','client',96,'axLY5xde09CNm4aacA2O','مشتری گرامی محمد آقازاده, کد تأیید شماره همراه شما: 476043',1,'2022-11-19 18:38:52','09100055062'),
(62,'422925','client',96,'SwFRCBKn2FbdEXxcTbPi','مشتری گرامی محمد آقازاده, کد تأیید شماره همراه شما: 422925',1,'2022-11-19 18:38:53','09100055062'),
(63,'652157','client',97,'iMlH4kY3dDVpwT3Y8CqQ','مشتری گرامی علی زمانی, کد تأیید شماره همراه شما: 652157',1,'2022-11-20 23:29:32','09905353114'),
(64,'512397','client',97,'ChpNnQN3ESUOTTl0G2KD','مشتری گرامی علی زمانی, کد تأیید شماره همراه شما: 512397',1,'2022-11-20 23:29:33','09905353114'),
(65,'063113','client',101,'10cLLgSr4rOM07p1fjmB','مشتری گرامی محمد حجت  اسماعیل بیگی , کد تأیید شماره همراه شما: 063113',1,'2022-11-26 13:21:00','09128512934'),
(66,'414774','client',101,'hbzOgb7Dwpg7VrQAZrZA','مشتری گرامی محمد حجت  اسماعیل بیگی , کد تأیید شماره همراه شما: 414774',1,'2022-11-26 13:21:01','09128512934'),
(67,'552529','client',103,'vfVjmIukTZMsh3xFPdBG','مشتری گرامی مهدی یعقوبی, کد تأیید شماره همراه شما: 552529',1,'2022-11-26 19:26:35','09352854080'),
(68,'443632','client',103,'5BRTQ5Jw9ZYRMMCSPvFU','مشتری گرامی مهدی یعقوبی, کد تأیید شماره همراه شما: 443632',1,'2022-11-26 19:26:35','09352854080'),
(69,'918101','client',104,'7j3qAZBTb1g5qhcPKmES','مشتری گرامی سعید طامه بیدگلی, کد تأیید شماره همراه شما: 918101',1,'2022-11-27 17:32:32','09366393932'),
(70,'714876','client',104,'6KIt2wi8Wl3hOKjfxHna','مشتری گرامی سعید طامه بیدگلی, کد تأیید شماره همراه شما: 714876',1,'2022-11-27 17:32:33','09366393932'),
(71,'110691','client',105,'G8rrnHJHByNMjKfLrw4y','مشتری گرامی مهدی  امیر آبادی, کد تأیید شماره همراه شما: 110691',1,'2022-11-28 11:32:29','912 365 9982'),
(72,'560869','client',105,'S40I4VqmvQl1Rtawc0NU','مشتری گرامی مهدی  امیر آبادی, کد تأیید شماره همراه شما: 560869',1,'2022-11-28 11:32:29','912 365 9982'),
(73,'275408','client',108,'lWlxNkH7wVdmmFs4k40Y','مشتری گرامی میثم قنبری, کد تأیید شماره همراه شما: 275408',1,'2022-12-04 23:48:44','09182605595'),
(74,'527351','client',108,'cyiPnDGuRgHe9kuswRmq','مشتری گرامی میثم قنبری, کد تأیید شماره همراه شما: 527351',1,'2022-12-04 23:48:59','09182605595'),
(75,'673229','client',109,'GzxofG83gqQmvLA8buvQ','مشتری گرامی محمد قلندری, کد تأیید شماره همراه شما: 673229',1,'2022-12-05 22:16:19','09332358481'),
(76,'958630','client',109,'5BdCdCAKBXQTd7cTQVRB','مشتری گرامی محمد قلندری, کد تأیید شماره همراه شما: 958630',1,'2022-12-05 22:16:24','09332358481'),
(77,'077080','client',110,'PZYVzfEiXFeEOWL6JdrP','مشتری گرامی داریوش کازرونی, کد تأیید شماره همراه شما: 077080',1,'2022-12-06 01:53:02','09170052328'),
(78,'079680','client',110,'x5JdK21n4veTtdAFJynR','مشتری گرامی داریوش کازرونی, کد تأیید شماره همراه شما: 079680',1,'2022-12-06 01:53:02','09170052328'),
(79,'104258','client',113,'C2BPgbaJUNZsAJ5VjXsE','مشتری گرامی Hanna Madel, کد تأیید شماره همراه شما: 104258',1,'2022-12-08 16:01:17','+51666754494'),
(80,'909617','client',113,'tPrCdNrRk5O6mbRJnF7f','مشتری گرامی Hanna Madel, کد تأیید شماره همراه شما: 909617',1,'2022-12-08 16:01:17','+51666754494'),
(81,'616448','client',116,'h5iEcrAa1xeYgK09o5rR','مشتری گرامی مصطفی منصوری, کد تأیید شماره همراه شما: 616448',1,'2022-12-10 11:38:25','09222601367'),
(82,'521301','client',116,'4WrIu6tuftsWgwkGHV43','مشتری گرامی مصطفی منصوری, کد تأیید شماره همراه شما: 521301',1,'2022-12-10 11:38:27','09222601367'),
(83,'396891','client',117,'skvENaQW9U4tRyVgytVo','مشتری گرامی مصطفی صناعی, کد تأیید شماره همراه شما: 396891',1,'2022-12-10 17:01:43','09133209077'),
(84,'924438','client',117,'bzFYnBqJwZT0wG2pX331','مشتری گرامی مصطفی صناعی, کد تأیید شماره همراه شما: 924438',1,'2022-12-10 17:01:44','09133209077'),
(85,'552623','client',119,'NeB9ZLCjcOVzpGRkJotr','مشتری گرامی مهدی ساجدی, کد تأیید شماره همراه شما: 552623',1,'2022-12-10 22:19:34','09901310385'),
(86,'373026','client',119,'R2L1GHjeE6UyjfurOKes','مشتری گرامی مهدی ساجدی, کد تأیید شماره همراه شما: 373026',1,'2022-12-10 22:19:40','09901310385'),
(87,'634651','client',120,'BgvPVNxv0YJcXBeTKlCJ','مشتری گرامی علی آذرمی, کد تأیید شماره همراه شما: 634651',1,'2022-12-11 16:34:27','09351476469'),
(88,'507559','client',120,'XpuzAWJCKTY801ircMXX','مشتری گرامی علی آذرمی, کد تأیید شماره همراه شما: 507559',1,'2022-12-11 16:34:30','09351476469'),
(89,'482037','client',121,'7nblvAzOy0vn6bEUi7Fh','مشتری گرامی باقی حسینی, کد تأیید شماره همراه شما: 482037',1,'2022-12-11 21:09:50','09903842457'),
(90,'822216','client',121,'ovpzRfjtwrwFVKWMWuXj','مشتری گرامی باقی حسینی, کد تأیید شماره همراه شما: 822216',1,'2022-12-11 21:09:56','09903842457'),
(91,'278924','client',123,'lRIT7Hts8LIyMNg8wxpt','مشتری گرامی امین زنگنه, کد تأیید شماره همراه شما: 278924',1,'2022-12-12 00:08:26','09115546209'),
(92,'818339','client',123,'DtlLCZMXWSXga7ouQxZl','مشتری گرامی امین زنگنه, کد تأیید شماره همراه شما: 818339',1,'2022-12-12 00:08:29','09115546209'),
(93,'980833','client',124,'3NjtVSXye4kELUCUayry','مشتری گرامی شروین سیدلو, کد تأیید شماره همراه شما: 980833',1,'2022-12-12 03:47:48','09913371375'),
(94,'308923','client',124,'xDwiR9kvmjcB5bRkCxFI','مشتری گرامی شروین سیدلو, کد تأیید شماره همراه شما: 308923',1,'2022-12-12 03:47:49','09913371375'),
(95,'580415','client',125,'WZ9dEoW3di67xSIOg57e','مشتری گرامی مصطفی صناعی, کد تأیید شماره همراه شما: 580415',1,'2022-12-12 13:39:58','09133769940'),
(96,'814020','client',125,'SYlIXqAU9YFOxIQecmTy','مشتری گرامی مصطفی صناعی, کد تأیید شماره همراه شما: 814020',1,'2022-12-12 13:40:07','09133769940'),
(97,'546852','client',126,'IPTNPkMDu6E26K4cNITi','مشتری گرامی ilgar az, کد تأیید شماره همراه شما: 546852',1,'2022-12-13 21:31:34','09145862484'),
(98,'973197','client',126,'PIzzrOHLuQYTPS4mi9K2','مشتری گرامی ilgar az, کد تأیید شماره همراه شما: 973197',1,'2022-12-13 21:31:40','09145862484'),
(99,'120285','client',127,'NxFjDsoyadVQpk7tA1O4','مشتری گرامی امیر عرب, کد تأیید شماره همراه شما: 120285',1,'2022-12-14 01:22:25','09390723875'),
(100,'549670','client',127,'mZBWpJgDXCtbS6YqHlDG','مشتری گرامی امیر عرب, کد تأیید شماره همراه شما: 549670',1,'2022-12-14 01:22:30','09390723875'),
(101,'874667','client',128,'vwslamzmlfwcqtiLu7UO','مشتری گرامی ابوالفضل ابوترابی, کد تأیید شماره همراه شما: 874667',1,'2022-12-14 16:21:05','09132597294'),
(102,'040819','client',128,'yTbHj2khRo02o3dQqIdU','مشتری گرامی ابوالفضل ابوترابی, کد تأیید شماره همراه شما: 040819',1,'2022-12-14 16:21:11','09132597294'),
(103,'030210','client',129,'M63gakceVkGIIGs26N8F','مشتری گرامی Sajad Fard, کد تأیید شماره همراه شما: 030210',1,'2022-12-14 18:12:08','09135211627'),
(104,'047913','client',129,'fjMmYuGqYWapoS9LncHh','مشتری گرامی Sajad Fard, کد تأیید شماره همراه شما: 047913',1,'2022-12-14 18:12:09','09135211627'),
(105,'204448','client',131,'TWRY26z306pY3JeX5y6R','مشتری گرامی غزاله قدسی پور, کد تأیید شماره همراه شما: 204448',1,'2022-12-15 12:23:03','09364928199'),
(106,'568983','client',131,'x2A9ST2cVx1iWV5oinQO','مشتری گرامی غزاله قدسی پور, کد تأیید شماره همراه شما: 568983',1,'2022-12-15 12:23:04','09364928199'),
(107,'096248','client',132,'9SCajUUNBZdqPdGB4QpO','مشتری گرامی حمیدرضا الماسی, کد تأیید شماره همراه شما: 096248',1,'2022-12-15 14:42:36','09395151193'),
(108,'910275','client',132,'8YBJCZmBG4CZrj0lamoE','مشتری گرامی حمیدرضا الماسی, کد تأیید شماره همراه شما: 910275',1,'2022-12-15 14:42:37','09395151193'),
(109,'864837','client',134,'CXOvuqu9lD8wfCgdAjfu','مشتری گرامی مهدی ملک زاده, کد تأیید شماره همراه شما: 864837',1,'2022-12-19 15:38:32','09120143449'),
(110,'551548','client',134,'pFPLaQ8igrYCYQZ09X2H','مشتری گرامی مهدی ملک زاده, کد تأیید شماره همراه شما: 551548',1,'2022-12-19 15:38:33','09120143449'),
(111,'196234','client',135,'YggpfIKbiR4C7KOj9YJM','مشتری گرامی فرنوش پیرانی, کد تأیید شماره همراه شما: 196234',1,'2022-12-19 16:20:08','09389742070'),
(112,'534091','client',135,'32V8W7NIGu4mQjO24EpG','مشتری گرامی فرنوش پیرانی, کد تأیید شماره همراه شما: 534091',1,'2022-12-19 16:20:09','09389742070'),
(113,'027259','client',136,'9xUq8P2FifM673b7FcBW','مشتری گرامی محمد زانا فرج نژاد, کد تأیید شماره همراه شما: 027259',1,'2022-12-19 17:25:34','09359534710'),
(114,'568203','client',136,'fUwFyxM7zjVWh03ZL1cl','مشتری گرامی محمد زانا فرج نژاد, کد تأیید شماره همراه شما: 568203',1,'2022-12-19 17:25:35','09359534710'),
(115,'043512','client',139,'lJIB4PwHamZxf0YIo3tU','مشتری گرامی AliReza Karami, کد تأیید شماره همراه شما: 043512',1,'2022-12-20 23:30:27','09382041384'),
(116,'973467','client',139,'WQ3lfaymV5hoEsih7jxH','مشتری گرامی AliReza Karami, کد تأیید شماره همراه شما: 973467',1,'2022-12-20 23:30:28','09382041384'),
(117,'260624','client',142,'aOBE7oHMP9jPDSpNEx5L','مشتری گرامی حامد افضلی, کد تأیید شماره همراه شما: 260624',1,'2022-12-21 16:45:17','09146444359'),
(118,'835080','client',142,'astNm5qOgNnlhsxBWwpF','مشتری گرامی حامد افضلی, کد تأیید شماره همراه شما: 835080',1,'2022-12-21 16:45:19','09146444359'),
(119,'033402','client',145,'AIVV8I6bRnqrpj0BEi4j','مشتری گرامی سروش طیبی, کد تأیید شماره همراه شما: 033402',1,'2022-12-21 22:10:45','09360901792'),
(120,'288697','client',145,'YA8fGsgM2b5JrrObXLmn','مشتری گرامی سروش طیبی, کد تأیید شماره همراه شما: 288697',1,'2022-12-21 22:10:46','09360901792'),
(121,'364677','client',148,'tkbIO8o2QLVWVnShYHbQ','مشتری گرامی شهزیاز درویش ها, کد تأیید شماره همراه شما: 364677',1,'2022-12-23 16:28:13','09228302678'),
(122,'151070','client',148,'ncpw9DmFznvMVQ7gbAq6','مشتری گرامی شهزیاز درویش ها, کد تأیید شماره همراه شما: 151070',1,'2022-12-23 16:28:19','09228302678'),
(123,'296793','client',150,'gkjmg14nDsXZFtV1xevH','مشتری گرامی سیاووش سیاووشی, کد تأیید شماره همراه شما: 296793',1,'2022-12-24 10:13:27','09124445922'),
(124,'001612','client',150,'RFYM8TyQZBbUnCDPxTjv','مشتری گرامی سیاووش سیاووشی, کد تأیید شماره همراه شما: 001612',1,'2022-12-24 10:13:30','09124445922'),
(125,'746246','client',152,'Sa5BxcFNEs1BLuTIv01P','مشتری گرامی سامان مرادی, کد تأیید شماره همراه شما: 746246',1,'2022-12-26 09:07:54','09120219788'),
(126,'265431','client',152,'0XVZGVejqJHWTC8jcTe3','مشتری گرامی سامان مرادی, کد تأیید شماره همراه شما: 265431',1,'2022-12-26 09:07:55','09120219788'),
(127,'480711','client',153,'NkHwotZsMeOj9Zam6Mzp','مشتری گرامی علی حسنزاده, کد تأیید شماره همراه شما: 480711',1,'2022-12-26 13:14:48','09120850616'),
(128,'049329','client',153,'o2dNFV2DKcxMijbb4ig0','مشتری گرامی علی حسنزاده, کد تأیید شماره همراه شما: 049329',1,'2022-12-26 13:14:53','09120850616'),
(129,'054062','client',154,'nFQoiBrbVDQQigwJTLOg','مشتری گرامی مهدی  عابدی, کد تأیید شماره همراه شما: 054062',1,'2022-12-27 12:36:06','09999588032'),
(130,'143582','client',154,'3V03XUcxFZHkEJ9Wo2uz','مشتری گرامی مهدی  عابدی, کد تأیید شماره همراه شما: 143582',1,'2022-12-27 12:36:07','09999588032'),
(131,'710392','client',157,'djpzrpF0G2JoqthbzgEx','مشتری گرامی کاظم نظمی تیل, کد تأیید شماره همراه شما: 710392',1,'2022-12-28 19:59:47','09369360433'),
(132,'145733','client',157,'LvZcS2UF5AS0eQTX4fC2','مشتری گرامی کاظم نظمی تیل, کد تأیید شماره همراه شما: 145733',1,'2022-12-28 19:59:55','09369360433'),
(133,'357341','client',162,'E9VFs6KOGHLoRFTx3mJx','مشتری گرامی سید محمد امین نژاد, کد تأیید شماره همراه شما: 357341',1,'2022-12-29 22:53:45','09365170813'),
(134,'243331','client',162,'pHc4ySjiBJOSofAF5Dc3','مشتری گرامی سید محمد امین نژاد, کد تأیید شماره همراه شما: 243331',1,'2022-12-29 22:53:46','09365170813'),
(135,'926732','client',163,'jn0y6R72p8BlakyyLvhr','مشتری گرامی فاروق رحمتی, کد تأیید شماره همراه شما: 926732',1,'2022-12-30 00:06:52','09152277462'),
(136,'036219','client',163,'X3koskNVU8r17cezZKuL','مشتری گرامی فاروق رحمتی, کد تأیید شماره همراه شما: 036219',1,'2022-12-30 00:06:53','09152277462'),
(137,'112562','client',164,'XdIErQ3rrGBaWJtXHuOv','مشتری گرامی پیمان علی پور, کد تأیید شماره همراه شما: 112562',1,'2022-12-30 05:07:45','09388758248'),
(138,'883751','client',164,'QwIJULhA8v5ZGpn0fhgh','مشتری گرامی پیمان علی پور, کد تأیید شماره همراه شما: 883751',1,'2022-12-30 05:07:45','09388758248'),
(139,'579907','client',165,'s1QnCBRSQQOCsircOlcb','مشتری گرامی محمد حسین جعفریان, کد تأیید شماره همراه شما: 579907',1,'2022-12-30 12:04:40','09224783282'),
(140,'691399','client',165,'bxBCYj8QHQ5PK5dAj7J0','مشتری گرامی محمد حسین جعفریان, کد تأیید شماره همراه شما: 691399',1,'2022-12-30 12:04:41','09224783282'),
(141,'317952','client',166,'c4LpZBdLDMHZoIF73YHd','مشتری گرامی saeed rouzegar, کد تأیید شماره همراه شما: 317952',1,'2022-12-30 17:26:23','09380836364'),
(142,'475738','client',166,'aEZnenkRphgypXN0r3Xb','مشتری گرامی saeed rouzegar, کد تأیید شماره همراه شما: 475738',1,'2022-12-30 17:26:23','09380836364'),
(143,'713155','client',168,'iXxIkME5GS6897OCZNor','مشتری گرامی amirsaman baniassadi, کد تأیید شماره همراه شما: 713155',1,'2023-01-01 23:55:55','09399117912'),
(144,'464156','client',168,'O2Xa7jHu4xP2Cc89nrRh','مشتری گرامی amirsaman baniassadi, کد تأیید شماره همراه شما: 464156',1,'2023-01-01 23:55:56','09399117912'),
(145,'045593','client',169,'o7iidwx6rqtwDDr8V9Uo','مشتری گرامی Pouya Salimi, کد تأیید شماره همراه شما: 045593',1,'2023-01-02 17:57:47','09189178663'),
(146,'566130','client',169,'b9cbvcgeAB4fYeCKxrQG','مشتری گرامی Pouya Salimi, کد تأیید شماره همراه شما: 566130',1,'2023-01-02 17:57:49','09189178663'),
(147,'076429','client',173,'KbzbBLssvLO2BsIn8yBB','مشتری گرامی علی رستم پور, کد تأیید شماره همراه شما: 076429',1,'2023-01-03 18:34:25','09172760201'),
(148,'093347','client',173,'9i6Y2OJqFx0YgqH9po2n','مشتری گرامی علی رستم پور, کد تأیید شماره همراه شما: 093347',1,'2023-01-03 18:34:26','09172760201'),
(149,'553453','client',175,'EP5JjaCMumRTk2GWYWT8','مشتری گرامی رضا اسدی, کد تأیید شماره همراه شما: 553453',1,'2023-01-04 11:24:44','09127307287'),
(150,'894254','client',176,'DhtRgMzprG80V3yWjJku','مشتری گرامی masuod malekniya, کد تأیید شماره همراه شما: 894254',1,'2023-01-04 11:24:45','09152739749'),
(151,'305364','client',175,'IB6CeaI5bqMcUNbNQKyZ','مشتری گرامی رضا اسدی, کد تأیید شماره همراه شما: 305364',1,'2023-01-04 11:24:45','09127307287'),
(152,'824541','client',176,'rYRg3Mutpjxe2PQbgKCc','مشتری گرامی masuod malekniya, کد تأیید شماره همراه شما: 824541',1,'2023-01-04 11:24:46','09152739749'),
(153,'014551','client',177,'bBozcL79PbLxzsjGM7nD','مشتری گرامی محسن کیانی, کد تأیید شماره همراه شما: 014551',1,'2023-01-04 12:14:06','۰۹۳۵۶۵۲۶۵۵۲'),
(154,'857550','client',177,'RdhomTV4iXtI1hLkpdh3','مشتری گرامی محسن کیانی, کد تأیید شماره همراه شما: 857550',1,'2023-01-04 12:14:07','۰۹۳۵۶۵۲۶۵۵۲'),
(155,'618672','client',179,'J90LPkrQDgtXbV9ucX5s','مشتری گرامی نوید افراشته, کد تأیید شماره همراه شما: 618672',1,'2023-01-04 22:35:48','09398120138'),
(156,'095231','client',179,'LMjoi9C48jVBZBhQbCol','مشتری گرامی نوید افراشته, کد تأیید شماره همراه شما: 095231',1,'2023-01-04 22:35:49','09398120138'),
(157,'478246','client',180,'iLs0QNnUl2z4Golcyr7P','مشتری گرامی سعید منوچهری, کد تأیید شماره همراه شما: 478246',1,'2023-01-04 23:12:23','09178982616'),
(158,'558977','client',180,'wcop4P3IRNYRTK7I4PTc','مشتری گرامی سعید منوچهری, کد تأیید شماره همراه شما: 558977',1,'2023-01-04 23:12:24','09178982616'),
(159,'807701','client',183,'lR3d881ay64n7xol7Jq8','مشتری گرامی مهدی رضایی, کد تأیید شماره همراه شما: 807701',1,'2023-01-05 12:10:55','09031168444'),
(160,'901437','client',183,'Hr0NXpcGMJ8ESrjr5p9b','مشتری گرامی مهدی رضایی, کد تأیید شماره همراه شما: 901437',1,'2023-01-05 12:10:57','09031168444'),
(161,'599573','client',184,'tjhhgYF11RHzdhh6k2iR','مشتری گرامی مهدی نعیمی, کد تأیید شماره همراه شما: 599573',1,'2023-01-06 16:51:42','09222778507'),
(162,'238561','client',184,'GSqW3BGtUvoVwEez7SJd','مشتری گرامی مهدی نعیمی, کد تأیید شماره همراه شما: 238561',1,'2023-01-06 16:51:43','09222778507'),
(163,'317135','client',185,'akcAp69tQIqZmo1ZkjHr','مشتری گرامی محمد جواد فصاحت, کد تأیید شماره همراه شما: 317135',1,'2023-01-06 17:14:38','09384999655'),
(164,'947150','client',185,'UBGL2uuXgFd37D79Sm3T','مشتری گرامی محمد جواد فصاحت, کد تأیید شماره همراه شما: 947150',1,'2023-01-06 17:14:38','09384999655'),
(165,'889520','client',187,'BGgIFvhS5k1hKu2IAaCF','مشتری گرامی سجاد خلیلی آزاد, کد تأیید شماره همراه شما: 889520',1,'2023-01-07 18:20:10','09354975105'),
(166,'445270','client',187,'O4ZElbQGFujGWVwtQCkQ','مشتری گرامی سجاد خلیلی آزاد, کد تأیید شماره همراه شما: 445270',1,'2023-01-07 18:20:12','09354975105'),
(167,'093680','client',188,'8rLEkYR1xcjTHJwRyg3M','مشتری گرامی علیرضا کریمی, کد تأیید شماره همراه شما: 093680',1,'2023-01-07 22:46:25','09981505051'),
(168,'349115','client',188,'Ax4adZ9iXiUe0oKGZ7Pv','مشتری گرامی علیرضا کریمی, کد تأیید شماره همراه شما: 349115',1,'2023-01-07 22:46:26','09981505051'),
(169,'334301','client',189,'qrNwLoZ3MzX8WFIwVGBY','مشتری گرامی حمیدرضا  راشدی فر, کد تأیید شماره همراه شما: 334301',1,'2023-01-09 04:18:39','09130942381'),
(170,'950574','client',189,'5x83uE2qVGVet1sGZHeD','مشتری گرامی حمیدرضا  راشدی فر, کد تأیید شماره همراه شما: 950574',1,'2023-01-09 04:18:40','09130942381'),
(171,'324529','client',190,'xfjuyj8BNK5rL7uyvYVq','مشتری گرامی عمادالدین محمودی, کد تأیید شماره همراه شما: 324529',1,'2023-01-09 12:34:09','09902083341'),
(172,'246484','client',190,'vcLTz0BbYRrjDeY22qol','مشتری گرامی عمادالدین محمودی, کد تأیید شماره همراه شما: 246484',1,'2023-01-09 12:34:11','09902083341'),
(173,'995739','client',192,'DF9JhiUi8MfCCUNSd1sd','مشتری گرامی پرسا کمانگیر, کد تأیید شماره همراه شما: 995739',1,'2023-01-10 11:07:06','09385287962'),
(174,'185101','client',192,'vwV83AB7NJQUyPAPSnVQ','مشتری گرامی پرسا کمانگیر, کد تأیید شماره همراه شما: 185101',1,'2023-01-10 11:07:09','09385287962'),
(175,'636211','client',193,'0A1huBaA2C6gwlfIKJda','مشتری گرامی MT. Akbarzadeh, کد تأیید شماره همراه شما: 636211',1,'2023-01-10 14:16:35','09166109969'),
(176,'344254','client',193,'P3ZTRyN9CQX2Yu7vc9mx','مشتری گرامی MT. Akbarzadeh, کد تأیید شماره همراه شما: 344254',1,'2023-01-10 14:16:36','09166109969'),
(177,'937259','client',194,'oa9PSN0StkLtFoNzxOOE','مشتری گرامی صادق شهریاری, کد تأیید شماره همراه شما: 937259',1,'2023-01-10 18:54:49','09360607879'),
(178,'028499','client',194,'tscXnNo6oiSf3hXh1fRa','مشتری گرامی صادق شهریاری, کد تأیید شماره همراه شما: 028499',1,'2023-01-10 18:54:50','09360607879'),
(179,'943755','client',197,'JlEaZLds2OqVTh5ztVdA','مشتری گرامی سید محمد رضوی, کد تأیید شماره همراه شما: 943755',1,'2023-01-12 09:45:58','09360932966'),
(180,'359208','client',197,'EDYhcnUApXomcXpPTqpH','مشتری گرامی سید محمد رضوی, کد تأیید شماره همراه شما: 359208',1,'2023-01-12 09:45:59','09360932966'),
(181,'633469','client',198,'WRMoMi5xAzaXWDHHhTwP','مشتری گرامی حمیدرضا ادیب, کد تأیید شماره همراه شما: 633469',1,'2023-01-13 01:09:37','09358551590'),
(182,'655082','client',198,'aiuBWPwZHyNXsiGhafgP','مشتری گرامی حمیدرضا ادیب, کد تأیید شماره همراه شما: 655082',1,'2023-01-13 01:09:38','09358551590'),
(183,'834026','client',199,'h2oLsQWXzovQK4S0qQeY','مشتری گرامی مهدی  حسینی, کد تأیید شماره همراه شما: 834026',1,'2023-01-13 01:46:02','09199519001'),
(184,'451300','client',199,'oEEpUgDJU9bbEWbiLtP5','مشتری گرامی مهدی  حسینی, کد تأیید شماره همراه شما: 451300',1,'2023-01-13 01:46:03','09199519001'),
(185,'104029','client',200,'ZZNw5S1MjklzAMObYemg','مشتری گرامی منصور بیجاد, کد تأیید شماره همراه شما: 104029',1,'2023-01-14 23:03:21','09360720099'),
(186,'939419','client',200,'hOEq1NqHpBkEnNbKyP99','مشتری گرامی منصور بیجاد, کد تأیید شماره همراه شما: 939419',1,'2023-01-14 23:03:21','09360720099'),
(187,'355654','client',201,'8HeiP5vJGXztmUO64GJ2','مشتری گرامی احمد کاوسی, کد تأیید شماره همراه شما: 355654',1,'2023-01-15 04:06:16','09901306283'),
(188,'962774','client',201,'fGN8iOJxJ9Camwlnxs3Y','مشتری گرامی احمد کاوسی, کد تأیید شماره همراه شما: 962774',1,'2023-01-15 04:06:16','09901306283'),
(189,'604918','client',202,'yBs8RcltOp7SR0YEg1Rt','مشتری گرامی امین ظهرابی, کد تأیید شماره همراه شما: 604918',1,'2023-01-15 15:07:50','09168030360'),
(190,'145237','client',202,'uNnTcicC1G6ICY243EKZ','مشتری گرامی امین ظهرابی, کد تأیید شماره همراه شما: 145237',1,'2023-01-15 15:07:51','09168030360'),
(191,'406819','client',203,'3N8MIzSg4yVVCw4WZcX8','مشتری گرامی امید عزیزی, کد تأیید شماره همراه شما: 406819',1,'2023-01-17 00:59:47','09181761086'),
(192,'498504','client',203,'FKLWAQ3AXfLQ66ZM3qDR','مشتری گرامی امید عزیزی, کد تأیید شماره همراه شما: 498504',1,'2023-01-17 00:59:49','09181761086'),
(193,'757434','client',206,'pghsxev33IO3Bg6e46gQ','مشتری گرامی behrooz ebrahimi, کد تأیید شماره همراه شما: 757434',1,'2023-01-17 19:06:20','09364369243'),
(194,'054627','client',206,'qMNMwbORS6pCCqoWu4Zm','مشتری گرامی behrooz ebrahimi, کد تأیید شماره همراه شما: 054627',1,'2023-01-17 19:06:21','09364369243'),
(195,'666657','client',208,'bTWGeBoHp7BwcUC6kauS','مشتری گرامی محمد فکوری, کد تأیید شماره همراه شما: 666657',1,'2023-01-18 00:07:41','09111831780'),
(196,'358023','client',208,'0wTFnlT4DVsh6hxXYhuU','مشتری گرامی محمد فکوری, کد تأیید شماره همراه شما: 358023',1,'2023-01-18 00:07:41','09111831780'),
(197,'304556','client',210,'ppFbh9Wy7mTG93fLQcvv','مشتری گرامی YahYa Sarab, کد تأیید شماره همراه شما: 304556',1,'2023-01-18 06:53:44','09305301679'),
(198,'347943','client',210,'efew9ep4zbOmYa3MNS0Q','مشتری گرامی YahYa Sarab, کد تأیید شماره همراه شما: 347943',1,'2023-01-18 06:53:45','09305301679'),
(199,'585411','client',211,'Hr0VT6LD5DnCtULrQBxm','مشتری گرامی قاسم صالحی, کد تأیید شماره همراه شما: 585411',1,'2023-01-18 11:16:48','09357106197'),
(200,'758990','client',211,'3dTFAPx2DPMceJ3sbL58','مشتری گرامی قاسم صالحی, کد تأیید شماره همراه شما: 758990',1,'2023-01-18 11:16:49','09357106197'),
(201,'904076','client',214,'wpGPYe6IwcngMkn2kCTz','مشتری گرامی محمد فرازنده, کد تأیید شماره همراه شما: 904076',1,'2023-01-19 00:19:05','۰۹۱۲۱۰۶۵۶۲۵'),
(202,'335035','client',214,'OrNHRMTHZFRtodobtQBE','مشتری گرامی محمد فرازنده, کد تأیید شماره همراه شما: 335035',1,'2023-01-19 00:19:05','۰۹۱۲۱۰۶۵۶۲۵'),
(203,'079463','client',216,'tVYBXtUwWuVwfuT4v9pH','مشتری گرامی رضا مهمان دوست, کد تأیید شماره همراه شما: 079463',1,'2023-01-20 12:59:55','09384121640'),
(204,'624756','client',216,'guR7NlniC9UKIGYgpuvI','مشتری گرامی رضا مهمان دوست, کد تأیید شماره همراه شما: 624756',1,'2023-01-20 12:59:55','09384121640'),
(205,'473481','client',217,'aLKoui4VwVMeb9LlSGBO','مشتری گرامی سیدهادی موسوی, کد تأیید شماره همراه شما: 473481',1,'2023-01-20 16:53:33','09021182339'),
(206,'734127','client',217,'03k4DXR1lpvubUtY4DG9','مشتری گرامی سیدهادی موسوی, کد تأیید شماره همراه شما: 734127',1,'2023-01-20 16:53:38','09021182339'),
(207,'764491','client',219,'eaXo4Ed8aUDoTW9MFsDe','مشتری گرامی سید مرتضی حسینی مهرداد, کد تأیید شماره همراه شما: 764491',1,'2023-01-20 19:18:33','09120615156+'),
(208,'309585','client',219,'xaef6WziRKLGsKDznzPS','مشتری گرامی سید مرتضی حسینی مهرداد, کد تأیید شماره همراه شما: 309585',1,'2023-01-20 19:18:34','09120615156+'),
(209,'005729','client',220,'qYPZvkPV3fGmY3s1ktE0','مشتری گرامی Amirreza  Ba, کد تأیید شماره همراه شما: 005729',1,'2023-01-20 20:00:07','09378690509'),
(210,'180082','client',220,'esdGtkAwlomCTZzYQHR0','مشتری گرامی Amirreza  Ba, کد تأیید شماره همراه شما: 180082',1,'2023-01-20 20:00:07','09378690509'),
(211,'835261','client',221,'eZVWbNvtoVte2GSFUw7y','مشتری گرامی محمد نریموسایی, کد تأیید شماره همراه شما: 835261',1,'2023-01-21 01:33:52','09169530743'),
(212,'610973','client',221,'OMTL7FU55DvqKuahrGc4','مشتری گرامی محمد نریموسایی, کد تأیید شماره همراه شما: 610973',1,'2023-01-21 01:33:54','09169530743'),
(213,'766226','client',223,'FRaSe1OyDIykuWFURZWs','مشتری گرامی بهروز نوری, کد تأیید شماره همراه شما: 766226',1,'2023-01-22 17:33:08','09144588816'),
(214,'164445','client',223,'tWbsdpsQB3aXYleU8t9r','مشتری گرامی بهروز نوری, کد تأیید شماره همراه شما: 164445',1,'2023-01-22 17:33:09','09144588816'),
(215,'005047','client',224,'wxc1bWywONrF8gNoceJF','مشتری گرامی فهیم قاسمی, کد تأیید شماره همراه شما: 005047',1,'2023-01-24 23:23:26','09121234567'),
(216,'678225','client',224,'hjOpw8hp9BwrifLbbbbk','مشتری گرامی فهیم قاسمی, کد تأیید شماره همراه شما: 678225',1,'2023-01-24 23:23:27','09121234567'),
(217,'697932','client',227,'o7HBwQyfFfeCww3eh0zg','مشتری گرامی مجید باسره, کد تأیید شماره همراه شما: 697932',1,'2023-01-27 12:42:54','09332637117'),
(218,'891956','client',227,'C0SBUVvB2HbWy6b5LOvn','مشتری گرامی مجید باسره, کد تأیید شماره همراه شما: 891956',1,'2023-01-27 12:42:54','09332637117'),
(219,'344995','client',229,'ILdWwm73WRvVFJHCN2QL','مشتری گرامی امیر حسین یوسفیان, کد تأیید شماره همراه شما: 344995',1,'2023-01-29 21:36:30','09028122550'),
(220,'751381','client',229,'plzkVO8oTTmdWTs9hUHW','مشتری گرامی امیر حسین یوسفیان, کد تأیید شماره همراه شما: 751381',1,'2023-01-29 21:36:30','09028122550'),
(221,'024348','client',233,'GSBQPLk5faCZjl4X8n83','مشتری گرامی سامان عادل پور, کد تأیید شماره همراه شما: 024348',1,'2023-01-30 02:50:40','09107499731'),
(222,'213696','client',233,'vhforJblAML0ceJNsJsb','مشتری گرامی سامان عادل پور, کد تأیید شماره همراه شما: 213696',1,'2023-01-30 02:50:40','09107499731'),
(223,'471069','client',234,'y6YdueD3xRZj7gcyJIWG','مشتری گرامی غلامرضا رنجبر, کد تأیید شماره همراه شما: 471069',1,'2023-01-30 12:31:03','09192464821'),
(224,'984948','client',234,'Y6fkBi2E7u9prpvWiWu6','مشتری گرامی غلامرضا رنجبر, کد تأیید شماره همراه شما: 984948',1,'2023-01-30 12:31:04','09192464821'),
(225,'439606','client',237,'kCDxZlg9aN4AEefIkhTl','مشتری گرامی سردار  خضری, کد تأیید شماره همراه شما: 439606',1,'2023-01-31 16:10:24','09104779636'),
(226,'280522','client',237,'VFU3jYMzfSp0yMMfa6kF','مشتری گرامی سردار  خضری, کد تأیید شماره همراه شما: 280522',1,'2023-01-31 16:10:24','09104779636'),
(227,'777816','client',238,'xr4FaIRPnIMcgLmddnGX','مشتری گرامی میلاد فرهادی, کد تأیید شماره همراه شما: 777816',1,'2023-01-31 16:48:35','09374845108'),
(228,'062433','client',238,'DqM4bk8Gpt8LrZ22N56E','مشتری گرامی میلاد فرهادی, کد تأیید شماره همراه شما: 062433',1,'2023-01-31 16:48:36','09374845108'),
(232,'67466','client',241,'S31KsEeqck0AhQqwHLW0','مشتری گرامی رضا کلالی, کد تأیید شماره همراه شما: 67466 برای درخواست # S31KsEeqck0AhQqwHLW0.',1,'2023-02-01 10:25:35','09153065412'),
(233,'836256','client',242,'FZPVRTDWtss6ciyhh1VK','مشتری گرامی لیلا مهدوی, کد تأیید شماره همراه شما: 836256',1,'2023-02-03 18:24:51','09372518191'),
(234,'004585','client',242,'dYem2UXvHRl6v79R1HCs','مشتری گرامی لیلا مهدوی, کد تأیید شماره همراه شما: 004585',1,'2023-02-03 18:24:52','09372518191'),
(235,'022604','client',244,'RkVicz6p9YNVaHtMfBKh','مشتری گرامی مجید بهادری, کد تأیید شماره همراه شما: 022604',1,'2023-02-03 21:14:20','09037024617'),
(236,'748798','client',244,'qQAnnnMAy54JRmVtyXSP','مشتری گرامی مجید بهادری, کد تأیید شماره همراه شما: 748798',1,'2023-02-03 21:14:20','09037024617'),
(237,'550629','client',246,'xPx1XYcvvQ8sYqMVZHoq','مشتری گرامی مسعود بخشی نژاد, کد تأیید شماره همراه شما: 550629',1,'2023-02-04 16:41:06','۰۹۳۳۲۳۵۶۶۰۴'),
(238,'732138','client',246,'S6PGMLfLRkKcIVNmJVus','مشتری گرامی مسعود بخشی نژاد, کد تأیید شماره همراه شما: 732138',1,'2023-02-04 16:41:06','۰۹۳۳۲۳۵۶۶۰۴'),
(239,'958333','client',247,'qMsbAL6uCssGsJoeQb3v','مشتری گرامی فرهاد قربانپور, کد تأیید شماره همراه شما: 958333',1,'2023-02-04 18:05:46','09121182315'),
(240,'873514','client',247,'qvpoOmTmg6jSL617p1Hg','مشتری گرامی فرهاد قربانپور, کد تأیید شماره همراه شما: 873514',1,'2023-02-04 18:05:47','09121182315'),
(241,'829330','client',248,'EKEqLu2oxfYYKH4obp1l','مشتری گرامی Abas Ghavabesh, کد تأیید شماره همراه شما: 829330',1,'2023-02-04 20:55:45','09163001394'),
(242,'137014','client',248,'wlWJfWblys3PzXlbx9sF','مشتری گرامی Abas Ghavabesh, کد تأیید شماره همراه شما: 137014',1,'2023-02-04 20:55:45','09163001394'),
(243,'990194','client',251,'7zXvLCYcIhOoK1o9liSW','مشتری گرامی علی قربان زاده, کد تأیید شماره همراه شما: 990194',1,'2023-02-06 13:36:25','09303024537'),
(244,'339314','client',251,'j3h0L9ScpUdKeBug2FqL','مشتری گرامی علی قربان زاده, کد تأیید شماره همراه شما: 339314',1,'2023-02-06 13:36:25','09303024537'),
(245,'463577','client',253,'2oA0dw9FY01RFtzEomEP','مشتری گرامی حمید محررزاده, کد تأیید شماره همراه شما: 463577',1,'2023-02-06 16:34:04','09196704570'),
(246,'271171','client',253,'5ZMKqC3r4dhlECoOXHQX','مشتری گرامی حمید محررزاده, کد تأیید شماره همراه شما: 271171',1,'2023-02-06 16:34:04','09196704570'),
(247,'293351','client',254,'6SXsed2lreRnBj4mTo50','مشتری گرامی حامد سعادتمند, کد تأیید شماره همراه شما: 293351',1,'2023-02-06 18:57:48','09155458878'),
(248,'408991','client',254,'pqlqc6wb7cLvr7LgJStr','مشتری گرامی حامد سعادتمند, کد تأیید شماره همراه شما: 408991',1,'2023-02-06 18:57:49','09155458878'),
(249,'322592','client',255,'U1b5ajSYxSvPnQqBBxve','مشتری گرامی roham yaghoobi, کد تأیید شماره همراه شما: 322592',1,'2023-02-06 19:08:18','09128012509'),
(250,'856856','client',255,'xr9z0uzMSzmp96B5Ghpi','مشتری گرامی roham yaghoobi, کد تأیید شماره همراه شما: 856856',1,'2023-02-06 19:08:19','09128012509'),
(251,'257819','client',256,'Faf4H6S9WUEpAiewqSpF','مشتری گرامی Ruhollah Noruzi, کد تأیید شماره همراه شما: 257819',1,'2023-02-07 00:03:59','09193085208'),
(252,'588874','client',256,'4NvqlmZISWARdIlEkV2u','مشتری گرامی Ruhollah Noruzi, کد تأیید شماره همراه شما: 588874',1,'2023-02-07 00:03:59','09193085208'),
(253,'228908','client',257,'rN3k52a4aPA4vmP1piR0','مشتری گرامی پارسا قربانیان, کد تأیید شماره همراه شما: 228908',1,'2023-02-07 13:36:17','09383403350'),
(254,'435178','client',257,'gjytLiL3kJdecIYAmSAC','مشتری گرامی پارسا قربانیان, کد تأیید شماره همراه شما: 435178',1,'2023-02-07 13:36:18','09383403350'),
(255,'067291','client',258,'k7G7K9HulwOxsSux48iV','مشتری گرامی عادل محمدی, کد تأیید شماره همراه شما: 067291',1,'2023-02-08 10:37:46','09216560669'),
(256,'068074','client',258,'bzIjgh3vV14FM1VpJRYl','مشتری گرامی عادل محمدی, کد تأیید شماره همراه شما: 068074',1,'2023-02-08 10:37:47','09216560669'),
(257,'275551','client',259,'6kiMdCeb6FB1ywx3O8QF','مشتری گرامی محمدرضا میرجانی, کد تأیید شماره همراه شما: 275551',1,'2023-02-08 21:35:00','09204041250'),
(258,'450229','client',259,'hSdbLZtUlK5orA0YuN6q','مشتری گرامی محمدرضا میرجانی, کد تأیید شماره همراه شما: 450229',1,'2023-02-08 21:35:00','09204041250'),
(259,'818765','client',260,'8sVvHPWo9LghsGdoW6wE','مشتری گرامی محبوب عبداللهی, کد تأیید شماره همراه شما: 818765',1,'2023-02-09 10:50:18','09391605665'),
(260,'814742','client',260,'8bTBabnZEqFnET3sDvbg','مشتری گرامی محبوب عبداللهی, کد تأیید شماره همراه شما: 814742',1,'2023-02-09 10:50:18','09391605665'),
(261,'857538','client',261,'3j3T9nlSkyjE1IxwhfwU','مشتری گرامی Milad esmail zadeh, کد تأیید شماره همراه شما: 857538',1,'2023-02-11 23:19:32','09335312764'),
(262,'743800','client',261,'JMzmbghAKxubIJm0mlnA','مشتری گرامی Milad esmail zadeh, کد تأیید شماره همراه شما: 743800',1,'2023-02-11 23:19:32','09335312764'),
(263,'242430','client',262,'Q2K0PPUGTcMVBP4pVa9N','مشتری گرامی رسول حسینی, کد تأیید شماره همراه شما: 242430',1,'2023-02-12 01:35:31','09104669398'),
(264,'827418','client',262,'kzUevEk6uEqw7Lc5uhti','مشتری گرامی رسول حسینی, کد تأیید شماره همراه شما: 827418',1,'2023-02-12 01:35:31','09104669398'),
(265,'524011','client',263,'o0cfq90h2hR7HcAOV5IL','مشتری گرامی بهرام باقری, کد تأیید شماره همراه شما: 524011',1,'2023-02-12 09:58:36','09124057563'),
(266,'276366','client',263,'jXJes1KNVb6ZefcUgUzQ','مشتری گرامی بهرام باقری, کد تأیید شماره همراه شما: 276366',1,'2023-02-12 09:58:37','09124057563'),
(267,'288985','client',265,'PB5POWCPCVIYldfW01Gv','مشتری گرامی حسین احمدی, کد تأیید شماره همراه شما: 288985',1,'2023-02-13 15:39:40','09387885959'),
(268,'935785','client',265,'kI30ciWKDmP8hAQYxeFo','مشتری گرامی حسین احمدی, کد تأیید شماره همراه شما: 935785',1,'2023-02-13 15:39:40','09387885959'),
(269,'331942','client',267,'tMfDKnLTvkLCjTUQn0lM','مشتری گرامی sajad hey, کد تأیید شماره همراه شما: 331942',1,'2023-02-18 21:24:09','09367622186'),
(270,'005552','client',267,'OJuJ9u4Ucw8R2jkH2Xz7','مشتری گرامی sajad hey, کد تأیید شماره همراه شما: 005552',1,'2023-02-18 21:24:10','09367622186'),
(271,'310470','client',269,'mZwjtMVms0SSV4yanAa6','مشتری گرامی مارال مرادی, کد تأیید شماره همراه شما: 310470',1,'2023-02-21 00:52:06','09138028654'),
(272,'522864','client',269,'ibNtIjO23eirkh843EZx','مشتری گرامی مارال مرادی, کد تأیید شماره همراه شما: 522864',1,'2023-02-21 00:52:06','09138028654'),
(273,'879691','client',271,'07AhYqICwCKFdcyYwsfd','مشتری گرامی elias elias, کد تأیید شماره همراه شما: 879691',1,'2023-02-23 00:31:12','09390888293'),
(274,'135001','client',271,'9UUbGxzZK9hxEz8AIVn3','مشتری گرامی elias elias, کد تأیید شماره همراه شما: 135001',1,'2023-02-23 00:31:12','09390888293');
/*!40000 ALTER TABLE `mod_ippanelsms_otp` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_ippanelsms_settings`
--

DROP TABLE IF EXISTS `mod_ippanelsms_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_ippanelsms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api` varchar(40) NOT NULL,
  `apiparams` varchar(500) NOT NULL,
  `wantsmsfield` int(11) DEFAULT NULL,
  `gsmnumberfield` int(11) DEFAULT NULL,
  `dateformat` varchar(12) DEFAULT NULL,
  `calendar` varchar(15) DEFAULT NULL,
  `version` varchar(6) DEFAULT NULL,
  `deletedatabase` int(1) DEFAULT 0,
  `debugmode` int(1) DEFAULT 0,
  `enable_otp` int(1) DEFAULT NULL,
  `otpdelay` int(5) DEFAULT NULL,
  `accesswithoutverify` text DEFAULT NULL,
  `unsuccessotptry` int(5) DEFAULT 5,
  `otplength` int(1) DEFAULT 5,
  `repetetive` int(1) DEFAULT 0,
  `enable_mobilelogin` int(1) DEFAULT 1,
  `loginotpexpire` int(4) DEFAULT 300,
  `loginotplength` int(1) DEFAULT 5,
  `enable_mobilereset` int(1) DEFAULT 1,
  `resetotpexpire` int(4) DEFAULT 300,
  `resetotplength` int(1) DEFAULT 5,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_ippanelsms_settings`
--

LOCK TABLES `mod_ippanelsms_settings` WRITE;
/*!40000 ALTER TABLE `mod_ippanelsms_settings` DISABLE KEYS */;
INSERT INTO `mod_ippanelsms_settings` (`id`, `api`, `apiparams`, `wantsmsfield`, `gsmnumberfield`, `dateformat`, `calendar`, `version`, `deletedatabase`, `debugmode`, `enable_otp`, `otpdelay`, `accesswithoutverify`, `unsuccessotptry`, `otplength`, `repetetive`, `enable_mobilelogin`, `loginotpexpire`, `loginotplength`, `enable_mobilereset`, `resetotpexpire`, `resetotplength`) VALUES (1,'ippanel','{\"user\":\"keloncloud\",\"pass\":\"@Hammed23\",\"senderid\":\"+983000505\",\"signature\":\"Keloncloud.com\",\"paneladdress\":\"ippanel.com\"}',64,3,'%y/%m/%d','shamsi','2.5',0,0,1,30,'null',5,5,1,1,300,5,1,300,5);
/*!40000 ALTER TABLE `mod_ippanelsms_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_ippanelsms_templates`
--

DROP TABLE IF EXISTS `mod_ippanelsms_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_ippanelsms_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `type` enum('client','admin') NOT NULL,
  `admingsm` varchar(255) NOT NULL,
  `template` varchar(500) NOT NULL,
  `variables` varchar(500) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `extra` varchar(3) NOT NULL,
  `description` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_ippanelsms_templates`
--

LOCK TABLES `mod_ippanelsms_templates` WRITE;
/*!40000 ALTER TABLE `mod_ippanelsms_templates` DISABLE KEYS */;
INSERT INTO `mod_ippanelsms_templates` (`id`, `name`, `type`, `admingsm`, `template`, `variables`, `active`, `extra`, `description`) VALUES (1,'loginbymobile','client','','کد تأیید شماره همراه شما: {otp}','{otp}',1,'','{\"english\":\"Login By Mobile\",\"persian\":\"\\u067e\\u06cc\\u0627\\u0645\\u06a9 \\u0627\\u062d\\u0631\\u0627\\u0632 \\u0647\\u0648\\u06cc\\u062a \\u0648\\u0631\\u0648\\u062f \\u0628\\u0627 \\u0645\\u0648\\u0628\\u0627\\u06cc\\u0644\"}'),
(2,'AfterRegistrarRegistrationFailed_admin','admin','9123952369,‪09128436084‬','دامنه جدید ثبت نشد {domain}','{firstname}, {lastname}, {domain},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After domain registration failed\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062b\\u0628\\u062a \\u0646\\u0627\\u0645\\u0648\\u0641\\u0642 \\u06cc\\u06a9 \\u062f\\u0627\\u0645\\u0646\\u0647\"}'),
(3,'AfterRegistrarRenewal','client','','مشتری گرامی {firstname} {lastname} دامنه شما تمدید شد {domain}','{firstname}, {lastname}, {domain},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"After domain renewal\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062a\\u0645\\u062f\\u06cc\\u062f \\u06cc\\u06a9 \\u062f\\u0627\\u0645\\u0646\\u0647\"}'),
(4,'AfterRegistrarRenewalFailed_admin','admin','9123952369,‪09128436084‬','دامنه تمدید نشد {domain}','{firstname}, {lastname}, {domain},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After domain renewal failed\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062a\\u0645\\u062f\\u06cc\\u062f \\u0646\\u0627\\u0645\\u0648\\u0641\\u0642 \\u062f\\u0627\\u0645\\u0646\\u0647\"}'),
(5,'resetpassword','client','','مشتری گرامی {firstname} {lastname}، اطلاعات جدید حساب کاربری شما:\nآدرس ایمیل: {clientemail}\nرمز عبور: {password}','{password},{firstname},{lastname},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After Reset Password\",\"persian\":\"\\u067e\\u06cc\\u0627\\u0645\\u06a9 \\u0628\\u0627\\u0632\\u06cc\\u0627\\u0628\\u06cc \\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631\"}'),
(6,'ClientAdd','client','','مشتری گرامی {firstname} {lastname} ثبت نام شما انجام شد ایمیل {email} رمز عبور {password}','{firstname},{lastname},{email},{password},{clientid},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"After client register\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062b\\u0628\\u062a \\u0646\\u0627\\u0645 \\u06cc\\u06a9 \\u0645\\u0634\\u062a\\u0631\\u06cc\"}'),
(7,'TicketOpen_admin','client','','تیکت {ticketsubject} باز شد','{firstname},{lastname},{ticketsubject},{ticketid},{ticketuniqID},{ticketmessage},{ticketurgency},{ticketservice},{ticketdepartment},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"After ticket opened\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062b\\u0628\\u062a \\u062a\\u06cc\\u06a9\\u062a \\u062a\\u0648\\u0633\\u0637 \\u0645\\u062f\\u06cc\\u0631\"}'),
(8,'ClientLogin_admin','admin','9123952369,‪09128436084‬','مشتری {firstname} {lastname} وارد ناحیه کاربری شد','{firstname},{lastname},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate},{loginip},{logintime}',0,'','{\"english\":\"After client loged in\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u0648\\u0631\\u0648\\u062f \\u0645\\u0634\\u062a\\u0631\\u06cc \\u0628\\u0647 \\u0645\\u062d\\u06cc\\u0637 \\u06a9\\u0627\\u0631\\u0628\\u0631\\u06cc\"}'),
(9,'ClientAdd_admin','admin','9123952369,‪09128436084‬','ثبت نام جدید انجام شد','{firstname},{lastname},{email},{password},{clientid},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After client register\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062b\\u0628\\u062a \\u0646\\u0627\\u0645 \\u06cc\\u06a9 \\u0645\\u0634\\u062a\\u0631\\u06cc\"}'),
(10,'InvoicePaymentReminder_Reminder','client','','مشتری گرامی {firstname} {lastname} صورتحساب {duedate} ایجاد شد جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}, {total}, {invoiceid},{clientid},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"Invoice payment reminder\",\"persian\":\"\\u06cc\\u0627\\u062f\\u0622\\u0648\\u0631\\u06cc \\u067e\\u0631\\u062f\\u0627\\u062e\\u062a \\u0635\\u0648\\u0631\\u062a\\u062d\\u0633\\u0627\\u0628\"}'),
(11,'AfterModuleChangePassword','client','','مشتری گرامی {firstname} {lastname} سفارش شما تغییر رمز یافت نام کاربری {username} رمز عبور {password} {domain}','{firstname}, {lastname}, {domain}, {username}, {password},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After module change password\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631\"}'),
(12,'TicketAdminReply','client','','مشتری گرامی {firstname} {lastname} تیکت {ticketsubject} پاسخ داده شد','{firstname},{lastname},{ticketsubject},{ticketid},{ticketuniqID},{ticketmessage},{ticketurgency},{ticketservice},{ticketdepartment},{ticketreplymessage},{ticketreplyadminname},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"After ticket replied by admin\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u067e\\u0627\\u0633\\u062e \\u0628\\u0647 \\u062a\\u06cc\\u06a9\\u062a \\u062a\\u0648\\u0633\\u0637 \\u0645\\u062f\\u06cc\\u0631\"}'),
(13,'AfterModuleSuspend','client','','مشتری گرامی {firstname} {lastname} سفارش شما تعلیق شد {domain}','{firstname}, {lastname}, {domain},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After module suspended\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062a\\u0639\\u0644\\u06cc\\u0642 \\u06cc\\u06a9 \\u0633\\u0641\\u0627\\u0631\\u0634\"}'),
(14,'DomainRenewalNotice','client','','مشتری گرامی {firstname} {lastname} دامنه شما {x} روز دیگر منقضی می شود جهت تمدید به سایت مراجعه کنید تاریخ انقضا {expirydate} {domain}','{firstname}, {lastname}, {domain},{expirydate},{x}',1,'15','{\"english\":\"Donmain renewal notice before {x} days ago\",\"persian\":\"\\u0627\\u062e\\u0637\\u0627\\u0631 \\u062a\\u0645\\u062f\\u06cc\\u062f \\u062f\\u0627\\u0645\\u0646\\u0647 \\u0628\\u0647 \\u0645\\u0634\\u062a\\u0631\\u06cc \\u067e\\u0633 \\u0627\\u0632 {x} \\u0631\\u0648\\u0632\"}'),
(15,'AfterRegistrarRegistration_admin','admin','9123952369,‪09128436084‬','دامنه جدید ثبت شد {domain}','{firstname}, {lastname}, {domain},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After domain registration\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062b\\u0628\\u062a \\u06cc\\u06a9 \\u062f\\u0627\\u0645\\u0646\\u0647\"}'),
(16,'ClientChangePassword','client','','مشتری گرامی {firstname} {lastname} رمز شما تغییر کرد اگر خودتان تغییر نداده اید با ما در ارتباط باشید','{newpassword},{clientid},{firstname},{lastname},{clientemail},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"After client change password\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u0631\\u0645\\u0632 \\u0639\\u0628\\u0648\\u0631 \\u0645\\u0634\\u062a\\u0631\\u06cc\"}'),
(17,'InvoicePaid','client','','مشتری گرامی {firstname} {lastname} صورتحساب {duedate} پرداخت شد شماره فاکتور {invoiceid} با تشکر از پرداخت شما','{firstname}, {lastname}, {duedate}, {total}, {invoiceid},{clientid},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"When you have paid the bill sends a message.\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u067e\\u0631\\u062f\\u0627\\u062e\\u062a \\u06cc\\u06a9 \\u0635\\u0648\\u0631\\u062a\\u062d\\u0633\\u0627\\u0628\"}'),
(18,'ClientLogin_client','client','','مشتری {firstname} {lastname} خوش امدید','{firstname},{lastname},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate},{loginip},{logintime}',0,'','{\"english\":\"After client loged in\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u0648\\u0631\\u0648\\u062f \\u0645\\u0634\\u062a\\u0631\\u06cc \\u0628\\u0647 \\u0645\\u062d\\u06cc\\u0637 \\u06a9\\u0627\\u0631\\u0628\\u0631\\u06cc\"}'),
(19,'AfterModuleUnsuspend','client','','مشتری گرامی {firstname} {lastname} سفارش شما رفع تعلیق شد {domain}','{firstname}, {lastname}, {domain},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"After module unsuspend\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u0631\\u0641\\u0639 \\u062a\\u0639\\u0644\\u06cc\\u0642 \\u06cc\\u06a9 \\u0633\\u0641\\u0627\\u0631\\u0634\"}'),
(20,'InvoiceCreated_admin','admin','9123952369,‪09128436084‬','ایجاد صورتحساب جدید: نام مشتری: {firstname} {lastname} تاریخ سررسید: {duedate} مبلغ: {total} شماره فاکتور: {invoiceid}','{firstname}, {lastname}, {duedate}, {total}, {invoiceid},{clientid},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"After invoice created\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u0627\\u06cc\\u062c\\u0627\\u062f \\u0635\\u0648\\u0631\\u062a\\u062d\\u0633\\u0627\\u0628\"}'),
(21,'InvoicePaymentReminder_secondoverdue','client','','مشتری گرامی {firstname} {lastname} دومین یادآوری صورتحساب {duedate} ایجاد شده جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}, {total}, {invoiceid},{clientid},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"Invoice payment second for first overdue\",\"persian\":\"\\u062f\\u0648\\u0645\\u06cc\\u0646 \\u06cc\\u0627\\u062f\\u0622\\u0648\\u0631\\u06cc \\u067e\\u0631\\u062f\\u0627\\u062e\\u062a \\u0635\\u0648\\u0631\\u062a\\u062d\\u0633\\u0627\\u0628 \\u0645\\u0634\\u062a\\u0631\\u06cc\"}'),
(22,'TicketUserReply_admin','admin','9123952369,‪09128436084‬','تیکت {ticketsubject} بروزرسانی شد','{firstname},{lastname},{ticketsubject},{ticketid},{ticketuniqID},{ticketmessage},{ticketurgency},{ticketservice},{ticketdepartment},{ticketreplymessage},{ticketreplyadminname},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After ticket replied by user.\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u067e\\u0627\\u0633\\u062e \\u0628\\u0647 \\u062a\\u06cc\\u06a9\\u062a \\u062a\\u0648\\u0633\\u0637 \\u06a9\\u0627\\u0631\\u0628\\u0631\"}'),
(23,'ClientEdit_clientarea','client','','مشتری گرامی {firstname} {lastname}, کد تأیید شماره همراه شما: {otp} برای درخواست # {request}.','{firstname},{lastname},{otp},{request},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After Client Edit (OTP) Mobile Verification\",\"persian\":\"\\u06a9\\u062f \\u062a\\u0623\\u06cc\\u06cc\\u062f \\u0627\\u062d\\u0631\\u0627\\u0632 \\u0647\\u0648\\u06cc\\u062a \\u067e\\u0633 \\u0627\\u0632 \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u0634\\u0645\\u0627\\u0631\\u0647 \\u0645\\u0648\\u0628\\u0627\\u06cc\\u0644 \\u0645\\u0634\\u062a\\u0631\\u06cc\"}'),
(24,'AfterRegistrarRegistrationFailed','client','','مشتری گرامی {firstname} {lastname} دامنه شما ثبت نشد جهت کسب اطلاعات بیشتر تیکت نمایید {domain}','{firstname}, {lastname}, {domain},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After domain registration failed\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062b\\u0628\\u062a \\u0646\\u0627\\u0645\\u0648\\u0641\\u0642 \\u06cc\\u06a9 \\u062f\\u0627\\u0645\\u0646\\u0647\"}'),
(25,'AcceptOrder_SMS','client','','مشتری گرامی {firstname} {lastname} سفارش شماره {orderid} شما تایید شد','{orderid},{firstname},{lastname},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"After order accepted\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062a\\u0623\\u06cc\\u06cc\\u062f \\u0633\\u0641\\u0627\\u0631\\u0634\"}'),
(26,'AfterRegistrarRenewal_admin','admin','9123952369,‪09128436084‬','دامنه تمدید شد {domain}','{firstname}, {lastname}, {domain},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"After domain renewal\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062a\\u0645\\u062f\\u06cc\\u062f \\u06cc\\u06a9 \\u062f\\u0627\\u0645\\u0646\\u0647\"}'),
(27,'TicketClose','client','','مشتری گرامی {firstname} {lastname} تیکت {ticketid} بسته شد','{firstname},{lastname},{ticketsubject},{ticketid},{ticketuniqID},{ticketmessage},{ticketurgency},{ticketservice},{ticketdepartment},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',0,'','{\"english\":\"When the ticket is closed it sends a message.\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u0628\\u0633\\u062a\\u0647 \\u0634\\u062f\\u0646 \\u062a\\u06cc\\u06a9\\u062a\"}'),
(28,'InvoicePaymentReminder_Firstoverdue','client','','مشتری گرامی {firstname} {lastname} اولین یادآوری صورتحساب {duedate} ایجاد شده جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}, {total}, {invoiceid},{clientid},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"Invoice payment reminder for first overdue\",\"persian\":\"\\u0627\\u0648\\u0644\\u06cc\\u0646 \\u06cc\\u0627\\u062f\\u0622\\u0648\\u0631\\u06cc \\u0628\\u0631\\u0627\\u06cc \\u067e\\u0631\\u062f\\u0627\\u062e\\u062a \\u0635\\u0648\\u0631\\u062a\\u062d\\u0633\\u0627\\u0628\"}'),
(29,'AfterRegistrarRegistration','client','','مشتری گرامی {firstname} {lastname} دامنه شما ثبت شد {domain}','{firstname}, {lastname}, {domain},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After domain registration\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062b\\u0628\\u062a \\u06cc\\u06a9 \\u062f\\u0627\\u0645\\u0646\\u0647\"}'),
(30,'InvoiceCreated','client','','مشتری گرامی {firstname} {lastname} صورتحساب {duedate} مبلغ {total} ایجاد شد شماره فاکتور {invoiceid} جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}, {total}, {invoiceid},{clientid},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After invoice created\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u0627\\u06cc\\u062c\\u0627\\u062f \\u0635\\u0648\\u0631\\u062a\\u062d\\u0633\\u0627\\u0628\"}'),
(31,'AdminLogin_admin','admin','9123952369,‪09128436084‬','نام کاربری {username} وارد پنل مدیریت شد','{username},{firstname},{lastname},{loginip},{logintime}',0,'','{\"english\":\"After admin loged in\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u0648\\u0631\\u0648\\u062f \\u0645\\u062f\\u06cc\\u0631\"}'),
(32,'AfterModuleChangePackage','client','','مشتری گرامی {firstname} {lastname} سفارش شما تغییر وضعیت یافت {domain}','{firstname},{lastname},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate},{domain}',0,'','{\"english\":\"After module Change Package\",\"persian\":\"\\u0628\\u0639\\u062f \\u0627\\u0632 \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u06cc\\u06a9 \\u0633\\u0641\\u0627\\u0631\\u0634\"}'),
(33,'InvoicePaymentReminder_thirdoverdue','client','','مشتری گرامی {firstname} {lastname} سومین یادآوری صورتحساب {duedate} ایجاد شده جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}, {total}, {invoiceid},{clientid},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"Invoice payment third for first overdue\",\"persian\":\"\\u0633\\u0648\\u0645\\u06cc\\u0646 \\u06cc\\u0627\\u062f\\u0622\\u0648\\u0631\\u06cc \\u067e\\u0631\\u062f\\u0627\\u062e\\u062a \\u0635\\u0648\\u0631\\u062a\\u062d\\u0633\\u0627\\u0628 \\u0645\\u0634\\u062a\\u0631\\u06cc\"}'),
(34,'AfterModuleCreate_Hosting','client','','مشتری گرامی {firstname} {lastname} سفارش شما ایجاد شد نام کاربری {username} رمز عبور {password} {domain}','{firstname}, {lastname}, {domain}, {username}, {password},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After hosting create\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u0627\\u06cc\\u062c\\u0627\\u062f \\u0647\\u0627\\u0633\\u062a\\u06cc\\u0646\\u06af\"}'),
(35,'ClientAreaRegister_clientarea','client','','مشتری گرامی {firstname} {lastname}, کد تأیید شماره همراه شما: {otp}','{firstname},{lastname},{otp},{request},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After Client Registration (OTP) Mobile Verification\",\"persian\":\"\\u06a9\\u062f \\u062a\\u0623\\u06cc\\u06cc\\u062f \\u0647\\u0648\\u06cc\\u062a \\u0648\\u0631\\u0648\\u062f \\u06a9\\u0627\\u0631\\u0628\\u0631 \\u0628\\u0647 \\u0645\\u062d\\u06cc\\u0637 \\u06a9\\u0627\\u0631\\u0628\\u0631\\u06cc\"}'),
(36,'InvoicePaid_admin','admin','9123952369,‪09128436084‬','پرداخت صورتحساب جدید: نام مشتری: {firstname} {lastname} مبلغ: {total} شماره فاکتور: {invoiceid}','{firstname}, {lastname}, {duedate}, {total}, {invoiceid},{clientid},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"When customer has paid the bill.\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u067e\\u0631\\u062f\\u0627\\u062e\\u062a \\u06cc\\u06a9 \\u0635\\u0648\\u0631\\u062a\\u062d\\u0633\\u0627\\u0628 \\u062a\\u0648\\u0633\\u0637 \\u0645\\u0634\\u062a\\u0631\\u06cc\"}'),
(37,'TicketOpen','admin','9123952369,‪09128436084‬','تیکت {ticketsubject} باز شد','{firstname},{lastname},{ticketsubject},{ticketid},{ticketuniqID},{ticketmessage},{ticketurgency},{ticketservice},{ticketdepartment},{clientid},{clientemail},{clientcompanyname},{clientcity},{clientstate}',1,'','{\"english\":\"After ticket opened\",\"persian\":\"\\u067e\\u0633 \\u0627\\u0632 \\u062b\\u0628\\u062a \\u062a\\u06cc\\u06a9\\u062a \\u062a\\u0648\\u0633\\u0637 \\u06a9\\u0627\\u0631\\u0628\\u0631\"}');
/*!40000 ALTER TABLE `mod_ippanelsms_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_litespeedRenew_allow`
--

DROP TABLE IF EXISTS `mod_litespeedRenew_allow`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_litespeedRenew_allow` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `clientid` int(11) unsigned NOT NULL DEFAULT 0,
  `serverid` int(11) unsigned NOT NULL DEFAULT 0,
  `ip` varchar(255) NOT NULL,
  `time` int(11) unsigned NOT NULL DEFAULT 0,
  `expiration` int(11) unsigned NOT NULL DEFAULT 0,
  `reason` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_litespeedRenew_allow`
--

LOCK TABLES `mod_litespeedRenew_allow` WRITE;
/*!40000 ALTER TABLE `mod_litespeedRenew_allow` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_litespeedRenew_allow` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_litespeedRenew_allow_keys`
--

DROP TABLE IF EXISTS `mod_litespeedRenew_allow_keys`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_litespeedRenew_allow_keys` (
  `key_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL DEFAULT 0,
  `server_id` int(11) unsigned NOT NULL DEFAULT 0,
  `product_id` int(11) unsigned NOT NULL DEFAULT 0,
  `key_hash` varchar(40) NOT NULL,
  `key_email` varchar(255) NOT NULL,
  `key_recipient` varchar(255) NOT NULL,
  `key_clicks_remained` int(11) unsigned NOT NULL DEFAULT 0,
  `key_expire` int(11) unsigned NOT NULL DEFAULT 0,
  `key_cancelled` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`key_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_litespeedRenew_allow_keys`
--

LOCK TABLES `mod_litespeedRenew_allow_keys` WRITE;
/*!40000 ALTER TABLE `mod_litespeedRenew_allow_keys` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_litespeedRenew_allow_keys` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_litespeedRenew_config`
--

DROP TABLE IF EXISTS `mod_litespeedRenew_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_litespeedRenew_config` (
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_litespeedRenew_config`
--

LOCK TABLES `mod_litespeedRenew_config` WRITE;
/*!40000 ALTER TABLE `mod_litespeedRenew_config` DISABLE KEYS */;
INSERT INTO `mod_litespeedRenew_config` (`name`, `value`) VALUES ('permission_firewall','1'),
('permission_unblock','1'),
('permission_allow','1'),
('permission_allowemail','1'),
('permission_aunblock','1'),
('allowlength','7'),
('allowlength_type','days'),
('checkbrute','1'),
('version_check','0'),
('version_new',''),
('servers','');
/*!40000 ALTER TABLE `mod_litespeedRenew_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_mellatverification`
--

DROP TABLE IF EXISTS `mod_mellatverification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_mellatverification` (
  `orderId` bigint(20) NOT NULL,
  `invoiceid` int(11) NOT NULL,
  `amount` bigint(20) NOT NULL,
  `date` datetime NOT NULL,
  `hashRefId` text DEFAULT NULL,
  `refId` bigint(20) DEFAULT NULL,
  `reqType` enum('Sale','Refund') NOT NULL DEFAULT 'Sale',
  `status` enum('Verified','Unknown','Unsuccess','Success') NOT NULL DEFAULT 'Unknown',
  PRIMARY KEY (`orderId`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_mellatverification`
--

LOCK TABLES `mod_mellatverification` WRITE;
/*!40000 ALTER TABLE `mod_mellatverification` DISABLE KEYS */;
INSERT INTO `mod_mellatverification` (`orderId`, `invoiceid`, `amount`, `date`, `hashRefId`, `refId`, `reqType`, `status`) VALUES (1474484353,1,2,'2016-09-21 18:59:13',NULL,NULL,'Sale','Unsuccess'),
(1474654795,2,200000,'2016-09-23 18:19:55',NULL,NULL,'Sale','Unsuccess'),
(1474654858,2,200000,'2016-09-23 18:20:58','D70D2D0890F9A4BE',NULL,'Sale','Unsuccess'),
(1474788980,2,200000,'2016-09-25 11:06:20','1E26968EA14302BA',NULL,'Sale','Unsuccess'),
(1475138583,6,220000,'2016-09-29 12:13:03','5C658B52BA0988C4',119426047707,'Sale','Success'),
(1475530373,12,10800000,'2016-10-04 01:02:53','C145D75A198BE487',119544814811,'Sale','Success'),
(1475596957,13,720000,'2016-10-04 19:32:37','07A4E11AD97AD9D9',119564163179,'Sale','Success'),
(1475781698,15,55000,'2016-10-06 22:51:38','B3BB038F030BC6B7',NULL,'Sale','Unknown'),
(1475782235,15,55000,'2016-10-06 23:00:35','FB9342BD706EDD70',119622406915,'Sale','Success'),
(1482222391,28,400000,'2016-12-20 08:26:31','0344F13E20FCB8DC',NULL,'Sale','Unsuccess'),
(1482244483,29,500000,'2016-12-20 14:34:43','2CF22EA316434AC6',NULL,'Sale','Unsuccess'),
(1482245207,29,220000,'2016-12-20 14:46:47','62639CBAE3B2A173',121116639537,'Sale','Success'),
(1485006124,4012,220000,'2017-01-21 13:42:04','B791848022ECEE47',121717778767,'Sale','Success'),
(1485595745,4016,1650000,'2017-01-28 09:29:05','1FC8E1D12DF3ED3F',NULL,'Sale','Unsuccess'),
(1485948594,4018,1350000,'2017-02-01 11:29:54','753320FDBAA86355',NULL,'Sale','Unsuccess'),
(1487409849,4022,600000,'2017-02-18 09:24:09','CF6E441425EDF1E6',NULL,'Sale','Unsuccess'),
(1487747158,4023,600000,'2017-02-22 07:05:58','A3FFE61FA42D8576',NULL,'Sale','Unsuccess'),
(1487828171,4025,600000,'2017-02-23 05:36:11','62E664E32FBB30FD',NULL,'Sale','Unsuccess'),
(1487844337,4023,600000,'2017-02-23 10:05:37','F0F0AA8509B1D98E',122373319367,'Sale','Success'),
(1489385529,4029,1400000,'2017-03-13 06:12:09','CBDBC8AECD7096FA',NULL,'Sale','Unsuccess'),
(1490184502,4031,600000,'2017-03-22 12:08:22','C6454560F1FE6496',NULL,'Sale','Unsuccess'),
(1490184791,4031,450000,'2017-03-22 12:13:11','CE61CE61BE3A6957',123043501299,'Sale','Success'),
(1491070494,4032,13500000,'2017-04-01 22:44:54','BDE9AE544074C6BB',123216404256,'Sale','Success'),
(1493112031,4045,1300000,'2017-04-25 13:50:31','68A387A6DDFD16A2',NULL,'Sale','Unsuccess'),
(1497783121,4054,9500000,'2017-06-18 15:22:01',NULL,NULL,'Sale','Unsuccess'),
(1497783163,4054,9500000,'2017-06-18 15:22:43',NULL,NULL,'Sale','Unsuccess'),
(1497783200,4054,9500000,'2017-06-18 15:23:20',NULL,NULL,'Sale','Unsuccess'),
(1497801885,4054,9500000,'2017-06-18 20:34:45','A92B78F1446921F0',NULL,'Sale','Unsuccess'),
(1497803821,4054,9500000,'2017-06-18 21:07:01','03B5CA6E47D70D5E',124861881870,'Sale','Success'),
(1499075350,4056,600000,'2017-07-03 14:19:10','6D838ABFAD577B7B',NULL,'Sale','Unsuccess'),
(1499075607,4056,400000,'2017-07-03 14:23:27','126B3F82BCCF4B39',125307817727,'Sale','Success'),
(1503250384,4063,600000,'2017-08-20 22:03:04','55E6594531F84B28',NULL,'Sale','Unsuccess'),
(1503408282,4063,400000,'2017-08-22 17:54:42','64474BBCBD43F991',126897542446,'Sale','Success'),
(1504796157,4067,530000,'2017-09-07 19:25:57','C5EEFCFFEA1FF7E2',127422656067,'Sale','Success'),
(1506630937,4074,18000000,'2017-09-29 00:05:37','5120A968FF901518',128113707605,'Sale','Success'),
(1514053270,4017,3850000,'2017-12-23 21:51:10','A61E157F7CD5C756',NULL,'Sale','Unsuccess'),
(1515780410,4076,2750000,'2018-01-12 21:36:50','2E0A902EFC469307',NULL,'Sale','Unsuccess'),
(1519408753,4102,10000,'2018-02-23 21:29:13','A9CA624F234CA870',NULL,'Sale','Unsuccess'),
(1519622474,4090,472500,'2018-02-26 08:51:14','A067D0BE5EC5A350',132967123065,'Sale','Success'),
(1521999765,4109,18000000,'2018-03-25 22:12:45','0F50439D59A39A99',134042701758,'Sale','Success'),
(1521999977,4110,12000000,'2018-03-25 22:16:17','826332D7C5CC54C1',134042821012,'Sale','Success'),
(1523026034,4104,1470000,'2018-04-06 19:17:14','4E89F514F01E7E88',NULL,'Sale','Unsuccess'),
(1523026535,4115,350000,'2018-04-06 19:25:35','95442BF70B373712',NULL,'Sale','Unsuccess'),
(1523029286,4116,145000,'2018-04-06 20:11:26','D68BC1A5562CC2B3',NULL,'Sale','Unsuccess'),
(1523029478,4116,145000,'2018-04-06 20:14:38','8836EF6A3E4CFC4C',134409435827,'Sale','Success'),
(1524412085,4123,230000,'2018-04-22 20:18:05','15732B4ED3C97EB5',134951283451,'Sale','Success'),
(1527084630,4128,6000000,'2018-05-23 18:40:30','EE962C632CC981D8',136047576618,'Sale','Success'),
(1528010550,4132,450000,'2018-06-03 11:52:30','CB5C65EB0320D476',136424293476,'Sale','Success'),
(1528919634,4138,500000,'2018-06-14 00:23:54',NULL,NULL,'Sale','Unknown'),
(1528919702,4138,500000,'2018-06-14 00:25:02','296598DDF783DB51',136786637532,'Sale','Success'),
(1529137799,4135,16500000,'2018-06-16 12:59:59','E52AF0B42CF06EE7',136869112684,'Sale','Success'),
(1530625885,4140,650000,'2018-07-03 18:21:25','6DF45341517D29F0',137535993725,'Sale','Success'),
(1534144552,4151,500000,'2018-08-13 11:45:52','629228217C6AB564',NULL,'Sale','Unknown'),
(1534144553,4151,500000,'2018-08-13 11:45:53','3C72EC385531FE29',139080568709,'Sale','Success'),
(1535567686,4157,500000,'2018-08-29 23:04:46','2D9320F729D0B374',139746349374,'Sale','Success'),
(1538123307,4165,18000000,'2018-09-28 11:58:27','7CDF47E38F5171FD',140882690816,'Sale','Success'),
(1541093195,4176,10000,'2018-11-01 20:56:35','9D7D91D8E1CC7E11',NULL,'Sale','Unsuccess'),
(1541611970,4183,10000,'2018-11-07 21:02:50','D4AE238B53D5B53F',NULL,'Sale','Unsuccess'),
(1541661638,4171,390000,'2018-11-08 10:50:38','91EAFA1B82E4A18E',142486672299,'Sale','Success'),
(1541707963,4183,10000,'2018-11-08 23:42:43','847BD9D09C7F6603',142514072099,'Sale','Success'),
(1541765304,4185,10000,'2018-11-09 15:38:24','05BE6F0A4CE01D4E',NULL,'Sale','Unsuccess'),
(1543250557,4191,1000,'2018-11-26 20:12:37','F5CDE310512AC334',NULL,'Sale','Unknown'),
(1543385282,4189,500000,'2018-11-28 09:38:02','D17E9A6E89E0034D',143291893296,'Sale','Success'),
(1545817827,4199,500000,'2018-12-26 13:20:27','7914FEB9A6306670',144432572542,'Sale','Success'),
(1548166688,4202,500000,'2019-01-22 17:48:08','E23133498FB6D226',145534395396,'Sale','Success'),
(1550127994,4207,3500000,'2019-02-14 10:36:34','6BDE6CDB6C31CF91',146489109108,'Sale','Success'),
(1551277185,4208,46990822,'2019-02-27 17:49:45','89D57A732B18B4CE',147114633376,'Sale','Success'),
(1551345561,4209,5450000,'2019-02-28 12:49:21','0B8C9F45A5D5E43B',147149477455,'Sale','Success');
/*!40000 ALTER TABLE `mod_mellatverification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_onlinenic`
--

DROP TABLE IF EXISTS `mod_onlinenic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_onlinenic` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL,
  `lockstatus` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `domainid` (`domain`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_onlinenic`
--

LOCK TABLES `mod_onlinenic` WRITE;
/*!40000 ALTER TABLE `mod_onlinenic` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_onlinenic` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_pageseo`
--

DROP TABLE IF EXISTS `mod_pageseo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_pageseo` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `page` text NOT NULL,
  `keywords` text NOT NULL,
  `description` text NOT NULL,
  `activated` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_pageseo`
--

LOCK TABLES `mod_pageseo` WRITE;
/*!40000 ALTER TABLE `mod_pageseo` DISABLE KEYS */;
INSERT INTO `mod_pageseo` (`id`, `title`, `page`, `keywords`, `description`, `activated`) VALUES (1,'صفحه اصلی - ستنرال هاست | فروش هاست | فروش دامنه | فروش SSL','https://cl.keloncloud.com/','صفحه اصلی - ستنرال هاست | فروش هاست | فروش دامنه | فروش SSL','صفحه اصلی - ستنرال هاست | فروش هاست | فروش دامنه | فروش SSL','0'),
(2,' گواهینامه امنیتی از Comodo - Comodo SSL certificate','https://cl.keloncloud.com/cart.php?gid=18',' گواهینامه امنیتی از Comodo - Comodo SSL certificate','\r\nگواهینامه امنیتی از Comodo - Comodo SSL certificate\r\n','0');
/*!40000 ALTER TABLE `mod_pageseo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_pleskaccounts`
--

DROP TABLE IF EXISTS `mod_pleskaccounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_pleskaccounts` (
  `userid` int(11) NOT NULL,
  `usertype` varchar(255) NOT NULL,
  `panelexternalid` varchar(255) NOT NULL,
  PRIMARY KEY (`userid`,`usertype`),
  KEY `mod_pleskaccounts_usertype_index` (`usertype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_pleskaccounts`
--

LOCK TABLES `mod_pleskaccounts` WRITE;
/*!40000 ALTER TABLE `mod_pleskaccounts` DISABLE KEYS */;
INSERT INTO `mod_pleskaccounts` (`userid`, `usertype`, `panelexternalid`) VALUES (1,'hostingaccount','90387195-7035-48f7-b79c-8e47f2cb848b'),
(32,'hostingaccount','c22a95ef-a4ae-4fe2-b77c-79f225bb9c53'),
(43,'hostingaccount','98e380d6-307c-4674-909d-4d7d1546298f'),
(44,'hostingaccount','9e74c499-ed0e-4333-89dc-214a975e13eb'),
(51,'hostingaccount','f752693e-bdbd-4fcf-8a8a-fce262eb8b9c'),
(71,'hostingaccount','0b3a193d-7355-4677-8db5-7e0a5503a794'),
(162,'hostingaccount','09fdc32d-9566-465f-be09-f7066f72fe73'),
(208,'hostingaccount','43f1906f-1801-4fc4-aff4-6e7b9bc67b9f'),
(243,'hostingaccount','ee600b8e-7fdf-49e7-b073-5e055b22499e'),
(120,'hostingaccount','18f47a85-9995-4902-bb58-fda847e8052e');
/*!40000 ALTER TABLE `mod_pleskaccounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_poshtibaniwebsms_messages`
--

DROP TABLE IF EXISTS `mod_poshtibaniwebsms_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_poshtibaniwebsms_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender` varchar(40) NOT NULL,
  `to` varchar(15) DEFAULT NULL,
  `text` text DEFAULT NULL,
  `msgid` varchar(50) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `errors` text DEFAULT NULL,
  `logs` text DEFAULT NULL,
  `user` int(11) DEFAULT NULL,
  `datetime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_poshtibaniwebsms_messages`
--

LOCK TABLES `mod_poshtibaniwebsms_messages` WRITE;
/*!40000 ALTER TABLE `mod_poshtibaniwebsms_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_poshtibaniwebsms_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_poshtibaniwebsms_settings`
--

DROP TABLE IF EXISTS `mod_poshtibaniwebsms_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_poshtibaniwebsms_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `apiparams` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `wantsmsfield` int(11) DEFAULT NULL,
  `gsmnumberfield` int(11) DEFAULT NULL,
  `dateformat` varchar(12) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `version` varchar(6) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `verifyforce` int(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_poshtibaniwebsms_settings`
--

LOCK TABLES `mod_poshtibaniwebsms_settings` WRITE;
/*!40000 ALTER TABLE `mod_poshtibaniwebsms_settings` DISABLE KEYS */;
INSERT INTO `mod_poshtibaniwebsms_settings` (`id`, `api`, `apiparams`, `wantsmsfield`, `gsmnumberfield`, `dateformat`, `version`, `verifyforce`) VALUES (1,'','',0,0,'%d.%m.%y','1.1.3',1);
/*!40000 ALTER TABLE `mod_poshtibaniwebsms_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_poshtibaniwebsms_templates`
--

DROP TABLE IF EXISTS `mod_poshtibaniwebsms_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_poshtibaniwebsms_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `type` enum('client','admin') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `admingsm` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `template` varchar(240) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `variables` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `extra` varchar(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_poshtibaniwebsms_templates`
--

LOCK TABLES `mod_poshtibaniwebsms_templates` WRITE;
/*!40000 ALTER TABLE `mod_poshtibaniwebsms_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_poshtibaniwebsms_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_poshtibaniwebsms_verifyuser`
--

DROP TABLE IF EXISTS `mod_poshtibaniwebsms_verifyuser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_poshtibaniwebsms_verifyuser` (
  `vuid` int(11) NOT NULL AUTO_INCREMENT,
  `client_id_fk` int(11) NOT NULL,
  `verifycode` int(11) DEFAULT NULL,
  `status` int(3) DEFAULT NULL,
  `datetime` datetime NOT NULL,
  `sendednumber` bigint(15) NOT NULL,
  PRIMARY KEY (`vuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_poshtibaniwebsms_verifyuser`
--

LOCK TABLES `mod_poshtibaniwebsms_verifyuser` WRITE;
/*!40000 ALTER TABLE `mod_poshtibaniwebsms_verifyuser` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_poshtibaniwebsms_verifyuser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_sabaSMS_messages`
--

DROP TABLE IF EXISTS `mod_sabaSMS_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_sabaSMS_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender` varchar(40) NOT NULL,
  `to` varchar(15) DEFAULT NULL,
  `text` text DEFAULT NULL,
  `msgid` varchar(50) DEFAULT NULL,
  `status` varchar(10) DEFAULT NULL,
  `errors` text DEFAULT NULL,
  `logs` text DEFAULT NULL,
  `user` int(11) DEFAULT NULL,
  `datetime` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_sabaSMS_messages`
--

LOCK TABLES `mod_sabaSMS_messages` WRITE;
/*!40000 ALTER TABLE `mod_sabaSMS_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_sabaSMS_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_sabaSMS_settings`
--

DROP TABLE IF EXISTS `mod_sabaSMS_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_sabaSMS_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `api` varchar(40) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `apiparams` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `wantsmsfield` int(11) DEFAULT NULL,
  `gsmnumberfield` int(11) DEFAULT NULL,
  `dateformat` varchar(12) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `version` varchar(6) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `verifyforce` int(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_sabaSMS_settings`
--

LOCK TABLES `mod_sabaSMS_settings` WRITE;
/*!40000 ALTER TABLE `mod_sabaSMS_settings` DISABLE KEYS */;
INSERT INTO `mod_sabaSMS_settings` (`id`, `api`, `apiparams`, `wantsmsfield`, `gsmnumberfield`, `dateformat`, `version`, `verifyforce`) VALUES (1,'sabaSMS','{\"senderid\":\"5000145\",\"signature\":\"central-host\"}',0,3,'%d.%m.%y','1.1.3',0);
/*!40000 ALTER TABLE `mod_sabaSMS_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_sabaSMS_templates`
--

DROP TABLE IF EXISTS `mod_sabaSMS_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_sabaSMS_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `type` enum('client','admin') CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `admingsm` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `template` varchar(240) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `variables` varchar(500) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `active` tinyint(1) NOT NULL,
  `extra` varchar(3) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_sabaSMS_templates`
--

LOCK TABLES `mod_sabaSMS_templates` WRITE;
/*!40000 ALTER TABLE `mod_sabaSMS_templates` DISABLE KEYS */;
INSERT INTO `mod_sabaSMS_templates` (`id`, `name`, `type`, `admingsm`, `template`, `variables`, `active`, `extra`, `description`) VALUES (1,'InvoiceCreation','client','','مشتری گرامی {firstname} {lastname} صورتحساب {duedate} مبلغ {total} ایجاد شد شماره فاکتور {invoiceid} جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}, {total}, {invoiceid}',0,'','{\"english\":\"After invoice created\"}'),
(2,'AfterRegistrarRenewal','client','','مشتری گرامی {firstname} {lastname} دامنه شما تمدید شد {domain}','{firstname},{lastname},{domain}',0,'','{\"english\":\"After domain renewal\"}'),
(3,'InvoicePaid','client','','مشتری گرامی {firstname} {lastname} صورتحساب {duedate} پرداخت شد شماره فاکتور {invoiceid} با تشکر از پرداخت شما','{firstname}, {lastname}, {duedate},{invoiceid}',0,'','{\"english\":\"Whenyou have paidthe billsends a message.\"}'),
(4,'AdminLogin_admin','admin','','نام کاربری {username} وارد پنل مدیریت شد','{username}',0,'','null'),
(5,'ClientChangePassword','client','','مشتری گرامی {firstname} {lastname} رمز شما تغییر کرد اگر خودتان تغییر نداده اید با ما در ارتباط باشید','{firstname},{lastname}',0,'','{\"english\":\"After client change password\"}'),
(6,'TicketOpen_admin','admin','','تیکت {subject} باز شد','{subject}',0,'','null'),
(7,'AcceptOrder_SMS','client','','مشتری گرامی {firstname} {lastname} سفارش شماره {orderid} شما تایید شد','{firstname},{lastname},{orderid}',0,'','{\"english\":\"After order accepted\"}'),
(8,'InvoiceCreated','client','','مشتری گرامی {firstname} {lastname} صورتحساب {duedate} مبلغ {total} ایجاد شد شماره فاکتور {invoiceid} جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}, {total}, {invoiceid}',0,'','{\"english\":\"After invoice created\"}'),
(9,'TicketClose','client','','مشتری گرامی {firstname} {lastname} تیکت {ticketno} بسته شد','{firstname}, {lastname}, {ticketno}',0,'','{\"english\":\"When the ticket is closed it sends a message.\"}'),
(10,'InvoicePaymentReminder_thirdoverdue','client','','مشتری گرامی {firstname} {lastname} سومین یادآوری صورتحساب {duedate} ایجاد شده جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}',0,'','{\"english\":\"Invoice payment third for first overdue\"}'),
(11,'ClientLogin_admin','admin','','مشتری {firstname} {lastname} وارد ناحیه کاربری شد','{firstname},{lastname}',0,'','null'),
(12,'InvoicePaymentReminder_Firstoverdue','client','','مشتری گرامی {firstname} {lastname} اولین یادآوری صورتحساب {duedate} ایجاد شده جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}',0,'','{\"english\":\"Invoice payment reminder for first overdue\"}'),
(13,'AfterRegistrarRegistration_admin','admin','','دامنه جدید ثبت شد {domain}','{domain}',0,'','null'),
(14,'AfterModuleChangePackage','client','','مشتری گرامی {firstname} {lastname} سفارش شما تغییر وضعیت یافت {domain}','{firstname},{lastname},{domain}',0,'','{\"english\":\"After module Change Package\"}'),
(15,'AfterRegistrarRegistrationFailed','client','','مشتری گرامی {firstname} {lastname} دامنه شما ثبت نشد جهت کسب اطلاعات بیشتر تیکت نمایید {domain}','{firstname},{lastname},{domain}',0,'','{\"english\":\"After domain registration failed\"}'),
(16,'AfterRegistrarRegistration','client','','مشتری گرامی {firstname} {lastname} دامنه شما ثبت شد {domain}','{firstname},{lastname},{domain}',0,'','{\"english\":\"After domain registration\"}'),
(17,'AfterRegistrarRegistrationFailed_admin','admin','','دامنه جدید ثبت نشد {domain}','{domain}',0,'','null'),
(18,'DomainRenewalNotice','client','','مشتری گرامی {firstname} {lastname} دامنه شما {x} روز دیگر منقضی می شود جهت تمدید به سایت مراجعه کنید تاریخ انقضا {expirydate} {domain}','{firstname}, {lastname}, {domain},{expirydate},{x}',0,'15','{\"english\":\"Donmain renewal notice before {x} days ago\"}'),
(19,'AfterModuleSuspend','client','','مشتری گرامی {firstname} {lastname} سفارش شما تعلیق شد {domain}','{firstname},{lastname},{domain}',0,'','{\"english\":\"After module suspended\"}'),
(20,'TicketAdminReply','client','','مشتری گرامی {firstname} {lastname} تیکت {ticketsubject} پاسخ داده شد','{firstname},{lastname},{ticketsubject}',0,'','{\"english\":\"After ticket replied by admin\"}'),
(21,'AfterModuleUnsuspend','client','','مشتری گرامی {firstname} {lastname} سفارش شما رفع تعلیق شد {domain}','{firstname},{lastname},{domain}',0,'','{\"english\":\"After module unsuspend\"}'),
(22,'InvoicePaymentReminder_Reminder','client','','مشتری گرامی {firstname} {lastname} صورتحساب {duedate} ایجاد شد جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}',0,'','{\"english\":\"Invoice payment reminder\"}'),
(23,'AfterRegistrarRenewal_admin','admin','','دامنه تمدید شد {domain}','{domain}',0,'','null'),
(24,'AfterRegistrarRenewalFailed_admin','admin','','دامنه تمدید نشد {domain}','{domain}',0,'','null'),
(25,'AfterModuleCreate_Hosting','client','','مشتری گرامی {firstname} {lastname} سفارش شما ایجاد شد نام کاربری {username} رمز عبور {password} {domain}','{firstname}, {lastname}, {domain}, {username}, {password}',0,'','{\"english\":\"After hosting create\"}'),
(26,'ClientAdd_admin','admin','','ثبت نام جدید انجام شد','',0,'','null'),
(27,'ClientAdd','client','','مشتری گرامی {firstname} {lastname} ثبت نام شما انجام شد ایمیل {email} رمز عبور {password}','{firstname},{lastname},{email},{password}',0,'','{\"english\":\"After client register\"}'),
(28,'TicketUserReply_admin','admin','','تیکت {subject} بروزرسانی شد','{subject}',0,'','null'),
(29,'InvoicePaymentReminder_secondoverdue','client','','مشتری گرامی {firstname} {lastname} دومین یادآوری صورتحساب {duedate} ایجاد شده جهت پرداخت به سایت مراجعه کنید','{firstname}, {lastname}, {duedate}',0,'','{\"english\":\"Invoice payment second for first overdue\"}'),
(30,'AfterModuleChangePassword','client','','مشتری گرامی {firstname} {lastname} سفارش شما تغییر رمز یافت نام کاربری {username} رمز عبور {password} {domain}','{firstname}, {lastname}, {domain}, {username}, {password}',0,'','{\"english\":\"After module change password\"}');
/*!40000 ALTER TABLE `mod_sabaSMS_templates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_sabaSMS_verifyuser`
--

DROP TABLE IF EXISTS `mod_sabaSMS_verifyuser`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_sabaSMS_verifyuser` (
  `vuid` int(11) NOT NULL AUTO_INCREMENT,
  `client_id_fk` int(11) NOT NULL,
  `verifycode` int(11) DEFAULT NULL,
  `status` int(3) DEFAULT NULL,
  `datetime` datetime NOT NULL,
  `sendednumber` bigint(15) NOT NULL,
  PRIMARY KEY (`vuid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_sabaSMS_verifyuser`
--

LOCK TABLES `mod_sabaSMS_verifyuser` WRITE;
/*!40000 ALTER TABLE `mod_sabaSMS_verifyuser` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_sabaSMS_verifyuser` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_smsaddon`
--

DROP TABLE IF EXISTS `mod_smsaddon`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_smsaddon` (
  `id` bigint(255) NOT NULL AUTO_INCREMENT,
  `new_bill` tinyint(1) NOT NULL DEFAULT 0,
  `changepass` tinyint(1) NOT NULL DEFAULT 0,
  `orders` tinyint(1) NOT NULL DEFAULT 0,
  `newticket` tinyint(1) NOT NULL DEFAULT 0,
  `ticketreply` tinyint(1) NOT NULL DEFAULT 0,
  `ordersadmin` tinyint(1) NOT NULL DEFAULT 0,
  `newticketadmin` tinyint(1) NOT NULL DEFAULT 0,
  `ticketreplyadmin` tinyint(1) NOT NULL DEFAULT 0,
  `adminmobile` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `businessname` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `sender` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `mobilenumberfield` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `notificationfield` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `username` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `password` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `no_area` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `senderforce` tinyint(1) NOT NULL DEFAULT 0,
  `modulecreate` tinyint(1) NOT NULL DEFAULT 0,
  `modulecreatetext` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `passwordchangetxt` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `ticketopentxtclient` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `ticketopentxtadmin` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `ticketreplytext` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `ticketreplytextadmin` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `ordertextclient` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `ordertextadmin` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `invoicetextclient` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `numbercorrection` tinyint(1) NOT NULL DEFAULT 0,
  `countrycode` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `leadingzeros` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `logsperpage` bigint(255) DEFAULT 50,
  `domainxdays` bigint(255) DEFAULT 0,
  `domainxdaystext` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `modulesuspend` tinyint(1) NOT NULL DEFAULT 0,
  `modulesuspendtext` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `dueinvoice` tinyint(1) NOT NULL DEFAULT 0,
  `dueinvoicetext` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `urgency1` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `urgency2` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `urgency3` longtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_smsaddon`
--

LOCK TABLES `mod_smsaddon` WRITE;
/*!40000 ALTER TABLE `mod_smsaddon` DISABLE KEYS */;
INSERT INTO `mod_smsaddon` (`id`, `new_bill`, `changepass`, `orders`, `newticket`, `ticketreply`, `ordersadmin`, `newticketadmin`, `ticketreplyadmin`, `adminmobile`, `businessname`, `sender`, `mobilenumberfield`, `notificationfield`, `username`, `password`, `no_area`, `senderforce`, `modulecreate`, `modulecreatetext`, `passwordchangetxt`, `ticketopentxtclient`, `ticketopentxtadmin`, `ticketreplytext`, `ticketreplytextadmin`, `ordertextclient`, `ordertextadmin`, `invoicetextclient`, `numbercorrection`, `countrycode`, `leadingzeros`, `logsperpage`, `domainxdays`, `domainxdaystext`, `modulesuspend`, `modulesuspendtext`, `dueinvoice`, `dueinvoicetext`, `urgency1`, `urgency2`, `urgency3`) VALUES (1,1,0,0,1,1,1,1,0,'09123952369',NULL,'50002346997','شماره موبایل','عدم دریافت پیامک','d.hammedsadeghie','Hammed23','بله',0,0,'سرويس {domain} فعال گرديده است. لطفا ايميل خود را چک کنيد.','کلمه عبور شما به روزرسانی گرديد. آدرس ايميل شما: {emailaddress}. کلمه رمز: {password}.','کاربر محترم {clientname} تيکت شما با عنوان {subject} دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.','کاربر با نام {clientname} در شاخه {department} اقدام به بازکردن تيکت جديد با عنوان {subject} نموده است.','تيکت با عنوان {subject} به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.','کاربر با نام {clientname} در شاخه {department} اقدام به ارسال پاسخ در تيکت با عنوان {subject} نموده است.','کاربر گرامی از سفارش شما به ارزش {amount}  ریال سپاس گزاريم. تاريخ سررسيد سفارش {duedate}.','سفارش جديد به ارزش {amount} به تاريخ سررسيد {duedate} ثبت گرديده است.','صورت حساب جديدی با تاريخ سررسيد {duedate} و به ارزش {amount} برای شما ايجاد گرديده است.',0,NULL,NULL,50,7,'{domain} طی {remainingdays} روز آينده منقضی ميگردد.',0,'{domain} به وضعيت تعليق در آمده است. لطفا جهت رفع هرچه سريعتر مشکل با ما تماس بگيريد.',1,'ُسفارش شما به ارزش {amount} در تاريخ {duedate} منقضی گرديد.','1','1','1');
/*!40000 ALTER TABLE `mod_smsaddon` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_smsaddon_logs`
--

DROP TABLE IF EXISTS `mod_smsaddon_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_smsaddon_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` varchar(500) NOT NULL,
  `client` varchar(500) NOT NULL,
  `mobilenumber` varchar(500) NOT NULL,
  `result` varchar(5500) NOT NULL,
  `text` varchar(5000) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=555 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_smsaddon_logs`
--

LOCK TABLES `mod_smsaddon_logs` WRITE;
/*!40000 ALTER TABLE `mod_smsaddon_logs` DISABLE KEYS */;
INSERT INTO `mod_smsaddon_logs` (`id`, `time`, `client`, `mobilenumber`, `result`, `text`) VALUES (1,'1556390925','admin','09123952369','0','سفارش جديد به ارزش 8200000.00 به تاريخ سررسيد 05/04/2019 ثبت گرديده است.'),
(2,'1557737804','admin','09123952369','0','سفارش جديد به ارزش 1800000.00 به تاريخ سررسيد 05/20/2019 ثبت گرديده است.'),
(3,'1557818248','admin','09123952369','0','سفارش جديد به ارزش 1800000.00 به تاريخ سررسيد 05/21/2019 ثبت گرديده است.'),
(4,'1558106897','admin','09123952369','0','سفارش جديد به ارزش 200000.00 به تاريخ سررسيد 05/24/2019 ثبت گرديده است.'),
(5,'1558195600','admin','09123952369','0','سفارش جديد به ارزش 0.00 به تاريخ سررسيد 05/25/2019 ثبت گرديده است.'),
(6,'1558324873','admin','09123952369','0','سفارش جديد به ارزش 3600000.00 به تاريخ سررسيد 05/27/2019 ثبت گرديده است.'),
(7,'1558589816','??? ?? (????? ???)','09123952369','Caught exception: Value cannot be null.\r\nParameter name: value\n','تست '),
(8,'1558590632','??? ?? (????? ???)','09123952369','Caught exception: Value cannot be null.\r\nParameter name: value\n','تستس'),
(9,'1558591464','??? ?? (????? ???)','09123952369','','تست'),
(10,'1558591509','??? ?? (????? ???)','09123952369','','تست'),
(11,'1558591903','??? ?? (????? ???)','09123952369','','تست'),
(12,'1558770210','??? ?? (????? ???)','09123952369','','تست ارسال '),
(13,'1558770247','??? ?? (????? ???)','09123952369','','تست'),
(14,'1559437313','8','','','ُسفارش شما به ارزش 1900000.00 در تاريخ 06/01/2019 منقضی گرديد.'),
(15,'1559437314','1','','','ُسفارش شما به ارزش 400000.00 در تاريخ 06/01/2019 منقضی گرديد.'),
(16,'1559489340','??? ?? (????? ???)','09123952369','','test module'),
(17,'1559489549','??? ?? (????? ???)','09123952369','','test'),
(18,'1559489666','??? ?? (????? ???)','09123952369','9','test '),
(19,'1559490680','1','09123952369','113760665','test'),
(20,'1559490749','1','09123952369','113760676','test'),
(21,'1559490783','1','09123952369','113760682','testmodule'),
(22,'1559523628','3','','113763016','ُسفارش شما به ارزش 1900000.00 در تاريخ 06/02/2019 منقضی گرديد.'),
(23,'1559782929','11','','113806161','صورت حساب جديدی با تاريخ سررسيد 06/13/2019 و به ارزش 1900000.00 برای شما ايجاد گرديده است.'),
(24,'1560128493','6','','113868069','صورت حساب جديدی با تاريخ سررسيد 06/17/2019 و به ارزش 23500000.00 برای شما ايجاد گرديده است.'),
(25,'1560214850','1','','113889595','ُسفارش شما به ارزش 100000.00 در تاريخ 06/10/2019 منقضی گرديد.'),
(26,'1560387654','11','','113922262','ُسفارش شما به ارزش 1900000.00 در تاريخ 06/12/2019 منقضی گرديد.'),
(27,'1560474101','13','','113937940','صورت حساب جديدی با تاريخ سررسيد 06/21/2019 و به ارزش 1900000.00 برای شما ايجاد گرديده است.'),
(28,'1560601989','admin','09123952369','113962781','سفارش جديد به ارزش 2300000.00 به تاريخ سررسيد 06/22/2019 ثبت گرديده است.'),
(29,'1560733258','11','','113983301','ُسفارش شما به ارزش 1900000.00 در تاريخ 06/16/2019 منقضی گرديد.'),
(30,'1560819692','11','','113999304','ُسفارش شما به ارزش 200000.00 در تاريخ 06/17/2019 منقضی گرديد.'),
(31,'1560992491','3','','114032041','صورت حساب جديدی با تاريخ سررسيد 06/27/2019 و به ارزش 500000.00 برای شما ايجاد گرديده است.'),
(32,'1561251652','4','','114073323','ُسفارش شما به ارزش 2000000.00 در تاريخ 06/22/2019 منقضی گرديد.'),
(33,'1561251654','24','','114073324','ُسفارش شما به ارزش 2300000.00 در تاريخ 06/22/2019 منقضی گرديد.'),
(34,'1561394390','admin','09123952369','114114323','سفارش جديد به ارزش 3600000.00 به تاريخ سررسيد 07/01/2019 ثبت گرديده است.'),
(35,'1562029292','14','','114765851','ُسفارش شما به ارزش 3600000.00 در تاريخ 07/01/2019 منقضی گرديد.'),
(36,'1562426272','1','09123952369','114850557','jsjs'),
(37,'1562655573','admin','09123952369','114903732','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان دریافت نکردن کد تایید شماره موبایل و وارد نشدن به سی پنل  نموده است.'),
(38,'1562668421','admin','09123952369','114910057','سفارش جديد به ارزش 1800000.00 به تاريخ سررسيد 07/16/2019 ثبت گرديده است.'),
(39,'1563015582','admin','09123952369','114971602','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان پاک کردن فایل اضافی نموده است.'),
(40,'1563238827','8','09128685061','115014394','ُسفارش شما به ارزش 12000000.00 در تاريخ 07/15/2019 منقضی گرديد.'),
(41,'1563584448','3','','7','صورت حساب جديدی با تاريخ سررسيد 07/27/2019 و به ارزش 500000.00 برای شما ايجاد گرديده است.'),
(42,'1563613183','??? ?? (????? ???)','?????','115067255','ظزطزط'),
(43,'1563615165','??? ?? (????? ???)','09123952369','115067458','بلابل'),
(44,'1563618660','1','09123952369','7','کاربر محترم حامد صادقی تيکت شما با عنوان فثسف دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(45,'1563618660','admin','09123952369','115067665','کاربر با نام حامد صادقی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان فثسف نموده است.'),
(46,'1563618725','1','09123952369','115067669','تيکت با عنوان فثسف به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(47,'1563619045','1','09123952369','7','کاربر محترم حامد صادقی تيکت شما با عنوان hgjjg دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(48,'1563619046','admin','09123952369','115067692','کاربر با نام حامد صادقی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان hgjjg نموده است.'),
(49,'1563619069','1','09123952369','115067693','تيکت با عنوان hgjjg به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(50,'1563619543','1','09123952369','7','کاربر محترم حامد صادقی تيکت شما با عنوان sdfdsf دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(51,'1563619543','admin','09123952369','115067717','کاربر با نام حامد صادقی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان sdfdsf نموده است.'),
(52,'1563619614','1','09123952369','115067720','تيکت با عنوان sdfdsf به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(53,'1563620577','1','09123952369','7','کاربر محترم حامد صادقی تيکت شما با عنوان sdfdsf دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(54,'1563620577','admin','09123952369','115067784','کاربر با نام حامد صادقی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان sdfdsf نموده است.'),
(55,'1563620682','1','09123952369','115067790','تيکت با عنوان sdfdsf به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(56,'1563789600','1','09123952369','7','کاربر محترم حامد صادقی تيکت شما با عنوان تیتی دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(57,'1563789600','admin','09123952369','115080245','کاربر با نام حامد صادقی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان تیتی نموده است.'),
(58,'1563843712','4','09121086336','7','ُسفارش شما به ارزش 2000000.00 در تاريخ 07/22/2019 منقضی گرديد.'),
(59,'1564102841','20','9383194723','7','صورت حساب جديدی با تاريخ سررسيد 08/02/2019 و به ارزش 4900000.00 برای شما ايجاد گرديده است.'),
(60,'1564275652','3','','7','ُسفارش شما به ارزش 500000.00 در تاريخ 07/27/2019 منقضی گرديد.'),
(61,'1564794052','20','9383194723','7','ُسفارش شما به ارزش 4900000.00 در تاريخ 08/02/2019 منقضی گرديد.'),
(62,'1564988559','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان مشخصات دامین ثبت شده  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(63,'1564988559','admin','09123952369','115289836','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان مشخصات دامین ثبت شده  نموده است.'),
(64,'1564991199','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان ای پی سرور دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(65,'1564991199','admin','09123952369','115290363','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان ای پی سرور نموده است.'),
(66,'1565001981','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان سی پنل  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(67,'1565001982','admin','09123952369','115292324','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان سی پنل  نموده است.'),
(68,'1565101979','25','09121751503','115307109','تيکت با عنوان مشخصات دامین ثبت شده  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(69,'1565102000','25','09121751503','115307114','تيکت با عنوان ای پی سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(70,'1565102048','25','09121751503','115307118','تيکت با عنوان سی پنل  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(71,'1565106077','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان پاک کردن کل هاست دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(72,'1565106078','admin','09123952369','115307676','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان پاک کردن کل هاست نموده است.'),
(73,'1565111036','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان حذف تمامی یوزر های سی پنل و خرید حجم  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(74,'1565111036','admin','09123952369','115308431','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان حذف تمامی یوزر های سی پنل و خرید حجم  نموده است.'),
(75,'1565112456','25','09121751503','115308615','تيکت با عنوان پاک کردن کل هاست [ادغام شدند] به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(76,'1565149752','25','09121751503','115310315','تيکت با عنوان پاک کردن کل هاست [ادغام شدند] به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(77,'1565160893','25','09121751503','115313931','تيکت با عنوان پاک کردن کل هاست [ادغام شدند] به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(78,'1565201264','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان ارور http500 دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(79,'1565201264','admin','09123952369','115320991','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان ارور http500 نموده است.'),
(80,'1565201733','25','09121751503','115321034','تيکت با عنوان ارور http500 به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(81,'1565293635','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان انتقال وب سایت دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(82,'1565293635','admin','09123952369','7','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان انتقال وب سایت نموده است.'),
(83,'1565296809','25','09121751503','7','تيکت با عنوان انتقال وب سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(84,'1565297377','25','09121751503','7','تيکت با عنوان انتقال وب سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(85,'1565297695','25','09121751503','7','تيکت با عنوان انتقال وب سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(86,'1565298033','25','09121751503','7','تيکت با عنوان انتقال وب سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(87,'1565299628','25','09121751503','7','تيکت با عنوان انتقال وب سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(88,'1565301700','25','09121751503','7','تيکت با عنوان انتقال وب سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(89,'1565350951','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان فعال کرن فانکشن دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(90,'1565350951','admin','09123952369','115335039','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان فعال کرن فانکشن نموده است.'),
(91,'1565354527','25','09121751503','115335308','تيکت با عنوان فعال کرن فانکشن به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(92,'1565379110','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان نمایش دادن حجم مصرفی از سی پی یو دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(93,'1565379110','admin','09123952369','115338079','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان نمایش دادن حجم مصرفی از سی پی یو نموده است.'),
(94,'1565411866','25','09121751503','115339267','تيکت با عنوان نمایش دادن حجم مصرفی از سی پی یو به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(95,'1565506664','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان ریدایرکت شدن  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(96,'1565506664','admin','09123952369','115354264','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان ریدایرکت شدن  نموده است.'),
(97,'1565506748','25','09121751503','115354309','تيکت با عنوان ریدایرکت شدن  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(98,'1565508246','25','09121751503','115354860','تيکت با عنوان ریدایرکت شدن  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(99,'1565508902','admin','09123952369','7','سفارش جديد به ارزش 1800000.00 به تاريخ سررسيد 08/18/2019 ثبت گرديده است.'),
(100,'1565508965','25','09121751503','115355012','تيکت با عنوان ریدایرکت شدن  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(101,'1565509922','25','09121751503','115355220','تيکت با عنوان ریدایرکت شدن  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(102,'1565511095','1','09123952369','7','کاربر محترم حامد صادقی تيکت شما با عنوان dfgdg دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(103,'1565511095','admin','09123952369','115355512','کاربر با نام حامد صادقی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان dfgdg نموده است.'),
(104,'1565512710','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان سرور مجازی دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(105,'1565512710','admin','09123952369','115356137','کاربر با نام رضا خلیلی در شاخه سرور اختصاصی و مجازی اقدام به بازکردن تيکت جديد با عنوان سرور مجازی نموده است.'),
(106,'1565514176','25','09121751503','115358222','تيکت با عنوان سرور مجازی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(107,'1565756966','admin','09123952369','7','سفارش جديد به ارزش 250000.00 به تاريخ سررسيد 08/21/2019 ثبت گرديده است.'),
(108,'1565781329','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان سوال دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(109,'1565781329','admin','09123952369','115395107','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان سوال نموده است.'),
(110,'1565781580','25','09121751503','115395164','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(111,'1565784902','25','09121751503','115395810','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(112,'1565787331','25','09121751503','115396153','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(113,'1565788023','25','09121751503','115396258','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(114,'1565790462','25','09121751503','115396861','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(115,'1565848817','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان امار ترافیک دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(116,'1565848817','admin','09123952369','115404892','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان امار ترافیک نموده است.'),
(117,'1565849215','25','09121751503','115405100','تيکت با عنوان امار ترافیک به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(118,'1565851662','25','09121751503','115406409','تيکت با عنوان امار ترافیک به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(119,'1565853068','25','09121751503','115406832','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(120,'1565855297','25','09121751503','115407235','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(121,'1565888109','25','09121751503','115412940','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(122,'1565893408','25','09121751503','115413465','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(123,'1565894112','25','09121751503','115413524','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(124,'1565894830','25','09121751503','115413694','تيکت با عنوان سوال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(125,'1565908030','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان بک اپ دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(126,'1565908030','admin','09123952369','115414299','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان بک اپ نموده است.'),
(127,'1565937886','25','09121751503','115416378','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(128,'1565987197','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان شتاب دهنده  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(129,'1565987197','admin','09123952369','115422174','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان شتاب دهنده  نموده است.'),
(130,'1565990856','25','09121751503','115422278','تيکت با عنوان شتاب دهنده  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(131,'1566079501','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان آی پی دامنه ریدایرکت نمی شود  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(132,'1566079501','admin','09123952369','115434971','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان آی پی دامنه ریدایرکت نمی شود  نموده است.'),
(133,'1566098891','25','09121751503','115435333','تيکت با عنوان آی پی دامنه ریدایرکت نمی شود  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(134,'1566114214','25','09121751503','115443002','تيکت با عنوان آی پی دامنه ریدایرکت نمی شود  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(135,'1566114855','25','09121751503','115443308','تيکت با عنوان آی پی دامنه ریدایرکت نمی شود  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(136,'1566135606','25','09121751503','115452673','تيکت با عنوان آی پی دامنه ریدایرکت نمی شود  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(137,'1566149657','25','09121751503','115454682','تيکت با عنوان آی پی دامنه ریدایرکت نمی شود  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(138,'1566184222','25','09121751503','115455679','تيکت با عنوان آی پی دامنه ریدایرکت نمی شود  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(139,'1566262900','3','','7','صورت حساب جديدی با تاريخ سررسيد 08/27/2019 و به ارزش 500000.00 برای شما ايجاد گرديده است.'),
(140,'1566370264','admin','09123952369','7','سفارش جديد به ارزش 10000000.00 به تاريخ سررسيد 08/28/2019 ثبت گرديده است.'),
(141,'1566375744','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان غیر قابل دسترسی دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(142,'1566375744','admin','09123952369','115481426','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان غیر قابل دسترسی نموده است.'),
(143,'1566376197','25','09121751503','115481517','تيکت با عنوان غیر قابل دسترسی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(144,'1566382881','25','09121751503','115483033','تيکت با عنوان غیر قابل دسترسی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(145,'1566511802','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان ای پی دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(146,'1566511802','admin','09123952369','115496529','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان ای پی نموده است.'),
(147,'1566522626','25','09121751503','115496594','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(148,'1566608494','8','09128685061','7','صورت حساب جديدی با تاريخ سررسيد 08/31/2019 و به ارزش 1900000.00 برای شما ايجاد گرديده است.'),
(149,'1566660117','25','09121751503','115515285','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(150,'1566670822','25','09121751503','115516571','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(151,'1566672660','25','09121751503','115516708','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(152,'1566675351','25','09121751503','115516973','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(153,'1566694852','2','','7','صورت حساب جديدی با تاريخ سررسيد 09/01/2019 و به ارزش 70000.00 برای شما ايجاد گرديده است.'),
(154,'1566694853','2','','7','solidplastic.ir طی 7 روز آينده منقضی ميگردد.'),
(155,'1566703849','25','09121751503','115517614','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(156,'1566729833','25','09121751503','115527273','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(157,'1566730556','25','09121751503','115527422','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(158,'1566733302','25','09121751503','115528137','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(159,'1566733908','25','09121751503','115528249','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(160,'1566735923','25','09121751503','115528609','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(161,'1567019524','25','09121751503','115569374','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(162,'1567040455','2','','7','ُسفارش شما به ارزش 10000000.00 در تاريخ 08/28/2019 منقضی گرديد.'),
(163,'1567054194','25','09121751503','115571605','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(164,'1567055260','25','09121751503','115572041','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(165,'1567056499','25','09121751503','115572199','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(166,'1567057903','25','09121751503','115572743','تيکت با عنوان ای پی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(167,'1567175151','admin','09123952369','7','سفارش جديد به ارزش 3600000.00 به تاريخ سررسيد 09/06/2019 ثبت گرديده است.'),
(168,'1567729374','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان اضافه کردن حجم دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(169,'1567729375','admin','09123952369','115723357','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان اضافه کردن حجم نموده است.'),
(170,'1567753912','25','09121751503','115727139','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(171,'1567765925','25','09121751503','115731830','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(172,'1567768019','25','09121751503','115732654','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(173,'1567769077','25','09121751503','115733113','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(174,'1567780324','25','09121751503','115737735','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(175,'1567830707','25','09121751503','115747984','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(176,'1567844002','25','09121751503','115754260','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(177,'1567914942','admin','09123952369','7','سفارش جديد به ارزش 100000.00 به تاريخ سررسيد 09/15/2019 ثبت گرديده است.'),
(178,'1567932998','admin','09123952369','7','سفارش جديد به ارزش 8500000.00 به تاريخ سررسيد 09/15/2019 ثبت گرديده است.'),
(179,'1567944754','25','09121751503','115777008','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(180,'1567945574','25','09121751503','115777175','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(181,'1567949399','25','09121751503','115777857','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(182,'1568101183','25','09121751503','115791358','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(183,'1568110522','25','09121751503','115791722','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(184,'1568542041','25','09121751503','115873686','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(185,'1568543729','25','09121751503','115874099','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(186,'1568544344','25','09121751503','115874211','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(187,'1568545675','25','09121751503','115874509','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(188,'1568712100','25','09121751503','115908645','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(189,'1568828583','25','09121751503','115935572','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(190,'1568885378','25','09121751503','115949238','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(191,'1568941260','3','','7','صورت حساب جديدی با تاريخ سررسيد 09/27/2019 و به ارزش 500000.00 برای شما ايجاد گرديده است.'),
(192,'1568959515','25','09121751503','115960015','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(193,'1568969457','25','09121751503','115962870','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(194,'1569027684','4','09121086336','7','صورت حساب جديدی با تاريخ سررسيد 09/28/2019 و به ارزش 6500000.00 برای شما ايجاد گرديده است.'),
(195,'1569089910','25','09121751503','115995959','تيکت با عنوان اضافه کردن حجم به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(196,'1569109305','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان بک اپ  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(197,'1569109306','admin','09123952369','115997052','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان بک اپ  نموده است.'),
(198,'1569127707','25','09121751503','115998173','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(199,'1569130260','25','09121751503','115998622','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(200,'1569130785','25','09121751503','115998766','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(201,'1569131749','25','09121751503','115998990','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(202,'1569135450','25','09121751503','116001967','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(203,'1569137332','25','09121751503','116004110','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(204,'1569138213','25','09121751503','116005043','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(205,'1569144354','25','09121751503','116007884','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(206,'1569200487','4','09121086336','7','ُسفارش شما به ارزش 2000000.00 در تاريخ 09/22/2019 منقضی گرديد.'),
(207,'1569216782','25','09121751503','116021497','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(208,'1569254037','25','09121751503','116040880','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(209,'1569263155','25','09121751503','116043338','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(210,'1569286876','6','','7','صورت حساب جديدی با تاريخ سررسيد 10/01/2019 و به ارزش 24000000.00 برای شما ايجاد گرديده است.'),
(211,'1569311868','25','09121751503','116051247','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(212,'1569332377','25','09121751503','116061244','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(213,'1569346911','25','09121751503','116064811','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(214,'1569349235','25','09121751503','116065300','تيکت با عنوان بک اپ  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(215,'1569373284','11','09143929008','7','صورت حساب جديدی با تاريخ سررسيد 10/02/2019 و به ارزش 1900000.00 برای شما ايجاد گرديده است.'),
(216,'1569805319','5','09154070600','7','ُسفارش شما به ارزش 550000.00 در تاريخ 09/29/2019 منقضی گرديد.'),
(217,'1570431069','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان برگردان بک اپ دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(218,'1570431070','admin','09123952369','116355918','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان برگردان بک اپ نموده است.'),
(219,'1570431494','25','09121751503','116356253','تيکت با عنوان برگردان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(220,'1570432579','25','09121751503','116357247','تيکت با عنوان برگردان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(221,'1570435707','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان واتر مارک بی صاحاب دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(222,'1570435707','admin','09123952369','116359256','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان واتر مارک بی صاحاب نموده است.'),
(223,'1570453102','25','09121751503','116367846','تيکت با عنوان برگردان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(224,'1570842099','2','','7','ُسفارش شما به ارزش 2500000.00 در تاريخ 10/11/2019 منقضی گرديد.'),
(225,'1571126534','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان مشکل فایروال ورد فنس و خطاه ها دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(226,'1571126534','admin','09123952369','116489236','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان مشکل فایروال ورد فنس و خطاه ها نموده است.'),
(227,'1571126724','25','09121751503','116489276','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(228,'1571127629','25','09121751503','116489512','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(229,'1571149537','25','09121751503','116494921','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(230,'1571203250','25','09121751503','116498813','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(231,'1571208067','25','09121751503','116499877','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(232,'1571212200','25','09121751503','116501657','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(233,'1571212834','25','09121751503','116501793','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(234,'1571213900','25','09121751503','116502037','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(235,'1571215367','25','09121751503','116502491','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(236,'1571216226','25','09121751503','116502706','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(237,'1571218848','25','09121751503','116503456','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(238,'1571219281','25','09121751503','116503569','تيکت با عنوان مشکل فایروال ورد فنس و خطاه ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(239,'1571336400','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان فول بکاپ دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(240,'1571336400','admin','09123952369','116522078','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان فول بکاپ نموده است.'),
(241,'1571340176','25','09121751503','116522760','تيکت با عنوان فول بکاپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(242,'1571432348','25','09121751503','116534515','تيکت با عنوان فول بکاپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(243,'1571432437','25','09121751503','116534518','تيکت با عنوان فول بکاپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(244,'1571477563','25','09121751503','116536759','تيکت با عنوان فول بکاپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(245,'1571477822','25','09121751503','116536776','تيکت با عنوان فول بکاپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(246,'1571486578','25','09121751503','116537405','تيکت با عنوان فول بکاپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(247,'1571489080','25','09121751503','116538440','تيکت با عنوان فول بکاپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(248,'1571503951','admin','09123952369','7','سفارش جديد به ارزش 1500000.00 به تاريخ سررسيد 10/26/2019 ثبت گرديده است.'),
(249,'1571533261','3','','7','صورت حساب جديدی با تاريخ سررسيد 10/27/2019 و به ارزش 500000.00 برای شما ايجاد گرديده است.'),
(250,'1571778418','25','09121751503','116601922','تيکت با عنوان فول بکاپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(251,'1571792550','4','09121086336','7','ُسفارش شما به ارزش 2000000.00 در تاريخ 10/22/2019 منقضی گرديد.'),
(252,'1571825146','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان تمدید دامنه  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(253,'1571825147','admin','09123952369','116612197','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان تمدید دامنه  نموده است.'),
(254,'1571826087','25','09121751503','116612466','تيکت با عنوان تمدید دامنه  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(255,'1572035358','25','09121751503','116645893','تيکت با عنوان فول بکاپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(256,'1572077873','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان خطای سیستم اعتبار سنجی دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(257,'1572077873','admin','09123952369','116653026','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان خطای سیستم اعتبار سنجی نموده است.'),
(258,'1572078554','25','09121751503','116653571','تيکت با عنوان خطای سیستم اعتبار سنجی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(259,'1572079532','25','09121751503','116654286','تيکت با عنوان خطای سیستم اعتبار سنجی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(260,'1572086316','25','09121751503','6','تيکت با عنوان خطای سیستم اعتبار سنجی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(261,'1572088579','25','09121751503','6','تيکت با عنوان خطای سیستم اعتبار سنجی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(262,'1572224470','3','','6','ُسفارش شما به ارزش 500000.00 در تاريخ 10/27/2019 منقضی گرديد.'),
(263,'1572360398','25','09121751503','6','تيکت با عنوان خطای سیستم اعتبار سنجی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(264,'1572382470','25','09121751503','6','کاربر محترم رضا خلیلی تيکت شما با عنوان سئو دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(265,'1572382471','admin','09123952369','6','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان سئو نموده است.'),
(266,'1572383620','25','09121751503','6','تيکت با عنوان سئو به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(267,'1572383866','25','09121751503','6','تيکت با عنوان سئو به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(268,'1572464541','25','09121751503','6','کاربر محترم رضا خلیلی تيکت شما با عنوان پشتیبان دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(269,'1572464542','admin','09123952369','6','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان پشتیبان نموده است.'),
(270,'1572465033','25','09121751503','6','تيکت با عنوان پشتیبان به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(271,'1572465361','25','09121751503','6','تيکت با عنوان پشتیبان به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(272,'1572469443','25','09121751503','6','تيکت با عنوان پشتیبان به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(273,'1572469549','25','09121751503','6','تيکت با عنوان پشتیبان به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(274,'1572500205','25','09121751503','6','تيکت با عنوان پشتیبان به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(275,'1572626458','25','09121751503','6','کاربر محترم رضا خلیلی تيکت شما با عنوان بک اپ دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(276,'1572626458','admin','09123952369','6','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان بک اپ نموده است.'),
(277,'1572628694','25','09121751503','6','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(278,'1573175036','25','09121751503','7','ُسفارش شما به ارزش 4000000.00 در تاريخ 11/07/2019 منقضی گرديد.'),
(279,'1573273739','25','09121751503','116848645','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(280,'1573537080','25','09121751503','116893009','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(281,'1573537606','25','09121751503','116893105','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(282,'1573537881','25','09121751503','116893132','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(283,'1573621462','25','09121751503','116910776','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(284,'1573623542','25','09121751503','116911073','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(285,'1573624732','25','09121751503','116911319','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(286,'1573626515','25','09121751503','116911777','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(287,'1573627216','25','09121751503','116912251','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(288,'1573629369','25','09121751503','116913822','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(289,'1573629545','25','09121751503','116913919','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(290,'1574211652','3','','7','صورت حساب جديدی با تاريخ سررسيد 11/27/2019 و به ارزش 500000.00 برای شما ايجاد گرديده است.'),
(291,'1574860460','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان سلام . بعد از ثبت سفارش به بانک ملت متصل نمیشه  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(292,'1574860461','admin','09123952369','7','کاربر با نام مهدی فلاح سارمه در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان سلام . بعد از ثبت سفارش به بانک ملت متصل نمیشه  نموده است.'),
(293,'1574861400','26','09390174884','7','تيکت با عنوان سلام . بعد از ثبت سفارش به بانک ملت متصل نمیشه  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(294,'1574867805','26','09390174884','7','تيکت با عنوان سلام . بعد از ثبت سفارش به بانک ملت متصل نمیشه  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(295,'1574868117','26','09390174884','7','تيکت با عنوان سلام . بعد از ثبت سفارش به بانک ملت متصل نمیشه  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(296,'1574895600','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان از دسترس خارج شدن سرور دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(297,'1574895601','admin','09123952369','117142378','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان از دسترس خارج شدن سرور نموده است.'),
(298,'1574917385','25','09121751503','117143145','تيکت با عنوان از دسترس خارج شدن سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(299,'1574917479','26','09390174884','7','تيکت با عنوان سلام . بعد از ثبت سفارش به بانک ملت متصل نمیشه  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(300,'1574918047','26','09390174884','7','تيکت با عنوان سلام . بعد از ثبت سفارش به بانک ملت متصل نمیشه  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(301,'1574933554','admin','09123952369','7','سفارش جديد به ارزش 21600000.00 به تاريخ سررسيد 12/05/2019 ثبت گرديده است.'),
(302,'1575023649','25','09121751503','117161061','تيکت با عنوان از دسترس خارج شدن سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(303,'1575024739','25','09121751503','117161344','تيکت با عنوان از دسترس خارج شدن سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(304,'1575025054','25','09121751503','117161422','تيکت با عنوان از دسترس خارج شدن سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(305,'1575025420','25','09121751503','117161529','تيکت با عنوان از دسترس خارج شدن سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(306,'1575059101','25','09121751503','117169479','تيکت با عنوان از دسترس خارج شدن سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(307,'1575122958','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان خطای لایسنس سی پنل دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(308,'1575122958','admin','09123952369','117181092','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان خطای لایسنس سی پنل نموده است.'),
(309,'1575123578','25','09121751503','117181174','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(310,'1575264023','25','09121751503','117198308','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(311,'1575264492','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان سایت بالا نمیاد دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(312,'1575264492','admin','09123952369','117198468','کاربر با نام مهدی فلاح سارمه در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان سایت بالا نمیاد نموده است.'),
(313,'1575266278','26','09390174884','117198890','تيکت با عنوان سایت بالا نمیاد به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(314,'1575266361','25','09121751503','117198903','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(315,'1575266723','25','09121751503','117199026','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(316,'1575274771','25','09121751503','117202298','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(317,'1575275345','25','09121751503','117202555','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(318,'1575275582','25','09121751503','117202792','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(319,'1575278010','25','09121751503','117216472','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(320,'1575283029','admin','09123952369','7','سفارش جديد به ارزش 5390000.00 به تاريخ سررسيد 12/09/2019 ثبت گرديده است.'),
(321,'1575283274','25','09121751503','117218805','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(322,'1575283834','25','09121751503','117219023','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(323,'1575286546','25','09121751503','117219914','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(324,'1575288376','25','09121751503','117220398','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(325,'1575289302','25','09121751503','117220604','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(326,'1575295708','25','09121751503','117221752','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(327,'1575296178','25','09121751503','117221831','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(328,'1575301610','25','09121751503','117222908','تيکت با عنوان خطای لایسنس سی پنل به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(329,'1575382491','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان وصل نشدن به وی پی اس دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(330,'1575382491','admin','09123952369','117238437','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان وصل نشدن به وی پی اس نموده است.'),
(331,'1575387036','25','09121751503','117239831','تيکت با عنوان وصل نشدن به وی پی اس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(332,'1575388367','25','09121751503','117240169','تيکت با عنوان وصل نشدن به وی پی اس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(333,'1575388538','25','09121751503','117240213','تيکت با عنوان وصل نشدن به وی پی اس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(334,'1575408741','21','09118548174','7','ُسفارش شما به ارزش 1000000.00 در تاريخ 12/03/2019 منقضی گرديد.'),
(335,'1575457239','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان اس اس ال دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(336,'1575457240','admin','09123952369','117250562','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان اس اس ال نموده است.'),
(337,'1575457600','25','09121751503','117250735','تيکت با عنوان اس اس ال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(338,'1575457910','25','09121751503','117250825','تيکت با عنوان اس اس ال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(339,'1575458753','25','09121751503','117251121','تيکت با عنوان اس اس ال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(340,'1575459685','25','09121751503','117251475','تيکت با عنوان اس اس ال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(341,'1575824661','25','09121751503','117297300','تيکت با عنوان اس اس ال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(342,'1576044491','25','09121751503','117317358','تيکت با عنوان اس اس ال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(343,'1576062285','25','09121751503','117321330','تيکت با عنوان اس اس ال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(344,'1576070279','25','09121751503','117322529','تيکت با عنوان اس اس ال به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(345,'1576185242','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان بک اپ دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(346,'1576185243','admin','09123952369','117333335','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان بک اپ نموده است.'),
(347,'1576186021','25','09121751503','117333357','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(348,'1576224392','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان لایسنس وبسایت دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(349,'1576224393','admin','09123952369','117334653','کاربر با نام مهدی فلاح سارمه در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان لایسنس وبسایت نموده است.'),
(350,'1576225060','26','09390174884','117334724','تيکت با عنوان لایسنس وبسایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(351,'1576229793','26','09390174884','117335099','تيکت با عنوان لایسنس وبسایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(352,'1576325444','25','09121751503','117345104','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(353,'1576473846','25','09121751503','117362304','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(354,'1576532229','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان تست سرعت سایت  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(355,'1576532229','admin','09123952369','117370658','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان تست سرعت سایت  نموده است.'),
(356,'1576561759','25','09121751503','117371945','تيکت با عنوان تست سرعت سایت  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(357,'1576561850','25','09121751503','117371956','تيکت با عنوان تست سرعت سایت  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(358,'1576566918','25','09121751503','117373109','تيکت با عنوان تست سرعت سایت  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(359,'1576609367','25','09121751503','117382737','تيکت با عنوان تست سرعت سایت  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(360,'1576791195','3','','16','صورت حساب جديدی با تاريخ سررسيد 12/27/2019 و به ارزش 500000.00 برای شما ايجاد گرديده است.'),
(361,'1577058293','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان سرور اختصاصی دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(362,'1577058293','admin','09123952369','117444906','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان سرور اختصاصی نموده است.'),
(363,'1577072831','25','09121751503','117445071','تيکت با عنوان سرور اختصاصی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(364,'1577096025','25','09121751503','6','تيکت با عنوان سرور اختصاصی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(365,'1577097615','25','09121751503','6','تيکت با عنوان سرور اختصاصی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(366,'1577098366','25','09121751503','6','تيکت با عنوان سرور اختصاصی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(367,'1577098945','25','09121751503','6','تيکت با عنوان سرور اختصاصی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(368,'1577378434','25','09121751503','117480758','تيکت با عنوان سرور اختصاصی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(369,'1577378614','25','09121751503','117480769','تيکت با عنوان سرور اختصاصی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(370,'1577379938','25','09121751503','117480847','تيکت با عنوان سرور اختصاصی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(371,'1577380140','25','09121751503','117480866','تيکت با عنوان سرور اختصاصی به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(372,'1577545967','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان اینماد دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(373,'1577545967','admin','09123952369','117494556','کاربر با نام مهدی فلاح سارمه در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان اینماد نموده است.'),
(374,'1577547327','26','09390174884','117494768','تيکت با عنوان اینماد به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(375,'1577548089','26','09390174884','117494841','تيکت با عنوان اینماد به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(376,'1577548665','26','09390174884','117494895','تيکت با عنوان اینماد به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(377,'1577702183','26','09390174884','117515904','تيکت با عنوان اینماد به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(378,'1577711045','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان سرعت پایین سایت دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(379,'1577711046','admin','09123952369','117517466','کاربر با نام مهدی فلاح سارمه در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان سرعت پایین سایت نموده است.'),
(380,'1577711548','26','09390174884','117517544','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(381,'1577712249','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان یک قسمت از سایت به مشکل برخورده دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(382,'1577712249','admin','09123952369','117517706','کاربر با نام مهدی فلاح سارمه در شاخه طراحی وب  اقدام به بازکردن تيکت جديد با عنوان یک قسمت از سایت به مشکل برخورده نموده است.'),
(383,'1577712597','26','09390174884','117517819','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(384,'1577712793','26','09390174884','117517897','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(385,'1577712861','26','09390174884','117517909','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(386,'1577713274','26','09390174884','117518000','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(387,'1577717393','26','09390174884','117518636','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(388,'1577717512','26','09390174884','117518653','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(389,'1577724250','26','09390174884','117519498','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(390,'1577724354','26','09390174884','117519506','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(391,'1577724638','26','09390174884','117519530','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(392,'1577952628','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان دریافت نکردن اس ام اس دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(393,'1577952628','admin','09123952369','7','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان دریافت نکردن اس ام اس نموده است.'),
(394,'1577953475','25','09121751503','7','تيکت با عنوان دریافت نکردن اس ام اس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(395,'1578313327','26','09390174884','117585855','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(396,'1578421183','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان بالا نیومدن سایت دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(397,'1578421183','admin','09123952369','117598473','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان بالا نیومدن سایت نموده است.'),
(398,'1578951036','26','09390174884','7','ُسفارش شما به ارزش 5000000.00 در تاريخ 01/13/2020 منقضی گرديد.'),
(399,'1578996340','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان سر رسید  دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(400,'1578996340','admin','09123952369','7','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان سر رسید  نموده است.'),
(401,'1578996627','25','09121751503','7','تيکت با عنوان سر رسید  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(402,'1578996768','25','09121751503','7','تيکت با عنوان سر رسید  به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(403,'1579469508','3','','16','صورت حساب جديدی با تاريخ سررسيد 01/27/2020 و به ارزش 500000.00 برای شما ايجاد گرديده است.'),
(404,'1579728728','1','09123952369','7','ُسفارش شما به ارزش 4070000.00 در تاريخ 01/22/2020 منقضی گرديد.'),
(405,'1579949777','26','09390174884','117780963','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(406,'1579949923','26','09390174884','117780985','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(407,'1579950005','26','09390174884','117780995','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(408,'1579950443','26','09390174884','117781089','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(409,'1579952274','26','09390174884','117781510','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(410,'1579954034','26','09390174884','117781784','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(411,'1579954611','26','09390174884','117781861','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(412,'1580054968','26','09390174884','117796202','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(413,'1580065305','26','09390174884','117798101','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(414,'1580065384','26','09390174884','117798105','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(415,'1580160778','2','','16','صورت حساب جديدی با تاريخ سررسيد 02/04/2020 و به ارزش 1800000.00 برای شما ايجاد گرديده است.'),
(416,'1580160778','3','','16','ُسفارش شما به ارزش 500000.00 در تاريخ 01/27/2020 منقضی گرديد.'),
(417,'1580202893','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان اختلال در سرویس دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(418,'1580202893','admin','09123952369','117819768','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان اختلال در سرویس نموده است.'),
(419,'1580203905','25','09121751503','117819961','تيکت با عنوان اختلال در سرویس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(420,'1580329329','26','09390174884','117832383','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(421,'1580416009','26','09390174884','117840425','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(422,'1580416364','26','09390174884','117840456','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(423,'1580424405','25','09121751503','117840686','تيکت با عنوان اختلال در سرویس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(424,'1580463334','25','09121751503','117842411','تيکت با عنوان اختلال در سرویس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(425,'1580463450','26','09390174884','117842417','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(426,'1580464279','25','09121751503','117842486','تيکت با عنوان اختلال در سرویس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(427,'1580465628','26','09390174884','117842586','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(428,'1580467202','26','09390174884','117842740','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(429,'1580467697','26','09390174884','117842789','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(430,'1580468124','26','09390174884','117842821','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(431,'1580469864','26','09390174884','117842990','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(432,'1580472267','25','09121751503','117843184','تيکت با عنوان اختلال در سرویس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(433,'1580472373','26','09390174884','117843188','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(434,'1580472890','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان تغییر بخش های از سایت دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(435,'1580472890','admin','09123952369','117843242','کاربر با نام مهدی فلاح سارمه در شاخه طراحی وب  اقدام به بازکردن تيکت جديد با عنوان تغییر بخش های از سایت نموده است.'),
(436,'1580483329','26','09390174884','117844168','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(437,'1580575863','26','09390174884','117855704','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(438,'1580578597','25','09121751503','117856181','تيکت با عنوان اختلال در سرویس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(439,'1580581898','26','09390174884','117856567','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(440,'1580644024','25','09121751503','117865153','تيکت با عنوان اختلال در سرویس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(441,'1580644024','26','09390174884','117865154','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(442,'1580644553','26','09390174884','117865245','تيکت با عنوان تغییر بخش های از سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(443,'1580750960','26','09390174884','117880865','تيکت با عنوان سرعت پایین سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(444,'1580794873','26','09390174884','117883715','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(445,'1580851958','2','','16','ُسفارش شما به ارزش 1800000.00 در تاريخ 02/04/2020 منقضی گرديد.'),
(446,'1580938292','25','09121751503','7','صورت حساب جديدی با تاريخ سررسيد 02/13/2020 و به ارزش 36000000.00 برای شما ايجاد گرديده است.'),
(447,'1580974211','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان ریدایرکت نشدن دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(448,'1580974211','admin','09123952369','117912138','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان ریدایرکت نشدن نموده است.'),
(449,'1580974729','25','09121751503','117912312','تيکت با عنوان ریدایرکت نشدن به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(450,'1580975361','25','09121751503','117912446','تيکت با عنوان ریدایرکت نشدن به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(451,'1581179086','26','09390174884','117936781','تيکت با عنوان یک قسمت از سایت به مشکل برخورده به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(452,'1581234589','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان سرور دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(453,'1581234589','admin','09123952369','117943504','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان سرور نموده است.'),
(454,'1581235675','25','09121751503','117943771','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(455,'1581241534','25','09121751503','117945434','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(456,'1581244542','25','09121751503','117946302','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(457,'1581252508','25','09121751503','117948897','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(458,'1581258193','25','09121751503','117950769','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(459,'1581270952','25','09121751503','117952593','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(460,'1581271325','25','09121751503','117952620','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(461,'1581275180','25','09121751503','117953072','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(462,'1581275618','26','09390174884','117953106','تيکت با عنوان تغییر بخش های از سایت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(463,'1581275657','25','09121751503','117953110','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(464,'1581276026','25','09121751503','117953132','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(465,'1581276833','admin','09123952369','7','سفارش جديد به ارزش 19800000.00 به تاريخ سررسيد 02/16/2020 ثبت گرديده است.'),
(466,'1581277639','25','09121751503','117953235','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(467,'1581321799','25','09121751503','117958560','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(468,'1581324590','25','09121751503','117959290','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(469,'1581325342','25','09121751503','117959479','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(470,'1581507874','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان ssl دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(471,'1581507874','admin','09123952369','117978913','کاربر با نام مهدی فلاح سارمه در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان ssl نموده است.'),
(472,'1581508103','26','09390174884','117978976','تيکت با عنوان ssl به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(473,'1581512708','26','09390174884','117980189','تيکت با عنوان ssl به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(474,'1581513832','26','09390174884','117980485','تيکت با عنوان ssl به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(475,'1581513984','26','09390174884','117980517','تيکت با عنوان ssl به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(476,'1581514393','26','09390174884','117980585','تيکت با عنوان ssl به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(477,'1581515414','25','09121751503','117980849','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(478,'1581523432','25','09121751503','117982309','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(479,'1581523575','25','09121751503','117982325','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(480,'1581543162','25','09121751503','117984116','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(481,'1581543962','25','09121751503','117984173','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(482,'1581546215','25','09121751503','117984224','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(483,'1581546470','25','09121751503','117984277','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(484,'1581546922','25','09121751503','117984290','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(485,'1581547293','25','09121751503','117984294','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(486,'1581548223','25','09121751503','117984303','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(487,'1581574147','25','09121751503','117985983','تيکت با عنوان سرور به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(488,'1581629472','25','09121751503','7','ُسفارش شما به ارزش 36000000.00 در تاريخ 02/13/2020 منقضی گرديد.'),
(489,'1581686998','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان مشکل در مدیریت دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(490,'1581686999','admin','09123952369','117996206','کاربر با نام مهدی فلاح سارمه در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان مشکل در مدیریت نموده است.'),
(491,'1581687411','26','09390174884','117996242','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(492,'1581688040','26','09390174884','117996283','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(493,'1581688456','26','09390174884','117996325','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(494,'1581688838','26','09390174884','117996377','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(495,'1581691874','26','09390174884','117996653','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(496,'1581692472','26','09390174884','117996690','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(497,'1581697164','26','09390174884','117996993','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(498,'1581712162','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان از کار افتادن درگاه پرداخت دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(499,'1581712162','admin','09123952369','7','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان از کار افتادن درگاه پرداخت نموده است.'),
(500,'1581742070','25','09121751503','7','تيکت با عنوان از کار افتادن درگاه پرداخت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(501,'1581780327','26','09390174884','118008405','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(502,'1581781090','26','09390174884','118008498','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(503,'1581781736','26','09390174884','118008552','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(504,'1581782551','26','09390174884','118008642','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(505,'1581783309','26','09390174884','118008719','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(506,'1582016975','26','09390174884','118038208','تيکت با عنوان مشکل در مدیریت به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(507,'1582031005','26','09390174884','118041211','تيکت با عنوان ssl به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(508,'1582031212','26','09390174884','118041260','تيکت با عنوان ssl به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(509,'1582031787','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان اپلود عکس ها دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(510,'1582031787','admin','09123952369','118041422','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان اپلود عکس ها نموده است.'),
(511,'1582032154','25','09121751503','118041510','تيکت با عنوان اپلود عکس ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(512,'1582032477','25','09121751503','118041580','تيکت با عنوان اپلود عکس ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(513,'1582033226','26','09390174884','7','کاربر محترم مهدی فلاح سارمه تيکت شما با عنوان https دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(514,'1582033226','admin','09123952369','118041755','کاربر با نام مهدی فلاح سارمه در شاخه طراحی وب  اقدام به بازکردن تيکت جديد با عنوان https نموده است.'),
(515,'1582033459','25','09121751503','118041801','تيکت با عنوان اپلود عکس ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(516,'1582033503','26','09390174884','118041810','تيکت با عنوان https به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(517,'1582034082','25','09121751503','118041923','تيکت با عنوان اپلود عکس ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(518,'1582034232','26','09390174884','118041949','تيکت با عنوان https به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(519,'1582035597','26','09390174884','118042130','تيکت با عنوان https به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(520,'1582121798','25','09121751503','118053716','تيکت با عنوان اپلود عکس ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(521,'1582122681','25','09121751503','118053861','تيکت با عنوان اپلود عکس ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(522,'1582125227','25','09121751503','118054254','تيکت با عنوان اپلود عکس ها به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(523,'1582131330','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان sms دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(524,'1582131330','admin','09123952369','118054857','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان sms نموده است.'),
(525,'1582132475','25','09121751503','118054943','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(526,'1582133258','25','09121751503','118055018','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(527,'1582147956','3','','16','صورت حساب جديدی با تاريخ سررسيد 02/27/2020 و به ارزش 500000.00 برای شما ايجاد گرديده است.'),
(528,'1582666351','26','09390174884','7','ُسفارش شما به ارزش 500000.00 در تاريخ 02/25/2020 منقضی گرديد.'),
(529,'1582925439','22','+989133082272','7','صورت حساب جديدی با تاريخ سررسيد 03/07/2020 و به ارزش 1950000.00 برای شما ايجاد گرديده است.'),
(530,'1583061260','25','09121751503','118182235','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(531,'1583063181','25','09121751503','118182590','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(532,'1583063653','25','09121751503','118182659','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(533,'1583064075','25','09121751503','118182752','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(534,'1583064903','25','09121751503','118182996','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(535,'1583067320','25','09121751503','118183372','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(536,'1583098296','25','09121751503','7','صورت حساب جديدی با تاريخ سررسيد 03/09/2020 و به ارزش 21500000.00 برای شما ايجاد گرديده است.'),
(537,'1583244772','25','09121751503','118206282','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(538,'1583244938','25','09121751503','118206316','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(539,'1583247764','25','09121751503','118206618','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(540,'1583248843','25','09121751503','118206709','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(541,'1583265657','25','09121751503','118208208','تيکت با عنوان sms به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(542,'1583283275','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان بک اپ دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(543,'1583283275','admin','09123952369','118208705','کاربر با نام رضا خلیلی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان بک اپ نموده است.'),
(544,'1583292598','25','09121751503','118208887','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(545,'1583304621','25','09121751503','118210574','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(546,'1583308514','25','09121751503','118211371','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(547,'1583309521','25','09121751503','118211590','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(548,'1583310036','25','09121751503','118211677','تيکت با عنوان بک اپ به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(549,'1583668343','25','09121751503','7','کاربر محترم رضا خلیلی تيکت شما با عنوان تمدید سرویس دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(550,'1583668343','admin','09123952369','118242464','کاربر با نام رضا خلیلی در شاخه فروش و مالی اقدام به بازکردن تيکت جديد با عنوان تمدید سرویس نموده است.'),
(551,'1583673670','25','09121751503','118242852','تيکت با عنوان تمدید سرویس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(552,'1583724740','25','09121751503','118245367','تيکت با عنوان تمدید سرویس به روز رسانی گرديده است. لطفا جهت بررسی به حيطه کاربری خود وارد شويد.'),
(553,'1583771312','1','09123952369','7','کاربر محترم حامد صادقی تيکت شما با عنوان test دريافت گرديده و به زودی پاسخ داده شده و به روز رسانی می گردد.'),
(554,'1583771312','admin','09123952369','118253754','کاربر با نام حامد صادقی در شاخه پشتیبانی فنی اقدام به بازکردن تيکت جديد با عنوان test نموده است.');
/*!40000 ALTER TABLE `mod_smsaddon_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_subirnic_poll`
--

DROP TABLE IF EXISTS `mod_subirnic_poll`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_subirnic_poll` (
  `msgID` int(11) NOT NULL,
  `poll_msg` text NOT NULL,
  `processed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`msgID`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_subirnic_poll`
--

LOCK TABLES `mod_subirnic_poll` WRITE;
/*!40000 ALTER TABLE `mod_subirnic_poll` DISABLE KEYS */;
INSERT INTO `mod_subirnic_poll` (`msgID`, `poll_msg`, `processed`) VALUES (1868578,'{\"status\":0,\"message\":\"Success\",\"msgcount\":3,\"msgid\":1868578,\"date\":\"2016-10-07 19:32:57\",\"keywords\":\"DomainUpdateStatus DomainNotice\",\"domain\":\"roselab.ir\",\"email\":\"\",\"note\":\"\"}',1),
(1933618,'{\"status\":0,\"message\":\"Success\",\"msgcount\":2,\"msgid\":1933618,\"date\":\"2016-11-27 14:09:35\",\"keywords\":\"DomainUpdateStatus DomainNotice\",\"domain\":\"central-ssl.ir\",\"email\":\"\",\"note\":\"\"}',1),
(1933619,'{\"status\":0,\"message\":\"Success\",\"msgcount\":1,\"msgid\":1933619,\"date\":\"2016-11-27 14:09:35\",\"keywords\":\"DomainUpdateStatus DomainNotice\",\"domain\":\"centralssl.ir\",\"email\":\"\",\"note\":\"\"}',1),
(2120746,'{\"status\":0,\"message\":\"Success\",\"msgcount\":1,\"msgid\":2120746,\"date\":\"2017-04-25 17:51:56\",\"keywords\":\"DomainUpdateStatus DomainNotice\",\"domain\":\"plusmart.ir\",\"email\":\"\",\"note\":\"\"}',1);
/*!40000 ALTER TABLE `mod_subirnic_poll` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_subirnic_setting`
--

DROP TABLE IF EXISTS `mod_subirnic_setting`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_subirnic_setting` (
  `setting_key` varchar(128) NOT NULL,
  `setting_value` text NOT NULL,
  PRIMARY KEY (`setting_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_subirnic_setting`
--

LOCK TABLES `mod_subirnic_setting` WRITE;
/*!40000 ALTER TABLE `mod_subirnic_setting` DISABLE KEYS */;
INSERT INTO `mod_subirnic_setting` (`setting_key`, `setting_value`) VALUES ('licensekey','sirnic-29f46f8dcafa7f'),
('localkey','==Qf7ICNyETMyIDMyIiO4ozc7ISZ0FGZrNWZoNmI6kjOztjIjlmbylmY1N3LzJXYyR3cpdWZy9yclxWd\nk9Wbv02bj5CZ19Gbj52bsV2auw2YvQWdvx2Yu9Gblt2Ll12bo9iI6IjN6M3OikncvR3YlJXakRWasFmd\nioDNxozc9tjI54yMyIjL1EjMuMDMxIiOzEjOztDM6k2e6EjOhtjIzBXaklGbhZnI6gjOz13Oi02bj5CZ\n19Gbj52bsV2auw2Yuc3d3JiOxIjOztTM6k2Oi02bj5CZ19Gbj52bsV2auw2YiozNxozc7AjOptnOyoTY\n7IyculWYt9GZklGbhZnI6ITM6M3OiUmdpR3YBJiO2ozc7Iyc1RXY0NnI6YjOztnO1oTY405cc428a8e8\n701795b6ab1f1b6c8c2bdaacc38e249f987eb59b77b3d268e1f8'),
('module_version','1.0.0');
/*!40000 ALTER TABLE `mod_subirnic_setting` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_veportal`
--

DROP TABLE IF EXISTS `mod_veportal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_veportal` (
  `id` int(250) NOT NULL AUTO_INCREMENT,
  `relid` text DEFAULT NULL,
  `veid` text DEFAULT NULL,
  `hostname` text DEFAULT NULL,
  `ipad` text DEFAULT NULL,
  `lastmod` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_veportal`
--

LOCK TABLES `mod_veportal` WRITE;
/*!40000 ALTER TABLE `mod_veportal` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_veportal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_vpsnet`
--

DROP TABLE IF EXISTS `mod_vpsnet`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_vpsnet` (
  `relid` int(10) unsigned NOT NULL,
  `setting` varchar(45) NOT NULL,
  `value` varchar(45) NOT NULL,
  PRIMARY KEY (`relid`,`setting`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_vpsnet`
--

LOCK TABLES `mod_vpsnet` WRITE;
/*!40000 ALTER TABLE `mod_vpsnet` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod_vpsnet` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_zarinpal_settings`
--

DROP TABLE IF EXISTS `mod_zarinpal_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_zarinpal_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_zarinpal_settings`
--

LOCK TABLES `mod_zarinpal_settings` WRITE;
/*!40000 ALTER TABLE `mod_zarinpal_settings` DISABLE KEYS */;
INSERT INTO `mod_zarinpal_settings` (`id`, `name`, `value`) VALUES (1,'mobile_customfield_id',''),
(2,'iran_access_only','0');
/*!40000 ALTER TABLE `mod_zarinpal_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `mod_zarinpal_transactions`
--

DROP TABLE IF EXISTS `mod_zarinpal_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `mod_zarinpal_transactions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `invoice_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(20,2) NOT NULL DEFAULT 0.00,
  `authority` varchar(255) DEFAULT NULL,
  `ip_address` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'pending',
  `failure_message` text DEFAULT NULL,
  `card_number` varchar(255) DEFAULT NULL,
  `created_at` bigint(20) unsigned NOT NULL,
  `updated_at` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `mod_zarinpal_transactions`
--

LOCK TABLES `mod_zarinpal_transactions` WRITE;
/*!40000 ALTER TABLE `mod_zarinpal_transactions` DISABLE KEYS */;
INSERT INTO `mod_zarinpal_transactions` (`id`, `uuid`, `user_id`, `invoice_id`, `amount`, `authority`, `ip_address`, `status`, `failure_message`, `card_number`, `created_at`, `updated_at`) VALUES (1,'c26ab382-ed02-447d-b803-9540758a3829',56,4765,4354500.00,'A00000000000000000000000000380352680','46.245.72.220','cancelled',NULL,NULL,1664601282,1664601341),
(2,'a5929939-c0cd-4b3f-ac0e-fc5227e8fb7e',56,4765,4354500.00,'A00000000000000000000000000380352783','46.245.72.220','cancelled',NULL,NULL,1664601347,1664601356),
(3,'5cb5be11-95e5-46a0-8c84-cceae6931f1b',56,4765,4354500.00,'A00000000000000000000000000380353748','46.245.72.220','cancelled',NULL,NULL,1664601914,1664601918),
(4,'d09317a6-e4f2-43ff-aea8-b21e80f16cd6',65,4882,1800000.00,'A00000000000000000000000000389367391','188.212.243.3','pending',NULL,NULL,1668640772,1668640772),
(5,'193f5f11-5c6d-403c-999b-dc582e305ea7',65,4882,1800000.00,'A00000000000000000000000000389367401','188.212.243.3','pending',NULL,NULL,1668640781,1668640781),
(6,'7c70d920-0e11-4c37-a4d7-765d00670d7b',93,4891,1800000.00,'A00000000000000000000000000389501561','37.98.65.28','success',NULL,'603799******8934',1668707100,1668707140),
(7,'1c502d4a-ebd9-4c54-92dd-016c56a011fd',95,4899,2300000.00,'A00000000000000000000000000389744288','185.108.96.40','cancelled',NULL,NULL,1668838001,1668838112),
(8,'456df6ca-4fc1-4eba-85f7-0e2264dd33af',98,4920,380000.00,'A00000000000000000000000000390454370','151.247.53.169','pending',NULL,NULL,1669140033,1669140034),
(9,'83632dcb-f707-43c6-a52b-5e93885abd50',65,4976,4000000.00,'A00000000000000000000000000392670544','5.112.251.154','pending',NULL,NULL,1669995598,1669995604),
(10,'f65f9d01-e589-47a2-9971-0baab5629f4b',65,4976,4000000.00,'A00000000000000000000000000392673518','89.199.29.210','success',NULL,'502229******2233',1669996469,1669996525),
(11,'2831cdb8-4782-4209-aa29-05e94530855a',112,5006,1800000.00,'A00000000000000000000000000393761953','167.235.78.146','success',NULL,'585983******6837',1670440376,1670440441),
(12,'3ecbfd63-2952-43a1-aac7-f82e372ccb25',112,5045,1800000.00,'A00000000000000000000000000394618561','95.162.198.219','success',NULL,'585983******6837',1670784576,1670784650),
(13,'b5198b31-311c-4e80-867c-9fbb9e0442c6',123,5088,1800000.00,NULL,'141.11.250.53','pending',NULL,NULL,1671008091,1671008091),
(14,'89a7aabc-a9a4-4394-b75b-538b4029ff0d',123,5088,1800000.00,NULL,'141.11.250.53','pending',NULL,NULL,1671011144,1671011144),
(15,'b0e3d440-2487-479c-ba4e-625b979e9166',123,5088,1800000.00,NULL,'141.11.250.53','pending',NULL,NULL,1671011761,1671011761),
(16,'f79cb1ec-121b-4d5a-9881-2bddd657b6c1',95,5056,3040000.00,'A00000000000000000000000000396513326','83.121.5.151','pending',NULL,NULL,1671550102,1671550113),
(17,'01d43d32-310c-4653-a051-bd42d67e3bac',149,5158,1800000.00,'A00000000000000000000000000397227302','18.193.247.204','pending',NULL,NULL,1671808448,1671808459),
(18,'80f073f9-2fa9-48fe-bb56-3c8b0712a6b2',149,5158,1800000.00,'A00000000000000000000000000397227305','18.193.247.204','success',NULL,'504172******2897',1671808459,1671808555),
(19,'17d22fd9-cc69-4ce3-89fe-81afc69ea5f8',69,5139,3040000.00,'A00000000000000000000000000397302510','217.172.126.131','success',NULL,'603799******7998',1671825138,1671825224),
(20,'099b0650-03ba-4b25-9f21-0e85cea132ac',156,5192,2650000.00,'A00000000000000000000000000398427858','46.225.76.113','success',NULL,'603799******4279',1672236898,1672236978),
(21,'2e9016b2-5f7b-4ea6-8f96-891533ec7b0f',158,5194,1800000.00,'A00000000000000000000000000398494237','46.225.75.8','success',NULL,'603799******8072',1672253005,1672253052),
(22,'04a76334-cfa1-47f3-9503-40b482903ae0',160,5202,3040000.00,'A00000000000000000000000000398617472','31.2.242.137','success',NULL,'502229******7731',1672310587,1672310689),
(23,'d54559b4-d05c-4813-b25b-3052e744552f',127,5205,3550000.00,'A00000000000000000000000000398702739','89.199.24.183','success',NULL,'502229******2262',1672334342,1672334430),
(24,'d8e71854-6112-4489-8a3e-c6e681e032cc',112,5226,3000000.00,'A00000000000000000000000000399500490','217.147.80.42','success',NULL,'628023******1923',1672648705,1672648830),
(25,'58b31dce-274d-4b8a-aa7e-a95b4b43b19f',182,5260,2500000.00,'A00000000000000000000000000400139850','178.131.185.242','pending',NULL,NULL,1672870515,1672870515),
(26,'8c0987f8-2432-44fe-a178-a3cd9a6ca42d',195,5313,1800000.00,'A00000000000000000000000000401754220','5.121.120.196','success',NULL,'585983******9384',1673470833,1673470888),
(27,'044890c4-728b-4813-bc67-c59e12b76662',199,5324,1800000.00,'A00000000000000000000000000402014037','162.55.45.80','success',NULL,'621986******8132',1673562074,1673562162),
(28,'bcbceec6-e6b2-4b38-a0d1-e9d20792edf1',205,5368,2800000.00,'A00000000000000000000000000403160601','37.98.86.166','success',NULL,'603769******7316',1673962608,1673962660),
(29,'1a99d215-ffc4-4046-b3e5-6193f33bb22c',219,5398,1800000.00,'A00000000000000000000000000403888274','188.121.138.57','success',NULL,'636214******9930',1674230671,1674230730),
(30,'90f09095-3066-42b8-9953-d46d0418f9cc',230,5480,1800000.00,'A00000000000000000000000000406295316','5.250.0.178','pending',NULL,NULL,1675018805,1675018807),
(31,'8ae198b9-cd37-4ebb-91bf-3dbccba01419',230,5480,1800000.00,'A00000000000000000000000000406295321','5.250.0.178','success',NULL,'603799******0165',1675018808,1675018871),
(32,'27f76995-d418-414a-9c61-3e81d0a10ec6',235,5495,1800000.00,'A00000000000000000000000000406504718','5.208.217.44','success',NULL,'621986******9511',1675096724,1675096794),
(33,'23a7f3f6-926f-46c7-b3db-3e7b356fbe34',149,5360,1800000.00,'A00000000000000000000000000407685687','144.76.97.102','cancelled',NULL,NULL,1675530898,1675531304),
(34,'23bc6e38-d393-4d6e-9768-3397936dbe07',149,5360,1800000.00,'A00000000000000000000000000407687279','144.76.97.102','success',NULL,'504172******2897',1675531314,1675531379),
(35,'e2ee1c68-3dfe-4edb-bcda-543c7dad2811',82,5534,1800000.00,'A00000000000000000000000000408035076','45.156.29.136','pending',NULL,NULL,1675672567,1675672568),
(36,'6932e78d-9e99-49da-bdde-8be2584d1869',251,5568,1800000.00,'A00000000000000000000000000408054998','116.203.110.84','success',NULL,'603799******0137',1675678116,1675678170),
(37,'75309abc-f10a-4bc5-b3d5-a370392c3aaa',82,5534,1800000.00,'A00000000000000000000000000408209728','45.156.29.136','success',NULL,'636214******1367',1675721927,1675721986),
(38,'735ab5c3-6c3c-4549-b606-516959c33d67',254,5576,330000.00,'A00000000000000000000000000408295081','5.125.133.28','pending',NULL,NULL,1675767007,1675767013),
(39,'13b52599-e5d9-45d9-8628-17c7ff8d7e96',254,5576,330000.00,'A00000000000000000000000000408295086','5.125.133.28','success',NULL,'603769******3462',1675767013,1675767064),
(40,'f83af6be-e6b4-4ea2-b4a9-bc0029418578',151,5585,500000.00,'A00000000000000000000000000408616583','5.126.227.24','success',NULL,'606373******8059',1675879398,1675879446),
(41,'a931c819-1890-4337-af54-d8b50846b63b',226,5597,500000.00,'A00000000000000000000000000408986034','46.143.101.203','pending',NULL,NULL,1676031090,1676031091),
(42,'8e248891-4c9d-401f-b507-140c51216f65',226,5597,500000.00,'A00000000000000000000000000408986651','46.143.101.203','pending',NULL,NULL,1676031266,1676031266),
(43,'78677a7e-a973-43cc-a938-920ebdf69f92',151,5604,500000.00,'A00000000000000000000000000409226379','91.107.254.223','success',NULL,'606373******8059',1676125544,1676125603),
(44,'1069a1bc-1d75-43a4-a411-98ac936fa460',151,5626,2250000.00,'A00000000000000000000000000409894820','78.38.125.11','pending',NULL,NULL,1676377425,1676377425),
(45,'3992f6d6-6103-4ff4-be8a-f0905a975293',151,5626,2250000.00,'A00000000000000000000000000409894913','78.38.125.11','success',NULL,'606373******1303',1676377451,1676377515),
(46,'c4cfc533-cb83-4571-b836-fb9427fd6e81',260,5646,2500000.00,'A00000000000000000000000000410973813','109.125.165.227','pending',NULL,NULL,1676795538,1676795614);
/*!40000 ALTER TABLE `mod_zarinpal_transactions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rstheme_themes`
--

DROP TABLE IF EXISTS `rstheme_themes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rstheme_themes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `version` varchar(255) NOT NULL,
  `active_style` varchar(255) NOT NULL,
  `active_layout` varchar(255) NOT NULL,
  `pages_configuration` text NOT NULL,
  `widgets_configuration` text NOT NULL,
  `widgets_layouts` text NOT NULL,
  `active_widgets_layout` varchar(255) NOT NULL,
  `settings` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rstheme_themes_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rstheme_themes`
--

LOCK TABLES `rstheme_themes` WRITE;
/*!40000 ALTER TABLE `rstheme_themes` DISABLE KEYS */;
INSERT INTO `rstheme_themes` (`id`, `name`, `version`, `active_style`, `active_layout`, `pages_configuration`, `widgets_configuration`, `widgets_layouts`, `active_widgets_layout`, `settings`, `created_at`, `updated_at`) VALUES (1,'lagom2','2.1.1','default','default','{\"clientareahome\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"account-contacts-manage\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"account-contacts-new\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"account-paymentmethods\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"account-paymentmethods-manage\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"account-user-management\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"account-user-permissions\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"addons\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"announcements\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"clientareaaddfunds\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"bulkdomainmanagement\":{\"default\":{\"config\":{\"amountVal1\":\"10\",\"amountVal2\":\"25\",\"amountVal3\":\"50\",\"amountVal4\":\"75\",\"amountVal5\":\"100\"}},\"option\":\"default\"},\"clientareadetails\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"clientareadomains\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"clientareaemails\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"clientareainvoices\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"clientareaproducts\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"clientareaquotes\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"clientareasecurity\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"clientregister\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"configureproductdomain\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"domain-renewals\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":{\"showFeaturedTLD\":\"1\",\"showTLDCategoryFilter\":\"1\"}}},\"domainregister\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":{\"showFeaturedTLD\":\"1\",\"showTLDCategoryFilter\":\"1\"}}},\"domaintransfer\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"downloaddenied\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"downloads\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"downloadscat\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"homepage\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"knowledgebase\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"knowledgebasearticle\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"knowledgebasecat\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"login\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"password-reset-container\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":{\"productColumns\":\"3\"}}},\"products\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"serverstatus\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"supportticketslist\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"supportticketsubmit-confirm\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"supportticketsubmit-stepone\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"supportticketsubmit-steptwo\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"two-factor-challenge\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"two-factor-new-backup-code\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"user-invite-accept\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"user-password\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"user-profile\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"user-security\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"user-switch-account\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"user-switch-account-forced\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"user-verify-email\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"viewannouncement\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"viewcart\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"viewinvoice\":{\"option\":\"default\",\"config\":[],\"default\":{\"config\":[]}},\"configuredomains\":{\"option\":\"default\",\"config\":[]},\"configureproduct\":{\"option\":\"default\",\"config\":[]},\"contact\":{\"option\":\"default\",\"config\":[]},\"forwardpage\":{\"option\":\"default\",\"config\":[]},\"invoicepdf\":{\"option\":\"default\",\"config\":[]},\"clientareaproductdetails\":{\"option\":\"default\",\"config\":[]},\"complete\":{\"option\":\"default\",\"config\":[]},\"access-denied\":{\"option\":\"default\",\"config\":[]},\"clientareadomaindetails\":{\"option\":\"default\",\"config\":[]},\"viewticket\":{\"option\":\"default\",\"config\":[]},\"banned\":{\"option\":\"default\",\"config\":[]},\"affiliatessignup\":{\"option\":\"default\",\"config\":[]},\"domain-pricing\":{\"option\":\"default\",\"config\":[]},\"affiliates\":{\"option\":\"default\",\"config\":[]},\"clientareadomainregisterns\":{\"option\":\"default\",\"config\":[]},\"clientareacancelrequest\":{\"option\":\"default\",\"config\":[]},\"clientareadomaindns\":{\"option\":\"default\",\"config\":[]},\"clientareadomaincontactinfo\":{\"option\":\"default\",\"config\":[]},\"clientareadomainaddons\":{\"option\":\"default\",\"config\":[]}}','[]','{\"default\":\"Default\"}','default','[]','2022-08-13 03:56:07','2022-12-31 18:55:00');
/*!40000 ALTER TABLE `rstheme_themes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_configurable_options`
--

DROP TABLE IF EXISTS `rsthemes_configurable_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_configurable_options` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `configurableoption` int(11) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_configurable_options`
--

LOCK TABLES `rsthemes_configurable_options` WRITE;
/*!40000 ALTER TABLE `rsthemes_configurable_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `rsthemes_configurable_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_display_menus`
--

DROP TABLE IF EXISTS `rsthemes_display_menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_display_menus` (
  `rule_id` int(10) unsigned NOT NULL,
  `menu_id` int(10) unsigned NOT NULL,
  KEY `rsthemes_display_menus_rule_id_foreign` (`rule_id`),
  KEY `rsthemes_display_menus_menu_id_foreign` (`menu_id`),
  CONSTRAINT `rsthemes_display_menus_menu_id_foreign` FOREIGN KEY (`menu_id`) REFERENCES `rsthemes_menus` (`id`) ON DELETE CASCADE,
  CONSTRAINT `rsthemes_display_menus_rule_id_foreign` FOREIGN KEY (`rule_id`) REFERENCES `rsthemes_display_rules` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_display_menus`
--

LOCK TABLES `rsthemes_display_menus` WRITE;
/*!40000 ALTER TABLE `rsthemes_display_menus` DISABLE KEYS */;
INSERT INTO `rsthemes_display_menus` (`rule_id`, `menu_id`) VALUES (2,3),
(2,4),
(1,4),
(1,7),
(2,8),
(1,9),
(1,5);
/*!40000 ALTER TABLE `rsthemes_display_menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_display_rules`
--

DROP TABLE IF EXISTS `rsthemes_display_rules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_display_rules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `display_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `navigation_layout` varchar(255) DEFAULT NULL,
  `footer_layout` varchar(255) DEFAULT NULL,
  `main_menu_id` int(11) DEFAULT NULL,
  `secondary_menu_id` int(11) DEFAULT NULL,
  `footer_menu_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rsthemes_display_rules_display_id_foreign` (`display_id`),
  CONSTRAINT `rsthemes_display_rules_display_id_foreign` FOREIGN KEY (`display_id`) REFERENCES `rsthemes_displays` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_display_rules`
--

LOCK TABLES `rsthemes_display_rules` WRITE;
/*!40000 ALTER TABLE `rsthemes_display_rules` DISABLE KEYS */;
INSERT INTO `rsthemes_display_rules` (`id`, `display_id`, `name`, `slug`, `icon`, `navigation_layout`, `footer_layout`, `main_menu_id`, `secondary_menu_id`, `footer_menu_id`, `created_at`, `updated_at`) VALUES (1,1,'Guest Client','guest-client','user','default','default',5,7,4,'2022-08-13 03:56:07','2022-08-20 02:50:04'),
(2,1,'Existing Client','existing-client','padlock','default','default',8,3,4,'2022-08-13 03:56:07','2022-08-13 05:03:17'),
(3,2,'Website','website','user','default','default',NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(4,2,'Client Portal','client-portal','padlock','default','default',NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(5,2,'Order Process','order-process','basket','default','default',NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07');
/*!40000 ALTER TABLE `rsthemes_display_rules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_displays`
--

DROP TABLE IF EXISTS `rsthemes_displays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_displays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_displays`
--

LOCK TABLES `rsthemes_displays` WRITE;
/*!40000 ALTER TABLE `rsthemes_displays` DISABLE KEYS */;
INSERT INTO `rsthemes_displays` (`id`, `name`, `active`, `created_at`, `updated_at`) VALUES (1,'Default',1,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(2,'CMS',0,'2022-08-13 03:56:07','2022-08-13 03:56:07');
/*!40000 ALTER TABLE `rsthemes_displays` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_menus`
--

DROP TABLE IF EXISTS `rsthemes_menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_menus` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `display_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `location` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `version` varchar(255) NOT NULL DEFAULT '1.0.0',
  `changed` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rsthemes_menus_display_id_foreign` (`display_id`),
  CONSTRAINT `rsthemes_menus_display_id_foreign` FOREIGN KEY (`display_id`) REFERENCES `rsthemes_displays` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_menus`
--

LOCK TABLES `rsthemes_menus` WRITE;
/*!40000 ALTER TABLE `rsthemes_menus` DISABLE KEYS */;
INSERT INTO `rsthemes_menus` (`id`, `display_id`, `name`, `location`, `active`, `version`, `changed`, `created_at`, `updated_at`) VALUES (1,1,'Client Main Menu - WHMCS Defaults','Main Menu',0,'1.0.0',1,'2022-08-13 03:56:07','2022-08-13 06:51:17'),
(3,1,'Client Secondary Menu','Secondary Menu',1,'1.0.0',0,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(4,1,'Footer','Footer',1,'1.0.0',0,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(5,1,'Guest Main Menu - WHMCS Defaults','Main Menu',1,'1.0.0',1,'2022-08-13 03:56:08','2022-08-20 02:50:37'),
(7,1,'Guest Secondary Menu','Secondary Menu',1,'1.0.0',1,'2022-08-13 03:56:09','2022-08-13 07:19:53'),
(8,1,'Client Main Menu','Main Menu',1,'1.0.0',0,'2022-08-13 04:53:52','2022-08-13 05:03:17'),
(9,1,'Guest Main Menu','Main Menu',0,'1.0.1',1,'2022-08-13 06:51:35','2022-08-13 06:53:35');
/*!40000 ALTER TABLE `rsthemes_menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_menus_content`
--

DROP TABLE IF EXISTS `rsthemes_menus_content`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_menus_content` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type_id` int(10) unsigned NOT NULL,
  `content_settings` text DEFAULT NULL,
  `display_settings` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rsthemes_menus_content_type_id_foreign` (`type_id`),
  CONSTRAINT `rsthemes_menus_content_type_id_foreign` FOREIGN KEY (`type_id`) REFERENCES `rsthemes_menus_types` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=768 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_menus_content`
--

LOCK TABLES `rsthemes_menus_content` WRITE;
/*!40000 ALTER TABLE `rsthemes_menus_content` DISABLE KEYS */;
INSERT INTO `rsthemes_menus_content` (`id`, `type_id`, `content_settings`, `display_settings`, `created_at`, `updated_at`) VALUES (76,1,'{\"page\":\"85\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-basket\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(77,5,'{\"translation-method\":\"whmcs\",\"icon\":\"lm lm-bell\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"icon\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(78,7,NULL,'{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(79,6,'{\"icon\":\"lm lm-user\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(80,3,'{\"list\":\"Client Details\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(81,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(82,1,'{\"page\":\"18\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-info-circle\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(83,1,'{\"page\":\"8\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-configure\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(84,1,'{\"page\":\"6\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-wallet\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(85,1,'{\"page\":\"4\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-smartphone\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(86,1,'{\"page\":\"32\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-shield\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(87,1,'{\"page\":\"27\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-envelope\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(88,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(89,1,'{\"page\":\"79\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-user\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(90,1,'{\"page\":\"81\",\"translation-method\":\"whmcs\",\"icon\":\"fas fa-random\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(91,1,'{\"page\":\"78\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-padlock\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(92,1,'{\"page\":\"80\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-security-code\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(93,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(94,2,'{\"link\":\"logout.php\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-arrow-left-wall\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(95,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"text\"},\"footer-position\":\"Primary\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(96,3,'{\"list\":\"Product Groups\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(97,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"text\"},\"footer-position\":\"Primary\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(98,3,'{\"list\":\"MarketConnect Products\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(99,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"text\"},\"footer-position\":\"Primary\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(100,1,'{\"page\":\"41\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(101,1,'{\"page\":\"13\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(102,1,'{\"page\":\"55\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(103,1,'{\"page\":\"11\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(104,7,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"footer-position\":\"Secondary\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(105,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-go-top\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon\"},\"footer-position\":\"Secondary\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(106,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"social\\/facebook.tpl\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon\"},\"footer-position\":\"Social\",\"custom-data-classes\":\"social-fb\",\"target\":\"1\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(107,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"social\\/twitter.tpl\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon\"},\"footer-position\":\"Social\",\"custom-data-classes\":\"social-tw\",\"target\":\"1\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(108,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"social\\/linkedin.tpl\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon\"},\"footer-position\":\"Social\",\"custom-data-classes\":\"social-in\",\"target\":\"1\"}','2022-08-13 03:56:08','2022-08-13 03:56:08'),
(335,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"addon.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"right\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(336,3,'{\"list\":\"Product Groups\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(337,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(338,3,'{\"list\":\"MarketConnect Products\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(339,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(340,1,'{\"page\":\"43\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-refresh\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(341,1,'{\"page\":\"44\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-ticket-tag\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(342,1,'{\"page\":\"45\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-transfer\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(343,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"web-hosting.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(344,1,'{\"page\":\"30\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-hosting\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(345,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(346,1,'{\"page\":\"63\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-box\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(347,1,'{\"page\":\"10\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-addon\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(348,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"content-delivery-network.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(349,1,'{\"page\":\"26\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-globe\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(350,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(351,1,'{\"page\":\"43\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-refresh\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(352,1,'{\"page\":\"44\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-dns\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(353,1,'{\"page\":\"45\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-transfer\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(354,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"addon-id-protection.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(355,3,'{\"list\":\"MarketConnect Products\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(356,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(357,1,'{\"page\":\"60\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-security-code\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(358,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"blogging.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(359,1,'{\"page\":\"28\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-document\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(360,1,'{\"page\":\"31\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-text-cloud\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(361,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(362,1,'{\"page\":\"61\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-bank-note\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(363,1,'{\"page\":\"6\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-bank-note\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(364,1,'{\"page\":\"16\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-credit\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(365,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"ticket.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(366,1,'{\"page\":\"67\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-envelope\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(367,1,'{\"page\":\"13\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-text-cloud\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(368,1,'{\"page\":\"55\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-document-info\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(369,1,'{\"page\":\"47\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-download-square\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(370,1,'{\"page\":\"65\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-range\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(371,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(372,1,'{\"page\":\"69\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-new-window\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(373,1,'{\"page\":\"11\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"increase-SEO-rank.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(374,1,'{\"page\":\"69\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-chat-cloud\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"Default\",\"Condensed\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"button\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"right\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 05:03:17','2022-08-13 05:03:17'),
(407,1,'{\"page\":\"1\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-home\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"icon\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(408,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-hosting\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(409,1,'{\"page\":\"30\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-hosting\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(410,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(411,1,'{\"page\":\"63\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-box\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(412,1,'{\"page\":\"10\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-addon\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(413,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-globe\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(414,1,'{\"page\":\"26\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-globe\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(415,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(416,1,'{\"page\":\"43\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-refresh\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(417,1,'{\"page\":\"44\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-dns\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(418,1,'{\"page\":\"45\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-transfer\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(419,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-document\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(420,1,'{\"page\":\"28\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-document\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(421,1,'{\"page\":\"31\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-text-cloud\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(422,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(423,1,'{\"page\":\"61\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-bank-note\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(424,1,'{\"page\":\"6\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-bank-note\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(425,1,'{\"page\":\"16\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-credit\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:17','2022-08-13 06:51:17'),
(426,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-envelope\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:18','2022-08-13 06:51:18'),
(427,1,'{\"page\":\"67\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-envelope\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:18','2022-08-13 06:51:18'),
(428,1,'{\"page\":\"13\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-text-cloud\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:18','2022-08-13 06:51:18'),
(429,1,'{\"page\":\"55\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-document-info\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:18','2022-08-13 06:51:18'),
(430,1,'{\"page\":\"47\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-download-square\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:18','2022-08-13 06:51:18'),
(431,1,'{\"page\":\"65\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-range\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:18','2022-08-13 06:51:18'),
(432,1,'{\"page\":\"69\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-new-window\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:18','2022-08-13 06:51:18'),
(433,1,'{\"page\":\"11\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-bar-graph\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:18','2022-08-13 06:51:18'),
(434,1,'{\"page\":\"69\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-chat-cloud\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"Default\",\"Left\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"button\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"right\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:51:18','2022-08-13 06:51:18'),
(541,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"web-hosting.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(542,3,'{\"list\":\"Product Groups\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(543,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"content-delivery-network.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(544,1,'{\"page\":\"44\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-globe\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(545,1,'{\"page\":\"45\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-transfer\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(546,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(547,1,'{\"page\":\"42\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-document-info\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(548,1,'{\"page\":\"11\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"comissions.tpl\"}','{\"theme-layout\":[\"Default\",\"Left\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(549,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"comments.tpl\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(550,1,'{\"page\":\"41\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-chat-clouds\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(551,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(552,1,'{\"page\":\"65\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-spark\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(553,1,'{\"page\":\"55\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-document-info\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(554,1,'{\"page\":\"13\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-document\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(555,1,'{\"page\":\"33\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"Default\",\"Condensed\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"button\",\"button-style\":\"outline\"},\"left\":{\"layout\":\"button\",\"button-style\":\"outline\"}},\"position\":\"right\",\"custom-data-classes\":\"d-md-none d-lg-flex\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(556,1,'{\"page\":\"58\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"Default\",\"Condensed\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"button\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"button\",\"button-style\":\"primary\"}},\"position\":\"right\",\"custom-data-classes\":\"d-md-none d-lg-flex\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(557,7,NULL,'{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"right\",\"custom-data-classes\":\"d-lg-none\",\"target\":\"0\"}','2022-08-13 06:53:35','2022-08-13 06:53:35'),
(608,1,'{\"page\":\"85\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-basket\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"Logged-Out\",\"style\":{\"top\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 07:19:53','2022-08-13 07:19:53'),
(609,7,NULL,'{\"theme-layout\":[\"Default\",\"Left\"],\"client-status\":\"Logged-Out\",\"style\":{\"top\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 07:19:53','2022-08-13 07:19:53'),
(610,6,'{\"icon\":\"lm lm-user\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"Left\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 07:19:53','2022-08-13 07:19:53'),
(611,1,'{\"page\":\"58\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-user\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 07:19:53','2022-08-13 07:19:53'),
(612,1,'{\"page\":\"33\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-sign-in\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 07:19:53','2022-08-13 07:19:53'),
(613,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 07:19:53','2022-08-13 07:19:53'),
(614,1,'{\"page\":\"62\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-refresh\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-13 07:19:53','2022-08-13 07:19:53'),
(751,1,'{\"page\":\"52\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-home\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"icon\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(752,2,'{\"link\":\"#\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-basket\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(753,1,'{\"page\":\"63\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-basket\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(754,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(755,3,'{\"list\":\"Product Groups\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(756,3,'{\"list\":\"MarketConnect Products\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(757,4,NULL,'{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(758,1,'{\"page\":\"44\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-search\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(759,1,'{\"page\":\"45\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-globe\",\"predefined_icon\":\"\"}','{\"client-status\":\"All\",\"style\":{\"layout\":\"icon-text\"},\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(760,1,'{\"page\":\"13\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-document\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(761,1,'{\"page\":\"55\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-document-info\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(762,1,'{\"page\":\"65\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-range\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(763,1,'{\"page\":\"11\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-bar-graph\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(764,1,'{\"page\":\"41\",\"translation-method\":\"whmcs\",\"icon\":\"lm lm-envelope\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(765,1,'{\"page\":\"33\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"button\",\"button-style\":\"outline\"},\"left\":{\"layout\":\"button\",\"button-style\":\"primary\"}},\"position\":\"right\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(766,1,'{\"page\":\"58\",\"translation-method\":\"whmcs\",\"icon\":\"\",\"predefined_icon\":\"\"}','{\"theme-layout\":[\"Default\",\"Condensed\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"button\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"right\",\"custom-data-classes\":\"\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37'),
(767,7,NULL,'{\"theme-layout\":[\"All\"],\"client-status\":\"All\",\"style\":{\"top\":{\"layout\":\"text\",\"button-style\":\"primary\"},\"left\":{\"layout\":\"icon-text\",\"button-style\":\"primary\"}},\"position\":\"left\",\"custom-data-classes\":\"d-lg-none\",\"target\":\"0\"}','2022-08-20 02:50:37','2022-08-20 02:50:37');
/*!40000 ALTER TABLE `rsthemes_menus_content` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_menus_items`
--

DROP TABLE IF EXISTS `rsthemes_menus_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_menus_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int(10) unsigned NOT NULL,
  `content_menu_id` int(10) unsigned NOT NULL,
  `parent_id` int(11) NOT NULL,
  `title` text NOT NULL,
  `level` int(11) NOT NULL,
  `order` int(11) DEFAULT NULL,
  `active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rsthemes_menus_items_menu_id_foreign` (`menu_id`),
  KEY `rsthemes_menus_items_content_menu_id_foreign` (`content_menu_id`),
  CONSTRAINT `rsthemes_menus_items_content_menu_id_foreign` FOREIGN KEY (`content_menu_id`) REFERENCES `rsthemes_menus_content` (`id`) ON DELETE CASCADE,
  CONSTRAINT `rsthemes_menus_items_menu_id_foreign` FOREIGN KEY (`menu_id`) REFERENCES `rsthemes_menus` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=768 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_menus_items`
--

LOCK TABLES `rsthemes_menus_items` WRITE;
/*!40000 ALTER TABLE `rsthemes_menus_items` DISABLE KEYS */;
INSERT INTO `rsthemes_menus_items` (`id`, `menu_id`, `content_menu_id`, `parent_id`, `title`, `level`, `order`, `active`, `created_at`, `updated_at`) VALUES (76,3,76,0,'{\"whmcs\":\"viewcart\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,1,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(77,3,77,0,'{\"whmcs\":\"notifications\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,2,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(78,3,78,0,'Language',0,3,0,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(79,3,79,0,'My Account',0,4,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(80,3,80,79,'Client Details',1,1,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(81,3,81,79,'-----',1,2,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(82,3,82,79,'{\"whmcs\":\"clientareanavdetails\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(83,3,83,79,'{\"whmcs\":\"navUserManagement\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(84,3,84,79,'{\"whmcs\":\"paymentMethods.title\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,5,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(85,3,85,79,'{\"whmcs\":\"navContacts\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,6,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(86,3,86,79,'{\"whmcs\":\"navAccountSecurity\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,7,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(87,3,87,79,'{\"whmcs\":\"navemailssent\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,8,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(88,3,88,79,'-----',1,9,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(89,3,89,79,'{\"whmcs\":\"yourProfile\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,10,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(90,3,90,79,'{\"whmcs\":\"navSwitchAccount\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,11,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(91,3,91,79,'{\"whmcs\":\"clientareanavchangepw\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,12,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(92,3,92,79,'{\"whmcs\":\"clientareanavsecurity\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,13,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(93,3,93,79,'-----',1,14,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(94,3,94,79,'{\"whmcs\":\"clientareanavlogout\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,15,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(95,4,95,0,'{\"whmcs\":\"footer_extended.products\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,1,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(96,4,96,95,'Product Groups',1,1,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(97,4,97,0,'{\"whmcs\":\"navservices\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,2,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(98,4,98,97,'MarketConnect Products',1,1,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(99,4,99,0,'{\"whmcs\":\"navsupport\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,3,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(100,4,100,99,'{\"whmcs\":\"contactUs\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(101,4,101,99,'{\"whmcs\":\"news\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,2,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(102,4,102,99,'{\"whmcs\":\"knowledgebasetitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(103,4,103,99,'{\"whmcs\":\"affiliatestitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(104,4,104,0,'Language',0,4,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(105,4,105,0,'{\"whmcs\":\"footer_extended.back_to_top\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,5,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(106,4,106,0,'{\"whmcs\":\"social.facebook\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,6,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(107,4,107,0,'{\"whmcs\":\"social.twitter\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,7,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(108,4,108,0,'{\"whmcs\":\"social.linkedin\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,8,1,'2022-08-13 03:56:08','2022-08-13 03:56:08'),
(335,8,335,0,'{\"whmcs\":\"navStore\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"Store\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,1,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(336,8,336,335,'Product Groups',1,1,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(337,8,337,335,'-----',1,2,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(338,8,338,335,'MarketConnect Products',1,3,0,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(339,8,339,335,'-----',1,4,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(340,8,340,335,'{\"whmcs\":\"domainrenewals\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,5,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(341,8,341,335,'{\"whmcs\":\"navregisterdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,6,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(342,8,342,335,'{\"whmcs\":\"navtransferdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,7,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(343,8,343,0,'{\"whmcs\":\"navservices\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,2,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(344,8,344,343,'{\"whmcs\":\"clientareanavservices\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(345,8,345,343,'-----',1,2,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(346,8,346,343,'{\"whmcs\":\"navservicesorder\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(347,8,347,343,'{\"whmcs\":\"clientareaviewaddons\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(348,8,348,0,'{\"whmcs\":\"navdomains\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,3,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(349,8,349,348,'{\"whmcs\":\"clientareanavdomains\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(350,8,350,348,'-----',1,2,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(351,8,351,348,'{\"whmcs\":\"domainrenewals\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(352,8,352,348,'{\"whmcs\":\"navregisterdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(353,8,353,348,'{\"whmcs\":\"navtransferdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,5,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(354,8,354,0,'{\"whmcs\":\"navWebsiteSecurity\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,4,0,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(355,8,355,354,'MarketConnect Products',1,1,0,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(356,8,356,354,'-----',1,2,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(357,8,357,354,'{\"whmcs\":\"navManageSsl\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(358,8,358,0,'{\"whmcs\":\"navbilling\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,5,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(359,8,359,358,'{\"whmcs\":\"invoices\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(360,8,360,358,'{\"whmcs\":\"quotestitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,2,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(361,8,361,358,'-----',1,3,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(362,8,362,358,'{\"whmcs\":\"masspaytitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,0,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(363,8,363,358,'{\"whmcs\":\"paymentMethods.title\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,5,0,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(364,8,364,358,'{\"whmcs\":\"addfunds\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,6,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(365,8,365,0,'{\"whmcs\":\"navsupport\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,6,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(366,8,366,365,'{\"whmcs\":\"navtickets\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(367,8,367,365,'{\"whmcs\":\"announcementstitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,2,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(368,8,368,365,'{\"whmcs\":\"knowledgebasetitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(369,8,369,365,'{\"whmcs\":\"downloadstitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(370,8,370,365,'{\"whmcs\":\"networkstatustitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,5,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(371,8,371,365,'-----',1,6,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(372,8,372,365,'{\"whmcs\":\"navopenticket\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,7,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(373,8,373,0,'{\"whmcs\":\"affiliatestitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,7,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(374,8,374,0,'{\"whmcs\":\"navopenticket\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,8,1,'2022-08-13 05:03:17','2022-08-13 05:03:17'),
(407,1,407,0,'{\"whmcs\":\"clientareanavhome\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,1,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(408,1,408,0,'{\"whmcs\":\"navservices\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,2,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(409,1,409,408,'{\"whmcs\":\"clientareanavservices\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(410,1,410,408,'-----',1,2,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(411,1,411,408,'{\"whmcs\":\"navservicesorder\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(412,1,412,408,'{\"whmcs\":\"clientareaviewaddons\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(413,1,413,0,'{\"whmcs\":\"navdomains\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,3,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(414,1,414,413,'{\"whmcs\":\"clientareanavdomains\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(415,1,415,413,'-----',1,2,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(416,1,416,413,'{\"whmcs\":\"domainrenewals\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(417,1,417,413,'{\"whmcs\":\"navregisterdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(418,1,418,413,'{\"whmcs\":\"navtransferdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,5,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(419,1,419,0,'{\"whmcs\":\"navbilling\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,4,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(420,1,420,419,'{\"whmcs\":\"invoices\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(421,1,421,419,'{\"whmcs\":\"quotestitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,2,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(422,1,422,419,'-----',1,3,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(423,1,423,419,'{\"whmcs\":\"masspaytitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,0,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(424,1,424,419,'{\"whmcs\":\"paymentMethods.title\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,5,0,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(425,1,425,419,'{\"whmcs\":\"addfunds\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,6,1,'2022-08-13 06:51:17','2022-08-13 06:51:17'),
(426,1,426,0,'{\"whmcs\":\"navsupport\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,5,1,'2022-08-13 06:51:18','2022-08-13 06:51:18'),
(427,1,427,426,'{\"whmcs\":\"navtickets\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 06:51:18','2022-08-13 06:51:18'),
(428,1,428,426,'{\"whmcs\":\"announcementstitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,2,1,'2022-08-13 06:51:18','2022-08-13 06:51:18'),
(429,1,429,426,'{\"whmcs\":\"knowledgebasetitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 06:51:18','2022-08-13 06:51:18'),
(430,1,430,426,'{\"whmcs\":\"downloadstitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 06:51:18','2022-08-13 06:51:18'),
(431,1,431,426,'{\"whmcs\":\"networkstatustitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,5,1,'2022-08-13 06:51:18','2022-08-13 06:51:18'),
(432,1,432,426,'{\"whmcs\":\"navopenticket\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,6,1,'2022-08-13 06:51:18','2022-08-13 06:51:18'),
(433,1,433,0,'{\"whmcs\":\"affiliatestitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,6,1,'2022-08-13 06:51:18','2022-08-13 06:51:18'),
(434,1,434,0,'{\"whmcs\":\"navopenticket\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,7,1,'2022-08-13 06:51:18','2022-08-13 06:51:18'),
(541,9,541,0,'{\"whmcs\":\"footer_extended.products\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,1,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(542,9,542,541,'Product Groups',1,1,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(543,9,543,0,'{\"whmcs\":\"navdomains\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,2,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(544,9,544,543,'{\"whmcs\":\"navregisterdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(545,9,545,543,'{\"whmcs\":\"navtransferdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,2,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(546,9,546,543,'-----',1,3,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(547,9,547,543,'{\"whmcs\":\"domainspricing\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(548,9,548,0,'{\"whmcs\":\"affiliatestitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,3,0,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(549,9,549,0,'{\"whmcs\":\"navsupport\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,4,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(550,9,550,549,'{\"whmcs\":\"contactus\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(551,9,551,549,'-----',1,2,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(552,9,552,549,'{\"whmcs\":\"networkstatustitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,3,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(553,9,553,549,'{\"whmcs\":\"knowledgebasetitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(554,9,554,549,'{\"whmcs\":\"news\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,5,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(555,9,555,0,'{\"whmcs\":\"register\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,5,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(556,9,556,0,'{\"whmcs\":\"login\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,6,1,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(557,9,557,0,'Language',0,7,0,'2022-08-13 06:53:35','2022-08-13 06:53:35'),
(608,7,608,0,'{\"whmcs\":\"viewcart\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,1,1,'2022-08-13 07:19:53','2022-08-13 07:19:53'),
(609,7,609,0,'Language',0,2,1,'2022-08-13 07:19:53','2022-08-13 07:19:53'),
(610,7,610,0,'My Account',0,3,1,'2022-08-13 07:19:53','2022-08-13 07:19:53'),
(611,7,611,610,'{\"whmcs\":\"login\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-13 07:19:53','2022-08-13 07:19:53'),
(612,7,612,610,'{\"whmcs\":\"register\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,2,1,'2022-08-13 07:19:53','2022-08-13 07:19:53'),
(613,7,613,610,'-----',1,3,1,'2022-08-13 07:19:53','2022-08-13 07:19:53'),
(614,7,614,610,'{\"whmcs\":\"forgotpw\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,4,1,'2022-08-13 07:19:53','2022-08-13 07:19:53'),
(751,5,751,0,'{\"whmcs\":\"clientareanavhome\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,1,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(752,5,752,0,'{\"whmcs\":\"navStore\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,2,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(753,5,753,752,'{\"whmcs\":\"navBrowseProductsServices\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,1,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(754,5,754,752,'-----',1,2,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(755,5,755,752,'Product Groups',1,3,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(756,5,756,752,'MarketConnect Products',1,4,0,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(757,5,757,752,'-----',1,5,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(758,5,758,752,'{\"whmcs\":\"navregisterdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,6,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(759,5,759,752,'{\"whmcs\":\"navtransferdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',1,7,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(760,5,760,0,'{\"whmcs\":\"news\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,3,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(761,5,761,0,'{\"whmcs\":\"knowledgebasetitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,4,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(762,5,762,0,'{\"whmcs\":\"networkstatustitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,5,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(763,5,763,0,'{\"whmcs\":\"affiliatestitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,6,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(764,5,764,0,'{\"whmcs\":\"contactus\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"New Item\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,7,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(765,5,765,0,'{\"whmcs\":\"register\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,8,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(766,5,766,0,'{\"whmcs\":\"login\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}',0,9,1,'2022-08-20 02:50:37','2022-08-20 02:50:37'),
(767,5,767,0,'Language',0,10,1,'2022-08-20 02:50:37','2022-08-20 02:50:37');
/*!40000 ALTER TABLE `rsthemes_menus_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_menus_types`
--

DROP TABLE IF EXISTS `rsthemes_menus_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_menus_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `view` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_menus_types`
--

LOCK TABLES `rsthemes_menus_types` WRITE;
/*!40000 ALTER TABLE `rsthemes_menus_types` DISABLE KEYS */;
INSERT INTO `rsthemes_menus_types` (`id`, `name`, `view`, `created_at`, `updated_at`) VALUES (1,'WHMCS Page','whmcs-page','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(2,'Custom Link','custom-link','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(3,'Predefined List','predefined-list','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(4,'Divider','divider','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(5,'WHMCS Notifications','whmcs-notifications','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(6,'Client Account','my-account','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(7,'Language','language','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(8,'Currency Switcher','currency-switcher','2022-08-13 03:56:07','2022-08-13 03:56:07');
/*!40000 ALTER TABLE `rsthemes_menus_types` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_page_sections`
--

DROP TABLE IF EXISTS `rsthemes_page_sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_page_sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `page_id` int(10) unsigned NOT NULL,
  `visibility` tinyint(1) NOT NULL,
  `theme` varchar(255) NOT NULL,
  `order` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rsthemes_page_sections_page_id_foreign` (`page_id`),
  CONSTRAINT `rsthemes_page_sections_page_id_foreign` FOREIGN KEY (`page_id`) REFERENCES `rsthemes_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_page_sections`
--

LOCK TABLES `rsthemes_page_sections` WRITE;
/*!40000 ALTER TABLE `rsthemes_page_sections` DISABLE KEYS */;
/*!40000 ALTER TABLE `rsthemes_page_sections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_page_sections_lang`
--

DROP TABLE IF EXISTS `rsthemes_page_sections_lang`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_page_sections_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `section_id` int(10) unsigned NOT NULL,
  `lang` varchar(255) NOT NULL,
  `values` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rsthemes_page_sections_lang_section_id_foreign` (`section_id`),
  CONSTRAINT `rsthemes_page_sections_lang_section_id_foreign` FOREIGN KEY (`section_id`) REFERENCES `rsthemes_page_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_page_sections_lang`
--

LOCK TABLES `rsthemes_page_sections_lang` WRITE;
/*!40000 ALTER TABLE `rsthemes_page_sections_lang` DISABLE KEYS */;
/*!40000 ALTER TABLE `rsthemes_page_sections_lang` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_pages`
--

DROP TABLE IF EXISTS `rsthemes_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_pages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `custom_page` tinyint(1) NOT NULL DEFAULT 0,
  `url` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `display_type` varchar(255) NOT NULL,
  `list_display` tinyint(1) NOT NULL,
  `seo_enabled` tinyint(1) NOT NULL DEFAULT 0,
  `seo_robots` tinyint(1) NOT NULL DEFAULT 0,
  `seo_title` text DEFAULT NULL,
  `seo_description` text DEFAULT NULL,
  `seo_image` text DEFAULT NULL,
  `settings` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_pages`
--

LOCK TABLES `rsthemes_pages` WRITE;
/*!40000 ALTER TABLE `rsthemes_pages` DISABLE KEYS */;
INSERT INTO `rsthemes_pages` (`id`, `custom_page`, `url`, `name`, `display_type`, `list_display`, `seo_enabled`, `seo_robots`, `seo_title`, `seo_description`, `seo_image`, `settings`, `created_at`, `updated_at`) VALUES (1,0,'','clientareahome','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(2,0,'','3dsecure','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(3,0,'','access-denied','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(4,0,'','account-contacts-manage','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(5,0,'','account-contacts-new','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(6,0,'','account-paymentmethods','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(7,0,'','account-paymentmethods-manage','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(8,0,'','account-user-management','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(9,0,'','account-user-permissions','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(10,0,'','addons','order-process',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(11,0,'','affiliates','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(12,0,'','affiliatessignup','website',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(13,0,'','announcements','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(14,0,'','banned','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(15,0,'','bulkdomainmanagement','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(16,0,'','clientareaaddfunds','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(17,0,'','clientareacancelrequest','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(18,0,'','clientareadetails','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(19,0,'','clientareadomainaddons','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(20,0,'','clientareadomaincontactinfo','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(21,0,'','clientareadomaindetails','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(22,0,'','clientareadomaindns','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(23,0,'','clientareadomainemailforwarding','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(24,0,'','clientareadomaingetepp','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(25,0,'','clientareadomainregisterns','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(26,0,'','clientareadomains','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(27,0,'','clientareaemails','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(28,0,'','clientareainvoices','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(29,0,'','clientareaproductdetails','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(30,0,'','clientareaproducts','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(31,0,'','clientareaquotes','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(32,0,'','clientareasecurity','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(33,0,'','clientregister','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(34,0,'','complete','order-process',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(35,0,'','configuredomains','order-process',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(36,0,'','configureproduct','order-process',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(37,0,'','configureproductdomain','order-process',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(38,0,'','configuressl-complete','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(39,0,'','configuressl-stepone','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(40,0,'','configuressl-steptwo','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(41,0,'','contact','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(42,0,'','domain-pricing','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(43,0,'','domain-renewals','order-process',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(44,0,'','domainregister','order-process',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(45,0,'','domaintransfer','order-process',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(46,0,'','downloaddenied','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(47,0,'','downloads','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(48,0,'','downloadscat','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(49,0,'','error','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(50,0,'','forwardpage','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(51,0,'','fraudcheck','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(52,0,'','homepage','website',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(53,0,'','invoice-payment','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(54,0,'','invoicepdf','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(55,0,'','knowledgebase','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(56,0,'','knowledgebasearticle','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(57,0,'','knowledgebasecat','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(58,0,'','login','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(59,0,'','logout','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(60,0,'','managessl','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(61,0,'','masspay','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(62,0,'','password-reset-container','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(63,0,'','products','order-process',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(64,0,'','quotepdf','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(65,0,'','serverstatus','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(66,0,'','subscription-manage','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(67,0,'','supportticketslist','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(68,0,'','supportticketsubmit-confirm','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(69,0,'','supportticketsubmit-stepone','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(70,0,'','supportticketsubmit-steptwo','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(71,0,'','ticketfeedback','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(72,0,'','two-factor-challenge','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(73,0,'','two-factor-new-backup-code','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(74,0,'','upgrade','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(75,0,'','upgrade-configure','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(76,0,'','upgradesummary','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(77,0,'','user-invite-accept','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(78,0,'','user-password','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(79,0,'','user-profile','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(80,0,'','user-security','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(81,0,'','user-switch-account','client-portal',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(82,0,'','user-switch-account-forced','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(83,0,'','user-verify-email','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(84,0,'','viewannouncement','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(85,0,'','viewcart','order-process',1,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(86,0,'','viewinvoice','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(87,0,'','viewquote','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07'),
(88,0,'','viewticket','client-portal',0,0,0,NULL,NULL,NULL,NULL,'2022-08-13 03:56:07','2022-08-13 03:56:07');
/*!40000 ALTER TABLE `rsthemes_pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_sections`
--

DROP TABLE IF EXISTS `rsthemes_sections`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_sections`
--

LOCK TABLES `rsthemes_sections` WRITE;
/*!40000 ALTER TABLE `rsthemes_sections` DISABLE KEYS */;
/*!40000 ALTER TABLE `rsthemes_sections` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_sections_lang`
--

DROP TABLE IF EXISTS `rsthemes_sections_lang`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_sections_lang` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `section_id` int(10) unsigned NOT NULL,
  `lang` varchar(255) NOT NULL,
  `values` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rsthemes_sections_lang_section_id_foreign` (`section_id`),
  CONSTRAINT `rsthemes_sections_lang_section_id_foreign` FOREIGN KEY (`section_id`) REFERENCES `rsthemes_sections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_sections_lang`
--

LOCK TABLES `rsthemes_sections_lang` WRITE;
/*!40000 ALTER TABLE `rsthemes_sections_lang` DISABLE KEYS */;
/*!40000 ALTER TABLE `rsthemes_sections_lang` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_settings`
--

DROP TABLE IF EXISTS `rsthemes_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `setting` varchar(255) NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_settings`
--

LOCK TABLES `rsthemes_settings` WRITE;
/*!40000 ALTER TABLE `rsthemes_settings` DISABLE KEYS */;
INSERT INTO `rsthemes_settings` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES (1,'show_logo_url','0','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(2,'logo_url','','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(3,'display_mode_switcher','0','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(4,'display_longest_billing_cycle_monthly_price','0','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(5,'light_mode_theme','default','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(6,'dark_mode_theme','futuristic','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(7,'auto_recalculate_package_width','0','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(8,'package_price_wrap','default','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(9,'hide_nameserver_fields','displayed','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(10,'hide_password_fields','displayed','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(11,'enable_custom_hostname','0','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(12,'custom_hostname_prefix','kelon-cloud','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(13,'custom_hostname_interfix_length','20','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(14,'custom_hostname_suffix','.com','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(15,'sticky_sidebars','hidden','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(16,'show_gravatar_image','hidden','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(17,'show_affixed_navigation','disabled','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(18,'show_cookie_box','hidden','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(19,'cookie_box_position','bottom-left','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(20,'cookie_box_message',' ','2022-08-13 03:56:07','2022-08-13 03:56:07'),
(21,'lagom2_theme_last_save_time','1660977161','2022-08-13 03:56:10','2022-08-20 02:02:41'),
(22,'lagom2_theme_default_color_scheme','green','2022-08-13 03:56:12','2022-08-13 03:59:35'),
(23,'lagom2_theme_depth_color_scheme','default','2022-08-13 03:56:42','2022-08-13 03:56:42'),
(24,'lagom2_theme_futuristic_color_scheme','default','2022-08-13 03:56:42','2022-08-13 03:56:42'),
(25,'lagom2_theme_modern_color_scheme','default','2022-08-13 03:56:45','2022-08-13 03:56:45'),
(26,'lagom2_template_version','2.1.1','2022-08-13 03:56:45','2022-08-13 03:56:45');
/*!40000 ALTER TABLE `rsthemes_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_sidebars`
--

DROP TABLE IF EXISTS `rsthemes_sidebars`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_sidebars` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `title` text NOT NULL,
  `translation` varchar(255) NOT NULL,
  `location` varchar(255) NOT NULL,
  `display` varchar(255) NOT NULL,
  `order` int(11) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_sidebars`
--

LOCK TABLES `rsthemes_sidebars` WRITE;
/*!40000 ALTER TABLE `rsthemes_sidebars` DISABLE KEYS */;
INSERT INTO `rsthemes_sidebars` (`id`, `name`, `title`, `translation`, `location`, `display`, `order`, `active`, `created_at`, `updated_at`) VALUES (1,'My Services - Secondary Sidebar','{\"whmcs\":\"\",\"custom\":{\"english\":\"My Services - Sidebar Secondary\"}}','custom','Secondary','Custom Selected Pages',1,1,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(2,'Store - Primary Sidebar','{\"whmcs\":\"ordercategories\",\"custom\":{\"english\":\"Categories\"}}','whmcs','Primary','Sidebar Pages',1,1,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(3,'Store - Secondary Sidebar','{\"whmcs\":\"actions\",\"custom\":{\"english\":\"Actions\"}}','whmcs','Secondary','Sidebar Pages',1,1,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(4,'Support - Secondary Sidebar','{\"whmcs\":\"navsupport\",\"custom\":{\"english\":\"Support\"}}','whmcs','Secondary','Sidebar Pages',1,1,'2022-08-13 03:56:09','2022-08-13 03:56:09');
/*!40000 ALTER TABLE `rsthemes_sidebars` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_sidebars_items`
--

DROP TABLE IF EXISTS `rsthemes_sidebars_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_sidebars_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sidebar_id` int(10) unsigned NOT NULL,
  `title` text NOT NULL,
  `content` text NOT NULL,
  `order` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `rsthemes_sidebars_items_sidebar_id_foreign` (`sidebar_id`),
  CONSTRAINT `rsthemes_sidebars_items_sidebar_id_foreign` FOREIGN KEY (`sidebar_id`) REFERENCES `rsthemes_sidebars` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_sidebars_items`
--

LOCK TABLES `rsthemes_sidebars_items` WRITE;
/*!40000 ALTER TABLE `rsthemes_sidebars_items` DISABLE KEYS */;
INSERT INTO `rsthemes_sidebars_items` (`id`, `sidebar_id`, `title`, `content`, `order`, `created_at`, `updated_at`) VALUES (1,1,'{\"whmcs\":\"navservicesplaceorder\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"Place a New Order\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"products\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-box\"}',1,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(2,1,'{\"whmcs\":\"clientareaviewaddons\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"View Avaialble Addons\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"addons\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-addon\"}',2,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(3,2,'Product Groups','{\"list\":\"Product Groups\"}',1,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(4,3,'{\"whmcs\":\"orderregisterdomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"Register a New Domain\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"domainregister\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-dns\"}',1,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(5,3,'{\"whmcs\":\"transferinadomain\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"Transfer in a Domain\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"domaintransfer\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-transfer\"}',2,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(6,3,'{\"whmcs\":\"viewcart\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"View Cart\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"viewcart\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-basket\"}',3,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(7,3,'{\"whmcs\":\"viewcart\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"View Cart\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"viewcart\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-basket\"}',4,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(8,3,'Custom HTML','{\"html\":\"<div>This is custom html<\\/div>\"}',5,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(9,4,'{\"whmcs\":\"clientareanavsupporttickets\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"My Support Tickets\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"supportticketlist\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-ticket-tag\"}',1,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(10,4,'{\"whmcs\":\"announcementstitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"Announcements\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"announcements\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-text-cloud\"}',2,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(11,4,'{\"whmcs\":\"knowledgebasetitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"Knowledgebase\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"knowledgebase\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-document-info\"}',3,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(12,4,'{\"whmcs\":\"downloadstitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"Downloads\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"downloads\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-download-square\"}',4,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(13,4,'{\"whmcs\":\"networkstatustitle\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"Network Status\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"downloads\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-range\"}',5,'2022-08-13 03:56:09','2022-08-13 03:56:09'),
(14,4,'{\"whmcs\":\"navopenticket\",\"custom\":{\"arabic\":\"\",\"azerbaijani\":\"\",\"catalan\":\"\",\"chinese\":\"\",\"croatian\":\"\",\"czech\":\"\",\"danish\":\"\",\"dutch\":\"\",\"english\":\"Open Ticket\",\"estonian\":\"\",\"farsi\":\"\",\"french\":\"\",\"german\":\"\",\"hebrew\":\"\",\"hungarian\":\"\",\"italian\":\"\",\"macedonian\":\"\",\"norwegian\":\"\",\"portuguese-br\":\"\",\"portuguese-pt\":\"\",\"romanian\":\"\",\"russian\":\"\",\"spanish\":\"\",\"swedish\":\"\",\"turkish\":\"\",\"ukranian\":\"\"}}','{\"page\":\"supportticketsubmit-stepone\",\"translation-method\":\"whmcs\",\"icon\":\"ls ls-new-window\"}',6,'2022-08-13 03:56:09','2022-08-13 03:56:09');
/*!40000 ALTER TABLE `rsthemes_sidebars_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_sidebars_pages`
--

DROP TABLE IF EXISTS `rsthemes_sidebars_pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_sidebars_pages` (
  `page_id` int(10) unsigned NOT NULL,
  `sidebar_id` int(10) unsigned NOT NULL,
  KEY `rsthemes_sidebars_pages_page_id_foreign` (`page_id`),
  KEY `rsthemes_sidebars_pages_sidebar_id_foreign` (`sidebar_id`),
  CONSTRAINT `rsthemes_sidebars_pages_page_id_foreign` FOREIGN KEY (`page_id`) REFERENCES `rsthemes_pages` (`id`) ON DELETE CASCADE,
  CONSTRAINT `rsthemes_sidebars_pages_sidebar_id_foreign` FOREIGN KEY (`sidebar_id`) REFERENCES `rsthemes_sidebars` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_sidebars_pages`
--

LOCK TABLES `rsthemes_sidebars_pages` WRITE;
/*!40000 ALTER TABLE `rsthemes_sidebars_pages` DISABLE KEYS */;
INSERT INTO `rsthemes_sidebars_pages` (`page_id`, `sidebar_id`) VALUES (30,1),
(63,2),
(44,3),
(45,3),
(85,3),
(13,4),
(55,4),
(47,4),
(69,4);
/*!40000 ALTER TABLE `rsthemes_sidebars_pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_versions`
--

DROP TABLE IF EXISTS `rsthemes_versions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_versions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `themeVersion` varchar(255) NOT NULL,
  `whmcsVersion` varchar(255) NOT NULL,
  `compability` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_versions`
--

LOCK TABLES `rsthemes_versions` WRITE;
/*!40000 ALTER TABLE `rsthemes_versions` DISABLE KEYS */;
INSERT INTO `rsthemes_versions` (`id`, `type`, `themeVersion`, `whmcsVersion`, `compability`, `created_at`, `updated_at`) VALUES (1,'info','2.1.1','8.5.1',1,NULL,NULL);
/*!40000 ALTER TABLE `rsthemes_versions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rsthemes_widgets`
--

DROP TABLE IF EXISTS `rsthemes_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `rsthemes_widgets` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug_name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=610 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rsthemes_widgets`
--

LOCK TABLES `rsthemes_widgets` WRITE;
/*!40000 ALTER TABLE `rsthemes_widgets` DISABLE KEYS */;
INSERT INTO `rsthemes_widgets` (`id`, `name`, `slug_name`, `label`) VALUES (217,'Active Products/Services','active-productsservices','محصولات/سرویس های فعال شما'),
(218,'Register a New Domain','register-a-new-domain','ثبت دامنه جدید'),
(219,'Recent Support Tickets','recent-support-tickets','تیکت های اخیر'),
(220,'Recent News','recent-news','اخبار اخیر'),
(609,'Unpaid Invoices','unpaid-invoices','صورت حساب های پرداخت نشده');
/*!40000 ALTER TABLE `rsthemes_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_mellat_verification`
--

DROP TABLE IF EXISTS `tbl_mellat_verification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_mellat_verification` (
  `mvid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `salesorderid` varchar(255) NOT NULL,
  `time` varchar(255) NOT NULL,
  `invoiceid` varchar(255) NOT NULL,
  `amount` varchar(255) NOT NULL,
  `resultcode` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `refid` varchar(500) NOT NULL,
  PRIMARY KEY (`mvid`)
) ENGINE=MyISAM AUTO_INCREMENT=857 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_mellat_verification`
--

LOCK TABLES `tbl_mellat_verification` WRITE;
/*!40000 ALTER TABLE `tbl_mellat_verification` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbl_mellat_verification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbl_saman_verification`
--

DROP TABLE IF EXISTS `tbl_saman_verification`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbl_saman_verification` (
  `msvid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `salesorderid` varchar(255) NOT NULL,
  `time` varchar(255) NOT NULL,
  `invoiceid` varchar(255) NOT NULL,
  `amount` varchar(255) NOT NULL,
  `resultcode` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `refid` varchar(255) NOT NULL,
  PRIMARY KEY (`msvid`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbl_saman_verification`
--

LOCK TABLES `tbl_saman_verification` WRITE;
/*!40000 ALTER TABLE `tbl_saman_verification` DISABLE KEYS */;
INSERT INTO `tbl_saman_verification` (`msvid`, `salesorderid`, `time`, `invoiceid`, `amount`, `resultcode`, `status`, `refid`) VALUES (1,'','1543249763','4191','1000','','0','1543249763'),
(2,'','1543249805','4191','1000','','0','1543249805'),
(3,'','1543250136','4191','1000','','0','1543250136'),
(4,'','1543250167','4191','1000','','0','1543250167'),
(5,'','1543250225','4191','1000','','0','1543250225'),
(6,'','1543250264','4191','1000','','0','1543250264'),
(7,'','1543250281','4191','1000','','0','1543250281'),
(8,'','1543250284','4191','1000','','0','1543250284'),
(9,'','1543250304','4191','1000','','0','1543250304'),
(10,'','1543250347','4191','1000','','0','1543250347'),
(11,'','1543250446','4191','1000','','0','1543250446'),
(12,'','1543250611','4191','1000','','0','1543250611'),
(13,'','1543250623','4191','1000','','0','1543250623'),
(14,'','1543250720','4191','1000','','0','1543250720'),
(15,'','1543250772','4191','1000','','0','1543250772'),
(16,'','1543250806','4191','1000','','0','1543250806'),
(17,'','1543250876','4191','1000','','0','1543250876'),
(18,'','1543251230','4191','1000','','0','1543251230'),
(19,'','1543258517','4191','1000','','0','1543258517'),
(20,'','1543258903','4191','1000','0','0','1543258903'),
(21,'','1543259233','4192','1000','0','0','1543259233'),
(22,'','1543333168','4193','1000','0','0','1543333168'),
(23,'','1543334019','4194','1000','','0','1543334019'),
(24,'','1543334073','4194','1000','0','0','1543334073'),
(25,'','1551973076','4210','5550000','','0','1551973076'),
(26,'','1559414896','4249','400000','','0','1559414896'),
(27,'','1559452585','4249','400000','-111','1','1559452585'),
(28,'','1559486846','4249','400000','','0','1559486846'),
(29,'','1559486911','4249','100000','-111','1','1559486911'),
(30,'','1559487020','4249','200000','-111','1','1559487020'),
(31,'','1559539149','4252','100000','-111','1','1559539149'),
(32,'','1560529256','4252','100000','100000','1','1560529256'),
(33,'','1567915048','4288','220000','','0','1567915048'),
(34,'','1588823522','4379','10000000','10000000','1','1588823522'),
(35,'','1589050722','4380','5400000','5400000','1','1589050722'),
(36,'','1603618091','4448','300000','300000','1','1603618091'),
(37,'','1624968073','4549','2900000','2900000','1','1624968073'),
(38,'','1630129482','4575','2670000','2670000','1','1630129482'),
(39,'','1630134794','4575','70000','','0','1630134794'),
(40,'','1630137410','4575','70000','70000','1','1630137410'),
(41,'','1630508621','4578','3200000','','0','1630508621'),
(42,'','1630508640','4579','32000000','','0','1630508640'),
(43,'','1631169232','4576','22600000','','0','1631169232'),
(44,'','1631887725','4584','7920000','','0','1631887725'),
(45,'','1631888361','4584','7920000','','0','1631888361'),
(46,'','1634706914','4600','7600000','','0','1634706914'),
(47,'','1634706944','4600','7600000','','0','1634706944'),
(48,'','1634706979','4600','7600000','','0','1634706979'),
(49,'','1634707006','4600','7600000','','0','1634707006'),
(50,'','1635706476','4598','7875000','','0','1635706476'),
(51,'','1637182218','4609','7600000','7600000','1','1637182218');
/*!40000 ALTER TABLE `tbl_saman_verification` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblaccounts`
--

DROP TABLE IF EXISTS `tblaccounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblaccounts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `currency` int(10) NOT NULL,
  `gateway` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `description` text NOT NULL,
  `amountin` decimal(16,2) NOT NULL DEFAULT 0.00,
  `fees` decimal(16,2) NOT NULL DEFAULT 0.00,
  `amountout` decimal(16,2) NOT NULL DEFAULT 0.00,
  `rate` decimal(16,5) NOT NULL DEFAULT 1.00000,
  `transid` text NOT NULL,
  `invoiceid` int(10) NOT NULL DEFAULT 0,
  `refundid` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `invoiceid` (`invoiceid`),
  KEY `userid` (`userid`),
  KEY `date` (`date`),
  KEY `transid` (`transid`(32))
) ENGINE=MyISAM AUTO_INCREMENT=939 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblaccounts`
--

LOCK TABLES `tblaccounts` WRITE;
/*!40000 ALTER TABLE `tblaccounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblaccounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblactivitylog`
--

DROP TABLE IF EXISTS `tblactivitylog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblactivitylog` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `description` text NOT NULL,
  `user` text NOT NULL,
  `userid` int(10) unsigned NOT NULL DEFAULT 0,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0,
  `admin_id` int(10) unsigned NOT NULL DEFAULT 0,
  `ipaddr` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `user_id` (`user_id`),
  KEY `admin_id` (`admin_id`)
) ENGINE=MyISAM AUTO_INCREMENT=63601 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblactivitylog`
--

LOCK TABLES `tblactivitylog` WRITE;
/*!40000 ALTER TABLE `tblactivitylog` DISABLE KEYS */;
INSERT INTO `tblactivitylog` (`id`, `date`, `description`, `user`, `userid`, `user_id`, `admin_id`, `ipaddr`) VALUES (62778,'2025-11-17 17:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62779,'2025-11-17 17:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62780,'2025-11-17 17:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62781,'2025-11-17 21:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63531,'2025-11-30 01:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63532,'2025-11-30 01:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63408,'2025-11-28 01:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63407,'2025-11-28 01:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63406,'2025-11-27 23:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63524,'2025-11-29 19:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63525,'2025-11-29 19:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63523,'2025-11-29 19:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62663,'2025-11-16 01:55:06','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62664,'2025-11-16 01:55:19','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62665,'2025-11-16 01:55:19','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62666,'2025-11-16 01:55:19','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62667,'2025-11-16 01:55:19','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62668,'2025-11-16 05:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62669,'2025-11-16 05:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62670,'2025-11-16 05:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63476,'2025-11-29 07:40:09','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63475,'2025-11-29 03:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63586,'2025-11-30 19:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63478,'2025-11-29 07:40:09','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62760,'2025-11-17 09:00:54','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(63481,'2025-11-29 09:00:05','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63480,'2025-11-29 09:00:04','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(63479,'2025-11-29 07:40:09','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62682,'2025-11-16 09:00:06','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(62683,'2025-11-16 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63447,'2025-11-28 09:01:39','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63056,'2025-11-22 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63055,'2025-11-22 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63054,'2025-11-22 09:00:06','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(63053,'2025-11-22 09:00:06','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(63052,'2025-11-22 09:00:06','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(63051,'2025-11-22 09:00:05','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(63120,'2025-11-23 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(62704,'2025-11-16 09:55:14','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63081,'2025-11-22 15:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63080,'2025-11-22 15:40:03','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63599,'2025-12-01 03:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63598,'2025-12-01 03:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63482,'2025-11-29 09:00:05','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(63483,'2025-11-29 09:00:05','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(63484,'2025-11-29 09:00:05','Automated Task: Starting Invoices','System',0,0,0,''),
(63485,'2025-11-29 09:00:06','Automated Task: Starting Late Fees','System',0,0,0,''),
(63486,'2025-11-29 09:00:06','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(63487,'2025-11-29 09:00:06','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(62800,'2025-11-18 09:00:06','Automated Task: Starting Invoices','System',0,0,0,''),
(62801,'2025-11-18 09:00:07','Automated Task: Starting Late Fees','System',0,0,0,''),
(62802,'2025-11-18 09:00:07','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(62803,'2025-11-18 09:00:07','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(62603,'2025-11-15 01:55:18','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63542,'2025-11-30 09:00:04','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(63541,'2025-11-30 07:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63540,'2025-11-30 07:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63539,'2025-11-30 07:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62698,'2025-11-16 09:01:55','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(62697,'2025-11-16 09:01:54','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(62696,'2025-11-16 09:01:54','Automated Task: Starting Client Status Update','System',0,0,0,''),
(62695,'2025-11-16 09:01:53','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62694,'2025-11-16 09:01:50','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(62693,'2025-11-16 09:00:06','Automated Task: Starting SSL Sync','System',0,0,0,''),
(62692,'2025-11-16 09:00:06','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(62691,'2025-11-16 09:00:06','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(62690,'2025-11-16 09:00:06','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(62689,'2025-11-16 09:00:06','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(62687,'2025-11-16 09:00:06','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(62688,'2025-11-16 09:00:06','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(62774,'2025-11-17 13:55:18','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62775,'2025-11-17 17:00:08','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62776,'2025-11-17 17:00:08','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62777,'2025-11-17 17:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62658,'2025-11-15 21:55:12','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62659,'2025-11-15 21:55:12','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62660,'2025-11-15 21:55:12','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62661,'2025-11-16 01:00:05','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62662,'2025-11-16 01:00:05','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63201,'2025-11-24 11:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63083,'2025-11-22 15:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62972,'2025-11-21 01:00:10','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62973,'2025-11-21 01:55:05','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62974,'2025-11-21 01:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62731,'2025-11-17 05:55:13','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62730,'2025-11-17 05:55:13','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62729,'2025-11-17 01:55:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62728,'2025-11-17 01:55:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62727,'2025-11-17 01:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62726,'2025-11-17 01:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62725,'2025-11-17 01:55:05','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62724,'2025-11-17 01:00:05','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62723,'2025-11-17 01:00:05','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62722,'2025-11-16 21:55:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62721,'2025-11-16 21:55:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62720,'2025-11-16 21:55:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62718,'2025-11-16 17:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62719,'2025-11-16 21:55:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62717,'2025-11-16 17:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63273,'2025-11-25 17:00:05','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63274,'2025-11-25 17:00:05','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63272,'2025-11-25 15:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63271,'2025-11-25 15:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63376,'2025-11-27 09:00:06','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(63377,'2025-11-27 09:00:06','Automated Task: Starting SSL Sync','System',0,0,0,''),
(62655,'2025-11-15 17:55:12','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62656,'2025-11-15 17:55:12','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62657,'2025-11-15 21:55:12','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63262,'2025-11-25 09:00:39','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(63261,'2025-11-25 09:00:38','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63260,'2025-11-25 09:00:38','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63125,'2025-11-23 09:00:08','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(63124,'2025-11-23 09:00:08','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63251,'2025-11-25 09:00:06','Automated Task: Starting Credit Card Expiry Notices','System',0,0,0,''),
(63312,'2025-11-26 09:00:05','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63432,'2025-11-28 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(63126,'2025-11-23 09:00:08','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(62797,'2025-11-18 09:00:06','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(62798,'2025-11-18 09:00:06','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(62799,'2025-11-18 09:00:06','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(62796,'2025-11-18 09:00:04','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(62795,'2025-11-18 05:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62794,'2025-11-18 05:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62793,'2025-11-18 05:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62792,'2025-11-18 05:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62791,'2025-11-18 01:55:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62790,'2025-11-18 01:55:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62789,'2025-11-18 01:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62788,'2025-11-18 01:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62787,'2025-11-18 01:55:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63135,'2025-11-23 09:00:41','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62653,'2025-11-15 17:55:12','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62654,'2025-11-15 17:55:12','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63555,'2025-11-30 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(63595,'2025-12-01 01:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63594,'2025-12-01 01:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63593,'2025-11-30 23:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63591,'2025-11-30 23:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63592,'2025-11-30 23:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63589,'2025-11-30 19:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63590,'2025-11-30 23:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63588,'2025-11-30 19:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63587,'2025-11-30 19:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62932,'2025-11-20 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62931,'2025-11-20 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62930,'2025-11-20 09:00:06','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(62929,'2025-11-20 09:00:06','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(62875,'2025-11-19 09:00:08','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(62874,'2025-11-19 09:00:08','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(62873,'2025-11-19 09:00:08','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63006,'2025-11-21 09:00:53','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63007,'2025-11-21 09:00:53','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(63005,'2025-11-21 09:00:53','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62876,'2025-11-19 09:00:08','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63567,'2025-11-30 09:01:39','Automated Task: Starting Client Status Update','System',0,0,0,''),
(62887,'2025-11-19 09:01:05','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63375,'2025-11-27 09:00:06','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(63064,'2025-11-22 09:00:06','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(63065,'2025-11-22 09:00:06','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63066,'2025-11-22 09:01:40','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(62939,'2025-11-20 09:00:07','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(62937,'2025-11-20 09:00:07','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(62938,'2025-11-20 09:00:07','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63194,'2025-11-24 09:01:40','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(62707,'2025-11-16 09:55:15','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62708,'2025-11-16 13:55:09','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62709,'2025-11-16 13:55:21','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62710,'2025-11-16 13:55:21','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62711,'2025-11-16 13:55:21','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62712,'2025-11-16 13:55:21','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62713,'2025-11-16 17:00:07','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62714,'2025-11-16 17:00:07','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62715,'2025-11-16 17:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62716,'2025-11-16 17:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62830,'2025-11-18 09:55:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62831,'2025-11-18 09:55:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62832,'2025-11-18 13:55:05','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62833,'2025-11-18 13:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62834,'2025-11-18 13:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62835,'2025-11-18 13:55:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62836,'2025-11-18 13:55:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62837,'2025-11-18 17:00:06','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62962,'2025-11-20 17:00:06','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62961,'2025-11-20 17:00:06','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63077,'2025-11-22 11:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63076,'2025-11-22 11:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63075,'2025-11-22 09:01:45','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(62956,'2025-11-20 13:55:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62621,'2025-11-15 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62619,'2025-11-15 09:00:07','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(62618,'2025-11-15 09:00:07','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(62620,'2025-11-15 09:00:07','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(62922,'2025-11-20 09:00:06','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(62923,'2025-11-20 09:00:06','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(62924,'2025-11-20 09:00:06','Automated Task: Starting Invoices','System',0,0,0,''),
(62925,'2025-11-20 09:00:06','Automated Task: Starting Late Fees','System',0,0,0,''),
(62926,'2025-11-20 09:00:06','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(62927,'2025-11-20 09:00:06','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(62928,'2025-11-20 09:00:06','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(62839,'2025-11-18 17:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62840,'2025-11-18 17:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62971,'2025-11-21 01:00:10','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62970,'2025-11-20 21:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62968,'2025-11-20 21:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62969,'2025-11-20 21:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62590,'2025-11-14 17:00:08','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62914,'2025-11-20 01:55:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62913,'2025-11-20 01:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62912,'2025-11-20 01:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62911,'2025-11-20 01:55:05','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62910,'2025-11-20 01:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62909,'2025-11-20 01:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62908,'2025-11-19 21:55:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62907,'2025-11-19 21:55:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62906,'2025-11-19 21:55:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62905,'2025-11-19 21:55:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62904,'2025-11-19 17:55:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62578,'2025-11-14 09:01:40','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(63204,'2025-11-24 15:40:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63203,'2025-11-24 11:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63136,'2025-11-23 09:00:41','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(63013,'2025-11-21 09:00:54','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63557,'2025-11-30 09:00:06','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63558,'2025-11-30 09:00:06','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(63263,'2025-11-25 09:00:39','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63078,'2025-11-22 11:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63202,'2025-11-24 11:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63169,'2025-11-24 09:00:05','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63170,'2025-11-24 09:00:05','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(63171,'2025-11-24 09:00:05','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(63172,'2025-11-24 09:00:05','Automated Task: Starting Invoices','System',0,0,0,''),
(63173,'2025-11-24 09:00:06','Automated Task: Starting Late Fees','System',0,0,0,''),
(63174,'2025-11-24 09:00:06','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(63175,'2025-11-24 09:00:06','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(63176,'2025-11-24 09:00:06','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(63177,'2025-11-24 09:00:06','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(63178,'2025-11-24 09:00:06','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(63179,'2025-11-24 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63421,'2025-11-28 09:00:06','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(63420,'2025-11-28 09:00:06','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(63105,'2025-11-23 07:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63147,'2025-11-23 17:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63148,'2025-11-23 17:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63149,'2025-11-23 19:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63150,'2025-11-23 19:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63151,'2025-11-23 19:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63152,'2025-11-23 19:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63153,'2025-11-23 23:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63154,'2025-11-23 23:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63155,'2025-11-23 23:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63156,'2025-11-23 23:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63119,'2025-11-23 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(63032,'2025-11-21 21:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63033,'2025-11-22 03:40:07','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63034,'2025-11-22 03:40:19','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63035,'2025-11-22 03:40:19','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63036,'2025-11-22 03:40:19','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62994,'2025-11-21 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62995,'2025-11-21 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(62996,'2025-11-21 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(62997,'2025-11-21 09:00:07','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(62998,'2025-11-21 09:00:07','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(62999,'2025-11-21 09:00:07','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63000,'2025-11-21 09:00:07','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63001,'2025-11-21 09:00:07','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(63002,'2025-11-21 09:00:08','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(63003,'2025-11-21 09:00:08','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63431,'2025-11-28 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(63254,'2025-11-25 09:00:35','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(63255,'2025-11-25 09:00:38','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(63383,'2025-11-27 09:00:39','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(63384,'2025-11-27 09:00:39','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63385,'2025-11-27 09:00:39','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63374,'2025-11-27 09:00:06','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63373,'2025-11-27 09:00:05','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63315,'2025-11-26 09:00:05','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63252,'2025-11-25 09:00:06','Cron Job: Sent 0 Credit Card Expiry Notices','System',0,0,0,''),
(63188,'2025-11-24 09:00:06','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(62814,'2025-11-18 09:00:07','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(62812,'2025-11-18 09:00:07','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(62813,'2025-11-18 09:00:07','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63243,'2025-11-25 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(62768,'2025-11-17 09:55:18','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62769,'2025-11-17 09:55:18','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62770,'2025-11-17 13:55:06','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63190,'2025-11-24 09:01:37','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(62828,'2025-11-18 09:55:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62827,'2025-11-18 09:01:47','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(62598,'2025-11-14 21:55:12','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62599,'2025-11-15 01:00:09','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62600,'2025-11-15 01:00:09','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62601,'2025-11-15 01:55:06','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62602,'2025-11-15 01:55:18','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63334,'2025-11-26 15:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63335,'2025-11-26 17:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63220,'2025-11-25 01:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63211,'2025-11-24 19:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63212,'2025-11-24 19:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63213,'2025-11-24 19:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63214,'2025-11-24 19:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63215,'2025-11-24 23:40:09','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63216,'2025-11-24 23:40:09','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63217,'2025-11-24 23:40:09','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63218,'2025-11-24 23:40:09','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63219,'2025-11-25 01:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63346,'2025-11-27 01:00:03','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63347,'2025-11-27 03:40:03','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63348,'2025-11-27 03:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63349,'2025-11-27 03:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63350,'2025-11-27 03:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63351,'2025-11-27 03:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63352,'2025-11-27 07:40:09','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63452,'2025-11-28 11:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63453,'2025-11-28 11:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63454,'2025-11-28 15:40:03','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63455,'2025-11-28 15:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62940,'2025-11-20 09:00:07','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(63106,'2025-11-23 09:00:05','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(63107,'2025-11-23 09:00:07','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63506,'2025-11-29 09:00:44','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(63507,'2025-11-29 09:00:44','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(63508,'2025-11-29 09:00:44','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63221,'2025-11-25 03:40:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63222,'2025-11-25 03:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63223,'2025-11-25 03:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63224,'2025-11-25 03:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63225,'2025-11-25 03:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63226,'2025-11-25 07:40:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63227,'2025-11-25 07:40:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63302,'2025-11-26 09:00:05','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(63300,'2025-11-26 09:00:05','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(63301,'2025-11-26 09:00:05','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(63299,'2025-11-26 09:00:05','Automated Task: Starting Late Fees','System',0,0,0,''),
(63298,'2025-11-26 09:00:04','Automated Task: Starting Invoices','System',0,0,0,''),
(63014,'2025-11-21 09:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63015,'2025-11-21 09:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63016,'2025-11-21 09:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63017,'2025-11-21 09:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63018,'2025-11-21 13:55:05','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63019,'2025-11-21 13:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63020,'2025-11-21 13:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63021,'2025-11-21 13:55:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63022,'2025-11-21 13:55:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63023,'2025-11-21 17:00:07','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63024,'2025-11-21 17:00:07','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63025,'2025-11-21 17:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63026,'2025-11-21 17:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63027,'2025-11-21 17:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63028,'2025-11-21 17:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63029,'2025-11-21 21:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63030,'2025-11-21 21:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63031,'2025-11-21 21:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63270,'2025-11-25 15:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63269,'2025-11-25 15:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63268,'2025-11-25 15:40:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63267,'2025-11-25 11:40:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63266,'2025-11-25 11:40:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63108,'2025-11-23 09:00:07','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(63109,'2025-11-23 09:00:07','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(63110,'2025-11-23 09:00:07','Automated Task: Starting Invoices','System',0,0,0,''),
(63111,'2025-11-23 09:00:07','Automated Task: Starting Late Fees','System',0,0,0,''),
(63112,'2025-11-23 09:00:07','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(63113,'2025-11-23 09:00:07','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(62628,'2025-11-15 09:00:07','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63164,'2025-11-24 07:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63163,'2025-11-24 03:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63168,'2025-11-24 09:00:03','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(63167,'2025-11-24 07:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63166,'2025-11-24 07:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63165,'2025-11-24 07:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63103,'2025-11-23 07:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63140,'2025-11-23 11:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63104,'2025-11-23 07:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63162,'2025-11-24 03:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63161,'2025-11-24 03:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63160,'2025-11-24 03:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63159,'2025-11-24 03:40:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63158,'2025-11-24 01:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63157,'2025-11-24 01:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62979,'2025-11-21 05:55:12','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63330,'2025-11-26 15:40:03','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63331,'2025-11-26 15:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63332,'2025-11-26 15:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63180,'2025-11-24 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62577,'2025-11-14 09:01:40','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63340,'2025-11-26 19:40:09','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63341,'2025-11-26 23:40:09','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63338,'2025-11-26 19:40:09','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63339,'2025-11-26 19:40:09','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63253,'2025-11-25 09:00:06','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63551,'2025-11-30 09:00:06','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(63552,'2025-11-30 09:00:06','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(63292,'2025-11-26 07:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63293,'2025-11-26 07:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63294,'2025-11-26 09:00:03','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(63295,'2025-11-26 09:00:04','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63296,'2025-11-26 09:00:04','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(63297,'2025-11-26 09:00:04','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(62623,'2025-11-15 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(62622,'2025-11-15 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62627,'2025-11-15 09:00:07','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(62625,'2025-11-15 09:00:07','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(62626,'2025-11-15 09:00:07','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(62624,'2025-11-15 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(63600,'2025-12-01 03:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63503,'2025-11-29 09:00:43','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62585,'2025-11-14 13:55:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63139,'2025-11-23 11:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63553,'2025-11-30 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63336,'2025-11-26 17:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63337,'2025-11-26 19:40:09','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63545,'2025-11-30 09:00:05','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(63544,'2025-11-30 09:00:05','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(63543,'2025-11-30 09:00:05','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63118,'2025-11-23 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63116,'2025-11-23 09:00:08','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(63117,'2025-11-23 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62735,'2025-11-17 09:00:07','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(62734,'2025-11-17 09:00:05','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(62782,'2025-11-17 21:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62783,'2025-11-17 21:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62784,'2025-11-17 21:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63538,'2025-11-30 07:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63537,'2025-11-30 03:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63536,'2025-11-30 03:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63535,'2025-11-30 03:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63534,'2025-11-30 03:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63533,'2025-11-30 03:40:03','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63205,'2025-11-24 15:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63206,'2025-11-24 15:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63207,'2025-11-24 15:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63208,'2025-11-24 15:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63209,'2025-11-24 17:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63210,'2025-11-24 17:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63308,'2025-11-26 09:00:05','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(63309,'2025-11-26 09:00:05','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63310,'2025-11-26 09:00:05','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(63311,'2025-11-26 09:00:05','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63434,'2025-11-28 09:00:07','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(63433,'2025-11-28 09:00:07','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(62978,'2025-11-21 05:55:12','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62977,'2025-11-21 01:55:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62976,'2025-11-21 01:55:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63199,'2025-11-24 09:01:41','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63200,'2025-11-24 11:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62604,'2025-11-15 01:55:18','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62605,'2025-11-15 01:55:18','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62606,'2025-11-15 05:55:12','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62607,'2025-11-15 05:55:12','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62608,'2025-11-15 05:55:12','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62815,'2025-11-18 09:00:07','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(62816,'2025-11-18 09:00:07','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(63550,'2025-11-30 09:00:06','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(63303,'2025-11-26 09:00:05','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(63041,'2025-11-22 07:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63039,'2025-11-22 03:40:19','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63040,'2025-11-22 07:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63596,'2025-12-01 03:40:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63597,'2025-12-01 03:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63275,'2025-11-25 19:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63276,'2025-11-25 19:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63277,'2025-11-25 19:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63278,'2025-11-25 19:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63279,'2025-11-25 23:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63280,'2025-11-25 23:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63281,'2025-11-25 23:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63282,'2025-11-25 23:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63283,'2025-11-26 01:00:03','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63284,'2025-11-26 01:00:03','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63285,'2025-11-26 03:40:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63286,'2025-11-26 03:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63287,'2025-11-26 03:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63288,'2025-11-26 03:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63289,'2025-11-26 03:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63290,'2025-11-26 07:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63291,'2025-11-26 07:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62804,'2025-11-18 09:00:07','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(62805,'2025-11-18 09:00:07','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(62806,'2025-11-18 09:00:07','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(62807,'2025-11-18 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62808,'2025-11-18 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62809,'2025-11-18 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(62810,'2025-11-18 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(62637,'2025-11-15 09:00:49','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(62638,'2025-11-15 09:00:50','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62639,'2025-11-15 09:00:50','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62739,'2025-11-17 09:00:08','Automated Task: Starting Late Fees','System',0,0,0,''),
(62740,'2025-11-17 09:00:08','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(63396,'2025-11-27 15:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63397,'2025-11-27 17:00:03','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63398,'2025-11-27 17:00:03','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62767,'2025-11-17 09:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62699,'2025-11-16 09:01:55','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(63369,'2025-11-27 09:00:05','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(63371,'2025-11-27 09:00:05','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63370,'2025-11-27 09:00:05','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(62629,'2025-11-15 09:00:07','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(62630,'2025-11-15 09:00:08','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(62631,'2025-11-15 09:00:08','Automated Task: Starting SSL Sync','System',0,0,0,''),
(62632,'2025-11-15 09:00:46','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(62633,'2025-11-15 09:00:49','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62851,'2025-11-19 01:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63417,'2025-11-28 07:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63416,'2025-11-28 07:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63415,'2025-11-28 07:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63414,'2025-11-28 07:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63413,'2025-11-28 03:40:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63412,'2025-11-28 03:40:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63411,'2025-11-28 03:40:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63410,'2025-11-28 03:40:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63333,'2025-11-26 15:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62749,'2025-11-17 09:00:08','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63423,'2025-11-28 09:00:07','Automated Task: Starting Late Fees','System',0,0,0,''),
(63326,'2025-11-26 11:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63325,'2025-11-26 09:01:41','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63328,'2025-11-26 11:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63327,'2025-11-26 11:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63448,'2025-11-28 09:01:40','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(63549,'2025-11-30 09:00:06','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(63546,'2025-11-30 09:00:05','Automated Task: Starting Invoices','System',0,0,0,''),
(63547,'2025-11-30 09:00:06','Automated Task: Starting Late Fees','System',0,0,0,''),
(63548,'2025-11-30 09:00:06','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(62915,'2025-11-20 01:55:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62916,'2025-11-20 05:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62917,'2025-11-20 05:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62918,'2025-11-20 05:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62919,'2025-11-20 05:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62920,'2025-11-20 09:00:04','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(62921,'2025-11-20 09:00:05','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(62786,'2025-11-18 01:00:05','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62785,'2025-11-18 01:00:05','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62596,'2025-11-14 21:55:12','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62705,'2025-11-16 09:55:14','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62706,'2025-11-16 09:55:15','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63569,'2025-11-30 09:01:39','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(63409,'2025-11-28 03:40:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63584,'2025-11-30 17:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63530,'2025-11-29 23:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63528,'2025-11-29 23:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63529,'2025-11-29 23:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63477,'2025-11-29 07:40:09','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63585,'2025-11-30 17:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63418,'2025-11-28 09:00:04','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(63419,'2025-11-28 09:00:06','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63582,'2025-11-30 15:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63583,'2025-11-30 15:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63581,'2025-11-30 15:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63578,'2025-11-30 11:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63579,'2025-11-30 15:40:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63580,'2025-11-30 15:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63510,'2025-11-29 09:00:44','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(63387,'2025-11-27 09:00:40','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63388,'2025-11-27 11:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63389,'2025-11-27 11:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63390,'2025-11-27 11:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63316,'2025-11-26 09:01:37','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(63439,'2025-11-28 09:00:07','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63438,'2025-11-28 09:00:07','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(62950,'2025-11-20 09:01:43','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(62680,'2025-11-16 09:00:06','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(62681,'2025-11-16 09:00:06','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(62679,'2025-11-16 09:00:06','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(62678,'2025-11-16 09:00:06','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(62677,'2025-11-16 09:00:06','Automated Task: Starting Late Fees','System',0,0,0,''),
(62676,'2025-11-16 09:00:05','Automated Task: Starting Invoices','System',0,0,0,''),
(63048,'2025-11-22 09:00:05','Automated Task: Starting Invoices','System',0,0,0,''),
(63049,'2025-11-22 09:00:05','Automated Task: Starting Late Fees','System',0,0,0,''),
(63050,'2025-11-22 09:00:05','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(63047,'2025-11-22 09:00:05','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(63469,'2025-11-29 01:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63470,'2025-11-29 01:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63471,'2025-11-29 03:40:03','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63472,'2025-11-29 03:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63526,'2025-11-29 19:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63527,'2025-11-29 23:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63474,'2025-11-29 03:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63473,'2025-11-29 03:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63368,'2025-11-27 09:00:05','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63367,'2025-11-27 09:00:05','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63004,'2025-11-21 09:00:50','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(63063,'2025-11-22 09:00:06','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(63061,'2025-11-22 09:00:06','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63062,'2025-11-22 09:00:06','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(62822,'2025-11-18 09:01:46','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(62825,'2025-11-18 09:01:46','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62823,'2025-11-18 09:01:46','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(62824,'2025-11-18 09:01:46','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62844,'2025-11-18 21:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62845,'2025-11-18 21:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62846,'2025-11-18 21:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62847,'2025-11-19 01:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62848,'2025-11-19 01:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62849,'2025-11-19 01:55:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62850,'2025-11-19 01:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62821,'2025-11-18 09:01:46','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(63130,'2025-11-23 09:00:40','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63131,'2025-11-23 09:00:40','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(62587,'2025-11-14 13:55:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63187,'2025-11-24 09:00:06','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(62671,'2025-11-16 05:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62672,'2025-11-16 09:00:04','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(62673,'2025-11-16 09:00:05','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(62674,'2025-11-16 09:00:05','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(62675,'2025-11-16 09:00:05','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(63522,'2025-11-29 17:00:05','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63521,'2025-11-29 17:00:05','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62763,'2025-11-17 09:00:54','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63511,'2025-11-29 09:00:45','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63512,'2025-11-29 11:40:12','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63513,'2025-11-29 11:40:12','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63514,'2025-11-29 11:40:12','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63515,'2025-11-29 11:40:12','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63516,'2025-11-29 15:40:03','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63467,'2025-11-28 23:40:09','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63468,'2025-11-28 23:40:09','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62761,'2025-11-17 09:00:54','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(62762,'2025-11-17 09:00:54','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63317,'2025-11-26 09:01:40','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62811,'2025-11-18 09:00:07','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63059,'2025-11-22 09:00:06','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63060,'2025-11-22 09:00:06','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(63517,'2025-11-29 15:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63518,'2025-11-29 15:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63519,'2025-11-29 15:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63520,'2025-11-29 15:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62738,'2025-11-17 09:00:07','Automated Task: Starting Invoices','System',0,0,0,''),
(62737,'2025-11-17 09:00:07','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(62736,'2025-11-17 09:00:07','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(63560,'2025-11-30 09:00:06','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63559,'2025-11-30 09:00:06','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63132,'2025-11-23 09:00:41','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(62732,'2025-11-17 05:55:13','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62733,'2025-11-17 05:55:13','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63576,'2025-11-30 11:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63577,'2025-11-30 11:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63575,'2025-11-30 11:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63574,'2025-11-30 09:01:40','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(62574,'2025-11-14 09:01:39','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(62575,'2025-11-14 09:01:40','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(62576,'2025-11-14 09:01:40','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62701,'2025-11-16 09:01:56','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62702,'2025-11-16 09:01:57','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(63450,'2025-11-28 11:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63451,'2025-11-28 11:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63449,'2025-11-28 09:01:40','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63573,'2025-11-30 09:01:39','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(62684,'2025-11-16 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62685,'2025-11-16 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(62686,'2025-11-16 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(62609,'2025-11-15 05:55:12','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62610,'2025-11-15 09:00:04','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(62611,'2025-11-15 09:00:06','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(62612,'2025-11-15 09:00:06','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(62613,'2025-11-15 09:00:06','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(62614,'2025-11-15 09:00:06','Automated Task: Starting Invoices','System',0,0,0,''),
(62615,'2025-11-15 09:00:07','Automated Task: Starting Late Fees','System',0,0,0,''),
(62616,'2025-11-15 09:00:07','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(62617,'2025-11-15 09:00:07','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(62852,'2025-11-19 01:55:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62853,'2025-11-19 01:55:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62854,'2025-11-19 05:55:09','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62855,'2025-11-19 05:55:09','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62856,'2025-11-19 05:55:09','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63307,'2025-11-26 09:00:05','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(63306,'2025-11-26 09:00:05','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63305,'2025-11-26 09:00:05','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63304,'2025-11-26 09:00:05','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(63141,'2025-11-23 11:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63142,'2025-11-23 15:40:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63143,'2025-11-23 15:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63144,'2025-11-23 15:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63145,'2025-11-23 15:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63146,'2025-11-23 15:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62872,'2025-11-19 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(62871,'2025-11-19 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(62870,'2025-11-19 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62869,'2025-11-19 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62868,'2025-11-19 09:00:08','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(62867,'2025-11-19 09:00:08','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(62866,'2025-11-19 09:00:08','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(62865,'2025-11-19 09:00:08','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(62864,'2025-11-19 09:00:08','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(62863,'2025-11-19 09:00:08','Automated Task: Starting Late Fees','System',0,0,0,''),
(62861,'2025-11-19 09:00:07','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(62862,'2025-11-19 09:00:07','Automated Task: Starting Invoices','System',0,0,0,''),
(62860,'2025-11-19 09:00:07','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(62859,'2025-11-19 09:00:07','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(62858,'2025-11-19 09:00:05','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(62857,'2025-11-19 05:55:09','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63380,'2025-11-27 09:00:39','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63038,'2025-11-22 03:40:19','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63037,'2025-11-22 03:40:19','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62933,'2025-11-20 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(62936,'2025-11-20 09:00:07','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(62935,'2025-11-20 09:00:07','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(62934,'2025-11-20 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(63344,'2025-11-26 23:40:09','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63345,'2025-11-27 01:00:03','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63115,'2025-11-23 09:00:08','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(63114,'2025-11-23 09:00:07','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(63353,'2025-11-27 07:40:09','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63354,'2025-11-27 07:40:09','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62984,'2025-11-21 09:00:06','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(62985,'2025-11-21 09:00:06','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(62986,'2025-11-21 09:00:06','Automated Task: Starting Invoices','System',0,0,0,''),
(62987,'2025-11-21 09:00:07','Automated Task: Starting Late Fees','System',0,0,0,''),
(62988,'2025-11-21 09:00:07','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(62989,'2025-11-21 09:00:07','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(62990,'2025-11-21 09:00:07','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(62991,'2025-11-21 09:00:07','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(62992,'2025-11-21 09:00:07','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(62993,'2025-11-21 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63123,'2025-11-23 09:00:08','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63122,'2025-11-23 09:00:08','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(63121,'2025-11-23 09:00:08','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63246,'2025-11-25 09:00:06','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(63245,'2025-11-25 09:00:06','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63244,'2025-11-25 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(62652,'2025-11-15 17:00:10','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62651,'2025-11-15 17:00:09','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62650,'2025-11-15 13:55:21','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63264,'2025-11-25 11:40:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63265,'2025-11-25 11:40:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63247,'2025-11-25 09:00:06','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63248,'2025-11-25 09:00:06','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(62771,'2025-11-17 13:55:18','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63342,'2025-11-26 23:40:09','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63343,'2025-11-26 23:40:09','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62980,'2025-11-21 05:55:12','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62981,'2025-11-21 05:55:12','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62982,'2025-11-21 09:00:05','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(62983,'2025-11-21 09:00:06','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63228,'2025-11-25 07:40:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63229,'2025-11-25 07:40:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63230,'2025-11-25 09:00:03','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(63231,'2025-11-25 09:00:04','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63232,'2025-11-25 09:00:04','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(63233,'2025-11-25 09:00:04','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(63234,'2025-11-25 09:00:04','Automated Task: Starting Invoices','System',0,0,0,''),
(63235,'2025-11-25 09:00:05','Automated Task: Starting Late Fees','System',0,0,0,''),
(63236,'2025-11-25 09:00:05','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(63237,'2025-11-25 09:00:05','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(63238,'2025-11-25 09:00:05','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(63239,'2025-11-25 09:00:06','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(63240,'2025-11-25 09:00:06','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(63241,'2025-11-25 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63242,'2025-11-25 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63391,'2025-11-27 11:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63392,'2025-11-27 15:40:03','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63393,'2025-11-27 15:40:16','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63394,'2025-11-27 15:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63395,'2025-11-27 15:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63366,'2025-11-27 09:00:05','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(63365,'2025-11-27 09:00:05','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(63364,'2025-11-27 09:00:05','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(63363,'2025-11-27 09:00:05','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(63361,'2025-11-27 09:00:05','Automated Task: Starting Late Fees','System',0,0,0,''),
(63362,'2025-11-27 09:00:05','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(63360,'2025-11-27 09:00:05','Automated Task: Starting Invoices','System',0,0,0,''),
(63359,'2025-11-27 09:00:05','Cron Job: Products Updated for Current Rates','System',0,0,0,''),
(63358,'2025-11-27 09:00:04','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(63357,'2025-11-27 09:00:04','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63356,'2025-11-27 09:00:03','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(63355,'2025-11-27 07:40:09','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63405,'2025-11-27 23:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63403,'2025-11-27 23:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63404,'2025-11-27 23:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63401,'2025-11-27 19:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63402,'2025-11-27 19:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63400,'2025-11-27 19:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63399,'2025-11-27 19:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62759,'2025-11-17 09:00:54','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(62634,'2025-11-15 09:00:49','Automated Task: Starting Client Status Update','System',0,0,0,''),
(62635,'2025-11-15 09:00:49','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(62636,'2025-11-15 09:00:49','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(63465,'2025-11-28 23:40:09','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63466,'2025-11-28 23:40:09','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63464,'2025-11-28 19:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63456,'2025-11-28 15:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63457,'2025-11-28 15:40:16','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63458,'2025-11-28 15:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63459,'2025-11-28 17:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63460,'2025-11-28 17:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63461,'2025-11-28 19:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63462,'2025-11-28 19:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63463,'2025-11-28 19:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63042,'2025-11-22 07:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63043,'2025-11-22 07:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63044,'2025-11-22 09:00:04','Cron Job: Starting Daily Automation Tasks','System',0,0,0,''),
(63045,'2025-11-22 09:00:05','Automated Task: Starting Currency Exchange Rates','System',0,0,0,''),
(63046,'2025-11-22 09:00:05','Automated Task: Starting Product Pricing Updates','System',0,0,0,''),
(62841,'2025-11-18 17:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62842,'2025-11-18 17:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62843,'2025-11-18 21:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62955,'2025-11-20 09:55:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62944,'2025-11-20 09:01:42','Automated Task: Starting Client Status Update','System',0,0,0,''),
(62945,'2025-11-20 09:01:42','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(63554,'2025-11-30 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63488,'2025-11-29 09:00:06','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(63489,'2025-11-29 09:00:06','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(63490,'2025-11-29 09:00:06','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(63491,'2025-11-29 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63084,'2025-11-22 15:40:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63085,'2025-11-22 17:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63086,'2025-11-22 17:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63087,'2025-11-22 19:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63088,'2025-11-22 19:40:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63089,'2025-11-22 19:40:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63090,'2025-11-22 19:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63091,'2025-11-22 23:40:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63092,'2025-11-22 23:40:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63093,'2025-11-22 23:40:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63094,'2025-11-22 23:40:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63095,'2025-11-23 01:00:04','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63096,'2025-11-23 01:00:04','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63097,'2025-11-23 03:40:03','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63098,'2025-11-23 03:40:15','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63099,'2025-11-23 03:40:15','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63100,'2025-11-23 03:40:15','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63101,'2025-11-23 03:40:15','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63102,'2025-11-23 07:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62948,'2025-11-20 09:01:43','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63561,'2025-11-30 09:00:07','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(63430,'2025-11-28 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63429,'2025-11-28 09:00:07','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(63428,'2025-11-28 09:00:07','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(63181,'2025-11-24 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(63182,'2025-11-24 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(63183,'2025-11-24 09:00:06','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63184,'2025-11-24 09:00:06','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(63185,'2025-11-24 09:00:06','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63313,'2025-11-26 09:00:05','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(63250,'2025-11-25 09:00:06','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(63249,'2025-11-25 09:00:06','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(63504,'2025-11-29 09:00:44','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63505,'2025-11-29 09:00:44','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(63562,'2025-11-30 09:00:07','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(63563,'2025-11-30 09:00:07','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63564,'2025-11-30 09:01:36','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(63498,'2025-11-29 09:00:07','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63497,'2025-11-29 09:00:07','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63496,'2025-11-29 09:00:07','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(63495,'2025-11-29 09:00:06','Automated Task: Starting Overdue Suspensions','System',0,0,0,''),
(63494,'2025-11-29 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(63493,'2025-11-29 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(63446,'2025-11-28 09:01:39','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63422,'2025-11-28 09:00:06','Automated Task: Starting Invoices','System',0,0,0,''),
(62764,'2025-11-17 09:00:54','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(62641,'2025-11-15 09:00:51','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63008,'2025-11-21 09:00:53','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(62885,'2025-11-19 09:01:05','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(62882,'2025-11-19 09:01:05','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63572,'2025-11-30 09:01:39','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62879,'2025-11-19 09:00:08','Automated Task: Starting SSL Sync','System',0,0,0,''),
(62880,'2025-11-19 09:01:01','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(62881,'2025-11-19 09:01:05','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62942,'2025-11-20 09:01:39','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(62941,'2025-11-20 09:00:07','Automated Task: Starting SSL Sync','System',0,0,0,''),
(62878,'2025-11-19 09:00:08','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(62877,'2025-11-19 09:00:08','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(62826,'2025-11-18 09:01:46','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(62703,'2025-11-16 09:02:00','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(62644,'2025-11-15 09:55:11','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62645,'2025-11-15 09:55:11','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63318,'2025-11-26 09:01:40','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63010,'2025-11-21 09:00:53','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62649,'2025-11-15 13:55:21','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63197,'2025-11-24 09:01:41','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62648,'2025-11-15 13:55:21','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62647,'2025-11-15 13:55:21','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62646,'2025-11-15 13:55:08','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63068,'2025-11-22 09:01:43','Automated Task: Starting Client Status Update','System',0,0,0,''),
(62954,'2025-11-20 09:55:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62953,'2025-11-20 09:55:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62900,'2025-11-19 17:00:06','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62901,'2025-11-19 17:55:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63571,'2025-11-30 09:01:39','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62898,'2025-11-19 13:55:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62899,'2025-11-19 17:00:06','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62975,'2025-11-21 01:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62949,'2025-11-20 09:01:43','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62758,'2025-11-17 09:00:54','Automated Task: Starting Client Status Update','System',0,0,0,''),
(62757,'2025-11-17 09:00:53','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62756,'2025-11-17 09:00:50','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(62960,'2025-11-20 13:55:17','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62883,'2025-11-19 09:01:05','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(63134,'2025-11-23 09:00:41','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63133,'2025-11-23 09:00:41','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(62892,'2025-11-19 09:55:13','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62893,'2025-11-19 09:55:13','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62894,'2025-11-19 13:55:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(62895,'2025-11-19 13:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62896,'2025-11-19 13:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62897,'2025-11-19 13:55:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63079,'2025-11-22 11:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62958,'2025-11-20 13:55:17','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62959,'2025-11-20 13:55:17','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62957,'2025-11-20 13:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62947,'2025-11-20 09:01:43','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(62748,'2025-11-17 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(63257,'2025-11-25 09:00:38','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(62581,'2025-11-14 09:55:13','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62582,'2025-11-14 09:55:13','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62583,'2025-11-14 09:55:13','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62967,'2025-11-20 21:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62966,'2025-11-20 17:55:19','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62965,'2025-11-20 17:55:19','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62964,'2025-11-20 17:55:19','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62963,'2025-11-20 17:55:19','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63444,'2025-11-28 09:01:39','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(63445,'2025-11-28 09:01:39','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(63509,'2025-11-29 09:00:44','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62746,'2025-11-17 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62745,'2025-11-17 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - admin -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62744,'2025-11-17 09:00:08','Automated Task: Starting Cancellation Requests','System',0,0,0,''),
(62743,'2025-11-17 09:00:08','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(62742,'2025-11-17 09:00:08','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(62741,'2025-11-17 09:00:08','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(62890,'2025-11-19 09:55:12','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63138,'2025-11-23 11:40:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63137,'2025-11-23 09:00:42','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63082,'2025-11-22 15:40:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63071,'2025-11-22 09:01:44','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(63069,'2025-11-22 09:01:44','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(63070,'2025-11-22 09:01:44','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(62943,'2025-11-20 09:01:42','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62817,'2025-11-18 09:00:07','Automated Task: Starting SSL Sync','System',0,0,0,''),
(62818,'2025-11-18 09:01:42','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(62819,'2025-11-18 09:01:45','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62820,'2025-11-18 09:01:45','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63191,'2025-11-24 09:01:40','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(63127,'2025-11-23 09:00:08','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63189,'2025-11-24 09:00:06','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63378,'2025-11-27 09:00:36','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(63324,'2025-11-26 09:01:40','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(63012,'2025-11-21 09:00:53','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(62592,'2025-11-14 17:55:14','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62766,'2025-11-17 09:55:17','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(63073,'2025-11-22 09:01:44','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63072,'2025-11-22 09:01:44','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63196,'2025-11-24 09:01:40','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63195,'2025-11-24 09:01:40','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(63442,'2025-11-28 09:01:39','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63568,'2025-11-30 09:01:39','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(63074,'2025-11-22 09:01:44','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(62642,'2025-11-15 09:55:11','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62886,'2025-11-19 09:01:05','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62589,'2025-11-14 17:00:08','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(62588,'2025-11-14 13:55:16','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63570,'2025-11-30 09:01:39','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(63256,'2025-11-25 09:00:38','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63322,'2025-11-26 09:01:40','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63128,'2025-11-23 09:00:37','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(63129,'2025-11-23 09:00:40','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(63425,'2025-11-28 09:00:07','Automated Task: Starting Credit Card Charges','System',0,0,0,''),
(63492,'2025-11-29 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی خارج پلان اول - kharej-server.com -   (Due Date: 2023/02/23)','System',0,0,0,''),
(62591,'2025-11-14 17:55:14','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62903,'2025-11-19 17:55:10','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(63441,'2025-11-28 09:01:39','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(63440,'2025-11-28 09:01:36','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(63058,'2025-11-22 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(63057,'2025-11-22 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(63435,'2025-11-28 09:00:07','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(63437,'2025-11-28 09:00:07','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(63436,'2025-11-28 09:00:07','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63565,'2025-11-30 09:01:39','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(63566,'2025-11-30 09:01:39','Automated Task: Starting Overage Billing Charges','System',0,0,0,''),
(62584,'2025-11-14 13:55:04','Automated Task: Starting Tenant Usage Metrics','System',0,0,0,''),
(63186,'2025-11-24 09:00:06','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(63379,'2025-11-27 09:00:39','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(62773,'2025-11-17 13:55:18','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62829,'2025-11-18 09:55:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63426,'2025-11-28 09:00:07','Automated Task: Starting Invoice & Overdue Reminders','System',0,0,0,''),
(63329,'2025-11-26 11:40:10','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62750,'2025-11-17 09:00:08','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(62640,'2025-11-15 09:00:50','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(63067,'2025-11-22 09:01:43','Server Usage Update Failed: Connection Error: Failed to connect to 103.215.223.77 port 2087: No route to host(7) - Server ID: 199','System',0,0,0,''),
(63323,'2025-11-26 09:01:40','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62751,'2025-11-17 09:00:08','Automated Task: Starting Fixed Term Terminations','System',0,0,0,''),
(62752,'2025-11-17 09:00:08','Automated Task: Starting Inactive Tickets','System',0,0,0,''),
(62753,'2025-11-17 09:00:09','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(62754,'2025-11-17 09:00:09','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(62755,'2025-11-17 09:00:09','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63319,'2025-11-26 09:01:40','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(62891,'2025-11-19 09:55:12','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62747,'2025-11-17 09:00:08','Cron Job: ERROR: Manual Cancellation Required - No Module -  - nice-tools.ir -   (Due Date: 2023/03/03)','System',0,0,0,''),
(62586,'2025-11-14 13:55:16','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63198,'2025-11-24 09:01:41','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(62952,'2025-11-20 09:55:10','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62951,'2025-11-20 09:01:43','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(63500,'2025-11-29 09:00:07','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(63501,'2025-11-29 09:00:07','Automated Task: Starting SSL Sync','System',0,0,0,''),
(63502,'2025-11-29 09:00:40','Automated Task: Starting Server Usage Stats','System',0,0,0,''),
(63258,'2025-11-25 09:00:38','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(63443,'2025-11-28 09:01:39','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(63556,'2025-11-30 09:00:06','Cron Job: ERROR: Manual Cancellation Required - No Module - سرور مجازی ایران پلان اول - services-gameshopcity.com -   (Due Date: 2023/02/03)','System',0,0,0,''),
(62643,'2025-11-15 09:55:11','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62765,'2025-11-17 09:00:55','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(62595,'2025-11-14 21:55:12','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62593,'2025-11-14 17:55:14','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62594,'2025-11-14 17:55:14','Domain Sync Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63499,'2025-11-29 09:00:07','Automated Task: Starting Delayed Affiliate Commissions','System',0,0,0,''),
(63314,'2025-11-26 09:00:05','Automated Task: Starting Email Marketer Rules','System',0,0,0,''),
(62580,'2025-11-14 09:55:13','Automated Task: Starting Domain Transfer Status Synchronisation','System',0,0,0,''),
(62579,'2025-11-14 09:01:45','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(62888,'2025-11-19 09:01:05','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(62884,'2025-11-19 09:01:05','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(62902,'2025-11-19 17:55:10','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(63259,'2025-11-25 09:00:38','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(63386,'2025-11-27 09:00:39','Cron Job: Completed Daily Automation Tasks','System',0,0,0,''),
(62772,'2025-11-17 13:55:18','Domain Transfer Status Cron: Disabled. Run Aborted.','System',0,0,0,''),
(62597,'2025-11-14 21:55:12','Automated Task: Starting Domain Status Synchronisation','System',0,0,0,''),
(62889,'2025-11-19 09:01:05','Cron Job: Database Backup requested but backups are not configured.','System',0,0,0,''),
(62838,'2025-11-18 17:00:06','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(63427,'2025-11-28 09:00:07','Automated Task: Starting Domain Renewal Notices','System',0,0,0,''),
(63372,'2025-11-27 09:00:05','Automated Task: Starting Overdue Terminations','System',0,0,0,''),
(63424,'2025-11-28 09:00:07','Cron Job: Late Invoice Fees added to 0 Invoices','System',0,0,0,''),
(63009,'2025-11-21 09:00:53','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(62946,'2025-11-20 09:01:43','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(63011,'2025-11-21 09:00:53','Check for Updates Failed: The temporary update path is not valid. Please specify a writable temporary update path to proceed with update.','System',0,0,0,''),
(62700,'2025-11-16 09:01:56','Automated Task: Starting WHMCS Updates','System',0,0,0,''),
(63192,'2025-11-24 09:01:40','Automated Task: Starting Client Status Update','System',0,0,0,''),
(63193,'2025-11-24 09:01:40','Automated Task: Starting Domain Expiry','System',0,0,0,''),
(63321,'2025-11-26 09:01:40','Automated Task: Starting SSL Certificate Reissues','System',0,0,0,''),
(63320,'2025-11-26 09:01:40','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(63382,'2025-11-27 09:00:39','Automated Task: Starting Data Retention Pruning','System',0,0,0,''),
(63381,'2025-11-27 09:00:39','Automated Task: Starting Domain Expiry','System',0,0,0,'');
/*!40000 ALTER TABLE `tblactivitylog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbladdonmodules`
--

DROP TABLE IF EXISTS `tbladdonmodules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbladdonmodules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `module` text NOT NULL,
  `setting` text NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1268 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbladdonmodules`
--

LOCK TABLES `tbladdonmodules` WRITE;
/*!40000 ALTER TABLE `tbladdonmodules` DISABLE KEYS */;
INSERT INTO `tbladdonmodules` (`id`, `module`, `setting`, `value`) VALUES (5,'SeoManager','delete',''),
(548,'ChangeMainDomain','Text Field Name','2'),
(12,'mellatbank_verification','version','Legacy Module'),
(16,'SeoManager','version','2.1.1'),
(17,'mspcontrol_addons','version','3.0.7'),
(263,'sms_addon','version','Legacy Module'),
(775,'CpanelWordpressInstallation','version','1.0'),
(661,'csfmanager','version','1.0'),
(585,'ChangeMainDomain','limitation','2'),
(660,'CpanelResetHost','limitation','5'),
(226,'mellatbank_transaction','version','Legacy Module'),
(244,'mellat_verify_list','version','Legacy Module'),
(817,'sabaSMS','version','1.2.0'),
(1266,'subirnic','access','1'),
(322,'SSLCENTERWHMCS','version','2.1.12'),
(535,'ChangeMainDomain','version','1.0'),
(598,'CpanelChangeMainDomain','version','1.0'),
(1264,'smsalert','access','1'),
(1263,'sms_addon','access','1,2,3'),
(612,'CpanelChangeMainDomain','limitation','5'),
(712,'PleskResetHost','limitation','5'),
(1250,'SeoManager','access',''),
(1251,'adminchangepassword','access','1'),
(645,'CpanelResetHost','version','1.0'),
(1262,'sabaSMS','access',''),
(695,'PleskResetHost','version','1.0'),
(713,'plesksync','version','2.0b'),
(731,'plesksync','accounts_per_page','100'),
(732,'plesksync','whmcs_addorder_payment','mailin'),
(733,'plesksync','whmcs_addorder_billingcycle','monthly'),
(734,'PleskChangeMainDomain','version','1.0'),
(1261,'plesksync','access','1,2,3'),
(753,'PleskChangeMainDomain','limitation','5'),
(1260,'mspcontrol_addons','access','1'),
(796,'CpanelWordpressInstallation','limitation','0'),
(838,'adminchangepassword','version','1.0'),
(879,'litespeedRenew','version','1.0'),
(1259,'mellatbank_verification','access','1,2,3'),
(947,'RSThemes','version','2.1.1'),
(1258,'mellatbank_transaction','access',''),
(1257,'mellat_verify_list','access','1'),
(1256,'litespeedRenew','access','1'),
(970,'RSThemes','dbrollback','on'),
(1047,'ConfigServer','version','1.5.0'),
(1254,'ippanel_sms','access','1'),
(1253,'csfmanager','access','1,2,3'),
(1182,'HetznerCloud','version','2020.7'),
(1073,'smsalert','version','1.1'),
(1249,'SSLCENTERWHMCS','access','1'),
(1248,'RSThemes','access','1'),
(1247,'PleskResetHost','access','1,2,3'),
(1245,'HetznerCloud','access','1,2,3'),
(1099,'ippanel_sms','version','2.5'),
(1126,'wordpress_autoinstaller','version','1.0'),
(1246,'PleskChangeMainDomain','access','1,2,3'),
(1244,'CpanelWordpressInstallation','access',''),
(1154,'subirnic','version','1.0'),
(1243,'CpanelResetHost','access','1,2,3'),
(1242,'CpanelChangeMainDomain','access','1,2,3'),
(1241,'ConfigServer','access','1'),
(1211,'HetznerCloud','whmcsmodule_key','hetzc-128aece4ed8'),
(1267,'wordpress_autoinstaller','access','1'),
(1240,'ChangeMainDomain','access','');
/*!40000 ALTER TABLE `tbladdonmodules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbladdons`
--

DROP TABLE IF EXISTS `tbladdons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbladdons` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `packages` text NOT NULL,
  `name` text NOT NULL,
  `description` text NOT NULL,
  `billingcycle` text NOT NULL,
  `allowqty` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `tax` tinyint(1) NOT NULL,
  `showorder` tinyint(1) NOT NULL,
  `hidden` tinyint(1) NOT NULL DEFAULT 0,
  `retired` tinyint(1) NOT NULL DEFAULT 0,
  `downloads` text NOT NULL,
  `autoactivate` text NOT NULL,
  `suspendproduct` tinyint(1) NOT NULL,
  `welcomeemail` int(10) NOT NULL,
  `type` varchar(16) NOT NULL DEFAULT '',
  `module` varchar(32) NOT NULL DEFAULT '',
  `server_group_id` int(10) NOT NULL DEFAULT 0,
  `prorate` tinyint(1) NOT NULL DEFAULT 0,
  `weight` int(2) NOT NULL DEFAULT 0,
  `autolinkby` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `name` (`name`(32))
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbladdons`
--

LOCK TABLES `tbladdons` WRITE;
/*!40000 ALTER TABLE `tbladdons` DISABLE KEYS */;
INSERT INTO `tbladdons` (`id`, `packages`, `name`, `description`, `billingcycle`, `allowqty`, `tax`, `showorder`, `hidden`, `retired`, `downloads`, `autoactivate`, `suspendproduct`, `welcomeemail`, `type`, `module`, `server_group_id`, `prorate`, `weight`, `autolinkby`, `created_at`, `updated_at`) VALUES (1,'39,36,40,37,41,38,35,30,12,1,14,31,18,32,33,11,27,34,2,24,23,15,25,26,13,9,10,5,6,4,7,3,8,21,20,19,28,29','پنل پیامکی','پنل ارسال و دریافت  پیامک','Annually',0,0,1,0,0,'','',0,0,'','',0,0,0,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(2,'39,36,40,37,41,38,35,30,12,1,14,31,18,32,33,11,27,34,2,24,23,15,25,26,13,9,10,5,6,4,7,3,8,21,20,19,28,29','شماره اختصاصی 14 رقمی - 5000','شماره اختصاصی 14 رقمی - 5000','Annually',0,0,1,0,0,'','',0,0,'','',0,0,0,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(8,',217,229,241,288,18,223,235,242,246,248,257,289,218,230,243,245,249,250,259,275,282,290,33,224,236,244,247,251,253,291,11,219,231,252,260,276,292,225,237,283,293,2,186,220,232,254,199,226,233,238,255,261,277,221,234,239,262,279,227,240,256,284,285,222,263,280,228,258,286,264,281,287,','DNS  اختصاصی','<br/>\r\nتنظیم نیم سرور اختصاصی برروی هاست','onetime',0,0,1,0,0,'','',0,0,'other','',0,0,0,'','2022-08-20 10:27:56','2022-08-20 10:43:57'),
(9,',217,229,241,288,18,223,235,242,246,248,257,289,218,230,243,245,249,250,259,275,282,290,33,224,236,244,247,251,253,291,11,219,231,252,260,276,292,225,237,283,293,2,186,220,232,254,199,226,233,238,255,261,277,221,234,239,262,279,227,240,256,284,285,222,263,280,228,258,286,264,281,287,','ip اضافه','به صورت پیش فرض هر سرور یک ای پی دارد.','recurring',0,0,1,0,0,'','',0,0,'other','',0,0,0,'','2022-08-20 10:31:10','2022-08-20 10:44:59'),
(10,',217,229,241,288,18,223,235,242,246,248,257,289,218,230,243,245,249,250,259,275,282,290,33,224,236,244,247,251,253,291,11,219,231,252,260,276,292,225,237,283,293,2,186,220,232,254,199,226,233,238,255,261,277,221,234,239,262,279,227,240,256,284,285,222,263,280,228,258,286,264,281,287,','گواهینامه امنیتی SSL - ویژه دامین های IR و بین المللی','افزایش رتبه و رنکیگ سئو\r\nبا خرید و راه اندازی گواهینامه SSL علاوه بر تامین امنیت کاربران خود از این پس میتوانید رنک و رتبه گوگل خود را نیز ارتقاء دهید. اخیرا گوگل به این نکته مهم در وبلاگ خود اشاره کرده و شما میتوانید با خرید و نصب گواهینامه امنیتی SSL  به سادگی رتبه و رنک خود را افزایش دهید . همچنین با نصب گواهینامه های امنیتی میتوانید گواهینامه نماد اعتماد 2 ستاره نیز دریافت نمایید.\r\nمدت اعتبار گواهینامه های صادر شده یک سال بوده است.','Annually',0,0,1,0,0,'','',0,0,'other','',0,0,0,'','2022-08-20 10:32:42','2022-08-20 10:45:22');
/*!40000 ALTER TABLE `tbladdons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbladminlog`
--

DROP TABLE IF EXISTS `tbladminlog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbladminlog` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `adminusername` text NOT NULL,
  `logintime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `logouttime` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `ipaddress` text NOT NULL,
  `sessionid` text NOT NULL,
  `lastvisit` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `logouttime` (`logouttime`)
) ENGINE=MyISAM AUTO_INCREMENT=5274 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbladminlog`
--

LOCK TABLES `tbladminlog` WRITE;
/*!40000 ALTER TABLE `tbladminlog` DISABLE KEYS */;
INSERT INTO `tbladminlog` (`id`, `adminusername`, `logintime`, `logouttime`, `ipaddress`, `sessionid`, `lastvisit`) VALUES (5270,'admin','2023-02-23 23:19:14','2023-02-24 00:10:49','103.215.223.64','3704238deca5f2ab2c9771c03c10a03f','2023-02-24 00:10:49'),
(5271,'admin','2023-03-10 13:08:37','2023-03-10 13:34:48','2.190.226.124','ac395cf43be684a47dfd3690a1f04c50','2023-03-10 13:34:48'),
(5272,'admin','2023-03-21 16:17:55','2023-03-21 16:18:52','84.241.25.102','7d2cc2594764cc16d1af97b6ef3b0557','2023-03-21 16:18:52'),
(5273,'admin','2023-03-21 16:35:32','0000-00-00 00:00:00','84.241.25.102','7d2cc2594764cc16d1af97b6ef3b0557','2023-03-21 16:44:42');
/*!40000 ALTER TABLE `tbladminlog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbladminperms`
--

DROP TABLE IF EXISTS `tbladminperms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbladminperms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `roleid` int(1) NOT NULL,
  `permid` int(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `roleid_permid` (`roleid`,`permid`)
) ENGINE=MyISAM AUTO_INCREMENT=242 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbladminperms`
--

LOCK TABLES `tbladminperms` WRITE;
/*!40000 ALTER TABLE `tbladminperms` DISABLE KEYS */;
INSERT INTO `tbladminperms` (`id`, `roleid`, `permid`) VALUES (1,1,1),
(2,1,2),
(3,1,3),
(4,1,4),
(5,1,5),
(6,1,6),
(7,1,7),
(8,1,8),
(9,1,9),
(10,1,10),
(11,1,11),
(12,1,12),
(13,1,13),
(14,1,14),
(15,1,15),
(16,1,16),
(17,1,17),
(18,1,18),
(19,1,19),
(20,1,20),
(21,1,21),
(22,1,22),
(23,1,23),
(24,1,24),
(25,1,25),
(26,1,26),
(27,1,27),
(28,1,28),
(29,1,29),
(30,1,30),
(31,1,31),
(32,1,32),
(33,1,33),
(34,1,34),
(35,1,35),
(36,1,36),
(37,1,37),
(38,1,38),
(39,1,39),
(40,1,40),
(41,1,41),
(42,1,42),
(43,1,43),
(44,1,44),
(45,1,45),
(46,1,46),
(47,1,47),
(48,1,49),
(49,1,50),
(50,1,51),
(51,1,52),
(52,1,53),
(53,1,54),
(54,1,55),
(55,1,56),
(56,1,57),
(57,1,58),
(58,1,59),
(59,1,60),
(60,1,61),
(61,1,62),
(62,1,63),
(63,1,64),
(64,1,65),
(65,1,66),
(66,1,67),
(67,1,68),
(68,1,69),
(69,1,70),
(70,1,71),
(71,1,72),
(72,1,73),
(73,1,74),
(74,1,75),
(75,1,76),
(76,1,77),
(77,1,78),
(78,1,79),
(79,1,80),
(80,1,81),
(81,1,82),
(82,1,83),
(83,1,84),
(84,1,85),
(85,1,86),
(86,1,87),
(87,1,88),
(88,1,89),
(89,1,90),
(90,1,91),
(91,1,92),
(92,1,93),
(93,1,94),
(94,1,95),
(95,1,96),
(96,1,97),
(97,1,98),
(98,1,99),
(99,1,100),
(100,1,101),
(101,1,102),
(102,1,103),
(103,1,104),
(104,1,105),
(105,1,106),
(106,1,107),
(107,1,108),
(108,1,109),
(109,1,110),
(110,1,111),
(111,1,112),
(112,1,113),
(113,1,114),
(114,1,115),
(115,1,116),
(116,1,117),
(117,1,118),
(118,1,119),
(119,1,120),
(120,1,121),
(121,1,122),
(122,1,123),
(123,1,124),
(124,1,125),
(125,1,126),
(126,1,127),
(127,1,128),
(128,1,129),
(129,1,130),
(130,1,131),
(131,1,132),
(132,1,133),
(133,1,134),
(134,1,135),
(135,1,136),
(136,1,137),
(137,1,138),
(138,1,139),
(139,1,139),
(140,1,140),
(141,1,141),
(142,1,142),
(143,1,143),
(144,1,144),
(145,1,145),
(146,2,1),
(147,2,2),
(148,2,3),
(149,2,4),
(150,2,5),
(151,2,6),
(152,2,7),
(153,2,8),
(154,2,9),
(155,2,10),
(156,2,11),
(157,2,12),
(158,2,13),
(159,2,14),
(160,2,15),
(161,2,16),
(162,2,17),
(163,2,18),
(164,2,19),
(165,2,20),
(166,2,21),
(167,2,22),
(168,2,23),
(169,2,24),
(170,2,25),
(171,2,26),
(172,2,27),
(173,2,28),
(174,2,29),
(175,2,30),
(176,2,31),
(177,2,32),
(178,2,33),
(179,2,34),
(180,2,35),
(181,2,36),
(182,2,37),
(183,2,38),
(184,2,39),
(185,2,40),
(186,2,41),
(187,2,42),
(188,2,43),
(189,2,44),
(190,2,45),
(191,2,46),
(192,2,47),
(193,2,49),
(194,2,50),
(195,2,51),
(196,2,52),
(197,2,71),
(198,2,73),
(199,2,85),
(200,2,98),
(201,2,99),
(202,2,101),
(203,2,104),
(204,2,105),
(205,2,110),
(206,2,120),
(207,2,123),
(208,2,124),
(209,2,125),
(210,2,125),
(211,2,126),
(212,2,126),
(213,2,128),
(214,2,129),
(215,2,145),
(216,3,38),
(217,3,39),
(218,3,40),
(219,3,41),
(220,3,42),
(221,3,43),
(222,3,44),
(223,3,50),
(224,3,105),
(225,3,125),
(226,3,125),
(227,3,126),
(228,3,128),
(229,1,146),
(230,1,148),
(231,1,147),
(232,1,150),
(233,1,151),
(234,1,149),
(235,2,149),
(236,1,152),
(237,1,153),
(238,1,154),
(239,1,155),
(240,1,156),
(241,1,157);
/*!40000 ALTER TABLE `tbladminperms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbladminroles`
--

DROP TABLE IF EXISTS `tbladminroles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbladminroles` (
  `id` int(1) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `widgets` text NOT NULL,
  `reports` text NOT NULL,
  `systememails` int(1) NOT NULL,
  `accountemails` int(1) NOT NULL,
  `supportemails` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbladminroles`
--

LOCK TABLES `tbladminroles` WRITE;
/*!40000 ALTER TABLE `tbladminroles` DISABLE KEYS */;
INSERT INTO `tbladminroles` (`id`, `name`, `widgets`, `reports`, `systememails`, `accountemails`, `supportemails`) VALUES (1,'Full Administrator','staffboard_overview','',1,1,1),
(2,'Sales Operator','activity_log,getting_started,income_forecast,income_overview,my_notes,network_status,open_invoices,orders_overview,paypal_addon,client_activity,todo_list,whmcs_news,supporttickets_overview,calendar','',0,1,1),
(3,'Support Operator','activity_log,getting_started,my_notes,todo_list,whmcs_news,supporttickets_overview,calendar','',0,0,1);
/*!40000 ALTER TABLE `tbladminroles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbladmins`
--

DROP TABLE IF EXISTS `tbladmins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbladmins` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL DEFAULT '',
  `roleid` int(1) NOT NULL,
  `username` text NOT NULL,
  `password` varchar(255) NOT NULL DEFAULT '',
  `passwordhash` varchar(255) NOT NULL DEFAULT '',
  `authmodule` text NOT NULL,
  `authdata` text NOT NULL,
  `firstname` text NOT NULL,
  `lastname` text NOT NULL,
  `email` text NOT NULL,
  `signature` text NOT NULL,
  `notes` text NOT NULL,
  `template` text NOT NULL,
  `language` text NOT NULL,
  `disabled` int(1) NOT NULL,
  `loginattempts` int(1) NOT NULL,
  `supportdepts` text NOT NULL,
  `ticketnotifications` text NOT NULL,
  `homewidgets` text NOT NULL,
  `password_reset_key` varchar(255) NOT NULL DEFAULT '',
  `password_reset_data` text NOT NULL,
  `password_reset_expiry` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `hidden_widgets` text NOT NULL,
  `widget_order` text NOT NULL,
  `user_preferences` mediumtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `username` (`username`(32))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbladmins`
--

LOCK TABLES `tbladmins` WRITE;
/*!40000 ALTER TABLE `tbladmins` DISABLE KEYS */;
INSERT INTO `tbladmins` (`id`, `uuid`, `roleid`, `username`, `password`, `passwordhash`, `authmodule`, `authdata`, `firstname`, `lastname`, `email`, `signature`, `notes`, `template`, `language`, `disabled`, `loginattempts`, `supportdepts`, `ticketnotifications`, `homewidgets`, `password_reset_key`, `password_reset_data`, `password_reset_expiry`, `hidden_widgets`, `widget_order`, `user_preferences`, `created_at`, `updated_at`) VALUES (1,'ee66e9b5-21bd-4a4d-9f36-cf3de4cecaa9',1,'admin','$2y$10$N5kMgd.kiZeq3nSPQvX5J.Sdxa01s.pZxFRvJUZmuFlOcQVvwQhZ6','$2y$10$K06zmkjqgnnS1CXDTid9Lu8cnDqexSRHET9/0YrX5IteNji5BMIXa','','','پشتیبانی',' - کلون کلود','hammedsadeghie@gmail.com','با سلام و وقت بخیر\r\nکاربر گرامی\r\n\r\nموفق و پیروز باشید\r\n\r\n---------------------------------------------\r\nکلون کلود \r\nارائه سرور اختصاصی و مجازی در ایران با هارد SSD و ترافیک نامحدود \r\nhttps://www.keloncloud.com/vps','','blend','english',0,0,'2,3,1,4',',2,3,1,4,','sysinfo:true,admin_activity:false,calendar:false,getting_started:false,orders_overview:false,supporttickets_overview:false,my_notes:false,client_activity:false,open_invoices:false,activity_log:false|income_overview:false,system_overview:false,whmcs_news:false,todo_list:false,network_status:false,income_forecast:false|','','','0000-00-00 00:00:00','',',Overview,Automation,staffnoticeboard,Activity,Billing,MarketConnect,Staff,ToDo,ClientActivity,NetworkStatus,Health,Support,','{\"tableLengths\":{\"default\":10,\"summaryServices\":\"1000\"}}','0000-00-00 00:00:00','2022-10-27 08:37:10'),
(4,'7a26e323-d7c5-437e-b6a6-59d637c732b5',1,'sajedi','$2y$10$r8.9sBbpFlHEzTPZZh442eJ.tpJ6aN3ZuZcg8hJvCdCJ36WJjita6','$2y$10$o5vJCpfv2t7njdy9ZERlR.8CsfiNDggoezvKyU2s.II.wLh4LPidm','','','کارشناس فنی','ساجدی','mohamadsajedi75@gmail.com','با سلام و وقت بخیر\r\nکاربر گرامی\r\n\r\n\r\nموفق و پیروز باشید\r\n===================================\r\nکلون کلود میزبانی ایرانی با کیفیت \r\nhttps://www.keloncloud.com/host/\r\nشماره تماس : 021-77979369','','blend','english',0,0,'2,3,1,4','2,3,1,4','','','','0000-00-00 00:00:00','','',NULL,'2022-08-25 08:09:03','2022-08-29 07:30:58');
/*!40000 ALTER TABLE `tbladmins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbladminsecurityquestions`
--

DROP TABLE IF EXISTS `tbladminsecurityquestions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbladminsecurityquestions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `question` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbladminsecurityquestions`
--

LOCK TABLES `tbladminsecurityquestions` WRITE;
/*!40000 ALTER TABLE `tbladminsecurityquestions` DISABLE KEYS */;
INSERT INTO `tbladminsecurityquestions` (`id`, `question`, `created_at`, `updated_at`) VALUES (1,'XlxiikZtXrHVs5ExNJvSLjUe4HV1zNJxWC6yN3dlY6BB0AyYYoR9BXonboOzSnFMdy9ANcnnE7EMRqrAvk/sQ8YG','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(2,'M2CSgx5F+S9L+o0S9li0EyFtbmMY8CJ4AAYVqeMue4OPEEGldvfzE3RDiYY9UCeCPcs1ufCsWa2fhlaBcAIvnqYiVXGQgCrEody9','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(3,'RZFRawn/UeIs3WJ5gTfqSlYAVHFuAeGQF7y9ZIcLkOnXfj78AWK/XQQ4s63fWeqfTFf9IAzM+sDdrfL5ltmICePr0o7WKDTWVQUzbanBcQ==','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(4,'adAR/X4e5KF/p+3MJxvqyaO/5RJCTqEQYWrwS1pxEl1eUwl+3SV5Xn0DvnuYqDdeydyrY10ODJcR6g/hPfKlSEZb','0000-00-00 00:00:00','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `tbladminsecurityquestions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblaffiliates`
--

DROP TABLE IF EXISTS `tblaffiliates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblaffiliates` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` date DEFAULT NULL,
  `clientid` int(10) NOT NULL,
  `visitors` int(1) NOT NULL,
  `paytype` text NOT NULL,
  `payamount` decimal(16,2) NOT NULL,
  `onetime` int(1) NOT NULL,
  `balance` decimal(16,2) NOT NULL DEFAULT 0.00,
  `withdrawn` decimal(16,2) NOT NULL DEFAULT 0.00,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `clientid` (`clientid`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblaffiliates`
--

LOCK TABLES `tblaffiliates` WRITE;
/*!40000 ALTER TABLE `tblaffiliates` DISABLE KEYS */;
INSERT INTO `tblaffiliates` (`id`, `date`, `clientid`, `visitors`, `paytype`, `payamount`, `onetime`, `balance`, `withdrawn`, `created_at`, `updated_at`) VALUES (1,'2020-03-01',25,0,'',0.00,0,0.00,0.00,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(2,'2020-08-15',29,4,'',0.00,0,0.00,0.00,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(3,'2022-11-09',76,0,'',0.00,0,0.00,0.00,'0000-00-00 00:00:00','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `tblaffiliates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblaffiliates_hits`
--

DROP TABLE IF EXISTS `tblaffiliates_hits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblaffiliates_hits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(10) unsigned NOT NULL DEFAULT 0,
  `referrer_id` int(10) unsigned NOT NULL DEFAULT 0,
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`,`referrer_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblaffiliates_hits`
--

LOCK TABLES `tblaffiliates_hits` WRITE;
/*!40000 ALTER TABLE `tblaffiliates_hits` DISABLE KEYS */;
INSERT INTO `tblaffiliates_hits` (`id`, `affiliate_id`, `referrer_id`, `created_at`) VALUES (1,2,1,'2020-08-15 14:33:03'),
(2,2,1,'2020-10-06 08:31:31'),
(3,2,1,'2020-10-06 08:32:09'),
(4,2,1,'2020-10-06 08:33:09');
/*!40000 ALTER TABLE `tblaffiliates_hits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblaffiliates_referrers`
--

DROP TABLE IF EXISTS `tblaffiliates_referrers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblaffiliates_referrers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `affiliate_id` int(10) unsigned NOT NULL DEFAULT 0,
  `referrer` varchar(500) NOT NULL DEFAULT '',
  `created_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `affiliate_id` (`affiliate_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblaffiliates_referrers`
--

LOCK TABLES `tblaffiliates_referrers` WRITE;
/*!40000 ALTER TABLE `tblaffiliates_referrers` DISABLE KEYS */;
INSERT INTO `tblaffiliates_referrers` (`id`, `affiliate_id`, `referrer`, `created_at`, `updated_at`) VALUES (1,2,'','2020-08-15 14:33:03','2020-08-15 14:33:03');
/*!40000 ALTER TABLE `tblaffiliates_referrers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblaffiliatesaccounts`
--

DROP TABLE IF EXISTS `tblaffiliatesaccounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblaffiliatesaccounts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `affiliateid` int(10) NOT NULL,
  `relid` int(10) NOT NULL,
  `lastpaid` date NOT NULL DEFAULT '0000-00-00',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `affiliateid` (`affiliateid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblaffiliatesaccounts`
--

LOCK TABLES `tblaffiliatesaccounts` WRITE;
/*!40000 ALTER TABLE `tblaffiliatesaccounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblaffiliatesaccounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblaffiliateshistory`
--

DROP TABLE IF EXISTS `tblaffiliateshistory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblaffiliateshistory` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `affiliateid` int(10) NOT NULL,
  `date` date NOT NULL,
  `affaccid` int(10) NOT NULL,
  `invoice_id` int(10) unsigned NOT NULL DEFAULT 0,
  `description` text NOT NULL,
  `amount` decimal(16,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `affiliateid` (`affiliateid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblaffiliateshistory`
--

LOCK TABLES `tblaffiliateshistory` WRITE;
/*!40000 ALTER TABLE `tblaffiliateshistory` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblaffiliateshistory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblaffiliatespending`
--

DROP TABLE IF EXISTS `tblaffiliatespending`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblaffiliatespending` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `affaccid` int(10) NOT NULL DEFAULT 0,
  `invoice_id` int(10) unsigned NOT NULL DEFAULT 0,
  `amount` decimal(16,2) NOT NULL,
  `clearingdate` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `clearingdate` (`clearingdate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblaffiliatespending`
--

LOCK TABLES `tblaffiliatespending` WRITE;
/*!40000 ALTER TABLE `tblaffiliatespending` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblaffiliatespending` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblaffiliateswithdrawals`
--

DROP TABLE IF EXISTS `tblaffiliateswithdrawals`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblaffiliateswithdrawals` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `affiliateid` int(10) NOT NULL,
  `date` date NOT NULL,
  `amount` decimal(16,2) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `affiliateid` (`affiliateid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblaffiliateswithdrawals`
--

LOCK TABLES `tblaffiliateswithdrawals` WRITE;
/*!40000 ALTER TABLE `tblaffiliateswithdrawals` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblaffiliateswithdrawals` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblannouncements`
--

DROP TABLE IF EXISTS `tblannouncements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblannouncements` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` datetime DEFAULT NULL,
  `title` text NOT NULL,
  `announcement` text NOT NULL,
  `published` tinyint(1) NOT NULL,
  `parentid` int(10) NOT NULL,
  `language` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `date` (`date`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblannouncements`
--

LOCK TABLES `tblannouncements` WRITE;
/*!40000 ALTER TABLE `tblannouncements` DISABLE KEYS */;
INSERT INTO `tblannouncements` (`id`, `date`, `title`, `announcement`, `published`, `parentid`, `language`, `created_at`, `updated_at`) VALUES (2,'2016-09-28 13:11:00','','',0,0,'','0000-00-00 00:00:00','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `tblannouncements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblapi_roles`
--

DROP TABLE IF EXISTS `tblapi_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblapi_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  `permissions` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblapi_roles`
--

LOCK TABLES `tblapi_roles` WRITE;
/*!40000 ALTER TABLE `tblapi_roles` DISABLE KEYS */;
INSERT INTO `tblapi_roles` (`id`, `role`, `description`, `permissions`, `created_at`, `updated_at`) VALUES (1,'admin','','{\"acceptorder\":1,\"acceptquote\":1,\"activatemodule\":1,\"addannouncement\":1,\"addbannedip\":1,\"addbillableitem\":1,\"addcancelrequest\":1,\"addclient\":1,\"addclientnote\":1,\"addcontact\":1,\"addcredit\":1,\"addinvoicepayment\":1,\"addorder\":1,\"addproduct\":1,\"addprojectmessage\":1,\"addprojecttask\":1,\"addticketnote\":1,\"addticketreply\":1,\"addtransaction\":1,\"affiliateactivate\":1,\"applycredit\":1,\"cancelorder\":1,\"capturepayment\":1,\"closeclient\":1,\"createinvoice\":1,\"createoauthcredential\":1,\"createorupdatetld\":1,\"createproject\":1,\"createquote\":1,\"deactivatemodule\":1,\"decryptpassword\":1,\"deleteannouncement\":1,\"deleteclient\":1,\"deletecontact\":1,\"deleteoauthcredential\":1,\"deleteorder\":1,\"deleteprojecttask\":1,\"deletequote\":1,\"deleteticket\":1,\"deleteticketnote\":1,\"domaingetlockingstatus\":1,\"domaingetnameservers\":1,\"domaingetwhoisinfo\":1,\"domainregister\":1,\"domainrelease\":1,\"domainrenew\":1,\"domainrequestepp\":1,\"domaintoggleidprotect\":1,\"domaintransfer\":1,\"domainupdatelockingstatus\":1,\"domainupdatenameservers\":1,\"domainupdatewhoisinfo\":1,\"domainwhois\":1,\"encryptpassword\":1,\"endtasktimer\":1,\"fraudorder\":1,\"geninvoices\":1,\"getactivitylog\":1,\"getadmindetails\":1,\"getaffiliates\":1,\"getannouncements\":1,\"getautomationlog\":1,\"getcancelledpackages\":1,\"getclientgroups\":1,\"getclientpassword\":1,\"getclients\":1,\"getclientsaddons\":1,\"getclientsdetails\":1,\"getclientsdomains\":1,\"getclientsproducts\":1,\"getconfigurationvalue\":1,\"getcontacts\":1,\"getcredits\":1,\"getcurrencies\":1,\"getemails\":1,\"getemailtemplates\":1,\"gethealthstatus\":1,\"getinvoice\":1,\"getinvoices\":1,\"getmoduleconfigurationparameters\":1,\"getmodulequeue\":1,\"getorders\":1,\"getorderstatuses\":1,\"getpaymentmethods\":1,\"getproducts\":1,\"getproject\":1,\"getprojects\":1,\"getpromotions\":1,\"getquotes\":1,\"getservers\":1,\"getstaffonline\":1,\"getstats\":1,\"getsupportdepartments\":1,\"getsupportstatuses\":1,\"getticket\":1,\"getticketcounts\":1,\"getticketnotes\":1,\"getticketpredefinedcats\":1,\"getticketpredefinedreplies\":1,\"gettickets\":1,\"gettldpricing\":1,\"gettodoitems\":1,\"gettodoitemstatuses\":1,\"gettransactions\":1,\"listoauthcredentials\":1,\"logactivity\":1,\"modulechangepackage\":1,\"modulechangepw\":1,\"modulecreate\":1,\"modulecustom\":1,\"modulesuspend\":1,\"moduleterminate\":1,\"moduleunsuspend\":1,\"openticket\":1,\"orderfraudcheck\":1,\"pendingorder\":1,\"sendadminemail\":1,\"sendemail\":1,\"sendquote\":1,\"starttasktimer\":1,\"triggernotificationevent\":1,\"updateadminnotes\":1,\"updateannouncement\":1,\"updateclient\":1,\"updateclientaddon\":1,\"updateclientdomain\":1,\"updateclientproduct\":1,\"updatecontact\":1,\"updateinvoice\":1,\"updatemoduleconfiguration\":1,\"updateoauthcredential\":1,\"updateproject\":1,\"updateprojecttask\":1,\"updatequote\":1,\"updateticket\":1,\"updatetodoitem\":1,\"updatetransaction\":1,\"upgradeproduct\":1,\"validatelogin\":1}','2018-07-24 17:30:38','2020-07-14 09:37:47');
/*!40000 ALTER TABLE `tblapi_roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblapilog`
--

DROP TABLE IF EXISTS `tblapilog`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblapilog` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL DEFAULT '',
  `endpoint` varchar(255) DEFAULT NULL,
  `method` enum('GET','POST','PUT','PATCH','DELETE') DEFAULT NULL,
  `request` text NOT NULL,
  `request_headers` text DEFAULT NULL,
  `response` text NOT NULL,
  `response_status` int(11) NOT NULL DEFAULT 0,
  `response_headers` text NOT NULL,
  `level` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblapilog`
--

LOCK TABLES `tblapilog` WRITE;
/*!40000 ALTER TABLE `tblapilog` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblapilog` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblapplinks`
--

DROP TABLE IF EXISTS `tblapplinks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblapplinks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `module_type` varchar(20) NOT NULL DEFAULT '',
  `module_name` varchar(50) NOT NULL DEFAULT '',
  `is_enabled` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblapplinks`
--

LOCK TABLES `tblapplinks` WRITE;
/*!40000 ALTER TABLE `tblapplinks` DISABLE KEYS */;
INSERT INTO `tblapplinks` (`id`, `module_type`, `module_name`, `is_enabled`, `created_at`, `updated_at`) VALUES (1,'servers','cpanel',1,'2016-09-21 18:25:39','2022-08-12 09:46:50');
/*!40000 ALTER TABLE `tblapplinks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblapplinks_links`
--

DROP TABLE IF EXISTS `tblapplinks_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblapplinks_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `applink_id` int(10) unsigned NOT NULL DEFAULT 0,
  `scope` varchar(80) NOT NULL DEFAULT '',
  `display_label` varchar(256) NOT NULL DEFAULT '',
  `is_enabled` tinyint(4) NOT NULL DEFAULT 0,
  `order` tinyint(4) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblapplinks_links`
--

LOCK TABLES `tblapplinks_links` WRITE;
/*!40000 ALTER TABLE `tblapplinks_links` DISABLE KEYS */;
INSERT INTO `tblapplinks_links` (`id`, `applink_id`, `scope`, `display_label`, `is_enabled`, `order`, `created_at`, `updated_at`) VALUES (1,1,'clientarea:profile','Manage Profile',1,1,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(2,1,'clientarea:billing_info','Manage Billing Information',1,2,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(3,1,'clientarea:emails','View Email History',1,3,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(4,1,'clientarea:announcements','News &amp; Announcements',1,4,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(5,1,'clientarea:downloads','Download Resources',1,5,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(6,1,'clientarea:knowledgebase','Search our Knowledgebase',1,6,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(7,1,'clientarea:network_status','Check Network Status',1,7,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(8,1,'clientarea:product_details','View Billing Information',1,8,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(9,1,'clientarea:invoices','View Invoice History',1,9,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(10,1,'clientarea:tickets','View Support Tickets',1,10,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(11,1,'clientarea:submit_ticket','Open Ticket',1,11,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(12,1,'clientarea:shopping_cart_addons','View/Order Addons',1,12,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(13,1,'clientarea:shopping_cart_domain_register','Register New Domain',1,13,'2016-09-21 18:25:39','2016-09-24 21:25:16'),
(14,1,'clientarea:shopping_cart_domain_transfer','Transfer a Domain',1,14,'2016-09-21 18:25:39','2016-09-24 21:25:16');
/*!40000 ALTER TABLE `tblapplinks_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblapplinks_log`
--

DROP TABLE IF EXISTS `tblapplinks_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblapplinks_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `applink_id` int(10) unsigned NOT NULL DEFAULT 0,
  `message` varchar(2000) NOT NULL DEFAULT '',
  `level` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblapplinks_log`
--

LOCK TABLES `tblapplinks_log` WRITE;
/*!40000 ALTER TABLE `tblapplinks_log` DISABLE KEYS */;
INSERT INTO `tblapplinks_log` (`id`, `applink_id`, `message`, `level`, `created_at`, `updated_at`) VALUES (7,1,'Attempting to Disable Application Links for cpanel',100,'2019-05-17 18:53:43','2019-05-17 18:53:43'),
(8,1,'API failure:   You do not have a user named “roselabi”. XIDs: zpejww, ferjms, pfauwr, yfddut, t5zcmb and 10 more.',300,'2019-05-17 18:53:46','2019-05-17 18:53:46'),
(9,1,'API failure:   You do not have a user named “ibtilorg”. XIDs: xb324s, xesj9j, vqaysn, z4mft6, jsrxmq and 10 more.',300,'2019-05-17 18:53:46','2019-05-17 18:53:46'),
(10,1,'API failure:   You do not have a user named “azarsatr”. XIDs: ntvjks, w9h28j, rz3m5z, 5gb3u8, qv2g4h and 10 more.',300,'2019-05-17 18:53:46','2019-05-17 18:53:46'),
(11,1,'API failure:   You do not have a user named “irdnn”. XIDs: gqad32, v353td, j4uwtw, 76pk3q, 4nzw4j and 10 more.',300,'2019-05-17 18:53:46','2019-05-17 18:53:46'),
(12,1,'Process Completed Successfully!',100,'2019-05-17 18:53:46','2019-05-17 18:53:46');
/*!40000 ALTER TABLE `tblapplinks_log` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblauthn_account_links`
--

DROP TABLE IF EXISTS `tblauthn_account_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblauthn_account_links` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `provider` char(32) NOT NULL,
  `remote_user_id` char(255) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `contact_id` int(11) DEFAULT NULL,
  `metadata` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tblauthn_account_links_provider_remote_user_id_unique` (`provider`,`remote_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblauthn_account_links`
--

LOCK TABLES `tblauthn_account_links` WRITE;
/*!40000 ALTER TABLE `tblauthn_account_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblauthn_account_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblauthn_config`
--

DROP TABLE IF EXISTS `tblauthn_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblauthn_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `provider` char(64) NOT NULL,
  `setting` char(128) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tblauthn_config_provider_setting_unique` (`provider`,`setting`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblauthn_config`
--

LOCK TABLES `tblauthn_config` WRITE;
/*!40000 ALTER TABLE `tblauthn_config` DISABLE KEYS */;
INSERT INTO `tblauthn_config` (`id`, `provider`, `setting`, `value`, `created_at`, `updated_at`) VALUES (8,'google_signin','ClientSecret','TzkB5_kFMLKPUVsR2xZdQnaM','2022-08-20 04:08:25','2022-08-20 04:08:25'),
(7,'google_signin','ClientId','349033642823-5jemks7nu5p6tq946pbimvsam77pml8g.apps.googleusercontent.com','2022-08-20 04:08:25','2022-08-20 04:08:25'),
(9,'google_signin','Enabled','0','2022-08-20 04:08:25','2022-08-20 04:08:25');
/*!40000 ALTER TABLE `tblauthn_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblbankaccts`
--

DROP TABLE IF EXISTS `tblbankaccts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblbankaccts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pay_method_id` int(11) NOT NULL DEFAULT 0,
  `bank_name` varchar(255) NOT NULL DEFAULT '',
  `acct_type` varchar(255) NOT NULL DEFAULT '',
  `bank_data` blob NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tblbankaccts_pay_method_id` (`pay_method_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblbankaccts`
--

LOCK TABLES `tblbankaccts` WRITE;
/*!40000 ALTER TABLE `tblbankaccts` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblbankaccts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblbannedemails`
--

DROP TABLE IF EXISTS `tblbannedemails`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblbannedemails` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `domain` text NOT NULL,
  `count` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `domain` (`domain`(64))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblbannedemails`
--

LOCK TABLES `tblbannedemails` WRITE;
/*!40000 ALTER TABLE `tblbannedemails` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblbannedemails` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblbannedips`
--

DROP TABLE IF EXISTS `tblbannedips`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblbannedips` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `ip` text NOT NULL,
  `reason` text NOT NULL,
  `expires` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`(32))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblbannedips`
--

LOCK TABLES `tblbannedips` WRITE;
/*!40000 ALTER TABLE `tblbannedips` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblbannedips` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblbillableitems`
--

DROP TABLE IF EXISTS `tblbillableitems`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblbillableitems` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `description` text NOT NULL,
  `hours` decimal(5,1) NOT NULL,
  `amount` decimal(16,2) NOT NULL,
  `recur` int(5) NOT NULL DEFAULT 0,
  `recurcycle` text NOT NULL,
  `recurfor` int(5) NOT NULL DEFAULT 0,
  `invoiceaction` int(1) NOT NULL,
  `unit` tinyint(1) NOT NULL DEFAULT 0,
  `duedate` date NOT NULL,
  `invoicecount` int(5) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblbillableitems`
--

LOCK TABLES `tblbillableitems` WRITE;
/*!40000 ALTER TABLE `tblbillableitems` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblbillableitems` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblbundles`
--

DROP TABLE IF EXISTS `tblbundles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblbundles` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `validfrom` date NOT NULL,
  `validuntil` date NOT NULL,
  `uses` int(4) NOT NULL,
  `maxuses` int(4) NOT NULL,
  `itemdata` text NOT NULL,
  `allowpromo` int(1) NOT NULL,
  `showgroup` int(1) NOT NULL,
  `gid` int(10) NOT NULL,
  `description` text NOT NULL,
  `displayprice` decimal(16,2) NOT NULL,
  `sortorder` int(3) NOT NULL,
  `is_featured` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblbundles`
--

LOCK TABLES `tblbundles` WRITE;
/*!40000 ALTER TABLE `tblbundles` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblbundles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcalendar`
--

DROP TABLE IF EXISTS `tblcalendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcalendar` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `title` text NOT NULL,
  `desc` text NOT NULL,
  `start` int(10) NOT NULL,
  `end` int(10) NOT NULL,
  `allday` int(1) NOT NULL,
  `adminid` int(10) NOT NULL,
  `recurid` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcalendar`
--

LOCK TABLES `tblcalendar` WRITE;
/*!40000 ALTER TABLE `tblcalendar` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblcalendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcampaigns`
--

DROP TABLE IF EXISTS `tblcampaigns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcampaigns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(10) unsigned NOT NULL DEFAULT 0,
  `name` varchar(250) NOT NULL DEFAULT '',
  `configuration` text DEFAULT NULL,
  `message_data` mediumtext DEFAULT NULL,
  `sending_start_at` datetime DEFAULT NULL,
  `draft` tinyint(1) NOT NULL DEFAULT 0,
  `started` tinyint(1) NOT NULL DEFAULT 0,
  `paused` tinyint(1) NOT NULL DEFAULT 0,
  `position` int(10) unsigned NOT NULL DEFAULT 0,
  `completed` tinyint(1) NOT NULL DEFAULT 0,
  `completed_at` timestamp NULL DEFAULT NULL,
  `queue_completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tblcampaigns_started_index` (`started`),
  KEY `tblcampaigns_paused_index` (`paused`),
  KEY `tblcampaigns_completed_index` (`completed`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcampaigns`
--

LOCK TABLES `tblcampaigns` WRITE;
/*!40000 ALTER TABLE `tblcampaigns` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblcampaigns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcancelrequests`
--

DROP TABLE IF EXISTS `tblcancelrequests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcancelrequests` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `relid` int(10) NOT NULL,
  `reason` text NOT NULL,
  `type` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `serviceid` (`relid`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcancelrequests`
--

LOCK TABLES `tblcancelrequests` WRITE;
/*!40000 ALTER TABLE `tblcancelrequests` DISABLE KEYS */;
INSERT INTO `tblcancelrequests` (`id`, `date`, `relid`, `reason`, `type`, `created_at`, `updated_at`) VALUES (1,'2021-08-06 13:21:23',119,'نیروی جدید ، شرکت جدید ، پلتفرم جدید','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(2,'2022-11-30 16:33:45',230,'تمام شدن مدت سرویس','End of Billing Period','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(3,'2022-11-30 16:35:24',236,'اتمام دوره ','End of Billing Period','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(4,'2022-12-03 09:52:08',246,'سلام اتمام دوره','End of Billing Period','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(5,'2022-12-12 23:11:54',377,'سرعت بسیار پایین','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(6,'2022-12-13 16:38:34',364,'جهت اطمینان','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(7,'2022-12-14 13:58:24',384,'سرعت کم ','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(8,'2022-12-15 19:00:50',351,'عدم نیاز','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(9,'2022-12-21 17:07:32',416,'Ip  سرور رو تو سایت چک میکنم بدون فیلتر نیست و ظاهرا فیلتر هست نیاز دارم که ای پی بدون فیلتر باشه و برام تو سایت پینگ نشون بده ','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(10,'2022-12-26 15:18:47',438,'با سرور خارج من همخوانی نداشت ','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(11,'2022-12-30 12:23:15',455,'با اینترنت ما وصل نمیشه','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(12,'2023-01-02 17:49:56',404,'عدم نیاز','End of Billing Period','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(13,'2023-01-03 22:24:18',410,'عدم نیاز به سرویس','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(14,'2023-01-04 09:09:58',370,'عدم نیاز','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(15,'2023-01-06 16:57:41',350,'.','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(16,'2023-01-08 12:36:17',354,'.','End of Billing Period','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(17,'2023-01-08 12:37:38',383,'.','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(18,'2023-01-11 11:36:05',203,'با سلام این سرور بجهت عدم نیاز پرداخت نشد ولی دیدم هنوز فعال است. لطفا غیر فعال بفرمایید و فاکتور اخیر را نیز حذف بفرمایید. \r\nهم این سرویس و هم سرویس مانیتورینگ\r\nممنونم','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(19,'2023-01-19 18:27:02',409,'علت لغو کردن خود را مختصرا توضیح دهید','End of Billing Period','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(20,'2023-01-21 09:52:56',466,'نداشتن هزینه تمدید ','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(21,'2023-01-27 15:15:02',465,'امکان راه اندازی هیچ سرویسی وجود ندارد وبسیار محدود است','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(22,'2023-02-03 23:02:05',588,'عدم نیاز','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(23,'2023-02-06 18:38:03',597,'کندی سرعت ایترنت و داشتن لگ','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(24,'2023-02-09 21:29:23',587,'عدم نیاز','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(25,'2023-02-10 18:41:28',481,'niaz nadaram','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(26,'2023-02-18 13:21:55',539,'عدم نیاز','End of Billing Period','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(27,'2023-02-20 00:06:22',429,'تمام شدن','Immediate','0000-00-00 00:00:00','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `tblcancelrequests` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcarts`
--

DROP TABLE IF EXISTS `tblcarts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcarts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `tag` char(64) NOT NULL,
  `data` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `tblcarts_tag_unique` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcarts`
--

LOCK TABLES `tblcarts` WRITE;
/*!40000 ALTER TABLE `tblcarts` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblcarts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblclientgroups`
--

DROP TABLE IF EXISTS `tblclientgroups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblclientgroups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `groupname` varchar(45) NOT NULL,
  `groupcolour` varchar(45) DEFAULT NULL,
  `discountpercent` decimal(10,2) unsigned DEFAULT 0.00,
  `susptermexempt` text DEFAULT NULL,
  `separateinvoices` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblclientgroups`
--

LOCK TABLES `tblclientgroups` WRITE;
/*!40000 ALTER TABLE `tblclientgroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblclientgroups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblclients`
--

DROP TABLE IF EXISTS `tblclients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblclients` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL DEFAULT '',
  `firstname` text NOT NULL,
  `lastname` text NOT NULL,
  `companyname` text NOT NULL,
  `email` text NOT NULL,
  `address1` text NOT NULL,
  `address2` text NOT NULL,
  `city` text NOT NULL,
  `state` text NOT NULL,
  `postcode` text NOT NULL,
  `country` text NOT NULL,
  `phonenumber` text NOT NULL,
  `tax_id` varchar(128) NOT NULL DEFAULT '',
  `password` text NOT NULL,
  `authmodule` text NOT NULL,
  `authdata` text NOT NULL,
  `currency` int(10) NOT NULL,
  `defaultgateway` text NOT NULL,
  `credit` decimal(16,2) NOT NULL,
  `taxexempt` tinyint(1) NOT NULL,
  `latefeeoveride` tinyint(1) NOT NULL,
  `overideduenotices` tinyint(1) NOT NULL,
  `separateinvoices` tinyint(1) NOT NULL,
  `disableautocc` tinyint(1) NOT NULL,
  `datecreated` date NOT NULL,
  `notes` text NOT NULL,
  `billingcid` int(10) NOT NULL,
  `securityqid` int(10) NOT NULL,
  `securityqans` text NOT NULL,
  `groupid` int(10) NOT NULL,
  `cardtype` varchar(255) NOT NULL DEFAULT '',
  `cardlastfour` text NOT NULL,
  `cardnum` blob NOT NULL,
  `startdate` blob NOT NULL,
  `expdate` blob NOT NULL,
  `issuenumber` blob NOT NULL,
  `bankname` text NOT NULL,
  `banktype` text NOT NULL,
  `bankcode` blob NOT NULL,
  `bankacct` blob NOT NULL,
  `gatewayid` text NOT NULL,
  `lastlogin` datetime DEFAULT NULL,
  `ip` text NOT NULL,
  `host` text NOT NULL,
  `status` enum('Active','Inactive','Closed') NOT NULL DEFAULT 'Active',
  `language` text NOT NULL,
  `pwresetkey` text NOT NULL,
  `emailoptout` int(1) NOT NULL,
  `marketing_emails_opt_in` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `overrideautoclose` int(1) NOT NULL,
  `allow_sso` tinyint(1) NOT NULL DEFAULT 1,
  `email_verified` tinyint(1) NOT NULL DEFAULT 0,
  `email_preferences` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pwresetexpiry` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `firstname_lastname` (`firstname`(32),`lastname`(32)),
  KEY `email` (`email`(64))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblclients`
--

LOCK TABLES `tblclients` WRITE;
/*!40000 ALTER TABLE `tblclients` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblclients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblclientsfiles`
--

DROP TABLE IF EXISTS `tblclientsfiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblclientsfiles` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `title` text NOT NULL,
  `filename` text NOT NULL,
  `adminonly` int(1) NOT NULL,
  `dateadded` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblclientsfiles`
--

LOCK TABLES `tblclientsfiles` WRITE;
/*!40000 ALTER TABLE `tblclientsfiles` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblclientsfiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblconfiguration`
--

DROP TABLE IF EXISTS `tblconfiguration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblconfiguration` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `setting` varchar(64) NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `whmcs_setting_unique` (`setting`),
  KEY `setting` (`setting`)
) ENGINE=MyISAM AUTO_INCREMENT=356 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblconfiguration`
--

LOCK TABLES `tblconfiguration` WRITE;
/*!40000 ALTER TABLE `tblconfiguration` DISABLE KEYS */;
INSERT INTO `tblconfiguration` (`id`, `setting`, `value`, `created_at`, `updated_at`) VALUES (1,'Language','farsi','0000-00-00 00:00:00','2016-09-21 13:54:00'),
(2,'CompanyName','MTPCloud','0000-00-00 00:00:00','2022-08-13 05:08:05'),
(3,'Email','no-reply@MTPCloud.org','0000-00-00 00:00:00','2022-08-11 15:03:45'),
(4,'Domain','https://www.MTPCloud.org','0000-00-00 00:00:00','2022-08-20 06:43:43'),
(5,'LogoURL','https://my.MTPCloud.org/images/logo.png','0000-00-00 00:00:00','2022-08-13 05:07:27'),
(6,'SystemURL','https://my.MTPCloud.org/','0000-00-00 00:00:00','2022-08-20 04:21:31'),
(7,'UpdaterLatestVersion','8.5.1-release.1','2016-12-18 12:41:39','2022-06-22 13:17:01'),
(8,'DisableSessionIPCheck','on','0000-00-00 00:00:00','2019-07-08 16:30:52'),
(9,'AutoSuspension','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(10,'AutoSuspensionDays','1','0000-00-00 00:00:00','2016-10-30 16:48:35'),
(11,'CreateInvoiceDaysBefore','7','0000-00-00 00:00:00','2017-01-09 05:31:46'),
(12,'AffiliateEnabled','on','0000-00-00 00:00:00','2016-09-24 06:46:17'),
(13,'AffiliateEarningPercent','0','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(14,'AffiliateBonusDeposit','0.00','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(15,'AffiliatePayout','25.00','0000-00-00 00:00:00','2016-09-21 13:03:35'),
(16,'AffiliateLinks','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(17,'ActivityLimit','1000','0000-00-00 00:00:00','2019-05-19 14:46:10'),
(18,'DateFormat','YYYY/MM/DD','0000-00-00 00:00:00','2021-08-28 19:09:29'),
(19,'PreSalesQuestions','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(20,'Template','lagom2','0000-00-00 00:00:00','2022-08-13 03:56:55'),
(21,'AllowRegister','on','0000-00-00 00:00:00','2022-02-25 19:07:54'),
(22,'AllowTransfer','on','0000-00-00 00:00:00','2022-02-25 19:07:54'),
(23,'AllowOwnDomain','on','0000-00-00 00:00:00','2022-02-25 19:07:54'),
(24,'EnableTOSAccept','on','0000-00-00 00:00:00','2016-09-21 15:51:43'),
(25,'TermsOfService','https://www.keloncloud.com/terms-of-service/','0000-00-00 00:00:00','2022-08-13 13:29:21'),
(26,'AllowLanguageChange','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(27,'CutUtf8Mb4','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(28,'AllowCustomerChangeInvoiceGateway','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(29,'DefaultNameserver1','lincloud1.keloncloud.com','0000-00-00 00:00:00','2022-08-20 04:05:36'),
(30,'DefaultNameserver2','lincloud2.keloncloud.com','0000-00-00 00:00:00','2022-08-20 04:05:36'),
(31,'SendInvoiceReminderDays','5','0000-00-00 00:00:00','2019-04-03 06:42:17'),
(32,'SendReminder','on','0000-00-00 00:00:00','2017-01-22 05:38:33'),
(33,'NumRecordstoDisplay','50','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(34,'BCCMessages','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(35,'MailType','smtp','0000-00-00 00:00:00','2020-01-04 10:50:36'),
(40,'ShowCancellationButton','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(41,'UpdateStatsAuto','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(42,'InvoicePayTo','تهران','0000-00-00 00:00:00','2018-12-13 17:21:35'),
(43,'SendAffiliateReportMonthly','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(44,'InvalidLoginBanLength','15','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(45,'Signature','---\r\nکلون کلود\r\nhttp://cl.keloncloud.com','0000-00-00 00:00:00','2022-08-13 13:28:58'),
(46,'DomainOnlyOrderEnabled','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(47,'TicketBannedAddresses','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(48,'SendEmailNotificationonUserDetailsChange','','0000-00-00 00:00:00','2016-09-21 19:14:36'),
(49,'TicketAllowedFileTypes','.jpg,.gif,.jpeg,.png,.pdf,.doc,.docx,.txt','0000-00-00 00:00:00','2022-12-13 14:46:33'),
(50,'CloseInactiveTickets','72','0000-00-00 00:00:00','2016-12-20 14:36:17'),
(51,'InvoiceLateFeeAmount','5','0000-00-00 00:00:00','2018-02-16 17:39:20'),
(52,'AutoTermination','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(53,'AutoTerminationDays','60','0000-00-00 00:00:00','2017-01-10 05:44:10'),
(54,'RegistrarAdminFirstName','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(55,'RegistrarAdminLastName','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(56,'RegistrarAdminCompanyName','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(57,'RegistrarAdminAddress1','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(58,'RegistrarAdminAddress2','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(59,'RegistrarAdminCity','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(60,'RegistrarAdminStateProvince','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(61,'RegistrarAdminCountry','US','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(62,'RegistrarAdminPostalCode','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(63,'RegistrarAdminPhone','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(64,'RegistrarAdminFax','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(65,'RegistrarAdminEmailAddress','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(66,'RegistrarAdminUseClientDetails','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(67,'Charset','utf-8','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(68,'AutoUnsuspend','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(69,'RunScriptonCheckOut','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(70,'License','N2JjMzNjOTc0ZWJkZDcyNGQzYmRlYzQ3YTBkZjA0N2JkODFlNjU3Y2wxV1l1SnllczBuSWxaWGEwTldZ\ndWxrSTZJeWMxUlhZME5uSXNJaUk2SVNaMEZHWmxWSFowaFhadUpDTGlNWFowRkdad1ZGSWs1V1lnUW5j\ndkJIYzFObEk2SVNadEZtYmlzSEw5SlNaMmxHZGpGbWJKSmlPaU1YZDBGR2R6SkNMaUlpT2lVR2RoUlda\nMVJHZDRWbWJpd2lJc0ZtZHYxV1pTQnladWxHWnVGbWNDSmlPaVVXYmg1bUk3dGxPaU1uYnZSR1poSkNM\naUlpT2lVR2RoUldaMVJHZDRWbWJpd2lJd0lUTHhBVEw1RURNeUlpT2lVR2RoUjJabEpuSXNJQ011Y2pM\nM0lpT2k0MmJwTm5jbFpuSXNJQ055MFNPdzB5TXlBak1pb2pJbFJYWWt0MllsaDJZaXdpSW5KM2J1UVdk\ndngyWXdSWGJ1a1hidndGWjE5R2JqQkhkdDlDWGwxMmJvOUNYaW9qSXpKWGFrUldhc0ZtZGl3aUk1NHlN\neUlqTDFFak11TURNeElpT2lNSGNwUldhc0ZtZGl3aUluSjNidVFXZHZ4Mll3UlhidWtYYmlvakl6NVdh\naDEyYmtSV2FzRm1kaXdpSWwxV2FVQlNadTlrSTZJU1pzTldlamRtYnB4R2JwSm1Jc0lTTmlvaklrbEdk\nalZIWnZKSGNpd2lJbE5uYmxOV2FNQkNabHhHYjE1a0k2SVNadEZtYjBOV2RrOW1jd0pDTGljbWN2NUNa\nMTlHYmpCSGR0NVNldEppT2lVV2JoNUdabEpYWjBOWGFuVm1jaXdpSWtWM2JzTm1idnhXWnJKaU9pa1ha\nckpDTGlVbWRwUjNZQkppT2lNWGQwRkdkekp5ZTYxZjE1ODk1ODI1MTk0MTMxNGViMmE1OThjZDMyZmNi\nNzRkYWU3NDM5SkNabU5qWjNFbU4xWVdaNGtqTWhsVE1tSkdNaFpXWXlFbU1rVjJOMklUTmlOR1ozVVdP\na05EWmlvaklvTlhZb0pDTGQxbklsWlhhME5XWXVsa0k2SXljMVJYWTBObklzSWlJNklTWjBGR1psVkha\nMGhYWnVKQ0xpY21icFJtYmhKblFnOG1UZ2tIYm9SbmJ2MUVJMEZHYURCU1oybEdUaW9qSWwxV1l1Snll\nczBuSWxaWGEwTldZdWxrSTZJeWMxUlhZME5uSXNJaUk2SVNaMEZHWmxWSFowaFhadUpDTGk0MmJrUldR\nZ1UyWmh0MlloQkZJbHhtWWhKWGRubG1adTkyUWlvaklsMVdZdUp5ZXMwbklsWlhhME5XWXVsa0k2SXlj\nMVJYWTBObklzSWlJNklTWjBGR1psVkhaMGhYWnVKQ0xpQUhjQkJDWnA5bWNrNVdRaW9qSWwxV1l1Snll\nczBuSWxaWGEwTldZdWxrSTZJeWMxUlhZME5uSXNJaUk2SVNaMEZHWmxWSFowaFhadUpDTGlBSGNCQlNa\ndTlHYVFsbUk2SVNadEZtYmlzSEw5SlNaMmxHZGpGbWJKSmlPaU1YZDBGR2R6SkNMaUlpT2lVR2RoUlda\nMVJHZDRWbWJpd2lJdTlXYTBsR1pGQlNac2xtWXYxa0k2SVNadEZtYmlzSEw5SlNaMmxHZGpGbWJKSmlP\naU1YZDBGR2R6SkNMaUlpT2lVR2RoUldaMVJHZDRWbWJpd2lJdTlHWmtGRUluNVdhejVXWmpsR1Rpb2pJ\nbDFXWXVKeWVzMG5JbFpYYTBObWJKSmlPaU1YZDBGR2R6SkNMaUlpT2lVR2RoUldaMVJHZDRWbWJpd2lJ\ndTlHWmtGRUkwNVdadFYyWmg1V1lOQkNkalZtYXZKSFVpb2pJNGRhM2EyYzdkZWFmMGYyMDliMWM1MTIw\nZTZmNTU3NjQ2YjhkMjRkOQ==','0000-00-00 00:00:00','2023-09-23 21:10:44'),
(71,'PhoneNumberDropdown','1','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(72,'OrderFormTemplate','lagom2','0000-00-00 00:00:00','2022-08-13 03:56:55'),
(73,'AllowDomainsTwice','','0000-00-00 00:00:00','2016-09-21 19:22:11'),
(74,'AddLateFeeDays','15','0000-00-00 00:00:00','2017-01-10 05:44:10'),
(75,'TaxEnabled','on','0000-00-00 00:00:00','2022-08-23 01:57:55'),
(76,'DefaultCountry','IR','0000-00-00 00:00:00','2016-09-21 13:54:00'),
(77,'OrderFormSidebarToggle','1','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(78,'AutoRedirectoInvoice','gateway','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(79,'EnablePDFInvoices','','0000-00-00 00:00:00','2016-11-07 11:18:37'),
(80,'CaptchaSetting','','0000-00-00 00:00:00','2019-07-20 10:36:36'),
(81,'SupportTicketOrder','DESC','0000-00-00 00:00:00','2018-04-23 00:01:57'),
(82,'SendFirstOverdueInvoiceReminder','3','0000-00-00 00:00:00','2019-04-03 06:42:17'),
(83,'TaxType','Exclusive','0000-00-00 00:00:00','2022-08-23 02:46:30'),
(84,'DefaultNameserver3','wincloud1.keloncloud.com','0000-00-00 00:00:00','2022-08-20 04:05:36'),
(85,'DomainDNSManagement','5.00','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(86,'DomainEmailForwarding','5.00','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(87,'InvoiceIncrement','1','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(88,'ContinuousInvoiceGeneration','on','0000-00-00 00:00:00','2016-10-29 20:09:05'),
(89,'AutoCancellationRequests','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(90,'SystemEmailsFromName','کلون کلود','0000-00-00 00:00:00','2022-08-13 13:28:58'),
(91,'SystemEmailsFromEmail','no-reply@keloncloud.com','0000-00-00 00:00:00','2022-09-04 19:00:05'),
(92,'AllowClientRegister','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(93,'BulkCheckTLDs','.com,.net','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(94,'OrderDaysGrace','7','0000-00-00 00:00:00','2016-09-21 15:51:43'),
(95,'CreditOnDowngrade','','0000-00-00 00:00:00','2016-09-21 19:14:36'),
(96,'AcceptedCardTypes','','0000-00-00 00:00:00','2016-12-24 07:23:36'),
(97,'TaxDomains','on','0000-00-00 00:00:00','2022-08-23 01:58:49'),
(98,'TaxLateFee','on','0000-00-00 00:00:00','2022-08-23 01:58:49'),
(99,'PremiumDomains','0','2016-12-18 16:11:39','2016-12-18 16:11:39'),
(100,'ProductMonthlyPricingBreakdown','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(101,'LateFeeType','Percentage','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(102,'SendSecondOverdueInvoiceReminder','2','0000-00-00 00:00:00','2019-04-03 06:42:17'),
(103,'SendThirdOverdueInvoiceReminder','1','0000-00-00 00:00:00','2019-04-03 06:42:17'),
(104,'DomainIDProtection','5.00','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(105,'DomainRenewalNotices','30,7,-3,0,0','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(106,'SequentialInvoiceNumbering','1','0000-00-00 00:00:00','2022-08-23 02:41:37'),
(107,'SequentialInvoiceNumberFormat','{NUMBER}','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(108,'SequentialInvoiceNumberValue','577','0000-00-00 00:00:00','2023-02-23 12:59:06'),
(109,'DefaultNameserver4','wincloud2.keloncloud.com','0000-00-00 00:00:00','2022-08-20 04:05:36'),
(110,'AffiliatesDelayCommission','0','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(111,'SupportModule','','0000-00-00 00:00:00','2019-08-06 14:35:03'),
(112,'AddFundsEnabled','on','0000-00-00 00:00:00','2016-09-24 06:47:29'),
(113,'AddFundsMinimum','1000.00','0000-00-00 00:00:00','2018-11-26 16:28:58'),
(114,'AddFundsMaximum','100000000.00','0000-00-00 00:00:00','2019-02-27 17:49:37'),
(115,'AddFundsMaximumBalance','100000000.00','0000-00-00 00:00:00','2019-02-27 17:49:37'),
(117,'CCProcessDaysBefore','0','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(118,'CCAttemptOnlyOnce','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(119,'CCDaySendExpiryNotices','25','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(120,'BulkDomainSearchEnabled','1','0000-00-00 00:00:00','2016-09-21 13:24:56'),
(121,'AutoRenewDomainsonPayment','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(122,'DomainAutoRenewDefault','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(123,'CCRetryEveryWeekFor','0','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(124,'SupportTicketKBSuggestions','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(125,'DailyEmailBackup','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(126,'FTPBackupHostname','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(127,'FTPBackupUsername','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(128,'FTPBackupPassword','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(129,'FTPBackupDestination','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(130,'TaxL2Compound','','0000-00-00 00:00:00','2022-08-23 02:46:04'),
(131,'SEOFriendlyUrls','','0000-00-00 00:00:00','2017-01-09 06:34:17'),
(132,'ShowCCIssueStart','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(133,'TicketRatingEnabled','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(134,'NetworkIssuesRequireLogin','','0000-00-00 00:00:00','2016-09-24 21:37:01'),
(135,'ShowNotesFieldOnCheckout','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(136,'RequireLoginforClientTickets','on','0000-00-00 00:00:00','2019-08-23 05:28:24'),
(137,'EmailCSS','.ExternalClass,.ExternalClass div,.ExternalClass font,.ExternalClass p,.ExternalClass span,.ExternalClass td,h1,img{line-height:100%}h1,h2{display:block;font-family:Tahoma;font-style:normal;font-weight:700}#outlook a{padding:0}.ExternalClass,.ReadMsgBody{width:100%}a,blockquote,body,li,p,table,td{-webkit-text-size-adjust:100%;-ms-text-size-adjust:100%}table,td{mso-table-lspace:0;mso-table-rspace:0}img{-ms-interpolation-mode:bicubic;border:0;height:auto;outline:0;text-decoration:none}table{border-collapse:collapse!important}#bodyCell,#bodyTable,body{height:100%!important;margin:0;padding:0;width:100%!important}#bodyCell{padding:20px;}#templateContainer{width:600px;border:1px solid #ddd;background-color:#fff}#bodyTable,body{background-color:#FAFAFA}h1{color:#202020!important;font-size:26px;letter-spacing:normal;text-align:right;margin:0 0 10px}h2{color:#404040!important;font-size:20px;line-height:100%;letter-spacing:normal;text-align:right;margin:0 0 10px}h3,h4{display:block;font-style:italic;font-weight:400;letter-spacing:normal;text-align:right;margin:0 0 10px;font-family:Tahoma;line-height:100%}h3{color:#606060!important;font-size:16px}h4{color:grey!important;font-size:14px}.headerContent{background-color:#f8f8f8;border-bottom:1px solid #ddd;color:#505050;font-family:Tahoma;font-size:20px;font-weight:700;line-height:100%;text-align:right;vertical-align:middle;padding:0}.bodyContent,.footerContent{font-family:Tahoma;line-height:150%;text-align:right;}.footerContent{text-align:center}.bodyContent pre{padding:15px;background-color:#444;color:#f8f8f8;border:0}.bodyContent pre code{white-space:pre;word-break:normal;word-wrap:normal}.bodyContent table{margin:10px 0;background-color:#fff;border:1px solid #ddd}.bodyContent table th{padding:4px 10px;background-color:#f8f8f8;border:1px solid #ddd;font-weight:700;text-align:center}.bodyContent table td{padding:3px 8px;border:1px solid #ddd}.table-responsive{border:0}.bodyContent a{word-break:break-all}.headerContent a .yshortcuts,.headerContent a:link,.headerContent a:visited{color:#1f5d8c;font-weight:400;text-decoration:underline}#headerImage{height:auto;max-width:600px;padding:20px}#templateBody{background-color:#fff}.bodyContent{color:#505050;font-size:14px;padding:20px}.bodyContent a .yshortcuts,.bodyContent a:link,.bodyContent a:visited{color:#1f5d8c;font-weight:400;text-decoration:underline}.bodyContent a:hover{text-decoration:none}.bodyContent img{display:inline;height:auto;max-width:560px}.footerContent{color:grey;font-size:12px;padding:20px}.footerContent a .yshortcuts,.footerContent a span,.footerContent a:link,.footerContent a:visited{color:#606060;font-weight:400;text-decoration:underline}@media only screen and (max-width:640px){h1,h2,h3,h4{line-height:100%!important}#templateContainer{max-width:600px!important;width:100%!important}#templateContainer,body{width:100%!important}a,blockquote,body,li,p,table,td{-webkit-text-size-adjust:none!important}body{min-width:100%!important}#bodyCell{padding:10px!important}h1{font-size:24px!important}h2{font-size:20px!important}h3{font-size:18px!important}h4{font-size:16px!important}#templatePreheader{display:none!important}.headerContent{font-size:20px!important;line-height:125%!important}.footerContent{font-size:14px!important;line-height:115%!important}.footerContent a{display:block!important}.hide-mobile{display:none;}}','0000-00-00 00:00:00','2022-08-20 06:38:07'),
(138,'CurrencyAutoUpdateExchangeRates','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(139,'CurrencyAutoUpdateProductPrices','on','0000-00-00 00:00:00','2017-01-22 05:38:33'),
(140,'RequiredPWStrength','50','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(141,'MaintenanceMode','','0000-00-00 00:00:00','2017-01-09 06:30:21'),
(142,'MaintenanceModeMessage','&lt;img src=&quot;https://cl.keloncloud.com/templates/sixrtl/img/TopLogo.png&quot; /&gt;\r\n&lt;h1&gt;\r\nسایت در حال بروزرسانی است \r\n&lt;br /&gt;\r\nلطفا اندکی صبوری نمایید \r\n&lt;/h1&gt;','0000-00-00 00:00:00','2017-01-09 06:29:51'),
(143,'SkipFraudForExisting','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(145,'ContactFormDept','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(146,'ContactFormTo','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(147,'TicketEscalationLastRun','2025-12-01 04:40:04','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(148,'APIAllowedIPs','a:0:{}','0000-00-00 00:00:00','2022-08-27 13:22:28'),
(149,'NOMD5','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(150,'DisableSupportTicketReplyEmailsLogging','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(151,'OverageBillingMethod','1','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(287,'GatewayModuleHooks','','2020-02-26 09:38:58','2020-02-26 09:38:58'),
(153,'CCAllowCustomerDelete','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(154,'CreateDomainInvoiceDaysBefore','7','0000-00-00 00:00:00','2016-10-30 16:48:00'),
(155,'NoInvoiceEmailOnOrder','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(156,'TaxInclusiveDeduct','','0000-00-00 00:00:00','2022-08-23 02:46:04'),
(157,'LateFeeMinimum','0.00','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(158,'AutoProvisionExistingOnly','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(159,'EnableDomainRenewalOrders','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(160,'EnableMassPay','','0000-00-00 00:00:00','2017-01-13 18:06:52'),
(161,'NoAutoApplyCredit','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(162,'CreateInvoiceDaysBeforeMonthly','7','0000-00-00 00:00:00','2016-10-30 16:48:00'),
(163,'CreateInvoiceDaysBeforeQuarterly','7','0000-00-00 00:00:00','2016-10-30 16:48:00'),
(164,'CreateInvoiceDaysBeforeSemiAnnually','7','0000-00-00 00:00:00','2016-10-30 16:48:00'),
(165,'CreateInvoiceDaysBeforeAnnually','7','0000-00-00 00:00:00','2016-10-30 16:48:00'),
(166,'CreateInvoiceDaysBeforeBiennially','7','0000-00-00 00:00:00','2016-10-30 16:48:00'),
(167,'CreateInvoiceDaysBeforeTriennially','7','0000-00-00 00:00:00','2016-10-30 16:48:00'),
(168,'ClientsProfileUneditableFields','firstname,lastname,phonenumber','0000-00-00 00:00:00','2017-02-06 12:42:24'),
(169,'ClientDisplayFormat','1','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(170,'CCDoNotRemoveOnExpiry','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(171,'GenerateRandomUsername','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(172,'AddFundsRequireOrder','','0000-00-00 00:00:00','2019-09-23 07:15:40'),
(173,'GroupSimilarLineItems','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(174,'ProrataClientsAnniversaryDate','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(175,'TCPDFFont','dejavusans','0000-00-00 00:00:00','2020-10-11 06:19:44'),
(176,'CancelInvoiceOnCancellation','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(177,'AttachmentThumbnails','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(178,'EmailGlobalHeader','&lt;!DOCTYPE html PUBLIC &quot;-//W3C//DTD XHTML 1.0 Transitional//EN&quot; &quot;http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd&quot;&gt;\r\n&lt;html xmlns=&quot;http://www.w3.org/1999/xhtml&quot;&gt;\r\n    &lt;head&gt;\r\n        &lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset={$charset}&quot; /&gt;\r\n        &lt;meta name=&quot;viewport&quot; content=&quot;width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no&quot;&gt;\r\n        &lt;style type=&quot;text/css&quot;&gt;\r\n            [EmailCSS]\r\n        &lt;/style&gt;\r\n    &lt;/head&gt;\r\n    &lt;body leftmargin=&quot;0&quot; marginwidth=&quot;0&quot; topmargin=&quot;0&quot; marginheight=&quot;0&quot; offset=&quot;0&quot;&gt;\r\n        &lt;center&gt;\r\n            &lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;100%&quot; width=&quot;100%&quot; id=&quot;bodyTable&quot;&gt;\r\n                &lt;tr&gt;\r\n                    &lt;td align=&quot;center&quot; valign=&quot;top&quot; id=&quot;bodyCell&quot;&gt;\r\n                        &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; id=&quot;templateContainer&quot;&gt;\r\n                            &lt;tr&gt;\r\n                                &lt;td align=&quot;center&quot; valign=&quot;top&quot;&gt;\r\n                                    &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;100%&quot; id=&quot;templateHeader&quot;&gt;\r\n                                        &lt;tr&gt;\r\n                                            &lt;td valign=&quot;top&quot; class=&quot;headerContent&quot;&gt;\r\n                                                &lt;a href=&quot;{$company_domain}&quot;&gt;\r\n                                                    &lt;img src=&quot;{$company_logo_url}&quot; style=&quot;max-width:600px;padding:20px&quot; id=&quot;headerImage&quot; alt=&quot;{$company_name}&quot; /&gt;\r\n                                            &lt;/td&gt;\r\n                                        &lt;/tr&gt;\r\n                                    &lt;/table&gt;\r\n                                &lt;/td&gt;\r\n                            &lt;/tr&gt;\r\n                            &lt;tr&gt;\r\n                                &lt;td align=&quot;center&quot; valign=&quot;top&quot;&gt;\r\n                                    &lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;100%&quot; id=&quot;templateBody&quot;&gt;\r\n                                        &lt;tr&gt;\r\n                                            &lt;td valign=&quot;top&quot; class=&quot;bodyContent&quot;&gt;','0000-00-00 00:00:00','2022-08-20 06:38:07'),
(179,'EmailGlobalFooter','&lt;/td&gt;\r\n&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/td&gt;\r\n&lt;/tr&gt;\r\n&lt;tr&gt;\r\n&lt;td align=&quot;center&quot; valign=&quot;top&quot;&gt;\r\n&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;100%&quot; id=&quot;templateFooter&quot;&gt;\r\n&lt;tr&gt;\r\n    &lt;td valign=&quot;top&quot; class=&quot;footerContent&quot;&gt;\r\n         &lt;a href=&quot;https://www.keloncloud.com&quot;&gt;مشاهده سایت&lt;/a&gt;\r\n        &lt;span class=&quot;hide-mobile&quot;&gt; | &lt;/span&gt;\r\n        &lt;a href=&quot;{$whmcs_url}&quot;&gt;ورود به ناحیه کاربری&lt;/a&gt;\r\n        &lt;span class=&quot;hide-mobile&quot;&gt; | &lt;/span&gt;\r\n        &lt;a href=&quot;{$whmcs_url}submitticket.php&quot;&gt;ارسال تیکت پشتیبانی&lt;/a&gt; &lt;br /&gt;\r\n        تمامی حقوق متعلق به  © {$company_name} می باشد.\r\n    &lt;/td&gt;\r\n&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/td&gt;\r\n&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/td&gt;\r\n&lt;/tr&gt;\r\n&lt;/table&gt;\r\n&lt;/center&gt;\r\n&lt;/body&gt;\r\n&lt;/html&gt;','0000-00-00 00:00:00','2022-08-20 06:40:07'),
(180,'DomainSyncEnabled','','0000-00-00 00:00:00','2019-10-19 09:34:39'),
(181,'DomainSyncNextDueDate','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(182,'DomainSyncNextDueDateDays','0','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(183,'TicketMask','%n%n%n%n%n%n','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(184,'AutoClientStatusChange','3','0000-00-00 00:00:00','2020-05-08 18:46:40'),
(185,'AllowClientsEmailOptOut','0','0000-00-00 00:00:00','2018-07-24 17:42:37'),
(186,'BannedSubdomainPrefixes','mail,mx,gapps,gmail,webmail,cpanel,whm,ftp,clients,billing,members,login,accounts,access','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(187,'FreeDomainAutoRenewRequiresProduct','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(188,'DomainToDoListEntries','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(189,'Version','8.5.1-release.1','0000-00-00 00:00:00','2022-08-11 13:47:09'),
(190,'MDEFromTime','2016-09-21 13:03:36','2016-09-21 13:03:36','2016-09-21 13:03:36'),
(191,'ModuleHooks','','2016-09-21 13:03:36','2023-03-10 09:44:21'),
(192,'AddonModulesHooks','','2016-09-21 13:03:36','2023-03-10 09:39:57'),
(193,'ActiveAddonModules','ChangeMainDomain,ConfigServer,CpanelChangeMainDomain,CpanelResetHost,CpanelWordpressInstallation,HetznerCloud,PleskChangeMainDomain,PleskResetHost,RSThemes,SSLCENTERWHMCS,SeoManager,adminchangepassword,csfmanager,ippanel_sms,litespeedRenew,mellat_verify_list,mellatbank_transaction,mellatbank_verification,mspcontrol_addons,plesksync,sabaSMS,sms_addon,smsalert,subirnic,wordpress_autoinstaller','0000-00-00 00:00:00','2023-03-10 09:39:57'),
(194,'InstanceID','5EvbyOIVpiPp','2016-09-21 13:05:26','2016-09-21 13:05:26'),
(195,'token_namespaces','a:3:{s:13:\"WHMCS.default\";b:1;s:19:\"WHMCS.admin.default\";b:1;s:19:\"WHMCS.domainchecker\";b:0;}','2016-09-21 13:05:26','2016-09-21 13:05:26'),
(196,'domainLookupProvider','WhmcsDomains','2016-09-21 13:23:59','2018-05-30 21:30:21'),
(197,'MaintenanceModeURL','','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(198,'ClientDateFormat','fullday','2016-09-21 13:24:56','2018-04-07 04:40:25'),
(199,'EnableTranslations','1','2016-09-21 13:24:56','2016-11-22 09:35:43'),
(200,'DomainSyncNotifyOnly','','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(201,'AllowIDNDomains','','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(202,'DefaultNameserver5','','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(204,'TicketEmailLimit','10','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(205,'ShowClientOnlyDepts','','2016-09-21 13:24:56','2016-09-24 21:37:55'),
(206,'PreventEmailReopening','1','2016-09-21 13:24:56','2017-01-09 06:34:17'),
(207,'UpdateLastReplyTimestamp','statusonly','2016-09-21 13:24:56','2018-04-23 00:01:40'),
(208,'DownloadsIncludeProductLinked','','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(209,'PDFPaperSize','A4','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(210,'StoreClientDataSnapshotOnInvoiceCreation','','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(211,'AutoCancelSubscriptions','','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(212,'EnableProformaInvoicing','1','2016-09-21 13:24:56','2022-08-23 02:41:37'),
(213,'AffiliateDepartment','3','2016-09-21 13:24:56','2016-10-15 13:53:16'),
(214,'CaptchaType','recaptcha','2016-09-21 13:24:56','2019-08-11 08:10:45'),
(215,'ReCAPTCHAPublicKey','6LdfdWcUAAAAAKJHEhWXYwFNoeyGHE9x6G8zV-0p','2016-09-21 13:24:56','2018-07-31 15:41:40'),
(216,'ReCAPTCHAPrivateKey','6LdfdWcUAAAAAFVh1Pd9K0NHv2pMqInlWnFrtxsF','2016-09-21 13:24:56','2018-07-31 15:41:40'),
(217,'EnableEmailVerification','0','2016-09-21 13:24:56','2016-09-27 12:32:49'),
(218,'sendFailedLoginWhitelist','0','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(219,'DisableAdminPWReset','','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(220,'AllowSmartyPhpTags','1','2016-09-21 13:24:56','2016-09-21 15:18:23'),
(221,'proxyHeader','X_FORWARDED_FOR','2016-09-21 13:24:56','2022-08-27 13:34:13'),
(222,'LogAPIAuthentication','1','2016-09-21 13:24:56','2017-02-06 12:42:24'),
(223,'TwitterUsername','','2016-09-21 13:24:56','2016-09-21 13:24:56'),
(224,'AnnouncementsTweet','on','2016-09-21 13:24:56','2017-02-06 12:42:24'),
(225,'AnnouncementsFBRecommend','on','2016-09-21 13:24:56','2017-02-06 12:42:24'),
(226,'AnnouncementsFBComments','on','2016-09-21 13:24:56','2017-02-06 12:42:24'),
(288,'TicketAddCarbonCopyRecipients','1','2020-02-26 09:38:58','2020-02-26 09:38:58'),
(228,'DefaultToClientArea','','2016-09-21 13:24:56','2022-08-27 13:22:41'),
(229,'ClientsProfileOptionalFields','phonenumber','2016-09-21 13:24:56','2022-08-27 13:22:41'),
(230,'DisplayErrors','on','2016-09-21 13:24:56','2020-04-28 08:21:45'),
(231,'SQLErrorReporting','on','2016-09-21 13:24:56','2020-06-15 06:50:59'),
(232,'HooksDebugMode','','2016-09-21 13:24:56','2022-09-15 18:48:54'),
(233,'LoginFailures','a:53:{s:12:\"5.238.198.78\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1474472819;}s:14:\"31.171.223.137\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1474726239;}s:15:\"188.165.154.245\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1478006022;}s:13:\"93.118.161.72\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1475264295;}s:14:\"151.80.211.157\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1486275057;}s:13:\"2.176.166.235\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1479670984;}s:13:\"5.212.237.251\";a:2:{s:5:\"count\";i:2;s:7:\"expires\";i:1482219861;}s:13:\"141.101.76.27\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1484028400;}s:14:\"141.101.69.194\";a:2:{s:5:\"count\";i:2;s:7:\"expires\";i:1484028763;}s:13:\"5.238.207.232\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1484845256;}s:13:\"54.210.12.240\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1485077668;}s:12:\"5.209.253.74\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1491202426;}s:13:\"37.156.30.186\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1493035007;}s:13:\"89.199.175.28\";a:2:{s:5:\"count\";i:2;s:7:\"expires\";i:1496258728;}s:12:\"31.2.144.167\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1497680682;}s:14:\"89.199.137.139\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1499089363;}s:12:\"31.2.190.162\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1503252713;}s:14:\"89.199.107.132\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1505124621;}s:13:\"86.55.123.245\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1505477456;}s:13:\"5.106.252.227\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1506168667;}s:14:\"162.158.90.221\";a:2:{s:5:\"count\";i:2;s:7:\"expires\";i:1518590803;}s:12:\"5.210.185.63\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1522048144;}s:11:\"89.199.21.8\";a:2:{s:5:\"count\";i:2;s:7:\"expires\";i:1523983721;}s:12:\"5.210.72.239\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1528027398;}s:12:\"46.224.49.14\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1528815598;}s:13:\"46.224.48.252\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1532681658;}s:13:\"46.224.117.11\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1535739315;}s:13:\"5.209.240.159\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1546544490;}s:12:\"5.117.167.64\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1557165221;}s:13:\"185.187.51.84\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1557216790;}s:13:\"162.158.88.16\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1591546355;}s:12:\"162.158.92.6\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1600485989;}s:14:\"162.158.91.175\";a:2:{s:5:\"count\";i:2;s:7:\"expires\";i:1601404652;}s:13:\"89.199.74.223\";a:2:{s:5:\"count\";i:2;s:7:\"expires\";i:1635246744;}s:14:\"185.187.51.210\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1643395664;}s:12:\"5.106.41.199\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1643534581;}s:12:\"62.204.61.42\";a:2:{s:5:\"count\";i:2;s:7:\"expires\";i:1648897089;}s:12:\"37.19.84.201\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1649537721;}s:9:\"5.52.70.6\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1650562640;}s:12:\"2.190.93.220\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1653830614;}s:13:\"172.70.250.71\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1658390315;}s:14:\"172.70.251.130\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1658673018;}s:14:\"212.33.196.204\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1660923509;}s:11:\"2.176.31.46\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1661748536;}s:13:\"2.191.240.180\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1662228530;}s:13:\"84.241.25.102\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1679404647;}s:13:\"91.231.84.201\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1667246832;}s:13:\"91.231.84.214\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1668117556;}s:13:\"78.47.147.179\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1668327269;}s:15:\"135.181.156.237\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1668682785;}s:13:\"103.215.223.7\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1669104133;}s:15:\"142.132.234.153\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1669662196;}s:14:\"103.215.223.64\";a:2:{s:5:\"count\";i:1;s:7:\"expires\";i:1677181789;}}','2016-09-21 15:16:59','2023-03-21 12:47:27'),
(234,'DisableSetupWizard','1','2016-12-18 12:41:39','2016-12-18 12:41:39'),
(235,'AddonModulesPerms','a:0:{}','0000-00-00 00:00:00','2023-03-10 09:39:50'),
(285,'DomainTransferStatusCheckFrequency','0','2019-10-19 09:34:39','2019-10-19 09:34:39'),
(282,'WhitelistedIPs','a:0:{}','2019-06-15 06:09:56','2022-08-27 13:22:00'),
(350,'trustedProxyIps','[{\"ip\":\"212.33.196.204\",\"note\":\"\"},{\"ip\":\"103.215.223.7\",\"note\":\"\"}]','2022-08-27 13:06:28','2022-11-22 17:59:27'),
(236,'EmailMarketingOptInMessage','We would like to send you occasional news, information and special offers by email. To join our mailing list, simply tick the box below. You can unsubscribe at any time.','2018-07-24 17:24:21','2018-07-24 17:24:21'),
(237,'RegistrarModuleHooks','','2016-09-21 18:20:31','2016-09-21 18:20:31'),
(238,'FTPBackupPort','0','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(239,'SystemStatsCache','{\"clientStatus\":[],\"productModules\":{\"\":104,\"HetznerCloud\":18,\"virtualizor\":2},\"productModules30\":[],\"productModules90\":[],\"productAddonModules\":[],\"productAddonModules30\":[],\"productAddonModules90\":[],\"domainModules\":{\"domainnameapi\":15,\"hostcontrol\":1,\"SPDomainReseller\":1},\"domainModules30\":[],\"domainModules90\":[],\"invoiceModules\":[],\"invoicePaidLast30d\":[],\"addonModules\":{\"adminchangepassword\":\"1.0\",\"ChangeMainDomain\":\"1.0\",\"ConfigServer\":\"1.5.0\",\"CpanelChangeMainDomain\":\"1.0\",\"CpanelResetHost\":\"1.0\",\"CpanelWordpressInstallation\":\"1.0\",\"csfmanager\":\"1.0\",\"HetznerCloud\":\"2020.7\",\"ippanel_sms\":\"2.5\",\"litespeedRenew\":\"1.0\",\"mellat_verify_list\":\"Legacy Module\",\"mellatbank_transaction\":\"Legacy Module\",\"mellatbank_verification\":\"Legacy Module\",\"mspcontrol_addons\":\"3.0.7\",\"PleskChangeMainDomain\":\"1.0\",\"PleskResetHost\":\"1.0\",\"plesksync\":\"2.0b\",\"RSThemes\":\"2.1.1\",\"sabaSMS\":\"1.2.0\",\"SeoManager\":\"2.1.1\",\"sms_addon\":\"Legacy Module\",\"smsalert\":\"1.1\",\"SSLCENTERWHMCS\":\"2.1.12\",\"subirnic\":\"1.0\",\"wordpress_autoinstaller\":\"1.0\"},\"enabledFraudModule\":{\"NONE\":1},\"fraudModuleOfOrders\":[],\"notificationModules\":[],\"domainLookupProvider\":{\"WhmcsDomains\":1},\"servers\":{\"cpanel\":1},\"appLinks\":{\"servers_cpanel\":1},\"authProviders\":[],\"defaultOrderform\":{\"standard_cart\":1},\"orderforms\":{\"standard_cart\":1},\"clientTheme\":{\"CUSTOM\":1},\"adminThemes\":{\"blend\":1},\"backups\":{\"ftp\":false,\"cpanel\":false,\"email\":false},\"twoFactorAuth\":{\"duo\":false,\"totp\":false,\"yubikey\":false},\"featureShowcase\":null,\"autoUpdate\":{\"count\":12,\"success\":5},\"languages\":{\"systemDefault\":\"farsi\",\"clientUsage\":{\"farsi\":0},\"adminUsage\":{\"english\":2,\"farsi\":0}},\"dbCollationStats\":{\"synced\":false,\"collations\":[\"utf8mb3_unicode_ci\",\"utf8mb3_general_ci\",\"latin1_swedish_ci\"],\"stats\":{\"utf8mb3_unicode_ci\":841,\"utf8mb3_general_ci\":146,\"latin1_swedish_ci\":68}},\"hasSslAvailable\":true,\"captcha\":{\"setting\":\"disabled\",\"type\":\"\",\"invisible\":\"\"},\"domainFeatures\":{\"isEnabled\":1,\"gracePeriods\":13,\"redemptionPeriods\":0},\"domainSyncSettings\":{\"isEnabled\":false,\"dueDateSyncEnabled\":false,\"dueDateSyncDays\":0,\"notifyOnlyEnabled\":false,\"statusSyncHours\":0,\"transferPendingSyncHours\":0},\"wptk\":{\"cPanelAddOn\":0,\"pleskAddOn\":0,\"cPanelLandingPage.hits.30Days\":0,\"cPanelLandingPage.hits.Lifetime\":0,\"cPanelLandingPage.cart.30Days\":0,\"cPanelLandingPage.cart.Lifetime\":0,\"activeBilledAddon\":0},\"wordpressInstallations\":{\"total\":0,\"total.adminInstallAllowed\":0,\"total.clientInstallAllowed\":0,\"total.automationInstallation\":0,\"total.services\":0,\"total.services_wp\":0,\"instances\":0},\"additionalModuleInfo\":[]}','2016-10-31 07:01:03','2025-01-04 05:31:17'),
(240,'MemberPubKey','/7n16sxRA3BxR7IthiGv6qBTAiYggrCbJtWKaT0G6DUi87HMMskNlocRg8Stf2qq9ggVg2ULGbAxLnlmVzW70MHf3i9PqGvpDzxE4n0YhMvAobDKMujVXmL29Xwr0jblyRosmBNrafGQHlC6lvxZWaePOYshiLuDDySulNOpkxx6t1YXSwzAOWhW7PGjdZNr1GHaJvTH4n1XOtzvfDojwKquQKn97RRffAD0D7H0a2RsK4eMSmmYFdaWGq4zaeCzkn9ckc71QMGyp8cBWhi+2I1h7Na0brsIcKMd5kER6dnS+YXsfbYeX6w0BggqIlOrpOdH1AFhlCX3gJTNmVsxhUWAcwX1+yqfOPN/2pPAdHxsUUa56sTk3FKiL3ADr9GZb5DpqqG58x+MOrOBYM6b7xmSRQFfJo016aK16ts4h466OGWlSbPfdJmhxDjGssa9OJ5kq7TXsG+TXCZouRaplLEarGSC6ENP2T6QKTC2OYoC9M3tW12M02y+V2zuCd7Fe7jhDFTn73tlJ9TOcdBPjzt8IDA4nTQKg1oxOt0COYgIlsQr+XePOhIrZIsV5kKS65wc2YtxdVwkfIcETjNh7QsAalaj0oX270uBv5z2EPPcSX0SQSNEOkdOZZLD3Im5/79vzFYJUwbSz0qH5T/k+42Nhc9b9xxon7sY9aEt6JUIFZ/x28lq+SXPdabuXdayFbLB7eH4R3GhwjifUsFtXOd1MGPng03dSbPwmiT6cxT9MU2JBy5do7z929ii0Z2q3Hjs4ndkKzhuQ16VJwe9O+6jkvYP8kPBZgVeMVwoX0HYblawy2wMgD/lEpdxPAwtQzPGa5nVGleUqjlKVuCkwmCtgzjWZL5xtoNE+Kmzt6NsvcL4s4F7xbQj5N4keUdC6rBcaP+2RG7piLz9m9cwwUFvfQ6f4WDogxyvVKFmDzWUQdqha5EM3Y/MbeDdnFXhlNt1tpkVGfTGHryLuA3OgvIiwp9dMnW/6o8v1DmTlfk0IE+99HcjdJ0YUK09Hq8ywyu2WYshqJld/MHUHwRTM5XD4Q0qzojIrjZ97DHnVao8cHhRUoY=','2016-12-20 08:04:01','2016-12-20 08:04:01'),
(241,'WHMCSUpdatePinVersion','beta','2016-12-18 12:41:40','2020-10-06 05:19:19'),
(242,'GoGetSSL_APIKey','83615e7117c22bdafd0a0e39ca95114a132a5bbe','2016-11-27 06:09:22','2019-05-20 04:06:38'),
(243,'GoGetSSL_APIKeyExpire','1584680798','2016-11-27 06:09:22','2019-05-20 04:06:38'),
(244,'UpdaterLatestBetaVersion','8.0.2-release.1','2016-12-18 12:41:39','2020-10-15 06:39:16'),
(245,'UpdaterLatestStableVersion','8.0.2-release.1','2016-12-18 12:41:39','2020-10-15 06:39:17'),
(246,'UpdaterLatestSupportAndUpdatesVersion','8.5.1-release.1','2016-12-18 12:41:39','2022-06-22 13:22:19'),
(247,'DailyCronExecutionHour','09','2016-12-18 12:41:39','2022-09-05 04:39:04'),
(248,'lastDailyCronInvocationTime','2025-11-30 09:00:04','2016-12-18 12:41:39','2025-11-30 05:30:04'),
(249,'ModuleDebugMode','on','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(250,'FTPPassiveMode','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(251,'SpotlightTLDs','.com,.ir,.net,.co,.org,.xyz','2017-01-28 06:10:40','2022-11-19 10:08:36'),
(252,'UpdateMaintenanceMessage','','2017-03-23 07:10:40','2017-03-23 07:10:40'),
(253,'UpdateTempPath','/home/centralhost/public_html/cl.keloncloud.com/whmcsUpdate','2017-03-26 04:22:23','2017-03-26 04:22:23'),
(254,'ActiveBackupSystems','','2017-12-23 21:49:55','2017-12-23 21:49:55'),
(255,'UriRewriteAutoManage','1','2017-08-02 22:30:11','2020-10-26 08:30:29'),
(256,'RouteUriPathMode','rewrite','2017-08-02 22:30:12','2022-02-25 18:40:29'),
(257,'ReversalChangeInvoiceStatus','1','2017-08-02 22:30:12','2017-08-02 22:30:12'),
(258,'ReversalChangeDueDates','1','2017-08-02 22:30:12','2017-08-02 22:30:12'),
(259,'MarketConnectEmail','mail.centralhost@gmail.com','2017-08-02 22:32:47','2017-08-02 22:32:47'),
(260,'MarketConnectApiToken','DIehlu4SSO4iVF+a6CDY+SGxSI2b6IP6TIzF2Wgyb5lPgdv/vEhGEPyf4DMkqFyfXmCeNOdkJctvKUVnIP88FE7DNc/xDf/b3vn4XkYKiyOHhbxVHfymi4rZulf7cUF5j11TzdOr2wHzRFcnaOpKGqzeguRFyZ8ZiEbJiX/nPB2jQq+ZqMqD2fU4UVCToNzTMKvrtvEGUWt1pAxAjrxwKAE/r6sye4W3yE1GqjwJuZO5S5eHQW6VwSW72CPbpgJzm0wna9AA34GaKWTc5m+rIlg93Nfh1ZroO7kRlilGyQqrAHMNnGPkJxpnZMlwsYEKu+egDHawxkZF3VUYCr31DsC9aFYtAk5S6hehZR1wOnsJQi/WOgOqs8+ldBjZjRsBTZyqRyc4RwPu6iYEMJn9VIixqlp6JSBi0WS8FxdYrMgKi09nA/eUxB032K3gQkPX/Y8BIkGC5PF+JRWn0X8cOAxttffW/98p8XRhQXCdLN4Jg94JOSJCzgzQmVag/aegWn7Bu/YphSBZ8/8iQIpnHeVYVyTxaU7a9rT+nI2iP0hW8pS74Tjq4UUNneZN5P7ds3URGpjOuxl3jglwv4eTkciayCi81rnuq6kMMnABqHfhfLgVLkiHeMpkmZIXjFTcglf029yaRL2i0IvKZvKJXQvLl5JfR+KtLgspRqADUcwJkG+vOvNDG5kAHc+3uahgCG7rj9yndRMxQ+eMucMaE785E+jtBGWm6/SEgS00u8GWe2dDaytw4yp0ampqCBxDZUFyehIgCn8q5rddjHA0pUil3rffk9g1Y8NEzF2UrSCBz9nETxA3qvtB/pzL7WfWas+g+WQ9lqZcz7SJ6MI2zinjBMQetjFmnG84vn9VELncwzqT/Y+iLlm0ikCVl29ewm+YietATjZditxcMFFynOIWVyYa/DrnLhwX4TPhz+nUj5tT1zAJmqCNP276kHQy7gMvggMFbemHNjZ7kJRpI7T/EQM7T5G9qpWqAp7MQgJl94CPQiP3ge0KwO9fwufRmvc8lAFOZKkYyT9YuAhNGhTNZvf/yy8NDbBTiSQb7rRLWYQUqpkNc353/MQIqYoF00bfrHiaxYwhmk2MXL52WPK0X7l7oWD+rDVFIR78Ha+OHSbd1/4XATP0VC/ymdz3gfDLODkS/8kkeDJciDHJEIYPS8GNGOFCcKia0514wx/2WcZUQyEI/la2Pu81i5476ehFtKOvfrrSvYXDMJk6b9wlzbTaf99qhrr/FX9mHR1fIt27JSlH3tiObs4DJ1iSoF12AqHNqKabgcRzKAjmeCQyGQvMIWQy4UAaD+Q/ElTyxeyRwBIiew7h0RFlgyQANo1j1ztFdNAjhREsUl7OEcL7HSF3bhzhnjQbbVYAUoxN8qJrE0ywCvt+tofPGdedappo9SbbdvkJMp4BYFoIVZdbw5/jKgaajjEJbPscNp6xtlmhkxPR8Q==','2017-08-02 22:32:47','2017-08-02 22:32:47'),
(261,'MarketConnectBalance','{\"balance\":\"0.00\",\"updated\":\"2023-02-22 17:34:43\"}','2017-08-02 22:32:47','2023-02-22 14:04:43'),
(262,'FeatureHighlightsByAdmin','{\"1\":\"8.5.0-rc.1\",\"3\":\"7.4.0-alpha.1\",\"4\":\"8.5.0-rc.1\"}','2017-08-02 22:37:22','2022-08-25 08:09:03'),
(263,'LogErrors','on','2017-08-02 22:39:44','2020-05-27 11:37:46'),
(264,'UriModeOverride','0','2017-08-02 22:43:57','2022-02-25 18:40:29'),
(265,'br_dropbox_backup_key','128c5bc2a52b7403e999e7c7842b5317c3399744','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(266,'resellers_center_localkey','9tjI2kDNhJzM5IWM5gTNyADMxQTNzImNlRTYyYTMhBDZwEmNyMDN5cDNwUTMiojM0ozc7Iiblt2b0t2Y\nlh2YioDMxozc7IyNwkDM3EDMyIiO4ozc7ISZ0FGZrNWZoNmI6kjOztjI0UTY4IjNyU2MhRTYlNzYkVzY\nxkTOlFGZ3UTZ3M2M4cjI6IzM6M3Oig2chhWNk1mI6cjOztjI9U2cuV2YpxEI2VGRiojMxozc7Iycu9Wa\n0B3bnlmZu92YiozMxozc7IiclRnblN0cyVGbsV2clJ1Lz52bkRWYvMXZsVHZv12Lt92YuQ3cvhWLsFmc\n05WZj5CduVWasN2Ls1Gdo91YpxmY1B3L0N3boxWYyRnblN2Ll12bo9iI6QDO6M3OikncvR3YlJXakRWa\nsFmdioDNxozc7ISOx4iN1EjL0cjL3MTMiozMxozc7ICcpRWasFmdiozN6M3Oi02bj5Cdz9GatwWYyRnb\nlNmL05WZpx2Yuc3d3xSbvNmL0N3bo1CbhJHduV2YuQnbllGbjJiOxUjOztjIulWYt9GZklGbhZnI6ETM\n6M3OikHbsFWdu5WQioDO6M3OiUGbjl3Yn5WasxWaiJiOyEjOztjI0ETL5ATL3EDMyIiOwEjOztjIlRXY\nkVWdkRHel5mI6ETM6M3OicDMtkDMtcTMwIjI6ATM6M3OiUGdhR2ZlJnI6cjOztjITNUTIdFIy9mRgIXZ\n05WZDBycyVGbsV2clJlI6YjM6M3OiUWbh5GdjVHZvJHcioTMxozc7IiMzIiOyozc7ICZpR3Y1R2byBnI\n6kjOztjI5EDN5QjI6UjOztjIklWZjlmdyV2cioTO6M3Oi02bj5CbpFWbnBEdz9GasFmc05WZj5CbpFWb\niojNyozc7ICbpFWblJiO1ozc7ICdz9GagwWYyRnblNmI6ITM6M3OiUWbh5WeuFGct92YioTMxozc7ISa\nodWZkF2cgQWZtFGaiozMxozc7ISZtFmbkVmclR3cpdWZyJiO0EjOztjIlZXa0NWQiojN6M3OiMXd0FGd\nzJiO2ozc7pzNxoTY88e12c1159470d7ae2d2253c8a6e43dfe75c7c24d7c968bf9a895ba411e8f360','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(267,'RC_Skip_Dashboard','1','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(268,'domainLookupRegistrar','','2018-05-30 21:16:52','2018-05-30 21:30:21'),
(269,'UpdatesLastChecked','2022-08-11 01:08:42','2018-07-06 19:30:06','2022-08-11 05:08:42'),
(270,'UpdaterUpdateToken','vLY9r0gL7npsRY5UxuORe4rVNb6TPfMHP6CFR1OdMnraY17OXnL88bZfjbfN1olE','2018-07-21 22:23:27','2022-02-25 18:48:36'),
(271,'DomainExpirationFeeHandling','existing','2018-07-24 17:24:21','2018-07-24 17:24:21'),
(272,'TaxPerLineItem','0','2018-07-24 17:24:21','2022-08-23 02:03:12'),
(273,'AdminUserNamesWithSpaces','','2018-07-24 17:24:21','2018-07-31 16:35:25'),
(274,'DisableDomainGraceAndRedemptionFees','0','2018-07-24 17:42:37','2018-07-24 17:42:37'),
(275,'AutoGeneratedPasswordFormat','legacy','2018-07-24 17:42:37','2018-07-31 15:42:29'),
(276,'EmailMarketingRequireOptIn','0','2018-07-24 17:42:37','2018-07-24 17:42:37'),
(277,'DRAutoDeleteInactiveClients','0','2019-04-03 06:42:17','2019-04-03 06:42:17'),
(278,'DRAutoDeleteInactiveClientsMonths','0','2019-04-03 06:42:17','2019-04-03 06:42:17'),
(279,'CaptchaForms','{\"checkoutCompletion\":false,\"domainChecker\":true,\"registration\":true,\"contactUs\":true,\"submitTicket\":false,\"login\":true}','2019-05-18 14:32:07','2019-08-23 05:28:59'),
(280,'EnableSafeInclude','1','2019-05-18 14:32:07','2019-05-18 14:32:07'),
(281,'EulaAgreementAccepted','{\"hash\":\"c0ac9edca53ea8940bc7d9f26034acf9\",\"date\":\"2022-08-11\",\"admin\":\"1:admin\"}','2019-05-18 14:32:09','2022-08-11 13:47:09'),
(284,'DomainStatusSyncFrequency','0','2019-10-19 09:34:39','2019-10-19 09:34:39'),
(283,'MarketConnectDismissedPromos','{\"1\":\"8.5.1-release.1\"}','2019-08-12 05:39:19','2022-08-13 11:43:55'),
(286,'PruneTicketAttachmentsMonths','0','2020-02-26 09:38:57','2020-02-26 09:38:57'),
(289,'AutoNumberingResetMonth','2020-2','2020-02-26 09:38:58','2020-02-26 09:38:58'),
(290,'AutoPaidNumberingResetMonth','2020-2','2020-02-26 09:38:58','2020-02-26 09:38:58'),
(291,'MetricUsageCollection','1','2020-02-26 09:38:59','2020-02-26 09:38:59'),
(292,'MetricUsageInvoicing','on','2020-02-26 09:38:59','2020-02-28 09:46:32'),
(293,'CronPHPVersion','7.4.33','2020-02-26 21:30:45','2022-11-12 05:43:31'),
(294,'systemUUID','8c9bdac4-6f3f-5a9c-9eee-18c579207e9a','2020-02-26 21:30:46','2020-02-26 21:30:46'),
(295,'ComponentStatsCache','{\"info\":{\"type\":1,\"systemId\":\"8c9bdac4-6f3f-5a9c-9eee-18c579207e9a\",\"version\":\"1.0.0\"},\"data\":[{\"name\":\"UsageBilling\",\"topics\":[{\"name\":\"MetricSettings\",\"data\":[{\"key\":\"MetricUsageCollection\",\"value\":true},{\"key\":\"MetricUsageInvoicing\",\"value\":true}]},{\"name\":\"ProductMetrics\",\"data\":[]}]}],\"api\":\"1.0.0\"}','2020-02-26 21:30:46','2020-02-26 21:30:46'),
(297,'AutoUpdateInProgress','1','2020-04-13 16:59:07','2020-11-02 13:14:18'),
(296,'AutoUpdateCount','12','2020-04-13 16:59:07','2022-02-25 18:48:40'),
(298,'AutoUpdateAdminId','1','2020-04-13 16:59:07','2020-11-02 13:14:18'),
(299,'ReleaseMetadata','{\"productVersion\":\"8.4.1-release.1\",\"releaseNotesUrl\":\"https:\\/\\/docs.whmcs.com\\/Version_8.4.1_Release_Notes\",\"changeLogUrl\":\"https:\\/\\/docs.whmcs.com\\/Changelog:WHMCS_V8.4.1\"}','2020-04-13 17:04:39','2022-02-25 18:52:32'),
(324,'SupportReopenTicketOnFailedImport','on','2022-02-13 17:05:54','2022-02-17 17:34:31'),
(301,'AutoUpdateCountSuccess','5','2020-04-13 17:04:42','2020-10-26 08:25:52'),
(302,'DisableClientEmailPreferences','','2020-04-28 08:21:45','2020-04-28 08:21:45'),
(303,'UpdaterLTS','{\"Active\":[\"8.0\"],\"LTS\":[\"7.10\",\"7.9\"]}','2020-05-27 11:42:16','2020-09-30 16:41:18'),
(304,'lastCronInvocationTime','2025-12-01 04:40:03','2020-10-06 05:30:25','2025-12-01 01:10:03'),
(305,'MailConfig','Dcg81ojo01RTmYtiHZ98ibhoGIKE/DnlK1tzb3Ss03mBe16rCLswVd4D9RD6QdmxNMAXcLh4l+MNohttb1TjPuPWGc7koA9EtgCDT996s1u0u9thEfrRbbl2twU7e+IpAVBZdsgFSiGHTPFmRKGgRmKbMKG9c592lIA4lT98Tnx38Aku2IL4IN3APX9qNj1Qw72wofCg8YHf569/OAT/qfllc6YzrKHAju4JT1rcVgW4Xgjn2WWqwSfBU63SncJnjscFwU3GryL5rwFPfFnTSooOokd2RCaglzmeIeAMP/7ZHpc4wpEM/RadSr2wOYBYQy8zspVXjS4UkFRlrNGYz+2cOSRzxvYo8DDwgZIxwOhyffFzZ9S30PNJ93m2MCgnzId+//+LZRjyFN+uoC1npx7RNU9AcqUv89VeqUOvi3vpbpjFcb/K5aXdXjT6Db1tkMO4jNxJ31UFB5x8OPcQH3SG9d5wplr0RbdueibvW5FMkCjZVNT463ztB+G+l913OPNp0/ch+tHGNNOsSB+CAy1GOiU6GIV5iMICYz7JqAa4bXU=','2020-10-06 05:30:25','2022-11-09 08:08:52'),
(306,'LastUpgradeTimestamp','1660225629','2020-10-06 05:30:26','2022-08-11 13:47:09'),
(307,'DisableClientAreaUserMgmt','on','2020-10-06 05:32:47','2020-10-15 09:38:04'),
(308,'cronTimeZone','Asia/Tehran','2020-10-06 05:35:02','2025-07-18 10:25:03'),
(309,'lastDailyCronEndTime','2025-11-30 09:01:39','2020-10-06 21:31:20','2025-11-30 05:31:39'),
(310,'TaxBillableItems','on','2021-01-23 09:33:28','2022-08-23 01:58:49'),
(311,'TaxCustomInvoices','on','2021-01-23 09:33:28','2022-08-23 01:58:49'),
(312,'TaxVATEnabled','1','2021-01-23 09:33:28','2022-08-23 01:57:55'),
(313,'TaxEUTaxValidation','','2021-01-23 09:33:28','2021-01-23 09:33:28'),
(314,'TaxEUHomeCountry','AT','2021-01-23 09:33:28','2022-08-23 01:57:55'),
(315,'TaxEUTaxExempt','','2021-01-23 09:33:28','2021-01-23 09:33:28'),
(316,'TaxEUHomeCountryNoExempt','','2021-01-23 09:33:28','2021-01-23 09:33:28'),
(317,'TaxCustomInvoiceNumbering','','2021-01-23 09:33:28','2021-01-23 09:33:28'),
(318,'TaxCustomInvoiceNumberFormat','{NUMBER}','2021-01-23 09:33:28','2021-01-23 09:33:28'),
(319,'TaxAutoResetNumbering','','2021-01-23 09:33:28','2021-01-23 09:33:28'),
(320,'TaxAutoResetPaidNumbering','','2021-01-23 09:33:28','2021-01-23 09:33:28'),
(321,'TaxSetInvoiceDateOnPayment','1','2021-01-23 09:33:28','2022-08-23 02:41:37'),
(322,'TaxCode','','2021-01-23 09:33:28','2021-01-23 09:33:28'),
(323,'TaxIDDisabled','1','2021-01-23 09:33:28','2022-08-23 02:46:30'),
(325,'LandingPages','{\"wptk\":{\"landing\":{\"2025-10-31\":0,\"2025-11-01\":0,\"2025-11-02\":0,\"2025-11-03\":0,\"2025-11-04\":0,\"2025-11-05\":0,\"2025-11-06\":0,\"2025-11-07\":0,\"2025-11-08\":0,\"2025-11-09\":0,\"2025-11-10\":0,\"2025-11-11\":0,\"2025-11-12\":0,\"2025-11-13\":0,\"2025-11-14\":0,\"2025-11-15\":0,\"2025-11-16\":0,\"2025-11-17\":0,\"2025-11-18\":0,\"2025-11-19\":0,\"2025-11-20\":0,\"2025-11-21\":0,\"2025-11-22\":0,\"2025-11-23\":0,\"2025-11-24\":0,\"2025-11-25\":0,\"2025-11-26\":0,\"2025-11-27\":0,\"2025-11-28\":0,\"2025-11-29\":0,\"2025-11-30\":0,\"lifetime\":0},\"cart\":{\"2025-10-31\":0,\"2025-11-01\":0,\"2025-11-02\":0,\"2025-11-03\":0,\"2025-11-04\":0,\"2025-11-05\":0,\"2025-11-06\":0,\"2025-11-07\":0,\"2025-11-08\":0,\"2025-11-09\":0,\"2025-11-10\":0,\"2025-11-11\":0,\"2025-11-12\":0,\"2025-11-13\":0,\"2025-11-14\":0,\"2025-11-15\":0,\"2025-11-16\":0,\"2025-11-17\":0,\"2025-11-18\":0,\"2025-11-19\":0,\"2025-11-20\":0,\"2025-11-21\":0,\"2025-11-22\":0,\"2025-11-23\":0,\"2025-11-24\":0,\"2025-11-25\":0,\"2025-11-26\":0,\"2025-11-27\":0,\"2025-11-28\":0,\"2025-11-29\":0,\"2025-11-30\":0,\"lifetime\":0}}}','2022-02-13 21:45:04','2025-11-30 05:31:40'),
(336,'ProductRecommendationEnable','','2022-08-11 13:47:09','2022-08-11 15:01:57'),
(337,'ProductRecommendationLocationAfterAdd','0','2022-08-11 13:47:09','2022-08-11 13:47:09'),
(338,'ProductRecommendationLocationViewCart','0','2022-08-11 13:47:09','2022-08-11 13:47:09'),
(339,'ProductRecommendationLocationCheckout','0','2022-08-11 13:47:09','2022-08-11 13:47:09'),
(326,'DisableEmailSending','','2022-02-17 17:34:31','2022-02-17 17:34:31'),
(327,'DisableRFC3834','','2022-02-17 17:34:31','2022-02-17 17:34:31'),
(328,'SupportAllowInsecureImport','','2022-02-17 17:34:31','2022-02-17 17:34:31'),
(329,'ModuleEventHandlingMode','0','2022-02-17 17:34:31','2022-02-17 17:34:31'),
(330,'SocialAccounts','[]','2022-02-17 17:34:32','2022-02-17 17:34:32'),
(348,'RSTheme-lagom2-license-data','==Qf7ISNy0yMw0yMyAjMioDMxozc7ISZ0FGRsFmbpZmI6kjOztDM6I2Oi0WZsJ2byBVZ09WblJnI6MTM\n6M3OwojY7IibvlGdhJXawhXZioDMxozc7AjOitjIn5WauJXYXRWasFmdulUZz5WZjlGbioTMyozc7EjO\nitjIkV2ajVGaDVGdv1WZyJiOzEjOztjIioDM6M3OiUGZvNWZnF2czVWbioTMxozc7IiI6AjOztjIldWY\nzNXZtJiO3ozc7IiI6AjOztjI0NWasZmbvNmcpRmI6ETM6M3OiIiOwozc7ICdjlGbm52bjBXaioDMxozc\n7IiI6AjOztjI0NWasZmbu92YulWYt9GZioTNxozc7IiI6AjOztjI5J3b0NWZylGZklGbhZnI6QTM6M3O\niIiOwozc7ICcpRWasFmdiozN6M3OiIiOwozc7IibpFWbvRGZpxWY2JiOxEjOztjIioDM6M3OiQ2boRXZ\nt9FduVWb5FGcioDNxozc7IiI6AjOztjI05Wdv1WYfdmbpJXdjVmcioTNxozc7IiI6AjOztjI05Wdv1WY\nfRnbl1WehB3X0NncpZmI6AjM6M3OiIiOwozc7ISZsNWejdmbpxGbpJmI6ITM6M3OiIiOwozc7ISZ0FGZ\nnVmciozN6M3OiIiOwozc7ISZtFmb0NWdk9mcwJiOxEjOztjIioDM6M3OiQWa0NWdk9mcwJiO5ozc7IiI\n6AjOztjIklWZjlmdyV2cioTO6M3OiIiOwozc7ICbpFWblJiO1ozc7IiI6AjOztjIl1WYulnbhBXbvNmI\n6ETM6M3OiIiOwozc7ISZtFmbkVmclR3cpdWZyJiO0EjOztjIzITLyATLzIDMyIiOwEjOztjIkV2ajVGa\nDVGdv1WZSR3chxmI6cTM6M3OiAjLw4SMioTN6M3Oi42bpNnclZnI6cjOztjIioDM6M3OiUGdhRWZ1RGd\n4VmbioTMxozc7ISZ2lGdjFkI6YjOztjIzVHdhR3cfV2cuV2YpxmI6QTM6M3OiUmdpR3YBJiO2ozc7Iyc\n1RXY0N3XlNWa2JXZzJiO0EjOztjIlZXa0NWQiojN6M3OiMXd0FGdzJiO2ozc7pDMzoTYd49f26abcdf0\n470a7f35f49cbe5a391e1a4a085d34d48ef4e657838b79728f93','2022-08-13 03:56:07','2023-02-22 20:30:02'),
(340,'ProductRecommendationLocationOrderComplete','0','2022-08-11 13:47:09','2022-08-11 13:47:09'),
(341,'ProductRecommendationCount','10','2022-08-11 13:47:09','2022-08-11 13:47:09'),
(342,'ProductRecommendationExisting','0','2022-08-11 13:47:09','2022-08-11 13:47:09'),
(343,'ProductRecommendationStyle','0','2022-08-11 13:47:09','2022-08-11 13:47:09'),
(344,'ApplyCartApi','0','2022-08-11 15:01:57','2022-08-11 15:01:57'),
(349,'RSTheme-lagom2-license','dsfsdfsdfdsf','2022-08-13 03:56:52','2022-08-13 03:56:52'),
(351,'DRAutoDeleteInactiveClientsUsers','0','2022-09-05 04:39:04','2022-09-05 04:39:04'),
(352,'FreeDomainReminders','','2022-09-05 04:39:04','2022-09-05 04:39:04'),
(353,'ModuleLogPruningEnabled','','2022-09-05 04:39:04','2022-09-05 04:39:04'),
(354,'ModuleLogRetentionDays','30','2022-09-05 04:39:04','2022-09-05 04:39:04'),
(355,'hetznercloud_localkey','==Qf7IyMy0iMw0yMyAjMioDMxozc7IyajVGajR3chxmI6kjOztjIwETLzATLzIDMyIiOwEjOztjIlRXY\\nkt2Ylh2Y0hXZuJiOzEjOztjIzIjMwMjMwIjI6gjOztjIlRXYkt2Ylh2YioTO6MXf7pDM6E2OiMnbvlGd\\nw92ZpZmbvNmI6MTM6MXf7pDM6E2OiMnbvRGZhJiO2ozc7ISZykDO5EDO2Y2N5UzMhJjYyUTM2AjZ5EmM\\n2EGOzEGZ5IiOyMjOztjIoNXYoVDZtJiO3ozc7IicvRmblZ3LkV3bsNkcl5me0VGSvMnclZnclN3LzVGb\\n1R2bt9SbvNmLkV3bsNmbvxWZr5Cbj9CZ19Gbj52bsV2avUWbvh2LioDM3ozc7ISey9GdjVmcpRGZpxWY\\n2JiO0EjOztjI54yMyIjL1EjMuMDMxIiOzEjOztjIwlGZpxWY2JiO3ozc7ISbvNmLkV3bsNmbvxWZr5Cb\\nj5yd3dHLt92YuQWdvx2Yu9GbltmLsNmI6kzM6M3Oi4Wah12bkRWasFmdioTMxozc7ISesxWY15mbBJiO\\n4ozc7ISZsNWejdmbpxGbpJmI6ITM6M3OiUDMtITMtMjMwIjI6ATM6M3OiUGdhRWZ1RGd4VmbioTMxozc\\n7ICMwoDMwoDMwASNw0iMx0iMyAjMioTOxozc7ISZ0FGZnVmciozN6M3OiM1QNh0Vgw42nidsYjK2gIXZ\\nupHdlhEIxithZLL2qi9hZDyrYjY2EmdqaDihZjY2Mu9sYfK2FmNiZrK2niNIHmthZjY2yidgZfK2ioDN\\n3ozc7ISZtFmb0NWdk9mcwJiOxEjOztjI5MjI6IjOztjIklGdjVHZvJHcioTO6M3OiADMzIiOzozc7ICZ\\npV2YpZnclNnI6kjOztjIt92YuwWah12ZAVWaodWZkF2ckVWbtFGaioDNyozc7ICbpFWblJiO1ozc7ISa\\nodWZkF2cgQWZtFGaiozMxozc7ISZtFmbkVmclR3cpdWZyJiO0EjOztjIlZXa0NWQiojN6M3OiMXd0FGd\\nzJiO2ozc7pDOxoTY200b2885ae7e66d6804b830265aab5fe1d83fe8a31d88e57615c2990e9c37fd9','0000-00-00 00:00:00','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `tblconfiguration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcontacts`
--

DROP TABLE IF EXISTS `tblcontacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcontacts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `firstname` text NOT NULL,
  `lastname` text NOT NULL,
  `companyname` text NOT NULL,
  `email` text NOT NULL,
  `address1` text NOT NULL,
  `address2` text NOT NULL,
  `city` text NOT NULL,
  `state` text NOT NULL,
  `postcode` text NOT NULL,
  `country` text NOT NULL,
  `phonenumber` text NOT NULL,
  `tax_id` varchar(128) NOT NULL DEFAULT '',
  `subaccount` int(1) NOT NULL DEFAULT 0,
  `password` text NOT NULL,
  `permissions` text NOT NULL,
  `domainemails` int(1) NOT NULL,
  `generalemails` int(1) NOT NULL,
  `invoiceemails` int(1) NOT NULL,
  `productemails` int(1) NOT NULL,
  `supportemails` int(1) NOT NULL,
  `affiliateemails` int(1) NOT NULL,
  `pwresetkey` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `pwresetexpiry` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `userid_firstname_lastname` (`userid`,`firstname`(32),`lastname`(32)),
  KEY `email` (`email`(64))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcontacts`
--

LOCK TABLES `tblcontacts` WRITE;
/*!40000 ALTER TABLE `tblcontacts` DISABLE KEYS */;
INSERT INTO `tblcontacts` (`id`, `userid`, `firstname`, `lastname`, `companyname`, `email`, `address1`, `address2`, `city`, `state`, `postcode`, `country`, `phonenumber`, `tax_id`, `subaccount`, `password`, `permissions`, `domainemails`, `generalemails`, `invoiceemails`, `productemails`, `supportemails`, `affiliateemails`, `pwresetkey`, `created_at`, `updated_at`, `pwresetexpiry`) VALUES (1,8,'centralhost','centralhost','','mail.centralhost@gmail.com','','','','','','IR','','',0,'$2y$10$n3lm6ht7fgpv9TeeQi2Fw.diivqHmr8NykCqrB4LAF4ZGyYccOzdq','',1,0,1,1,0,0,'','0000-00-00 00:00:00','0000-00-00 00:00:00','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `tblcontacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcredit`
--

DROP TABLE IF EXISTS `tblcredit`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcredit` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `clientid` int(10) NOT NULL,
  `admin_id` int(10) unsigned NOT NULL DEFAULT 0,
  `date` date NOT NULL,
  `description` text NOT NULL,
  `amount` decimal(16,2) NOT NULL,
  `relid` int(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=172 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcredit`
--

LOCK TABLES `tblcredit` WRITE;
/*!40000 ALTER TABLE `tblcredit` DISABLE KEYS */;
INSERT INTO `tblcredit` (`id`, `clientid`, `admin_id`, `date`, `description`, `amount`, `relid`) VALUES (1,11,0,'2018-06-14','Add Funds Invoice #4138',500000.00,0),
(2,11,0,'2018-06-14','Credit Applied to Invoice #4136',-500000.00,0),
(3,11,0,'2018-08-13','Add Funds Invoice #4151',500000.00,0),
(4,11,0,'2018-08-16','Credit Applied to Invoice #4153',-500000.00,0),
(5,3,0,'2018-10-10','',110000.00,0),
(6,3,0,'2018-10-28','Credit Applied to Invoice #4171',-110000.00,0),
(7,1,0,'2018-11-08','Add Funds Invoice #4176',10000.00,0),
(8,1,0,'2018-11-08','Add Funds Invoice #4183',10000.00,0),
(9,1,0,'2018-11-09','Add Funds Invoice #4185',10000.00,0),
(10,1,0,'2018-11-09','Add Funds Invoice #4186',10000.00,0),
(11,1,0,'2018-11-09','Add Funds Invoice #4187',10000.00,0),
(12,1,0,'2018-11-24','Credit Applied to Invoice #4190',0.00,0),
(13,1,0,'2018-11-26','Add Funds Invoice #4191',1000.00,0),
(14,1,0,'2018-11-26','Add Funds Invoice #4192',1000.00,0),
(15,1,0,'2018-11-27','Add Funds Invoice #4193',1000.00,0),
(16,1,0,'2018-11-27','Add Funds Invoice #4194',1000.00,0),
(17,1,0,'2019-01-15','Credit Applied to Invoice #4200',0.00,0),
(18,1,0,'2019-01-23','Credit Applied to Invoice #4203',-54000.00,0),
(19,1,0,'2019-02-27','Add Funds Invoice #4208',46990822.00,0),
(20,1,0,'2019-02-28','Add Funds Invoice #4209',5450000.00,0),
(21,1,0,'2019-03-19','Add Funds Invoice #4213',10000.00,0),
(22,1,0,'2019-03-27','Credit Applied to Invoice #4218',-5000000.00,0),
(23,1,0,'2019-05-18','Credit Applied to Invoice #4231',-100000.00,0),
(24,1,0,'2019-05-21','Add Funds Invoice #4234',3601651.00,0),
(25,1,0,'2019-05-23','Add Funds Invoice #4236',100000.00,0),
(26,1,0,'2019-05-23','Add Funds Invoice #4237',1000.00,0),
(27,1,0,'2019-05-23','Add Funds Invoice #4237',10000.00,0),
(28,1,0,'2019-05-23','Add Funds Invoice #4238',1000.00,0),
(29,1,0,'2019-05-24','Add Funds Invoice #4241',100000.00,0),
(30,14,0,'2019-05-26','',2100000.00,0),
(31,14,0,'2019-05-26','Credit Applied to Invoice #4245',-700000.00,0),
(32,14,0,'2019-05-26','Credit Applied to Invoice #4246',-700000.00,0),
(33,14,0,'2019-05-26','Credit Applied to Invoice #4247',-700000.00,0),
(34,1,0,'2019-06-02','Add Funds Invoice #4249',200000.00,0),
(35,1,0,'2019-06-02','Credit Applied to Invoice #4250',-100.00,0),
(36,1,0,'2019-06-11','Credit Applied to Invoice #4257',-100000.00,0),
(37,1,0,'2019-07-11','Credit Applied to Invoice #4267',-100000.00,0),
(38,11,0,'2019-07-16','Add Funds Invoice #4269',1000000.00,0),
(39,11,0,'2019-07-17','Add Funds Invoice #4270',1000000.00,0),
(40,1,0,'2019-08-11','Credit Applied to Invoice #4274',-2000000.00,0),
(41,11,0,'2019-08-14','',-2000000.00,0),
(42,1,0,'2019-08-20','Credit Applied to Invoice #4280',-5000000.00,0),
(43,1,0,'2019-09-11','Credit Applied to Invoice #4290',-100000.00,0),
(44,1,0,'2019-09-21','Credit Applied to Invoice #4294',-3600000.00,0),
(45,1,0,'2019-10-11','Credit Applied to Invoice #4300',-100000.00,0),
(46,1,0,'2019-11-11','Credit Applied to Invoice #4307',-100000.00,0),
(47,1,0,'2019-11-24','Credit Applied to Invoice #4311',0.00,0),
(48,1,0,'2019-11-25','Credit Applied to Invoice #4312',0.00,0),
(49,1,0,'2019-11-28','Credit Applied to Invoice #4314',-1900000.00,0),
(50,1,0,'2019-12-11','Credit Applied to Invoice #4318',-100000.00,0),
(51,1,0,'2020-01-11','Credit Applied to Invoice #4323',-100000.00,0),
(52,1,0,'2020-01-15','Credit Applied to Invoice #4324',0.00,0),
(53,1,0,'2020-01-23','Credit Applied to Invoice #4327',-3500000.00,0),
(54,1,0,'2020-01-25','Credit Applied to Invoice #4328',-900000.00,0),
(55,1,0,'2020-02-11','Credit Applied to Invoice #4333',-100000.00,0),
(56,1,0,'2020-03-11','Credit Applied to Invoice #4350',-100000.00,0),
(57,1,0,'2020-03-27','Credit Applied to Invoice #4355',-5000000.00,0),
(58,1,0,'2020-04-11','Credit Applied to Invoice #4361',-100000.00,0),
(59,8,1,'2020-04-21','بابت پرداخت بخش اول Adobe Connect',5000000.00,0),
(60,8,0,'2020-04-21','Credit Applied to Invoice #4364',-5000000.00,0),
(61,1,0,'2020-05-02','Credit Applied to Invoice #4376',-4680000.00,0),
(62,1,0,'2020-05-03','Credit Applied to Invoice #4377',-4680000.00,0),
(63,25,0,'2020-05-07','Add Funds Invoice #4379',10000000.00,0),
(64,25,0,'2020-05-09','Add Funds Invoice #4380',5400000.00,0),
(65,25,0,'2020-05-09','Credit Applied to Invoice #4375',-15400000.00,0),
(66,1,0,'2020-05-11','Credit Applied to Invoice #4381',-100000.00,0),
(67,1,0,'2020-05-27','Credit Applied to Invoice #4386',-7500000.00,0),
(68,1,0,'2020-05-28','Credit Applied to Invoice #4387',-4680000.00,0),
(69,1,0,'2020-05-30','Credit Applied to Invoice #4388',-6824373.00,0),
(70,29,0,'2020-07-11','Credit from Refund of Invoice ID 4407',2500000.00,0),
(71,29,0,'2020-07-11','Credit Applied to Invoice #4410',-2500000.00,0),
(72,1,0,'2020-09-15','Add Funds Invoice #4430',14200000.00,0),
(73,1,0,'2020-10-06','Credit Applied to Invoice #4442',-7500000.00,0),
(74,1,0,'2020-10-11','Credit Applied to Invoice #4443',-100000.00,0),
(75,1,0,'2020-11-06','Credit Applied to Invoice #4453',-6600000.00,0),
(76,1,0,'2020-11-29','Add Funds Invoice #4463',200000.00,0),
(77,1,0,'2020-12-06','Credit Applied to Invoice #4465',-200000.00,0),
(78,29,0,'2020-12-28','Add Funds Invoice #4472',4600000.00,0),
(79,29,0,'2020-12-28','Credit Applied to Invoice #4473',-2900000.00,0),
(80,29,0,'2020-12-28','Add Funds Invoice #4474',600000.00,0),
(81,29,0,'2021-01-14','Credit Applied to Invoice #4479',-2000000.00,0),
(82,29,0,'2021-01-18','Credit Applied to Invoice #4481',-300000.00,0),
(83,29,0,'2021-02-22','Add Funds Invoice #4494',2600000.00,0),
(84,29,0,'2021-02-22','Credit Applied to Invoice #4491',-2000000.00,0),
(85,29,0,'2021-02-22','Credit Applied to Invoice #4492',-300000.00,0),
(86,29,0,'2021-03-14','Credit Applied to Invoice #4499',-300000.00,0),
(87,29,0,'2021-05-26','Add Funds Invoice #4532',1000000.00,0),
(88,29,0,'2021-05-26','Credit Applied to Invoice #4526',-300000.00,0),
(89,29,0,'2021-05-26','Credit Applied to Invoice #4515',-315000.00,0),
(90,29,0,'2021-06-18','Credit Applied to Invoice #4542',-300000.00,0),
(91,29,0,'2021-06-27','Add Funds Invoice #4545',2000000.00,0),
(92,29,0,'2021-06-27','Credit Applied to Invoice #4546',-2085000.00,0),
(93,29,0,'2021-06-30','Add Funds Invoice #4544',200000.00,0),
(94,29,0,'2021-07-01','Credit Applied to Invoice #4551',-200000.00,0),
(95,29,0,'2021-07-12','Add Funds Invoice #4558',2800000.00,0),
(96,29,0,'2021-07-12','Credit Applied to Invoice #4554',-2800000.00,0),
(97,35,0,'2022-06-19','Add Funds Invoice #4645',1000.00,0),
(98,35,0,'2022-07-11','Credit Applied to Invoice #4725',-1000.00,0),
(99,60,0,'2022-10-16','Credit from Refund of Invoice ID 4781',1330000.00,0),
(101,60,1,'2022-10-17','refund',400000.00,0),
(102,60,0,'2022-10-17','Credit from Refund of Invoice ID 4781',200000.00,0),
(103,62,1,'2022-10-26','انتقال از فاکتور 46',1800000.00,0),
(104,62,0,'2022-10-29','Credit Applied to Invoice #4813',-1800000.00,0),
(105,60,0,'2022-11-08','Credit Applied to Invoice #4837',-1930000.00,0),
(106,60,0,'2022-11-09','Credit Removed from Invoice #4837',1930000.00,0),
(107,60,0,'2022-11-09','Credit Applied to Invoice #4842',-1930000.00,0),
(108,88,0,'2022-11-13','Add Funds Invoice #4867',5790000.00,0),
(109,73,0,'2022-11-15','Credit from Refund of Invoice ID 4871',1800000.00,0),
(110,73,0,'2022-11-16','Credit Applied to Invoice #4878',-1800000.00,0),
(111,73,0,'2022-11-17','Credit Removed from Invoice #4878',1800000.00,0),
(112,73,0,'2022-11-28','Credit Applied to Invoice #4947',-1800000.00,0),
(113,73,0,'2022-11-29','Add Funds Invoice #4951',2200000.00,0),
(114,73,0,'2022-11-29','Credit Applied to Invoice #4947',-190000.00,0),
(115,73,0,'2022-11-29','Credit Applied to Invoice #4952',-1990000.00,0),
(116,75,0,'2022-12-04','Add Funds Invoice #4990',9000000.00,0),
(117,75,0,'2022-12-04','Credit Applied to Invoice #4988',-3600000.00,0),
(118,75,0,'2022-12-04','Credit Applied to Invoice #4989',-5000000.00,0),
(119,88,0,'2022-12-06','Credit Applied to Invoice #5000',-3790000.00,0),
(120,73,0,'2022-12-09','Credit Applied to Invoice #5012',-20000.00,0),
(121,75,0,'2022-12-10','Credit Applied to Invoice #5024',-400000.00,0),
(122,108,0,'2022-12-10','Credit from Refund of Invoice ID 4994',1800000.00,0),
(123,117,0,'2022-12-11','Credit from Refund of Invoice ID 5035',110000.00,0),
(124,117,0,'2022-12-11','Credit Applied to Invoice #5039',-110000.00,0),
(125,123,0,'2022-12-14','Credit from Refund of Invoice ID 5092',2650000.00,0),
(126,123,0,'2022-12-15','Credit Applied to Invoice #5094',-2650000.00,0),
(127,123,0,'2022-12-16','Credit Removed from Invoice #5094',2650000.00,0),
(128,50,0,'2022-12-16','Credit from Refund of Invoice ID 5015',4000000.00,0),
(129,123,0,'2022-12-17','Credit Applied to Invoice #5104',-1800000.00,0),
(130,80,0,'2022-12-18','Add Funds Invoice #5110',8000000.00,0),
(131,125,0,'2022-12-18','Credit from Refund of Invoice ID 5059',1680000.00,0),
(132,125,0,'2022-12-19','Credit Applied to Invoice #5116',-1680000.00,0),
(133,95,0,'2022-12-20','Credit from Refund of Invoice ID 5056',3040000.00,0),
(134,95,0,'2022-12-20','Credit Applied to Invoice #5128',-3040000.00,0),
(135,108,0,'2022-12-22','Credit Applied to Invoice #5150',-1800000.00,0),
(136,80,0,'2023-01-01','Credit Applied to Invoice #5217',-8000000.00,0),
(137,50,0,'2023-01-02','Credit Applied to Invoice #5225',-4000000.00,0),
(138,170,0,'2023-01-02','Credit from Refund of Invoice ID 5227',17000000.00,0),
(139,170,0,'2023-01-02','Credit Applied to Invoice #5228',-6500000.00,0),
(140,123,0,'2023-01-05','Credit Applied to Invoice #5264',-850000.00,0),
(141,88,0,'2023-01-06','Credit Applied to Invoice #5272',-2000000.00,0),
(142,125,0,'2023-01-06','Add Funds Invoice #5278',3870000.00,0),
(143,125,0,'2023-01-06','Credit Applied to Invoice #5244',-270000.00,0),
(144,125,0,'2023-01-06','Credit Applied to Invoice #5276',-1800000.00,0),
(145,125,0,'2023-01-06','Credit Applied to Invoice #5261',-1800000.00,0),
(146,88,0,'2023-01-14','Add Funds Invoice #5343',2450000.00,0),
(147,88,0,'2023-01-14','Add Funds Invoice #5344',2000000.00,0),
(148,160,0,'2023-01-17','Credit from Refund of Invoice ID 5345',1800000.00,0),
(149,160,0,'2023-01-17','Credit from Refund of Invoice ID 5202',1220000.00,0),
(150,160,0,'2023-01-17','Credit Applied to Invoice #5370',-3020000.00,0),
(151,160,0,'2023-01-19','Credit Removed from Invoice #5370',3020000.00,0),
(152,214,0,'2023-01-19','Add Funds Invoice #5384',2650000.00,0),
(153,112,0,'2023-01-20','Add Funds Invoice #5393',90000000.00,0),
(154,112,0,'2023-01-20','Credit Applied to Invoice #5394',-90000000.00,0),
(155,160,0,'2023-01-22','Credit Applied to Invoice #5410',-3020000.00,0),
(156,214,1,'2023-01-23','server finlad',-2650000.00,0),
(157,170,0,'2023-01-26','Credit Applied to Invoice #5436',-6500000.00,0),
(158,88,0,'2023-01-29','Add Funds Invoice #5483',700000.00,0),
(159,138,0,'2023-01-30','Credit from Refund of Invoice ID 5326',1800000.00,0),
(160,138,0,'2023-01-30','Credit Applied to Invoice #5494',-1800000.00,0),
(161,239,0,'2023-01-31','Credit from Refund of Invoice ID 5507',7004400.00,0),
(162,239,0,'2023-01-31','Credit Applied to Invoice #5509',-7004400.00,0),
(163,120,0,'2023-02-03','Credit from Refund of Invoice ID 5543',240000.00,0),
(164,88,0,'2023-02-06','Credit Applied to Invoice #5563',-5150000.00,0),
(165,204,0,'2023-02-19','Credit from Refund of Invoice ID 5595',3517800.00,0),
(166,204,0,'2023-02-19','Credit Applied to Invoice #5647',-3517800.00,0),
(167,63,0,'2023-02-21','Add Funds Invoice #5660',11000000.00,0),
(168,63,0,'2023-02-21','Credit Applied to Invoice #5579',-3517800.00,0),
(169,63,0,'2023-02-21','Credit Applied to Invoice #5611',-3517800.00,0),
(170,63,0,'2023-02-21','Credit Applied to Invoice #5633',-3517800.00,0),
(171,170,0,'2023-02-23','Credit Applied to Invoice #5682',-4000000.00,0);
/*!40000 ALTER TABLE `tblcredit` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcreditcards`
--

DROP TABLE IF EXISTS `tblcreditcards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcreditcards` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pay_method_id` int(11) NOT NULL DEFAULT 0,
  `card_type` varchar(255) NOT NULL DEFAULT '',
  `last_four` varchar(255) NOT NULL DEFAULT '',
  `expiry_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `card_data` blob NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `tblcreditcards_pay_method_id` (`pay_method_id`),
  KEY `tblcreditcards_last_four` (`last_four`(4))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcreditcards`
--

LOCK TABLES `tblcreditcards` WRITE;
/*!40000 ALTER TABLE `tblcreditcards` DISABLE KEYS */;
/*!40000 ALTER TABLE `tblcreditcards` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcurrencies`
--

DROP TABLE IF EXISTS `tblcurrencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcurrencies` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `code` text NOT NULL,
  `prefix` text NOT NULL,
  `suffix` text NOT NULL,
  `format` int(1) NOT NULL,
  `rate` decimal(10,5) NOT NULL DEFAULT 1.00000,
  `default` int(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcurrencies`
--

LOCK TABLES `tblcurrencies` WRITE;
/*!40000 ALTER TABLE `tblcurrencies` DISABLE KEYS */;
INSERT INTO `tblcurrencies` (`id`, `code`, `prefix`, `suffix`, `format`, `rate`, `default`) VALUES (1,'IRR','ریال','',4,1.00000,1);
/*!40000 ALTER TABLE `tblcurrencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcustomfields`
--

DROP TABLE IF EXISTS `tblcustomfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcustomfields` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` text NOT NULL,
  `relid` int(10) NOT NULL DEFAULT 0,
  `fieldname` text NOT NULL,
  `fieldtype` text NOT NULL,
  `description` text NOT NULL,
  `fieldoptions` text NOT NULL,
  `regexpr` text NOT NULL,
  `adminonly` text NOT NULL,
  `required` text NOT NULL,
  `showorder` text NOT NULL,
  `showinvoice` text NOT NULL,
  `sortorder` int(10) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `serviceid` (`relid`)
) ENGINE=MyISAM AUTO_INCREMENT=266 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcustomfields`
--

LOCK TABLES `tblcustomfields` WRITE;
/*!40000 ALTER TABLE `tblcustomfields` DISABLE KEYS */;
INSERT INTO `tblcustomfields` (`id`, `type`, `relid`, `fieldname`, `fieldtype`, `description`, `fieldoptions`, `regexpr`, `adminonly`, `required`, `showorder`, `showinvoice`, `sortorder`, `created_at`, `updated_at`) VALUES (1,'support',1,'زبان برنامه نویسی','text','زبان برنامه نویسی سایت مورد نظر خود را اعلام نمایید','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(2,'support',1,'بودجه مورد نظر','text','بودجه مورد نظر خود را اعلام نمایید','','','','','','',1,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(3,'client',0,'شماره موبایل','text','mobile','mobile','','','on','on','',10,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(4,'product',10,'زبان مورد نظر برنامه نویسی ','text','','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(5,'product',10,'بودجه موردنظر : ','text','','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(6,'product',10,'نمونه قالبهای سایت مورد نظر','textarea','','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(71,'product',192,'سیستم عامل دلخواه','text','در صورتی که سیستم عامل مد نظر شما در لیست موجود نبود نام سیستم عامل خود را وارد نمایید','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(72,'product',193,'سیستم عامل مورد نظر','dropdown','',',windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(73,'product',193,'سیستم عامل دلخواه','text','در صورتی که سیستم عامل مد نظر شما در لیست موجود نبود نام سیستم عامل خود را وارد نمایید','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(226,'product',389,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(16,'product',19,'نوع سیستم عامل:','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(17,'product',19,'IP سرور :','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(18,'product',20,'نوع سیستم عامل:','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(19,'product',20,'IP سرور :','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(20,'product',21,'IP سرور :','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(21,'product',21,'نوع سیستم عامل:','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(224,'product',388,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(223,'product',387,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(225,'product',388,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(36,'product',49,'IP سرور : ','text','','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(37,'product',49,'Host Name:','text','','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(221,'product',268,'vps_uuid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(222,'product',387,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(220,'product',322,'نمونه قالبهای سایت مورد نظر','textarea','','','','','on','on','on',0,'2023-01-20 12:29:58','2023-01-20 12:29:58'),
(133,'product',269,'Operating System | سیستم عامل','text','','انتخاب کنید,windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(129,'product',266,'vpsid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(130,'product',267,'vpsid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(131,'product',268,'vpsid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(132,'product',269,'vpsid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(45,'product',61,'دامنه خود را وارد نمایید:','text','دامنه ای که قصد صدوره گواهینامه را بر روی آن دارید','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(47,'product',63,'CSR :','textarea','','','','','on','on','',1,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(56,'product',153,'دامنه خود را وارد نمایید:','text','دامنه ای که قصد صدوره گواهینامه را بر روی آن دارید','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(49,'product',65,'کلمات کلیدی خود را هر کدام در یک سطر وارد نمایید :','textarea','','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(70,'product',192,'سیستم عامل مورد نظر','dropdown','',',windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(52,'product',0,'Token Code','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(54,'product',61,'CSR :','textarea','','','','','','on','on',1,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(55,'product',63,'لطفا دامنه خود را وارد نمایید : ','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(57,'product',153,'CSR :','textarea','','','','','','on','on',1,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(58,'product',154,'دامنه خود را وارد نمایید:','text','دامنه ای که قصد صدوره گواهینامه را بر روی آن دارید','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(59,'product',154,'CSR :','textarea','','','','','','on','on',1,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(60,'product',155,'CSR :','textarea','','','','','on','on','',1,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(61,'product',155,'لطفا دامنه خود را وارد نمایید : ','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(62,'product',61,'private Key:','textarea','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(63,'product',61,'crt:','textarea','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(64,'client',0,'آیا مایل به دریافت پیامک هستید؟','tickbox','','بله','','on','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(125,'product',265,'vpsid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(126,'product',265,'OS','dropdown','','centos-7.9-x86_64,centos-8-x86_64,debian-10-x86_64,mikrotik-custom,ubuntu-18.04-x86_64,ubuntu-20.04-x86_64,ubuntu-22.04-x86_64,windows2016','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(227,'product',389,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(127,'product',265,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(214,'product',265,'vps_uuid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(74,'product',194,'سیستم عامل مورد نظر','dropdown','',',windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(75,'product',194,'سیستم عامل دلخواه','text','در صورتی که سیستم عامل مد نظر شما در لیست موجود نبود نام سیستم عامل خود را وارد نمایید','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(76,'product',206,'IP خود را وارد نمایید:','text','دامنه ای که قصد صدوره گواهینامه را بر روی آن دارید','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(77,'product',206,'CSR :','textarea','','','','','','on','on',1,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(78,'product',206,'private Key:','textarea','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(79,'product',206,'crt:','textarea','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(80,'product',208,'سیستم عامل مورد نظر','dropdown','',',windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(81,'product',208,'سیستم عامل دلخواه','text','در صورتی که سیستم عامل مد نظر شما در لیست موجود نبود نام سیستم عامل خود را وارد نمایید','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(82,'product',8,'domain :','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(83,'product',8,'control panel user name:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(84,'product',8,'control panel password:','password','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(85,'product',3,'domain :','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(86,'product',7,'domain :','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(87,'product',4,'domain :','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(88,'product',6,'domain :','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(89,'product',5,'domain :','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(90,'product',3,'control panel user name:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(91,'product',7,'control panel user name:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(92,'product',4,'control panel user name:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(93,'product',6,'control panel user name:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(94,'product',5,'control panel user name:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(95,'product',3,'control panel password:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(96,'product',7,'control panel password:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(97,'product',4,'control panel password:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(98,'product',6,'control panel password:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(99,'product',5,'control panel password:','text','','','','','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(100,'product',189,'site_description','textarea','{      &quot;countofsite&quot;: &quot;10&quot;,   &quot;storage&quot;: &quot;1GB&quot;,   &quot;x&quot;: &quot;XXXXXXX&quot;,   &quot;x1&quot;: &quot;XXXXXXX&quot;,   &quot;x2&quot;: &quot;XXXXXXX&quot;,   &quot;x3&quot;: &quot;XXXXXXX&quot;,   &quot;x64&quot;: &quot;XXXXXXX&quot;,   &quot;x5&quot;: &quot;XXXXXXX&quot;,   &quot;x6&quot;: &quot;XXXXXXX&quot;             }','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(219,'product',322,'بودجه موردنظر : ','text','','','','','on','on','on',0,'2023-01-20 12:29:58','2023-01-20 12:29:58'),
(218,'product',322,'زبان مورد نظر برنامه نویسی ','text','','','','','on','on','on',0,'2023-01-20 12:29:58','2023-01-20 12:29:58'),
(105,'product',213,'نوع سیستم عامل:','text','','','','','on','on','',0,'2022-02-23 09:15:25','2022-02-23 09:15:25'),
(106,'product',213,'IP سرور :','text','','','','','on','on','',0,'2022-02-23 09:15:25','2022-02-23 09:15:25'),
(107,'product',214,'IP سرور :','text','','','','','on','on','',0,'2022-02-23 09:17:42','2022-02-23 09:17:42'),
(108,'product',214,'نوع سیستم عامل:','text','','','','','on','on','',0,'2022-02-23 09:17:42','2022-02-23 09:17:42'),
(109,'product',215,'نوع سیستم عامل:','text','','','','','on','on','',0,'2022-02-23 09:21:00','2022-02-23 09:21:00'),
(110,'product',215,'IP سرور :','text','','','','','on','on','',0,'2022-02-23 09:21:00','2022-02-23 09:21:00'),
(111,'product',20,'پورت sSH','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(112,'product',20,'root password :','password','','','','','on','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(113,'product',21,'پورت SSH','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(114,'product',21,'root password','password','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(115,'product',214,'remote port','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(116,'product',214,'administrator password','password','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(117,'product',215,'remote port','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(118,'product',215,'administrator password','password','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(119,'product',19,'ssh port','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(120,'product',19,'ssh password','password','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(121,'product',213,'ssh port','text','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(122,'product',213,'root password','password','','','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(159,'product',294,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(134,'product',266,'Operating System | سیستم عامل','dropdown','','انتخاب کنید,windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(135,'product',267,'Operating System | سیستم عامل','dropdown','','انتخاب کنید,windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(136,'product',268,'Operating System | سیستم عامل','dropdown','','انتخاب کنید,windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(137,'product',269,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(138,'product',266,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(139,'product',267,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(140,'product',268,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(216,'product',267,'vps_uuid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(217,'product',269,'vps_uuid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(215,'product',266,'vps_uuid','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(160,'product',294,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(145,'product',270,'ssh_key|SSH Public Key','textarea','چنانچه قصد لاگین کردن بدون پسورد و از طریق کلید خصوصی ssh تان را دارید در این بخش وارد نمایید','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(229,'product',381,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(230,'product',382,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(231,'product',382,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(232,'product',383,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(149,'product',274,'OS | سیستم عامل','dropdown','',',windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(233,'product',383,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(228,'product',381,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(152,'product',270,'user_data|Custom Script','textarea','چنانچه نیاز دارید تا در حین بوت شدن سیستم عامل ، اسکریپتی ران شود ، وارد نمایید ( توجه نمایید این فیلد به به 32 kb محدود شده است )','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(234,'product',390,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(154,'product',274,'موقعیت سرور','dropdown','','آلمان,آمریکا,فنلاند','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(155,'product',192,'موقعیت سرور','dropdown','','آلمان,آمریکا,فنلاند','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(156,'product',208,'موقعیت سرور','dropdown','','آلمان,آمریکا,فنلاند','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(157,'product',193,'موقعیت سرور','dropdown','','آلمان,آمریکا,فنلاند','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(158,'product',194,'موقعیت سرور','dropdown','','آلمان,فنلاند,آمریکا','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(161,'product',295,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(162,'product',295,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(163,'product',296,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(164,'product',296,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(165,'product',297,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(166,'product',297,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(167,'product',298,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(168,'product',298,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(169,'product',299,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(170,'product',299,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(171,'product',300,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(172,'product',300,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(173,'product',301,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(174,'product',301,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(175,'product',302,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(176,'product',302,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(177,'product',303,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(178,'product',303,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(179,'product',304,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(180,'product',304,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(181,'product',305,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(182,'product',305,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(183,'product',306,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(184,'product',306,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(185,'product',307,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(186,'product',307,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(187,'product',308,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(188,'product',308,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(189,'product',309,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(190,'product',309,'IP','text','','','/^\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\z/','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(191,'product',310,'licenseId','text','','','','on','','','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(192,'product',310,'domain','text','','','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(193,'product',311,'wordpress_theme','dropdown','قالب انتخابی','wptheme,wptheme2,wptheme3,wptheme4','','','on','on','on',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(199,'product',271,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(198,'product',271,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(235,'product',390,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(200,'product',272,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(201,'product',272,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(202,'product',273,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(203,'product',273,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(204,'product',274,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(205,'product',274,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(206,'product',192,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(207,'product',192,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(208,'product',208,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(209,'product',208,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(210,'product',193,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(211,'product',193,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(212,'product',194,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(213,'product',194,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(236,'product',391,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(237,'product',391,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(238,'product',392,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(239,'product',392,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(240,'product',393,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(241,'product',393,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(242,'product',394,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(243,'product',394,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(244,'product',395,'ssh_key|SSH Public Key','textarea','If you wanted to login into the Cloud VM without password, then you need to enter your public key generated from OpenSSH or ssh-keygen (e.g: ssh-rsa)','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(245,'product',395,'user_data|Custom Script','textarea','Cloud-Init user data to use during server creation. This field is limited to 32KiB','','','','','on','',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(246,'product',411,'vpsid','text','','','','on','','','',0,'2023-03-10 09:43:54','2023-03-10 09:43:54'),
(247,'product',411,'OS','dropdown','','centos-7.9-x86_64,centos-8-x86_64,debian-10-x86_64,mikrotik-custom,ubuntu-18.04-x86_64,ubuntu-20.04-x86_64,ubuntu-22.04-x86_64,windows2016','','','on','on','on',0,'2023-03-10 09:43:54','2023-03-10 09:43:54'),
(248,'product',411,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'2023-03-10 09:43:54','2023-03-10 09:43:54'),
(249,'product',411,'vps_uuid','text','','','','on','','','',0,'2023-03-10 09:43:54','2023-03-10 09:43:54'),
(250,'product',412,'vpsid','text','','','','on','','','',0,'2023-03-10 09:44:41','2023-03-10 09:44:41'),
(251,'product',412,'Operating System | سیستم عامل','dropdown','','انتخاب کنید,windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','',0,'2023-03-10 09:44:41','2023-03-10 09:44:41'),
(252,'product',412,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'2023-03-10 09:44:41','2023-03-10 09:44:41'),
(253,'product',412,'vps_uuid','text','','','','on','','','',0,'2023-03-10 09:44:41','2023-03-10 09:44:41'),
(254,'product',413,'vpsid','text','','','','on','','','',0,'2023-03-10 09:45:07','2023-03-10 09:45:07'),
(255,'product',413,'Operating System | سیستم عامل','dropdown','','انتخاب کنید,windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','',0,'2023-03-10 09:45:07','2023-03-10 09:45:07'),
(256,'product',413,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'2023-03-10 09:45:07','2023-03-10 09:45:07'),
(257,'product',413,'vps_uuid','text','','','','on','','','',0,'2023-03-10 09:45:07','2023-03-10 09:45:07'),
(258,'product',414,'vpsid','text','','','','on','','','',0,'2023-03-10 09:45:43','2023-03-10 09:45:43'),
(259,'product',414,'Operating System | سیستم عامل','dropdown','','انتخاب کنید,windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','on',0,'2023-03-10 09:45:43','2023-03-10 09:45:43'),
(260,'product',414,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'2023-03-10 09:45:43','2023-03-10 09:45:43'),
(261,'product',414,'vps_uuid','text','','','','on','','','',0,'2023-03-10 09:45:43','2023-03-10 09:45:43'),
(262,'product',415,'vpsid','text','','','','on','','','',0,'2023-03-10 09:46:14','2023-03-10 09:46:14'),
(263,'product',415,'Operating System | سیستم عامل','text','','انتخاب کنید,windows-server-2022,windows-2019Server,windows-2016,WindowsServer2012R2,almalinux-8.4-x86_64,centos-8.2-x86_64,centos-7.4-x86_64,ubuntu-20.04-x86_64,ubuntu-18.04-x86_64,ubuntu-16.04-x86_64,debian-11-x86_64,debian-10-x86_64,debian-9.4-x86_64','','','on','on','',0,'2023-03-10 09:46:14','2023-03-10 09:46:14'),
(264,'product',415,'iso|ISO Disk','text','','none,ubuntu-14.04-x86_64.img,ubuntu-16.04-x86_64.img,ubuntu-18.04-x86_64.img','','on','','','',0,'2023-03-10 09:46:14','2023-03-10 09:46:14'),
(265,'product',415,'vps_uuid','text','','','','on','','','',0,'2023-03-10 09:46:14','2023-03-10 09:46:14');
/*!40000 ALTER TABLE `tblcustomfields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tblcustomfieldsvalues`
--

DROP TABLE IF EXISTS `tblcustomfieldsvalues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tblcustomfieldsvalues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fieldid` int(10) NOT NULL,
  `relid` int(10) NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `fieldid_relid` (`fieldid`,`relid`)
) ENGINE=MyISAM AUTO_INCREMENT=1805 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tblcustomfieldsvalues`
--

LOCK TABLES `tblcustomfieldsvalues` WRITE;
/*!40000 ALTER TABLE `tblcustomfieldsvalues` DISABLE KEYS */;
INSERT INTO `tblcustomfieldsvalues` (`id`, `fieldid`, `relid`, `value`, `created_at`, `updated_at`) VALUES (1,3,1,'091239523690','0000-00-00 00:00:00','2020-09-14 12:46:36'),
(2,3,4,'09121086336','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(3,3,5,'09154070600','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(4,39,27,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(80,43,20,'windows Server 2012R2','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(7,3,8,'09128685061','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(8,3,9,'09902287832','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(9,3,3,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(10,3,10,'9123843087','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(11,39,24,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(12,39,25,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(79,43,9,'Centos 6.X ','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(15,39,29,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(16,45,30,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(17,3,11,'09143929008','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(18,39,31,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(19,49,34,'دوره طراحی لباس\r\nآموزش طراحی لباس\r\nطراحی لباس','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(20,48,35,'www.roohigroup.com','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(21,50,39,'www.central-ssl.com','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(48,3,18,'09128392924','2018-06-02 12:12:24','2018-06-02 12:12:24'),
(82,66,41,'Windows server 2016','0000-00-00 00:00:00','2019-08-12 06:26:56'),
(24,48,42,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(25,50,44,'kerio-control.nssp.online','2017-08-14 22:27:26','2017-08-14 22:27:26'),
(26,48,45,'','2017-08-20 22:02:57','2017-08-20 22:02:57'),
(28,45,48,'game4pc.ir','2017-09-07 19:11:21','2017-09-07 19:11:21'),
(29,54,48,'-----BEGIN CERTIFICATE REQUEST-----\r\nMIICpDCCAYwCADBgMQswCQYDVQQGEwJJUjETMBEGA1UEAxMKZ2FtZTRwYy5pcjEP\r\nMA0GA1UEBxMGVGVocmFuMQ0wCwYDVQQKEwRub2VuMQ8wDQYDVQQIEwZUZWhyYW4x\r\nCzAJBgNVBAsTAmlyMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAretB\r\n4xw0JnEAPpXN77OToRr20OTMNBoYoXWmbkaPwffjVmyNs65sRMUiXRHNum6Y+PTC\r\nEqMh5VWlyLaGhDHkf2G9DE3YbLJnH8ImYofdkwdYIXL6JPdn5irUsj2YCyhlbMHW\r\n7f5KSyltP2qYQUnYPLcnwcIebMLo4GGLUQy/yYuhQH0E+9WWZBACLWza9MjG1Dty\r\n0Ih1g1qM/9WR4bNjQRr30kwcr/oW+9f83Hyr8Nwb3ds6grbnWFryAVibz773WylW\r\nu28/LIaXeFs0xzX26SZhYJPwH2wBif8WiiqOlWOwnVjprcf3siuB8ZEtIas3Zk9h\r\nkL4aqsYSctzXaiivRQIDAQABoAAwDQYJKoZIhvcNAQELBQADggEBAKVonKv31VJP\r\nppET0qdIYV2bh/A9U4A5cJAsIDJFS7Fg0eX6DEBkMN6BAiHqqCb0SM5z7x8xw8V5\r\n60PC9lpxvhcC454hpk6ktvZt5R5o2UjGhAt0S0Su0uPlYBOglm0ubIxumMhpQMrT\r\nsIycDrypBGMezMKjsAvUHgpJUZGoueshYSlEGcPrxhG/wsJpZYXlRCadTB+DoDgQ\r\nj6oL8indYoY78D5+L2fUZV65Isd7E5xkGudg1JaBNCddSmm2Yu4L13xj7V5cK6k2\r\n7xBpyS0oCdsWiFSIlF4QC+lYgdzV9PoRvLzdGqqv0VrDMRV479SVInMTCZj+E6SO\r\npJP4efGiRK4=\r\n-----END CERTIFICATE REQUEST-----','2017-09-07 19:11:21','2017-09-08 13:44:26'),
(30,62,48,'-----BEGIN PRIVATE KEY-----\r\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCt60HjHDQmcQA+\r\nlc3vs5OhGvbQ5Mw0GhihdaZuRo/B9+NWbI2zrmxExSJdEc26bpj49MISoyHlVaXI\r\ntoaEMeR/Yb0MTdhssmcfwiZih92TB1ghcvok92fmKtSyPZgLKGVswdbt/kpLKW0/\r\naphBSdg8tyfBwh5swujgYYtRDL/Ji6FAfQT71ZZkEAItbNr0yMbUO3LQiHWDWoz/\r\n1ZHhs2NBGvfSTByv+hb71/zcfKvw3Bvd2zqCtudYWvIBWJvPvvdbKVa7bz8shpd4\r\nWzTHNfbpJmFgk/AfbAGJ/xaKKo6VY7CdWOmtx/eyK4HxkS0hqzdmT2GQvhqqxhJy\r\n3NdqKK9FAgMBAAECggEBAKR2sgmoJBCuD0MfumyP7m0M6JXFpu0mOGCGtunVRCBy\r\n38JcSOu/Z5borIRCT7+a0oGqQtQI/Aa4pVtWb4IXBDMJJBK8korHcglwOYg3Xuqo\r\nqUiIR9ApPVFE83nSETOL8c2UyECqlWraM/siO/SRdjCEKs5pWQgUkM+OroXofnyB\r\nQ1bjXrK2l2NfFFVuMoUhL6bvoqXkptduwzXjWmd/XKAriyEl8NbjU0ZQAHYFjdwn\r\nbPF88ZY++PEzPykV+Q+L5/VcJjaieg5K1Ny5rA8rP3nfQNK+pOZmwtbuPYgA4bJF\r\nVepj61+7R0+3H3bFAAWFTqL/6Fe7r7yTJgZ+VtDwaIECgYEA5jWLgAM58ocQxcyJ\r\nHPQsmeGpnTs9doG7iqd0pp+CW8h4MVgTIq6qeo7iVd648uRsfBrEGm3396tdN/yJ\r\ncaN+d4h/0NhwNFtMuobYKEoQ76Hf+/vBaAjiNb5kmWlNUVDA3AdDzDHd2Sa5AHNL\r\na6kmfGGL547MuK3pUBUic9hGCxUCgYEAwWdLz7Z8UfmjRyp6HEklwoWi1pfQy/uX\r\ng2d2OWi7hmMDxL93XiGlW1Wj6NgEfmSW6U+Ja0we3Tw8q3PMVrRZL9I/qVmnXBuI\r\n6bFZxVyjbVpuMn6b27cWAXBPIir9u7CE484c4+cSdt1Xj2O8CoJA2mlBK5L5UwRL\r\nR409FtTdX3ECgYEAzQivoGo/ODT3yVPsYu9Oshd8u99BVMUjRdDzYlv6/MhF1Jz/\r\nHgq3J8UO7TAbRaoQvVARjQCYs+vacLzppV7aipf2TwoWlWsjoZXr+6ZMA0IHfiSy\r\nE3imEPvsGX7iMCReQRnvVnSrhHaqmy4U5GSZNHqk4q4aw/mRLZRFRSxA5ikCgYAX\r\nGRIZzY6Nb8YLUsxgom/LCpDHFjyOkA6pV+rrslFrHFov3joQWO5ZuSGpRltLCRJo\r\n7OHZma659167j0nhNQrNxktqG1X8jyFL3617/7NY9QriJvLQS85p/5LD3uSMzOki\r\nF9Sld0xiO88gReYIT0QVkaqB3LzAKGwhMIISPvvtUQKBgQDHxguUCiDBO1ecI0pO\r\nv4/GGHdwIxAbBXp2BT8z1QT2Enidml2rB3hTycYJDYbpLUAmUdd5PI26ajKfXJff\r\n5SrKjVolsJcug2ayH3y35uZkwu0gTuAOY7PLRZte4zptn2ORm56vKbO+QRUhZJqW\r\nhrWT+gg9qs/Yg+qJQWYr8WlWGQ==\r\n-----END PRIVATE KEY-----','2017-09-08 13:39:53','2017-09-15 16:12:52'),
(31,63,48,'','2017-09-08 13:39:53','2017-09-08 13:39:53'),
(32,3,13,'','2017-09-11 18:54:03','2017-09-11 18:54:03'),
(35,1,2,'','2017-10-09 06:10:25','2017-10-09 06:10:25'),
(36,2,2,'','2017-10-09 06:10:25','2017-10-09 06:10:25'),
(37,49,52,'سوپر میکرو\r\nسرور اچ پی\r\nسرور سوپرمیکرو','2018-02-06 12:50:37','2018-02-06 12:50:37'),
(39,3,14,'09388357218','2018-04-07 03:55:28','2018-04-07 03:55:28'),
(40,3,15,'09382490252','2018-04-07 04:17:36','2018-04-07 04:17:36'),
(41,64,1,'','2018-04-07 05:15:04','2018-04-07 05:15:04'),
(42,3,16,'09120322854','2018-04-22 20:17:57','2018-04-22 20:17:57'),
(43,26,59,'89.42.209.136','2018-04-22 20:17:57','2018-04-22 20:17:57'),
(44,27,59,'server1.kishapp.com','2018-04-22 20:17:57','2018-04-22 20:17:57'),
(45,50,62,'order.use-ssl.com','2018-05-23 20:42:17','2018-05-23 20:42:17'),
(46,64,17,'','2018-05-24 22:36:15','2018-05-24 22:36:15'),
(47,3,17,'','2018-05-24 22:36:15','2018-05-24 22:36:15'),
(49,64,13,'','2018-06-20 10:39:37','2018-06-20 10:39:37'),
(50,62,30,'','2018-07-07 00:46:11','2018-07-07 00:46:11'),
(51,63,30,'','2018-07-07 00:46:11','2018-07-07 00:46:11'),
(52,54,30,'','2018-07-07 00:46:11','2018-07-07 00:46:11'),
(53,64,3,'','2018-10-10 17:41:19','2018-10-10 17:41:19'),
(54,64,19,'','2018-11-08 14:58:16','2018-11-08 14:58:16'),
(55,3,19,'','2018-11-08 14:58:16','2018-11-08 14:58:16'),
(56,64,20,'بله-خیر','2018-11-30 13:42:58','2018-11-30 13:42:58'),
(57,3,20,'9383194723','2018-11-30 13:42:58','2018-11-30 13:42:58'),
(58,3,21,'09118548174','2018-12-02 21:05:17','2018-12-04 07:01:41'),
(59,64,21,'','2018-12-04 18:39:27','2018-12-04 18:39:27'),
(60,64,2,'','2019-02-04 16:34:40','2019-02-04 16:34:40'),
(61,3,2,'','2019-02-04 16:34:40','2019-02-04 16:34:40'),
(62,64,22,'بله-خیر','2019-03-07 15:26:56','2019-03-07 15:26:56'),
(63,3,22,'+989133082272','2019-03-07 15:26:56','2019-03-07 15:26:56'),
(64,45,91,'karab.ir','2019-03-07 15:27:55','2019-03-07 15:27:55'),
(65,62,91,'-----BEGIN PRIVATE KEY-----\r\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCgO28hAohcM3tc\r\nc3Syx5PxhkmDsQRY8MmvUAEMbEzowkuohW6qnfztbbPPvJi9BePLPA1pVDhDpnZs\r\niYCdN65dxrJ1Xy9s/Plc9uleMr7oABloh4kJxZlkbfnySj4yfCQIXmGbJMu9E7Qh\r\ncheJd+GI4+flPkvZHQSgrFfgbfYTwVHPTUMOTJAxtA1MzL+LovUMk++b2frsewJ9\r\nTjpO7BWACk7jKebBl6dCRlYGTYgecQPG4f3PIR/59gwOS5MUs5HKAXMJu5Jw03Uj\r\nvTmSFO9NlEUAnO1jxYtqwDjrXqMvz3TwKLQEv8M5WS/3WgxAmm5teEGBxiaay0V2\r\n7qZ1jfXfAgMBAAECggEAbXVsix5RzLqWkSeGFwNju2DDI6VvlNqYzJxYuwXY3ECu\r\nsqbEXOWkfQWuCkGKDcbSQGn7t3KDJSO4Tpj4NW5uPT2Zd7jYixmdt7Ys4d7Er3Qx\r\n50h/gx9rlEHUt4GkT5SigN0IzJUsYTPun9Jy5cPxXDRknCQcaGr8WE6jkXtM2Vzo\r\nL+OJVoqt4FGAfvEorrbng0GZTq7g+01zpwa76qIk3xVZswqrFrbBfE6RGy9P3uFF\r\n4/LsHSpM/6Slsw9T++1l7mP5oVjcfp6qQ4ImQcIVO+VPu5SGczVCtSh8OKMuBLlP\r\nXi8K6HAfMsAGsiKb7MLeZ2N904fDquHS2n63+xwxYQKBgQDLz7L8trao8JdYdZ+V\r\nBkO9nByJr3uGScx9DDM6pvIpdPQOJovVyOsVmNR0fh0S/8iJW3OqE9tbUF/TXFZy\r\nDLAL80Fjsf/UJGB3KX+Uk50Nf9KigZ2srcqzhgjYYSIdLHr53JEqhq7bLku6jBi2\r\nzrygn8NymomirtNcTyef61ETZwKBgQDJQwVSgoRehF9FpL6gKow6b0g4cJf1eZmt\r\n0gZ6BwW9Dmb0MR3ARPo+IxSNoyFydygUSYGnaPDUlP3/YOFWoDARVtYnlHfnkEJn\r\n6/dNNcWer0OnxkcSdtqAjXN46mVKNqjeQSDv6CdwGFKyX4aOkoYU1R4YOf3E8cfq\r\nF2FdvgI2yQKBgF2JE67RN+EukXbCfJuLBXm2dI5n37vQkK1u9O/dAFQwXXVFEXXq\r\nwKDnw9E2s6cthl4rf1i1xj0RFPlObknnMsA5QnA7l5pHm5H0lJ2eZTx1xjhYXgGK\r\nvPVI9TRA18QlzsZvCJxItWTXyV9yvkDffkgFKlClRbdInq3FkfzdpRbPAoGBALKB\r\nhiPzbRIj2Bh+ETEf67YcY3LjsnPfwYVg5auvtNBFCN2G/rs8srMQDDe/u3e55ctw\r\nktV4BzqVV179f3+Enn2ShmkejubMlYl0yagqjDe9fYU+IGVpE023p/ZT9zjGmCpg\r\nm6UNRIVwnVBl14N2xAOQLpwQO1tFkym2SP6K+425AoGAYZOb01HQ+E7GuXR+7K+S\r\n82A5KOMb+rzIloO9Sy0s68Bhe6x5pXM2epuQawVjHf7vHJCW64pQrzEHrU0Uwjj+\r\nf1W9/eTmyCMCDlrtWrU6bjsc51aW9gaajB5A/v/BKnBYi1ACKZSYI7OEUkvGdV8L\r\njp5c7E//I6A79O5kJybQhtE=\r\n-----END PRIVATE KEY-----','2019-03-07 15:27:55','2019-03-09 16:20:33'),
(66,63,91,'-----BEGIN CERTIFICATE-----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\r\njs4foMS9VAFESML2hwnu75ElXQ==\r\n-----END CERTIFICATE-----','2019-03-07 15:27:55','2019-03-09 16:20:33'),
(67,54,91,'-----BEGIN CERTIFICATE REQUEST-----\r\nMIIC2TCCAcECAQAwgYQxCzAJBgNVBAYTAlVTMQ4wDAYDVQQIDAVmc2RmczENMAsG\r\nA1UEBwwEc2RmczEPMA0GA1UECgwGZnNkZnNkMQ8wDQYDVQQLDAZzZGZzZGYxFTAT\r\nBgNVBAMMDHd3dy5rYXJhYi5pcjEdMBsGCSqGSIb3DQEJARYOYWRtaW5Aa2FyYWIu\r\naXIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCgO28hAohcM3tcc3Sy\r\nx5PxhkmDsQRY8MmvUAEMbEzowkuohW6qnfztbbPPvJi9BePLPA1pVDhDpnZsiYCd\r\nN65dxrJ1Xy9s/Plc9uleMr7oABloh4kJxZlkbfnySj4yfCQIXmGbJMu9E7QhcheJ\r\nd+GI4+flPkvZHQSgrFfgbfYTwVHPTUMOTJAxtA1MzL+LovUMk++b2frsewJ9TjpO\r\n7BWACk7jKebBl6dCRlYGTYgecQPG4f3PIR/59gwOS5MUs5HKAXMJu5Jw03UjvTmS\r\nFO9NlEUAnO1jxYtqwDjrXqMvz3TwKLQEv8M5WS/3WgxAmm5teEGBxiaay0V27qZ1\r\njfXfAgMBAAGgDzANBgkqhkiG9w0BCQ4xADANBgkqhkiG9w0BAQsFAAOCAQEAg/Xc\r\nfwlpj9oF2z4/odKgH7emiBOq4jz9dW9fVCAsqMfgHDsL+oxo0yPKgEIAKr2/T3qO\r\nuXxYpRNHTJ2okLba32+H9YSR9qBkvhQFXFsYeEdLoZe7FhDRyVtIYOkZZP5Lq37H\r\nOmF+7IkGzZJ1XmRR8ywxHeRgNhDfBipjUpV+zHvwa/Zrb4mI4X3LFe9oX9YS1IUC\r\n9kFLLjtAC3P6c1mf+NkXvzFfs63n7BbszHPWgZnBAWSbFoUDu+C/LHQT5bZVWJUO\r\nPr0T7Bp8lcot5rXx0F53yL2jYx5/fLH37sqxY9QWlBFmxiYKDTwZI/axgQfqgCN8\r\nSJYRL0sZxX14SkIsGg==\r\n-----END CERTIFICATE REQUEST-----','2019-03-07 15:27:55','2019-03-09 16:20:33'),
(68,64,4,'','2019-05-25 05:41:46','2019-05-25 05:41:46'),
(69,3,23,'09396963413','2019-05-28 14:19:07','2019-05-28 14:19:07'),
(70,64,11,'','2019-06-09 05:49:57','2019-06-09 05:49:57'),
(71,3,24,'09014165100','2019-06-15 12:28:39','2019-06-15 12:28:39'),
(72,45,103,'emsisoft.co.ir','2019-06-15 12:32:58','2019-06-15 12:32:58'),
(73,62,103,'-----BEGIN PRIVATE KEY-----\r\nMIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDcf7Rn3pDND2nK\r\n2hrFtuJbws2dIm68nFO2LUy3ifro8I/IyIJS6eM0FlNjd+1LxficvSLKBOL6Obek\r\nG3XyfC60B0BmsCnYqq+kCajDkztfXCyKibj7iavaRG1FFhXWOqGoB9PH7VS3liL2\r\nPo36ajsaEc1eLQTaMo2IIc0sTG4FjK+/V4syYku9GYlM7VNhFvQqGfEAK7AspiPq\r\nh/ITdo2KSQJ6c8oMyPBj8bI4B4bpU/MjIM23rcV5n+rsq8tL7If90JWZ8swEWAR7\r\niISgfvtmtgbs/DvtxKMqnMmKoko6vOXk3ZmFp81GZLYHc79ZuvzukCiCBMmGOf6a\r\n7ifnhnyDAgMBAAECggEARmYPd0o7+Px+zmEsQwvM4XckppKjwFw47eUwpTjMfyqu\r\n/W/nDAnYnHy0SwGzJYojggdw4AcHYNSkqSSLV8wGLTxTd3WvJpn4Ueszkp2jSyLm\r\npaSrBsRBtgI60N/oQOmfS0KUfzRq4+JvbycxtU3NaNleND8zWWbigSApnYcZaXOV\r\ningfkL93QDfzkD76tDTVYmn4jYrMLEQX8uN6x7GSBQox/yPSWckjyZjx/nNjsChw\r\nUcUQsxT9cpNSgtEtOA1kbeUuIPuxShunbfvjmdAviZpV0rkgz4rF/S8qf/woPVjc\r\nQpfHHlqYMnwQyQ/0UfcQZB1XQvLIlS83o2/Be7sOAQKBgQD6v5Hpt/Zhf5Yr5FlA\r\n35G5geAY2FFJLgs49LOx6jfPrrwQayvGZ3i7cjthSz9OGvrgneLIwy5LiXBRO35C\r\nq7dML71q8gNdHuQt7pIbRQm9SmlMBRFalv162c3C3pMTDxf1oRSmJuXxA5KgOSAZ\r\nTSqIz009yqfTmi3+Xy0VmRQFwwKBgQDhHfJvG/so1k99/93imsdThwEWdgRF7Fj+\r\njF9dJKP5uh9iBA1RcGqdWLhHVxwTw8aLB77k/v/JttHq9CFY8bVZnhhOD7Zwu+RH\r\n+KMABQjG+JmrVJMv7UVBLVza7lbcBxLJdnw+BmbA8JmRzbr9rOViBlSK499ji7zC\r\nMflKiyyCQQKBgAESQHVXK95OxT16xEbaray1OVfh1LcTU0jzArGH5qUkgfkv/Afk\r\n+UcTvd00jRiwVNIQ2p8w9kmsVKaEMo3mXeodahnC3vDO6PqpQkaLjPcaEkkY3HIe\r\nowabV521hbtXHSsXfRcYo3LcKQw2MkTpZ30eJZ5V91GYHwovLeohtUwxAoGACWQk\r\nbvot2iBGpKz95qwqUJO7OeKmfvxDIitc9xfGN27KTF5658DW0cWXunIp27E5ISer\r\nkQYKSbH0w+Z3VayPsjNkNC13oPBVr6Lxudh760EHuBwJH+C4GOX5j7CNsxQgdoMY\r\n38WIl9fxsCFzAY4q65H0CO9ErHRx5XAMRE3WB4ECgYBbK+4/u4qgXprfgt1AJr1R\r\ncYzv07FfhRgTg3vp3N9x3vOyemNzHNJah+uDdTHwRpdsDOZZpnJ0CWqVDAq1L00I\r\n+U0NtcmR4YOpDm/o/Rum3VpxCE8x2VUYYsiDBTLBDkYh7cxNX3fJqizrikM/DS4b\r\n57rzd963bxe72ZpfC29xmA==\r\n-----END PRIVATE KEY-----\r\n','2019-06-15 12:32:58','2019-06-30 07:44:12'),
(74,63,103,'-----BEGIN CERTIFICATE-----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\r\n/imcovMnPujR+4OWAv17jGRgcs/gFxQBvAM44rMr9BMKhlg6N2A=\r\n-----END CERTIFICATE-----','2019-06-15 12:32:58','2019-07-01 08:08:12'),
(75,54,103,'-----BEGIN CERTIFICATE REQUEST-----\r\nMIIC4zCCAcsCAQAwgZ0xCzAJBgNVBAYTAklSMRAwDgYDVQQIDAdJc2ZhaGFuMRAw\r\nDgYDVQQHDAdJc2ZhaGFuMRowGAYDVQQKDBFBbW4gQWZ6YXIgU2VwYWhhbjEMMAoG\r\nA1UECwwDQ0VPMRswGQYDVQQDDBJ3d3cuZW1zaXNvZnQuY28uaXIxIzAhBgkqhkiG\r\n9w0BCQEWFGFkbWluQGVtc2lzb2Z0LmNvLmlyMIIBIjANBgkqhkiG9w0BAQEFAAOC\r\nAQ8AMIIBCgKCAQEA3H+0Z96QzQ9pytoaxbbiW8LNnSJuvJxTti1Mt4n66PCPyMiC\r\nUunjNBZTY3ftS8X4nL0iygTi+jm3pBt18nwutAdAZrAp2KqvpAmow5M7X1wsiom4\r\n+4mr2kRtRRYV1jqhqAfTx+1Ut5Yi9j6N+mo7GhHNXi0E2jKNiCHNLExuBYyvv1eL\r\nMmJLvRmJTO1TYRb0KhnxACuwLKYj6ofyE3aNikkCenPKDMjwY/GyOAeG6VPzIyDN\r\nt63FeZ/q7KvLS+yH/dCVmfLMBFgEe4iEoH77ZrYG7Pw77cSjKpzJiqJKOrzl5N2Z\r\nhafNRmS2B3O/Wbr87pAoggTJhjn+mu4n54Z8gwIDAQABoAAwDQYJKoZIhvcNAQEL\r\nBQADggEBADyedLplZoCJ+7xrVmvsm7YmlpUW4fQ8QDwWQxhX/Eb5TQPcE6NGSKRZ\r\nDLTVTcRysWJcI4pZakdyueQ5VhgKD+GBQplvyB4kr1BTSqkqHvHJA/1zGoAt/or/\r\nsJfEgPW4JCPVg7b2lwHH4r/VpU33RutxB/CGMat6QX7ImUCTLHmYmb6JCUifMd8b\r\ng3LuU7GW+9oJVE6T3K23nDHxweNMH3h6Xl0Gh/scLzQ/96ApJXkSVgbmZExf/1qs\r\nqLr6JiSztIa+nWD4Iuk/uDAsevrrq8pTfiKAj/uHvecbdyo+7hg16nA59ns7xusC\r\nVNMXl2JxvtNzqbMjN/2y6Qr2PqZDGGQ=\r\n-----END CERTIFICATE REQUEST-----\r\n','2019-06-15 12:32:58','2019-06-30 07:44:12'),
(78,3,25,'09203214155','2019-07-09 04:16:55','2020-06-09 09:41:55'),
(81,43,6,'windows Server 2012R2','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(83,67,41,'','2019-08-12 06:26:56','2019-08-12 06:26:56'),
(84,30,107,'91.98.98.26','2019-08-14 04:29:15','2019-08-14 04:29:15'),
(85,31,107,'server.entekhabkala.shop','2019-08-14 04:29:15','2019-08-14 04:29:15'),
(86,3,26,'09390174884','2019-09-08 08:23:38','2019-09-08 08:23:38'),
(91,64,26,'','2020-02-14 16:18:48','2020-02-14 16:18:48'),
(94,66,120,'Windows2012 R2','2020-04-03 09:18:06','2020-04-03 09:18:06'),
(95,67,120,'','2020-04-03 09:18:06','2020-04-03 09:18:06'),
(96,66,121,'Centos 7.X 64Bit','2020-04-03 09:18:07','2020-04-03 09:18:07'),
(97,67,121,'','2020-04-03 09:18:07','2020-04-03 09:18:07'),
(98,45,122,'lms.ibtil.org','2020-04-12 07:54:31','2020-04-12 07:54:31'),
(99,62,122,'-----BEGIN PRIVATE KEY-----\r\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQDCit2NvbiiNeJQ\r\n288nI/PO2Lu8Z+WLAV2LD0Xya8dGedn9OABolewnERyvvVrvje0ZZUZL+RsoVXSJ\r\n/2sVfST1YNLbfyfYAaXKHRs4XC49n6qFbcOFS/q9IMgctmArloEb8XNvxbIreoXW\r\nCOcveyzq8o7DKwRe878WO61w2lfDxxu7kFn2NX8SjjuyzuxinOpe7setlg4oF05v\r\npvxlk0xlvW7P1hJ9mgvUsW1/83gcl+JwZz3lQpMZZKO4ATwku4MZ/wiQem1QBPdA\r\nmQkDo/+WKjEOUbL/VOOYRgMY2vFr1xVd1e2AkuTa8NqJjOPMZRtM7AWZ809eDpQS\r\nsGLasxgrAgMBAAECggEBALuPiLWMUcNKci0FD36sAfbOLIokHUHciiR1EDn+QX0o\r\nI8wnvvUWfjzYGbExvceyLQLMCm9a9xz27snRUJvCMOzGceSffnmadQ4c6851yTsu\r\nggfsYJJWQ6MuROCx0JyVmVqoemQr1XBnyzslEEdN2WuXeZ6fDbLCC9xSoxBn4i/k\r\nS60H3mtUPuNQtXdnccIxqkNPzcc2Fa6Md4pmLZ1Dif0yJK0Be65pbcQ9DKLjUxaq\r\ntOTMD38lHEovRNNRlFLwpGK2nCefkVxzJPYdaVWX+SJ7ECHk+3IXkIPOq+NVfWyu\r\nlKHBe6aApHLkz7WkN0CJx/poQQf7cvlHY2wrYdiMTdkCgYEA59+OrKanQejiw4yc\r\n6tAZZB6dgkv42Z7IG9rfj9jD62q/w0MBKnK/ScxNtuh8VFfdeIQ4oM97yCQE1EPD\r\nvB1a2TDF9FOEqo0E88AsW1XT6HGkwcbliTW/GtQrevUABQA4aS2xBx8bWxzp/FTG\r\n74hJGvWGpC/FSl0fXVR6syr7pv8CgYEA1sjr3IPc8b5+nnsa3vHe0TCLWarmXo2J\r\n43yKGVpRh/6LKhrpjwRjQm3cyJOyk6MXuUh+aaIOda7yemFezTaxN1jBWdXhZcT6\r\nryV7HdKxekd/cq/COtkxGYNHAeP0uJNTTsC8qr3G/GiJgVJOPfxeHwsqEUTrWtNc\r\nUghD+vDk2tUCgYEAzmVQup4dg62pLCeeBeX2tAgMbE7z08JinWjWV1S8EHGVAFpE\r\nT2SUoTwacRXAldMgcIZBYeNOa3ikU81+DZSTqYCgtDsjfCzKm64Tzbk4R0/hOBuz\r\ndc9BrL/vdCNhQRJRJE5npc8qqo+yN8m+yrilWjny/3MGSotZv9nS3mkEWEECgYAx\r\nqTknvnFqj8IVAJ/A5qm/Mns121byi8VTDOudWw245PjmXlycTcZpiJ9g3Q2QJ0iH\r\n9aQM5oRzX2T/ON5Dkp69Dk9+Zv57mmTf9EmYJqwUes2UBeFh2/AHVxwm6r8doirD\r\n7bpxu/lzSPRqK06d9GkKwnkSjx3f3TjeWrzlG6e+lQKBgQCE//kGPKdMxcs7Jf91\r\nOmAn+Jk0JRmHD76NE4h0Q90TbrI3jZ4ouibpRYu2FqGe6v6dTRbmLfdgbQh7+y1J\r\n4PnAO2WDjbVVfEcoiZZ6nmgNLF51B9VfqMSDmofgDnYc+XjFDQEhsIw4fVKThVEh\r\n6MVeXHVT/6q5AVA0phgq/kJY6Q==\r\n-----END PRIVATE KEY-----','2020-04-12 07:54:31','2020-04-12 07:54:31'),
(100,63,122,'-----BEGIN CERTIFICATE-----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\r\nHPrgcXDO/dinzRtz\r\n-----END CERTIFICATE-----','2020-04-12 07:54:31','2020-04-12 07:54:31'),
(101,54,122,'','2020-04-12 07:54:31','2020-04-12 07:54:31'),
(104,3,27,'09355155976','2020-04-22 13:27:04','2020-04-22 13:27:04'),
(105,3,28,'09396015154','2020-04-22 18:17:46','2020-04-22 18:17:46'),
(106,80,124,'Centos 6.X 64Bit','2020-04-22 18:22:45','2020-04-22 18:22:45'),
(107,81,124,'mikrotik','2020-04-22 18:22:45','2020-04-22 18:22:45'),
(108,64,28,'','2020-05-08 18:45:10','2020-05-08 18:45:10'),
(109,64,27,'','2020-05-08 18:47:31','2020-05-08 18:47:31'),
(110,45,131,'','2020-06-30 20:11:35','2020-06-30 20:11:35'),
(111,62,131,'-----BEGIN RSA PRIVATE KEY-----\r\nMIIEpAIBAAKCAQEAsYyM9aUARDE3ySj2aSPz+4ojUwgw0x0FTmBcLwQZ6qBzWG8J\r\nAm87HLZ2Dnz32h+oMOFdkklW2z8+tqhQ+xDJM0sFDr4jP0Wc5TaQVq1nuW+UOvjr\r\nOxbRjwk9Uu/YL9BugfNtwVYMxu/GsGNQEE8RaKwoM281mAZimtn5PBQI8MqSkaFR\r\n2sCj7f0M0/zBI5A8kourFUDevaILX/6bjPPEBrM7ObcGf/nyJu9qZMd76kcJGhsb\r\nxx/aEwkcjg9cRkTPtc9gbNVnfvrlj2v+40ZSWGHn1DeKl0sBnSCBcZRAdxMxgcU6\r\n3bZzdFXOesfHIV2d71sf0bdB2H70WBd47mViRQIDAQABAoIBAFhcgqqd+4v0krbi\r\nU//vjLVbAkmIggQPJVzkR/x+JgfG4qDYYbt8cAbSJ97+ArvjlWj+P/tV1Iw45ZUy\r\nH1tT9043v8SejBwpIPRSO3NnyX9YMIVI7IjzykdNad+kzgq9yMGTzMOzd5hqLJAM\r\nXQRA1YEqbLdsWVfXlatLX+auceSjmCY5keYQpSYKN4n2SjIvbSVAfO49DeocKtR3\r\nngYuqFMt/PvFlUHQll6m2/pvgsVovsmHqQkDURrLggucvV744kiOAes7SDttC02n\r\nbm8FO0ya9YCoSiQpJnlT1ahFvuZfDpz5UUvZOagGz/5cKtMLlvADYc/oiZLgfzY9\r\nheh94gECgYEA125w3D/4STUojb4/ajttnXBdfysQbJxvJBdFQQH7ascs8hbsXnr3\r\nsvX82nwdIDjJIp5fXjbbIvVDZQkpqAeFanhwjfYMTVZhYH0aesTbV0fmfImXoZ+M\r\nttKkYmu8ayO2WbwRfd+H/YgIOuLFzirgzmgTJC2+G1R0B1OvTM2Sw3UCgYEA0vve\r\nU9NmgBfWlmkUpkVuKi3w3sEbsS29oiVadN6iVhga2TphiSGIbipAJsk+EK6TZ6CK\r\njgZ4YDpeczWJ5UGGLsnVCeYi7eagoAz1ruROpMZW26jUMXTsXDo8NSfpe/D8Gu1j\r\nAJQbdFfscDOidSuPASsFyWG1w4erFwjT89HtWZECgYEAtcb/vijQFN2g+XE1SysY\r\nBAejLMGmmy6obRihnAfTIDcuCpwjGFnEFiKQF78wSFcCCI7/w5yf7XBsTJ2do6Wt\r\nArjbqD2cBcnEYslNBZiDx7Lond7vrjXVYxJ8GHv1waWhoTgavk5WDiyxXRaqd5sg\r\nk6mntRhP1/m76c7IFRNFKl0CgYB9mEvIMM8Sr54hWZpeRHSJDWIW6HO4rFb3wC6x\r\n5ZpTj/PjnnpTbK/PjL01mZSlz5aWGJ6CX12nQvfYs2VMIQ5kqed1BheC8UhrHmve\r\nWbBrLFqmVkFC06ykVlJi/khibJlW2juWK5SQVIq+XC54e56cfmTqdY0DQa7afnnV\r\n6gDV0QKBgQC4NI+8xsZuQH9EyjWvFB3/649TDy6J0g1dGRhETUDjLPwMXiidmkcS\r\nnWS3MvIEtSjOsTnHUVuV+GDwfNjVKSdWizVul5ciwlg72Ohua776Zid0evrYQgN/\r\nb12sT8jtU8iwTObA7nr6abfHdLadDHDQ0GJYp7Lc/52Z45kykdJWHA==\r\n-----END RSA PRIVATE KEY-----','2020-06-30 20:11:35','2020-06-30 20:11:35'),
(112,63,131,'-----BEGIN CERTIFICATE-----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\r\nuX9NOkssxI8JLrLDSi2oImWxaD1/mXQlhVPAClqaPIu+\r\n-----END CERTIFICATE-----','2020-06-30 20:11:35','2020-06-30 20:11:35'),
(113,54,131,'','2020-06-30 20:11:35','2020-06-30 20:11:35'),
(114,3,29,'09203214155','2020-07-08 07:06:24','2020-07-08 07:06:24'),
(115,45,132,'','2020-07-11 15:08:41','2020-07-11 15:08:41'),
(116,62,132,'-----BEGIN RSA PRIVATE KEY-----\r\nMIIEpAIBAAKCAQEAxPVIyW6O1GWMPrhN/SNbZcI/YdKnRIZOelqNqzWNEdh6S185\r\ncGlfICml4Lw5Q/pD3O0nLT9ZcyrZeeE4YeET5kVq0deyxjabZaFDfCXnTBdG/b8y\r\nK5muX3f9GrvUfv8wPPN0R+zO21xK6ksZbllUHPMoyZ7kUSBnLmparKMi90avR4In\r\nVzy6ZJvU9yt8aerKl1nPB1/AEcWpctRiFXqyIXDdhmL0SgcBd8syUmDfudUxs/sI\r\nJzPOhki9gQmKbrS9uuQzVhLTnlPFiFEJAA7582jvz8AmM4BLmP1h+rhMYvUteUOo\r\nIulqvuLlVUyzU7XdQ1YRlRHZFamjTp/V0x3qtQIDAQABAoIBAQC12DFnqOe+OjOO\r\nBOQcf3R3My0JyFAe+FGkrc528G5at5/Rzw1dOCxXqZw5Lg9BL+NQKrUtFXwk1L8N\r\nxF8mH4Ub6aOCMsAgOXKoFogUK3qtyiAFT22my7Eu+7133UuIJVwIKk6FyaIC7edN\r\nAiFsvJToVaim3ki2jlA1joRBOC2kVsD4qFHxgwUetIY1peuYDsEFMtva23k2wbUM\r\n8z55LkYfnn2Yz2sLTS9nu3icZeOVww2joEMlR90hG6Fu0A3IJKLjRtJ8QKO+Mjyg\r\n9byZRdgSx8dStz/ZnwSnemQyvXIXuwCityRsEjuwDgoqvHTjgxaY5cakUuUH4tp4\r\nr3rO+ruBAoGBAP1t2mxJ0sLdA5OnFZLWw3qr2G5M9/vKsOaHhQ7N9sJy45gNifBa\r\nxxpaj84Q4cbEdumcluz4KLKdDn0AjzUleWdDSyr9jiMKmgbIgnePNt4vJPQuJW+6\r\nKqmVmO/yajhQKhhw0OrNjUi8OIxyOyxREzxWS02Gf8PBtwmOwd1R5vw5AoGBAMb0\r\nxyV5zdrAq5ySShCkfXbttLgLqEdBVOsz15ybSG/EVGMBnkIMfgRe7u4qQAYszFHp\r\nmvFxtXMYoHEHHS8w0WsdM+hupBDTQ7WhhV4vHs8EODqtX0RbHTe0+TQN4fw5MBRQ\r\noJsIdzpr0evuVA4GcXC6bDIZzR+OB3lcLhrmSppdAoGAbAUM2qdEvGY0BhVrrqD3\r\nxSvGHo2UDbDBYiFVZ5AGo68Qr1jl+JrYzrTXIsAzW+OVw9FIy0yjHC6xZDp+z+pf\r\nKtKWEYbttKXqLQX+BjP28RErMSESN+MkGBB5lZzABay1pKFBizN+CwifGc3+xs7v\r\n4gHuKucvQiMpf1tn6ovkZpECgYEAwaov2Cjy2wdFhYlZE04q2wOUMLsYORQ9Rx4V\r\nuVnmbvVbd2xx0rU6TaLjTW5PGDOvR+TvcCtRhxHny14zaGZK08t/ZbedeMtNU5ZA\r\nrmeLw9PFsEhnPbC7hihhk+wXmF9Kj9vUGlVpSbL+inxZ0bUv4510CGjZJOgqGlZC\r\ngui8ofkCgYAgCQJuCvl1RNfbYcGkXs61+zdw5/A8PGxqvFB/8Vv2viMt8185si5J\r\nRNkGHlAnREcdDNoXrQL3SCFF+/vyX4j/iHQIn5F/PprbBvdfYEzcRYoojM/kCL0Y\r\nq5YSrIZDOd79DhgZgs7LqyQYRdHa/GBQyZzbYNMWy99w70l6zu35Sw==\r\n-----END RSA PRIVATE KEY-----','2020-07-11 15:08:41','2020-07-11 15:25:20'),
(117,63,132,'-----BEGIN CERTIFICATE-----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\r\njxcVzrDixmPdX0LgYj3yVMIt\r\n-----END CERTIFICATE-----','2020-07-11 15:08:41','2020-07-11 15:25:20'),
(118,54,132,'-----BEGIN CERTIFICATE REQUEST-----\r\nMIIC1DCCAbwCAQAwYTEPMA0GA1UEBwwGdGVocmFuMQswCQYDVQQGEwJVUzEPMA0G\r\nA1UECAwGdGVocmFuMRkwFwYDVQQDDBB3d3cuc2F5YWh0ZWIuY29tMRUwEwYDVQQK\r\nDAxjZW50cmFsIGhvc3QwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDE\r\n9UjJbo7UZYw+uE39I1tlwj9h0qdEhk56Wo2rNY0R2HpLXzlwaV8gKaXgvDlD+kPc\r\n7SctP1lzKtl54Thh4RPmRWrR17LGNptloUN8JedMF0b9vzIrma5fd/0au9R+/zA8\r\n83RH7M7bXErqSxluWVQc8yjJnuRRIGcualqsoyL3Rq9HgidXPLpkm9T3K3xp6sqX\r\nWc8HX8ARxaly1GIVerIhcN2GYvRKBwF3yzJSYN+51TGz+wgnM86GSL2BCYputL26\r\n5DNWEtOeU8WIUQkADvnzaO/PwCYzgEuY/WH6uExi9S15Q6gi6Wq+4uVVTLNTtd1D\r\nVhGVEdkVqaNOn9XTHeq1AgMBAAGgLjAsBgkqhkiG9w0BCQ4xHzAdMBsGA1UdEQQU\r\nMBKCEHd3dy5zYXlhaHRlYi5jb20wDQYJKoZIhvcNAQELBQADggEBAEr4msEMjozV\r\nrdYMLIijPhsK/Tp9H6VHqmocwLtBE6xAkSTiS8S09e3RD9cKIhfNxjnbGKTnoBA3\r\nQ0AkcM02U9WCzgBW63odVtRzlKCASc75q8hyMdLuom9BhRM8WNyugo4R0Rr2+aHV\r\nhisngEBFk20b0ziQU5gTwv+8rthEuRMRtPG+Ng0mksm01aUPXwlA+9CafzE1rGUO\r\nTtJmUZWl9yJL75bpgSMRkXUy5qIhNW8QoUXtwAnMtQtLswNs714YT2rWLsSXL5X7\r\nQMZVtMxGITpLyAQ3MRuVdfZPQW7YCGXsjhnsZuJv8bbgI6GRiWH8wnEHgVl1tPnp\r\ndW8qfrcPM7A=\r\n-----END CERTIFICATE REQUEST-----','2020-07-11 15:08:41','2020-07-11 15:25:20'),
(119,45,133,'','2020-07-11 15:08:41','2020-07-11 15:08:41'),
(120,62,133,'-----BEGIN RSA PRIVATE KEY-----\r\nMIIEogIBAAKCAQEArvsfo/O4MYN9XslHzSuEPEMymi1ls69y2nJpGcGCADFp5z88\r\nSQrr3dWIochV0xQG9ZEE548w+9BXW7XX40OzXklQpdOgeKcUaUJkwg9cls0aCCcf\r\nDQxm3LiTiEmvJ5FJnGe+XAHnm+biY0qgnMgV5IIw3CgVYSMIxw6W5eGNPEEGReIw\r\nc4V2/EXJsZuEIUyT02f1udhPBnxuf9u8b766HXCF8XRWhjfwdOJvMFJ2xxJMzj+Q\r\nZ8CBLnr5j+/CwqGvne2Gry71dvw7zSYSGZYwBhARJpVlYztjCvdgpNk2h9cvGVSn\r\nxsX9Jd5ZT2zcC+653VOiJUXCVLu7kqMxemdEKQIDAQABAoIBAHPYFa55oCxHnSyv\r\nnTWb5cPvyQSBoZ9API2ayTIgBm0SScaq+sJw1I7c28Qf2ZIQ5DqXc+PJzOgpmmxB\r\nC1iObaWybA4c+VRnaP/20LYZbXb4+o8DN29wEnl2SVYlUiyj51QA6uoG6MsyJBcQ\r\nRR0G6leKSca3UtAoXZtLcWNn3BVS7cBsNHcwvlarqoaFLJrKSsWmZwjhkVOvt4h7\r\nB4LvrQd5lcnY6Wikl9yNl+QupqvLI5NYgMOmqb1eXmze1wFCHQexGHaN8Dmwwnjn\r\ncAob0I2q9ONTKAMX0NdsWQ0Wzhk4bE8bcrC4TqTTgKSql++zR4POaBrQIRejEDs3\r\nVsvAGvECgYEA6TM6zVNqKkcQ+vWpRdw9NEddIIzwNZImn2KnXI9MUV5g/VTwkK5o\r\n7kMjC/p413g6mSLMa63nIL2/p6OlK2uOcEH0Hpw1r0YX88cPfM2OHlq775N6LjaB\r\nAxYrER\r\n\r\nu3DoyrR+WdY2IAdkCqm2xwv9LVOxzoh2f/2R4mEYboFqKj7qMCgYEAwBa5\r\nrDilAJ8mr+X7PYnQ9oXgImz601ohxgDAEaC6oN/fzhKNDWpn/LxZAPj31p1CDTiJ\r\nO7xszc6jslZq5tPk7ciY2pyfyVH/hBQYj2M7bsQ0/IHyuFpxtS8V5VKdsEbYUq8I\r\nU3M4qAZBI3DUz5/Q1RDc4qf7ze6NsBkLXCbzasMCgYAs5goqQicsoKYqS2Yd5zt5\r\nd0v82mXdSphZE5t5fLWK7Qrre5EdqhbV2ONEiSL/CUzu8v48tSzM5vuhgSZp57ly\r\n75/azOShLHOsIeVfeAwm1/1bMR/TCfdo6rm7/4QNLxRDMXhODC5eljDC3+wNYsBf\r\nMz+p4mImIWHe+gRxZzr81QKBgA7wdYZQbXzL4+1gPJb/pfHWXaUvxp4zb1b/7fAx\r\nCPLEFprnVHMLqIS+fUmXE2dsmZt/nyS3NdsXzCFtmSjUqARaSpEOB1tX9kBmc7aL\r\nKC8oMVrGHIN7/UXzIIfSUhNIn0Bm/oXG+0wOGHjSKKrxKgO4KQWzvOC6QejFOd3z\r\n5ZCTAoGAbO6N7PsyH6yepHpwZ1otk7cnVJrAkc+es6pRjz9PiwBLv45uVQHF2+du\r\nwoAyVD5bey5scL1QiECNj3alfRXJDYcGU8FjlZ1VK8dvvdgEjex70G1uWu4vTMAj\r\nfJXh4x8qfegI+RIpsptRTzs7SHW1OJnMNGv4ypfB+s0StjZYcWc=\r\n-----END RSA PRIVATE KEY-----','2020-07-11 15:08:41','2020-07-11 15:29:07'),
(121,63,133,'-----BEGIN CERTIFICATE-----\r\nMIIGcjCCBVqgAwIBAgIQQ8B42ragroGYfAHhBlpjYTANBgkqhkiG9w0BAQsFADCB\r\nhTELMAkGA1UEBhMCUEwxIjAgBgNVBAoTGVVuaXpldG8gVGVjaG5vbG9naWVzIFMu\r\nQS4xJzAlBgNVBAsTHkNlcnR1bSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEpMCcG\r\nA1UEAxMgQ2VydHVtIERvbWFpbiBWYWxpZGF0aW9uIENBIFNIQTIwHhcNMjAwNzEx\r\nMTUyOTM5WhcNMjEwNzExMTUyOTM5WjAcMRowGAYDVQQDDBF3d3cuZmFyZmFsbGlu\r\nYS5pcjCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAK77H6PzuDGDfV7J\r\nR80rhDxDMpotZbOvctpyaRnBggAxaec/PEkK693ViKHIVdMUBvWRBOePMPvQV1u1\r\n1+NDs15JUKXToHinFGlCZMIPXJbNGggnHw0MZty4k4hJryeRSZxnvlwB55vm4mNK\r\noJzIFeSCMNwoFWEjCMcOluXhjTxBBkXiMHOFdvxFybGbhCFMk9Nn9bnYTwZ8bn/b\r\nvG++uh1whfF0VoY38HTibzBSdscSTM4/kGfAgS56+Y/vwsKhr53thq8u9Xb8O80m\r\nEhmWMAYQESaVZWM7Ywr3YKTZNofXLxlUp8bF/SXeWU9s3Avuud1ToiVFwlS7u5Kj\r\nMXpnRCkCAwEAAaOCA0QwggNAMAwGA1UdEwEB/wQCMAAwMgYDVR0fBCswKTAnoCWg\r\nI4YhaHR0cDovL2NybC5jZXJ0dW0ucGwvZHZjYXNoYTIuY3JsMHEGCCsGAQUFBwEB\r\nBGUwYzArBggrBgEFBQcwAYYfaHR0cDovL2R2Y2FzaGEyLm9jc3AtY2VydHVtLmNv\r\nbTA0BggrBgEFBQcwAoYoaHR0cDovL3JlcG9zaXRvcnkuY2VydHVtLnBsL2R2Y2Fz\r\naGEyLmNlcjAfBgNVHSMEGDAWgBTlMa2/OhGW9IO8UDzUt5CbkO7eJTAdBgNVHQ4E\r\nFgQUdr1sMNi7I8dAM6wUPEZSphrQpQwwHQYDVR0SBBYwFIESZHZjYXNoYTJAY2Vy\r\ndHVtLnBsMEsGA1UdIAREMEIwCAYGZ4EMAQIBMDYGCyqEaAGG9ncCBQEDMCcwJQYI\r\nKwYBBQUHAgEWGWh0dHBzOi8vd3d3LmNlcnR1bS5wbC9DUFMwHQYDVR0lBBYwFAYI\r\nKwYBBQUHAwEGCCsGAQUFBwMCMA4GA1UdDwEB/wQEAwIFoDArBgNVHREEJDAighF3\r\nd3cuZmFyZmFsbGluYS5pcoINZmFyZmFsbGluYS5pcjCCAX8GCisGAQQB1nkCBAIE\r\nggFvBIIBawFpAHcARJRlLrDuzq/EQAfYqP4owNrmgr7YyzG1P9MzlrW2gagAAAFz\r\nPn8LQgAABAMASDBGAiEAxMqv3bGkfeR4q/TzKjG71G+o6/1lvfEB7o3Je8v+vB0C\r\nIQDf5hb6eHtEGXUM5dCI5bY9PbPMLK7eVMtTdB9Y4vegjgB3APZclC/RdzAiFFQY\r\nCDCUVo7jTRMZM7/fDC8gC8xO8WTjAAABcz5/C20AAAQDAEgwRgIhAMzRm943SnJA\r\ndq8MS8w8DypYC3AOlGlftSm2s5+SA3jlAiEAh39Duud0MXnxD1UZn72kOxA9YdLU\r\nrsGspR8fAHp7QpcAdQBVgdTCFpA2AUrqC5tXPFPwwOQ4eHAlCBcvo6odBxPTDAAA\r\nAXM+fwyjAAAEAwBGMEQCIBXcuaiK76in8sTIYAaS1AfYFMAbVOD0O4zElwd3EnG4\r\nAiARg53DwoKhWi4J0pXMdjFQNqdH3d65GwP/KhWyij1RTTANBgkqhkiG9w0BAQsF\r\nAAOCAQEAXzdc15aRJFrBykpnZIvRe0WuIraYR/SndSmmzk7AFrfTBW0+zmPhC/3G\r\nwN++a2Gaqc80iLP1NppxzCWgcFL6enGBT2/Y1fFTdVX9X4Bj0r87R1zFqeI4HqAw\r\nJ+dR6wkscgj5l/DDBNV5qjvExfzbnhVcX+J3uqvAr9SfSqlRcQlBr8YsNKKGfegV\r\nKZDERATET+n862ZFW5irKAN5sMC2gU0fFjWATgW7Ibdmlqv3ZjHOak7gEEVraAET\r\nQnm64G2dTvqIMA2e32UgLXPp5sHGoQxr/qeb3F2TdbrONYVxw8w0dw8sePqyYOeq\r\nDm5r378fGMxXbZFg9qzaoNtk5SXeHg==\r\n-----END CERTIFICATE-----','2020-07-11 15:08:41','2020-07-11 15:47:24'),
(122,54,133,'-----BEGIN CERTIFICATE REQUEST-----\r\nMIIC1jCCAb4CAQAwYjEPMA0GA1UEBwwGdGVocmFuMQ8wDQYDVQQIDAZ0ZWhyYW4x\r\nCzAJBgNVBAYTAlVTMRowGAYDVQQDDBF3d3cuZmFyZmFsbGluYS5pcjEVMBMGA1UE\r\nCgwMY2VudHJhbCBob3N0MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA\r\nrvsfo/O4MYN9XslHzSuEPEMymi1ls69y2nJpGcGCADFp5z88SQrr3dWIochV0xQG\r\n9ZEE548w+9BXW7XX40OzXklQpdOgeKcUaUJkwg9cls0aCCcfDQxm3LiTiEmvJ5FJ\r\nnGe+XAHnm+biY0qgnMgV5IIw3CgVYSMIxw6W5eGNPEEGReIwc4V2/EXJsZuEIUyT\r\n02f1udhPBnxuf9u8b766HXCF8XRWhjfwdOJvMFJ2xxJMzj+QZ8CBLnr5j+/CwqGv\r\nne2Gry71dvw7zSYSGZYwBhARJpVlYztjCvdgpNk2h9cvGVSnxsX9Jd5ZT2zcC+65\r\n3VOiJUXCVLu7kqMxemdEKQIDAQABoC8wLQYJKoZIhvcNAQkOMSAwHjAcBgNVHREE\r\nFTATghF3d3cuZmFyZmFsbGluYS5pcjANBgkqhkiG9w0BAQsFAAOCAQEAgVXBRYP6\r\n2EEjK9qe3oE3v8PTu97XRw24l4TiYq78tGO8Q8yz4B7A/R1RVbM80I0+DFbUgYQ2\r\nu5T2W3ioxUfb/5WLKVODGorZq3tzNj1yUwKQHhvhjnsRl9xtxM5PyhyY638peyRk\r\nD9sqVZSa+bnfehTNAofOp6RhFFtLdp5LE3yCkEzcaXJanDUMFcMjm9/HS8h/Ac4h\r\nYoRogoNwkrlywyc5h0mcLDujGglY91UmvoGYSRhwZ92B7Y9ZENy7rxjfEKgH6PYE\r\n8vbaCgUPkE7YV1AmuhX2LKlj+XOpSBuYsDWba7yUVl5xed8jexJ8qhL8pjHIGFBL\r\nAQ97A7jaRvBJPw==\r\n-----END CERTIFICATE REQUEST-----','2020-07-11 15:08:41','2020-07-11 15:29:07'),
(123,45,106,'','2020-08-09 06:22:21','2020-08-09 06:22:21'),
(124,62,106,'-----BEGIN PRIVATE KEY-----\r\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDdY/vk+y0Emlyv\r\nfo/a2sa5ASIxXP5NALaG9O0Dg9QoUAzYqBI0kZP2zm0+hk0oJimZn7ixMYK5hDLr\r\nxuSxQyZmOwndXLIX8mWiSFt8aOTHKnaZrsTHUkGf1h/8XGmpLBV6rjXIIGN1TFi0\r\nHu0jmdFRwhv0okVbm5eteXT2Beiw/ugqUs2MUWKOOuZs4Sq1wbvNQ3vf4iKJY/nV\r\n8S1SQjcg/PiKy5ah6vvTmonLWX442CtfE3G05oU/H5sn5k3rsMIL9ZSP1wHRLD2r\r\nVr+Id2miv3esxAaPoFpwKoPIdi+ZPsFn3JKU0IoqXCpyDXhAMssXlqvYWak6ZcAd\r\nj3jRtPs5AgMBAAECggEASGqVEaBraE8JtEnkykS3rfpF8fmmIQ/zpI9nG7g6ZHlS\r\nymenlNRtntSE/We2w0RAZUTOh/9W8FHiyibD1YvOerAjGOpiQt0CC6Q5cKdq9g7Y\r\nvophSYWJe7vxuH2N/k0yNW/Ynb6iadLwTPK0xOlig6jHtiyCHWX2pkLNVFA4ffQ3\r\nbcVw7EUwg6cr1zcVJho1a+0p3xf8PAyvn/K2xIQdomM/e+I+kusWa8LduGtKg22a\r\nfhbLWcxXcv05I2ZwdmMmJOChnae8dyTVx/S2FzArvCxhSRs4IDezbOiXGKbDY2v7\r\nsdtmpguA74ZsjQFnlw/NnFhQm0K6xREQo+axNposUQKBgQD+RT7ix6K0gtt7AC8I\r\nFdKjaQrol+TFr4DEutbykgmfivpviFgBePg/v7t60PNkz1aG/w2UYiVb1DV9oK2T\r\nRtqOgZqEBFajTX76PWWqXsDc/FpWfBtNEebXtQounCVKSfFktpbYdxZI25rKAlZN\r\nAixMLba4Xs2azhN60paz1iGlZQKBgQDe5XxB+NTigeN633WGgVKKr7wqkim5I2Qs\r\nM5dljFKZlhIuQs9c+JZV6ncP5O1RqYOT3/1YPCDQYuS3TzgDoqHRSBeog9ep3p+O\r\nDqy8/BFYWhu9otF60H8bVII+rvmKLatO47PBGMswZcBWO5ntiFXm3dyxBdZb4ZTf\r\n4c6Kki7bRQKBgFAaNHNw/NrtFoOrTSW46kC8iMk5gMKeRWy0h56nTwzJ1ZdpVoAw\r\nQdSjbEaGqQarItEobHjAapCBS9Cl28i324ZlYe4RB9IuScA/s1V2wD9d6H+yXU9s\r\nQlLWH70LR9wda0SVGPRcn9KYDC1ziwh7lMTy6csvYopQPWbGDN/ep37ZAoGBAJKI\r\nMyP7vZga471HYi/GnMjntsAVzrATgCs+z2zGzxaA/frDmSb5lXtt5E/io9Fnq0Rv\r\noFF9VeUo3ktUHPLm25KF3me+JO1bmXD+XLjwzUZUFqCYhTZEEwuYhvdGeG5Kj7AR\r\nKX7sGcf7XHJURGFPm4lmmUsXF1DX/9Me03VtnLgxAoGBAJ8tkiy6vPFQ/tlyt3yA\r\nP9qIiybOS0/tMliFZFpgjNzWS8aNtjDYsZ+9XL9pMs64sYBB7Vyqp3unpUWyAOFt\r\nQ+t3YT0c5xiTpuHPXYyjEhGa10PGOf3iBS3Jjtb6P/ZXrMkA62TXIN33d03DcMBk\r\n6M8eiik8N4PkVO7D+6biANgM\r\n-----END PRIVATE KEY-----','2020-08-09 06:22:21','2020-08-09 06:22:21'),
(125,63,106,'','2020-08-09 06:22:21','2020-08-09 06:22:21'),
(126,54,106,'-----BEGIN PRIVATE KEY-----\r\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDdY/vk+y0Emlyv\r\nfo/a2sa5ASIxXP5NALaG9O0Dg9QoUAzYqBI0kZP2zm0+hk0oJimZn7ixMYK5hDLr\r\nxuSxQyZmOwndXLIX8mWiSFt8aOTHKnaZrsTHUkGf1h/8XGmpLBV6rjXIIGN1TFi0\r\nHu0jmdFRwhv0okVbm5eteXT2Beiw/ugqUs2MUWKOOuZs4Sq1wbvNQ3vf4iKJY/nV\r\n8S1SQjcg/PiKy5ah6vvTmonLWX442CtfE3G05oU/H5sn5k3rsMIL9ZSP1wHRLD2r\r\nVr+Id2miv3esxAaPoFpwKoPIdi+ZPsFn3JKU0IoqXCpyDXhAMssXlqvYWak6ZcAd\r\nj3jRtPs5AgMBAAECggEASGqVEaBraE8JtEnkykS3rfpF8fmmIQ/zpI9nG7g6ZHlS\r\nymenlNRtntSE/We2w0RAZUTOh/9W8FHiyibD1YvOerAjGOpiQt0CC6Q5cKdq9g7Y\r\nvophSYWJe7vxuH2N/k0yNW/Ynb6iadLwTPK0xOlig6jHtiyCHWX2pkLNVFA4ffQ3\r\nbcVw7EUwg6cr1zcVJho1a+0p3xf8PAyvn/K2xIQdomM/e+I+kusWa8LduGtKg22a\r\nfhbLWcxXcv05I2ZwdmMmJOChnae8dyTVx/S2FzArvCxhSRs4IDezbOiXGKbDY2v7\r\nsdtmpguA74ZsjQFnlw/NnFhQm0K6xREQo+axNposUQKBgQD+RT7ix6K0gtt7AC8I\r\nFdKjaQrol+TFr4DEutbykgmfivpviFgBePg/v7t60PNkz1aG/w2UYiVb1DV9oK2T\r\nRtqOgZqEBFajTX76PWWqXsDc/FpWfBtNEebXtQounCVKSfFktpbYdxZI25rKAlZN\r\nAixMLba4Xs2azhN60paz1iGlZQKBgQDe5XxB+NTigeN633WGgVKKr7wqkim5I2Qs\r\nM5dljFKZlhIuQs9c+JZV6ncP5O1RqYOT3/1YPCDQYuS3TzgDoqHRSBeog9ep3p+O\r\nDqy8/BFYWhu9otF60H8bVII+rvmKLatO47PBGMswZcBWO5ntiFXm3dyxBdZb4ZTf\r\n4c6Kki7bRQKBgFAaNHNw/NrtFoOrTSW46kC8iMk5gMKeRWy0h56nTwzJ1ZdpVoAw\r\nQdSjbEaGqQarItEobHjAapCBS9Cl28i324ZlYe4RB9IuScA/s1V2wD9d6H+yXU9s\r\nQlLWH70LR9wda0SVGPRcn9KYDC1ziwh7lMTy6csvYopQPWbGDN/ep37ZAoGBAJKI\r\nMyP7vZga471HYi/GnMjntsAVzrATgCs+z2zGzxaA/frDmSb5lXtt5E/io9Fnq0Rv\r\noFF9VeUo3ktUHPLm25KF3me+JO1bmXD+XLjwzUZUFqCYhTZEEwuYhvdGeG5Kj7AR\r\nKX7sGcf7XHJURGFPm4lmmUsXF1DX/9Me03VtnLgxAoGBAJ8tkiy6vPFQ/tlyt3yA\r\nP9qIiybOS0/tMliFZFpgjNzWS8aNtjDYsZ+9XL9pMs64sYBB7Vyqp3unpUWyAOFt\r\nQ+t3YT0c5xiTpuHPXYyjEhGa10PGOf3iBS3Jjtb6P/ZXrMkA62TXIN33d03DcMBk\r\n6M8eiik8N4PkVO7D+6biANgM\r\n-----END PRIVATE KEY-----','2020-08-09 06:22:21','2020-08-09 06:22:21'),
(127,45,134,'','2020-08-19 04:33:48','2020-08-19 04:33:48'),
(128,62,134,'','2020-08-19 04:33:48','2020-08-19 04:33:48'),
(129,63,134,'','2020-08-19 04:33:48','2020-08-19 04:33:48'),
(130,54,134,'','2020-08-19 04:33:48','2020-08-19 04:33:48'),
(131,45,135,'','2020-08-19 04:33:48','2020-08-19 04:33:48'),
(132,62,135,'','2020-08-19 04:33:48','2020-08-19 04:33:48'),
(133,63,135,'','2020-08-19 04:33:48','2020-08-19 04:33:48'),
(134,54,135,'','2020-08-19 04:33:48','2020-08-19 04:33:48'),
(135,45,136,'','2020-09-19 17:57:59','2020-09-19 17:57:59'),
(136,62,136,'-----BEGIN RSA PRIVATE KEY-----\r\nMIIEowIBAAKCAQEAwBn8RC6l3PbNCMh3+0Kx3s0KtvQHc5YJV40x2njn/SsHedYK\r\nd1IJFagCyH/nGorrPnGYcDGuuEHyv1tEpr3EnEDyKsOHKwtgWi4hdb7LLGVgezVW\r\nElXkwozLDtHXd3eUp3IqgmwOwj/GlP3nr6f2YxqdsSXaN5K32KfUT9eUPeBNpJ5p\r\nQIzCPehmcNTIFkwsrGCaL5L3JyKQpMzN/1KNZofyA/r1KvqpzOvNJFwM2MzZvKX5\r\npZ+/PM3eN9oxvRgs5V6+e/8ow4MrcFcETZko414oTsvKY53ygSLSDRpu6s3MCiIV\r\nB/jSg97+lr1dYcEywIqdnsnppTircCFO6raxJwIDAQABAoIBAQCf3gA+jcOi3BFN\r\n2edfxuVX0bO1BeidnKMxpWNzuWL3IbQbBLG5EyBUUXnfefHN+QZE9SwzUmVhGiD2\r\ndvHvAcZ5cuMWC5qVi+YnpnRaFOnojIV6g6yZnbm+3oSuVJvH5FBl+XC/EUZHCeQt\r\nYhBJ8rHtT90j66hqz0MInsLlnzbTNkF22uujz4Iej/Zol35GuZE3Us/mmj+OMLxj\r\nM82My+XxArVcGFwWx0UIs3GYK5pElAHabuf7YYEmPI/qeg9xW2/9Jvy8BligEp19\r\nVipRMM+0orPlbtJGFLYJMpcSHh0/GMuilqmqkHrhFJI8s1MZlCV5g9gczjMyo+nx\r\nj3C4VG/BAoGBAPFuy/2FGS/fR8Vbxgr+kF7RycwP0PUDAios7gq88VVcyd40RbGM\r\nx9dYM6FX4sss+vn2aEYjBISHTXHM1HjLY2jh25UNIwt5GBKwEoWhBwTwfTCBA3eD\r\n5/gZFAdiPB8PDDXc4E9IIELlOlbw2uu5O/xyHYR1oMTYqgRPAOx2mAx/AoGBAMux\r\nNflcDwCu3OlwdxPq6vyLK3iPDBXQw2UBCnyWKq7OR0G47PglSgd1X9Kss0xMDjma\r\nMNj+WMgH/ez597A3Z6sYo6cjQaEBl8Y79dQMSn1xgZsvYc/81gITmpwB+tWgSRfg\r\n+zH7lB5cPOMyba6PklcnuWlwxvynWVQZNzRcjSdZAoGAHsd0RB7Kxjqd6MA5cD9h\r\n4mS2aEh/6Cx5Ay11L3NFBQ/uQGDDnc4H0CFTe7c7l5FlcaaDRqXCNq8VJXPqhnfP\r\ndZiNqOPi2tyWQBOoWNbdkTijjSJ1cbAkS5HO5t4UMhV2BgvhoNneGwkkNd9A2Zpk\r\n1lsp/jAMzeudSS1VPdAktDsCgYBZ8NPOWZHeUVgGU7ygtNgxzxnQ0AkcEORWUxFY\r\nVc5fBYJ9SLSKFZ0Mkg1PryY0iFi3opfzGMwG91BuNSnjS3OhHu4UPQMbnuJvi8ZO\r\nbWbu4RHDfjaIajHtFM7uGAm0DmR4AMWqGlYa2cug3oGD1K1fgpDiOAQFR7ev5Lp1\r\ninBhcQKBgHBRCDe3wkuOBi7hdS6ZPYE7s7FR2Ms6k94WcaKWxkcJ8f6nAvaEVqdF\r\n+2jaRfPwbpuGEHglZuUDTiT6DIa7Z6XhDsGnm9AflxlXxW0Apyr3JqcHWFUUZwSI\r\n97MEZnBRjklrZ2jE8K/Crpi8XDj4qOklV7ivG4nKj1s+ESYZDUh6\r\n-----END RSA PRIVATE KEY-----','2020-09-19 17:57:59','2020-09-25 13:27:53'),
(137,63,136,'-----BEGIN CERTIFICATE-----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\r\n6zj7ODK0poHDucCfAA==\r\n-----END CERTIFICATE-----','2020-09-19 17:57:59','2020-09-25 13:34:16'),
(138,54,136,'-----BEGIN CERTIFICATE REQUEST-----\r\nMIIC3jCCAcYCAQAwZjEeMBwGA1UEAwwVc3RhdGljLmFiemFyaXN0LnRvb2xzMRUw\r\nEwYDVQQKDAxjZW50cmFsIGhvc3QxDzANBgNVBAcMBnRlaHJhbjEPMA0GA1UECAwG\r\ndGVocmFuMQswCQYDVQQGEwJVUzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoC\r\nggEBAMAZ/EQupdz2zQjId/tCsd7NCrb0B3OWCVeNMdp45/0rB3nWCndSCRWoAsh/\r\n5xqK6z5xmHAxrrhB8r9bRKa9xJxA8irDhysLYFouIXW+yyxlYHs1VhJV5MKMyw7R\r\n13d3lKdyKoJsDsI/xpT956+n9mManbEl2jeSt9in1E/XlD3gTaSeaUCMwj3oZnDU\r\nyBZMLKxgmi+S9ycikKTMzf9SjWaH8gP69Sr6qczrzSRcDNjM2byl+aWfvzzN3jfa\r\nMb0YLOVevnv/KMODK3BXBE2ZKONeKE7LymOd8oEi0g0aburNzAoiFQf40oPe/pa9\r\nXWHBMsCKnZ7J6aU4q3AhTuq2sScCAwEAAaAzMDEGCSqGSIb3DQEJDjEkMCIwIAYD\r\nVR0RBBkwF4IVc3RhdGljLmFiemFyaXN0LnRvb2xzMA0GCSqGSIb3DQEBCwUAA4IB\r\nAQCjpTbwHGG69mvNlkn6DX7zFVjuKf2/BF1Bvvf69S1P8LldrxE8OY8PsaeWZmrQ\r\n4XG5gYQ9KIvuPaEi/CHSGVbZu/Osx5o+4tljOTo7v06qOO5/wZfz9LwWyPb4WRzR\r\nwd3l69j9tyelJlivzvgqGidusaS9W02apoL62koY6FG8kgtbpp0GM1i2GnioeGE1\r\nvQm/tKOVtRuaAjud7IZ045T7auj1iCAgbGYrdJFhlPkS5G0gfqlCupLmoZhy1PZD\r\nPNTBn6LBY9Fye/il6mnf5n84El9A6TcavZLXISe0hQUCRidUR99wWJ2im7gEaq0r\r\nt+UdXxutOtL2Lp1s41DyY8jU\r\n-----END CERTIFICATE REQUEST-----','2020-09-19 17:57:59','2020-09-25 13:27:53'),
(139,45,137,'','2020-09-28 16:46:26','2020-09-28 16:46:26'),
(140,62,137,'-----BEGIN PRIVATE KEY-----\r\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQDXJDb/TlbObgTY\r\nK39Z/sXPjKXsnChsilrV6QBcifPeDwB+3fjmKpvR5kx6yckvKYY4wC3A6C2izman\r\npQHdKMutVl/ejpFdfuQLM9SSIg4USbEucC+Fr+YBfK/l5Nf5sWH56JeKmcZGXJ9o\r\nw470N0EQx5KXV5s/e6+zOwkLh8bHa74nhyZTr01smErKAwRQ+qVEGW7BAeFK52mO\r\n6cDB1R6RrwJrlxsHTvACxHUfEZISEiOoXx9yTZ+2Wr0A0mAXdZEhAOctyUTSbQ/V\r\ns6IERuYgPZEnjRkVNLaXpgmtoypYRD95/6JdX72xdjVHMQm2P/HhXIylKihPJ4sG\r\n9eKUrKu5AgMBAAECggEBANSUtzc8PDALrAPBrzvIr8LuUgFjJ9pgN3NIoQ/PTEWu\r\nAypYwRkFHySfcBCgFIfievrWgh8sC/PkCLE8LYRPTDpBr8ckjmSY/lJHa5LdzZWk\r\nX0volDx/20C66L+7iODzskES37KXUcCywtzs5vNPKZ6f5KxgZ0mqOKlb+wsGpZbj\r\nghEjipNlV9A3I+XC4nem20HgENXAFuHvA5x3H3oiWGhTGsGS6ZsE1X2eVMBSTZxt\r\nOsQt9OBuDu04pOIGKqbQ+itKivSCJ9JIEqbyYL3VzSNbNNbxIlgG72SxdLmNbHMQ\r\nD4mtKOSVduxUqGYaNkhZlMfce4fUvd0BhM7ErWs26QUCgYEA9m7ER2uG3kpSgTbO\r\nDswdPhh3Cu2w3SYiQY9PAMDcfKOUMk/WPtTIXN3JeDjunll2vaP7oFwSeHdUb45p\r\nFwowYyEzF3ubW0Ke5SUneYJBhDV2nAQzr/AVNwXmFH0RONyXMwt4lCH6cI8Hn31x\r\n2mfQ0hds0eLuEuhAVBx9Hr9EPycCgYEA335z1K0WxSyIDRnIsNVR5sMpKDUVmLLL\r\nb4/kEy/WbEo1knR3I7AjXsIeVRTR9FCvU3aFEjJ/Owv/dYSt0u/eFEhHpCyxm/tL\r\nW7WxylU8j9pmyEi2IP9rfWN8U/n+uX/VL/jwiqdDLctExNAU2ZkQW0iIstjYngjs\r\n3EhkEq5yih8CgYBAyNvm3rjFBYrtF0hSkYx6f5oEEHq3mMfWrmMZkpokViimlWCA\r\nghXufAv0BBuPG3vg3RRQkwP0EYLsFOdBvFb+KIMzADbWZgw5t2vKQNkSda+p0lz4\r\nOsiI/47+AeceKLfDHpfjcY9SOffKEQN2ZGZ8ZNYh02O9KruGoTqvc57wbwKBgA07\r\nR1BIDxkNUeC0rhUKDBdFZqJiwiyQKUspka8xHdi7bACHtKYAP5fUlkcjPGrie/7M\r\n/YPeSXoNc8pZWJEsclFxFgy6OKmrbwK29xerhDJgE8W3yFCbzplV0n6GRnZlAxIc\r\nAuGylV+YsTGVwCZB0Z4V5UHxZKG2lY9VGdehTFaxAoGAVAf6HHUQYMYwn1XpdgEu\r\nQJ4cq56QOgUEYG1Ji8YKlAHd9XCbdLg2vp42h7uJP8i3xA9xOAUVbVYe/xdYxv+U\r\na4AzAixNNYZfdYhBIDmLI4kb3XDcPNziRSKWt2O8TeraUbu/hc4TFdB5hHOo3vwD\r\nmF9ZdwZk580aVMo0UMTnuik=\r\n-----END PRIVATE KEY-----','2020-09-28 16:46:26','2020-09-28 17:55:11'),
(141,63,137,'-----BEGIN CERTIFICATE-----\r\nMIIGaTCCBVGgAwIBAgIQBsyg4X6pLEbAGivnAt83XzANBgkqhkiG9w0BAQsFADCB\r\nhTELMAkGA1UEBhMCUEwxIjAgBgNVBAoTGVVuaXpldG8gVGVjaG5vbG9naWVzIFMu\r\nQS4xJzAlBgNVBAsTHkNlcnR1bSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTEpMCcG\r\nA1UEAxMgQ2VydHVtIERvbWFpbiBWYWxpZGF0aW9uIENBIFNIQTIwHhcNMjAwOTI4\r\nMTc1MzMwWhcNMjEwOTI4MTc1MzMwWjAXMRUwEwYDVQQDDAxyYWhlc2FiYS5jb20w\r\nggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDXJDb/TlbObgTYK39Z/sXP\r\njKXsnChsilrV6QBcifPeDwB+3fjmKpvR5kx6yckvKYY4wC3A6C2izmanpQHdKMut\r\nVl/ejpFdfuQLM9SSIg4USbEucC+Fr+YBfK/l5Nf5sWH56JeKmcZGXJ9ow470N0EQ\r\nx5KXV5s/e6+zOwkLh8bHa74nhyZTr01smErKAwRQ+qVEGW7BAeFK52mO6cDB1R6R\r\nrwJrlxsHTvACxHUfEZISEiOoXx9yTZ+2Wr0A0mAXdZEhAOctyUTSbQ/Vs6IERuYg\r\nPZEnjRkVNLaXpgmtoypYRD95/6JdX72xdjVHMQm2P/HhXIylKihPJ4sG9eKUrKu5\r\nAgMBAAGjggNAMIIDPDAMBgNVHRMBAf8EAjAAMDIGA1UdHwQrMCkwJ6AloCOGIWh0\r\ndHA6Ly9jcmwuY2VydHVtLnBsL2R2Y2FzaGEyLmNybDBxBggrBgEFBQcBAQRlMGMw\r\nKwYIKwYBBQUHMAGGH2h0dHA6Ly9kdmNhc2hhMi5vY3NwLWNlcnR1bS5jb20wNAYI\r\nKwYBBQUHMAKGKGh0dHA6Ly9yZXBvc2l0b3J5LmNlcnR1bS5wbC9kdmNhc2hhMi5j\r\nZXIwHwYDVR0jBBgwFoAU5TGtvzoRlvSDvFA81LeQm5Du3iUwHQYDVR0OBBYEFJGv\r\nmZiYU/7JT1MG2u4hx3gj/38FMB0GA1UdEgQWMBSBEmR2Y2FzaGEyQGNlcnR1bS5w\r\nbDBLBgNVHSAERDBCMAgGBmeBDAECATA2BgsqhGgBhvZ3AgUBAzAnMCUGCCsGAQUF\r\nBwIBFhlodHRwczovL3d3dy5jZXJ0dW0ucGwvQ1BTMB0GA1UdJQQWMBQGCCsGAQUF\r\nBwMBBggrBgEFBQcDAjAOBgNVHQ8BAf8EBAMCBaAwKQYDVR0RBCIwIIIMcmFoZXNh\r\nYmEuY29tghB3d3cucmFoZXNhYmEuY29tMIIBfQYKKwYBBAHWeQIEAgSCAW0EggFp\r\nAWcAdQBElGUusO7Or8RAB9io/ijA2uaCvtjLMbU/0zOWtbaBqAAAAXTV2SIiAAAE\r\nAwBGMEQCIGvrTA8iJQyaAAos81w6LXOHE3Pf6Wn2hz73s/uy2vDrAiBmAlF6+hD/\r\nrmCah76A/6xOZG2V77DkWerta9TzAU2jpAB2APZclC/RdzAiFFQYCDCUVo7jTRMZ\r\nM7/fDC8gC8xO8WTjAAABdNXZIg0AAAQDAEcwRQIgDbnVuy8TPV2snTBYObTsbCZb\r\nmsQsJZoKnt+v+O/QM4gCIQDWmT4k6Z6YbsR+zDxxxv0rQwIdmlzeXQP7ZA9VaJMh\r\nWwB2AFWB1MIWkDYBSuoLm1c8U/DA5Dh4cCUIFy+jqh0HE9MMAAABdNXZI48AAAQD\r\nAEcwRQIhAOQ51dRw72ez1O4a6v3RNChNhEDaxVr83I7ZDkjwSg10AiAtv3uoiT9f\r\noR6EiocvyP6RzlCvu101QaUoT6XG5GE6+jANBgkqhkiG9w0BAQsFAAOCAQEARRL+\r\njZqkEmQvJJtFugS10TnAn1Qs48MDhoNpnUcV4dLhPjDQoTnf70OJGMwzAEV/Gul5\r\nGjAzeVaurLyK2t9gXJt5/QSPJ/rhbnS/YObcf8MtQGvYINenuGyzYT+eCfXnO0D+\r\nzGOvMtBsEyD4xNbeYl4jI1VDgtF1q5B5oAnub12hjzaDFPjPoa+oB/iR7oeoy/Zd\r\nzLyZOw8xscFdVViFaxsNcQ72OHexYFVqoEhcc9HVHrcxuqvqD8Kn2djaaxL+rVgC\r\n2uOS6CcQJjefoTkmFFUxXuL8lQFW8MKEu7PzYqm/iynmttU98X67/rZwxPeYlIAo\r\nnYUWBjkkIUQeD3cXMw==\r\n-----END CERTIFICATE-----','2020-09-28 16:46:26','2020-09-28 17:55:11'),
(142,54,137,'','2020-09-28 16:46:26','2020-09-28 16:46:26'),
(143,3,30,'09120289276','2020-10-06 05:15:34','2020-10-06 05:15:34'),
(148,45,142,'weplancer.com','2021-06-27 06:18:27','2021-06-27 06:18:27'),
(149,62,142,'-----BEGIN PRIVATE KEY-----\r\nMIIEvgIBADANBgkqhkiG9w0BAQEFAASCBKgwggSkAgEAAoIBAQDxzvPoLeAeWe5g\r\nbnr1HRWJbYwceN8pEKMu49RQZ8U1ChEDhWH+succKr5hyGVsa0VG9pJxKoyI5JSW\r\n2CqNBb1w6Hbm5oz+3odD797ExokUKORJcTDF1CNF01mNnLCFZtI/wqA8aHc7EdCq\r\nZeCzHwxHzfkI6vbQXOMbLTp8PMwpybrmhX41xkPyvWUGsIFI9zcM2HhV8M1iitfS\r\nstA06+O0mULuy0UA6ITm89ZCBzch3/4kz+CcQO/aV+K8EZ1gH2LSZqKE1oVkEpry\r\n2yBYA1sMua7E7o8X2z9riFZxDRfqhZ5AOjfHXtspQI/R4kqu/0J+2pnyqfQxeFsC\r\nFC0m49zZAgMBAAECggEBAOTqsjd8rq6tHqHGFbtU5F2tCratqz56FLJAV3AjPSwA\r\nMqktrd7sySP+RyvVBkeEqhoLNgnSaSbzlsPTMz08UOLCAEaJvrNOQaoMPM320jD2\r\noV/xu2WddiMVebM5wlcYRzS7cOyfTTjrnaqjNfz9CKg1k2xg3HXXad0BjVuuRu3K\r\nyF+RbFzcPjPqqRFRvswL6B5yUgbLtvDyJGeC0WLT09Jfz76cZzN62kzEIonT1h04\r\nTuqkTfE6wNmQo2YElFz/PPLPkqEXKCXw0EDWwsCcwKBnkxA2m32MESx8kEHhi6uR\r\nHHzCHWYOco+YNa1OD1fgDvlicieHP0f9R+11kQwLS00CgYEA/uizPXHeP7+SNkEY\r\npgyhb6gQzDnzw8w26hBt1j3ni3EbKgmIvaYF0bhyeuQQ37CHwcmpNHUuwSsky40Q\r\nwhSsmJaWpYcZcIySTkGP4x0taVfc9OUpeEJI9xt7sDwovF4M/um76ooctzXqoD4q\r\ndYiXFrpu8TNlhvYWfJ6KpQnxOAsCgYEA8tfmBIOE4GvTYLtKeUTVA0Z72yjZzAJ4\r\nZgWLtSmYPZU+8yj0BmVrYEjKlTIKsSyiSZ81C68DWkJxr0m9s512OSHtRRXDFYF2\r\nYSSupPoKVljmw1te5LeXrTDvXvmFeEymApOxwi/HXzbsXd0CGupj3jSwEq67aOPn\r\nuNZtrH/POSsCgYATpWWjF7KUYTRooA3BRnnuvBpHUzQZZBTbZ1a/y1ecJKR+UevL\r\nCg+qwTd5hzhRtS5RXjR/SYTH+IZGdeHTw3ol7H1B1q68QOlJxL3NOEN2ugHakgrn\r\nLNyoxuJ6i7hsBCemQedsxSY/bJVfskrdciCK7OV+C4MIqtDC3Ak9fQ2tTwKBgDNy\r\nQaybID9bGIDZrMFcL7Rt7jdTxDBQJamXay2KDlKdl6Rz/J6ORd00Dpbk7xbx2b+3\r\nFsnO3er1QJheCu5OYYlhAp8sKRQZRTb3Snhw8FeypdClPsk9i8iJIW0Bd6Ewu8q3\r\n92SoMpidTh3kgFmrZlTg3JxYoCNshN7Hrpxox0HZAoGBAOKhfx9N1pAZfLLMDSgW\r\nUmoJSyG211/F+QFY1kxfKFSfY5h5zL1VER5m+v6KEKfwXcjBOQVwM3AZgS3t3el2\r\nSZinTECl1VIA3anthbLkLsw4uVfMFy5AZkdXSyMTXd6gp+cTt3qEaMQMhgMa1jxj\r\nI8LaT4sjObv+5ed5zQjjX2mz\r\n-----END PRIVATE KEY-----','2021-06-27 06:18:27','2021-06-27 06:24:21'),
(150,63,142,'-----BEGIN CERTIFICATE-----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\r\ncHFg+WMoD8j5UcBfN5xet9etxx9N\r\n-----END CERTIFICATE-----','2021-06-27 06:18:27','2021-06-27 06:24:21'),
(151,54,142,'','2021-06-27 06:18:27','2021-06-27 06:18:27'),
(152,45,144,'abzarist.com','2021-06-29 16:53:07','2021-06-29 16:53:07'),
(153,62,144,'-----BEGIN PRIVATE KEY-----\r\nMIIEvwIBADANBgkqhkiG9w0BAQEFAASCBKkwggSlAgEAAoIBAQCp70kV4xU6aH8N\r\naGVEHFr9HtGFMBsbQ55QrqAPoFXSs8HNR74VRoYZvE9S7hMf0W9PYeeptpIW4Mut\r\nPEgIIH+FMeJvHlFPZZcQLyoffdp0HyRkWuWR/tKMQuV5kFl5XwTjQdClP26fpkA0\r\nJCXxKRdsMFj5DUAp/RD+VEgdfQk7XvCJnajlK3V0TS8GGD1x6mWJNytWqvEt4XvW\r\nj2X7YSGktgw4lvgwcfNug/a5ZWFvODnZB/AXc+lrKFIYtldOd00BCruiJzI4EB/u\r\nszJfee7YpQj4Tc7LJQ6Lc1t4LQEqa/cjlabwNEK8+ZJDVOMmkqDC8Kd9Nl0eteGe\r\nx77DnDSLAgMBAAECggEAbkf20zhql1wnT+k3BsusFOaCLIA6pyfrvwqEn397EuFL\r\nXVA4wI/jCSKXDAeq65Q8O3UbJZ1xE13RcFxVlsiYWTU1cM1pETCpp3wkRwmi0oc/\r\nU81VfLi1pQbo60pNdqG+h0k4AXW38e2vbucipG35YGHD6+S4hkdQVu0VW+XALwFv\r\n0iHdD7o2Bgn7nXihg5W/L6v7/+dLTjdMTuTgf8iWvTwaAKo0PoHZms2NXBu6VIfX\r\nxj2nUbyCgFDXramHhxOsqH44CfYXfZ9syLCjW8oameaUXPZOu9B982e1AXYqFyll\r\nOCSTPhy8Lys7xTsagJPWc+RxmW59HfN6kurFj83YqQKBgQDcXYyACEZ1fsejPzLE\r\nq/XEpCH2Wq/+RNVgoyd1fmnNpJCexnpLtX7ScTUYuRqAj5BCGi+xvREumA+00RJY\r\nTnumL3BWRnXjQkrC2cHOJg4VivUevGvE9M8OFn6edSdhcBVUmU6H1h6gu3lkYU2k\r\ntFB2UJORi8z9ZpLoIpiUvsKyTwKBgQDFag9e6s2ZU0H3FuUwX67NRX2IXLGrrUFr\r\nrnpthpihw0y4Eot+H2LRv+ZeMVqdpn3HHD9DhvVaxbCAWUys4I5NtFOmWIH4oRaT\r\n0CpsLEpvKv9uptbKXVyngz3R+0GZ8QgKbWAJ1QbtIZ3GlGTqVjghuHmkwPyzeROX\r\nrX84yVR3BQKBgQCKs48Vnx/KIIxDoimwRJQiuzRtPVN89ZJgixDxESpDN4uXhFHB\r\niXFTv9GtyAR4WuRv1s+iTeCctTVdmCK11mBZj45jn2HgMv+feTRVLvq6cIYsXGhw\r\nxa31rg7wacjpuYSThRM6yHjqrlWP6vbV7nCep8TaXWYfMQrSdcQYC6G8XQKBgQC6\r\nOg3b7UYcEFVXAMsdcfWVAKul+kNEfwEK0qH9Ng4/8tspfZ0HUhZHZW6shoRD2a4n\r\nKTdovSQxB/IzcYoKPx8eoDCU6ENbRqLkt2d9ed6Rtg8V098lMSNZhk3ICuxciuqZ\r\n44nIXKPXCHIsxQnZoZH8BWkDCWaY62uXFvy/lfTO/QKBgQCLt1VYbneSLZwdpYi3\r\nbzIwTJuqN0CMRcnr3KXn/IBvEXB0ZTUHlxUv6qADNhOCJusIEmaKcIDbBoPpgP9l\r\nGFFzvA58QK808jOqdcRDZ7ZUuyzbGZe7SCgGCgXyDeEpzpMgKt7JA6SgvgcAy6r/\r\ncqk+dz3YXpiVKoDb767OjTZBnQ==\r\n-----END PRIVATE KEY-----','2021-06-29 16:53:07','2021-06-29 17:13:23'),
(154,63,144,'-----BEGIN CERTIFICATE-----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\r\nhnzHNvKgdJP1157gT+4uus4=\r\n-----END CERTIFICATE-----','2021-06-29 16:53:07','2021-06-29 17:13:23'),
(155,54,144,'-----BEGIN CERTIFICATE REQUEST-----\r\nMIIC4TCCAckCAQAwgYwxCzAJBgNVBAYTAlVTMQ4wDAYDVQQIDAVzZGZzZDEOMAwG\r\nA1UEBwwFZHNmc2QxDjAMBgNVBAoMBWZzZGZzMQ8wDQYDVQQLDAZmc2ZzZGYxGTAX\r\nBgNVBAMMEHd3dy5hYnphcmlzdC5jb20xITAfBgkqhkiG9w0BCQEWEmFkbWluQGFi\r\nemFyaXN0LmNvbTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKnvSRXj\r\nFTpofw1oZUQcWv0e0YUwGxtDnlCuoA+gVdKzwc1HvhVGhhm8T1LuEx/Rb09h56m2\r\nkhbgy608SAggf4Ux4m8eUU9llxAvKh992nQfJGRa5ZH+0oxC5XmQWXlfBONB0KU/\r\nbp+mQDQkJfEpF2wwWPkNQCn9EP5USB19CTte8ImdqOUrdXRNLwYYPXHqZYk3K1aq\r\n8S3he9aPZfthIaS2DDiW+DBx826D9rllYW84OdkH8Bdz6WsoUhi2V053TQEKu6In\r\nMjgQH+6zMl957tilCPhNzsslDotzW3gtASpr9yOVpvA0Qrz5kkNU4yaSoMLwp302\r\nXR614Z7HvsOcNIsCAwEAAaAPMA0GCSqGSIb3DQEJDjEAMA0GCSqGSIb3DQEBCwUA\r\nA4IBAQCO2LFEFdO/niuyytHrozgp9DE3sIkwTXH3mlJ325m8biM/pb4btuvZcw8H\r\nnty8Bm9Ezymq0E8y3mzSGtC7QXwb/dMiTzvoL5Xppw57LedNnDH94WKG1oVY6Nms\r\ncOkkkflehhqsTuAptn886F8YnKpUNVRjznYeMSzy5Cmp+sU2QgcF6jzB/nTnEesQ\r\nFj8fUBHyLpPsiZQ/5qnO3AhGO6X3HCopyYlZoGPJsEal/d6Bkdl7oMaxTaf8YiLV\r\naJLXnybk5JTY0rzKz6HwPKUjpf/w9ukEfL6yIR5cS5PctHC77bPtMB2XRauChvR/\r\nYfmXB86LbRbG5gfnmZf64X/oMz0E\r\n-----END CERTIFICATE REQUEST-----','2021-06-29 16:53:07','2021-06-29 17:13:24'),
(156,3,31,'914 222 9341','2021-08-05 14:45:41','2021-08-05 14:45:41'),
(157,4,147,'php','2021-08-05 14:45:48','2021-08-05 14:45:48'),
(158,5,147,'100','2021-08-05 14:45:48','2021-08-05 14:45:48'),
(159,6,147,'سایت فروش هاستینگ و سرور مجازی','2021-08-05 14:45:48','2021-08-05 14:45:48'),
(160,3,32,'09121799081','2021-08-28 05:29:50','2021-08-28 05:29:50'),
(161,3,33,'09027776670','2021-09-01 13:00:01','2021-09-01 13:00:01'),
(162,3,34,'09127243318','2021-09-14 04:42:35','2021-09-14 04:42:35'),
(163,3,35,'09122450268','2021-09-18 11:11:06','2021-09-18 11:11:06'),
(164,68,151,'Centos 7.X 64Bit','2021-09-18 14:15:46','2021-09-18 14:15:46'),
(165,69,151,'','2021-09-18 14:15:46','2021-09-18 14:15:46'),
(166,68,152,'Centos 7.X 64Bit','2021-09-18 16:32:52','2021-09-18 16:32:52'),
(167,69,152,'','2021-09-18 16:32:52','2021-09-18 16:32:52'),
(168,3,36,'09122488373','2021-09-26 06:50:28','2021-09-26 06:50:28'),
(169,45,154,'','2021-09-29 08:22:21','2021-09-29 08:22:21'),
(170,62,154,'','2021-09-29 08:22:21','2021-09-29 08:22:21'),
(171,63,154,'','2021-09-29 08:22:21','2021-09-29 08:22:21'),
(172,54,154,'','2021-09-29 08:22:21','2021-09-29 08:22:21'),
(173,45,155,'','2021-10-29 10:13:25','2021-10-29 10:13:25'),
(174,62,155,'','2021-10-29 10:13:25','2021-10-29 10:13:25'),
(175,63,155,'','2021-10-29 10:13:25','2021-10-29 10:13:25'),
(176,54,155,'','2021-10-29 10:13:25','2021-10-29 10:13:25'),
(177,3,37,'۰۹۱۹۱۷۷۲۲۱۷','2021-11-08 06:28:43','2021-11-08 06:28:43'),
(178,3,38,'09036124888','2021-11-08 06:41:40','2021-11-08 06:41:40'),
(186,96,156,'','2021-12-19 08:56:13','2021-12-19 08:56:13'),
(185,91,156,'','2021-12-19 08:56:13','2021-12-19 08:56:13'),
(184,86,156,'','2021-12-19 08:56:13','2021-12-19 08:56:13'),
(187,45,158,'redbazar.ir','2022-02-18 05:38:57','2022-02-18 05:38:57'),
(188,62,158,'','2022-02-18 05:38:57','2022-02-18 05:38:57'),
(189,63,158,'','2022-02-18 05:38:57','2022-02-18 05:38:57'),
(190,54,158,'','2022-02-18 05:38:57','2022-02-18 05:38:57'),
(191,3,39,'09035879726','2022-02-22 16:19:17','2022-02-22 16:19:17'),
(192,16,159,'centos 7 ','2022-02-23 09:33:22','2022-02-23 09:33:22'),
(193,17,159,'185.208.175.23','2022-02-23 09:33:22','2022-02-23 09:33:22'),
(194,119,159,'5690','2022-02-23 09:33:22','2022-02-23 09:33:22'),
(195,120,159,'E4vzVDIweOky8raeUbTBi7UnR4OG0No9wcfez3G6q4bobfWx','2022-02-23 09:33:22','2022-07-24 14:03:12'),
(196,22,160,'185.208.175.23','2022-02-23 09:39:34','2022-02-23 09:39:34'),
(197,24,160,'','2022-02-23 09:39:34','2022-02-23 09:39:34'),
(198,101,53,'','2022-02-24 08:31:05','2022-02-24 08:31:05'),
(199,68,161,'Windows server 2016','2022-03-02 06:45:29','2022-03-02 06:45:29'),
(200,69,161,'','2022-03-02 06:45:29','2022-03-02 06:45:29'),
(201,3,40,'09122094843','2022-03-12 14:47:02','2022-03-12 14:47:02'),
(202,123,162,'Windows server 2016','2022-03-12 15:54:10','2022-03-12 15:54:10'),
(203,124,162,'windows 2019','2022-03-12 15:54:10','2022-03-12 15:54:10'),
(204,45,163,'redbazar.net','2022-03-13 17:08:13','2022-03-13 17:08:13'),
(205,62,163,'','2022-03-13 17:08:13','2022-03-13 17:08:13'),
(206,63,163,'','2022-03-13 17:08:13','2022-03-13 17:08:13'),
(207,54,163,'','2022-03-13 17:08:13','2022-03-13 17:08:13'),
(208,3,41,'09374912999','2022-04-25 15:34:19','2022-04-25 15:34:19'),
(209,68,165,'Centos 7.X 64Bit','2022-06-21 04:17:11','2022-06-21 04:17:11'),
(210,69,165,'','2022-06-21 04:17:11','2022-06-21 04:17:11'),
(213,3,42,'09175294600','2022-06-28 11:51:48','2022-06-28 11:51:48'),
(214,43,167,'Windows server 2016','2022-06-28 11:51:55','2022-06-28 11:51:55'),
(215,65,167,'','2022-06-28 11:51:55','2022-06-28 11:51:55'),
(216,64,43,'on','2022-08-11 15:05:02','2022-09-18 07:38:09'),
(217,3,43,'09123952369','2022-08-11 15:05:02','2022-09-18 07:36:47'),
(218,3,44,'09128436084','2022-08-20 04:09:54','2022-08-20 04:09:54'),
(219,3,45,'09121061222','2022-08-27 08:31:48','2022-08-27 08:31:48'),
(220,3,46,'۰۹۰۱۵۵۵۵۴۲۳','2022-08-27 10:00:32','2022-08-27 10:00:32'),
(221,45,175,'ironcenter.ir','2022-08-28 10:27:25','2022-08-28 10:27:25'),
(222,54,175,'','2022-08-28 10:27:25','2022-08-28 10:27:25'),
(223,3,47,'09354064158','2022-09-03 17:28:01','2022-09-03 17:28:01'),
(224,3,48,'09165146079','2022-09-04 18:55:56','2022-09-04 18:55:56'),
(225,62,175,'','2022-09-05 06:32:04','2022-09-05 06:32:04'),
(226,63,175,'','2022-09-05 06:32:04','2022-09-05 06:32:04'),
(227,3,49,'09124931609','2022-09-06 19:46:21','2022-09-06 19:46:21'),
(228,45,179,'konaherbs.com','2022-09-06 20:19:43','2022-09-07 09:04:43'),
(229,62,179,'','2022-09-06 20:19:43','2022-09-06 20:19:43'),
(230,63,179,'-----BEGIN CERTIFICATE-----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\r\n27/U9bSKnDSwjOEUReJ2yqnl/3yLaa9NCdwOBL22ZiBxkyA=\r\n-----END CERTIFICATE-----','2022-09-06 20:19:43','2022-09-07 09:04:43'),
(231,54,179,'','2022-09-06 20:19:43','2022-09-06 20:19:43'),
(232,64,49,'','2022-09-07 06:59:15','2022-09-07 06:59:15'),
(233,3,50,'09359923631','2022-09-10 14:54:22','2022-09-10 14:54:22'),
(234,3,51,'','2022-09-10 15:07:19','2022-09-10 15:07:19'),
(235,74,181,'centos-7.4-x86_64','2022-09-10 15:31:44','2022-09-10 15:31:44'),
(236,75,181,'','2022-09-10 15:31:44','2022-09-10 15:31:44'),
(237,158,181,'آلمان','2022-09-10 15:31:44','2022-09-10 15:31:44'),
(238,3,52,'09369204423','2022-09-13 19:47:22','2022-09-13 19:47:22'),
(239,74,182,'','2022-09-13 19:58:32','2022-09-13 19:58:32'),
(240,75,182,'','2022-09-13 19:58:32','2022-09-13 19:58:32'),
(241,158,182,'آلمان','2022-09-13 19:58:32','2022-09-13 19:58:32'),
(242,193,183,'wptheme2','2022-09-15 19:37:23','2022-09-15 19:37:23'),
(243,3,53,'09123399076','2022-09-19 10:11:28','2022-09-19 10:11:28'),
(244,3,54,'09364098185','2022-09-27 11:17:30','2022-09-27 11:17:30'),
(245,126,184,'ubuntu-20.04-x86_64','2022-09-27 11:17:37','2022-09-27 19:02:27'),
(246,3,55,'09368472328','2022-09-27 12:41:37','2022-09-27 12:41:37'),
(247,126,185,'ubuntu-20.04-x86_64','2022-09-27 12:41:41','2022-09-27 17:22:38'),
(248,125,185,'28','2022-09-27 17:21:50','2022-09-27 17:36:26'),
(249,127,185,'','2022-09-27 17:21:50','2022-09-27 17:21:50'),
(1138,214,456,'','2022-12-30 18:49:27','2023-01-31 11:13:54'),
(251,125,184,'','2022-09-27 19:02:27','2022-11-30 21:00:28'),
(252,127,184,'','2022-09-27 19:02:27','2022-09-27 19:02:27'),
(1139,214,432,'WjgHjIcmoA7r1Un9','0000-00-00 00:00:00','2023-02-10 09:53:15'),
(659,145,330,'ubuntu-20.04-x86_64','2022-12-01 10:41:37','2022-12-01 10:41:37'),
(254,3,56,'09196411626','2022-09-30 19:05:03','2022-09-30 19:05:03'),
(255,159,186,'','2022-09-30 19:53:51','2022-09-30 19:53:51'),
(256,160,186,'5.161.148.136','2022-09-30 19:53:51','2022-09-30 19:56:30'),
(257,125,187,'29','2022-09-30 21:19:44','2022-09-30 21:19:44'),
(258,126,187,'ubuntu-20.04-x86_64','2022-09-30 21:19:44','2022-09-30 21:19:44'),
(259,127,187,'','2022-09-30 21:19:44','2022-09-30 21:19:44'),
(1137,127,456,'','2022-12-30 18:49:27','2022-12-30 18:49:27'),
(261,125,188,'','2022-10-02 06:55:28','2022-10-02 06:55:28'),
(262,126,188,'ubuntu-20.04-x86_64','2022-10-02 06:55:28','2022-10-02 06:55:28'),
(263,127,188,'','2022-10-02 06:55:28','2022-10-02 06:55:28'),
(1598,145,578,'','2023-02-01 15:01:00','2023-02-01 15:01:00'),
(265,125,190,'107','2022-10-04 19:35:37','2022-11-23 09:17:09'),
(266,126,190,'centos-7.9-x86_64','2022-10-04 19:35:37','2023-02-02 12:17:21'),
(267,127,190,'','2022-10-04 19:35:37','2022-10-04 19:35:37'),
(1136,125,456,'','2022-12-30 18:49:27','2023-01-31 11:12:20'),
(269,134,191,'ویندوز','2022-10-04 20:27:03','2022-10-04 20:27:03'),
(270,129,191,'','2022-10-04 20:57:47','2022-11-05 08:12:18'),
(271,138,191,'','2022-10-04 20:57:47','2022-10-04 20:57:47'),
(1057,214,354,'','2022-12-27 17:31:29','2022-12-27 17:31:29'),
(273,3,57,'09123866891','2022-10-05 10:32:25','2022-10-05 10:32:25'),
(274,3,58,'09125545413','2022-10-05 12:59:17','2022-10-05 12:59:17'),
(275,45,192,'galacticstarco.com','2022-10-06 16:41:06','2022-10-06 16:41:06'),
(276,54,192,'','2022-10-06 16:41:06','2022-10-06 16:41:06'),
(277,125,193,'91','2022-10-06 22:02:04','2022-11-14 12:40:38'),
(278,126,193,'ubuntu-20.04-x86_64','2022-10-06 22:02:04','2022-11-14 12:40:38'),
(279,127,193,'','2022-10-06 22:02:04','2022-10-06 22:02:04'),
(281,145,194,'centos-7.4-x86_64','2022-10-06 22:02:04','2022-10-07 11:57:39'),
(282,152,194,'آلمان','2022-10-06 22:02:04','2022-10-07 11:57:39'),
(283,62,192,'-----BEGIN RSA PRIVATE KEY-----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\r\n+K5GhIuaBxyx0gpsTFVRCyeh6W4qzgjX87CDNZWek/5B6Vet38TBNe6KFRw=\r\n-----END RSA PRIVATE KEY-----','2022-10-08 12:15:52','2022-10-08 12:16:59'),
(284,63,192,'-----BEGIN CERTIFICATE-----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\r\nQAXy\r\n-----END CERTIFICATE-----','2022-10-08 12:15:52','2022-10-08 12:16:59'),
(287,126,195,'ubuntu-20.04-x86_64','2022-10-08 19:25:22','2022-10-12 09:34:28'),
(288,145,196,'centos-7.4-x86_64','2022-10-08 19:25:22','2022-10-08 19:25:22'),
(289,152,196,'آلمان','2022-10-08 19:25:22','2022-10-08 19:25:22'),
(1336,3,199,'09199519001','2023-01-12 22:15:57','2023-01-12 22:15:57'),
(292,145,198,'ubuntu-20.04-x86_64','2022-10-12 08:42:46','2022-10-12 08:42:46'),
(293,152,198,'آلمان','2022-10-12 08:42:46','2022-10-12 08:42:46'),
(294,126,199,'ubuntu-20.04-x86_64','2022-10-12 08:42:46','2022-10-12 08:42:46'),
(295,125,195,'86','2022-10-12 09:34:28','2022-11-12 09:04:58'),
(296,127,195,'','2022-10-12 09:34:28','2022-10-12 09:34:28'),
(1134,3,166,'09380836364','2022-12-30 13:56:18','2022-12-30 13:56:18'),
(298,125,199,'40','2022-10-12 09:37:32','2022-10-12 09:37:32'),
(299,127,199,'','2022-10-12 09:37:32','2022-10-12 09:37:32'),
(1133,214,455,'','2022-12-30 08:46:11','2022-12-30 08:46:11'),
(301,3,59,'09362768686','2022-10-13 19:57:06','2022-10-13 19:57:06'),
(302,126,200,'centos-7.9-x86_64','2022-10-13 20:09:13','2023-01-16 09:19:04'),
(303,125,200,'51','2022-10-13 20:37:45','2022-10-20 07:30:14'),
(304,127,200,'','2022-10-13 20:37:45','2022-10-13 20:37:45'),
(1132,127,455,'','2022-12-30 08:46:11','2022-12-30 08:46:11'),
(306,3,60,'09228492709','2022-10-15 08:16:50','2022-10-15 08:16:50'),
(307,126,201,'windows-server-2022','2022-10-15 08:39:17','2022-10-15 17:39:36'),
(308,145,202,'ubuntu-20.04-x86_64','2022-10-15 08:39:17','2022-10-15 08:39:17'),
(309,152,202,'آلمان','2022-10-15 08:39:17','2022-10-15 08:39:17'),
(310,125,201,'','2022-10-15 10:43:38','2022-10-17 15:18:19'),
(311,127,201,'','2022-10-15 10:43:38','2022-10-15 10:43:38'),
(1145,198,228,'','2022-12-31 09:12:44','2022-12-31 09:12:44'),
(313,3,61,'09124868648','2022-10-15 19:02:01','2022-10-15 19:02:01'),
(314,3,62,'09940725790','2022-10-17 14:50:33','2022-10-17 14:50:33'),
(315,134,205,'انتخاب کنید','2022-10-17 15:15:51','2023-02-03 17:09:02'),
(316,129,205,'48','2022-10-17 15:39:16','2023-02-03 17:09:09'),
(317,138,205,'','2022-10-17 15:39:16','2022-10-17 15:39:16'),
(1056,214,353,'qv9hBvCluGw0i3zO','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(319,3,63,'09388739168','2022-10-18 21:23:06','2022-10-18 21:23:06'),
(320,125,206,'','2022-10-18 21:28:57','2022-10-18 21:28:57'),
(321,126,206,'centos-7.9-x86_64','2022-10-18 21:28:57','2023-01-21 12:40:31'),
(322,127,206,'','2022-10-18 21:28:57','2022-10-18 21:28:57'),
(1131,125,455,'','2022-12-30 08:46:11','2022-12-30 08:46:11'),
(324,125,207,'','2022-10-18 21:28:57','2022-10-18 21:28:57'),
(325,126,207,'windows-2019Server','2022-10-18 21:28:57','2022-10-20 07:35:44'),
(326,127,207,'','2022-10-18 21:28:57','2022-10-18 21:28:57'),
(328,145,208,'','2022-10-18 21:28:57','2022-10-18 21:28:57'),
(329,152,208,'آلمان','2022-10-18 21:28:57','2022-10-18 21:28:57'),
(330,145,209,'','2022-10-18 21:28:57','2022-10-18 21:28:57'),
(331,152,209,'آلمان','2022-10-18 21:28:57','2022-10-18 21:28:57'),
(332,145,210,'ubuntu-20.04-x86_64','2022-10-19 20:19:12','2022-10-19 20:19:12'),
(333,152,210,'آلمان','2022-10-19 20:19:12','2022-10-19 20:19:12'),
(334,145,211,'ubuntu-20.04-x86_64','2022-10-19 20:19:12','2022-10-19 20:19:12'),
(335,152,211,'فنلاند','2022-10-19 20:19:12','2022-10-19 20:19:12'),
(336,3,64,'09121216749','2022-10-21 12:34:22','2022-10-21 12:34:22'),
(337,126,213,'centos-7.9-x86_64','2022-10-21 20:08:12','2023-02-22 13:49:33'),
(338,125,213,'53','2022-10-21 20:13:25','2023-01-12 22:55:46'),
(339,127,213,'','2022-10-21 20:13:25','2022-10-21 20:13:25'),
(1338,214,213,'qwhNHltdw85xkswd','2023-01-12 22:55:38','2023-02-22 13:49:33'),
(341,145,214,'ubuntu-20.04-x86_64','2022-10-22 11:24:33','2022-10-22 11:24:33'),
(342,152,214,'آمریکا','2022-10-22 11:24:33','2022-10-22 11:24:33'),
(343,3,65,'09330533676','2022-10-23 18:20:29','2022-10-23 18:20:29'),
(344,145,215,'ubuntu-20.04-x86_64','2022-10-23 18:21:08','2022-10-23 18:21:08'),
(345,152,215,'فنلاند','2022-10-23 18:21:08','2022-10-23 18:21:08'),
(346,3,66,'09388698064','2022-10-23 19:13:50','2022-10-23 19:13:50'),
(1317,214,375,'','2023-01-12 07:22:41','2023-01-12 07:22:41'),
(1302,129,498,'','2023-01-11 13:44:10','2023-02-12 06:20:51'),
(349,3,67,'09228468939','2022-10-24 09:44:04','2022-10-24 09:44:04'),
(350,145,217,'ubuntu-20.04-x86_64','2022-10-24 09:44:10','2022-10-24 09:44:10'),
(351,152,217,'فنلاند','2022-10-24 09:44:10','2022-11-28 19:37:53'),
(352,145,218,'ubuntu-20.04-x86_64','2022-10-24 16:04:16','2022-10-24 16:04:16'),
(353,152,218,'آلمان','2022-10-24 16:04:16','2022-10-24 16:04:16'),
(354,145,219,'ubuntu-20.04-x86_64','2022-10-24 16:04:16','2022-10-24 16:04:16'),
(355,152,219,'آلمان','2022-10-24 16:04:16','2022-10-24 16:04:16'),
(356,145,220,'','2022-10-25 09:22:51','2022-12-21 08:23:35'),
(357,152,220,'','2022-10-25 09:22:51','2022-12-21 08:23:35'),
(358,3,68,'khadamat.essential@gmail.com','2022-10-25 12:42:04','2022-10-25 12:42:04'),
(359,126,221,'ubuntu-20.04-x86_64','2022-10-25 12:42:10','2022-10-25 12:42:10'),
(360,125,221,'','2022-10-26 07:24:57','2022-10-26 07:24:57'),
(361,127,221,'','2022-10-26 07:24:57','2022-10-26 07:24:57'),
(1130,126,455,'centos-7.4-x86_64','2022-12-30 08:38:09','2022-12-30 08:38:09'),
(363,126,222,'ubuntu-18.04-x86_64','2022-10-27 06:59:50','2022-10-27 06:59:50'),
(364,145,223,'ubuntu-20.04-x86_64','2022-10-27 10:18:53','2022-10-27 10:18:53'),
(365,152,223,'آلمان','2022-10-27 10:18:53','2022-10-27 10:18:53'),
(366,145,224,'ubuntu-20.04-x86_64','2022-10-27 10:18:53','2022-10-27 10:18:53'),
(367,152,224,'آلمان','2022-10-27 10:18:53','2022-10-27 10:18:53'),
(368,145,225,'ubuntu-20.04-x86_64','2022-10-27 10:18:53','2022-10-27 10:18:53'),
(369,152,225,'آلمان','2022-10-27 10:18:53','2022-10-27 10:18:53'),
(370,145,226,'ubuntu-20.04-x86_64','2022-10-27 10:18:54','2022-10-27 10:18:54'),
(371,152,226,'آلمان','2022-10-27 10:18:54','2022-10-27 10:18:54'),
(372,145,227,'ubuntu-20.04-x86_64','2022-10-27 10:18:54','2022-10-27 10:18:54'),
(373,152,227,'آلمان','2022-10-27 10:18:54','2022-10-27 10:18:54'),
(374,3,69,'09399745054','2022-10-28 13:19:28','2022-10-28 13:19:28'),
(1316,214,372,'','2023-01-12 07:21:56','2023-01-12 07:21:56'),
(1301,214,355,'','2023-01-11 09:45:19','2023-01-11 09:45:19'),
(396,125,222,'124','2022-11-05 08:12:39','2022-11-24 08:28:43'),
(377,3,70,'09388698064','2022-10-30 08:44:53','2022-10-30 08:44:53'),
(380,3,71,'09122654620','2022-10-30 10:53:40','2022-10-30 10:53:40'),
(1315,214,374,'','0000-00-00 00:00:00','2023-01-12 07:21:13'),
(1769,152,620,'','2023-02-14 20:33:39','2023-02-14 20:33:39'),
(1300,214,415,'40VW7l5txlN5aJhq','2023-01-11 09:15:09','2023-01-11 09:15:09'),
(385,3,72,'09378822868','2022-11-02 06:10:19','2022-11-02 06:10:19'),
(1314,214,371,'','2023-01-12 07:20:15','2023-01-12 07:20:15'),
(388,126,234,'ubuntu-20.04-x86_64','2022-11-02 07:48:19','2022-11-02 07:48:19'),
(389,125,234,'54','2022-11-02 07:54:41','2022-12-07 14:58:26'),
(390,127,234,'','2022-11-02 07:54:41','2022-11-02 07:54:41'),
(1335,3,198,'09358551590','2023-01-12 21:39:29','2023-01-12 21:39:29'),
(394,145,237,'centos-8.2-x86_64','2022-11-05 06:37:37','2022-11-05 06:37:37'),
(395,152,237,'آمریکا','2022-11-05 06:37:37','2022-11-05 06:37:37'),
(397,127,222,'','2022-11-05 08:12:39','2022-11-05 08:12:39'),
(1129,3,165,'09224783282','2022-12-30 08:34:35','2022-12-30 08:34:35'),
(399,3,73,'09150050301','2022-11-05 10:25:26','2022-11-05 10:25:26'),
(400,145,239,'centos-7.4-x86_64','2022-11-05 10:25:35','2022-11-05 10:25:35'),
(401,152,239,'آلمان','2022-11-05 10:25:35','2022-11-05 10:25:35'),
(402,145,240,'','2022-11-05 10:28:28','2022-12-19 06:49:17'),
(403,152,240,'','2022-11-05 10:28:28','2022-12-19 06:49:17'),
(1334,152,504,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1325,127,502,'','2023-01-12 07:33:20','2023-01-12 07:33:20'),
(406,3,74,'09124403412','2022-11-06 16:46:29','2022-11-06 16:46:29'),
(407,126,242,'debian-11-x86_64','2022-11-06 16:46:38','2022-11-06 16:46:38'),
(408,3,75,'09366155242','2022-11-06 18:08:54','2022-11-06 18:08:54'),
(409,125,242,'56','2022-11-07 16:01:59','2022-11-07 17:54:01'),
(410,127,242,'','2022-11-07 16:01:59','2022-11-07 16:01:59'),
(1127,214,453,'','2022-12-29 20:50:13','2023-01-31 11:09:55'),
(412,126,243,'ubuntu-20.04-x86_64','2022-11-07 17:06:27','2022-11-07 17:06:27'),
(413,125,243,'57','2022-11-07 17:10:32','2022-11-07 17:10:32'),
(414,127,243,'','2022-11-07 17:10:32','2022-11-07 17:10:32'),
(1126,127,453,'','2022-12-29 20:50:13','2022-12-29 20:50:13'),
(416,3,76,'09138509973','2022-11-08 21:13:01','2022-11-08 21:13:01'),
(417,126,244,'ubuntu-20.04-x86_64','2022-11-09 07:27:03','2022-11-09 07:27:03'),
(418,3,77,'09369915909','2022-11-09 07:35:33','2022-11-09 07:35:33'),
(419,125,244,'101','2022-11-09 07:37:40','2022-11-19 06:19:42'),
(420,127,244,'','2022-11-09 07:37:40','2022-11-09 07:37:40'),
(1599,152,578,'','2023-02-01 15:01:00','2023-02-01 15:01:00'),
(422,126,245,'ubuntu-20.04-x86_64','2022-11-09 08:11:55','2022-11-09 08:11:55'),
(423,125,245,'38','2022-11-09 08:12:29','2022-11-09 08:41:42'),
(424,127,245,'','2022-11-09 08:12:29','2022-11-09 08:12:29'),
(1125,125,453,'','2022-12-29 20:50:13','2022-12-29 20:50:13'),
(1337,126,505,'centos-8-x86_64','2023-01-12 22:21:00','2023-01-12 23:58:52'),
(1333,145,504,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(428,3,78,'09300136077','2022-11-09 13:04:08','2022-11-09 13:04:08'),
(429,145,247,'ubuntu-20.04-x86_64','2022-11-09 13:20:03','2022-11-09 13:20:03'),
(430,152,247,'آلمان','2022-11-09 13:20:03','2022-11-09 13:20:03'),
(431,3,79,'09359347626','2022-11-09 14:42:13','2022-11-09 14:42:13'),
(432,145,248,'centos-8.2-x86_64','2022-11-09 15:23:18','2022-11-09 15:23:18'),
(433,152,248,'فنلاند','2022-11-09 15:23:18','2022-11-09 15:23:18'),
(434,3,80,'09339751406','2022-11-10 03:04:17','2022-11-10 03:04:17'),
(435,126,249,'centos-7.9-x86_64','2022-11-10 03:04:21','2023-01-28 17:05:08'),
(436,3,81,'09305939754','2022-11-10 07:59:38','2022-11-10 07:59:38'),
(437,136,250,'centos-7.4-x86_64','2022-11-10 08:56:18','2022-11-10 08:56:18'),
(438,126,251,'centos-8.2-x86_64','2022-11-10 10:38:57','2022-11-10 10:38:57'),
(439,125,251,'68','2022-11-10 10:50:35','2022-11-10 10:50:35'),
(440,127,251,'','2022-11-10 10:50:35','2022-11-10 10:50:35'),
(1123,3,163,'09152277462','2022-12-29 20:36:43','2022-12-29 20:36:43'),
(442,3,82,'09197170836','2022-11-10 12:38:15','2022-11-10 12:38:15'),
(443,3,83,'09103589759','2022-11-10 12:46:48','2022-11-10 12:46:48'),
(444,126,252,'centos-7.4-x86_64','2022-11-10 12:46:52','2022-11-10 12:46:52'),
(445,126,253,'centos-8.2-x86_64','2022-11-10 13:01:23','2022-11-10 13:01:23'),
(446,125,253,'69','2022-11-10 13:02:47','2023-01-12 23:00:44'),
(447,127,253,'','2022-11-10 13:02:47','2022-11-10 13:02:47'),
(1339,214,253,'fIU0OkoxsZCNIxAy','2023-01-12 23:00:04','2023-01-12 23:00:04'),
(1121,214,435,'WBUeRrz2la5ZWVsp','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(449,125,249,'74','2022-11-10 13:09:47','2022-11-30 17:55:15'),
(450,127,249,'','2022-11-10 13:09:47','2022-11-10 13:09:47'),
(1124,126,453,'ubuntu-20.04-x86_64','2022-12-29 20:39:38','2022-12-29 20:39:38'),
(452,125,252,'71','2022-11-10 13:17:29','2022-11-10 13:17:29'),
(453,127,252,'','2022-11-10 13:17:29','2022-11-10 13:17:29'),
(1122,3,162,'09365170813','2022-12-29 19:23:41','2022-12-29 19:23:41'),
(623,152,311,'آلمان','2022-11-23 07:53:43','2022-11-23 07:53:43'),
(459,125,255,'110','2022-11-10 21:31:42','2023-02-06 21:23:50'),
(460,126,255,'centos-7.9-x86_64','2022-11-10 21:31:42','2023-01-28 17:04:46'),
(461,127,255,'','2022-11-10 21:31:42','2022-11-10 21:31:42'),
(1120,152,452,'','2022-12-29 17:13:36','2022-12-29 17:13:36'),
(1250,3,186,'09365180470','2023-01-06 21:52:45','2023-01-06 21:52:45'),
(1249,152,480,'','2023-01-06 13:50:14','2023-01-06 13:50:14'),
(1248,145,480,'','2023-01-06 13:50:14','2023-01-06 13:50:14'),
(1089,214,446,'g9mbJL8bFLyI0wPj','2022-12-28 17:04:41','2023-02-11 08:10:38'),
(622,145,311,'ubuntu-20.04-x86_64','2022-11-23 07:53:43','2022-11-23 07:53:43'),
(648,3,105,'912 365 9982','2022-11-28 08:02:25','2022-11-28 08:02:25'),
(467,3,84,'09368279106','2022-11-11 07:32:47','2022-11-11 07:32:47'),
(468,126,259,'ubuntu-20.04-x86_64','2022-11-11 07:37:19','2022-11-11 07:37:19'),
(469,125,259,'166','2022-11-11 09:48:10','2022-12-14 16:17:05'),
(470,127,259,'','2022-11-11 09:48:10','2022-11-11 09:48:10'),
(1119,145,452,'','2022-12-29 17:13:36','2022-12-29 17:13:36'),
(472,3,85,'۰۹۰۲۲۲۸۰۶۰۱','2022-11-11 17:34:11','2022-11-11 17:34:11'),
(624,145,313,'ubuntu-20.04-x86_64','2022-11-23 09:26:23','2022-11-23 09:26:23'),
(1135,126,456,'ubuntu-20.04-x86_64','2022-12-30 18:44:05','2022-12-30 18:44:05'),
(473,64,51,'','2022-11-11 20:33:21','2022-11-11 20:33:21'),
(474,3,86,'09011084639','2022-11-12 07:48:36','2022-11-12 07:48:36'),
(475,145,260,'','2022-11-12 07:48:42','2022-12-16 19:17:57'),
(476,152,260,'','2022-11-12 07:48:42','2022-12-16 19:17:57'),
(477,126,261,'ubuntu-20.04-x86_64','2022-11-12 12:15:24','2022-11-12 12:15:24'),
(478,125,261,'167','2022-11-12 12:17:45','2022-12-14 16:18:07'),
(479,127,261,'','2022-11-12 12:17:45','2022-11-12 12:17:45'),
(1118,214,411,'YniCAV2ZM0n1OG62','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(481,3,87,'09359170682','2022-11-12 15:37:15','2022-11-12 15:37:15'),
(482,126,262,'ubuntu-20.04-x86_64','2022-11-12 15:57:57','2022-11-12 18:13:38'),
(483,145,263,'ubuntu-20.04-x86_64','2022-11-12 15:57:57','2022-11-12 18:13:49'),
(484,152,263,'آلمان','2022-11-12 15:57:57','2022-11-12 15:57:57'),
(485,125,262,'','2022-11-12 18:13:38','2022-11-17 20:47:32'),
(486,127,262,'','2022-11-12 18:13:38','2022-11-12 18:13:38'),
(1117,152,451,'','2022-12-29 12:44:14','2022-12-29 12:44:14'),
(1313,3,197,'09360932966','2023-01-12 06:15:47','2023-01-12 06:15:47'),
(1299,214,497,'gXd6DEvm5G99C9W4','2023-01-10 15:34:49','2023-01-14 20:29:31'),
(490,3,88,'09374131611','2022-11-13 14:08:19','2022-11-13 14:08:19'),
(491,126,265,'ubuntu-20.04-x86_64','2022-11-13 14:08:25','2022-11-14 14:29:18'),
(492,145,266,'','2022-11-13 14:08:25','2023-01-01 17:15:34'),
(493,152,266,'','2022-11-13 14:08:25','2023-01-01 17:15:34'),
(494,145,267,'ubuntu-20.04-x86_64','2022-11-14 11:08:41','2022-11-14 11:08:41'),
(495,152,267,'فنلاند','2022-11-14 11:08:41','2022-11-14 11:08:41'),
(496,125,265,'118','2022-11-14 14:29:18','2023-01-12 23:13:20'),
(497,127,265,'','2022-11-14 14:29:18','2022-11-14 14:29:18'),
(1116,145,451,'','2022-12-29 12:44:14','2022-12-29 12:44:14'),
(1147,214,265,'EQNjqDsCYKUe3jEC','2023-01-01 17:18:45','2023-01-01 17:18:45'),
(499,126,268,'centos-7.4-x86_64','2022-11-15 08:45:08','2022-11-15 08:55:54'),
(500,125,268,'','2022-11-15 08:55:54','2022-11-15 11:02:27'),
(501,127,268,'','2022-11-15 08:55:54','2022-11-15 08:55:54'),
(503,3,89,'09123158391','2022-11-15 11:42:02','2022-11-15 11:42:02'),
(504,145,269,'ubuntu-20.04-x86_64','2022-11-15 11:48:32','2022-12-01 12:59:40'),
(505,152,269,'آلمان','2022-11-15 11:48:32','2022-11-15 11:48:32'),
(506,3,90,'09308500806','2022-11-15 20:03:20','2022-11-15 20:03:20'),
(1312,126,502,'ubuntu-20.04-x86_64','2023-01-12 00:06:16','2023-01-12 00:06:16'),
(1298,127,497,'','2023-01-10 15:34:49','2023-01-10 15:34:49'),
(509,145,271,'','2022-11-15 20:56:04','2022-12-16 20:42:32'),
(510,152,271,'','2022-11-15 20:56:04','2022-12-16 20:42:32'),
(511,126,272,'ubuntu-20.04-x86_64','2022-11-16 09:42:01','2022-11-16 09:42:01'),
(512,125,272,'','2022-11-16 09:54:31','2022-11-16 09:54:31'),
(513,127,272,'','2022-11-16 09:54:31','2022-11-16 09:54:31'),
(1115,3,161,'09337467489','2022-12-29 12:44:07','2022-12-29 12:44:07'),
(515,3,91,'09124101860','2022-11-16 10:09:47','2022-11-16 10:09:47'),
(1311,3,196,'۰۹۱۱۱۳۶۲۰۲۷','2023-01-12 00:06:11','2023-01-12 00:06:11'),
(1297,125,497,'230','2023-01-10 15:34:49','2023-01-14 20:29:40'),
(533,3,93,'09376810671','2022-11-17 17:40:19','2022-11-17 17:40:19'),
(518,126,274,'ubuntu-20.04-x86_64','2022-11-16 23:16:28','2022-11-16 23:16:28'),
(519,126,275,'ubuntu-20.04-x86_64','2022-11-16 23:19:22','2022-11-16 23:19:22'),
(520,126,276,'ubuntu-20.04-x86_64','2022-11-16 23:22:51','2022-11-16 23:22:51'),
(521,125,276,'96','2022-11-17 07:28:26','2022-11-17 07:28:26'),
(522,127,276,'','2022-11-17 07:28:26','2022-11-17 07:28:26'),
(1114,152,450,'','2022-12-29 11:23:23','2022-12-29 11:23:23'),
(524,3,92,'09130055461','2022-11-17 07:40:41','2022-11-17 07:40:41'),
(1330,214,503,'xhnxKa1vcDywSkM9','2023-01-12 11:02:12','2023-01-12 11:02:12'),
(1324,125,502,'234','2023-01-12 07:33:20','2023-01-12 07:33:20'),
(1310,126,501,'ubuntu-20.04-x86_64','2023-01-11 21:00:22','2023-01-11 21:00:22'),
(1296,126,497,'ubuntu-20.04-x86_64','2023-01-10 15:28:53','2023-01-10 15:28:53'),
(1294,203,496,'','2023-01-10 15:09:49','2023-01-10 15:09:49'),
(1295,3,194,'09360607879','2023-01-10 15:24:43','2023-01-10 15:24:43'),
(1286,203,493,'','2023-01-10 11:26:42','2023-01-10 11:26:42'),
(534,126,281,'ubuntu-18.04-x86_64','2022-11-17 17:40:24','2022-11-17 17:40:24'),
(535,126,282,'ubuntu-20.04-x86_64','2022-11-17 17:44:49','2022-11-17 17:44:49'),
(536,125,282,'','2022-11-17 17:50:04','2022-11-17 20:01:45'),
(537,127,282,'','2022-11-17 17:50:04','2022-11-17 17:50:04'),
(1113,145,450,'','2022-12-29 11:23:23','2022-12-29 11:23:23'),
(539,126,283,'ubuntu-20.04-x86_64','2022-11-17 20:46:16','2022-11-17 20:46:16'),
(540,125,283,'97','2022-11-17 20:47:06','2023-01-01 21:32:08'),
(541,127,283,'','2022-11-17 20:47:07','2022-11-17 20:47:07'),
(1112,199,449,'','2022-12-29 10:42:55','2022-12-29 10:42:55'),
(543,126,284,'ubuntu-20.04-x86_64','2022-11-18 08:28:45','2022-11-18 08:28:45'),
(544,125,284,'98','2022-11-18 08:38:21','2022-11-18 08:38:21'),
(545,127,284,'','2022-11-18 08:38:21','2022-11-18 08:38:21'),
(1111,198,449,'','2022-12-29 10:42:55','2022-12-29 10:42:55'),
(547,64,87,'','2022-11-18 18:29:28','2022-11-18 18:29:28'),
(548,3,94,'09382615857','2022-11-18 20:35:01','2022-11-18 20:35:01'),
(549,126,285,'ubuntu-20.04-x86_64','2022-11-18 20:35:07','2022-11-18 20:35:07'),
(550,125,285,'100','2022-11-18 20:42:37','2022-11-18 20:42:37'),
(551,127,285,'','2022-11-18 20:42:37','2022-11-18 20:42:37'),
(1287,126,494,'ubuntu-20.04-x86_64','2023-01-10 12:56:58','2023-01-10 12:56:58'),
(553,3,95,'09146569240','2022-11-19 05:48:32','2022-11-19 05:48:32'),
(554,125,286,'102','2022-11-19 05:56:38','2022-11-19 06:39:13'),
(555,126,286,'ubuntu-20.04-x86_64','2022-11-19 05:56:38','2022-11-19 05:56:38'),
(556,127,286,'','2022-11-19 05:56:38','2022-11-19 05:56:38'),
(558,125,287,'103','2022-11-19 05:56:38','2022-11-19 06:40:20'),
(559,126,287,'ubuntu-20.04-x86_64','2022-11-19 05:56:38','2022-11-19 05:56:38'),
(560,127,287,'','2022-11-19 05:56:38','2022-11-19 05:56:38'),
(562,125,288,'','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(563,126,288,'ubuntu-20.04-x86_64','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(564,127,288,'','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(566,125,289,'','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(567,126,289,'ubuntu-20.04-x86_64','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(568,127,289,'','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(570,145,290,'ubuntu-20.04-x86_64','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(571,152,290,'آلمان','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(572,145,291,'ubuntu-20.04-x86_64','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(573,152,291,'آلمان','2022-11-19 05:56:39','2022-11-19 05:56:39'),
(1309,3,195,'09145162579','2023-01-11 21:00:16','2023-01-11 21:00:16'),
(1293,202,496,'','2023-01-10 15:09:49','2023-01-10 15:09:49'),
(1303,134,498,'انتخاب کنید','2023-01-11 13:44:10','2023-01-11 13:44:10'),
(1329,127,503,'','2023-01-12 11:02:12','2023-01-12 11:02:12'),
(578,3,96,'09100055062','2022-11-19 15:08:47','2022-11-19 15:08:47'),
(1292,203,495,'','2023-01-10 14:07:12','2023-01-10 14:07:12'),
(581,131,250,'','2022-11-20 06:36:05','2023-01-20 15:34:31'),
(582,140,250,'','2022-11-20 06:36:05','2022-11-20 06:36:05'),
(1431,221,250,'','2023-01-20 15:34:31','2023-01-20 15:34:31'),
(1053,214,379,'ZFhl1fkBQgd8iQ3E','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(584,125,295,'111','2022-11-20 12:04:57','2022-11-29 12:10:38'),
(585,126,295,'انتخاب کنید','2022-11-20 12:04:57','2022-11-20 12:04:57'),
(586,127,295,'','2022-11-20 12:04:57','2022-11-20 12:04:57'),
(588,125,296,'120','2022-11-20 12:04:57','2022-11-21 19:58:59'),
(589,126,296,'ubuntu-20.04-x86_64','2022-11-20 12:04:57','2022-11-20 12:24:00'),
(590,127,296,'','2022-11-20 12:04:57','2022-11-20 12:04:57'),
(1108,3,160,'09031215741','2022-12-29 10:42:49','2022-12-29 10:42:49'),
(652,145,324,'','2022-11-29 18:37:19','2022-12-24 11:12:33'),
(617,145,306,'ubuntu-20.04-x86_64','2022-11-22 17:45:31','2022-11-22 17:45:31'),
(592,145,297,'ubuntu-20.04-x86_64','2022-11-20 12:35:09','2022-11-20 12:35:09'),
(593,152,297,'آلمان','2022-11-20 12:35:09','2022-11-20 12:35:09'),
(594,145,298,'ubuntu-20.04-x86_64','2022-11-20 12:35:10','2022-11-20 12:35:10'),
(595,152,298,'آلمان','2022-11-20 12:35:10','2022-11-20 12:35:10'),
(596,145,299,'ubuntu-20.04-x86_64','2022-11-20 14:06:38','2022-11-20 14:06:38'),
(597,152,299,'آمریکا','2022-11-20 14:06:38','2022-11-20 14:06:38'),
(598,145,300,'','2022-11-20 19:32:27','2022-12-15 07:14:09'),
(599,152,300,'','2022-11-20 19:32:27','2022-12-15 07:14:09'),
(600,3,97,'09905353114','2022-11-20 19:59:25','2022-11-20 19:59:25'),
(1328,125,503,'235','2023-01-12 11:02:12','2023-01-12 11:02:12'),
(1323,214,501,'9mp7MsY9I2uYrMDE','2023-01-12 07:28:41','2023-01-12 07:28:41'),
(603,145,302,'','2022-11-21 08:03:47','2022-12-15 21:07:12'),
(604,152,302,'','2022-11-21 08:03:47','2022-12-15 21:07:12'),
(1322,127,501,'','2023-01-12 07:28:41','2023-01-12 07:28:41'),
(616,152,304,'آلمان','2022-11-22 11:46:48','2022-11-22 11:46:48'),
(609,145,305,'ubuntu-20.04-x86_64','2022-11-21 11:31:25','2022-11-21 11:31:25'),
(610,152,305,'آلمان','2022-11-21 11:31:25','2022-11-21 11:31:25'),
(615,145,304,'ubuntu-20.04-x86_64','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(618,152,306,'آلمان','2022-11-22 17:45:31','2022-11-22 17:45:31'),
(619,3,98,'09169644846','2022-11-22 17:52:30','2022-11-22 17:52:30'),
(620,3,99,'09169644846','2022-11-22 17:55:51','2022-11-22 17:55:51'),
(621,3,100,'09169644846','2022-11-22 17:58:36','2022-11-22 17:58:36'),
(625,152,313,'آلمان','2022-11-23 09:26:23','2022-11-23 09:26:23'),
(626,145,314,'ubuntu-20.04-x86_64','2022-11-23 18:22:47','2022-11-23 18:22:47'),
(627,152,314,'آلمان','2022-11-23 18:22:47','2022-11-23 18:22:47'),
(628,145,315,'ubuntu-20.04-x86_64','2022-11-24 18:47:11','2022-11-24 18:47:11'),
(629,152,315,'آلمان','2022-11-24 18:47:11','2022-11-24 18:47:11'),
(630,145,316,'ubuntu-20.04-x86_64','2022-11-24 18:51:07','2022-11-24 18:51:07'),
(631,152,316,'فنلاند','2022-11-24 18:51:07','2022-11-27 07:16:00'),
(632,145,317,'ubuntu-20.04-x86_64','2022-11-25 11:06:21','2022-11-25 11:06:21'),
(633,152,317,'آلمان','2022-11-25 11:06:21','2022-11-25 11:06:21'),
(634,145,318,'ubuntu-20.04-x86_64','2022-11-25 17:34:28','2022-11-25 17:34:28'),
(635,152,318,'آلمان','2022-11-25 17:34:28','2022-11-25 17:34:28'),
(636,3,101,'09128512934','2022-11-26 09:50:46','2022-11-26 09:50:46'),
(637,3,102,'09215460996','2022-11-26 13:14:52','2022-11-26 13:14:52'),
(638,126,319,'ubuntu-20.04-x86_64','2022-11-26 13:15:04','2022-11-26 13:15:04'),
(639,125,319,'175','2022-11-26 13:27:23','2023-01-14 17:12:33'),
(640,127,319,'','2022-11-26 13:27:23','2022-11-26 13:27:23'),
(1107,214,448,'1w9vbeTIasnhL9Se','0000-00-00 00:00:00','2023-01-30 09:56:19'),
(642,145,320,'ubuntu-20.04-x86_64','2022-11-26 13:55:41','2022-11-26 13:55:41'),
(643,152,320,'آلمان','2022-11-26 13:55:41','2022-11-26 13:55:41'),
(644,3,103,'09352854080','2022-11-26 15:56:19','2022-11-26 15:56:19'),
(645,3,104,'09366393932','2022-11-27 14:02:24','2022-11-27 14:02:24'),
(646,145,321,'windows-server-2022','2022-11-27 14:39:32','2022-11-27 14:39:32'),
(647,152,321,'آلمان','2022-11-27 14:39:32','2022-11-27 14:39:32'),
(649,64,105,'','2022-11-28 11:27:49','2022-11-28 11:27:49'),
(1285,202,493,'','2023-01-10 11:26:42','2023-01-10 11:26:42'),
(1026,145,433,'','2022-12-25 17:10:13','2022-12-25 17:10:13'),
(653,152,324,'','2022-11-29 18:37:19','2022-12-24 11:12:33'),
(654,3,106,'09178829644','2022-11-30 11:30:53','2022-11-30 11:30:53'),
(655,145,327,'ubuntu-20.04-x86_64','2022-11-30 19:52:53','2022-11-30 19:52:53'),
(656,152,327,'فنلاند','2022-11-30 19:52:53','2022-11-30 19:52:53'),
(657,145,328,'ubuntu-20.04-x86_64','2022-11-30 19:56:37','2022-11-30 19:56:37'),
(658,152,328,'فنلاند','2022-11-30 19:56:37','2022-11-30 19:56:37'),
(660,152,330,'آلمان','2022-12-01 10:41:37','2022-12-01 10:41:37'),
(661,145,331,'ubuntu-20.04-x86_64','2022-12-01 19:13:41','2022-12-01 19:13:41'),
(662,152,331,'فنلاند','2022-12-01 19:13:41','2022-12-01 19:13:41'),
(663,145,332,'debian-11-x86_64','2022-12-01 19:17:27','2022-12-01 19:17:27'),
(664,152,332,'آلمان','2022-12-01 19:17:27','2022-12-01 19:17:27'),
(665,3,107,'0015028499549','2022-12-02 07:19:58','2022-12-02 07:19:58'),
(1308,126,500,'ubuntu-20.04-x86_64','2023-01-11 20:47:54','2023-01-11 20:47:54'),
(1291,202,495,'','2023-01-10 14:07:12','2023-01-10 14:07:12'),
(668,126,335,'centos-7.9-x86_64','2022-12-02 13:00:31','2023-01-29 12:26:30'),
(669,125,335,'29','2022-12-02 13:08:47','2023-01-03 08:11:52'),
(670,127,335,'','2022-12-02 13:08:47','2022-12-02 13:08:47'),
(1106,127,448,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1104,125,448,'203','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1105,126,448,'ubuntu-20.04-x86_64','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(672,145,336,'centos-7.4-x86_64','2022-12-03 12:18:13','2022-12-03 12:18:13'),
(673,152,336,'آلمان','2022-12-03 12:18:13','2022-12-03 12:18:13'),
(674,145,337,'debian-11-x86_64','2022-12-03 14:39:56','2022-12-03 14:39:56'),
(675,152,337,'آلمان','2022-12-03 14:39:56','2022-12-03 14:39:56'),
(676,145,338,'debian-11-x86_64','2022-12-03 14:45:49','2022-12-03 14:45:49'),
(677,152,338,'آلمان','2022-12-03 14:45:49','2022-12-03 14:45:49'),
(678,125,339,'133','2022-12-04 11:58:30','2022-12-04 12:03:59'),
(679,126,339,'ubuntu-20.04-x86_64','2022-12-04 11:58:30','2022-12-04 11:58:30'),
(680,127,339,'','2022-12-04 11:58:30','2022-12-04 11:58:30'),
(682,125,340,'141','2022-12-04 11:58:30','2022-12-09 14:33:00'),
(683,126,340,'ubuntu-20.04-x86_64','2022-12-04 11:58:30','2022-12-04 11:58:30'),
(684,127,340,'','2022-12-04 11:58:30','2022-12-04 11:58:30'),
(1095,3,159,'09104437068','2022-12-28 21:56:09','2022-12-28 21:56:09'),
(1094,214,447,'','2022-12-28 18:48:25','2022-12-28 18:48:25'),
(686,130,341,'134','2022-12-04 16:30:15','2022-12-04 16:46:14'),
(687,135,341,'ubuntu-20.04-x86_64','2022-12-04 16:30:15','2022-12-04 16:30:15'),
(688,139,341,'','2022-12-04 16:30:15','2022-12-04 16:30:15'),
(1535,3,229,'09028122550','2023-01-29 18:06:26','2023-01-29 18:06:26'),
(1052,214,439,'','2022-12-27 09:40:49','2022-12-27 09:41:20'),
(1307,199,499,'','2023-01-11 13:44:10','2023-01-11 13:44:10'),
(1768,145,620,'','2023-02-14 20:33:39','2023-02-14 20:33:39'),
(692,3,108,'09182605595','2022-12-04 20:18:26','2022-12-04 20:18:26'),
(693,145,343,'','2022-12-04 20:22:43','2022-12-15 07:16:58'),
(694,152,343,'','2022-12-04 20:22:43','2022-12-15 07:16:58'),
(695,126,344,'ubuntu-20.04-x86_64','2022-12-04 20:47:00','2022-12-04 20:47:00'),
(696,125,344,'135','2022-12-04 20:56:19','2022-12-04 20:56:19'),
(697,127,344,'','2022-12-04 20:56:19','2022-12-04 20:56:19'),
(1093,127,447,'','2022-12-28 18:48:25','2022-12-28 18:48:25'),
(1306,198,499,'','2023-01-11 13:44:10','2023-01-11 13:44:10'),
(1290,214,494,'','2023-01-10 13:34:10','2023-02-11 08:59:00'),
(701,3,109,'09332358481','2022-12-05 18:45:51','2022-12-05 18:45:51'),
(702,126,346,'ubuntu-20.04-x86_64','2022-12-05 18:51:24','2022-12-05 18:51:24'),
(703,125,346,'136','2022-12-05 18:56:21','2022-12-05 18:56:21'),
(704,127,346,'','2022-12-05 18:56:21','2022-12-05 18:56:21'),
(1092,125,447,'','2022-12-28 18:48:25','2022-12-28 18:48:25'),
(706,3,110,'09170052328','2022-12-05 22:22:53','2022-12-05 22:22:53'),
(746,125,356,'145','2022-12-10 08:45:15','2023-01-12 23:26:54'),
(709,3,111,'09926494914','2022-12-06 09:37:32','2022-12-06 09:37:32'),
(710,126,347,'ubuntu-20.04-x86_64','2022-12-06 09:38:01','2022-12-06 09:38:01'),
(711,125,347,'137','2022-12-06 09:43:56','2023-01-05 05:17:30'),
(712,127,347,'','2022-12-06 09:43:56','2022-12-06 09:43:56'),
(1091,126,447,'centos-7.4-x86_64','2022-12-28 18:43:14','2022-12-28 18:43:14'),
(1128,3,164,'09388758248','2022-12-30 01:37:40','2022-12-30 01:37:40'),
(714,3,112,'09021130577','2022-12-07 19:12:41','2022-12-07 19:12:41'),
(715,126,348,'centos-7.4-x86_64','2022-12-07 19:12:45','2022-12-07 19:12:45'),
(716,125,348,'139','2022-12-07 19:22:51','2022-12-07 19:22:51'),
(717,127,348,'','2022-12-07 19:22:51','2022-12-07 19:22:51'),
(719,3,113,'+51666754494','2022-12-08 12:31:14','2022-12-08 12:31:14'),
(720,125,349,'140','2022-12-08 13:11:49','2022-12-09 08:44:30'),
(721,126,349,'centos-7.9-x86_64','2022-12-08 13:11:49','2023-01-28 17:05:36'),
(722,127,349,'','2022-12-08 13:11:49','2022-12-08 13:11:49'),
(1090,3,158,'09036844994','2022-12-28 18:43:08','2022-12-28 18:43:08'),
(745,126,356,'ubuntu-20.04-x86_64','2022-12-10 08:38:18','2022-12-10 08:38:18'),
(730,126,353,'centos-7.4-x86_64','2022-12-09 19:39:52','2022-12-09 19:39:52'),
(731,125,353,'142','2022-12-09 19:57:34','2022-12-09 19:57:34'),
(732,127,353,'','2022-12-09 19:57:34','2022-12-09 19:57:34'),
(1088,127,446,'','2022-12-28 17:04:41','2022-12-28 17:04:41'),
(734,3,114,'09148051388','2022-12-09 20:52:39','2022-12-09 20:52:39'),
(735,126,354,'ubuntu-20.04-x86_64','2022-12-09 20:53:10','2022-12-09 20:53:10'),
(736,125,354,'','2022-12-09 21:08:14','2022-12-27 17:31:36'),
(737,127,354,'','2022-12-09 21:08:14','2022-12-09 21:08:14'),
(739,3,115,'09362053735','2022-12-10 07:48:02','2022-12-10 07:48:02'),
(740,126,355,'ubuntu-20.04-x86_64','2022-12-10 07:48:08','2022-12-10 07:48:08'),
(741,125,355,'','2022-12-10 08:07:17','2022-12-10 08:12:00'),
(742,127,355,'','2022-12-10 08:07:17','2022-12-10 08:07:17'),
(1087,125,446,'201','2022-12-28 17:04:41','2023-01-29 15:50:57'),
(744,3,116,'09222601367','2022-12-10 08:08:16','2022-12-10 08:08:16'),
(1340,214,356,'0uzITFkRmSU7PyUp','2023-01-12 23:26:36','2023-01-12 23:30:24'),
(747,127,356,'','2022-12-10 08:45:15','2022-12-10 08:45:15'),
(1086,126,446,'ubuntu-20.04-x86_64','2022-12-28 16:59:33','2022-12-28 16:59:33'),
(756,152,360,'','2022-12-10 11:06:02','2022-12-10 11:06:02'),
(755,145,360,'','2022-12-10 11:06:02','2022-12-10 11:06:02'),
(759,200,241,'','2022-12-10 12:16:36','2022-12-10 12:16:36'),
(758,152,362,'','2022-12-10 12:01:33','2022-12-10 12:01:33'),
(757,145,362,'','2022-12-10 12:01:33','2022-12-10 12:01:33'),
(760,201,241,'','2022-12-10 12:16:36','2022-12-10 12:16:36'),
(761,202,323,'','2022-12-10 13:23:39','2022-12-10 13:23:39'),
(762,203,323,'','2022-12-10 13:23:39','2022-12-10 13:23:39'),
(763,3,117,'09133209077','2022-12-10 13:31:36','2022-12-10 13:31:36'),
(764,3,118,'09210396099','2022-12-10 17:27:14','2022-12-10 17:27:14'),
(765,126,364,'ubuntu-20.04-x86_64','2022-12-10 17:27:54','2022-12-10 17:27:54'),
(766,125,364,'','2022-12-10 17:38:01','2022-12-10 17:38:01'),
(767,127,364,'','2022-12-10 17:38:01','2022-12-10 17:38:01'),
(1085,3,157,'09369360433','2022-12-28 16:29:34','2022-12-28 16:29:34'),
(769,3,119,'09901310385','2022-12-10 18:48:59','2022-12-10 18:48:59'),
(770,3,120,'09351476469','2022-12-11 13:03:57','2022-12-11 13:03:57'),
(771,126,370,'ubuntu-20.04-x86_64','2022-12-11 13:06:25','2022-12-11 13:42:21'),
(772,125,370,'','2022-12-11 13:42:21','2023-01-12 23:30:55'),
(773,127,370,'','2022-12-11 13:42:21','2022-12-11 13:42:21'),
(1084,152,445,'','2022-12-28 14:06:34','2022-12-28 14:06:34'),
(1341,214,370,'wXtXiIfXnbNsoxwG','2023-01-12 23:30:48','2023-01-12 23:30:48'),
(1083,145,445,'','2022-12-28 14:06:34','2022-12-28 14:06:34'),
(775,3,121,'09903842457','2022-12-11 17:39:12','2022-12-11 17:39:12'),
(776,126,371,'ubuntu-20.04-x86_64','2022-12-11 17:45:22','2022-12-11 17:45:22'),
(777,125,371,'149','2022-12-11 17:58:08','2022-12-11 17:58:08'),
(778,127,371,'','2022-12-11 17:58:09','2022-12-11 17:58:09'),
(1082,3,156,'09126109950','2022-12-28 14:06:27','2022-12-28 14:06:27'),
(780,126,372,'ubuntu-18.04-x86_64','2022-12-11 18:49:12','2022-12-11 18:49:12'),
(781,3,122,'09359249812','2022-12-11 19:13:52','2022-12-11 19:13:52'),
(782,126,373,'ubuntu-20.04-x86_64','2022-12-11 19:14:30','2022-12-11 19:14:30'),
(783,125,372,'150','2022-12-11 19:14:41','2022-12-11 19:14:41'),
(784,127,372,'','2022-12-11 19:14:41','2022-12-11 19:14:41'),
(1211,127,471,'','2023-01-04 21:39:02','2023-01-04 21:39:02'),
(786,126,374,'ubuntu-20.04-x86_64','2022-12-11 19:18:29','2022-12-11 19:18:29'),
(1212,214,471,'','2023-01-04 21:39:02','2023-02-06 08:14:23'),
(787,64,122,'','2022-12-11 19:27:14','2022-12-11 19:27:14'),
(788,125,374,'151','2022-12-11 19:29:45','2022-12-11 19:29:45'),
(789,127,374,'','2022-12-11 19:29:45','2022-12-11 19:29:45'),
(1689,126,603,'ubuntu-20.04-x86_64','2023-02-07 11:00:13','2023-02-07 11:00:13'),
(791,126,375,'centos-7.4-x86_64','2022-12-11 20:06:29','2022-12-11 20:06:29'),
(792,3,123,'09115546209','2022-12-11 20:37:54','2022-12-11 20:37:54'),
(793,126,376,'ubuntu-20.04-x86_64','2022-12-11 20:42:54','2022-12-11 20:42:54'),
(794,125,376,'152','2022-12-11 21:16:23','2023-01-12 23:31:52'),
(795,127,376,'','2022-12-11 21:16:23','2022-12-11 21:16:23'),
(1210,125,471,'','2023-01-04 21:39:02','2023-01-04 21:39:02'),
(1342,214,376,'EYe13zsLlurquZFq','2023-01-12 23:31:41','2023-01-12 23:31:41'),
(797,125,375,'153','2022-12-11 21:19:36','2022-12-11 21:19:36'),
(798,127,375,'','2022-12-11 21:19:36','2022-12-11 21:19:36'),
(800,3,124,'09913371375','2022-12-12 00:17:44','2022-12-12 00:17:44'),
(801,126,377,'ubuntu-20.04-x86_64','2022-12-12 00:21:24','2022-12-12 00:21:24'),
(802,125,377,'','2022-12-12 07:22:21','2022-12-12 07:22:21'),
(803,127,377,'','2022-12-12 07:22:21','2022-12-12 07:22:21'),
(1185,3,175,'09127307287','2023-01-04 07:54:35','2023-01-04 07:54:35'),
(805,198,231,'','2022-12-12 07:35:17','2022-12-12 07:35:17'),
(806,199,231,'','2022-12-12 07:35:17','2022-12-12 07:35:17'),
(807,212,181,'','2022-12-12 07:38:59','2022-12-12 07:38:59'),
(808,213,181,'','2022-12-12 07:38:59','2022-12-12 07:38:59'),
(809,3,125,'09133769940','2022-12-12 10:09:26','2022-12-12 10:09:26'),
(810,125,378,'156','2022-12-12 10:20:15','2022-12-28 12:46:20'),
(811,126,378,'centos-7.9-x86_64','2022-12-12 10:20:15','2023-01-17 20:02:50'),
(812,127,378,'','2022-12-12 10:20:15','2022-12-12 10:20:15'),
(1209,126,472,'ubuntu-20.04-x86_64','2023-01-04 21:30:48','2023-01-04 21:30:48'),
(1076,214,378,'PIfta29i1chDCQDQ','2022-12-28 12:46:13','2022-12-28 12:46:13'),
(814,126,379,'ubuntu-18.04-x86_64','2022-12-12 10:26:11','2022-12-12 10:26:11'),
(815,125,379,'171','2022-12-12 10:50:46','2022-12-22 11:52:55'),
(816,127,379,'','2022-12-12 10:50:46','2022-12-12 10:50:46'),
(818,126,380,'ubuntu-20.04-x86_64','2022-12-12 20:29:03','2022-12-12 20:29:03'),
(819,126,381,'ubuntu-20.04-x86_64','2022-12-12 20:42:58','2022-12-12 20:42:58'),
(820,125,381,'160','2022-12-12 20:51:10','2023-01-12 23:45:08'),
(821,127,381,'','2022-12-12 20:51:10','2022-12-12 20:51:10'),
(1075,160,443,'','2022-12-28 10:53:07','2022-12-28 10:53:07'),
(823,126,382,'ubuntu-20.04-x86_64','2022-12-12 21:01:27','2022-12-12 21:01:27'),
(824,125,382,'','2022-12-13 07:12:54','2023-01-20 20:14:46'),
(825,127,382,'','2022-12-13 07:12:54','2022-12-13 07:12:54'),
(1074,159,443,'','2022-12-28 10:53:07','2022-12-28 10:53:07'),
(827,126,383,'ubuntu-20.04-x86_64','2022-12-13 13:46:32','2022-12-13 13:46:32'),
(828,125,383,'','2022-12-13 14:17:47','2022-12-27 17:32:13'),
(829,127,383,'','2022-12-13 14:17:47','2022-12-13 14:17:47'),
(1073,201,442,'','2022-12-28 10:53:07','2022-12-28 10:53:07'),
(831,3,126,'09145862484','2022-12-13 18:01:00','2022-12-13 18:01:00'),
(832,126,384,'ubuntu-20.04-x86_64','2022-12-13 18:06:59','2022-12-13 18:06:59'),
(833,125,384,'','2022-12-13 18:29:28','2022-12-13 18:29:28'),
(834,127,384,'','2022-12-13 18:29:28','2022-12-13 18:29:28'),
(1072,200,442,'','2022-12-28 10:53:07','2022-12-28 10:53:07'),
(836,126,385,'ubuntu-20.04-x86_64','2022-12-13 19:23:56','2022-12-13 19:23:56'),
(837,125,385,'','2022-12-13 20:17:35','2023-01-20 20:12:46'),
(838,127,385,'','2022-12-13 20:17:35','2022-12-13 20:17:35'),
(1318,125,500,'232','2023-01-12 07:26:24','2023-01-12 07:26:24'),
(840,126,386,'ubuntu-20.04-x86_64','2022-12-13 20:41:46','2022-12-13 20:41:46'),
(841,126,387,'ubuntu-20.04-x86_64','2022-12-13 20:46:39','2022-12-13 20:46:39'),
(842,3,127,'09390723875','2022-12-13 21:49:56','2022-12-13 21:49:56'),
(1305,215,498,'','2023-01-11 13:44:10','2023-01-11 13:44:10'),
(1289,127,494,'','2023-01-10 13:34:10','2023-01-10 13:34:10'),
(845,198,388,'','2022-12-13 21:58:52','2022-12-13 21:58:52'),
(846,199,388,'','2022-12-13 21:58:52','2022-12-13 21:58:52'),
(847,145,389,'','2022-12-13 22:12:18','2022-12-13 22:12:18'),
(848,152,389,'','2022-12-13 22:12:18','2022-12-13 22:12:18'),
(849,126,390,'ubuntu-20.04-x86_64','2022-12-14 07:06:18','2022-12-14 07:06:18'),
(850,126,391,'ubuntu-20.04-x86_64','2022-12-14 07:08:19','2022-12-14 07:08:19'),
(851,126,392,'ubuntu-20.04-x86_64','2022-12-14 07:09:59','2022-12-14 07:09:59'),
(852,126,393,'ubuntu-20.04-x86_64','2022-12-14 07:16:00','2022-12-14 07:16:00'),
(853,126,394,'ubuntu-20.04-x86_64','2022-12-14 07:20:59','2022-12-14 07:20:59'),
(854,126,395,'ubuntu-20.04-x86_64','2022-12-14 07:44:31','2022-12-14 07:44:31'),
(855,126,396,'ubuntu-20.04-x86_64','2022-12-14 07:56:11','2022-12-14 07:56:11'),
(856,126,397,'ubuntu-20.04-x86_64','2022-12-14 07:58:20','2022-12-14 07:58:20'),
(857,126,398,'ubuntu-20.04-x86_64','2022-12-14 08:00:05','2022-12-14 08:00:05'),
(858,3,128,'09132597294','2022-12-14 12:48:33','2022-12-14 12:48:33'),
(859,3,129,'09135211627','2022-12-14 14:41:58','2022-12-14 14:41:58'),
(860,126,399,'ubuntu-20.04-x86_64','2022-12-14 14:50:49','2022-12-14 14:50:49'),
(861,125,399,'165','2022-12-14 15:35:00','2022-12-14 15:35:00'),
(862,127,399,'','2022-12-14 15:35:00','2022-12-14 15:35:00'),
(1327,126,503,'windows-2019Server','2023-01-12 10:15:30','2023-01-12 10:15:30'),
(864,145,400,'','2022-12-14 16:37:50','2022-12-14 16:37:50'),
(865,152,400,'','2022-12-14 16:37:50','2022-12-14 16:37:50'),
(866,125,395,'168','2022-12-14 17:28:11','2023-01-16 09:20:03'),
(867,127,395,'','2022-12-14 17:28:11','2022-12-14 17:28:11'),
(1326,214,502,'zi2LSh7G4BZbn8sG','2023-01-12 07:33:20','2023-01-12 07:33:20'),
(869,3,130,'09918730149','2022-12-14 20:33:03','2022-12-14 20:33:03'),
(870,126,401,'ubuntu-20.04-x86_64','2022-12-14 20:33:12','2022-12-14 20:33:12'),
(871,125,401,'170','2022-12-14 20:43:29','2023-01-17 13:55:15'),
(872,127,401,'','2022-12-14 20:43:29','2022-12-14 20:43:29'),
(1069,201,431,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(874,145,402,'','2022-12-14 21:06:52','2022-12-14 21:06:52'),
(875,152,402,'','2022-12-14 21:06:52','2022-12-14 21:06:52'),
(876,3,131,'09364928199','2022-12-15 08:52:51','2022-12-15 08:52:51'),
(877,3,132,'09395151193','2022-12-15 11:12:31','2022-12-15 11:12:31'),
(878,198,264,'','2022-12-15 12:50:15','2022-12-15 12:50:15'),
(879,199,264,'','2022-12-15 12:50:15','2022-12-15 12:50:15'),
(880,198,232,'','2022-12-15 12:50:53','2022-12-15 12:50:53'),
(881,199,232,'','2022-12-15 12:50:53','2022-12-15 12:50:53'),
(882,202,236,'','2022-12-15 13:04:12','2022-12-15 13:04:12'),
(883,203,236,'','2022-12-15 13:04:12','2022-12-15 13:04:12'),
(884,202,246,'','2022-12-15 13:05:37','2022-12-15 13:05:37'),
(885,203,246,'','2022-12-15 13:05:37','2022-12-15 13:05:37'),
(886,198,270,'','2022-12-15 21:00:32','2022-12-15 21:00:32'),
(887,199,270,'','2022-12-15 21:00:32','2022-12-15 21:00:32'),
(888,36,403,'78.157.56.232','2022-12-16 08:38:10','2022-12-16 08:38:10'),
(889,37,403,'78.157.56.232','2022-12-16 08:38:10','2022-12-16 08:38:10'),
(890,126,404,'centos-7.9-x86_64','2022-12-17 01:19:05','2023-01-28 17:06:24'),
(891,126,405,'ubuntu-20.04-x86_64','2022-12-17 04:29:51','2022-12-17 04:29:51'),
(892,198,273,'','2022-12-17 07:36:35','2022-12-17 07:36:35'),
(893,199,273,'','2022-12-17 07:36:35','2022-12-17 07:36:35'),
(894,125,405,'','2022-12-17 08:01:41','2023-01-20 20:15:38'),
(895,127,405,'','2022-12-17 08:01:41','2022-12-17 08:01:41'),
(1065,152,441,'','2022-12-27 21:16:52','2022-12-27 21:16:52'),
(897,125,404,'173','2022-12-17 17:18:33','2022-12-17 17:18:33'),
(898,127,404,'','2022-12-17 17:18:33','2022-12-17 17:18:33'),
(1068,200,431,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(900,145,406,'','2022-12-17 19:23:50','2022-12-17 19:23:50'),
(901,152,406,'','2022-12-17 19:23:50','2022-12-17 19:23:50'),
(902,212,182,'','2022-12-17 19:40:33','2022-12-17 19:40:33'),
(903,213,182,'','2022-12-17 19:40:33','2022-12-17 19:40:33'),
(904,202,197,'','2022-12-17 19:48:57','2022-12-17 19:48:57'),
(905,203,197,'','2022-12-17 19:48:57','2022-12-17 19:48:57'),
(906,3,133,'09200585334','2022-12-18 09:29:43','2022-12-18 09:29:43'),
(907,126,407,'ubuntu-20.04-x86_64','2022-12-18 09:29:51','2022-12-18 09:29:51'),
(908,125,407,'177','2022-12-18 09:34:33','2022-12-18 10:32:37'),
(909,127,407,'','2022-12-18 09:34:33','2022-12-18 09:34:33'),
(1064,145,441,'','2022-12-27 21:16:52','2022-12-27 21:16:52'),
(911,3,134,'09120143449','2022-12-19 12:08:00','2022-12-19 12:08:00'),
(912,145,408,'','2022-12-19 12:12:23','2022-12-19 12:12:23'),
(913,152,408,'','2022-12-19 12:12:23','2022-12-19 12:12:23'),
(914,3,135,'09389742070','2022-12-19 12:49:58','2022-12-19 12:49:58'),
(915,3,136,'09359534710','2022-12-19 13:55:28','2022-12-19 13:55:28'),
(916,126,409,'ubuntu-20.04-x86_64','2022-12-19 17:51:33','2022-12-19 17:51:33'),
(917,125,409,'178','2022-12-19 17:57:34','2022-12-19 17:57:34'),
(918,127,409,'','2022-12-19 17:57:34','2022-12-19 17:57:34'),
(1063,214,440,'','2022-12-27 18:07:02','2022-12-27 18:07:02'),
(1208,126,471,'ubuntu-20.04-x86_64','2023-01-04 21:26:22','2023-01-04 21:26:22'),
(1207,3,181,'09128926817','2023-01-04 21:26:16','2023-01-04 21:26:16'),
(1055,214,349,'E2AnkdETaa77TACP','0000-00-00 00:00:00','2023-02-09 17:38:57'),
(924,3,137,'09120617355','2022-12-20 00:57:50','2022-12-20 00:57:50'),
(925,126,411,'ubuntu-20.04-x86_64','2022-12-20 00:57:57','2022-12-20 00:57:57'),
(926,125,411,'180','2022-12-20 06:03:16','2022-12-20 06:03:16'),
(927,127,411,'','2022-12-20 06:03:16','2022-12-20 06:03:16'),
(1062,127,440,'','2022-12-27 18:07:02','2022-12-27 18:07:02'),
(929,198,292,'','2022-12-20 07:58:40','2022-12-20 07:58:40'),
(930,199,292,'','2022-12-20 07:58:40','2022-12-20 07:58:40'),
(931,200,293,'','2022-12-20 08:01:18','2022-12-20 08:01:18'),
(932,201,293,'','2022-12-20 08:01:18','2022-12-20 08:01:18'),
(933,145,412,'','2022-12-20 08:13:37','2022-12-20 08:13:37'),
(934,152,412,'','2022-12-20 08:13:37','2022-12-20 08:13:37'),
(935,135,413,'ubuntu-20.04-x86_64','2022-12-20 09:41:53','2022-12-20 09:41:53'),
(936,130,413,'181','2022-12-20 10:20:02','2022-12-20 10:20:02'),
(937,139,413,'','2022-12-20 10:20:02','2022-12-20 10:20:02'),
(1051,127,439,'','2022-12-27 09:40:49','2022-12-27 09:40:49'),
(1304,138,498,'','2023-01-11 13:44:10','2023-01-11 13:44:10'),
(1288,125,494,'','2023-01-10 13:34:10','2023-01-10 13:34:10'),
(941,198,414,'','2022-12-20 15:37:12','2022-12-20 15:37:12'),
(942,199,414,'','2022-12-20 15:37:12','2022-12-20 15:37:12'),
(943,3,138,'alireza','2022-12-20 19:55:17','2022-12-20 19:55:17'),
(944,126,415,'ubuntu-20.04-x86_64','2022-12-20 19:55:22','2022-12-20 19:55:22'),
(945,3,139,'09382041384','2022-12-20 20:00:23','2022-12-20 20:00:23'),
(946,125,415,'182','2022-12-20 20:03:05','2023-01-11 09:15:14'),
(947,127,415,'','2022-12-20 20:03:05','2022-12-20 20:03:05'),
(1061,125,440,'','2022-12-27 18:07:02','2022-12-27 18:07:02'),
(949,126,416,'ubuntu-20.04-x86_64','2022-12-20 20:14:40','2022-12-20 20:14:40'),
(950,125,416,'','2022-12-20 20:34:11','2022-12-20 20:34:11'),
(951,127,416,'','2022-12-20 20:34:11','2022-12-20 20:34:11'),
(953,3,140,'09352850431','2022-12-21 07:43:45','2022-12-21 07:43:45'),
(954,126,417,'debian-11-x86_64','2022-12-21 07:43:56','2022-12-21 07:43:56'),
(955,3,141,'09374761038','2022-12-21 07:45:17','2022-12-21 07:45:17'),
(956,126,418,'ubuntu-20.04-x86_64','2022-12-21 07:45:23','2022-12-21 07:45:23'),
(957,126,419,'ubuntu-20.04-x86_64','2022-12-21 07:52:09','2022-12-21 07:52:09'),
(958,125,419,'184','2022-12-21 08:04:22','2023-01-23 07:20:33'),
(959,127,419,'','2022-12-21 08:04:22','2022-12-21 08:04:22'),
(1060,126,440,'ubuntu-20.04-x86_64','2022-12-27 18:02:24','2022-12-27 18:02:24'),
(961,126,420,'debian-11-x86_64','2022-12-21 09:07:26','2022-12-21 09:07:26'),
(962,126,421,'debian-10-x86_64','2022-12-21 09:12:20','2022-12-21 09:20:25'),
(963,125,421,'185','2022-12-21 09:20:25','2022-12-21 09:20:25'),
(964,127,421,'','2022-12-21 09:20:25','2022-12-21 09:20:25'),
(1059,3,155,'09174729480','2022-12-27 18:02:15','2022-12-27 18:02:15'),
(966,3,142,'09146444359','2022-12-21 13:15:11','2022-12-21 13:15:11'),
(967,3,143,'09125638578','2022-12-21 14:13:02','2022-12-21 14:13:02'),
(968,126,422,'ubuntu-20.04-x86_64','2022-12-21 14:13:08','2022-12-21 14:13:08'),
(969,125,422,'','2022-12-21 14:23:50','2022-12-21 14:23:50'),
(970,127,422,'','2022-12-21 14:23:50','2022-12-21 14:23:50'),
(1058,214,383,'','2022-12-27 17:32:06','2022-12-27 17:32:06'),
(972,3,144,'09164208511','2022-12-21 15:12:41','2022-12-21 15:12:41'),
(973,134,423,'ubuntu-20.04-x86_64','2022-12-21 15:12:46','2022-12-21 15:12:46'),
(974,129,423,'193','2022-12-21 15:19:05','2023-01-23 09:18:32'),
(975,138,423,'','2022-12-21 15:19:05','2022-12-21 15:19:05'),
(1054,214,255,'fOqJJFW9gtXuoKae','0000-00-00 00:00:00','2023-02-09 17:38:13'),
(977,3,145,'09360901792','2022-12-21 18:40:40','2022-12-21 18:40:40'),
(978,200,303,'','2022-12-22 09:29:05','2022-12-22 09:29:05'),
(979,201,303,'','2022-12-22 09:29:05','2022-12-22 09:29:05'),
(980,198,278,'','2022-12-22 09:29:58','2022-12-22 09:29:58'),
(981,199,278,'','2022-12-22 09:29:58','2022-12-22 09:29:58'),
(982,198,294,'','2022-12-22 09:30:38','2022-12-22 09:30:38'),
(983,199,294,'','2022-12-22 09:30:38','2022-12-22 09:30:38'),
(984,198,279,'','2022-12-22 09:31:08','2022-12-22 09:31:08'),
(985,199,279,'','2022-12-22 09:31:08','2022-12-22 09:31:08'),
(986,198,345,'','2022-12-22 09:33:26','2022-12-22 09:33:26'),
(987,199,345,'','2022-12-22 09:33:26','2022-12-22 09:33:26'),
(988,200,301,'','2022-12-22 09:34:16','2022-12-22 09:34:16'),
(989,201,301,'','2022-12-22 09:34:16','2022-12-22 09:34:16'),
(990,202,280,'','2022-12-22 09:35:49','2022-12-22 09:35:49'),
(991,203,280,'','2022-12-22 09:35:49','2022-12-22 09:35:49'),
(992,3,146,'09335811327','2022-12-22 11:52:05','2022-12-22 11:52:05'),
(993,126,424,'ubuntu-18.04-x86_64','2022-12-22 11:52:28','2022-12-22 11:52:28'),
(994,125,424,'188','2022-12-22 11:59:39','2022-12-22 11:59:39'),
(995,127,424,'','2022-12-22 11:59:39','2022-12-22 11:59:39'),
(1273,3,192,'09385287962','2023-01-10 07:36:55','2023-01-10 07:36:55'),
(997,145,425,'','2022-12-22 17:12:38','2022-12-22 17:12:38'),
(998,152,425,'','2022-12-22 17:12:38','2022-12-22 17:12:38'),
(999,3,147,'server.take.ir','2022-12-22 17:44:49','2022-12-22 17:44:49'),
(1000,145,426,'','2022-12-22 17:47:17','2022-12-22 17:47:17'),
(1001,152,426,'','2022-12-22 17:47:17','2022-12-22 17:47:17'),
(1002,145,427,'','2022-12-22 17:51:38','2022-12-22 17:51:38'),
(1003,152,427,'','2022-12-22 17:51:38','2022-12-22 17:51:38'),
(1004,126,428,'ubuntu-20.04-x86_64','2022-12-22 19:29:22','2022-12-22 19:29:22'),
(1005,125,428,'189','2022-12-22 20:58:00','2022-12-22 20:58:00'),
(1006,127,428,'','2022-12-22 20:58:00','2022-12-22 20:58:00'),
(1049,214,404,'kBOfWgoHeCyPyMID','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1008,3,148,'09228302678','2022-12-23 12:57:39','2022-12-23 12:57:39'),
(1009,145,429,'','2022-12-23 13:18:09','2022-12-23 13:18:09'),
(1010,152,429,'','2022-12-23 13:18:09','2022-12-23 13:18:09'),
(1011,3,149,'09028015695','2022-12-23 15:13:44','2022-12-23 15:13:44'),
(1012,126,430,'ubuntu-20.04-x86_64','2022-12-23 15:13:54','2022-12-23 15:13:54'),
(1013,125,430,'287','2022-12-23 15:21:23','2023-02-04 18:12:14'),
(1014,127,430,'','2022-12-23 15:21:23','2022-12-23 15:21:23'),
(1016,3,150,'09124445922','2022-12-24 06:43:13','2022-12-24 06:43:13'),
(1319,127,500,'','2023-01-12 07:26:24','2023-01-12 07:26:24'),
(1320,214,500,'81fjTDiqe5dRLt9A','2023-01-12 07:26:24','2023-01-12 07:26:24'),
(1021,3,151,'09156640896','2022-12-24 11:00:09','2022-12-24 11:00:09'),
(1022,126,432,'ubuntu-20.04-x86_64','2022-12-24 11:00:46','2022-12-24 11:00:46'),
(1023,125,432,'195','2022-12-24 11:08:01','2022-12-24 11:08:01'),
(1024,127,432,'','2022-12-24 11:08:01','2022-12-24 11:08:01'),
(1754,206,559,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1027,152,433,'','2022-12-25 17:10:13','2022-12-25 17:10:13'),
(1028,145,434,'','2022-12-25 17:13:14','2022-12-25 17:13:14'),
(1029,152,434,'','2022-12-25 17:13:14','2022-12-25 17:13:14'),
(1030,126,435,'ubuntu-20.04-x86_64','2022-12-25 22:25:48','2022-12-25 22:25:48'),
(1033,3,152,'09120219788','2022-12-26 05:37:50','2022-12-26 05:37:50'),
(1034,145,436,'','2022-12-26 05:42:34','2022-12-26 05:42:34'),
(1035,152,436,'','2022-12-26 05:42:34','2022-12-26 05:42:34'),
(1036,125,435,'196','2022-12-26 06:55:36','2022-12-26 06:55:36'),
(1037,127,435,'','2022-12-26 06:55:36','2022-12-26 06:55:36'),
(1048,214,249,'h61vmxj0Q372KGRo','0000-00-00 00:00:00','2023-02-09 17:38:24'),
(1321,125,501,'233','2023-01-12 07:28:41','2023-01-12 07:28:41'),
(1039,159,437,'','2022-12-26 09:10:33','2022-12-26 09:10:33'),
(1040,160,437,'138.201.89.237','2022-12-26 09:10:33','2022-12-26 09:10:33'),
(1041,3,153,'09120850616','2022-12-26 09:44:43','2022-12-26 09:44:43'),
(1042,135,438,'ubuntu-20.04-x86_64','2022-12-26 09:48:10','2022-12-26 09:48:10'),
(1043,130,438,'','2022-12-26 09:54:06','2022-12-26 09:54:06'),
(1044,139,438,'','2022-12-26 09:54:06','2022-12-26 09:54:06'),
(1050,125,439,'','2022-12-27 09:40:49','2022-12-27 09:40:49'),
(1046,3,154,'09999588032','2022-12-27 09:06:02','2022-12-27 09:06:02'),
(1047,126,439,'ubuntu-20.04-x86_64','2022-12-27 09:08:49','2022-12-27 09:08:49'),
(1140,3,167,'09134898906','2022-12-30 20:38:41','2022-12-30 20:38:41'),
(1141,126,457,'ubuntu-20.04-x86_64','2022-12-30 20:38:48','2022-12-30 20:38:48'),
(1142,125,457,'','2022-12-30 21:20:29','2022-12-30 21:20:29'),
(1143,127,457,'','2022-12-30 21:20:29','2022-12-30 21:20:29'),
(1144,214,457,'','2022-12-30 21:20:29','2023-02-01 10:09:25'),
(1146,199,228,'','2022-12-31 09:12:44','2022-12-31 09:12:44'),
(1148,3,168,'09399117912','2023-01-01 20:25:46','2023-01-01 20:25:46'),
(1149,126,458,'centos-7.9-x86_64','2023-01-01 20:31:15','2023-02-18 13:44:22'),
(1150,125,458,'208','2023-01-01 21:28:09','2023-01-01 21:28:09'),
(1151,127,458,'','2023-01-01 21:28:09','2023-01-01 21:28:09'),
(1152,214,458,'','2023-01-01 21:28:09','2023-02-18 13:44:22'),
(1153,216,341,'F3W5wnSQaVOKbzWz','2023-01-01 21:29:59','2023-02-09 17:04:18'),
(1154,214,283,'M6GCG98xLRbKNnip','2023-01-01 21:31:38','2023-02-19 07:54:06'),
(1155,3,169,'09189178663','2023-01-02 14:27:41','2023-01-02 14:27:41'),
(1156,3,170,'09141761311','2023-01-02 16:05:56','2023-01-02 16:05:56'),
(1157,133,460,'ubuntu-18','2023-01-02 16:31:26','2023-01-02 16:31:26'),
(1158,132,460,'209','2023-01-02 16:34:10','2023-01-27 09:20:53'),
(1159,137,460,'','2023-01-02 16:34:10','2023-01-02 16:34:10'),
(1160,217,460,'','0000-00-00 00:00:00','2023-01-27 09:20:20'),
(1161,3,171,'09302273906','2023-01-02 21:59:08','2023-01-02 21:59:08'),
(1162,126,461,'ubuntu-20.04-x86_64','2023-01-02 21:59:14','2023-01-02 21:59:14'),
(1163,125,461,'','2023-01-03 07:25:28','2023-01-03 07:25:28'),
(1164,127,461,'','2023-01-03 07:25:28','2023-01-03 07:25:28'),
(1165,214,461,'','2023-01-03 07:25:28','2023-01-03 07:25:28'),
(1166,198,334,'','2023-01-03 08:09:02','2023-01-03 08:09:02'),
(1167,199,334,'','2023-01-03 08:09:02','2023-01-03 08:09:02'),
(1168,214,335,'BvsjxxWiVLNdIZMs','2023-01-03 08:11:47','2023-01-03 08:11:47'),
(1169,3,172,'09129309485','2023-01-03 10:41:40','2023-01-03 10:41:40'),
(1170,126,462,'ubuntu-20.04-x86_64','2023-01-03 10:41:47','2023-01-03 10:41:47'),
(1171,125,462,'','2023-01-03 10:48:33','2023-01-03 10:48:33'),
(1172,127,462,'','2023-01-03 10:48:33','2023-01-03 10:48:33'),
(1173,214,462,'','2023-01-03 10:48:33','2023-02-10 07:03:02'),
(1174,3,173,'09172760201','2023-01-03 15:04:15','2023-01-03 15:04:15'),
(1175,126,463,'ubuntu-20.04-x86_64','2023-01-03 15:07:30','2023-01-03 15:07:30'),
(1176,126,464,'ubuntu-20.04-x86_64','2023-01-03 15:11:06','2023-01-03 15:11:06'),
(1177,125,464,'','2023-01-03 15:16:17','2023-01-03 15:16:17'),
(1178,127,464,'','2023-01-03 15:16:17','2023-01-03 15:16:17'),
(1179,214,464,'7sJGa2yGkWiK5P2v','2023-01-03 15:16:17','2023-02-04 09:48:51'),
(1180,3,174,'09203104830','2023-01-03 18:39:14','2023-01-03 18:39:14'),
(1181,126,465,'ubuntu-18.04-x86_64','2023-01-03 18:39:22','2023-01-03 18:39:22'),
(1182,125,465,'214','2023-01-03 18:48:06','2023-01-27 11:18:37'),
(1183,127,465,'','2023-01-03 18:48:06','2023-01-03 18:48:06'),
(1184,214,465,'','2023-01-03 18:48:06','2023-01-27 11:18:24'),
(1186,3,176,'09152739749','2023-01-04 07:54:37','2023-01-04 07:54:37'),
(1187,3,177,'۰۹۳۵۶۵۲۶۵۵۲','2023-01-04 08:44:00','2023-01-04 08:44:00'),
(1188,126,466,'ubuntu-16.04-x86_64','2023-01-04 10:15:24','2023-01-04 10:15:24'),
(1189,125,466,'','2023-01-04 10:21:44','2023-01-04 10:21:44'),
(1190,127,466,'','2023-01-04 10:21:44','2023-01-04 10:21:44'),
(1191,214,466,'','2023-01-04 10:21:44','2023-01-04 10:21:44'),
(1192,145,467,'','2023-01-04 11:03:19','2023-01-04 11:03:19'),
(1193,152,467,'','2023-01-04 11:03:19','2023-01-04 11:03:19'),
(1194,3,178,'09025545656','2023-01-04 12:34:06','2023-01-04 12:34:06'),
(1195,145,468,'','2023-01-04 12:34:12','2023-01-04 12:34:12'),
(1196,152,468,'','2023-01-04 12:34:12','2023-01-04 12:34:12'),
(1197,126,469,'ubuntu-20.04-x86_64','2023-01-04 14:19:01','2023-01-04 14:19:01'),
(1198,125,469,'','2023-01-04 14:22:22','2023-01-04 14:22:22'),
(1199,127,469,'','2023-01-04 14:22:22','2023-01-04 14:22:22'),
(1200,214,469,'','2023-01-04 14:22:22','2023-02-05 10:23:29'),
(1201,3,179,'09398120138','2023-01-04 19:05:38','2023-01-04 19:05:38'),
(1202,126,470,'ubuntu-20.04-x86_64','2023-01-04 19:07:44','2023-01-04 19:07:44'),
(1203,125,470,'','2023-01-04 19:16:16','2023-01-04 19:16:16'),
(1204,127,470,'','2023-01-04 19:16:16','2023-01-04 19:16:16'),
(1205,214,470,'XxF9gzwVerAnez54','2023-01-04 19:16:16','2023-02-05 10:26:19'),
(1206,3,180,'09178982616','2023-01-04 19:42:18','2023-01-04 19:42:18'),
(1213,125,472,'','2023-01-04 21:45:34','2023-01-04 21:45:34'),
(1214,127,472,'','2023-01-04 21:45:34','2023-01-04 21:45:34'),
(1215,214,472,'','2023-01-04 21:45:34','2023-02-06 08:13:22'),
(1216,3,182,'09190982348','2023-01-04 22:14:56','2023-01-04 22:14:56'),
(1217,134,473,'ubuntu-18.04-x86_64','2023-01-04 22:15:04','2023-01-04 22:15:04'),
(1688,3,257,'09383403350','2023-02-07 10:06:05','2023-02-07 10:06:05'),
(1218,214,347,'z8ccBrD10BIK7rGy','2023-01-05 05:17:11','2023-02-08 10:26:07'),
(1219,126,474,'ubuntu-20.04-x86_64','2023-01-05 05:47:27','2023-01-05 05:47:27'),
(1220,125,474,'','2023-01-05 07:39:10','2023-01-05 07:39:10'),
(1221,127,474,'','2023-01-05 07:39:10','2023-01-05 07:39:10'),
(1222,214,474,'','2023-01-05 07:39:10','2023-02-07 06:29:09'),
(1223,125,475,'219','2023-01-05 08:01:58','2023-01-05 08:07:23'),
(1224,126,475,'centos-7.9-x86_64','2023-01-05 08:01:58','2023-01-14 18:11:22'),
(1225,127,475,'','2023-01-05 08:01:58','2023-01-05 08:01:58'),
(1226,214,475,'aYC5jaV1EH51mX30','2023-01-05 08:01:58','2023-02-09 17:38:40'),
(1227,198,342,'','2023-01-05 08:09:55','2023-01-05 08:09:55'),
(1228,199,342,'','2023-01-05 08:09:55','2023-01-05 08:09:55'),
(1229,214,339,'9IEmfsRjb5ODMyb5','2023-01-05 08:12:07','2023-01-05 08:12:07'),
(1230,214,340,'','2023-01-05 08:12:59','2023-01-05 08:12:59'),
(1231,3,183,'09031168444','2023-01-05 08:40:45','2023-01-05 08:40:45'),
(1232,126,476,'ubuntu-18.04-x86_64','2023-01-05 08:42:45','2023-01-05 08:42:45'),
(1233,125,476,'','2023-01-05 08:47:33','2023-01-28 07:19:08'),
(1234,127,476,'','2023-01-05 08:47:33','2023-01-05 08:47:33'),
(1235,214,476,'','2023-01-05 08:47:33','2023-01-28 07:18:45'),
(1236,145,477,'','2023-01-05 14:54:41','2023-01-05 14:54:41'),
(1237,152,477,'','2023-01-05 14:54:41','2023-01-05 14:54:41'),
(1238,214,346,'VW0VFap0Cm6KyBIA','2023-01-06 09:31:10','2023-01-06 09:31:10'),
(1239,125,478,'224','2023-01-06 10:00:09','2023-01-06 10:00:57'),
(1240,126,478,'centos-7.9-x86_64','2023-01-06 10:00:09','2023-01-13 18:12:32'),
(1241,127,478,'','2023-01-06 10:00:09','2023-01-06 10:00:09'),
(1242,214,478,'Oj1MTeOm32T4ROh1','2023-01-06 10:00:09','2023-02-14 17:08:35'),
(1243,3,184,'09222778507','2023-01-06 13:21:37','2023-01-06 13:21:37'),
(1244,145,479,'','2023-01-06 13:23:05','2023-01-06 13:23:05'),
(1245,152,479,'','2023-01-06 13:23:05','2023-01-06 13:23:05'),
(1247,3,185,'09384999655','2023-01-06 13:44:34','2023-01-06 13:44:34'),
(1251,3,187,'09354975105','2023-01-07 14:50:04','2023-01-07 14:50:04'),
(1252,3,188,'09981505051','2023-01-07 19:16:21','2023-01-07 19:16:21'),
(1253,126,484,'ubuntu-20.04-x86_64','2023-01-07 19:18:56','2023-01-07 19:18:56'),
(1254,125,484,'','2023-01-07 19:22:56','2023-01-07 19:22:56'),
(1255,127,484,'','2023-01-07 19:22:56','2023-01-07 19:22:56'),
(1256,214,484,'','2023-01-07 19:22:56','2023-02-10 11:44:49'),
(1257,214,348,'','2023-01-08 08:49:03','2023-01-08 08:49:03'),
(1258,145,485,'','2023-01-08 08:50:43','2023-01-08 08:50:43'),
(1259,152,485,'','2023-01-08 08:50:43','2023-01-08 08:50:43'),
(1260,145,486,'','2023-01-08 08:50:43','2023-01-08 08:50:43'),
(1261,152,486,'','2023-01-08 08:50:43','2023-01-08 08:50:43'),
(1262,145,487,'','2023-01-08 08:50:43','2023-01-08 08:50:43'),
(1263,152,487,'','2023-01-08 08:50:43','2023-01-08 08:50:43'),
(1264,3,189,'09130942381','2023-01-09 00:48:34','2023-01-09 00:48:34'),
(1265,3,190,'09902083341','2023-01-09 09:03:53','2023-01-09 09:03:53'),
(1266,3,191,'09217961972','2023-01-09 11:14:12','2023-01-09 11:14:12'),
(1267,126,488,'ubuntu-20.04-x86_64','2023-01-09 11:14:18','2023-01-09 11:14:18'),
(1268,125,488,'','2023-01-09 11:47:57','2023-01-09 11:47:57'),
(1269,127,488,'','2023-01-09 11:47:57','2023-01-09 11:47:57'),
(1270,214,488,'','2023-01-09 11:47:57','2023-02-10 07:04:34'),
(1271,145,489,'','2023-01-09 16:18:12','2023-01-09 16:18:12'),
(1272,152,489,'','2023-01-09 16:18:12','2023-01-09 16:18:12'),
(1274,126,490,'ubuntu-20.04-x86_64','2023-01-10 08:15:09','2023-01-10 08:15:09'),
(1275,125,490,'','2023-01-10 08:32:25','2023-01-10 08:32:25'),
(1276,127,490,'','2023-01-10 08:32:25','2023-01-10 08:32:25'),
(1277,214,490,'','2023-01-10 08:32:25','2023-02-11 09:00:14'),
(1278,145,491,'','2023-01-10 10:14:38','2023-01-10 10:14:38'),
(1279,152,491,'','2023-01-10 10:14:38','2023-01-10 10:14:38'),
(1280,3,193,'09166109969','2023-01-10 10:46:27','2023-01-10 10:46:27'),
(1281,126,492,'ubuntu-18.04-x86_64','2023-01-10 10:53:58','2023-01-10 10:53:58'),
(1282,125,492,'228','2023-01-10 11:01:42','2023-01-10 11:01:42'),
(1283,127,492,'','2023-01-10 11:01:42','2023-01-10 11:01:42'),
(1284,214,492,'StK0qQ5HdW6Hb7O3','2023-01-10 11:01:42','2023-01-10 11:01:42'),
(1343,214,381,'6lWwKLL24Klg4hDC','2023-01-12 23:44:33','2023-01-12 23:44:33'),
(1344,125,505,'','2023-01-12 23:57:11','2023-01-30 09:43:30'),
(1345,127,505,'','2023-01-12 23:57:11','2023-01-12 23:57:11'),
(1346,214,505,'','2023-01-12 23:57:11','2023-02-18 13:48:40'),
(1777,3,267,'09367622186','2023-02-18 17:54:07','2023-02-18 17:54:07'),
(1347,126,506,'ubuntu-22.04-x86_64','2023-01-13 19:47:53','2023-01-13 19:47:53'),
(1348,125,506,'237','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1349,214,506,'8jYax18szFiT69nP','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1350,126,507,'ubuntu-20.04-x86_64','2023-01-14 13:43:26','2023-01-14 13:43:26'),
(1351,198,508,'','2023-01-14 13:46:04','2023-01-14 13:46:04'),
(1352,199,508,'','2023-01-14 13:46:04','2023-01-14 13:46:04'),
(1353,125,507,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1354,214,507,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1355,214,319,'On0kYdlST57Ay6XU','2023-01-14 17:12:28','2023-01-27 11:53:43'),
(1356,198,509,'','2023-01-14 17:47:50','2023-01-14 17:47:50'),
(1357,199,509,'','2023-01-14 17:47:50','2023-01-14 17:47:50'),
(1358,3,200,'09360720099','2023-01-14 19:33:10','2023-01-14 19:33:10'),
(1359,198,510,'','2023-01-14 20:36:20','2023-01-14 20:36:20'),
(1360,199,510,'','2023-01-14 20:36:20','2023-01-14 20:36:20'),
(1361,3,201,'09901306283','2023-01-15 00:36:11','2023-01-15 00:36:11'),
(1362,126,511,'ubuntu-20.04-x86_64','2023-01-15 00:40:47','2023-01-15 00:40:47'),
(1363,198,512,'','2023-01-15 10:10:21','2023-01-15 10:10:21'),
(1364,199,512,'','2023-01-15 10:10:21','2023-01-15 10:10:21'),
(1365,3,202,'09168030360','2023-01-15 11:37:44','2023-01-15 11:37:44'),
(1366,145,513,'','2023-01-15 18:38:35','2023-01-15 18:38:35'),
(1367,152,513,'','2023-01-15 18:38:35','2023-01-15 18:38:35'),
(1368,214,200,'','2023-01-16 09:19:04','2023-01-16 09:19:04'),
(1369,214,395,'J5o8LQsIVcUP8k2z','2023-01-16 09:19:57','2023-01-16 09:19:57'),
(1370,3,203,'09181761086','2023-01-16 21:29:38','2023-01-16 21:29:38'),
(1371,145,515,'','2023-01-16 21:33:04','2023-01-16 21:33:04'),
(1372,152,515,'','2023-01-16 21:33:04','2023-01-16 21:33:04'),
(1373,3,204,'09120853818','2023-01-17 12:22:45','2023-01-17 12:22:45'),
(1374,145,516,'','2023-01-17 12:22:56','2023-01-17 12:22:56'),
(1375,152,516,'','2023-01-17 12:22:56','2023-01-17 12:22:56'),
(1376,3,205,'09390701577','2023-01-17 13:36:25','2023-01-17 13:36:25'),
(1377,134,517,'ubuntu-20.04-x86_64','2023-01-17 13:36:35','2023-01-17 13:36:35'),
(1378,126,518,'ubuntu-20.04-x86_64','2023-01-17 13:40:52','2023-01-17 13:40:52'),
(1379,125,518,'240','0000-00-00 00:00:00','2023-01-28 08:05:35'),
(1380,214,518,'ZdJRiiHA6pfbVc7t','0000-00-00 00:00:00','2023-02-11 08:10:42'),
(1381,129,517,'241','2023-01-17 13:44:11','2023-01-17 13:44:11'),
(1382,138,517,'','2023-01-17 13:44:11','2023-01-17 13:44:11'),
(1383,215,517,'TXVZnZcNwcD3eFbU','2023-01-17 13:44:11','2023-02-18 13:42:53'),
(1384,214,399,'1eZZ8dDe970SIRTr','2023-01-17 13:54:28','2023-01-17 13:54:28'),
(1385,214,401,'wqK5UYccynPJcyhu','2023-01-17 13:55:11','2023-01-17 13:55:11'),
(1386,3,206,'09364369243','2023-01-17 15:36:09','2023-01-17 15:36:09'),
(1387,127,507,'','2023-01-17 15:43:41','2023-01-17 15:43:41'),
(1388,3,207,'09923784283','2023-01-17 16:54:44','2023-01-17 16:54:44'),
(1389,126,519,'ubuntu-22.04-x86_64','2023-01-17 16:54:52','2023-01-17 16:54:52'),
(1390,125,519,'242','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1391,214,519,'JNVTYzpnAjrGbNz4','0000-00-00 00:00:00','2023-02-18 13:37:52'),
(1392,3,208,'09111831780','2023-01-17 20:37:35','2023-01-17 20:37:35'),
(1393,3,209,'09399176162','2023-01-17 22:37:19','2023-01-17 22:37:19'),
(1394,126,520,'ubuntu-22.04-x86_64','2023-01-17 22:37:24','2023-01-17 22:37:24'),
(1395,125,520,'243','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1396,214,520,'xDJFlKDRapms8INe','0000-00-00 00:00:00','2023-02-19 07:54:47'),
(1397,3,210,'09305301679','2023-01-18 03:23:40','2023-01-18 03:23:40'),
(1398,3,211,'09357106197','2023-01-18 07:46:43','2023-01-18 07:46:43'),
(1399,3,212,'09149292803','2023-01-18 10:08:32','2023-01-18 10:08:32'),
(1400,126,522,'ubuntu-20.04-x86_64','2023-01-18 10:08:36','2023-01-18 10:08:36'),
(1401,125,522,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1402,214,522,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1403,3,213,'09366474147','2023-01-18 18:16:19','2023-01-18 18:16:19'),
(1404,126,523,'ubuntu-20.04-x86_64','2023-01-18 18:16:24','2023-01-18 18:16:24'),
(1405,125,523,'246','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1406,214,523,'LPG3SocicOLgtGvf','0000-00-00 00:00:00','2023-02-19 07:54:34'),
(1407,145,524,'','2023-01-18 20:45:04','2023-01-18 20:45:04'),
(1408,152,524,'','2023-01-18 20:45:04','2023-01-18 20:45:04'),
(1409,3,214,'۰۹۱۲۱۰۶۵۶۲۵','2023-01-18 20:49:01','2023-01-18 20:49:01'),
(1410,3,215,'09338887989','2023-01-19 12:39:24','2023-01-19 12:39:24'),
(1411,126,526,'ubuntu-20.04-x86_64','2023-01-19 12:39:28','2023-01-19 12:39:28'),
(1412,126,527,'ubuntu-20.04-x86_64','2023-01-19 12:39:28','2023-01-19 12:39:28'),
(1413,125,526,'248','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1414,214,526,'6cj7xF28wUvBchxW','0000-00-00 00:00:00','2023-02-20 07:21:10'),
(1415,125,527,'249','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1416,214,527,'zkf02QNMFmxRdh3o','0000-00-00 00:00:00','2023-02-20 07:23:04'),
(1417,3,216,'09384121640','2023-01-20 09:29:50','2023-01-20 09:29:50'),
(1418,218,528,'','2023-01-20 12:31:20','2023-01-20 12:31:20'),
(1419,219,528,'','2023-01-20 12:31:20','2023-01-20 12:31:20'),
(1420,220,528,'','2023-01-20 12:31:20','2023-01-20 12:31:20'),
(1421,3,217,'09021182339','2023-01-20 13:23:29','2023-01-20 13:23:29'),
(1422,126,529,'ubuntu-18.04-x86_64','2023-01-20 13:26:57','2023-01-20 13:26:57'),
(1423,125,529,'250','0000-00-00 00:00:00','2023-01-29 22:42:31'),
(1424,214,529,'w3wtXrgnYyXaAFzc','0000-00-00 00:00:00','2023-02-19 18:37:50'),
(1425,3,218,'09016992861','2023-01-20 13:41:51','2023-01-20 13:41:51'),
(1426,126,530,'ubuntu-20.04-x86_64','2023-01-20 13:41:59','2023-01-20 13:41:59'),
(1427,125,530,'251','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1428,214,530,'7m93NofiyhHZqGPR','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1429,198,531,'','2023-01-20 15:02:13','2023-01-20 15:02:13'),
(1430,199,531,'','2023-01-20 15:02:13','2023-01-20 15:02:13'),
(1432,3,219,'09120615156+','2023-01-20 15:48:26','2023-01-20 15:48:26'),
(1433,126,532,'ubuntu-22.04-x86_64','2023-01-20 16:01:01','2023-01-20 16:01:01'),
(1434,125,532,'252','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1435,214,532,'FXz0i6J9FIlj8ZyY','0000-00-00 00:00:00','2023-01-28 15:00:53'),
(1436,3,220,'09378690509','2023-01-20 16:29:55','2023-01-20 16:29:55'),
(1437,214,385,'','2023-01-20 20:12:46','2023-01-20 20:12:46'),
(1438,214,382,'','2023-01-20 20:14:46','2023-01-20 20:14:46'),
(1439,214,405,'','2023-01-20 20:15:38','2023-01-20 20:15:38'),
(1440,214,407,'sDjtXAUIBOK4ZRIc','2023-01-20 20:18:05','2023-01-20 20:18:05'),
(1441,214,409,'','2023-01-20 20:18:54','2023-01-20 20:18:54'),
(1442,3,221,'09169530743','2023-01-20 22:03:42','2023-01-20 22:03:42'),
(1443,198,533,'','2023-01-20 22:07:55','2023-01-20 22:07:55'),
(1444,199,533,'','2023-01-20 22:07:55','2023-01-20 22:07:55'),
(1445,145,534,'','2023-01-21 07:01:58','2023-01-21 07:01:58'),
(1446,152,534,'','2023-01-21 07:01:58','2023-01-21 07:01:58'),
(1447,145,535,'','2023-01-21 07:04:48','2023-01-21 07:04:48'),
(1448,152,535,'','2023-01-21 07:04:48','2023-01-21 07:04:48'),
(1449,214,206,'','2023-01-21 12:40:31','2023-01-21 12:40:31'),
(1450,198,536,'','2023-01-21 12:52:16','2023-01-21 12:52:16'),
(1451,199,536,'','2023-01-21 12:52:16','2023-01-21 12:52:16'),
(1452,127,527,'','2023-01-21 18:50:29','2023-01-21 18:50:29'),
(1453,127,526,'','2023-01-21 18:50:43','2023-01-21 18:50:43'),
(1454,198,537,'','2023-01-21 23:06:09','2023-01-21 23:06:09'),
(1455,199,537,'','2023-01-21 23:06:09','2023-01-21 23:06:09'),
(1456,3,222,'09209202397','2023-01-22 07:43:37','2023-01-22 07:43:37'),
(1457,145,538,'','2023-01-22 07:43:45','2023-01-22 07:43:45'),
(1458,152,538,'','2023-01-22 07:43:45','2023-01-22 07:43:45'),
(1459,3,223,'09144588816','2023-01-22 14:03:00','2023-01-22 14:03:00'),
(1460,127,529,'','2023-01-22 17:48:38','2023-01-22 17:48:38'),
(1461,125,418,'','2023-01-23 07:19:53','2023-01-23 07:19:53'),
(1462,127,418,'','2023-01-23 07:19:53','2023-01-23 07:19:53'),
(1463,214,418,'','2023-01-23 07:19:53','2023-01-23 07:19:53'),
(1464,214,419,'','2023-01-23 07:20:24','2023-01-23 09:21:59'),
(1530,214,539,'LrndOxsIE5nGrrSt','0000-00-00 00:00:00','2023-01-30 10:09:35'),
(1532,125,539,'266','0000-00-00 00:00:00','2023-01-30 10:13:49'),
(1533,127,539,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1469,215,423,'op2l81idCtvt8A1L','2023-01-23 09:18:26','2023-01-23 09:18:26'),
(1470,214,421,'hK88QEdZ4NRVC83p','2023-01-23 09:20:55','2023-01-23 09:20:55'),
(1471,214,428,'xO2dDTIyYa9N6l44','2023-01-23 09:22:53','2023-01-23 09:22:53'),
(1472,200,540,'','2023-01-23 11:47:18','2023-01-23 11:47:18'),
(1473,201,540,'','2023-01-23 11:47:18','2023-01-23 11:47:18'),
(1474,200,541,'','2023-01-23 11:53:54','2023-01-23 11:53:54'),
(1475,201,541,'','2023-01-23 11:53:54','2023-01-23 11:53:54'),
(1476,198,542,'','2023-01-23 11:57:38','2023-01-23 11:57:38'),
(1477,199,542,'','2023-01-23 11:57:38','2023-01-23 11:57:38'),
(1478,145,543,'','2023-01-23 19:20:04','2023-01-23 19:20:04'),
(1479,152,543,'','2023-01-23 19:20:04','2023-01-23 19:20:04'),
(1480,3,224,'09121234567','2023-01-24 19:53:22','2023-01-24 19:53:22'),
(1481,145,544,'','2023-01-24 20:00:10','2023-01-24 20:00:10'),
(1482,152,544,'','2023-01-24 20:00:10','2023-01-24 20:00:10'),
(1483,3,225,'09357449018','2023-01-25 07:17:16','2023-01-25 07:17:16'),
(1484,126,545,'ubuntu-22.04-x86_64','2023-01-25 07:17:20','2023-01-25 07:17:20'),
(1485,125,545,'279','0000-00-00 00:00:00','2023-02-03 20:51:39'),
(1486,214,545,'kKd1Jcx7O9W2bDhH','0000-00-00 00:00:00','2023-02-09 17:58:40'),
(1487,145,546,'','2023-01-25 19:35:36','2023-01-25 19:35:36'),
(1488,152,546,'','2023-01-25 19:35:36','2023-01-25 19:35:36'),
(1489,145,547,'','2023-01-25 19:35:36','2023-01-25 19:35:36'),
(1490,152,547,'','2023-01-25 19:35:36','2023-01-25 19:35:36'),
(1491,145,548,'','2023-01-25 19:35:36','2023-01-25 19:35:36'),
(1492,152,548,'','2023-01-25 19:35:36','2023-01-25 19:35:36'),
(1493,3,226,'09373037238','2023-01-25 20:13:01','2023-01-25 20:13:01'),
(1494,126,549,'ubuntu-18.04-x86_64','2023-01-25 20:13:07','2023-01-25 20:13:07'),
(1495,125,549,'258','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1496,214,549,'oob65ndncZwTjuJA','0000-00-00 00:00:00','2023-02-10 11:48:15'),
(1497,127,518,'','2023-01-26 08:12:23','2023-01-26 08:12:23'),
(1498,198,550,'','2023-01-26 09:29:46','2023-01-26 09:29:46'),
(1499,199,550,'','2023-01-26 09:29:46','2023-01-26 09:29:46'),
(1500,198,551,'','2023-01-26 09:34:10','2023-01-26 09:34:10'),
(1501,199,551,'','2023-01-26 09:34:10','2023-01-26 09:34:10'),
(1502,145,552,'','2023-01-26 16:00:45','2023-01-26 16:00:45'),
(1503,152,552,'','2023-01-26 16:00:45','2023-01-26 16:00:45'),
(1504,126,553,'ubuntu-18.04-x86_64','2023-01-27 02:07:51','2023-01-27 02:07:51'),
(1505,125,553,'259','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1506,214,553,'RagITymJKkNvl0tP','0000-00-00 00:00:00','2023-02-09 17:58:10'),
(1507,3,227,'09332637117','2023-01-27 09:12:44','2023-01-27 09:12:44'),
(1508,126,554,'ubuntu-18.04-x86_64','2023-01-27 09:16:14','2023-01-27 09:16:14'),
(1509,125,554,'260','2023-01-27 09:25:44','2023-01-27 09:25:44'),
(1510,127,554,'','2023-01-27 09:25:44','2023-01-27 09:25:44'),
(1511,214,554,'LgQTiqQmhHg5okIP','2023-01-27 09:25:44','2023-01-27 09:25:44'),
(1512,145,555,'','2023-01-27 13:41:45','2023-01-27 13:41:45'),
(1513,152,555,'','2023-01-27 13:41:45','2023-01-27 13:41:45'),
(1514,145,556,'','2023-01-27 16:19:35','2023-01-27 16:19:35'),
(1515,152,556,'','2023-01-27 16:19:35','2023-01-27 16:19:35'),
(1516,127,549,'','2023-01-28 07:24:46','2023-01-28 07:24:46'),
(1517,127,553,'','2023-01-28 07:25:05','2023-01-28 07:25:05'),
(1518,127,532,'','2023-01-28 15:00:53','2023-01-28 15:00:53'),
(1755,207,559,'','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1521,145,560,'','2023-01-29 10:16:37','2023-01-29 10:16:37'),
(1522,152,560,'','2023-01-29 10:16:37','2023-01-29 10:16:37'),
(1523,3,228,'09375826264','2023-01-29 11:24:28','2023-01-29 11:24:28'),
(1524,126,561,'ubuntu-22.04-x86_64','2023-01-29 11:24:31','2023-01-29 11:24:31'),
(1525,125,561,'261','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1526,214,561,'','0000-00-00 00:00:00','2023-02-09 17:57:36'),
(1534,214,539,'LrndOxsIE5nGrrSt','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1536,3,230,'09174661235','2023-01-29 18:59:49','2023-01-29 18:59:49'),
(1537,126,562,'ubuntu-20.04-x86_64','2023-01-29 18:59:55','2023-01-29 18:59:55'),
(1538,125,562,'262','2023-01-29 19:15:36','2023-01-29 19:15:36'),
(1539,127,562,'','2023-01-29 19:15:36','2023-01-29 19:15:36'),
(1540,214,562,'','2023-01-29 19:15:36','2023-02-09 17:57:17'),
(1541,3,231,'۰۹۹۱۱۵۸۰۵۷۴','2023-01-29 19:58:33','2023-01-29 19:58:33'),
(1542,126,563,'ubuntu-20.04-x86_64','2023-01-29 19:58:39','2023-01-29 19:58:39'),
(1543,125,563,'263','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1544,214,563,'bA8Zf9VwGe7jWkzU','0000-00-00 00:00:00','2023-02-09 17:57:07'),
(1545,3,232,'09306070390','2023-01-29 20:41:06','2023-01-29 20:41:06'),
(1546,126,564,'ubuntu-20.04-x86_64','2023-01-29 20:41:14','2023-01-29 20:41:14'),
(1547,125,564,'264','2023-01-29 20:45:17','2023-01-29 20:45:17'),
(1548,127,564,'','2023-01-29 20:45:17','2023-01-29 20:45:17'),
(1549,214,564,'gz9If1eaEovtAxEC','2023-01-29 20:45:17','2023-02-09 16:59:17'),
(1550,126,539,'centos-7.9-x86_64','2023-01-29 20:46:13','2023-01-29 20:46:13'),
(1551,3,233,'09107499731','2023-01-29 23:20:31','2023-01-29 23:20:31'),
(1552,126,565,'ubuntu-22.04-x86_64','2023-01-29 23:23:00','2023-01-29 23:23:00'),
(1553,125,565,'265','2023-01-30 07:42:54','2023-01-30 07:42:54'),
(1554,127,565,'','2023-01-30 07:42:54','2023-01-30 07:42:54'),
(1555,214,565,'3ZVNzmYh4p9Q6zBK','2023-01-30 07:42:54','2023-02-09 17:56:50'),
(1556,3,234,'09192464821','2023-01-30 09:00:58','2023-01-30 09:00:58'),
(1557,125,566,'267','2023-01-30 13:08:32','2023-01-30 13:14:02'),
(1558,126,566,'ubuntu-20.04-x86_64','2023-01-30 13:08:32','2023-01-30 13:08:32'),
(1559,127,566,'','2023-01-30 13:08:32','2023-01-30 13:08:32'),
(1560,214,566,'','2023-01-30 13:08:32','2023-02-09 17:56:44'),
(1739,127,563,'','2023-02-09 17:57:07','2023-02-09 17:57:07'),
(1561,3,235,'09120054881','2023-01-30 16:38:29','2023-01-30 16:38:29'),
(1562,126,567,'ubuntu-20.04-x86_64','2023-01-30 16:38:34','2023-01-30 16:38:34'),
(1563,125,567,'268','2023-01-30 16:51:35','2023-01-30 16:51:35'),
(1564,127,567,'','2023-01-30 16:51:35','2023-01-30 16:51:35'),
(1565,214,567,'hpbJmBKF05oihT8j','2023-01-30 16:51:35','2023-02-09 17:56:28'),
(1566,126,568,'ubuntu-20.04-x86_64','2023-01-31 08:09:38','2023-01-31 08:09:38'),
(1567,125,568,'269','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1568,214,568,'4wFG789DMqimWI7s','0000-00-00 00:00:00','2023-02-09 17:56:20'),
(1569,3,236,'09339589717','2023-01-31 12:12:00','2023-01-31 12:12:00'),
(1570,126,569,'ubuntu-18.04-x86_64','2023-01-31 12:12:07','2023-01-31 12:12:07'),
(1571,125,569,'270','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1572,214,569,'zY0D4Q2ZIsr3zg1u','0000-00-00 00:00:00','2023-02-09 17:56:06'),
(1573,3,237,'09104779636','2023-01-31 12:40:20','2023-01-31 12:40:20'),
(1574,3,238,'09374845108','2023-01-31 13:18:30','2023-01-31 13:18:30'),
(1575,126,570,'ubuntu-22.04-x86_64','2023-01-31 13:22:51','2023-01-31 13:22:51'),
(1576,125,570,'271','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1577,214,570,'','0000-00-00 00:00:00','2023-02-09 17:55:54'),
(1578,126,571,'ubuntu-20.04-x86_64','2023-01-31 14:47:18','2023-01-31 14:47:18'),
(1579,125,571,'272','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1580,214,571,'jurAtocgBtMk0rSC','0000-00-00 00:00:00','2023-02-16 11:21:50'),
(1581,3,239,'09134492511','2023-01-31 15:09:51','2023-01-31 15:09:51'),
(1582,202,572,'','2023-01-31 15:09:54','2023-01-31 15:09:54'),
(1583,203,572,'','2023-01-31 15:09:54','2023-01-31 15:09:54'),
(1584,145,573,'','2023-01-31 15:29:26','2023-01-31 15:29:26'),
(1585,152,573,'','2023-01-31 15:29:26','2023-01-31 15:29:26'),
(1586,202,574,'','2023-01-31 15:51:25','2023-01-31 15:51:25'),
(1587,203,574,'','2023-01-31 15:51:25','2023-01-31 15:51:25'),
(1588,3,240,'09135961363','2023-01-31 16:03:22','2023-01-31 16:03:22'),
(1589,200,575,'','2023-01-31 16:03:26','2023-01-31 16:03:26'),
(1590,201,575,'','2023-01-31 16:03:26','2023-01-31 16:03:26'),
(1591,3,241,'09153065412','2023-02-01 06:34:07','2023-02-01 06:55:34'),
(1592,126,576,'ubuntu-22.04-x86_64','2023-02-01 06:41:17','2023-02-01 06:41:17'),
(1593,125,576,'273','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1594,214,576,'bBl1FYo5eYdmcPap','0000-00-00 00:00:00','2023-02-09 17:55:09'),
(1595,126,577,'ubuntu-22.04-x86_64','2023-02-01 12:41:54','2023-02-01 12:41:54'),
(1596,125,577,'274','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1597,214,577,'tyUYGEtZsKpsPlLU','0000-00-00 00:00:00','2023-02-09 17:55:02'),
(1600,145,579,'','2023-02-01 15:01:00','2023-02-01 15:01:00'),
(1601,152,579,'','2023-02-01 15:01:00','2023-02-01 15:01:00'),
(1602,125,580,'276','2023-02-01 15:52:58','2023-02-01 15:52:58'),
(1603,126,580,'ubuntu-18.04-x86_64','2023-02-01 15:52:58','2023-02-01 15:52:58'),
(1604,127,580,'','2023-02-01 15:52:58','2023-02-01 15:52:58'),
(1605,214,580,'HYV8EMTbFSGVkwo7','2023-02-01 15:52:58','2023-02-01 15:52:58'),
(1606,145,581,'','2023-02-01 15:52:58','2023-02-01 15:52:58'),
(1607,152,581,'','2023-02-01 15:52:58','2023-02-01 15:52:58'),
(1608,126,582,'ubuntu-18.04-x86_64','2023-02-01 17:26:38','2023-02-01 17:26:38'),
(1609,125,582,'275','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1610,214,582,'gUikqXHfdN5VcLkw','0000-00-00 00:00:00','2023-02-09 17:54:10'),
(1611,214,190,'','2023-02-02 12:17:21','2023-02-02 12:17:21'),
(1612,126,583,'ubuntu-22.04-x86_64','2023-02-02 18:52:17','2023-02-02 18:52:17'),
(1613,125,583,'277','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1614,214,583,'VcmOtNT0T7zfLcfI','0000-00-00 00:00:00','2023-02-09 17:54:00'),
(1615,145,584,'','2023-02-02 19:31:41','2023-02-02 19:31:41'),
(1616,152,584,'','2023-02-02 19:31:41','2023-02-02 19:31:41'),
(1617,126,585,'ubuntu-22.04-x86_64','2023-02-02 19:44:55','2023-02-02 19:44:55'),
(1618,125,585,'278','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1619,214,585,'XGzGAstJ4eroixxp','0000-00-00 00:00:00','2023-02-09 17:53:17'),
(1620,3,242,'09372518191','2023-02-03 14:54:47','2023-02-03 14:54:47'),
(1621,3,243,'09023891160','2023-02-03 16:54:50','2023-02-03 16:54:50'),
(1622,215,205,'','2023-02-03 17:09:02','2023-02-03 17:09:02'),
(1623,214,430,'Ku94gjjiPeVfe1eq','2023-02-03 17:12:01','2023-02-04 18:12:14'),
(1624,214,185,'','2023-02-03 17:12:58','2023-02-03 17:12:58'),
(1625,214,188,'','2023-02-03 17:16:21','2023-02-03 17:16:21'),
(1626,3,244,'09037024617','2023-02-03 17:44:17','2023-02-03 17:44:17'),
(1627,127,545,'','2023-02-03 19:31:10','2023-02-03 19:31:10'),
(1628,3,245,'09981674177','2023-02-03 21:59:56','2023-02-03 21:59:56'),
(1629,126,589,'ubuntu-22.04-x86_64','2023-02-03 22:00:04','2023-02-03 22:00:04'),
(1630,125,589,'280','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1631,214,589,'eKNlJIjQluFfSXQJ','0000-00-00 00:00:00','2023-02-09 17:51:56'),
(1632,126,590,'ubuntu-18.04-x86_64','2023-02-04 05:22:39','2023-02-04 05:22:39'),
(1633,125,590,'281','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1634,214,590,'4VIA5eoSKU1a4zJr','0000-00-00 00:00:00','2023-02-11 08:11:04'),
(1635,126,591,'ubuntu-18.04-x86_64','2023-02-04 11:11:22','2023-02-04 11:11:22'),
(1636,125,591,'282','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1637,214,591,'8l086XJFR1iMIhJY','0000-00-00 00:00:00','2023-02-09 17:50:44'),
(1638,3,246,'۰۹۳۳۲۳۵۶۶۰۴','2023-02-04 13:11:02','2023-02-04 13:11:02'),
(1639,3,247,'09121182315','2023-02-04 14:35:41','2023-02-04 14:35:41'),
(1640,3,248,'09163001394','2023-02-04 17:25:42','2023-02-04 17:25:42'),
(1641,126,592,'mikrotik-custom','2023-02-04 17:39:30','2023-02-04 17:39:30'),
(1642,125,592,'285','2023-02-04 18:00:16','2023-02-04 18:00:16'),
(1643,127,592,'','2023-02-04 18:00:16','2023-02-04 18:00:16'),
(1644,214,592,'','2023-02-04 18:00:16','2023-02-09 17:50:35'),
(1645,126,593,'ubuntu-20.04-x86_64','2023-02-05 22:06:12','2023-02-05 22:06:12'),
(1646,125,593,'288','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1647,214,593,'YTdAlsW0Cp9nRBgQ','0000-00-00 00:00:00','2023-02-09 17:50:13'),
(1648,3,249,'09372979068','2023-02-06 05:04:46','2023-02-06 05:04:46'),
(1649,126,594,'ubuntu-20.04-x86_64','2023-02-06 05:04:53','2023-02-06 05:04:53'),
(1650,125,594,'289','2023-02-06 06:29:24','2023-02-06 06:29:24'),
(1651,127,594,'','2023-02-06 06:29:24','2023-02-06 06:29:24'),
(1652,214,594,'5VVonJAzkEcmj4rD','2023-02-06 06:29:24','2023-02-09 17:49:51'),
(1653,3,250,'09023520493','2023-02-06 07:46:18','2023-02-06 07:46:18'),
(1654,126,595,'ubuntu-18.04-x86_64','2023-02-06 07:46:22','2023-02-06 07:46:22'),
(1655,125,595,'290','2023-02-06 07:51:09','2023-02-06 07:51:09'),
(1656,127,595,'','2023-02-06 07:51:09','2023-02-06 07:51:09'),
(1657,214,595,'mgfEoa45cjuUCaht','2023-02-06 07:51:09','2023-02-09 17:49:45'),
(1658,3,251,'09303024537','2023-02-06 10:06:19','2023-02-06 10:06:19'),
(1659,126,596,'ubuntu-20.04-x86_64','2023-02-06 10:08:24','2023-02-06 10:08:24'),
(1660,125,596,'291','2023-02-06 10:12:04','2023-02-06 10:12:04'),
(1661,127,596,'','2023-02-06 10:12:04','2023-02-06 10:12:04'),
(1662,214,596,'0SUmlLVFQr7ffqDh','2023-02-06 10:12:04','2023-02-16 11:17:42'),
(1663,126,597,'ubuntu-22.04-x86_64','2023-02-06 11:35:49','2023-02-06 11:35:49'),
(1664,125,597,'','2023-02-06 11:40:23','2023-02-06 11:40:23'),
(1665,127,597,'','2023-02-06 11:40:23','2023-02-06 11:40:23'),
(1666,214,597,'e91vWueFbKbu2nUw','2023-02-06 11:40:23','2023-02-06 11:40:23'),
(1667,3,252,'09193752649','2023-02-06 12:02:34','2023-02-06 12:02:34'),
(1668,126,598,'ubuntu-18.04-x86_64','2023-02-06 12:02:41','2023-02-06 12:02:41'),
(1669,125,598,'297','2023-02-06 12:08:27','2023-02-07 10:49:44'),
(1670,127,598,'','2023-02-06 12:08:27','2023-02-06 12:08:27'),
(1671,214,598,'bWtZC1O4lhnyJwVj','2023-02-06 12:08:27','2023-02-09 17:43:29'),
(1672,3,253,'09196704570','2023-02-06 13:03:51','2023-02-06 13:03:51'),
(1673,3,254,'09155458878','2023-02-06 15:27:36','2023-02-06 15:27:36'),
(1674,3,255,'09128012509','2023-02-06 15:38:05','2023-02-06 15:38:05'),
(1675,126,599,'ubuntu-18.04-x86_64','2023-02-06 17:11:05','2023-02-06 17:11:05'),
(1676,125,599,'294','2023-02-06 17:15:03','2023-02-06 17:15:03'),
(1677,127,599,'','2023-02-06 17:15:03','2023-02-06 17:15:03'),
(1678,214,599,'cVpMprYC3fxURK6V','2023-02-06 17:15:03','2023-02-09 17:43:08'),
(1679,3,256,'09193085208','2023-02-06 20:33:52','2023-02-06 20:33:52'),
(1680,126,600,'ubuntu-20.04-x86_64','2023-02-07 05:06:24','2023-02-07 05:06:24'),
(1681,126,601,'ubuntu-20.04-x86_64','2023-02-07 05:06:25','2023-02-07 05:06:25'),
(1682,125,601,'296','2023-02-07 06:03:16','2023-02-07 06:10:16'),
(1683,127,601,'','2023-02-07 06:03:16','2023-02-07 06:03:16'),
(1684,214,601,'LoZvacde9vqiAKy3','2023-02-07 06:03:16','2023-02-07 06:03:16'),
(1685,125,600,'295','2023-02-07 06:06:21','2023-02-07 06:06:21'),
(1686,127,600,'','2023-02-07 06:06:21','2023-02-07 06:06:21'),
(1687,214,600,'qePV0JbD7a5BcJr5','2023-02-07 06:06:21','2023-02-07 06:06:21'),
(1690,125,603,'298','2023-02-07 11:03:47','2023-02-07 11:03:47'),
(1691,127,603,'','2023-02-07 11:03:47','2023-02-07 11:03:47'),
(1692,214,603,'Ilf1McgaiM4dWJWj','2023-02-07 11:03:47','2023-02-09 16:59:35'),
(1693,3,258,'09216560669','2023-02-08 07:07:44','2023-02-08 07:07:44'),
(1694,126,604,'ubuntu-22.04-x86_64','2023-02-08 07:21:33','2023-02-08 07:21:33'),
(1695,125,604,'299','2023-02-08 07:26:55','2023-02-08 07:26:55'),
(1696,127,604,'','2023-02-08 07:26:55','2023-02-08 07:26:55'),
(1697,214,604,'938Q2pdBN4UMOwle','2023-02-08 07:26:55','2023-02-09 17:42:02'),
(1698,145,605,'','2023-02-08 10:49:27','2023-02-08 10:49:27'),
(1699,152,605,'','2023-02-08 10:49:27','2023-02-08 10:49:27'),
(1700,126,606,'ubuntu-20.04-x86_64','2023-02-08 14:57:07','2023-02-08 14:57:07'),
(1701,125,606,'300','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1702,214,606,'5MAhSpdRZ0duLBTM','0000-00-00 00:00:00','2023-02-09 17:41:37'),
(1703,3,259,'09204041250','2023-02-08 18:04:59','2023-02-08 18:04:59'),
(1704,3,260,'09391605665','2023-02-09 07:20:16','2023-02-09 07:20:16'),
(1705,126,607,'ubuntu-22.04-x86_64','2023-02-09 07:20:50','2023-02-09 07:20:50'),
(1706,125,607,'301','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1707,214,607,'LM4b6guQnB1zefk5','0000-00-00 00:00:00','2023-02-09 17:41:31'),
(1708,126,608,'ubuntu-20.04-x86_64','2023-02-09 14:15:15','2023-02-09 14:15:15'),
(1709,145,609,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1710,152,609,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1711,145,610,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1712,152,610,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1713,145,611,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1714,152,611,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1715,145,612,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1716,152,612,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1717,145,613,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1718,152,613,'','2023-02-09 15:25:29','2023-02-09 15:25:29'),
(1719,145,614,'','2023-02-09 15:25:30','2023-02-09 15:25:30'),
(1720,152,614,'','2023-02-09 15:25:30','2023-02-09 15:25:30'),
(1721,127,589,'','2023-02-09 16:59:00','2023-02-09 16:59:00'),
(1722,127,571,'','2023-02-09 16:59:38','2023-02-09 16:59:38'),
(1723,125,608,'302','2023-02-09 17:36:10','2023-02-09 17:36:10'),
(1724,127,608,'','2023-02-09 17:36:10','2023-02-09 17:36:10'),
(1725,214,608,'eTGxOUVbQPCkWvj1','2023-02-09 17:36:10','2023-02-09 17:36:10'),
(1726,127,607,'','2023-02-09 17:41:31','2023-02-09 17:41:31'),
(1727,127,606,'','2023-02-09 17:41:37','2023-02-09 17:41:37'),
(1728,127,593,'','2023-02-09 17:50:13','2023-02-09 17:50:13'),
(1729,127,591,'','2023-02-09 17:50:44','2023-02-09 17:50:44'),
(1730,127,590,'','2023-02-09 17:50:57','2023-02-09 17:50:57'),
(1731,127,585,'','2023-02-09 17:53:17','2023-02-09 17:53:17'),
(1732,127,583,'','2023-02-09 17:54:00','2023-02-09 17:54:00'),
(1733,127,582,'','2023-02-09 17:54:10','2023-02-09 17:54:10'),
(1734,127,577,'','2023-02-09 17:55:02','2023-02-09 17:55:02'),
(1735,127,576,'','2023-02-09 17:55:09','2023-02-09 17:55:09'),
(1736,127,570,'','2023-02-09 17:55:54','2023-02-09 17:55:54'),
(1737,127,569,'','2023-02-09 17:56:06','2023-02-09 17:56:06'),
(1738,127,568,'','2023-02-09 17:56:20','2023-02-09 17:56:20'),
(1740,127,561,'','2023-02-09 17:57:36','2023-02-09 17:57:36'),
(1741,145,615,'','2023-02-10 20:30:23','2023-02-10 20:30:23'),
(1742,152,615,'','2023-02-10 20:30:23','2023-02-10 20:30:23'),
(1745,3,261,'09335312764','2023-02-11 19:49:29','2023-02-11 19:49:29'),
(1746,126,616,'ubuntu-20.04-x86_64','2023-02-11 20:11:21','2023-02-11 20:11:21'),
(1747,125,616,'','2023-02-11 20:17:18','2023-02-11 20:17:18'),
(1748,127,616,'','2023-02-11 20:17:18','2023-02-11 20:17:18'),
(1749,214,616,'','2023-02-11 20:17:18','2023-02-11 20:17:18'),
(1750,3,262,'09104669398','2023-02-11 22:05:29','2023-02-11 22:05:29'),
(1751,126,617,'ubuntu-20.04-x86_64','2023-02-11 22:07:23','2023-02-11 22:07:23'),
(1752,125,617,'308','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1753,214,617,'odAa2UYWZQS48OEH','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1756,70,559,'','2023-02-11 22:50:04','2023-02-11 22:50:04'),
(1757,71,559,'','2023-02-11 22:50:04','2023-02-11 22:50:04'),
(1758,155,559,'آلمان','2023-02-11 22:50:04','2023-02-11 22:50:04'),
(1759,3,263,'09124057563','2023-02-12 06:28:31','2023-02-12 06:28:31'),
(1760,3,264,'09360367001','2023-02-13 10:10:06','2023-02-13 10:10:06'),
(1761,126,618,'ubuntu-22.04-x86_64','2023-02-13 10:10:09','2023-02-13 10:10:09'),
(1762,3,265,'09387885959','2023-02-13 12:09:37','2023-02-13 12:09:37'),
(1763,126,619,'ubuntu-22.04-x86_64','2023-02-13 15:32:15','2023-02-13 15:32:15'),
(1764,125,619,'309','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1765,214,619,'ivKZbOTJxQy64hIm','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1766,125,618,'310','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1767,214,618,'A85oZ6zYByFFi6GJ','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1770,3,266,'09128585821','2023-02-16 11:05:15','2023-02-16 11:05:15'),
(1771,126,622,'ubuntu-22.04-x86_64','2023-02-16 11:05:32','2023-02-16 11:05:32'),
(1772,125,622,'311','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1773,214,622,'anLLFGVQ0TCslUaZ','0000-00-00 00:00:00','2023-02-19 07:58:05'),
(1774,198,623,'','2023-02-18 09:56:23','2023-02-18 09:56:23'),
(1775,199,623,'','2023-02-18 09:56:23','2023-02-18 09:56:23'),
(1776,127,519,'','2023-02-18 13:37:52','2023-02-18 13:37:52'),
(1778,127,523,'','2023-02-19 07:53:01','2023-02-19 07:53:01'),
(1779,127,520,'','2023-02-19 07:53:12','2023-02-19 07:53:12'),
(1780,127,622,'','2023-02-19 07:58:05','2023-02-19 07:58:05'),
(1781,145,624,'','2023-02-19 11:40:09','2023-02-19 11:40:09'),
(1782,152,624,'','2023-02-19 11:40:09','2023-02-19 11:40:09'),
(1783,126,625,'ubuntu-22.04-x86_64','2023-02-19 18:50:25','2023-02-19 18:50:25'),
(1784,145,626,'','2023-02-19 20:33:49','2023-02-19 20:33:49'),
(1785,152,626,'','2023-02-19 20:33:49','2023-02-19 20:33:49'),
(1786,125,625,'312','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1787,214,625,'dfBcXJPZOM4Ek9hM','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1788,126,627,'ubuntu-22.04-x86_64','2023-02-19 22:31:58','2023-02-19 22:31:58'),
(1789,125,627,'313','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1790,214,627,'xXisA8Un46pja3CF','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1791,3,268,'09177207471','2023-02-20 20:08:44','2023-02-20 20:08:44'),
(1792,126,628,'windows2016','2023-02-20 20:08:56','2023-02-20 20:08:56'),
(1793,3,269,'09138028654','2023-02-20 21:22:04','2023-02-20 21:22:04'),
(1794,125,628,'314','2023-02-21 11:10:06','2023-02-21 11:27:57'),
(1795,127,628,'','2023-02-21 11:10:06','2023-02-21 11:10:06'),
(1796,214,628,'','2023-02-21 11:10:06','2023-02-21 12:13:21'),
(1797,3,270,'09036225115','2023-02-22 13:20:47','2023-02-22 13:20:47'),
(1798,126,629,'ubuntu-20.04-x86_64','2023-02-22 13:21:00','2023-02-22 13:21:00'),
(1799,125,629,'315','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1800,214,629,'lQ7DNFaTnap50wDe','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1801,126,630,'ubuntu-22.04-x86_64','2023-02-22 14:06:54','2023-02-22 14:06:54'),
(1802,125,630,'316','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1803,214,630,'mZZFUxagaFXFFno4','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(1804,3,271,'09390888293','2023-02-22 21:01:04','2023-02-22 21:01:04');
/*!40000 ALTER TABLE `tblcustomfieldsvalues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldeviceauth`
--

DROP TABLE IF EXISTS `tbldeviceauth`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldeviceauth` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `identifier` varchar(255) NOT NULL DEFAULT '',
  `secret` varchar(255) NOT NULL DEFAULT '',
  `compat_secret` varchar(255) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT 0,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `role_ids` text NOT NULL,
  `description` varchar(255) NOT NULL DEFAULT '',
  `last_access` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `tbldeviceauth_identifier_unique` (`identifier`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldeviceauth`
--

LOCK TABLES `tbldeviceauth` WRITE;
/*!40000 ALTER TABLE `tbldeviceauth` DISABLE KEYS */;
INSERT INTO `tbldeviceauth` (`id`, `identifier`, `secret`, `compat_secret`, `user_id`, `is_admin`, `role_ids`, `description`, `last_access`, `created_at`, `updated_at`, `deleted_at`) VALUES (1,'xAswq5aWTqRK3X1vzzOqwhklpiUIcn69','$2y$10$cO09Db4nfvSskebHH720a.eW1YJfrKbD2WD55dNoMNFJT/wG/162C','$2y$10$TqhN41G1nzM4mDo/r9okUuyzW0CqcmEmivSzc/MWr0PlenoTO9ngS',2,1,'[1]','08AarunAmZ2Ari36BQYFGpsllJsck8dB','0000-00-00 00:00:00','2018-07-24 17:31:16','2018-07-24 17:31:35',NULL),
(2,'9wVruZ7tot81nMXZ16j5F6LYvuCcaa2w','$2y$10$LJwyGPV9C9YyS4z5oRrnyenwKaA82adAVC45xtHgSnYBiNHWFSxeq','$2y$10$aDHuMRhsG7zG5VJDN.OJCOc90qgp8mQ00MtunT7IkkYGfwMixWkk6',2,1,'[1]','','2019-02-04 05:20:03','2019-01-27 18:22:49','2019-02-04 05:20:03',NULL),
(3,'PxEibWpRuFjqACSJeFmCpOIhGgJLG1UU','$2y$10$hpnAIQp1SvNnkbdiuAIX6.TtYIGnzT3Y4qy/5fAP9SbvXHtmPLwZS','$2y$10$0P2s5Hh.eusZL./3mtyjN.gcqj1Lg385.ipB09cHrX93y6MSXPXpm',1,1,'[1]','login','2021-05-03 13:49:53','2019-06-15 05:51:59','2021-05-03 13:49:53',NULL),
(4,'kswO4PCCt6VhTMXQ9XhGwhRYO9JR4x7g','$2y$10$7w3YQRfQuld.FyPAVt.65uQKVhzlZNx2beuptustx75G93.q27SpS','$2y$10$pTXuz6YjdEyEi1CgNDYCNeBaj6faoPxNBe5ogIKvnbNkEQ7xzL3uq',1,1,'[1]','','0000-00-00 00:00:00','2019-10-06 06:59:44','2019-10-06 06:59:44',NULL),
(5,'tF6Kbac7jJxjw9ckjvJQobOXrrxZiBjF','$2y$10$UKhGGxolj70lbYrSgPHOVO/46WP3hO.kekIpW1Ypkd3gU85Pty7Uu','$2y$10$n/tLkMPPCuZAjjZRGV81i.SSC/m.rsrzh34qCfxdWRz9UIc8OcYJC',1,1,'[1]','','0000-00-00 00:00:00','2020-06-07 15:37:25','2020-06-07 15:37:25',NULL),
(6,'S6gMBQU38TZZgB641SKLxlGOgZFwclEM','$2y$10$F3KcP6HoAE7hB2HzQ3xkJegPon0nOAspMmJwWeGjYCA1RefTxyd1u','$2y$10$ammEs87L3yzCaBq/NTcZqup9hAUehNgKYqAagoURN6Xkcv275t/Ma',2,1,'[1]','','0000-00-00 00:00:00','2020-07-14 09:39:11','2020-07-14 09:39:11',NULL);
/*!40000 ALTER TABLE `tbldeviceauth` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldomain_lookup_configuration`
--

DROP TABLE IF EXISTS `tbldomain_lookup_configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldomain_lookup_configuration` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `registrar` varchar(32) NOT NULL DEFAULT '',
  `setting` varchar(128) NOT NULL DEFAULT '',
  `value` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `registrar_setting_index` (`registrar`,`setting`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldomain_lookup_configuration`
--

LOCK TABLES `tbldomain_lookup_configuration` WRITE;
/*!40000 ALTER TABLE `tbldomain_lookup_configuration` DISABLE KEYS */;
INSERT INTO `tbldomain_lookup_configuration` (`id`, `registrar`, `setting`, `value`, `created_at`, `updated_at`) VALUES (9,'enom','suggestMaxResultCount','100','2018-05-30 21:29:35','2018-05-30 21:29:35'),
(10,'enom','suggestOnlyGeneralAvailability','on','2018-05-30 21:29:35','2018-05-30 21:29:35'),
(11,'enom','suggestAdultDomains','on','2018-05-30 21:29:35','2018-05-30 21:29:35'),
(12,'WhmcsWhois','useWhmcsWhoisForSuggestions','on','2018-05-30 21:30:23','2018-05-30 21:30:23'),
(13,'WhmcsWhois','suggestTlds','.com,.ir,.org,.net,.co','2018-05-30 21:30:23','2018-05-30 21:30:23'),
(14,'WhmcsWhois','geotargetedResults','on','2019-05-18 14:32:07','2019-05-18 14:32:07');
/*!40000 ALTER TABLE `tbldomain_lookup_configuration` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldomainpricing`
--

DROP TABLE IF EXISTS `tbldomainpricing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldomainpricing` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `extension` text NOT NULL,
  `dnsmanagement` tinyint(1) NOT NULL,
  `emailforwarding` tinyint(1) NOT NULL,
  `idprotection` tinyint(1) NOT NULL,
  `eppcode` tinyint(1) NOT NULL,
  `autoreg` text NOT NULL,
  `order` int(1) NOT NULL DEFAULT 0,
  `group` varchar(5) NOT NULL DEFAULT 'none',
  `grace_period` int(1) NOT NULL DEFAULT -1,
  `grace_period_fee` decimal(16,2) NOT NULL DEFAULT 0.00,
  `redemption_grace_period` int(1) NOT NULL DEFAULT -1,
  `redemption_grace_period_fee` decimal(16,2) NOT NULL DEFAULT -1.00,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `extension_registrationperiod` (`extension`(32)),
  KEY `order` (`order`)
) ENGINE=MyISAM AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldomainpricing`
--

LOCK TABLES `tbldomainpricing` WRITE;
/*!40000 ALTER TABLE `tbldomainpricing` DISABLE KEYS */;
INSERT INTO `tbldomainpricing` (`id`, `extension`, `dnsmanagement`, `emailforwarding`, `idprotection`, `eppcode`, `autoreg`, `order`, `group`, `grace_period`, `grace_period_fee`, `redemption_grace_period`, `redemption_grace_period_fee`, `created_at`, `updated_at`) VALUES (1,'.ir',1,0,0,0,'subirnic',1,'sale',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:17'),
(4,'.com',1,0,0,0,'domainnameapi',0,'hot',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:17'),
(22,'.co',1,0,0,0,'domainnameapi',4,'hot',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:17'),
(53,'.net',1,0,0,0,'domainnameapi',3,'hot',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:17'),
(56,'.org',1,0,0,0,'domainnameapi',2,'sale',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:17'),
(69,'.tools',1,0,0,0,'domainnameapi',8,'sale',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:26'),
(70,'.academy',1,0,0,0,'domainnameapi',9,'',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:17'),
(71,'.me',1,0,0,0,'domainnameapi',7,'new',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:17'),
(72,'.site',1,0,0,0,'domainnameapi',6,'new',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:17'),
(73,'.xyz',1,0,0,0,'domainnameapi',5,'new',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:17'),
(74,'.fun',1,0,0,0,'domainnameapi',10,'sale',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','2022-11-19 10:16:26'),
(75,'.pro',1,0,0,0,'domainnameapi',11,'new',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(76,'.shop',1,0,0,0,'domainnameapi',12,'hot',-1,0.00,-1,-1.00,'0000-00-00 00:00:00','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `tbldomainpricing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldomainpricing_premium`
--

DROP TABLE IF EXISTS `tbldomainpricing_premium`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldomainpricing_premium` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `to_amount` decimal(16,2) NOT NULL DEFAULT 0.00,
  `markup` decimal(8,5) NOT NULL DEFAULT 0.00000,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `tbldomain_pricing_premium_to_amount_unique` (`to_amount`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldomainpricing_premium`
--

LOCK TABLES `tbldomainpricing_premium` WRITE;
/*!40000 ALTER TABLE `tbldomainpricing_premium` DISABLE KEYS */;
INSERT INTO `tbldomainpricing_premium` (`id`, `to_amount`, `markup`, `created_at`, `updated_at`) VALUES (1,200.00,20.00000,'2016-12-18 16:11:39','2016-12-18 16:11:39'),
(2,500.00,25.00000,'2016-12-18 16:11:39','2016-12-18 16:11:39'),
(3,1000.00,30.00000,'2016-12-18 16:11:39','2016-12-18 16:11:39'),
(4,-1.00,20.00000,'2016-12-18 16:11:39','2016-12-18 16:11:39');
/*!40000 ALTER TABLE `tbldomainpricing_premium` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldomainreminders`
--

DROP TABLE IF EXISTS `tbldomainreminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldomainreminders` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `domain_id` int(10) NOT NULL,
  `date` date NOT NULL,
  `recipients` text NOT NULL,
  `type` tinyint(4) NOT NULL,
  `days_before_expiry` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldomainreminders`
--

LOCK TABLES `tbldomainreminders` WRITE;
/*!40000 ALTER TABLE `tbldomainreminders` DISABLE KEYS */;
INSERT INTO `tbldomainreminders` (`id`, `domain_id`, `date`, `recipients`, `type`, `days_before_expiry`) VALUES (1,1,'2017-09-04','khajavi_mohamad@yahoo.com',1,30),
(2,2,'2017-09-04','khajavi_mohamad@yahoo.com',1,30),
(3,3,'2017-09-06','yazdanzarkhah@gmail.com',1,30),
(4,1,'2017-09-27','khajavi_mohamad@yahoo.com',2,7),
(5,2,'2017-09-27','khajavi_mohamad@yahoo.com',2,7),
(6,3,'2017-09-29','yazdanzarkhah@gmail.com',2,7),
(7,3,'2017-10-09','yazdanzarkhah@gmail.com',3,-3),
(8,4,'2017-12-29','bmodaberi@gmail.com',1,30),
(9,5,'2018-01-02','hammedsadeghie@gmail.com',1,30),
(10,4,'2018-01-21','bmodaberi@gmail.com',2,7),
(11,5,'2018-01-25','hammedsadeghie@gmail.com',2,7),
(12,7,'2018-01-29','hammedsadeghie@gmail.com',1,30),
(13,5,'2018-02-04','hammedsadeghie@gmail.com',3,-3),
(14,7,'2018-02-21','hammedsadeghie@gmail.com',2,7),
(15,7,'2018-03-03','hammedsadeghie@gmail.com',3,-3),
(16,9,'2018-03-13','hammedsadeghie@gmail.com',1,30),
(17,9,'2018-04-05','hammedsadeghie@gmail.com',2,7),
(18,13,'2018-08-03','hammedsadeghie@gmail.com',1,30),
(19,14,'2018-08-03','hammedsadeghie@gmail.com',1,30),
(20,13,'2018-08-26','hammedsadeghie@gmail.com',2,7),
(21,14,'2018-08-26','hammedsadeghie@gmail.com',2,7),
(22,13,'2018-09-05','hammedsadeghie@gmail.com',3,-3),
(23,14,'2018-09-05','hammedsadeghie@gmail.com',3,-3),
(24,4,'2019-01-31','bmodaberi@gmail.com',3,-3),
(25,12,'2019-08-02','yazdanzarkhah@gmail.com',1,30),
(26,12,'2019-08-25','yazdanzarkhah@gmail.com',2,7),
(27,12,'2019-09-04','yazdanzarkhah@gmail.com',3,-3),
(28,17,'2020-03-03','yazdanzarkhah@gmail.com',1,30),
(29,17,'2020-03-26','yazdanzarkhah@gmail.com',2,7),
(30,19,'2020-12-06','khalili.mrabzar@gmail.com',1,30),
(31,20,'2021-03-23','Akhedri96@yahoo.com',1,30),
(32,20,'2021-04-15','Akhedri96@yahoo.com',2,7),
(33,20,'2021-04-25','Akhedri96@yahoo.com',3,-3),
(34,21,'2021-06-08','betaa6644@gmail.com',1,30),
(35,21,'2021-07-01','betaa6644@gmail.com',2,7),
(36,23,'2021-09-26','Akhedri96@yahoo.com',1,30),
(37,23,'2021-10-19','Akhedri96@yahoo.com',2,7),
(38,24,'2021-11-28','betaa6644@gmail.com',1,30),
(39,19,'2021-12-06','khalili.mrabzar@gmail.com',1,30),
(40,24,'2021-12-21','betaa6644@gmail.com',2,7),
(41,19,'2021-12-29','khalili.mrabzar@gmail.com',2,7),
(42,19,'2022-01-08','khalili.mrabzar@gmail.com',3,-3),
(43,10,'2022-03-17','hammedsadeghie@gmail.com',1,30),
(44,11,'2022-03-25','hammedsadeghie@gmail.com',1,30),
(45,11,'2022-04-17','hammedsadeghie@gmail.com',2,7),
(46,25,'2022-05-30','khalili.mrabzar@gmail.com',1,30),
(47,25,'2022-06-22','khalili.mrabzar@gmail.com',2,7);
/*!40000 ALTER TABLE `tbldomainreminders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldomains`
--

DROP TABLE IF EXISTS `tbldomains`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldomains` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `userid` int(10) NOT NULL,
  `orderid` int(1) NOT NULL,
  `type` enum('Register','Transfer') NOT NULL,
  `registrationdate` date NOT NULL,
  `domain` text NOT NULL,
  `firstpaymentamount` decimal(16,2) NOT NULL DEFAULT 0.00,
  `recurringamount` decimal(16,2) NOT NULL,
  `registrar` text NOT NULL,
  `registrationperiod` int(1) NOT NULL DEFAULT 1,
  `expirydate` date DEFAULT NULL,
  `subscriptionid` text NOT NULL,
  `promoid` int(10) NOT NULL,
  `status` enum('Pending','Pending Registration','Pending Transfer','Active','Grace','Redemption','Expired','Cancelled','Fraud','Transferred Away') NOT NULL DEFAULT 'Pending',
  `nextduedate` date NOT NULL DEFAULT '0000-00-00',
  `nextinvoicedate` date NOT NULL,
  `additionalnotes` text NOT NULL,
  `paymentmethod` text NOT NULL,
  `dnsmanagement` tinyint(1) NOT NULL,
  `emailforwarding` tinyint(1) NOT NULL,
  `idprotection` tinyint(1) NOT NULL,
  `is_premium` tinyint(1) DEFAULT NULL,
  `donotrenew` tinyint(1) NOT NULL,
  `reminders` text NOT NULL,
  `synced` tinyint(1) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `orderid` (`orderid`),
  KEY `domain` (`domain`(64)),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldomains`
--

LOCK TABLES `tbldomains` WRITE;
/*!40000 ALTER TABLE `tbldomains` DISABLE KEYS */;
INSERT INTO `tbldomains` (`id`, `userid`, `orderid`, `type`, `registrationdate`, `domain`, `firstpaymentamount`, `recurringamount`, `registrar`, `registrationperiod`, `expirydate`, `subscriptionid`, `promoid`, `status`, `nextduedate`, `nextinvoicedate`, `additionalnotes`, `paymentmethod`, `dnsmanagement`, `emailforwarding`, `idprotection`, `is_premium`, `donotrenew`, `reminders`, `synced`, `created_at`, `updated_at`) VALUES (1,7,13,'Transfer','2016-10-04','tehrandubshow.com',400000.00,2300000.00,'hostcontrol',1,'2017-11-18','',0,'Expired','2017-10-04','2016-10-04','','zarinpal',0,0,0,NULL,0,'|30||7|',0,'0000-00-00 00:00:00','2017-11-19 03:30:02'),
(2,7,13,'Transfer','2016-10-04','Tehrandub.Com',400000.00,2300000.00,'hostcontrol',1,'2017-11-17','',0,'Expired','2017-10-04','2016-10-04','','zarinpal',0,0,0,NULL,0,'|30||7|',0,'0000-00-00 00:00:00','2017-11-18 03:30:03'),
(3,2,15,'Register','2016-10-07','roselab.ir',55000.00,55000.00,'subirnic',1,'2017-10-07','',0,'Expired','2017-10-06','2016-10-06','','zarinpal',0,0,0,NULL,0,'|30||7||-3|',0,'0000-00-00 00:00:00','2017-10-08 03:30:05'),
(4,10,25,'Transfer','2017-01-28','yourielts.com',450000.00,2300000.00,'SPDomainReseller',1,'2019-03-03','',0,'Expired','2019-01-28','2019-01-28','March 3, 2018','zarinpal',0,0,0,0,0,'|30||7||-3|',0,'0000-00-00 00:00:00','2018-03-04 05:00:02'),
(5,1,28,'Register','2017-02-01','azarsatrap.com',450000.00,2300000.00,'hostcontrol',1,'2018-02-01','',0,'Expired','2018-02-01','2019-02-01','','zarinpal',0,0,0,0,0,'|30||7||-3|',0,'0000-00-00 00:00:00','2018-02-02 03:30:10'),
(7,1,33,'Register','2017-02-28','darhadeno.com',450000.00,2300000.00,'hostcontrol',1,'2018-02-28','',0,'Expired','2018-02-28','2019-02-28','','zarinpal',0,0,0,0,0,'|30||7||-3|',0,'0000-00-00 00:00:00','2018-03-01 05:00:03'),
(8,1,39,'Transfer','2017-04-12','abc-cl.com',450000.00,2300000.00,'hostcontrol',1,'0000-00-00','',0,'Cancelled','2018-04-12','2018-04-12','','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(9,1,40,'Transfer','2017-04-12','abc-dl.com',450000.00,2300000.00,'hostcontrol',1,'2018-04-14','',0,'Expired','2018-04-12','2019-04-12','','zarinpal',0,0,0,0,0,'|30||7|',0,'0000-00-00 00:00:00','2018-04-16 04:00:05'),
(10,1,41,'Transfer','2017-04-12','abc-dl.ir',350000.00,350000.00,'subirnic',5,'2022-04-16','',0,'Expired','2022-04-16','2022-04-12','','zarinpal',0,0,0,0,0,'|30|',1,'0000-00-00 00:00:00','2022-06-22 13:12:28'),
(11,1,45,'Register','2017-04-24','plusmart.ir',350000.00,350000.00,'subirnic',5,'2022-04-24','',0,'Expired','2022-04-24','2027-04-24','','zarinpal',0,0,0,0,0,'|30|7|',1,'0000-00-00 00:00:00','2022-06-22 13:12:28'),
(12,2,46,'Transfer','2017-04-26','solidplastic.ir',70000.00,70000.00,'subirnic',1,'2019-09-01','',0,'Expired','2019-09-01','2020-09-01','','zarinpal',0,0,0,0,0,'|30||7||-3|',0,'0000-00-00 00:00:00','2019-09-01 20:30:42'),
(13,1,57,'Register','2017-09-02','poshtibanisite.ir',70000.00,70000.00,'subirnic',1,'2018-09-02','',0,'Expired','2018-09-02','2019-09-02','','zarinpal',0,0,0,0,0,'|30||7||-3|',0,'0000-00-00 00:00:00','2018-09-03 16:00:03'),
(14,1,58,'Register','2017-09-02','poshtibaniserver.ir',70000.00,70000.00,'subirnic',1,'2018-09-02','',0,'Expired','2018-09-02','2019-09-02','','zarinpal',0,0,0,0,0,'|30||7||-3|',0,'0000-00-00 00:00:00','2018-09-03 16:00:03'),
(15,14,68,'Register','2018-04-06','msseo.ir',350000.00,350000.00,'',5,'0000-00-00','',0,'Cancelled','2018-04-06','2023-04-06','','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(16,15,69,'Register','2018-04-06','msseo.ir',145000.00,350000.00,'SPDomainReseller',5,'2023-04-06','',0,'Expired','2023-04-06','2023-04-06','','zarinpal',0,0,0,0,0,'',1,'0000-00-00 00:00:00','2023-04-07 05:31:40'),
(17,2,105,'Transfer','2019-04-02','solidplastic.ir',70000.00,70000.00,'SPDomainReseller',1,'2020-09-01','',0,'Expired','2020-04-02','2021-04-02','','zarinpal',0,0,0,0,0,'|30||7|',1,'0000-00-00 00:00:00','2020-09-01 20:30:50'),
(18,14,106,'Transfer','2019-04-27','polgeorgia.com',1700000.00,2300000.00,'',1,'0000-00-00','',0,'Cancelled','2019-04-27','2020-04-27','','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(19,25,130,'Transfer','2019-12-02','abzarist.tools',5390000.00,14990000.00,'hostcontrol',1,'2022-01-05','',0,'Expired','2022-01-05','2023-01-05','sabahost','zarinpal',0,0,0,0,0,'|30||7||-3|',0,'0000-00-00 00:00:00','2022-02-14 21:33:49'),
(20,27,135,'Register','2020-04-22','btbinvestment.com',1400000.00,2300000.00,'hostcontrol',1,'2021-04-22','',0,'Expired','2021-04-22','2022-04-22','sazgaridc.com','zarinpal',0,0,0,0,0,'|30||7||-3|',0,'0000-00-00 00:00:00','2021-05-22 20:33:20'),
(21,29,144,'Register','2020-07-08','SAYAHTEB.COM',2500000.00,2300000.00,'',1,'0000-00-00','',0,'Expired','2021-07-08','2021-07-08','saba','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(22,29,144,'Register','2020-07-08','Farfallina.COM',2500000.00,2300000.00,'SPDomainReseller',1,'0000-00-00','',0,'Cancelled','2020-07-11','2020-07-11','','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(23,27,151,'Register','2020-10-26','viratahlil.com',2500000.00,2300000.00,'SPDomainReseller',1,'0000-00-00','',0,'Active','2021-10-26','2027-10-26','','zarinpal',0,0,0,0,0,'|30||7|',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(24,29,153,'Register','2020-12-28','weplancer.com',2900000.00,3200000.00,'SPDomainReseller',1,'0000-00-00','',0,'Grace','2021-12-28','2022-12-28','','zarinpal',0,0,0,0,0,'|30||7|',0,'0000-00-00 00:00:00','2022-01-13 06:31:53'),
(26,32,162,'Transfer','2021-08-28','atiara.ir',70000.00,70000.00,'SPDomainReseller',1,'2022-08-28','',0,'Expired','2023-08-28','2023-08-28','','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','2022-09-05 04:47:12'),
(25,25,158,'Register','2021-06-29','abzarist.com',2900000.00,3200000.00,'hostcontrol',1,'0000-00-00','',0,'Active','2023-06-29','2023-06-29','','zarinpal',0,0,0,0,0,'|30|7|',0,'0000-00-00 00:00:00','2022-06-22 12:45:31'),
(27,26,173,'Register','2022-01-28','redbazar.net',8000000.00,8000000.00,'',2,'2024-01-28','',0,'Expired','2024-01-28','2025-01-28','NetAfraz','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','2024-02-28 05:31:45'),
(28,49,199,'Register','2022-09-07','konaherbs.com',3200000.00,3200000.00,'domainnameapi',1,'2023-09-07','',0,'Expired','2023-09-07','2023-09-07','','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','2023-10-08 05:30:58'),
(29,47,257,'Register','2022-11-10','rdktrading.com',3200000.00,3200000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2023-11-10','2025-11-10','','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(30,87,288,'Register','2022-11-18','shnoserver.site',1200000.00,0.00,'domainnameapi',1,'0000-00-00','',0,'Active','2023-11-18','2025-11-18','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(31,98,303,'Register','2022-11-22','choghabafi.ir',140000.00,140000.00,'',1,'0000-00-00','',0,'Pending','2022-11-22','2024-11-22','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(32,99,304,'Register','2022-11-22','choghabafi.ir',140000.00,140000.00,'',1,'0000-00-00','',0,'Pending','2022-11-22','2024-11-22','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(33,100,305,'Register','2022-11-22','choghabafi.ir',140000.00,140000.00,'',1,'0000-00-00','',0,'Pending','2022-11-22','2024-11-22','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(34,98,306,'Register','2022-11-23','choghabafi.ir',140000.00,140000.00,'subirnic',1,'2023-11-23','',0,'Expired','2022-11-22','2023-11-22','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','2023-11-24 05:30:52'),
(35,106,321,'Register','2022-11-30','silverf.fun',900000.00,900000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2023-11-30','2025-11-30','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(36,62,345,'Register','2022-12-09','khadamatessential.xyz',1500000.00,1500000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2023-12-09','2025-12-09','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(37,62,357,'Register','2022-12-10','khadamatessential1.xyz',1500000.00,1500000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2023-12-10','2025-12-10','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(38,62,375,'Register','2022-12-12','khadamatessential2.xyz',1500000.00,1500000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2023-12-12','2025-12-12','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(39,127,449,'Register','2022-12-29','alfagtoa.fun',900000.00,900000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2023-12-29','2023-12-29','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(40,177,464,'Register','2023-01-04','ariagtoa.fun',900000.00,900000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2024-01-04','2024-01-04','','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(41,87,476,'Register','2023-01-06','shnovps.fun',900000.00,900000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2024-01-06','2026-01-06','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(42,211,517,'Register','2023-01-18','wstc-mg.com',4200000.00,4200000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2024-01-18','2026-01-18','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(43,224,539,'Register','2023-01-24','fantiures.com',4200000.00,4200000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2024-01-24','2025-01-24','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(44,112,546,'Register','2023-01-26','mtpcloud.org',4500000.00,4500000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2024-01-26','2026-01-26','','zarinpal',0,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(45,203,549,'Register','2023-01-27','banehvitrin.xyz',1500000.00,1500000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2024-01-27','2024-01-27','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(46,86,554,'Register','2023-01-29','gamepluseveryday.fun',900000.00,900000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2024-01-29','2025-01-29','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00'),
(47,87,557,'Register','2023-01-29','shno.fun',900000.00,900000.00,'domainnameapi',1,'0000-00-00','',0,'Active','2024-01-29','2026-01-29','','zarinpal',1,0,0,0,0,'',0,'0000-00-00 00:00:00','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `tbldomains` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldomains_extra`
--

DROP TABLE IF EXISTS `tbldomains_extra`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldomains_extra` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) NOT NULL DEFAULT 0,
  `name` varchar(32) NOT NULL DEFAULT '',
  `value` varchar(255) NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `tbldomains_extra_domain_id_type_unique` (`domain_id`,`name`),
  KEY `tbldomains_extra_type_index` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldomains_extra`
--

LOCK TABLES `tbldomains_extra` WRITE;
/*!40000 ALTER TABLE `tbldomains_extra` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbldomains_extra` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldomainsadditionalfields`
--

DROP TABLE IF EXISTS `tbldomainsadditionalfields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldomainsadditionalfields` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `domainid` int(10) NOT NULL,
  `name` text NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `domainid` (`domainid`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldomainsadditionalfields`
--

LOCK TABLES `tbldomainsadditionalfields` WRITE;
/*!40000 ALTER TABLE `tbldomainsadditionalfields` DISABLE KEYS */;
INSERT INTO `tbldomainsadditionalfields` (`id`, `domainid`, `name`, `value`, `created_at`, `updated_at`) VALUES (1,3,'irnichandle','hs3020-irnic','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(2,6,'irnichandle','','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(3,10,'irnichandle','hs3020-irnic','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(4,11,'irnichandle','hs3020-irnic','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(5,12,'irnichandle','hs2253-irnic','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(6,13,'irnichandle','hs3020-irnic','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(7,14,'irnichandle','hs3020-irnic','0000-00-00 00:00:00','0000-00-00 00:00:00'),
(8,15,'irnichandle','jamshidian.eng@gmail.com','2018-04-07 03:55:28','2018-04-07 03:55:28'),
(9,16,'irnichandle','sq192-irnic','2018-04-07 04:37:19','2018-04-07 04:37:19'),
(10,17,'irnichandle','','2019-04-04 07:12:17','2019-04-04 07:12:17'),
(11,26,'irnichandle','alvandi.atiara@gmail.com','2021-08-28 05:44:22','2021-08-28 05:44:22'),
(12,31,'irnichandle','mp.ari8a@gmail.com','2022-11-22 17:52:59','2022-11-22 17:52:59'),
(13,32,'irnichandle','mp.ari8a@gmail.com','2022-11-22 17:56:27','2022-11-22 17:56:27'),
(14,33,'irnichandle','mp.ari8a@gmail.com','2022-11-22 17:59:14','2022-11-22 17:59:14'),
(15,34,'irnichandle','aj7139-irnic','2022-11-22 17:59:55','2022-11-23 09:54:49');
/*!40000 ALTER TABLE `tbldomainsadditionalfields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldownloadcats`
--

DROP TABLE IF EXISTS `tbldownloadcats`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldownloadcats` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `parentid` int(10) NOT NULL DEFAULT 0,
  `name` text NOT NULL,
  `description` text NOT NULL,
  `hidden` tinyint(1) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `parentid` (`parentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldownloadcats`
--

LOCK TABLES `tbldownloadcats` WRITE;
/*!40000 ALTER TABLE `tbldownloadcats` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbldownloadcats` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldownloads`
--

DROP TABLE IF EXISTS `tbldownloads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldownloads` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `category` int(10) NOT NULL,
  `type` text NOT NULL,
  `title` text NOT NULL,
  `description` text NOT NULL,
  `downloads` int(10) NOT NULL DEFAULT 0,
  `location` text NOT NULL,
  `clientsonly` tinyint(1) NOT NULL,
  `hidden` tinyint(1) NOT NULL,
  `productdownload` tinyint(1) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `title` (`title`(32)),
  KEY `downloads` (`downloads`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldownloads`
--

LOCK TABLES `tbldownloads` WRITE;
/*!40000 ALTER TABLE `tbldownloads` DISABLE KEYS */;
/*!40000 ALTER TABLE `tbldownloads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tbldynamic_translations`
--

DROP TABLE IF EXISTS `tbldynamic_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `tbldynamic_translations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `related_type` enum('configurable_option.{id}.name','configurable_option_option.{id}.name','custom_field.{id}.description','custom_field.{id}.name','download.{id}.description','download.{id}.title','product.{id}.description','product.{id}.name','product.{id}.tagline','product.{id}.short_description','product_addon.{id}.description','product_addon.{id}.name','product_bundle.{id}.description','product_bundle.{id}.name','product_group.{id}.headline','product_group.{id}.name','product_group.{id}.tagline','product_group_feature.{id}.feature','ticket_department.{id}.description','ticket_department.{id}.name') DEFAULT NULL,
  `related_id` int(10) unsigned NOT NULL DEFAULT 0,
  `language` varchar(16) NOT NULL DEFAULT '',
  `translation` text NOT NULL,
  `input_type` enum('text','textarea') NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `tbldynamic_translations_id` (`related_id`),
  KEY `tbldynamic_translations_type` (`related_type`),
  KEY `tbldynamic_translations_id_type` (`related_id`,`related_type`)
) ENGINE=InnoDB AUTO_INCREMENT=1569 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tbldynamic_translations`
--

LOCK TABLES `tbldynamic_translations` WRITE;
/*!40000 ALTER TABLE `tbldynamic_translations` DISABLE KEYS */;
INSERT INTO `tbldynamic_translations` (`id`, `related_type`, `related_id`, `language`, `translation`, `input_type`, `created_at`, `updated_at`) VALUES (8,'custom_field.{id}.name',38,'arabic','الرجاء إدخال المجال الخاص بك:','text','2016-11-22 16:20:30','2016-11-22 16:20:36'),
(9,'custom_field.{id}.name',38,'english','Please Enter your Domain:','text','2016-11-22 16:20:30','2016-11-22 16:20:36'),
(10,'custom_field.{id}.name',39,'arabic','الرجاء إدخال المجال الخاص بك:','text','2016-11-22 16:23:31','2016-11-22 16:23:44'),
(11,'custom_field.{id}.name',39,'english','Please enter your domain:','text','2016-11-22 16:23:31','2016-11-22 16:23:44'),
(33,'product.{id}.description',18,'farsi','• 100 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2016-12-27 13:50:06','2022-08-19 14:17:57'),
(34,'product.{id}.name',18,'farsi','هاست لینوکس حرفه ای ایران - 100 مگ','text','2016-12-27 13:50:06','2022-08-19 14:09:03'),
(35,'product.{id}.description',11,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2016-12-27 13:51:01','2022-08-19 14:18:29'),
(36,'product.{id}.name',11,'farsi','هاست لینوکس حرفه ای ایران - 1 گیگ','text','2016-12-27 13:51:01','2022-08-19 14:10:30'),
(37,'product.{id}.description',2,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2016-12-27 13:51:45','2022-08-19 14:18:44'),
(38,'product.{id}.name',2,'farsi','هاست لینوکس حرفه ای ایران - 5 گیگ','text','2016-12-27 13:51:45','2022-08-19 14:10:46'),
(39,'product_group.{id}.headline',12,'farsi','سرور مجازی ایران - Iran VPS ','text','2016-12-29 15:50:16','2016-12-29 15:50:16'),
(40,'product_group.{id}.name',12,'farsi','سرور مجازی ایران','text','2016-12-29 15:50:16','2023-01-18 11:20:19'),
(41,'product_group.{id}.tagline',12,'farsi',' ترافیک نامحدود با شرط رعابت 1 به 10 ','text','2016-12-29 15:50:16','2022-12-14 19:01:24'),
(44,'custom_field.{id}.name',41,'arabic','نظام التشغيل','text','2016-12-29 16:03:06','2016-12-29 16:03:06'),
(45,'custom_field.{id}.name',41,'english','Select Your OS','text','2016-12-29 16:03:06','2016-12-29 16:03:06'),
(55,'product_group.{id}.headline',5,'farsi','سرورمجازی خارج - لینوکس و ویندوز','text','2016-12-29 16:17:44','2019-08-12 06:27:58'),
(56,'product_group.{id}.name',5,'farsi','سرورمجازی خارج','text','2016-12-29 16:17:44','2022-08-15 17:11:59'),
(57,'product_group.{id}.tagline',5,'farsi','','text','2016-12-29 16:17:44','2016-12-29 16:17:44'),
(72,'custom_field.{id}.name',42,'arabic','نظام التشغيل','text','2016-12-29 17:05:07','2016-12-29 17:05:07'),
(73,'custom_field.{id}.name',42,'english','Select Your OS:','text','2016-12-29 17:05:07','2016-12-29 17:05:07'),
(112,'product.{id}.description',61,'farsi','    قابل صدور برای دامنه های ir و بین المللی\r\n    صدور فوری پس از پرداخت\r\n    قابل صدور برای یک دامنه یا یک زیر دامنه مشخص(همراه با www)\r\n    نصب رایگان (بر روی هاستهای کلون کلود )','textarea','2017-03-13 06:07:55','2022-08-19 15:05:46'),
(113,'product.{id}.name',61,'farsi','گواهینامه استاندارد SSL DV','text','2017-03-13 06:07:55','2022-08-19 15:05:35'),
(116,'product.{id}.description',63,'farsi','    قابل صدور برای دامنه های ir و بین المللی\r\n    صدور فوری پس از پرداخت\r\n    قابل استفاده برای تمامی زیر دامنه های یک دامنه (و دامنه بدون www)\r\n    نصب رایگان ( بر روی سرورهای کلون کلود )','textarea','2017-03-13 07:19:42','2022-08-19 15:07:00'),
(117,'product.{id}.name',63,'farsi','گواهینامه استاندارد SSL DV Wildcard','text','2017-03-13 07:19:42','2022-08-19 15:07:00'),
(120,'product.{id}.description',65,'farsi','','textarea','2017-04-11 11:13:35','2017-04-11 11:13:35'),
(121,'product.{id}.name',65,'farsi','پکیج سئو - پلان پایه ','text','2017-04-11 11:13:35','2017-04-11 11:13:35'),
(122,'product.{id}.description',6,'farsi','پشتیبانی نرم افزاری سایت -  php - پلان طلایی','textarea','2017-04-11 11:20:44','2019-08-12 06:40:00'),
(123,'product.{id}.name',6,'farsi','پشتیبانی نرم افزاری سایت -  php - پلان طلایی','text','2017-04-11 11:20:44','2017-04-11 11:20:44'),
(124,'product.{id}.description',5,'farsi','پشتیبانی نرم افزاری سایت -  asp .net','textarea','2017-04-11 11:21:24','2017-04-11 11:21:24'),
(125,'product.{id}.name',5,'farsi','پشتیبانی نرم افزاری سایت -  asp .net - پلان طلایی','text','2017-04-11 11:21:24','2017-04-11 11:21:24'),
(126,'product.{id}.description',4,'farsi','پشتیبانی نرم افزاری سایت -  asp .net - پلان نقره ای','textarea','2017-04-11 11:31:09','2019-08-12 06:42:24'),
(127,'product.{id}.name',4,'farsi','پشتیبانی نرم افزاری سایت -  asp .net - پلان نقره ای','text','2017-04-11 11:31:09','2017-04-11 11:31:09'),
(306,'product.{id}.description',153,'farsi','    قابل صدور برای دامنه های ir و بین المللی\r\n    فعال سازی فوری پس از پرداخت، صدور پس از تایید مدارک سازمانی\r\n    تایید نام سازمان\r\n    قابل استفاده برای یک دامنه و یا یک زیر دامنه مشخص(همراه با www)\r\n    صدور تا 7 روز کاری اروپا\r\n    نصب رایگان ( بر روی سرورهای کلون کلود  )','textarea','2017-08-25 14:41:19','2022-08-19 15:10:54'),
(307,'product.{id}.name',153,'farsi','گواهینامه پیشرفته سازمانی EV SAN','text','2017-08-25 14:41:19','2022-08-19 15:10:54'),
(308,'product.{id}.description',154,'farsi','    قابل صدور برای دامنه های ir و بین المللی\r\n    صدور فوری پس از پرداخت\r\n    قابل صدور برای یک دامنه یا یک زیر دامنه مشخص(همراه با www)\r\n    نصب رایگان (بر روی هاستهای کلون کلود )','textarea','2017-08-25 15:05:08','2022-08-19 15:09:25'),
(309,'product.{id}.name',154,'farsi','گواهینامه سازمانی Certum Trusted OV','text','2017-08-25 15:05:08','2022-08-19 15:09:25'),
(310,'product.{id}.description',155,'farsi','    قابل صدور برای دامنه های ir و بین المللی\r\n    صدور فوری پس از پرداخت\r\n    قابل استفاده برای تمامی زیر دامنه های یک دامنه (و دامنه بدون www)\r\n    نصب رایگان ( بر روی سرورهای کلون کلود )','textarea','2017-08-25 15:10:30','2022-08-19 15:10:02'),
(311,'product.{id}.name',155,'farsi','گواهینامه سازمانی Certum Trusted OV Wildcard','text','2017-08-25 15:10:30','2022-08-19 15:10:02'),
(327,'product.{id}.description',9,'farsi','','textarea','2018-03-25 23:10:52','2018-03-25 23:10:52'),
(328,'product.{id}.name',9,'farsi','طراحی سایت اختصاصی با asp .net','text','2018-03-25 23:10:52','2018-03-25 23:10:52'),
(367,'product.{id}.description',49,'farsi','','textarea','2018-04-22 20:33:12','2018-04-22 20:33:12'),
(368,'product.{id}.name',49,'farsi','Plesk License unlimited Domain -  Web Host Edition','text','2018-04-22 20:33:12','2022-12-16 08:28:06'),
(422,'product.{id}.description',186,'farsi','• 3 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2018-05-30 21:06:56','2022-08-19 14:18:34'),
(423,'product.{id}.name',186,'farsi','هاست لینوکس حرفه ای ایران - 3 گیگ','text','2018-05-30 21:06:56','2022-08-19 14:10:35'),
(430,'product.{id}.description',33,'farsi','• 500 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2018-09-11 16:08:29','2022-08-19 14:18:03'),
(431,'product.{id}.name',33,'farsi','هاست لینوکس حرفه ای ایران - 500 مگ','text','2018-09-11 16:08:29','2022-08-19 14:09:10'),
(437,'product.{id}.description',189,'farsi','','textarea','2019-05-18 15:47:53','2019-05-18 15:47:53'),
(438,'product.{id}.name',189,'farsi','WHMCS LICENSE- Persian','text','2019-05-18 15:47:53','2019-05-18 15:47:53'),
(443,'product.{id}.description',192,'farsi','• 160 گیگ هارد\r\n• 8 گیگ رم\r\n• 4 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2019-08-12 06:29:12','2022-08-20 12:30:05'),
(444,'product.{id}.name',192,'farsi','سرور مجازی خارج پلان ششم','text','2019-08-12 06:29:12','2022-08-20 12:30:05'),
(445,'product.{id}.description',193,'farsi','• 240 گیگ هارد\r\n• 16 گیگ رم\r\n• 8 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2019-08-12 06:30:25','2022-08-20 12:32:18'),
(446,'product.{id}.name',193,'farsi','سرور مجازی خارج پلان هشتم','text','2019-08-12 06:30:25','2022-08-20 12:32:18'),
(447,'product.{id}.description',194,'farsi','• 240 گیگ هارد\r\n• 32 گیگ رم\r\n• 8 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2019-08-12 06:32:22','2022-08-20 12:33:04'),
(448,'product.{id}.name',194,'farsi','سرور مجازی خارج پلان نهم','text','2019-08-12 06:32:22','2022-08-20 12:33:04'),
(449,'product.{id}.description',7,'farsi','پشتیبانی نرم افزاری سایت -  php - پلان نقره ای','textarea','2019-08-12 06:42:51','2019-08-12 06:42:51'),
(450,'product.{id}.name',7,'farsi','پشتیبانی نرم افزاری سایت -  php - پلان نقره ای','text','2019-08-12 06:42:51','2019-08-12 06:42:51'),
(451,'product.{id}.description',3,'farsi','پشتیبانی نرم افزاری سایت -  asp .net - پلان برنزی','textarea','2019-08-12 06:43:27','2019-08-12 06:43:27'),
(452,'product.{id}.name',3,'farsi','پشتیبانی نرم افزاری سایت -  asp .net - پلان برنزی','text','2019-08-12 06:43:27','2019-08-12 06:43:27'),
(453,'product.{id}.description',8,'farsi','پشتیبانی نرم افزاری سایت -  php - پلان برنزی','textarea','2019-08-12 06:43:58','2019-08-12 06:43:58'),
(454,'product.{id}.name',8,'farsi','پشتیبانی نرم افزاری سایت -  php - پلان برنزی','text','2019-08-12 06:43:58','2019-08-12 06:43:58'),
(455,'product.{id}.description',195,'farsi',' پشتیبانی نرم افزاری سایت - وردپرس - پلان طلایی','textarea','2019-08-12 06:44:55','2019-08-12 06:45:07'),
(456,'product.{id}.name',195,'farsi',' پشتیبانی نرم افزاری سایت - وردپرس - پلان طلایی','text','2019-08-12 06:44:55','2019-08-12 06:44:55'),
(457,'product.{id}.description',196,'farsi',' پشتیبانی نرم افزاری سایت - وردپرس - پلان نقره ای','textarea','2019-08-12 06:45:46','2019-08-12 06:45:57'),
(458,'product.{id}.name',196,'farsi',' پشتیبانی نرم افزاری سایت - وردپرس - پلان نقره ای','text','2019-08-12 06:45:46','2019-08-12 06:45:46'),
(459,'product.{id}.description',197,'farsi',' پشتیبانی نرم افزاری سایت - وردپرس - پلان برنزی','textarea','2019-08-12 06:46:30','2019-08-12 06:46:40'),
(460,'product.{id}.name',197,'farsi',' پشتیبانی نرم افزاری سایت - وردپرس - پلان برنزی','text','2019-08-12 06:46:30','2019-08-12 06:46:30'),
(461,'product_group.{id}.headline',26,'farsi','سرور اختصاصی ایران','text','2019-08-15 07:32:25','2019-08-15 07:32:25'),
(462,'product_group.{id}.name',26,'farsi','سرور اختصاصی ایران','text','2019-08-15 07:32:25','2019-08-15 07:32:25'),
(463,'product_group.{id}.tagline',26,'farsi','سرور اختصاصی ایران با امکان ارائه ترافیک نامحدود در کشور','text','2019-08-15 07:32:25','2019-08-15 07:32:25'),
(478,'product.{id}.description',199,'farsi','• فضای نامحدود\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2019-10-31 05:32:57','2022-08-19 14:18:55'),
(479,'product.{id}.name',199,'farsi','هاست لینوکس حرفه ای ایران - نامحدود','text','2019-10-31 05:32:57','2022-08-19 14:11:08'),
(480,'product.{id}.description',200,'farsi','رم	16GB\r\nپردازنده - CPU	Intel® Xeon® E5620\r\nتعداد هسته CPU	4Cores/8Threads\r\n250GB-SSD/300GB-SAS\r\nترافیک ماهیانه	1TB\r\nپورت شبکه	1Gb/s\r\nIP اختصاصی	1\r\n','textarea','2020-02-09 13:54:31','2020-08-13 17:43:05'),
(481,'product.{id}.name',200,'farsi','سرور اختصاصی ایران - پلان اول','text','2020-02-09 13:54:31','2020-02-09 13:54:31'),
(482,'product.{id}.description',201,'farsi','رم		32GB\r\nپردازنده - CPU	2xIntel® Xeon® E5620\r\nتعداد هسته CPU	8Cores/16Threads\r\n250GB-SSD/300GB-SAS\r\nترافیک ماهیانه	1TB\r\nپورت شبکه	1Gb/s	\r\nIP اختصاصی	1\r\n','textarea','2020-02-09 13:57:21','2020-08-13 17:42:59'),
(483,'product.{id}.name',201,'farsi','سرور اختصاصی ایران - پلان دوم','text','2020-02-09 13:57:21','2020-02-09 13:57:21'),
(484,'product.{id}.description',202,'farsi','رم		32GB\r\nپردازنده - CPU	2xIntel® Xeon® X5660\r\nتعداد هسته CPU	12Cores/24Threads\r\n250GB-SSD/300GB-SAS\r\nترافیک ماهیانه	1TB\r\nپورت شبکه	1Gb/s\r\nIP اختصاصی	1\r\n','textarea','2020-02-09 13:59:17','2020-08-13 17:43:16'),
(485,'product.{id}.name',202,'farsi','سرور اختصاصی ایران - پلان سوم','text','2020-02-09 13:59:17','2020-02-09 13:59:17'),
(486,'product.{id}.description',203,'farsi','رم	64GB	\r\nپردازنده - CPU	 2xIntel® Xeon® E5-2620 V2\r\nتعداد هسته CPU	12Cores/24Threads	\r\nفضای هارد	 2x300-SAS\r\nترافیک ماهیانه	2TB\r\nپورت شبکه	1Gb/s	 \r\nIP اختصاصی	 1\r\n','textarea','2020-02-09 14:00:54','2020-08-13 17:42:46'),
(487,'product.{id}.name',203,'farsi','سرور اختصاصی ایران - پلان چهارم','text','2020-02-09 14:00:54','2020-02-09 14:00:54'),
(488,'product.{id}.description',204,'farsi','رم	128GB	\r\nپردازنده - CPU	 2xIntel® Xeon® E5-2650 V2\r\nتعداد هسته CPU	20Cores/40Threads	\r\nفضای هارد	 2x250-SSD\r\nترافیک ماهیانه	2TB\r\nپورت شبکه	1Gb/s	 \r\nIP اختصاصی	 1\r\n','textarea','2020-02-09 14:05:19','2020-08-15 09:57:31'),
(489,'product.{id}.name',204,'farsi','سرور اختصاصی ایران - پلان پنجم','text','2020-02-09 14:05:19','2020-02-09 14:05:19'),
(492,'product.{id}.description',206,'farsi','قابل صدور و نصب بر روی IP های اینترنتی ایران\r\n    صدور فوری پس از پرداخت','textarea','2020-03-28 08:54:41','2020-03-28 08:55:51'),
(493,'product.{id}.name',206,'farsi','گواهینامه SSL قابل ارائه و نصب بر روی IP','text','2020-03-28 08:54:41','2020-03-28 08:54:41'),
(499,'product.{id}.description',208,'farsi','• 160 گیگ هارد\r\n• 16 گیگ رم\r\n• 4 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2020-04-22 18:21:43','2022-08-20 12:31:30'),
(500,'product.{id}.name',208,'farsi','سرور مجازی خارج پلان هفتم','text','2020-04-22 18:21:43','2022-08-20 12:31:30'),
(501,'product.{id}.description',209,'farsi','','textarea','2020-10-21 18:17:27','2020-10-21 18:17:27'),
(502,'product.{id}.name',209,'farsi','پشتیبانی سرور','text','2020-10-21 18:17:27','2020-10-21 18:17:27'),
(503,'product.{id}.description',210,'farsi','','textarea','2020-10-25 09:05:31','2020-10-25 09:05:31'),
(504,'product.{id}.name',210,'farsi','IP اختصاصی','text','2020-10-25 09:05:31','2020-10-25 09:05:31'),
(512,'custom_field.{id}.name',102,'farsi','domain :','text','2022-02-23 09:07:06','2022-02-23 09:07:06'),
(513,'custom_field.{id}.description',102,'farsi','','text','2022-02-23 09:07:06','2022-02-23 09:07:06'),
(514,'custom_field.{id}.name',103,'farsi','control panel user name:','text','2022-02-23 09:07:06','2022-02-23 09:07:06'),
(515,'custom_field.{id}.description',103,'farsi','','text','2022-02-23 09:07:06','2022-02-23 09:07:06'),
(516,'custom_field.{id}.name',104,'farsi','control panel password:','text','2022-02-23 09:07:06','2022-02-23 09:07:06'),
(517,'custom_field.{id}.description',104,'farsi','','text','2022-02-23 09:07:06','2022-02-23 09:07:06'),
(518,'product.{id}.description',21,'farsi','پشتیانی نرم افزاری سرور لینوکس - پلان طلایی ','textarea','2022-02-23 09:09:59','2022-02-23 09:13:54'),
(519,'product.{id}.name',21,'farsi','پشتیانی نرم افزاری سرور لینوکس - پلان طلایی ','text','2022-02-23 09:09:59','2022-02-23 09:13:54'),
(520,'product.{id}.description',20,'farsi','پشتیانی نرم افزاری سرور لینوکس - پلان نقره ای ','textarea','2022-02-23 09:10:26','2022-02-23 09:13:08'),
(521,'product.{id}.name',20,'farsi','پشتیانی نرم افزاری سرور لینوکس - پلان نقره ای ','text','2022-02-23 09:10:26','2022-02-23 09:13:08'),
(522,'product.{id}.description',19,'farsi','پشتیانی نرم افزاری سرور لینوکسی - پلان برنزی','textarea','2022-02-23 09:10:43','2022-02-23 09:11:57'),
(523,'product.{id}.name',19,'farsi','پشتیانی نرم افزاری سرور لینوکسی - پلان برنزی','text','2022-02-23 09:10:43','2022-02-23 09:11:57'),
(524,'product.{id}.description',213,'farsi','پشتیانی نرم افزاری سرور ویندوزی - پلان برنزی','textarea','2022-02-23 09:15:25','2022-02-23 09:16:22'),
(525,'product.{id}.name',213,'farsi','پشتیانی نرم افزاری سرور ویندوزی - پلان برنزی','text','2022-02-23 09:15:25','2022-02-23 09:15:26'),
(526,'custom_field.{id}.name',105,'farsi','نوع سیستم عامل:','text','2022-02-23 09:15:25','2022-02-23 09:15:25'),
(527,'custom_field.{id}.description',105,'farsi','','text','2022-02-23 09:15:25','2022-02-23 09:15:25'),
(528,'custom_field.{id}.name',106,'farsi','IP سرور :','text','2022-02-23 09:15:25','2022-02-23 09:15:25'),
(529,'custom_field.{id}.description',106,'farsi','','text','2022-02-23 09:15:26','2022-02-23 09:15:26'),
(530,'product.{id}.description',214,'farsi','پشتیانی نرم افزاری سرور ویندوزی - پلان طلایی ','textarea','2022-02-23 09:17:42','2022-02-23 09:19:41'),
(531,'product.{id}.name',214,'farsi','پشتیبانی نرم افزاری سرور ویندوزی - پلان طلایی','text','2022-02-23 09:17:42','2022-02-23 09:17:42'),
(532,'custom_field.{id}.name',107,'farsi','IP سرور :','text','2022-02-23 09:17:42','2022-02-23 09:17:42'),
(533,'custom_field.{id}.description',107,'farsi','','text','2022-02-23 09:17:42','2022-02-23 09:17:42'),
(534,'custom_field.{id}.name',108,'farsi','نوع سیستم عامل:','text','2022-02-23 09:17:42','2022-02-23 09:17:42'),
(535,'custom_field.{id}.description',108,'farsi','','text','2022-02-23 09:17:42','2022-02-23 09:17:42'),
(536,'product.{id}.description',215,'farsi','پشتیانی نرم افزاری سرور ویندوز- پلان نقره ای ','textarea','2022-02-23 09:21:00','2022-02-23 09:22:05'),
(537,'product.{id}.name',215,'farsi','پشتیبانی نرم افزاری سرور ویندوزی - پلان نقره ای','text','2022-02-23 09:21:00','2022-02-23 09:21:00'),
(538,'custom_field.{id}.name',109,'farsi','نوع سیستم عامل:','text','2022-02-23 09:21:00','2022-02-23 09:21:00'),
(539,'custom_field.{id}.description',109,'farsi','','text','2022-02-23 09:21:00','2022-02-23 09:21:00'),
(540,'custom_field.{id}.name',110,'farsi','IP سرور :','text','2022-02-23 09:21:00','2022-02-23 09:21:00'),
(541,'custom_field.{id}.description',110,'farsi','','text','2022-02-23 09:21:00','2022-02-23 09:21:00'),
(544,'custom_field.{id}.name',123,'farsi','سیستم عامل مورد نظر','text','2022-03-12 15:01:44','2022-03-12 15:01:44'),
(545,'custom_field.{id}.description',123,'farsi','','text','2022-03-12 15:01:44','2022-03-12 15:01:44'),
(546,'custom_field.{id}.name',124,'farsi','سیستم عامل دلخواه','text','2022-03-12 15:01:44','2022-03-12 15:01:44'),
(547,'custom_field.{id}.description',124,'farsi','در صورتی که سیستم عامل مد نظر شما در لیست موجود نبود نام سیستم عامل خود را وارد نمایید','text','2022-03-12 15:01:44','2022-03-12 15:01:44'),
(551,'product.{id}.tagline',217,'farsi','','text','2022-08-12 13:12:03','2022-08-12 13:12:03'),
(552,'product.{id}.short_description',217,'farsi','مناسب PHP و وردپرس','textarea','2022-08-12 13:12:03','2022-08-13 11:55:25'),
(553,'product.{id}.description',217,'farsi','• 100 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-12 13:12:03','2022-08-20 03:56:38'),
(554,'product.{id}.name',217,'farsi','هاست لینوکس ایران - 100 مگ','text','2022-08-12 13:12:03','2022-08-13 12:07:58'),
(555,'product.{id}.tagline',218,'farsi','','text','2022-08-12 13:34:04','2022-08-12 13:34:04'),
(556,'product.{id}.short_description',218,'farsi','مناسب PHP و وردپرس','textarea','2022-08-12 13:34:04','2022-08-13 11:57:02'),
(557,'product.{id}.description',218,'farsi','• 500 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-12 13:34:04','2022-08-20 03:56:47'),
(558,'product.{id}.name',218,'farsi','هاست لینوکس ایران - 500 مگ','text','2022-08-12 13:34:04','2022-08-13 12:07:54'),
(559,'product.{id}.tagline',219,'farsi','','text','2022-08-12 13:43:21','2022-08-12 13:43:21'),
(560,'product.{id}.short_description',219,'farsi','مناسب PHP و وردپرس','textarea','2022-08-12 13:43:21','2022-08-13 11:58:26'),
(561,'product.{id}.description',219,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-12 13:43:21','2022-08-20 03:56:54'),
(562,'product.{id}.name',219,'farsi','هاست لینوکس ایران - 1 گیگ','text','2022-08-12 13:43:21','2022-08-13 12:07:49'),
(563,'product.{id}.tagline',220,'farsi','','text','2022-08-12 14:01:10','2022-08-12 14:01:10'),
(564,'product.{id}.short_description',220,'farsi','مناسب PHP و وردپرس','textarea','2022-08-12 14:01:10','2022-08-13 11:59:55'),
(565,'product.{id}.description',220,'farsi','• 2 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-12 14:01:10','2022-08-20 03:57:00'),
(566,'product.{id}.name',220,'farsi','هاست لینوکس ایران - 2 گیگ','text','2022-08-12 14:01:10','2022-08-13 12:07:01'),
(567,'product.{id}.tagline',221,'farsi','','text','2022-08-12 14:03:23','2022-08-12 14:03:23'),
(568,'product.{id}.short_description',221,'farsi','مناسب PHP و وردپرس','textarea','2022-08-12 14:03:23','2022-08-13 12:00:30'),
(569,'product.{id}.description',221,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-12 14:03:23','2022-08-20 03:57:05'),
(570,'product.{id}.name',221,'farsi','هاست لینوکس ایران - 5 گیگ','text','2022-08-12 14:03:23','2022-08-13 12:07:17'),
(571,'product.{id}.tagline',222,'farsi','','text','2022-08-12 14:07:05','2022-08-12 14:07:05'),
(572,'product.{id}.short_description',222,'farsi','مناسب PHP و وردپرس','textarea','2022-08-12 14:07:05','2022-08-13 12:00:27'),
(573,'product.{id}.description',222,'farsi','• 10 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-12 14:07:05','2022-08-20 03:57:12'),
(574,'product.{id}.name',222,'farsi','هاست لینوکس ایران - 10 گیگ','text','2022-08-12 14:07:05','2022-08-13 12:07:07'),
(575,'product.{id}.tagline',223,'farsi','','text','2022-08-13 11:08:32','2022-08-13 11:08:32'),
(576,'product.{id}.short_description',223,'farsi','مناسب PHP و وردپرس','textarea','2022-08-13 11:08:32','2022-08-13 13:45:26'),
(577,'product.{id}.description',223,'farsi','• 100 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-13 11:08:32','2022-08-20 03:56:51'),
(578,'product.{id}.name',223,'farsi','هاست لینوکس خارج - 100 مگ','text','2022-08-13 11:08:32','2022-08-13 13:45:26'),
(579,'product.{id}.tagline',224,'farsi','','text','2022-08-13 11:13:04','2022-08-13 11:13:04'),
(580,'product.{id}.short_description',224,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:13:04','2022-08-13 13:34:33'),
(581,'product.{id}.description',224,'farsi','• 500 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-13 11:13:04','2022-08-20 03:56:48'),
(582,'product.{id}.name',224,'farsi','هاست لینوکس خارج - 500 مگ','text','2022-08-13 11:13:04','2022-08-13 13:45:57'),
(583,'product.{id}.tagline',225,'farsi','','text','2022-08-13 11:13:35','2022-08-13 11:13:35'),
(584,'product.{id}.short_description',225,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:13:35','2022-08-13 13:34:39'),
(585,'product.{id}.description',225,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-13 11:13:35','2022-08-20 03:56:57'),
(586,'product.{id}.name',225,'farsi','هاست لینوکس خارج - 1 گیگ','text','2022-08-13 11:13:35','2022-08-13 13:46:56'),
(587,'product.{id}.tagline',226,'farsi','','text','2022-08-13 11:14:01','2022-08-13 11:14:01'),
(588,'product.{id}.short_description',226,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:14:01','2022-08-13 13:35:56'),
(589,'product.{id}.description',226,'farsi','• 2 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-13 11:14:01','2022-08-20 03:57:02'),
(590,'product.{id}.name',226,'farsi','هاست لینوکس خارج - 2 گیگ','text','2022-08-13 11:14:01','2022-08-13 13:47:13'),
(591,'product.{id}.tagline',227,'farsi','','text','2022-08-13 11:14:34','2022-08-13 11:14:34'),
(592,'product.{id}.short_description',227,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:14:34','2022-08-13 13:36:14'),
(593,'product.{id}.description',227,'farsi','• 5 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-13 11:14:34','2022-08-20 03:57:09'),
(594,'product.{id}.name',227,'farsi','هاست لینوکس خارج - 5 گیگ','text','2022-08-13 11:14:34','2022-08-13 13:47:57'),
(595,'product.{id}.tagline',228,'farsi','','text','2022-08-13 11:15:00','2022-08-13 11:15:00'),
(596,'product.{id}.short_description',228,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:15:00','2022-08-13 13:36:32'),
(597,'product.{id}.description',228,'farsi','• 10 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-13 11:15:00','2022-08-20 03:57:15'),
(598,'product.{id}.name',228,'farsi','هاست لینوکس خارج - 10 گیگ','text','2022-08-13 11:15:00','2022-08-13 13:48:59'),
(602,'product.{id}.tagline',229,'farsi','','text','2022-08-13 11:22:31','2022-08-13 11:22:31'),
(603,'product.{id}.short_description',229,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:22:31','2022-08-14 03:13:48'),
(604,'product.{id}.description',229,'farsi','• 500 مگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:22:31','2022-08-20 03:58:52'),
(605,'product.{id}.name',229,'farsi','هاست وردپرس ایران - 500 مگ','text','2022-08-13 11:22:31','2022-08-14 03:13:48'),
(606,'product.{id}.tagline',230,'farsi','','text','2022-08-13 11:24:46','2022-08-13 11:24:46'),
(607,'product.{id}.short_description',230,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:24:46','2022-08-14 03:12:34'),
(608,'product.{id}.description',230,'farsi','• 1 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:24:46','2022-08-20 03:59:01'),
(609,'product.{id}.name',230,'farsi','هاست وردپرس ایران - 1 گیگ','text','2022-08-13 11:24:46','2022-08-14 03:12:34'),
(610,'product.{id}.tagline',231,'farsi','','text','2022-08-13 11:26:31','2022-08-13 11:26:31'),
(611,'product.{id}.short_description',231,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:26:31','2022-08-14 03:11:25'),
(612,'product.{id}.description',231,'farsi','• 2 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:26:31','2022-08-20 03:59:07'),
(613,'product.{id}.name',231,'farsi','هاست وردپرس ایران - 2 گیگ','text','2022-08-13 11:26:31','2022-08-14 03:11:25'),
(614,'product.{id}.tagline',232,'farsi','','text','2022-08-13 11:28:14','2022-08-13 11:28:14'),
(615,'product.{id}.short_description',232,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:28:14','2022-08-14 03:10:33'),
(616,'product.{id}.description',232,'farsi','• 5 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:28:14','2022-08-20 03:59:13'),
(617,'product.{id}.name',232,'farsi','هاست وردپرس ایران - 5 گیگ','text','2022-08-13 11:28:14','2022-08-14 03:10:33'),
(618,'product.{id}.tagline',233,'farsi','','text','2022-08-13 11:29:21','2022-08-13 11:29:21'),
(619,'product.{id}.short_description',233,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:29:21','2022-08-14 03:08:57'),
(620,'product.{id}.description',233,'farsi','• 10 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:29:21','2022-08-20 03:59:16'),
(621,'product.{id}.name',233,'farsi','هاست وردپرس ایران - 10 گیگ','text','2022-08-13 11:29:21','2022-08-14 03:08:57'),
(622,'product.{id}.tagline',234,'farsi','','text','2022-08-13 11:30:33','2022-08-13 11:30:33'),
(623,'product.{id}.short_description',234,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:30:33','2022-08-14 03:08:03'),
(624,'product.{id}.description',234,'farsi','• 15 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:30:33','2022-08-20 03:59:25'),
(625,'product.{id}.name',234,'farsi','هاست وردپرس ایران - 15 گیگ','text','2022-08-13 11:30:33','2022-08-14 03:08:03'),
(626,'product.{id}.tagline',235,'farsi','','text','2022-08-13 11:32:17','2022-08-13 11:32:17'),
(627,'product.{id}.short_description',235,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:32:17','2022-08-14 03:13:46'),
(628,'product.{id}.description',235,'farsi','• 500 مگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:32:17','2022-08-20 03:58:59'),
(629,'product.{id}.name',235,'farsi','هاست وردپرس خارج - 500 مگ','text','2022-08-13 11:32:17','2022-08-14 03:13:46'),
(630,'product.{id}.tagline',236,'farsi','','text','2022-08-13 11:33:18','2022-08-13 11:33:18'),
(631,'product.{id}.short_description',236,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:33:18','2022-08-14 03:12:36'),
(632,'product.{id}.description',236,'farsi','• 1 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:33:18','2022-08-20 03:59:03'),
(633,'product.{id}.name',236,'farsi','هاست وردپرس خارج - 1 گیگ','text','2022-08-13 11:33:18','2022-08-14 03:12:36'),
(634,'product.{id}.tagline',237,'farsi','','text','2022-08-13 11:33:49','2022-08-13 11:33:49'),
(635,'product.{id}.short_description',237,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:33:49','2022-08-14 03:11:26'),
(636,'product.{id}.description',237,'farsi','• 2 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:33:49','2022-08-20 03:59:12'),
(637,'product.{id}.name',237,'farsi','هاست وردپرس خارج - 2 گیگ','text','2022-08-13 11:33:49','2022-08-14 03:11:26'),
(638,'product.{id}.tagline',238,'farsi','','text','2022-08-13 11:34:50','2022-08-13 11:34:50'),
(639,'product.{id}.short_description',238,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:34:50','2022-08-14 03:10:31'),
(640,'product.{id}.description',238,'farsi','• 5 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:34:50','2022-08-20 03:59:19'),
(641,'product.{id}.name',238,'farsi','هاست وردپرس خارج - 5 گیگ','text','2022-08-13 11:34:50','2022-08-14 03:10:31'),
(642,'product.{id}.tagline',239,'farsi','','text','2022-08-13 11:35:25','2022-08-13 11:35:25'),
(643,'product.{id}.short_description',239,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:35:25','2022-08-14 03:09:07'),
(644,'product.{id}.description',239,'farsi','• 10 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:35:25','2022-08-20 03:59:28'),
(645,'product.{id}.name',239,'farsi','هاست وردپرس خارج - 10 گیگ','text','2022-08-13 11:35:25','2022-08-14 03:09:07'),
(646,'product.{id}.tagline',240,'farsi','','text','2022-08-13 11:35:51','2022-08-13 11:35:51'),
(647,'product.{id}.short_description',240,'farsi','هاست PHP و وردپرس','textarea','2022-08-13 11:35:51','2022-08-14 03:07:23'),
(648,'product.{id}.description',240,'farsi','• 15 گیگ فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• بهینه شده برای وردپرس','textarea','2022-08-13 11:35:51','2022-08-20 03:59:32'),
(649,'product.{id}.name',240,'farsi','هاست وردپرس خارج - 15 گیگ','text','2022-08-13 11:35:51','2022-08-14 03:07:23'),
(653,'product.{id}.tagline',241,'farsi','','text','2022-08-13 11:46:13','2022-08-13 11:46:13'),
(654,'product.{id}.short_description',241,'farsi','مناسب برای جنگو فلسک','textarea','2022-08-13 11:46:13','2022-08-14 03:21:30'),
(655,'product.{id}.description',241,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• دسترسی shell','textarea','2022-08-13 11:46:13','2022-08-14 03:23:59'),
(656,'product.{id}.name',241,'farsi','هاست پایتون ایران - 1 گیگ','text','2022-08-13 11:46:13','2022-08-14 03:21:30'),
(660,'product.{id}.tagline',242,'farsi','','text','2022-08-13 11:55:10','2022-08-13 11:55:10'),
(661,'product.{id}.short_description',242,'farsi','مناسب برای جنگو فلسک','textarea','2022-08-13 11:55:10','2022-08-14 03:21:35'),
(662,'product.{id}.description',242,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• دسترسی shell','textarea','2022-08-13 11:55:10','2022-08-14 03:24:00'),
(663,'product.{id}.name',242,'farsi','هاست پایتون ایران - 5 گیگ','text','2022-08-13 11:55:10','2022-08-14 03:21:35'),
(664,'product.{id}.tagline',243,'farsi','','text','2022-08-13 11:56:49','2022-08-13 11:56:49'),
(665,'product.{id}.short_description',243,'farsi','مناسب برای جنگو فلسک','textarea','2022-08-13 11:56:49','2022-08-14 03:21:59'),
(666,'product.{id}.description',243,'farsi','• 10 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• دسترسی shell','textarea','2022-08-13 11:56:49','2022-08-14 03:24:03'),
(667,'product.{id}.name',243,'farsi','هاست پایتون ایران - 10 گیگ','text','2022-08-13 11:56:49','2022-08-14 03:21:59'),
(671,'product.{id}.tagline',244,'farsi','','text','2022-08-13 12:02:00','2022-08-13 12:02:00'),
(672,'product.{id}.short_description',244,'farsi','مناسب برای جنگو فلسک','textarea','2022-08-13 12:02:00','2022-08-14 03:20:43'),
(673,'product.{id}.description',244,'farsi','• 10 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• دسترسی shell','textarea','2022-08-13 12:02:00','2022-08-14 03:23:22'),
(674,'product.{id}.name',244,'farsi','هاست پایتون خارج - 10 گیگ','text','2022-08-13 12:02:00','2022-08-14 03:21:11'),
(675,'product.{id}.tagline',245,'farsi','','text','2022-08-13 12:02:59','2022-08-13 12:02:59'),
(676,'product.{id}.short_description',245,'farsi','مناسب برای جنگو فلسک','textarea','2022-08-13 12:02:59','2022-08-14 03:20:41'),
(677,'product.{id}.description',245,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• دسترسی shell','textarea','2022-08-13 12:02:59','2022-08-14 03:23:35'),
(678,'product.{id}.name',245,'farsi','هاست پایتون خارج - 5 گیگ','text','2022-08-13 12:02:59','2022-08-14 03:21:13'),
(679,'product.{id}.tagline',246,'farsi','','text','2022-08-13 12:03:32','2022-08-13 12:03:32'),
(680,'product.{id}.short_description',246,'farsi','مناسب برای جنگو فلسک','textarea','2022-08-13 12:03:32','2022-08-14 03:20:38'),
(681,'product.{id}.description',246,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• دسترسی shell','textarea','2022-08-13 12:03:32','2022-08-14 03:23:42'),
(682,'product.{id}.name',246,'farsi','هاست پایتون خارج -1 گیگ','text','2022-08-13 12:03:32','2022-08-14 03:21:09'),
(689,'product.{id}.tagline',247,'farsi','','text','2022-08-13 12:08:05','2022-08-13 12:08:05'),
(690,'product.{id}.short_description',247,'farsi','','textarea','2022-08-13 12:08:05','2022-08-13 12:08:05'),
(691,'product.{id}.description',247,'farsi','• 10 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:08:05','2022-08-14 03:51:26'),
(692,'product.{id}.name',247,'farsi','هاست نود جی اس ایران - 10 گیگ','text','2022-08-13 12:08:05','2022-08-14 03:51:26'),
(693,'product.{id}.tagline',248,'farsi','','text','2022-08-13 12:09:07','2022-08-13 12:09:07'),
(694,'product.{id}.short_description',248,'farsi','','textarea','2022-08-13 12:09:07','2022-08-13 12:09:07'),
(695,'product.{id}.description',248,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:09:07','2022-08-14 03:51:20'),
(696,'product.{id}.name',248,'farsi','هاست نود جی اس ایران - 1 گیگ','text','2022-08-13 12:09:07','2022-08-14 03:51:20'),
(697,'product.{id}.tagline',249,'farsi','','text','2022-08-13 12:10:18','2022-08-13 12:10:18'),
(698,'product.{id}.short_description',249,'farsi','','textarea','2022-08-13 12:10:18','2022-08-13 12:10:18'),
(699,'product.{id}.description',249,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:10:18','2022-08-14 03:51:23'),
(700,'product.{id}.name',249,'farsi','هاست نود جی اس ایران - 5 گیگ','text','2022-08-13 12:10:18','2022-08-14 03:51:23'),
(701,'product.{id}.tagline',250,'farsi','','text','2022-08-13 12:11:02','2022-08-13 12:11:02'),
(702,'product.{id}.short_description',250,'farsi','','textarea','2022-08-13 12:11:02','2022-08-13 12:11:02'),
(703,'product.{id}.description',250,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:11:02','2022-08-14 03:53:03'),
(704,'product.{id}.name',250,'farsi','هاست نود جی اس خارج - 1 گیگ','text','2022-08-13 12:11:02','2022-08-14 03:44:42'),
(705,'product.{id}.tagline',251,'farsi','','text','2022-08-13 12:12:03','2022-08-13 12:12:03'),
(706,'product.{id}.short_description',251,'farsi','','textarea','2022-08-13 12:12:03','2022-08-13 12:12:03'),
(707,'product.{id}.description',251,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:12:03','2022-08-14 03:51:35'),
(708,'product.{id}.name',251,'farsi','هاست نود جی اس خارج - 5 گیگ','text','2022-08-13 12:12:03','2022-08-14 03:44:44'),
(709,'product.{id}.tagline',252,'farsi','','text','2022-08-13 12:12:52','2022-08-13 12:12:52'),
(710,'product.{id}.short_description',252,'farsi','','textarea','2022-08-13 12:12:52','2022-08-13 12:12:52'),
(711,'product.{id}.description',252,'farsi','• 10 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:12:52','2022-08-14 03:51:39'),
(712,'product.{id}.name',252,'farsi','هاست نود جی اس خارج - 10 گیگ','text','2022-08-13 12:12:52','2022-08-14 03:44:46'),
(713,'product.{id}.tagline',253,'farsi','','text','2022-08-13 12:51:18','2022-08-13 12:51:18'),
(714,'product.{id}.short_description',253,'farsi','','textarea','2022-08-13 12:51:18','2022-08-18 00:30:38'),
(715,'product.{id}.description',253,'farsi','• 500 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:51:18','2022-08-20 03:57:53'),
(716,'product.{id}.name',253,'farsi','هاست ویندوز ایران - 500 مگ','text','2022-08-13 12:51:18','2022-08-20 03:45:18'),
(717,'product.{id}.tagline',254,'farsi','','text','2022-08-13 12:54:03','2022-08-13 12:54:03'),
(718,'product.{id}.short_description',254,'farsi','','textarea','2022-08-13 12:54:04','2022-08-13 12:54:04'),
(719,'product.{id}.description',254,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:54:04','2022-08-20 03:58:00'),
(720,'product.{id}.name',254,'farsi','هاست ویندوز ایران - 1 گیگ','text','2022-08-13 12:54:04','2022-08-20 03:43:45'),
(721,'product.{id}.tagline',255,'farsi','','text','2022-08-13 12:54:48','2022-08-13 12:54:48'),
(722,'product.{id}.short_description',255,'farsi','مناسب PHP و وردپرس','textarea','2022-08-13 12:54:48','2022-08-13 12:54:48'),
(723,'product.{id}.description',255,'farsi','• 2 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:54:48','2022-08-20 03:58:04'),
(724,'product.{id}.name',255,'farsi','هاست ویندوز ایران - 2 گیگ','text','2022-08-13 12:54:48','2022-08-20 03:43:36'),
(725,'product.{id}.tagline',256,'farsi','','text','2022-08-13 12:55:30','2022-08-13 12:55:30'),
(726,'product.{id}.short_description',256,'farsi','مناسب PHP و وردپرس','textarea','2022-08-13 12:55:30','2022-08-13 12:55:30'),
(727,'product.{id}.description',256,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:55:30','2022-08-20 03:58:13'),
(728,'product.{id}.name',256,'farsi','هاست ویندوز ایران - 5 گیگ','text','2022-08-13 12:55:30','2022-08-20 03:48:31'),
(729,'product.{id}.tagline',257,'farsi','','text','2022-08-13 12:57:19','2022-08-13 12:57:19'),
(730,'product.{id}.short_description',257,'farsi','مناسب PHP و وردپرس','textarea','2022-08-13 12:57:19','2022-08-13 12:57:19'),
(731,'product.{id}.description',257,'farsi','• 100 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:57:19','2022-08-20 03:57:50'),
(732,'product.{id}.name',257,'farsi','هاست ویندوز ایران - 100 مگ','text','2022-08-13 12:57:19','2022-08-20 03:44:23'),
(733,'product.{id}.tagline',258,'farsi','','text','2022-08-13 12:58:24','2022-08-13 12:58:24'),
(734,'product.{id}.short_description',258,'farsi','مناسب PHP و وردپرس','textarea','2022-08-13 12:58:24','2022-08-13 12:58:24'),
(735,'product.{id}.description',258,'farsi','• 10 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:58:24','2022-08-20 03:58:19'),
(736,'product.{id}.name',258,'farsi','هاست ویندوز ایران - 10 گیگ','text','2022-08-13 12:58:24','2022-08-20 03:48:58'),
(737,'product.{id}.tagline',259,'farsi','','text','2022-08-13 12:59:49','2022-08-13 12:59:49'),
(738,'product.{id}.short_description',259,'farsi','مناسب asp و .net core','textarea','2022-08-13 12:59:49','2022-08-18 01:04:45'),
(739,'product.{id}.description',259,'farsi','• 100 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 12:59:49','2022-08-20 03:57:54'),
(740,'product.{id}.name',259,'farsi','هاست ویندوز خارج - 100 مگ','text','2022-08-13 12:59:49','2022-08-20 03:46:21'),
(741,'product.{id}.tagline',260,'farsi','','text','2022-08-13 13:02:12','2022-08-13 13:02:12'),
(742,'product.{id}.short_description',260,'farsi','مناسب asp و .net core','textarea','2022-08-13 13:02:12','2022-08-18 06:54:26'),
(743,'product.{id}.description',260,'farsi','• 500 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 13:02:12','2022-08-20 03:57:57'),
(744,'product.{id}.name',260,'farsi','هاست ویندوز خارج - 500 مگ','text','2022-08-13 13:02:12','2022-08-20 03:46:32'),
(745,'product.{id}.tagline',261,'farsi','','text','2022-08-13 13:02:59','2022-08-13 13:02:59'),
(746,'product.{id}.short_description',261,'farsi','مناسب برای ASP و Dot Net Core','textarea','2022-08-13 13:02:59','2022-08-14 03:55:50'),
(747,'product.{id}.description',261,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 13:02:59','2022-08-20 03:58:07'),
(748,'product.{id}.name',261,'farsi','هاست ویندوز خارج - 1 گیگ','text','2022-08-13 13:02:59','2022-08-14 03:57:29'),
(749,'product.{id}.tagline',262,'farsi','','text','2022-08-13 13:03:39','2022-08-13 13:03:39'),
(750,'product.{id}.short_description',262,'farsi','مناسب asp و .net core','textarea','2022-08-13 13:03:39','2022-08-18 06:56:28'),
(751,'product.{id}.description',262,'farsi','• 2 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 13:03:39','2022-08-20 03:58:09'),
(752,'product.{id}.name',262,'farsi','هاست ویندوز خارج - 2 گیگ','text','2022-08-13 13:03:39','2022-08-18 06:56:28'),
(753,'product.{id}.tagline',263,'farsi','','text','2022-08-13 13:04:11','2022-08-13 13:04:11'),
(754,'product.{id}.short_description',263,'farsi','مناسب asp و .net core','textarea','2022-08-13 13:04:11','2022-08-18 06:57:23'),
(755,'product.{id}.description',263,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 13:04:11','2022-08-20 03:58:16'),
(756,'product.{id}.name',263,'farsi','هاست ویندوز خارج - 5 گیگ','text','2022-08-13 13:04:11','2022-08-18 06:57:23'),
(757,'product.{id}.tagline',264,'farsi','','text','2022-08-13 13:04:47','2022-08-13 13:04:47'),
(758,'product.{id}.short_description',264,'farsi','مناسب asp و .net core','textarea','2022-08-13 13:04:47','2022-08-14 04:04:33'),
(759,'product.{id}.description',264,'farsi','• 10 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-13 13:04:47','2022-08-20 03:58:21'),
(760,'product.{id}.name',264,'farsi','هاست ویندوز خارج - 10 گیگ','text','2022-08-13 13:04:47','2022-08-14 04:04:33'),
(761,'product.{id}.tagline',265,'farsi','','text','2022-08-15 16:27:37','2022-08-15 16:27:37'),
(762,'product.{id}.short_description',265,'farsi','','textarea','2022-08-15 16:27:37','2022-08-15 16:27:37'),
(763,'product.{id}.description',265,'farsi','1گیگ رم\r\n 1 CPU\r\nتحویل آنی\r\n','textarea','2022-08-15 16:27:37','2023-03-10 09:51:51'),
(764,'product.{id}.name',265,'farsi','سرور مجازی ایران پلان اول','text','2022-08-15 16:27:37','2022-08-15 16:28:57'),
(765,'product.{id}.tagline',266,'farsi','','text','2022-08-15 16:29:42','2022-08-15 16:29:42'),
(766,'product.{id}.short_description',266,'farsi','','textarea','2022-08-15 16:29:42','2022-08-15 16:29:42'),
(767,'product.{id}.description',266,'farsi','• 30 گیگ هارد\r\n• 2 گیگ رم\r\n• 1 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2022-08-15 16:29:42','2022-08-20 03:55:20'),
(768,'product.{id}.name',266,'farsi','سرور مجازی ایران پلان دوم','text','2022-08-15 16:29:42','2022-08-15 16:29:42'),
(769,'product.{id}.tagline',267,'farsi','','text','2022-08-15 16:31:14','2022-08-15 16:31:14'),
(770,'product.{id}.short_description',267,'farsi','','textarea','2022-08-15 16:31:14','2022-08-15 16:31:14'),
(771,'product.{id}.description',267,'farsi','• 40 گیگ هارد\r\n• 3 گیگ رم\r\n• 2 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2022-08-15 16:31:14','2022-08-20 03:55:22'),
(772,'product.{id}.name',267,'farsi','سرور مجازی ایران پلان سوم','text','2022-08-15 16:31:14','2022-08-15 16:31:14'),
(773,'product.{id}.tagline',268,'farsi','','text','2022-08-15 16:32:51','2022-08-15 16:32:51'),
(774,'product.{id}.short_description',268,'farsi','','textarea','2022-08-15 16:32:51','2022-08-15 16:32:51'),
(775,'product.{id}.description',268,'farsi','• 60 گیگ هارد\r\n• 4 گیگ رم\r\n• 3 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2022-08-15 16:32:51','2022-08-20 03:55:38'),
(776,'product.{id}.name',268,'farsi','سرور مجازی ایران پلان چهارم','text','2022-08-15 16:32:51','2022-08-15 16:32:51'),
(777,'product.{id}.tagline',269,'farsi','','text','2022-08-15 16:34:24','2022-08-15 16:34:24'),
(778,'product.{id}.short_description',269,'farsi','','textarea','2022-08-15 16:34:24','2022-08-15 16:34:24'),
(779,'product.{id}.description',269,'farsi','• 80 گیگ هارد\r\n• 8 گیگ رم\r\n• 4 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2022-08-15 16:34:24','2022-08-20 03:55:51'),
(780,'product.{id}.name',269,'farsi','سرور مجازی ایران پلان پنجم','text','2022-08-15 16:34:24','2022-08-15 16:34:24'),
(787,'product.{id}.tagline',270,'farsi','','text','2022-08-15 17:13:56','2022-08-15 17:13:56'),
(788,'product.{id}.short_description',270,'farsi','','textarea','2022-08-15 17:13:56','2022-08-15 17:13:56'),
(789,'product.{id}.description',270,'farsi','• 20 گیگ هارد\r\n• 2 گیگ رم\r\n• 1 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2022-08-15 17:13:56','2022-08-20 13:46:10'),
(790,'product.{id}.name',270,'farsi','سرور مجازی خارج پلان اول','text','2022-08-15 17:13:56','2022-08-15 17:13:56'),
(791,'product.{id}.tagline',271,'farsi','','text','2022-08-15 17:15:54','2022-08-15 17:15:54'),
(792,'product.{id}.short_description',271,'farsi','','textarea','2022-08-15 17:15:54','2022-08-15 17:15:54'),
(793,'product.{id}.description',271,'farsi','• 40 گیگ هارد\r\n• 2 گیگ رم\r\n• 2 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2022-08-15 17:15:54','2022-08-20 13:44:54'),
(794,'product.{id}.name',271,'farsi','سرور مجازی خارج پلان دوم','text','2022-08-15 17:15:54','2022-08-15 17:16:59'),
(795,'product.{id}.tagline',272,'farsi','','text','2022-08-15 17:17:41','2022-08-15 17:17:41'),
(796,'product.{id}.short_description',272,'farsi','','textarea','2022-08-15 17:17:41','2022-08-15 17:17:41'),
(797,'product.{id}.description',272,'farsi','• 40 گیگ هارد\r\n• 4 گیگ رم\r\n• 2 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2022-08-15 17:17:41','2022-08-20 13:45:18'),
(798,'product.{id}.name',272,'farsi','سرور مجازی خارج پلان سوم','text','2022-08-15 17:17:41','2022-08-15 17:17:41'),
(799,'product.{id}.tagline',273,'farsi','','text','2022-08-15 17:19:40','2022-08-15 17:19:40'),
(800,'product.{id}.short_description',273,'farsi','','textarea','2022-08-15 17:19:40','2022-08-15 17:19:40'),
(801,'product.{id}.description',273,'farsi','• 80 گیگ هارد\r\n• 4 گیگ رم\r\n• 3 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2022-08-15 17:19:40','2022-08-20 13:45:35'),
(802,'product.{id}.name',273,'farsi','سرور مجازی خارج پلان چهارم','text','2022-08-15 17:19:40','2022-08-15 17:19:40'),
(803,'product.{id}.tagline',274,'farsi','','text','2022-08-15 17:21:17','2022-08-15 17:21:17'),
(804,'product.{id}.short_description',274,'farsi','','textarea','2022-08-15 17:21:17','2022-08-15 17:21:17'),
(805,'product.{id}.description',274,'farsi','• 80 گیگ هارد\r\n• 8 گیگ رم\r\n• 2 هسته cpu\r\n• هارد SSD\r\n• ترافیک نامحدود','textarea','2022-08-15 17:21:17','2022-08-20 13:45:54'),
(806,'product.{id}.name',274,'farsi','سرور مجازی خارج پلان پنجم','text','2022-08-15 17:21:17','2022-08-15 17:21:18'),
(816,'product.{id}.tagline',275,'farsi','','text','2022-08-19 10:52:33','2022-08-19 10:52:33'),
(817,'product.{id}.short_description',275,'farsi','مناسب PHP و وردپرس','textarea','2022-08-19 10:52:33','2022-08-19 10:52:33'),
(818,'product.{id}.description',275,'farsi','• 100 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 10:52:33','2022-08-19 14:28:25'),
(819,'product.{id}.name',275,'farsi','هاست ویندوز حرفه ای ایران - 100 مگ','text','2022-08-19 10:52:33','2022-08-19 14:28:25'),
(820,'product.{id}.tagline',276,'farsi','','text','2022-08-19 10:54:46','2022-08-19 10:54:46'),
(821,'product.{id}.short_description',276,'farsi','','textarea','2022-08-19 10:54:46','2022-08-19 10:54:46'),
(822,'product.{id}.description',276,'farsi','• 500 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 10:54:46','2022-08-19 10:54:46'),
(823,'product.{id}.name',276,'farsi','هاست ویندوز حرفه ای ایران - 500 مگ','text','2022-08-19 10:54:46','2022-08-19 14:28:35'),
(824,'product.{id}.tagline',277,'farsi','','text','2022-08-19 10:55:44','2022-08-19 10:55:44'),
(825,'product.{id}.short_description',277,'farsi','','textarea','2022-08-19 10:55:44','2022-08-19 10:55:44'),
(826,'product.{id}.description',277,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 10:55:44','2022-08-19 14:29:07'),
(827,'product.{id}.name',277,'farsi','هاست ویندوز حرفه ای ایران - 1 گیگ','text','2022-08-19 10:55:44','2022-08-19 14:29:07'),
(832,'product.{id}.tagline',279,'farsi','','text','2022-08-19 10:58:02','2022-08-19 10:58:02'),
(833,'product.{id}.short_description',279,'farsi','مناسب PHP و وردپرس','textarea','2022-08-19 10:58:02','2022-08-19 10:58:02'),
(834,'product.{id}.description',279,'farsi','• 3 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 10:58:02','2022-08-19 14:29:19'),
(835,'product.{id}.name',279,'farsi','هاست ویندوز حرفه ای ایران - 3 گیگ','text','2022-08-19 10:58:02','2022-08-19 14:29:19'),
(836,'product.{id}.tagline',280,'farsi','','text','2022-08-19 11:00:05','2022-08-19 11:00:05'),
(837,'product.{id}.short_description',280,'farsi','مناسب PHP و وردپرس','textarea','2022-08-19 11:00:05','2022-08-19 11:00:05'),
(838,'product.{id}.description',280,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 11:00:05','2022-08-19 14:29:32'),
(839,'product.{id}.name',280,'farsi','هاست ویندوز حرفه ای ایران - 5 گیگ','text','2022-08-19 11:00:05','2022-08-19 14:29:32'),
(840,'product.{id}.tagline',281,'farsi','','text','2022-08-19 11:01:24','2022-08-19 11:01:24'),
(841,'product.{id}.short_description',281,'farsi','مناسب PHP و وردپرس','textarea','2022-08-19 11:01:24','2022-08-19 11:01:24'),
(842,'product.{id}.description',281,'farsi','• فضای نامحدود\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 11:01:24','2022-08-19 14:29:48'),
(843,'product.{id}.name',281,'farsi','هاست ویندوز حرفه ای ایران - نامحدود','text','2022-08-19 11:01:24','2022-08-19 11:01:24'),
(844,'product.{id}.tagline',282,'farsi','','text','2022-08-19 11:05:45','2022-08-19 11:05:45'),
(845,'product.{id}.short_description',282,'farsi','','textarea','2022-08-19 11:05:45','2022-08-19 14:24:54'),
(846,'product.{id}.description',282,'farsi','• 100 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 11:05:45','2022-08-19 14:24:54'),
(847,'product.{id}.name',282,'farsi','هاست ویندوز حرفه ای خارج - 100 مگ','text','2022-08-19 11:05:45','2022-08-19 14:57:27'),
(848,'product.{id}.tagline',283,'farsi','','text','2022-08-19 11:15:40','2022-08-19 11:15:40'),
(849,'product.{id}.short_description',283,'farsi','','textarea','2022-08-19 11:15:40','2022-08-19 11:15:40'),
(850,'product.{id}.description',283,'farsi','• 500 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 11:15:40','2022-08-19 11:15:40'),
(851,'product.{id}.name',283,'farsi','هاست ویندوز حرفه ای خارج  - 500 مگ','text','2022-08-19 11:15:41','2022-08-19 14:57:25'),
(852,'product.{id}.tagline',284,'farsi','','text','2022-08-19 11:16:24','2022-08-19 11:16:24'),
(853,'product.{id}.short_description',284,'farsi','مناسب PHP و وردپرس','textarea','2022-08-19 11:16:24','2022-08-19 11:16:24'),
(854,'product.{id}.description',284,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 11:16:24','2022-08-19 14:25:43'),
(855,'product.{id}.name',284,'farsi','هاست ویندوز حرفه ای خارج - 1 گیگ','text','2022-08-19 11:16:24','2022-08-19 14:57:23'),
(856,'product.{id}.tagline',285,'farsi','','text','2022-08-19 11:17:19','2022-08-19 11:17:19'),
(857,'product.{id}.short_description',285,'farsi','مناسب PHP و وردپرس','textarea','2022-08-19 11:17:19','2022-08-19 11:17:19'),
(858,'product.{id}.description',285,'farsi','• 3 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 11:17:19','2022-08-19 14:26:07'),
(859,'product.{id}.name',285,'farsi','هاست ویندوز حرفه ای خارج - 3 گیگ','text','2022-08-19 11:17:19','2022-08-19 14:57:21'),
(860,'product.{id}.tagline',286,'farsi','','text','2022-08-19 11:18:11','2022-08-19 11:18:11'),
(861,'product.{id}.short_description',286,'farsi','مناسب PHP و وردپرس','textarea','2022-08-19 11:18:11','2022-08-19 11:18:11'),
(862,'product.{id}.description',286,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 11:18:11','2022-08-19 14:26:22'),
(863,'product.{id}.name',286,'farsi','هاست ویندوز حرفه ای خارج - 5 گیگ','text','2022-08-19 11:18:11','2022-08-19 14:57:19'),
(864,'product.{id}.tagline',287,'farsi','','text','2022-08-19 11:18:56','2022-08-19 11:18:56'),
(865,'product.{id}.short_description',287,'farsi','مناسب PHP و وردپرس','textarea','2022-08-19 11:18:56','2022-08-19 11:18:56'),
(866,'product.{id}.description',287,'farsi','• فضای نامحدود\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Plesk\r\n• بک آپ گیری 2 بار در هفته','textarea','2022-08-19 11:18:56','2022-08-19 14:26:36'),
(867,'product.{id}.name',287,'farsi','هاست ویندوز حرفه ای خارج - نامحدود','text','2022-08-19 11:18:56','2022-08-19 14:57:17'),
(868,'product.{id}.tagline',18,'farsi','','text','2022-08-19 11:21:15','2022-08-19 11:21:15'),
(869,'product.{id}.short_description',18,'farsi','','textarea','2022-08-19 11:21:15','2022-08-19 11:21:15'),
(870,'product.{id}.tagline',186,'farsi','','text','2022-08-19 11:21:31','2022-08-19 11:21:31'),
(871,'product.{id}.short_description',186,'farsi','','textarea','2022-08-19 11:21:31','2022-08-19 11:21:31'),
(872,'product.{id}.tagline',199,'farsi','','text','2022-08-19 11:21:56','2022-08-19 11:21:56'),
(873,'product.{id}.short_description',199,'farsi','','textarea','2022-08-19 11:21:56','2022-08-19 11:21:56'),
(874,'product.{id}.tagline',288,'farsi','','text','2022-08-19 11:23:50','2022-08-19 11:23:50'),
(875,'product.{id}.short_description',288,'farsi','','textarea','2022-08-19 11:23:50','2022-08-19 11:23:50'),
(876,'product.{id}.description',288,'farsi','• 100 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-19 11:23:50','2022-08-19 14:21:14'),
(877,'product.{id}.name',288,'farsi','هاست لینوکس حرفه ای خارج - 100 مگ','text','2022-08-19 11:23:50','2022-08-19 11:23:50'),
(878,'product.{id}.tagline',289,'farsi','','text','2022-08-19 11:27:11','2022-08-19 11:27:11'),
(879,'product.{id}.short_description',289,'farsi','','textarea','2022-08-19 11:27:11','2022-08-19 11:27:11'),
(880,'product.{id}.description',289,'farsi','• 500 مگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-19 11:27:11','2022-08-19 14:21:35'),
(881,'product.{id}.name',289,'farsi','هاست لینوکس حرفه ای خارج - 500 مگ','text','2022-08-19 11:27:11','2022-08-19 11:27:11'),
(882,'product.{id}.tagline',290,'farsi','','text','2022-08-19 11:27:51','2022-08-19 11:27:51'),
(883,'product.{id}.short_description',290,'farsi','','textarea','2022-08-19 11:27:51','2022-08-19 11:27:51'),
(884,'product.{id}.description',290,'farsi','• 1 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-19 11:27:51','2022-08-19 14:21:52'),
(885,'product.{id}.name',290,'farsi','هاست لینوکس حرفه ای خارج - 1 گیگ','text','2022-08-19 11:27:51','2022-08-19 14:23:19'),
(886,'product.{id}.tagline',291,'farsi','','text','2022-08-19 11:28:22','2022-08-19 11:28:22'),
(887,'product.{id}.short_description',291,'farsi','','textarea','2022-08-19 11:28:22','2022-08-19 11:28:22'),
(888,'product.{id}.description',291,'farsi','• 3 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-19 11:28:22','2022-08-19 14:22:07'),
(889,'product.{id}.name',291,'farsi','هاست لینوکس حرفه ای خارج - 3 گیگ','text','2022-08-19 11:28:22','2022-08-19 14:23:22'),
(890,'product.{id}.tagline',292,'farsi','','text','2022-08-19 11:28:58','2022-08-19 11:28:58'),
(891,'product.{id}.short_description',292,'farsi','','textarea','2022-08-19 11:28:58','2022-08-19 11:28:58'),
(892,'product.{id}.description',292,'farsi','• 5 گیگابایت فضای هاست\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-19 11:28:58','2022-08-19 14:22:20'),
(893,'product.{id}.name',292,'farsi','هاست لینوکس حرفه ای خارج - 5 گیگ','text','2022-08-19 11:28:58','2022-08-19 14:22:20'),
(894,'product.{id}.tagline',293,'farsi','','text','2022-08-19 11:29:33','2022-08-19 11:29:33'),
(895,'product.{id}.short_description',293,'farsi','','textarea','2022-08-19 11:29:33','2022-08-19 11:29:33'),
(896,'product.{id}.description',293,'farsi','• فضای نامحدود\r\n• ترافیک نامحدود\r\n• ترافیک نامحدود\r\n• گواهینامه SSL رایگان\r\n• کنترل پنل Cpanel\r\n• بک آپ گیری 2 بار در هفته\r\n• نصب رایگان وردپرس','textarea','2022-08-19 11:29:33','2022-08-19 14:22:30'),
(897,'product.{id}.name',293,'farsi','هاست لینوکس حرفه ای خارج - نامحدود','text','2022-08-19 11:29:33','2022-08-19 11:29:33'),
(898,'product.{id}.tagline',154,'farsi','','text','2022-08-19 11:50:57','2022-08-19 11:50:57'),
(899,'product.{id}.short_description',154,'farsi','','textarea','2022-08-19 11:50:57','2022-08-19 11:50:57'),
(900,'product.{id}.tagline',155,'farsi','','text','2022-08-19 11:53:49','2022-08-19 11:53:49'),
(901,'product.{id}.short_description',155,'farsi','','textarea','2022-08-19 11:53:49','2022-08-19 11:53:49'),
(902,'product.{id}.tagline',63,'farsi','','text','2022-08-19 11:55:14','2022-08-19 11:55:14'),
(903,'product.{id}.short_description',63,'farsi','','textarea','2022-08-19 11:55:14','2022-08-19 11:55:14'),
(904,'product.{id}.tagline',153,'farsi','','text','2022-08-19 12:44:36','2022-08-19 12:44:36'),
(905,'product.{id}.short_description',153,'farsi','','textarea','2022-08-19 12:44:36','2022-08-19 12:44:36'),
(906,'product.{id}.tagline',215,'farsi','','text','2022-08-19 12:48:26','2022-08-19 12:48:26'),
(907,'product.{id}.short_description',215,'farsi','','textarea','2022-08-19 12:48:26','2022-08-19 12:48:26'),
(908,'product.{id}.tagline',33,'farsi','','text','2022-08-19 14:07:49','2022-08-19 14:07:49'),
(909,'product.{id}.short_description',33,'farsi','','textarea','2022-08-19 14:07:49','2022-08-19 14:07:49'),
(910,'product.{id}.tagline',11,'farsi','','text','2022-08-19 14:09:24','2022-08-19 14:09:24'),
(911,'product.{id}.short_description',11,'farsi','','textarea','2022-08-19 14:09:24','2022-08-19 14:09:24'),
(912,'product.{id}.tagline',2,'farsi','','text','2022-08-19 14:10:46','2022-08-19 14:10:46'),
(913,'product.{id}.short_description',2,'farsi','','textarea','2022-08-19 14:10:46','2022-08-19 14:10:46'),
(914,'product.{id}.tagline',61,'farsi','','text','2022-08-19 15:05:35','2022-08-19 15:05:35'),
(915,'product.{id}.short_description',61,'farsi','','tex