<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme Saturnthemes Industry for publication on ThemeForest
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 *
 * Depending on your implementation, you may want to change the include call:
 *
 * Parent Theme:
 * require_once get_template_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Child Theme:
 * require_once get_stylesheet_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Plugin:
 * require_once dirname( __FILE__ ) . '/path/to/class-tgm-plugin-activation.php';
 */

add_action( 'tgmpa_register', 'personaltheme_register_theme_plugins' );

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variables passed to the `tgmpa()` function should be:
 * - an array of plugin arrays;
 * - optionally a configuration array.
 * If you are not changing anything in the configuration array, you can remove the array and remove the
 * variable from the function call: `tgmpa( $plugins );`.
 * In that case, the TGMPA default settings will be used.
 *
 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
 */
if ( ! function_exists( 'personaltheme_register_theme_plugins' ) ) :
    function personaltheme_register_theme_plugins() {
        /*
         * Array of plugin arrays. Required keys are name and slug.
         * If the source is NOT from the .org repo, then source is also required.
         */
        $plugins = array(
            array(
                'name'     => __( 'Contact Form 7'),
                'slug'     => 'contact-form-7',
                'required' => false,
            ),
            array(
                'name'     => __( 'polylang' ),
                'slug'     => 'polylang',
                'required' => true,
            ),
        );

        /*
         * Array of configuration settings. Amend each line as needed.
         *
         * TGMPA will start providing localized text strings soon. If you already have translations of our standard
         * strings available, please help us make TGMPA even better by giving us access to these translations or by
         * sending in a pull-request with .po file(s) with the translations.
         *
         * Only uncomment the strings in the config array if you want to customize the strings.
         */
        $config = array(
            'id'           => 'personaltheme', // Unique ID for hashing notices for multiple instances of TGMPA.
            'default_path' => '',                      // Default absolute path to bundled plugins.
            'menu'         => 'tgmpa-install-plugins', // Menu slug.
            'has_notices'  => true,                    // Show admin notices or not.
            'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
            'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
            'is_automatic' => true,                   // Automatically activate plugins after installation or not.
            'message'      => '',                      // Message to output right before the plugins table.
            'strings'      => array(
                    'page_title'                      => esc_html__( 'افزونه های ضروری را نصب نمایید', 'saturnthemes-industry' ),
                    'menu_title'                      => esc_html__( 'نصب افزونه ها' ),
                    'installing'                      => esc_html__( 'در حال نصب افزونه ها: %s' ),
                    // %s = plugin name.
                    'oops'                            => esc_html__( 'چیزی اشتباه است.'),
                    'notice_can_install_required'     => _n_noop( 'این قالب نیازمند نصب افزونه های مربوطه می باشد: %1$s.', 'این قالب نیازمند نصب این افزونه ها می باشد: %1$s.' ),
                    // %1$s = plugin name(s).
                    'notice_can_install_recommended'  => _n_noop( 'این قالب نصب این افزونه را پیشنهاد میدهد: %1$s.', 'این قالب نصب این افزونه ها رو پیشنهاد میدهد: %1$s.' ),
                    // %1$s = plugin name(s).
                    'notice_cannot_install'           => _n_noop( 'متأسفیم، اما شما مجوزهای صحیحی برای نصب افزونه %1$s ندارید.', 'متأسفیم، اما شما مجوزهای صحیحی برای نصب افزونه های %1$s ندارید.' ),
                    // %1$s = plugin name(s).
                    'notice_ask_to_update'            => _n_noop( 'افزونه زیر برای اطمینان از حداکثر سازگاری با این موضوع باید به آخرین نسخه خود به روز شود: %1$s.', 'افزونه های زیر باید به آخرین نسخه خود به روز شوند تا از حداکثر سازگاری با این موضوع اطمینان حاصل شود: %1$s.' ),
                    // %1$s = plugin name(s).
                    'notice_ask_to_update_maybe'      => _n_noop( 'یک به روز رسانی برای آن موجود است: %1$s.', 'به روز رسانی هایی برای پلاگین های زیر موجود است: %1$s.' ),
                    // %1$s = plugin name(s).
                    'notice_cannot_update'            => _n_noop( 'متأسفیم، اما شما مجوزهای صحیحی برای به روز رسانی افزونه %1$s ندارید.', 'متأسفیم، اما شما مجوزهای صحیحی برای به‌روزرسانی افزونه‌های %1$s ندارید.' ),
                    // %1$s = plugin name(s).
                    'notice_can_activate_required'    => _n_noop( 'افزونه مورد نیاز زیر در حال حاضر غیر فعال است: %1$s.', 'افزونه های مورد نیاز زیر در حال حاضر غیر فعال هستند: %1$s.' ),
                    // %1$s = plugin name(s).
                    'notice_can_activate_recommended' => _n_noop( 'افزونه پیشنهادی زیر در حال حاضر غیر فعال است: %1$s.', 'افزونه های پیشنهادی زیر در حال حاضر غیر فعال هستند: %1$s.' ),
                    // %1$s = plugin name(s).
                    'notice_cannot_activate'          => _n_noop( 'متأسفیم، اما شما مجوزهای صحیحی برای فعال کردن افزونه %1$s ندارید.', 'متأسفیم، اما شما مجوزهای صحیحی برای فعال کردن افزونه های %1$s ندارید.' ),
                    // %1$s = plugin name(s).
                    'install_link'                    => _n_noop( 'نصب افزونه را شروع کنید', 'نصب پلاگین ها را شروع کنید', 'saturnthemes-industry' ),
                    'update_link'                     => _n_noop( 'شروع به روز رسانی افزونه', 'به روز رسانی پلاگین ها را شروع کنید', 'saturnthemes-industry' ),
                    'activate_link'                   => _n_noop( 'شروع به فعال سازی افزونه کنید', 'شروع به فعال سازی پلاگین ها کنید', 'saturnthemes-industry' ),
                    'return'                          => esc_html__( 'بازگشت برای نصب پلاگین مورد نیاز', 'saturnthemes-industry' ),
                    'plugin_activated'                => esc_html__( 'افزونه با موفقیت فعال شد.', 'saturnthemes-industry' ),
                    'activated_successfully'          => esc_html__( 'افزونه زیر با موفقیت فعال شد:', 'saturnthemes-industry' ),
                    'plugin_already_active'           => esc_html__( 'اقدامی صورت نگرفت. افزونه %1$s قبلاً فعال بود.', 'saturnthemes-industry' ),
                    // %1$s = plugin name(s).
                    'plugin_needs_higher_version'     => esc_html__( 'افزونه فعال نشد یک نسخه بالاتر از %s برای این موضوع مورد نیاز است. لطفا افزونه را به روز کنید.' ),
                    // %1$s = plugin name(s).
                    'complete'                        => esc_html__( 'همه افزونه ها با موفقیت نصب و فعال شدند. %1$s', 'saturnthemes-industry' ),
                    // %s = dashboard link.
                    'contact_admin'                   => esc_html__( 'لطفا برای راهنمایی با مدیر این سایت تماس بگیرید.', 'saturnthemes-industry' ),
                    'nag_type'                        => 'updated',
                    // Determines admin notice type - can only be 'updated', 'update-nag' or 'error'.
                )
        );

        tgmpa( $plugins, $config );
    }
endif;
